--TEST--
Test tempnam() function: usage variations - permissions(0000 to 0777) of dir
--SKIPIF--
<?php
if (substr(PHP_OS, 0, 3) == 'WIN') {
    die('skip Not valid for Windows');
}
?>
--FILE--
<?php
/* Prototype:  string tempnam ( string $dir, string $prefix );
   Description: Create file with unique file name.
*/

/* Trying to create the file in a dir with permissions from 0000 to 0777,
     Allowable permissions: files are expected to be created in the input dir 
     Non-allowable permissions: files are expected to be created in '/tmp' dir
*/

echo "*** Testing tempnam() with dir of permissions from 0000 to 0777 ***\n";
$file_path = dirname(__FILE__);
$dir_name = $file_path."/tempnam_variation4";
$prefix = "tempnamVar4.";

mkdir($dir_name);

for($mode = 0000; $mode <= 0777; $mode++) {
  echo "-- dir perms ";
  printf("%o", $mode);
  echo " --\n";
  chmod($dir_name, $mode);
  $file_name = tempnam($dir_name, $prefix);

  if(file_exists($file_name) ) {
    if (realpath(dirname($file_name)) == realpath(sys_get_temp_dir())) {
       $msg = " created in temp directory";
    }
    else if (dirname($file_name) == $dir_name) {
       $msg = " created in requested directory";
    }
    else {
       $msg = " created in unexpected directory";
    }   
  
    echo basename($file_name).$msg."\n";
    unlink($file_name);    
  }
  else {
    print("FAILED: File is not created\n");
  }
}

rmdir($dir_name);

echo "*** Done ***\n";
?>
--EXPECTF--
*** Testing tempnam() with dir of permissions from 0000 to 0777 ***
-- dir perms 0 --
tempnamVar4.%s created in temp directory
-- dir perms 1 --
tempnamVar4.%s created in temp directory
-- dir perms 2 --
tempnamVar4.%s created in temp directory
-- dir perms 3 --
tempnamVar4.%s created in temp directory
-- dir perms 4 --
tempnamVar4.%s created in temp directory
-- dir perms 5 --
tempnamVar4.%s created in temp directory
-- dir perms 6 --
tempnamVar4.%s created in temp directory
-- dir perms 7 --
tempnamVar4.%s created in temp directory
-- dir perms 10 --
tempnamVar4.%s created in temp directory
-- dir perms 11 --
tempnamVar4.%s created in temp directory
-- dir perms 12 --
tempnamVar4.%s created in temp directory
-- dir perms 13 --
tempnamVar4.%s created in temp directory
-- dir perms 14 --
tempnamVar4.%s created in temp directory
-- dir perms 15 --
tempnamVar4.%s created in temp directory
-- dir perms 16 --
tempnamVar4.%s created in temp directory
-- dir perms 17 --
tempnamVar4.%s created in temp directory
-- dir perms 20 --
tempnamVar4.%s created in temp directory
-- dir perms 21 --
tempnamVar4.%s created in temp directory
-- dir perms 22 --
tempnamVar4.%s created in temp directory
-- dir perms 23 --
tempnamVar4.%s created in temp directory
-- dir perms 24 --
tempnamVar4.%s created in temp directory
-- dir perms 25 --
tempnamVar4.%s created in temp directory
-- dir perms 26 --
tempnamVar4.%s created in temp directory
-- dir perms 27 --
tempnamVar4.%s created in temp directory
-- dir perms 30 --
tempnamVar4.%s created in temp directory
-- dir perms 31 --
tempnamVar4.%s created in temp directory
-- dir perms 32 --
tempnamVar4.%s created in temp directory
-- dir perms 33 --
tempnamVar4.%s created in temp directory
-- dir perms 34 --
tempnamVar4.%s created in temp directory
-- dir perms 35 --
tempnamVar4.%s created in temp directory
-- dir perms 36 --
tempnamVar4.%s created in temp directory
-- dir perms 37 --
tempnamVar4.%s created in temp directory
-- dir perms 40 --
tempnamVar4.%s created in temp directory
-- dir perms 41 --
tempnamVar4.%s created in temp directory
-- dir perms 42 --
tempnamVar4.%s created in temp directory
-- dir perms 43 --
tempnamVar4.%s created in temp directory
-- dir perms 44 --
tempnamVar4.%s created in temp directory
-- dir perms 45 --
tempnamVar4.%s created in temp directory
-- dir perms 46 --
tempnamVar4.%s created in temp directory
-- dir perms 47 --
tempnamVar4.%s created in temp directory
-- dir perms 50 --
tempnamVar4.%s created in temp directory
-- dir perms 51 --
tempnamVar4.%s created in temp directory
-- dir perms 52 --
tempnamVar4.%s created in temp directory
-- dir perms 53 --
tempnamVar4.%s created in temp directory
-- dir perms 54 --
tempnamVar4.%s created in temp directory
-- dir perms 55 --
tempnamVar4.%s created in temp directory
-- dir perms 56 --
tempnamVar4.%s created in temp directory
-- dir perms 57 --
tempnamVar4.%s created in temp directory
-- dir perms 60 --
tempnamVar4.%s created in temp directory
-- dir perms 61 --
tempnamVar4.%s created in temp directory
-- dir perms 62 --
tempnamVar4.%s created in temp directory
-- dir perms 63 --
tempnamVar4.%s created in temp directory
-- dir perms 64 --
tempnamVar4.%s created in temp directory
-- dir perms 65 --
tempnamVar4.%s created in temp directory
-- dir perms 66 --
tempnamVar4.%s created in temp directory
-- dir perms 67 --
tempnamVar4.%s created in temp directory
-- dir perms 70 --
tempnamVar4.%s created in temp directory
-- dir perms 71 --
tempnamVar4.%s created in temp directory
-- dir perms 72 --
tempnamVar4.%s created in temp directory
-- dir perms 73 --
tempnamVar4.%s created in temp directory
-- dir perms 74 --
tempnamVar4.%s created in temp directory
-- dir perms 75 --
tempnamVar4.%s created in temp directory
-- dir perms 76 --
tempnamVar4.%s created in temp directory
-- dir perms 77 --
tempnamVar4.%s created in temp directory
-- dir perms 100 --
tempnamVar4.%s created in temp directory
-- dir perms 101 --
tempnamVar4.%s created in temp directory
-- dir perms 102 --
tempnamVar4.%s created in temp directory
-- dir perms 103 --
tempnamVar4.%s created in temp directory
-- dir perms 104 --
tempnamVar4.%s created in temp directory
-- dir perms 105 --
tempnamVar4.%s created in temp directory
-- dir perms 106 --
tempnamVar4.%s created in temp directory
-- dir perms 107 --
tempnamVar4.%s created in temp directory
-- dir perms 110 --
tempnamVar4.%s created in temp directory
-- dir perms 111 --
tempnamVar4.%s created in temp directory
-- dir perms 112 --
tempnamVar4.%s created in temp directory
-- dir perms 113 --
tempnamVar4.%s created in temp directory
-- dir perms 114 --
tempnamVar4.%s created in temp directory
-- dir perms 115 --
tempnamVar4.%s created in temp directory
-- dir perms 116 --
tempnamVar4.%s created in temp directory
-- dir perms 117 --
tempnamVar4.%s created in temp directory
-- dir perms 120 --
tempnamVar4.%s created in temp directory
-- dir perms 121 --
tempnamVar4.%s created in temp directory
-- dir perms 122 --
tempnamVar4.%s created in temp directory
-- dir perms 123 --
tempnamVar4.%s created in temp directory
-- dir perms 124 --
tempnamVar4.%s created in temp directory
-- dir perms 125 --
tempnamVar4.%s created in temp directory
-- dir perms 126 --
tempnamVar4.%s created in temp directory
-- dir perms 127 --
tempnamVar4.%s created in temp directory
-- dir perms 130 --
tempnamVar4.%s created in temp directory
-- dir perms 131 --
tempnamVar4.%s created in temp directory
-- dir perms 132 --
tempnamVar4.%s created in temp directory
-- dir perms 133 --
tempnamVar4.%s created in temp directory
-- dir perms 134 --
tempnamVar4.%s created in temp directory
-- dir perms 135 --
tempnamVar4.%s created in temp directory
-- dir perms 136 --
tempnamVar4.%s created in temp directory
-- dir perms 137 --
tempnamVar4.%s created in temp directory
-- dir perms 140 --
tempnamVar4.%s created in temp directory
-- dir perms 141 --
tempnamVar4.%s created in temp directory
-- dir perms 142 --
tempnamVar4.%s created in temp directory
-- dir perms 143 --
tempnamVar4.%s created in temp directory
-- dir perms 144 --
tempnamVar4.%s created in temp directory
-- dir perms 145 --
tempnamVar4.%s created in temp directory
-- dir perms 146 --
tempnamVar4.%s created in temp directory
-- dir perms 147 --
tempnamVar4.%s created in temp directory
-- dir perms 150 --
tempnamVar4.%s created in temp directory
-- dir perms 151 --
tempnamVar4.%s created in temp directory
-- dir perms 152 --
tempnamVar4.%s created in temp directory
-- dir perms 153 --
tempnamVar4.%s created in temp directory
-- dir perms 154 --
tempnamVar4.%s created in temp directory
-- dir perms 155 --
tempnamVar4.%s created in temp directory
-- dir perms 156 --
tempnamVar4.%s created in temp directory
-- dir perms 157 --
tempnamVar4.%s created in temp directory
-- dir perms 160 --
tempnamVar4.%s created in temp directory
-- dir perms 161 --
tempnamVar4.%s created in temp directory
-- dir perms 162 --
tempnamVar4.%s created in temp directory
-- dir perms 163 --
tempnamVar4.%s created in temp directory
-- dir perms 164 --
tempnamVar4.%s created in temp directory
-- dir perms 165 --
tempnamVar4.%s created in temp directory
-- dir perms 166 --
tempnamVar4.%s created in temp directory
-- dir perms 167 --
tempnamVar4.%s created in temp directory
-- dir perms 170 --
tempnamVar4.%s created in temp directory
-- dir perms 171 --
tempnamVar4.%s created in temp directory
-- dir perms 172 --
tempnamVar4.%s created in temp directory
-- dir perms 173 --
tempnamVar4.%s created in temp directory
-- dir perms 174 --
tempnamVar4.%s created in temp directory
-- dir perms 175 --
tempnamVar4.%s created in temp directory
-- dir perms 176 --
tempnamVar4.%s created in temp directory
-- dir perms 177 --
tempnamVar4.%s created in temp directory
-- dir perms 200 --
tempnamVar4.%s created in temp directory
-- dir perms 201 --
tempnamVar4.%s created in temp directory
-- dir perms 202 --
tempnamVar4.%s created in temp directory
-- dir perms 203 --
tempnamVar4.%s created in temp directory
-- dir perms 204 --
tempnamVar4.%s created in temp directory
-- dir perms 205 --
tempnamVar4.%s created in temp directory
-- dir perms 206 --
tempnamVar4.%s created in temp directory
-- dir perms 207 --
tempnamVar4.%s created in temp directory
-- dir perms 210 --
tempnamVar4.%s created in temp directory
-- dir perms 211 --
tempnamVar4.%s created in temp directory
-- dir perms 212 --
tempnamVar4.%s created in temp directory
-- dir perms 213 --
tempnamVar4.%s created in temp directory
-- dir perms 214 --
tempnamVar4.%s created in temp directory
-- dir perms 215 --
tempnamVar4.%s created in temp directory
-- dir perms 216 --
tempnamVar4.%s created in temp directory
-- dir perms 217 --
tempnamVar4.%s created in temp directory
-- dir perms 220 --
tempnamVar4.%s created in temp directory
-- dir perms 221 --
tempnamVar4.%s created in temp directory
-- dir perms 222 --
tempnamVar4.%s created in temp directory
-- dir perms 223 --
tempnamVar4.%s created in temp directory
-- dir perms 224 --
tempnamVar4.%s created in temp directory
-- dir perms 225 --
tempnamVar4.%s created in temp directory
-- dir perms 226 --
tempnamVar4.%s created in temp directory
-- dir perms 227 --
tempnamVar4.%s created in temp directory
-- dir perms 230 --
tempnamVar4.%s created in temp directory
-- dir perms 231 --
tempnamVar4.%s created in temp directory
-- dir perms 232 --
tempnamVar4.%s created in temp directory
-- dir perms 233 --
tempnamVar4.%s created in temp directory
-- dir perms 234 --
tempnamVar4.%s created in temp directory
-- dir perms 235 --
tempnamVar4.%s created in temp directory
-- dir perms 236 --
tempnamVar4.%s created in temp directory
-- dir perms 237 --
tempnamVar4.%s created in temp directory
-- dir perms 240 --
tempnamVar4.%s created in temp directory
-- dir perms 241 --
tempnamVar4.%s created in temp directory
-- dir perms 242 --
tempnamVar4.%s created in temp directory
-- dir perms 243 --
tempnamVar4.%s created in temp directory
-- dir perms 244 --
tempnamVar4.%s created in temp directory
-- dir perms 245 --
tempnamVar4.%s created in temp directory
-- dir perms 246 --
tempnamVar4.%s created in temp directory
-- dir perms 247 --
tempnamVar4.%s created in temp directory
-- dir perms 250 --
tempnamVar4.%s created in temp directory
-- dir perms 251 --
tempnamVar4.%s created in temp directory
-- dir perms 252 --
tempnamVar4.%s created in temp directory
-- dir perms 253 --
tempnamVar4.%s created in temp directory
-- dir perms 254 --
tempnamVar4.%s created in temp directory
-- dir perms 255 --
tempnamVar4.%s created in temp directory
-- dir perms 256 --
tempnamVar4.%s created in temp directory
-- dir perms 257 --
tempnamVar4.%s created in temp directory
-- dir perms 260 --
tempnamVar4.%s created in temp directory
-- dir perms 261 --
tempnamVar4.%s created in temp directory
-- dir perms 262 --
tempnamVar4.%s created in temp directory
-- dir perms 263 --
tempnamVar4.%s created in temp directory
-- dir perms 264 --
tempnamVar4.%s created in temp directory
-- dir perms 265 --
tempnamVar4.%s created in temp directory
-- dir perms 266 --
tempnamVar4.%s created in temp directory
-- dir perms 267 --
tempnamVar4.%s created in temp directory
-- dir perms 270 --
tempnamVar4.%s created in temp directory
-- dir perms 271 --
tempnamVar4.%s created in temp directory
-- dir perms 272 --
tempnamVar4.%s created in temp directory
-- dir perms 273 --
tempnamVar4.%s created in temp directory
-- dir perms 274 --
tempnamVar4.%s created in temp directory
-- dir perms 275 --
tempnamVar4.%s created in temp directory
-- dir perms 276 --
tempnamVar4.%s created in temp directory
-- dir perms 277 --
tempnamVar4.%s created in temp directory
-- dir perms 300 --
tempnamVar4.%s created in requested directory
-- dir perms 301 --
tempnamVar4.%s created in requested directory
-- dir perms 302 --
tempnamVar4.%s created in requested directory
-- dir perms 303 --
tempnamVar4.%s created in requested directory
-- dir perms 304 --
tempnamVar4.%s created in requested directory
-- dir perms 305 --
tempnamVar4.%s created in requested directory
-- dir perms 306 --
tempnamVar4.%s created in requested directory
-- dir perms 307 --
tempnamVar4.%s created in requested directory
-- dir perms 310 --
tempnamVar4.%s created in requested directory
-- dir perms 311 --
tempnamVar4.%s created in requested directory
-- dir perms 312 --
tempnamVar4.%s created in requested directory
-- dir perms 313 --
tempnamVar4.%s created in requested directory
-- dir perms 314 --
tempnamVar4.%s created in requested directory
-- dir perms 315 --
tempnamVar4.%s created in requested directory
-- dir perms 316 --
tempnamVar4.%s created in requested directory
-- dir perms 317 --
tempnamVar4.%s created in requested directory
-- dir perms 320 --
tempnamVar4.%s created in requested directory
-- dir perms 321 --
tempnamVar4.%s created in requested directory
-- dir perms 322 --
tempnamVar4.%s created in requested directory
-- dir perms 323 --
tempnamVar4.%s created in requested directory
-- dir perms 324 --
tempnamVar4.%s created in requested directory
-- dir perms 325 --
tempnamVar4.%s created in requested directory
-- dir perms 326 --
tempnamVar4.%s created in requested directory
-- dir perms 327 --
tempnamVar4.%s created in requested directory
-- dir perms 330 --
tempnamVar4.%s created in requested directory
-- dir perms 331 --
tempnamVar4.%s created in requested directory
-- dir perms 332 --
tempnamVar4.%s created in requested directory
-- dir perms 333 --
tempnamVar4.%s created in requested directory
-- dir perms 334 --
tempnamVar4.%s created in requested directory
-- dir perms 335 --
tempnamVar4.%s created in requested directory
-- dir perms 336 --
tempnamVar4.%s created in requested directory
-- dir perms 337 --
tempnamVar4.%s created in requested directory
-- dir perms 340 --
tempnamVar4.%s created in requested directory
-- dir perms 341 --
tempnamVar4.%s created in requested directory
-- dir perms 342 --
tempnamVar4.%s created in requested directory
-- dir perms 343 --
tempnamVar4.%s created in requested directory
-- dir perms 344 --
tempnamVar4.%s created in requested directory
-- dir perms 345 --
tempnamVar4.%s created in requested directory
-- dir perms 346 --
tempnamVar4.%s created in requested directory
-- dir perms 347 --
tempnamVar4.%s created in requested directory
-- dir perms 350 --
tempnamVar4.%s created in requested directory
-- dir perms 351 --
tempnamVar4.%s created in requested directory
-- dir perms 352 --
tempnamVar4.%s created in requested directory
-- dir perms 353 --
tempnamVar4.%s created in requested directory
-- dir perms 354 --
tempnamVar4.%s created in requested directory
-- dir perms 355 --
tempnamVar4.%s created in requested directory
-- dir perms 356 --
tempnamVar4.%s created in requested directory
-- dir perms 357 --
tempnamVar4.%s created in requested directory
-- dir perms 360 --
tempnamVar4.%s created in requested directory
-- dir perms 361 --
tempnamVar4.%s created in requested directory
-- dir perms 362 --
tempnamVar4.%s created in requested directory
-- dir perms 363 --
tempnamVar4.%s created in requested directory
-- dir perms 364 --
tempnamVar4.%s created in requested directory
-- dir perms 365 --
tempnamVar4.%s created in requested directory
-- dir perms 366 --
tempnamVar4.%s created in requested directory
-- dir perms 367 --
tempnamVar4.%s created in requested directory
-- dir perms 370 --
tempnamVar4.%s created in requested directory
-- dir perms 371 --
tempnamVar4.%s created in requested directory
-- dir perms 372 --
tempnamVar4.%s created in requested directory
-- dir perms 373 --
tempnamVar4.%s created in requested directory
-- dir perms 374 --
tempnamVar4.%s created in requested directory
-- dir perms 375 --
tempnamVar4.%s created in requested directory
-- dir perms 376 --
tempnamVar4.%s created in requested directory
-- dir perms 377 --
tempnamVar4.%s created in requested directory
-- dir perms 400 --
tempnamVar4.%s created in temp directory
-- dir perms 401 --
tempnamVar4.%s created in temp directory
-- dir perms 402 --
tempnamVar4.%s created in temp directory
-- dir perms 403 --
tempnamVar4.%s created in temp directory
-- dir perms 404 --
tempnamVar4.%s created in temp directory
-- dir perms 405 --
tempnamVar4.%s created in temp directory
-- dir perms 406 --
tempnamVar4.%s created in temp directory
-- dir perms 407 --
tempnamVar4.%s created in temp directory
-- dir perms 410 --
tempnamVar4.%s created in temp directory
-- dir perms 411 --
tempnamVar4.%s created in temp directory
-- dir perms 412 --
tempnamVar4.%s created in temp directory
-- dir perms 413 --
tempnamVar4.%s created in temp directory
-- dir perms 414 --
tempnamVar4.%s created in temp directory
-- dir perms 415 --
tempnamVar4.%s created in temp directory
-- dir perms 416 --
tempnamVar4.%s created in temp directory
-- dir perms 417 --
tempnamVar4.%s created in temp directory
-- dir perms 420 --
tempnamVar4.%s created in temp directory
-- dir perms 421 --
tempnamVar4.%s created in temp directory
-- dir perms 422 --
tempnamVar4.%s created in temp directory
-- dir perms 423 --
tempnamVar4.%s created in temp directory
-- dir perms 424 --
tempnamVar4.%s created in temp directory
-- dir perms 425 --
tempnamVar4.%s created in temp directory
-- dir perms 426 --
tempnamVar4.%s created in temp directory
-- dir perms 427 --
tempnamVar4.%s created in temp directory
-- dir perms 430 --
tempnamVar4.%s created in temp directory
-- dir perms 431 --
tempnamVar4.%s created in temp directory
-- dir perms 432 --
tempnamVar4.%s created in temp directory
-- dir perms 433 --
tempnamVar4.%s created in temp directory
-- dir perms 434 --
tempnamVar4.%s created in temp directory
-- dir perms 435 --
tempnamVar4.%s created in temp directory
-- dir perms 436 --
tempnamVar4.%s created in temp directory
-- dir perms 437 --
tempnamVar4.%s created in temp directory
-- dir perms 440 --
tempnamVar4.%s created in temp directory
-- dir perms 441 --
tempnamVar4.%s created in temp directory
-- dir perms 442 --
tempnamVar4.%s created in temp directory
-- dir perms 443 --
tempnamVar4.%s created in temp directory
-- dir perms 444 --
tempnamVar4.%s created in temp directory
-- dir perms 445 --
tempnamVar4.%s created in temp directory
-- dir perms 446 --
tempnamVar4.%s created in temp directory
-- dir perms 447 --
tempnamVar4.%s created in temp directory
-- dir perms 450 --
tempnamVar4.%s created in temp directory
-- dir perms 451 --
tempnamVar4.%s created in temp directory
-- dir perms 452 --
tempnamVar4.%s created in temp directory
-- dir perms 453 --
tempnamVar4.%s created in temp directory
-- dir perms 454 --
tempnamVar4.%s created in temp directory
-- dir perms 455 --
tempnamVar4.%s created in temp directory
-- dir perms 456 --
tempnamVar4.%s created in temp directory
-- dir perms 457 --
tempnamVar4.%s created in temp directory
-- dir perms 460 --
tempnamVar4.%s created in temp directory
-- dir perms 461 --
tempnamVar4.%s created in temp directory
-- dir perms 462 --
tempnamVar4.%s created in temp directory
-- dir perms 463 --
tempnamVar4.%s created in temp directory
-- dir perms 464 --
tempnamVar4.%s created in temp directory
-- dir perms 465 --
tempnamVar4.%s created in temp directory
-- dir perms 466 --
tempnamVar4.%s created in temp directory
-- dir perms 467 --
tempnamVar4.%s created in temp directory
-- dir perms 470 --
tempnamVar4.%s created in temp directory
-- dir perms 471 --
tempnamVar4.%s created in temp directory
-- dir perms 472 --
tempnamVar4.%s created in temp directory
-- dir perms 473 --
tempnamVar4.%s created in temp directory
-- dir perms 474 --
tempnamVar4.%s created in temp directory
-- dir perms 475 --
tempnamVar4.%s created in temp directory
-- dir perms 476 --
tempnamVar4.%s created in temp directory
-- dir perms 477 --
tempnamVar4.%s created in temp directory
-- dir perms 500 --
tempnamVar4.%s created in temp directory
-- dir perms 501 --
tempnamVar4.%s created in temp directory
-- dir perms 502 --
tempnamVar4.%s created in temp directory
-- dir perms 503 --
tempnamVar4.%s created in temp directory
-- dir perms 504 --
tempnamVar4.%s created in temp directory
-- dir perms 505 --
tempnamVar4.%s created in temp directory
-- dir perms 506 --
tempnamVar4.%s created in temp directory
-- dir perms 507 --
tempnamVar4.%s created in temp directory
-- dir perms 510 --
tempnamVar4.%s created in temp directory
-- dir perms 511 --
tempnamVar4.%s created in temp directory
-- dir perms 512 --
tempnamVar4.%s created in temp directory
-- dir perms 513 --
tempnamVar4.%s created in temp directory
-- dir perms 514 --
tempnamVar4.%s created in temp directory
-- dir perms 515 --
tempnamVar4.%s created in temp directory
-- dir perms 516 --
tempnamVar4.%s created in temp directory
-- dir perms 517 --
tempnamVar4.%s created in temp directory
-- dir perms 520 --
tempnamVar4.%s created in temp directory
-- dir perms 521 --
tempnamVar4.%s created in temp directory
-- dir perms 522 --
tempnamVar4.%s created in temp directory
-- dir perms 523 --
tempnamVar4.%s created in temp directory
-- dir perms 524 --
tempnamVar4.%s created in temp directory
-- dir perms 525 --
tempnamVar4.%s created in temp directory
-- dir perms 526 --
tempnamVar4.%s created in temp directory
-- dir perms 527 --
tempnamVar4.%s created in temp directory
-- dir perms 530 --
tempnamVar4.%s created in temp directory
-- dir perms 531 --
tempnamVar4.%s created in temp directory
-- dir perms 532 --
tempnamVar4.%s created in temp directory
-- dir perms 533 --
tempnamVar4.%s created in temp directory
-- dir perms 534 --
tempnamVar4.%s created in temp directory
-- dir perms 535 --
tempnamVar4.%s created in temp directory
-- dir perms 536 --
tempnamVar4.%s created in temp directory
-- dir perms 537 --
tempnamVar4.%s created in temp directory
-- dir perms 540 --
tempnamVar4.%s created in temp directory
-- dir perms 541 --
tempnamVar4.%s created in temp directory
-- dir perms 542 --
tempnamVar4.%s created in temp directory
-- dir perms 543 --
tempnamVar4.%s created in temp directory
-- dir perms 544 --
tempnamVar4.%s created in temp directory
-- dir perms 545 --
tempnamVar4.%s created in temp directory
-- dir perms 546 --
tempnamVar4.%s created in temp directory
-- dir perms 547 --
tempnamVar4.%s created in temp directory
-- dir perms 550 --
tempnamVar4.%s created in temp directory
-- dir perms 551 --
tempnamVar4.%s created in temp directory
-- dir perms 552 --
tempnamVar4.%s created in temp directory
-- dir perms 553 --
tempnamVar4.%s created in temp directory
-- dir perms 554 --
tempnamVar4.%s created in temp directory
-- dir perms 555 --
tempnamVar4.%s created in temp directory
-- dir perms 556 --
tempnamVar4.%s created in temp directory
-- dir perms 557 --
tempnamVar4.%s created in temp directory
-- dir perms 560 --
tempnamVar4.%s created in temp directory
-- dir perms 561 --
tempnamVar4.%s created in temp directory
-- dir perms 562 --
tempnamVar4.%s created in temp directory
-- dir perms 563 --
tempnamVar4.%s created in temp directory
-- dir perms 564 --
tempnamVar4.%s created in temp directory
-- dir perms 565 --
tempnamVar4.%s created in temp directory
-- dir perms 566 --
tempnamVar4.%s created in temp directory
-- dir perms 567 --
tempnamVar4.%s created in temp directory
-- dir perms 570 --
tempnamVar4.%s created in temp directory
-- dir perms 571 --
tempnamVar4.%s created in temp directory
-- dir perms 572 --
tempnamVar4.%s created in temp directory
-- dir perms 573 --
tempnamVar4.%s created in temp directory
-- dir perms 574 --
tempnamVar4.%s created in temp directory
-- dir perms 575 --
tempnamVar4.%s created in temp directory
-- dir perms 576 --
tempnamVar4.%s created in temp directory
-- dir perms 577 --
tempnamVar4.%s created in temp directory
-- dir perms 600 --
tempnamVar4.%s created in temp directory
-- dir perms 601 --
tempnamVar4.%s created in temp directory
-- dir perms 602 --
tempnamVar4.%s created in temp directory
-- dir perms 603 --
tempnamVar4.%s created in temp directory
-- dir perms 604 --
tempnamVar4.%s created in temp directory
-- dir perms 605 --
tempnamVar4.%s created in temp directory
-- dir perms 606 --
tempnamVar4.%s created in temp directory
-- dir perms 607 --
tempnamVar4.%s created in temp directory
-- dir perms 610 --
tempnamVar4.%s created in temp directory
-- dir perms 611 --
tempnamVar4.%s created in temp directory
-- dir perms 612 --
tempnamVar4.%s created in temp directory
-- dir perms 613 --
tempnamVar4.%s created in temp directory
-- dir perms 614 --
tempnamVar4.%s created in temp directory
-- dir perms 615 --
tempnamVar4.%s created in temp directory
-- dir perms 616 --
tempnamVar4.%s created in temp directory
-- dir perms 617 --
tempnamVar4.%s created in temp directory
-- dir perms 620 --
tempnamVar4.%s created in temp directory
-- dir perms 621 --
tempnamVar4.%s created in temp directory
-- dir perms 622 --
tempnamVar4.%s created in temp directory
-- dir perms 623 --
tempnamVar4.%s created in temp directory
-- dir perms 624 --
tempnamVar4.%s created in temp directory
-- dir perms 625 --
tempnamVar4.%s created in temp directory
-- dir perms 626 --
tempnamVar4.%s created in temp directory
-- dir perms 627 --
tempnamVar4.%s created in temp directory
-- dir perms 630 --
tempnamVar4.%s created in temp directory
-- dir perms 631 --
tempnamVar4.%s created in temp directory
-- dir perms 632 --
tempnamVar4.%s created in temp directory
-- dir perms 633 --
tempnamVar4.%s created in temp directory
-- dir perms 634 --
tempnamVar4.%s created in temp directory
-- dir perms 635 --
tempnamVar4.%s created in temp directory
-- dir perms 636 --
tempnamVar4.%s created in temp directory
-- dir perms 637 --
tempnamVar4.%s created in temp directory
-- dir perms 640 --
tempnamVar4.%s created in temp directory
-- dir perms 641 --
tempnamVar4.%s created in temp directory
-- dir perms 642 --
tempnamVar4.%s created in temp directory
-- dir perms 643 --
tempnamVar4.%s created in temp directory
-- dir perms 644 --
tempnamVar4.%s created in temp directory
-- dir perms 645 --
tempnamVar4.%s created in temp directory
-- dir perms 646 --
tempnamVar4.%s created in temp directory
-- dir perms 647 --
tempnamVar4.%s created in temp directory
-- dir perms 650 --
tempnamVar4.%s created in temp directory
-- dir perms 651 --
tempnamVar4.%s created in temp directory
-- dir perms 652 --
tempnamVar4.%s created in temp directory
-- dir perms 653 --
tempnamVar4.%s created in temp directory
-- dir perms 654 --
tempnamVar4.%s created in temp directory
-- dir perms 655 --
tempnamVar4.%s created in temp directory
-- dir perms 656 --
tempnamVar4.%s created in temp directory
-- dir perms 657 --
tempnamVar4.%s created in temp directory
-- dir perms 660 --
tempnamVar4.%s created in temp directory
-- dir perms 661 --
tempnamVar4.%s created in temp directory
-- dir perms 662 --
tempnamVar4.%s created in temp directory
-- dir perms 663 --
tempnamVar4.%s created in temp directory
-- dir perms 664 --
tempnamVar4.%s created in temp directory
-- dir perms 665 --
tempnamVar4.%s created in temp directory
-- dir perms 666 --
tempnamVar4.%s created in temp directory
-- dir perms 667 --
tempnamVar4.%s created in temp directory
-- dir perms 670 --
tempnamVar4.%s created in temp directory
-- dir perms 671 --
tempnamVar4.%s created in temp directory
-- dir perms 672 --
tempnamVar4.%s created in temp directory
-- dir perms 673 --
tempnamVar4.%s created in temp directory
-- dir perms 674 --
tempnamVar4.%s created in temp directory
-- dir perms 675 --
tempnamVar4.%s created in temp directory
-- dir perms 676 --
tempnamVar4.%s created in temp directory
-- dir perms 677 --
tempnamVar4.%s created in temp directory
-- dir perms 700 --
tempnamVar4.%s created in requested directory
-- dir perms 701 --
tempnamVar4.%s created in requested directory
-- dir perms 702 --
tempnamVar4.%s created in requested directory
-- dir perms 703 --
tempnamVar4.%s created in requested directory
-- dir perms 704 --
tempnamVar4.%s created in requested directory
-- dir perms 705 --
tempnamVar4.%s created in requested directory
-- dir perms 706 --
tempnamVar4.%s created in requested directory
-- dir perms 707 --
tempnamVar4.%s created in requested directory
-- dir perms 710 --
tempnamVar4.%s created in requested directory
-- dir perms 711 --
tempnamVar4.%s created in requested directory
-- dir perms 712 --
tempnamVar4.%s created in requested directory
-- dir perms 713 --
tempnamVar4.%s created in requested directory
-- dir perms 714 --
tempnamVar4.%s created in requested directory
-- dir perms 715 --
tempnamVar4.%s created in requested directory
-- dir perms 716 --
tempnamVar4.%s created in requested directory
-- dir perms 717 --
tempnamVar4.%s created in requested directory
-- dir perms 720 --
tempnamVar4.%s created in requested directory
-- dir perms 721 --
tempnamVar4.%s created in requested directory
-- dir perms 722 --
tempnamVar4.%s created in requested directory
-- dir perms 723 --
tempnamVar4.%s created in requested directory
-- dir perms 724 --
tempnamVar4.%s created in requested directory
-- dir perms 725 --
tempnamVar4.%s created in requested directory
-- dir perms 726 --
tempnamVar4.%s created in requested directory
-- dir perms 727 --
tempnamVar4.%s created in requested directory
-- dir perms 730 --
tempnamVar4.%s created in requested directory
-- dir perms 731 --
tempnamVar4.%s created in requested directory
-- dir perms 732 --
tempnamVar4.%s created in requested directory
-- dir perms 733 --
tempnamVar4.%s created in requested directory
-- dir perms 734 --
tempnamVar4.%s created in requested directory
-- dir perms 735 --
tempnamVar4.%s created in requested directory
-- dir perms 736 --
tempnamVar4.%s created in requested directory
-- dir perms 737 --
tempnamVar4.%s created in requested directory
-- dir perms 740 --
tempnamVar4.%s created in requested directory
-- dir perms 741 --
tempnamVar4.%s created in requested directory
-- dir perms 742 --
tempnamVar4.%s created in requested directory
-- dir perms 743 --
tempnamVar4.%s created in requested directory
-- dir perms 744 --
tempnamVar4.%s created in requested directory
-- dir perms 745 --
tempnamVar4.%s created in requested directory
-- dir perms 746 --
tempnamVar4.%s created in requested directory
-- dir perms 747 --
tempnamVar4.%s created in requested directory
-- dir perms 750 --
tempnamVar4.%s created in requested directory
-- dir perms 751 --
tempnamVar4.%s created in requested directory
-- dir perms 752 --
tempnamVar4.%s created in requested directory
-- dir perms 753 --
tempnamVar4.%s created in requested directory
-- dir perms 754 --
tempnamVar4.%s created in requested directory
-- dir perms 755 --
tempnamVar4.%s created in requested directory
-- dir perms 756 --
tempnamVar4.%s created in requested directory
-- dir perms 757 --
tempnamVar4.%s created in requested directory
-- dir perms 760 --
tempnamVar4.%s created in requested directory
-- dir perms 761 --
tempnamVar4.%s created in requested directory
-- dir perms 762 --
tempnamVar4.%s created in requested directory
-- dir perms 763 --
tempnamVar4.%s created in requested directory
-- dir perms 764 --
tempnamVar4.%s created in requested directory
-- dir perms 765 --
tempnamVar4.%s created in requested directory
-- dir perms 766 --
tempnamVar4.%s created in requested directory
-- dir perms 767 --
tempnamVar4.%s created in requested directory
-- dir perms 770 --
tempnamVar4.%s created in requested directory
-- dir perms 771 --
tempnamVar4.%s created in requested directory
-- dir perms 772 --
tempnamVar4.%s created in requested directory
-- dir perms 773 --
tempnamVar4.%s created in requested directory
-- dir perms 774 --
tempnamVar4.%s created in requested directory
-- dir perms 775 --
tempnamVar4.%s created in requested directory
-- dir perms 776 --
tempnamVar4.%s created in requested directory
-- dir perms 777 --
tempnamVar4.%s created in requested directory
*** Done ***