#!/usr/bin/perl -w
#
# Convert a single gnuplot demo script to a web page
# Usage:
#	webify xxx
#
# Reads xxx.dem and creates xxx.html along with associated 
# images output to xxx.<n>.html
#
# If gpsavediff is present also create a set of scripts
# xxx.<n>.gnu corresponding to the minimal set of commands 
# needed to generate that png image.
#
# If gnuplot_demo.css is present, link to it as a stylesheet.
#
# Ethan A Merritt <merritt@u.washington.edu>
# December 2003
#
# EAM Jan 2004
#   use gpsavediff if available
#   link to gnuplot_demo.css if available
#
# EAM Aug 2005
# If DEMOTERM is present as an environmental variable, then use
#    set term DEMOTERM
# rather than the default terminal settings
# E.g. (for image demo)
#    setenv DEMOTERM "png truecolor enhanced font 'arial,8' transparent size 420,320"
#    ./webify.pl image
#
# EAM Jan 2009
#    set term canvas
#
# EAM May 2009
#    generalized mousing support in the demos
#    each plot has its own mousebox
#    FIXME:  mousing should depend on some recognizable line in the demo script,
#	     or the mouseable demos should have a separate make target
#
use Env qw(DEMOTERM GNUPLOT_LIB);

use HTML::Entities;

require "ctime.pl";

# Use the in-tree copy of gnuplot if there is one
	my $gnuplot = ( -x "../../src/gnuplot" ) ? "../../src/gnuplot" : "gnuplot" ;

	if ((!defined $ENV{GNUPLOT_LIB}) || $GNUPLOT_LIB eq "") {
	    $GNUPLOT_LIB = "..";
	}
	my $date = &ctime(time);
	my $plot = 1;
	my $mousing = 0;
	my $name = "foo";

# options
	if ($ARGV[0] eq "--mouse") {
	    $mousing = 1;
	    $name = $ARGV[1];
	} else {
	    $name = $ARGV[0];
	}

print STDERR $name, "\n";

# input and output files
	open(IN,  "<$GNUPLOT_LIB/$name.dem") or die "can't open $GNUPLOT_LIB/$name.dem";
	open(OUT, ">$name.html") or die "can't open $ARGV[0].html";

# open pipe to gnuplot and set terminal type
	open(GNUPLOT, "|$gnuplot") or die "can't find gnuplot";
	if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
	    print GNUPLOT "set term $DEMOTERM\n";
	} else {
	    print GNUPLOT "set term canvas name \"$name"."_$plot\" jsdir \".\"\n";
	}
	print GNUPLOT "set output \"$name.$plot.js\"\n";

# find out if gpsavediff is available in current path
	my $savescripts = T;
	{local $^W=0; $savescripts = open(FOO, "|gpsavediff") }
	close FOO if ($savescripts);

# Boiler plate header
	print OUT "<html>\n<head>\n<title>gnuplot demo script: $name.dem </title>\n";
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot_demo.css\" type=\"text/css\">\n"
		  if (-e "gnuplot_demo.css");
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot_mouse.css\" type=\"text/css\">\n"
		  if ($mousing && -e "gnuplot_mouse.css");

	print OUT "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n";
	print OUT "<script src=\"canvastext.js\"></script>\n";
	print OUT "<script src=\"gnuplot_common.js\"></script>\n";
	print OUT "<script src=\"gnuplot_mouse.js\"></script>\n"
		  if ($mousing && -e "gnuplot_mouse.js");

	print OUT "<script type=\"text/javascript\">\n";
	print OUT "var canvas, ctx;\n";
	print OUT "var grid_lines = true;\n";
	print OUT "var zoomed = false;\n";
	print OUT "var active_plot_name = \"gnuplot_canvas\";\n";
	print OUT "var active_plot = dummyplot;\n";
	print OUT "function dummyplot() {};\n";
	print OUT "function gnuplot_canvas( plot ) { active_plot(); };\n";
	print OUT "</script>\n";

	print OUT "</head>\n";
	print OUT "<body oncontextmenu=\"return false;\">\n";
	print OUT "<a href=index.html><image src=return.png alt=\"Back to demo index\" align=right></a>\n";
	print OUT "<h2>gnuplot demo script: <font color=blue>$name.dem</font> </h2>\n";
	print OUT "<i>autogenerated by webify.pl on $date</i>";

# try to find gnuplot version
	$version = `gnuplot --version`;
	print OUT "\n<br><i>gnuplot version $version</i>";
	print OUT "<hr>\n";

# Start processing
	print OUT "<table border=0><tr><td valign=top>";

	print OUT "<script src=\"$name.$plot.js\"></script>\n";
	print OUT "<canvas id=\"$name"."_$plot\" width=600 height=400 tabindex=\"0\">\n";
	print OUT "    <div class='box'><h2>Your browser does not support the HTML 5 canvas element</h2></div>\n";
	print OUT "</canvas>\n";
	print OUT "<script>\n";
	print OUT "if (window.attachEvent) {window.attachEvent('onload', $name"."_$plot);}\n";
	print OUT "else if (window.addEventListener) {window.addEventListener('load', $name"."_$plot, false);}\n";
	print OUT "else {document.addEventListener('load', $name"."_$plot, false);}\n";
	print OUT "</script>\n";

	print OUT "</td><td>\n";

	# Copy mouse box into output stream
	if ($mousing && -e "mousebox.template") {
	    my $spanid = $name."_".$plot;
	    open(MOUSEBOX,  "<mousebox.template") or die "can't open mousebox.template";
	    while (<MOUSEBOX>) { s/ACTIVE_PLOT_NAME/$spanid/; print OUT; }
	    close MOUSEBOX;
	}

	print OUT "<pre>\n";

	while (<IN>) {
		if (/^ *pause -1/) {
			if ($savescripts) {
			    print OUT "<br><p>Click <a href=$name.$plot.gnu>here</a> ",
				  "for minimal script to generate this plot</p>\n";
			    print GNUPLOT "save \"| gpsavediff > $name.$plot.gnu\"\n";
			}
			print OUT "</pre></td></tr></table>\n<br clear=all>\n<hr>\n";
			$plot++;
	
			print OUT "<table border=0><tr><td>";

			print OUT "<script src=\"$name.$plot.js\"></script>\n";
			print OUT "<canvas id=\"$name"."_$plot\" width=600 height=400 tabindex=\"0\">\n";
			print OUT "    <div id='errorDiv'>Your browser does not support the HTML 5 canvas element</div>\n";
			print OUT "</canvas>\n";
			print OUT "<script>\n";
			print OUT "if (window.attachEvent) {window.attachEvent('onload', $name"."_$plot);}\n";
			print OUT "else if (window.addEventListener) {window.addEventListener('load', $name"."_$plot, false);}\n";
			print OUT "else {document.addEventListener('load', $name"."_$plot, false);}\n";
			print OUT "var grid_lines = true;\n";
			print OUT "var zoom = false;\n";
			print OUT "</script>\n";

			print OUT "</td><td valign=top>\n";

			# Copy mouse box into output stream
			if ($mousing && -e "mousebox.template") {
			    my $spanid = $name."_".$plot;
	    		    open(MOUSEBOX,  "<mousebox.template") or die "can't open mousebox.template";
	    		    while (<MOUSEBOX>) { s/ACTIVE_PLOT_NAME/$spanid/; print OUT; }
	    		    close MOUSEBOX;
			}

			print OUT "<pre>\n";
	    		print GNUPLOT "set term canvas name \"$name"."_$plot\" jsdir \".\"\n";
			print GNUPLOT "set output \"$name.$plot.js\"\n";
		} elsif (/^pause/) {
	    		print GNUPLOT "set term canvas name \"$name"."_$plot\" jsdir \".\"\n";
			print GNUPLOT "set output \"$name.$plot.js\"\n";
		} elsif (/^ *reset/) {
			print GNUPLOT;
		} else {
			print OUT HTML::Entities::encode($_);
			print GNUPLOT;
		}
	}

# Amazingly enough, that's it.
# Unlink leftover empty plot before leaving.
	close GNUPLOT;
	unlink("$name.$plot.js");
	print OUT "</pre></td></tr></table>\n";
	print OUT "</body>\n</html>\n";

