/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.InstructionList;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFieldInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantInterfaceMethodInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantMethodInfo;
import org.cojen.classfile.constant.ConstantStringInfo;

public class CodeBuilder
extends AbstractCodeAssembler
implements CodeBuffer,
CodeAssembler {
    private final CodeAttr mCodeAttr;
    private final ClassFile mClassFile;
    private final ConstantPool mCp;
    private final InstructionList mInstructions;
    private final LocalVariable mThisReference;
    private final LocalVariable[] mParameters;
    private final int mTarget;
    private final boolean mSaveLineNumberInfo;
    private final boolean mSaveLocalVariableInfo;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Number;

    public CodeBuilder(MethodInfo info) {
        this(info, true, false);
    }

    public CodeBuilder(MethodInfo info, boolean saveLineNumberInfo, boolean saveLocalVariableInfo) {
        LocalVariable localVar;
        String target = info.getClassFile().getTarget();
        this.mTarget = "1.0".equals(target) ? 65536 : ("1.1".equals(target) ? 65537 : ("1.2".equals(target) ? 65538 : ("1.3".equals(target) ? 65539 : ("1.4".equals(target) ? 65540 : ("1.5".equals(target) ? 65541 : ("1.6".equals(target) ? 65542 : 65536))))));
        this.mCodeAttr = info.getCodeAttr();
        this.mClassFile = info.getClassFile();
        this.mCp = this.mClassFile.getConstantPool();
        this.mInstructions = new InstructionList();
        this.mCodeAttr.setCodeBuffer(this);
        this.mSaveLineNumberInfo = saveLineNumberInfo;
        this.mSaveLocalVariableInfo = saveLocalVariableInfo;
        if (info.getModifiers().isStatic()) {
            this.mThisReference = null;
        } else {
            this.mThisReference = localVar = this.mInstructions.createLocalParameter("this", this.mClassFile.getType());
            if (saveLocalVariableInfo) {
                this.mCodeAttr.localVariableUse(localVar);
            }
        }
        TypeDesc[] paramTypes = info.getMethodDescriptor().getParameterTypes();
        int paramSize = paramTypes.length;
        this.mParameters = new LocalVariable[paramSize];
        for (int i = 0; i < paramTypes.length; ++i) {
            this.mParameters[i] = localVar = this.mInstructions.createLocalParameter(null, paramTypes[i]);
            if (!saveLocalVariableInfo) continue;
            this.mCodeAttr.localVariableUse(localVar);
        }
    }

    public int getMaxStackDepth() {
        return this.mInstructions.getMaxStackDepth();
    }

    public int getMaxLocals() {
        return this.mInstructions.getMaxLocals();
    }

    public byte[] getByteCodes() {
        return this.mInstructions.getByteCodes();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.mInstructions.getExceptionHandlers();
    }

    private void addCode(int stackAdjust, byte opcode) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode});
    }

    private void addCode(int stackAdjust, byte opcode, byte operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode, operand});
    }

    private void addCode(int stackAdjust, byte opcode, short operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, new byte[]{opcode, (byte)(operand >> 8), (byte)operand});
    }

    private void addCode(int stackAdjust, byte opcode, int operand) {
        byte[] bytes = new byte[]{opcode, (byte)(operand >> 24), (byte)(operand >> 16), (byte)(operand >> 8), (byte)operand};
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.CodeInstruction(instructionList, stackAdjust, bytes);
    }

    private void addCode(int stackAdjust, byte opcode, ConstantInfo info) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, new byte[]{opcode, 0, 0}, info);
    }

    private String getClassName(TypeDesc classDesc) throws IllegalArgumentException {
        if (classDesc.isPrimitive()) {
            throw new IllegalArgumentException("Primitive type not allowed");
        }
        if (classDesc.isArray()) {
            throw new IllegalArgumentException("Array type not allowed");
        }
        return classDesc.getRootName();
    }

    public int getParameterCount() {
        return this.mParameters.length;
    }

    public LocalVariable getParameter(int index) {
        return this.mParameters[index];
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        LocalVariable localVar = this.mInstructions.createLocalVariable(name, type);
        if (this.mSaveLocalVariableInfo) {
            this.mCodeAttr.localVariableUse(localVar);
        }
        return localVar;
    }

    public Label createLabel() {
        return new InstructionList.LabelInstruction(this.mInstructions);
    }

    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        Label catchLocation = this.createLabel().setLocation();
        ConstantClassInfo catchClass = catchClassName == null ? null : this.mCp.addConstantClass(catchClassName);
        ExceptionHandler handler = new ExceptionHandler(startLocation, endLocation, catchLocation, catchClass);
        this.mInstructions.addExceptionHandler(handler);
    }

    public void mapLineNumber(int lineNumber) {
        if (this.mSaveLineNumberInfo) {
            this.mCodeAttr.mapLineNumber(this.createLabel().setLocation(), lineNumber);
        }
    }

    public void loadNull() {
        this.addCode(1, (byte)1);
    }

    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
            return;
        }
        int strlen = value.length();
        if (strlen <= 21845) {
            ConstantStringInfo info = this.mCp.addConstantString(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            return;
        }
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen <= 65535) {
            ConstantStringInfo info = this.mCp.addConstantString(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            return;
        }
        TypeDesc stringBufferDesc = this.mTarget >= 65541 ? TypeDesc.forClass("java.lang.StringBuilder") : TypeDesc.forClass(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = CodeBuilder.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        TypeDesc intDesc = TypeDesc.INT;
        TypeDesc stringDesc = TypeDesc.STRING;
        TypeDesc[] stringParam = new TypeDesc[]{stringDesc};
        this.newObject(stringBufferDesc);
        this.dup();
        this.loadConstant(strlen);
        this.invokeConstructor(stringBufferDesc, new TypeDesc[]{intDesc});
        int endIndex = 0;
        while (endIndex < strlen) {
            char c;
            int size;
            int beginIndex = endIndex;
            utflen = 0;
            while (endIndex < strlen && utflen + (size = (c = value.charAt(endIndex)) >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2)) <= 65535) {
                utflen += size;
                ++endIndex;
            }
            String substr = value.substring(beginIndex, endIndex);
            ConstantStringInfo info = this.mCp.addConstantString(substr);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
            this.invokeVirtual(stringBufferDesc, "append", stringBufferDesc, stringParam);
        }
        this.invokeVirtual(stringBufferDesc, "toString", stringDesc, null);
    }

    public void loadConstant(TypeDesc type) throws IllegalStateException {
        if (type == null) {
            this.loadNull();
            return;
        }
        if (type.isPrimitive()) {
            if (this.mTarget < 65537) {
                throw new IllegalStateException("Loading constant primitive classes not supported below target version 1.1");
            }
            this.loadStaticField(type.toObjectType(), "TYPE", TypeDesc.forClass(class$java$lang$Class == null ? (class$java$lang$Class = CodeBuilder.class$("java.lang.Class")) : class$java$lang$Class));
        } else {
            if (this.mTarget < 65541) {
                throw new IllegalStateException("Loading constant object classes not supported below target version 1.5");
            }
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
        }
    }

    public void loadConstant(boolean value) {
        this.loadConstant(value ? 1 : 0);
    }

    public void loadConstant(int value) {
        if (-1 <= value && value <= 5) {
            byte op;
            switch (value) {
                case -1: {
                    op = 2;
                    break;
                }
                case 0: {
                    op = 3;
                    break;
                }
                case 1: {
                    op = 4;
                    break;
                }
                case 2: {
                    op = 5;
                    break;
                }
                case 3: {
                    op = 6;
                    break;
                }
                case 4: {
                    op = 7;
                    break;
                }
                case 5: {
                    op = 8;
                    break;
                }
                default: {
                    op = 0;
                }
            }
            this.addCode(1, op);
        } else if (-128 <= value && value <= 127) {
            this.addCode(1, (byte)16, (byte)value);
        } else if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
            this.addCode(1, (byte)17, (short)value);
        } else {
            ConstantIntegerInfo info = this.mCp.addConstantInteger(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
        }
    }

    public void loadConstant(long value) {
        if (value == 0L) {
            this.addCode(2, (byte)9);
        } else if (value == 1L) {
            this.addCode(2, (byte)10);
        } else {
            ConstantLongInfo info = this.mCp.addConstantLong(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, info, true);
        }
    }

    public void loadConstant(float value) {
        if (value == 0.0f) {
            this.addCode(1, (byte)11);
        } else if (value == 1.0f) {
            this.addCode(1, (byte)12);
        } else if (value == 2.0f) {
            this.addCode(1, (byte)13);
        } else {
            ConstantFloatInfo info = this.mCp.addConstantFloat(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, info);
        }
    }

    public void loadConstant(double value) {
        if (value == 0.0) {
            this.addCode(2, (byte)14);
        } else if (value == 1.0) {
            this.addCode(2, (byte)15);
        } else {
            ConstantDoubleInfo info = this.mCp.addConstantDouble(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, info, true);
        }
    }

    public void loadLocal(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? 2 : 1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.LoadLocalInstruction(instructionList, stackAdjust, local);
    }

    public void loadThis() {
        if (this.mThisReference == null) {
            throw new IllegalStateException("Attempt to load \"this\" reference in a static method");
        }
        this.loadLocal(this.mThisReference);
    }

    public void storeLocal(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? -2 : -1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StoreLocalInstruction(instructionList, stackAdjust, local);
    }

    public void loadFromArray(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 10: {
                op = 46;
                break;
            }
            case 4: 
            case 8: {
                op = 51;
                break;
            }
            case 9: {
                op = 53;
                break;
            }
            case 5: {
                op = 52;
                break;
            }
            case 6: {
                op = 48;
                break;
            }
            case 11: {
                stackAdjust = 0;
                op = 47;
                break;
            }
            case 7: {
                stackAdjust = 0;
                op = 49;
                break;
            }
            default: {
                op = 50;
            }
        }
        this.addCode(stackAdjust, op);
    }

    public void storeToArray(TypeDesc type) {
        byte op;
        int stackAdjust = -3;
        switch (type.getTypeCode()) {
            case 10: {
                op = 79;
                break;
            }
            case 4: 
            case 8: {
                op = 84;
                break;
            }
            case 9: {
                op = 86;
                break;
            }
            case 5: {
                op = 85;
                break;
            }
            case 6: {
                op = 81;
                break;
            }
            case 11: {
                stackAdjust = -4;
                op = 80;
                break;
            }
            case 7: {
                stackAdjust = -4;
                op = 82;
                break;
            }
            default: {
                op = 83;
            }
        }
        this.addCode(stackAdjust, op);
    }

    public void loadField(String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.constantField(fieldName, type), type);
    }

    public void loadField(String className, String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.mCp.addConstantField(className, fieldName, type), type);
    }

    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.loadField(this.getClassName(classDesc), fieldName, type);
    }

    public void loadStaticField(String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.constantField(fieldName, type), type);
    }

    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.mCp.addConstantField(className, fieldName, type), type);
    }

    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.loadStaticField(this.getClassName(classDesc), fieldName, type);
    }

    private void getfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        if (type.isDoubleWord()) {
            ++stackAdjust;
        }
        this.addCode(stackAdjust, opcode, info);
    }

    private ConstantFieldInfo constantField(String fieldName, TypeDesc type) {
        return this.mCp.addConstantField(this.mClassFile.getClassName(), fieldName, type);
    }

    public void storeField(String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.constantField(fieldName, type), type);
    }

    public void storeField(String className, String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.mCp.addConstantField(className, fieldName, type), type);
    }

    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.storeField(this.getClassName(classDesc), fieldName, type);
    }

    public void storeStaticField(String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.constantField(fieldName, type), type);
    }

    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.mCp.addConstantField(className, fieldName, type), type);
    }

    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.storeStaticField(this.getClassName(classDesc), fieldName, type);
    }

    private void putfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        stackAdjust = type.isDoubleWord() ? (stackAdjust -= 2) : --stackAdjust;
        this.addCode(stackAdjust, opcode, info);
    }

    public void returnVoid() {
        this.addCode(0, (byte)-79);
    }

    public void returnValue(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                op = -84;
                break;
            }
            case 6: {
                op = -82;
                break;
            }
            case 11: {
                stackAdjust = -2;
                op = -83;
                break;
            }
            case 7: {
                stackAdjust = -2;
                op = -81;
                break;
            }
            case 1: {
                stackAdjust = 0;
                op = -79;
                break;
            }
            default: {
                op = -80;
            }
        }
        this.addCode(stackAdjust, op);
    }

    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.convert(fromType, toType, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        Label end;
        block70: {
            void var10_12;
            TypeDesc toPrimitiveType;
            if (fpConvertMode < 0 || fpConvertMode > 2) {
                throw new IllegalArgumentException("Illegal floating point conversion mode");
            }
            if (toType == TypeDesc.OBJECT) {
                if (fromType.isPrimitive()) {
                    toType = fromType.toObjectType();
                } else {
                    return;
                }
            }
            if (fromType == toType) {
                return;
            }
            TypeDesc fromPrimitiveType = fromType.toPrimitiveType();
            if (fromPrimitiveType == null) {
                Class toClass;
                Class fromClass;
                if (!toType.isPrimitive() && (fromClass = fromType.toClass()) != null && (toClass = toType.toClass()) != null && toClass.isAssignableFrom(fromClass)) {
                    return;
                }
                throw this.invalidConversion(fromType, toType);
            }
            int fromTypeCode = fromPrimitiveType.getTypeCode();
            if (toType.toClass() == (class$java$lang$Number == null ? (class$java$lang$Number = CodeBuilder.class$("java.lang.Number")) : class$java$lang$Number)) {
                switch (fromTypeCode) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (fromType.isPrimitive()) {
                            toType = fromType.toObjectType();
                            break;
                        }
                        return;
                    }
                }
            }
            if ((toPrimitiveType = toType.toPrimitiveType()) == null) {
                throw this.invalidConversion(fromType, toType);
            }
            int toTypeCode = toPrimitiveType.getTypeCode();
            end = this.createLabel();
            int stackAdjust = 0;
            block3 : switch (fromTypeCode) {
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    int op;
                    switch (toTypeCode) {
                        case 8: {
                            op = fromTypeCode == 8 ? 0 : -111;
                            break block3;
                        }
                        case 9: {
                            op = fromTypeCode == 9 ? 0 : -109;
                            break block3;
                        }
                        case 5: {
                            op = fromTypeCode == 5 ? 0 : -110;
                            break block3;
                        }
                        case 6: {
                            op = -122;
                            break block3;
                        }
                        case 11: {
                            stackAdjust = 1;
                            op = -123;
                            break block3;
                        }
                        case 7: {
                            stackAdjust = 1;
                            op = -121;
                            break block3;
                        }
                        case 10: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 11: {
                    int op;
                    switch (toTypeCode) {
                        case 10: {
                            stackAdjust = -1;
                            op = -120;
                            break block3;
                        }
                        case 6: {
                            stackAdjust = -1;
                            op = -119;
                            break block3;
                        }
                        case 7: {
                            op = -118;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addCode(-1, (byte)-120);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 11: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0L);
                            this.math((byte)-108);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 6: {
                    int op;
                    switch (toTypeCode) {
                        case 10: {
                            op = -117;
                            break block3;
                        }
                        case 11: {
                            stackAdjust = 1;
                            op = -116;
                            break block3;
                        }
                        case 7: {
                            stackAdjust = 1;
                            op = -115;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addCode(0, (byte)-117);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 6: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0.0f);
                            this.math((byte)-106);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 7: {
                    int op;
                    switch (toTypeCode) {
                        case 10: {
                            stackAdjust = -1;
                            op = -114;
                            break block3;
                        }
                        case 6: {
                            stackAdjust = -1;
                            op = -112;
                            break block3;
                        }
                        case 11: {
                            op = -113;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addCode(-1, (byte)-114);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 7: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0.0);
                            this.math((byte)-104);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                default: {
                    throw this.invalidConversion(fromType, toType);
                }
            }
            if (!fromType.isPrimitive()) {
                if (!toType.isPrimitive()) {
                    this.nullConvert(end);
                }
                this.unbox(fromType, fromPrimitiveType);
            }
            if (toType.isPrimitive()) {
                if (var10_12 != false) {
                    this.convertPrimitive(stackAdjust, (byte)var10_12, fpConvertMode);
                }
            } else {
                if (var10_12 == false) {
                    this.prebox(toPrimitiveType, toType);
                } else if (!fromPrimitiveType.isDoubleWord() && toPrimitiveType.isDoubleWord()) {
                    this.prebox(fromPrimitiveType, toType);
                    this.convertPrimitive(stackAdjust, (byte)var10_12, fpConvertMode);
                } else {
                    this.convertPrimitive(stackAdjust, (byte)var10_12, fpConvertMode);
                    this.prebox(toPrimitiveType, toType);
                }
                this.box(toPrimitiveType, toType);
            }
        }
        end.setLocation();
    }

    /*
     * WARNING - void declaration
     */
    private void unbox(TypeDesc from, TypeDesc to) {
        void var3_3;
        switch (to.getTypeCode()) {
            case 4: {
                String methodName = "booleanValue";
                break;
            }
            case 5: {
                String methodName = "charValue";
                break;
            }
            case 6: {
                String methodName = "floatValue";
                break;
            }
            case 7: {
                String methodName = "doubleValue";
                break;
            }
            case 8: {
                String methodName = "byteValue";
                break;
            }
            case 9: {
                String methodName = "shortValue";
                break;
            }
            case 10: {
                String methodName = "intValue";
                break;
            }
            case 11: {
                String methodName = "longValue";
                break;
            }
            default: {
                return;
            }
        }
        this.invokeVirtual(from.getRootName(), (String)var3_3, to, null);
    }

    private void prebox(TypeDesc from, TypeDesc to) {
        if (this.mTarget >= 65541) {
            return;
        }
        switch (from.getTypeCode()) {
            default: {
                break;
            }
            case 4: {
                if (to.toPrimitiveType().getTypeCode() == 4) break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                this.newObject(to);
                this.dupX1();
                this.swap();
                break;
            }
            case 7: 
            case 11: {
                this.newObject(to);
                this.dupX2();
                this.dupX2();
                this.pop();
            }
        }
    }

    private void box(TypeDesc from, TypeDesc to) {
        if (this.mTarget >= 65541) {
            this.invokeStatic(to.getRootName(), "valueOf", to, new TypeDesc[]{from});
            return;
        }
        switch (from.getTypeCode()) {
            case 4: {
                this.toBoolean(true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.invokeConstructor(to.getRootName(), new TypeDesc[]{from});
            }
        }
    }

    private void toBoolean(boolean box) {
        if (box && this.mTarget >= 65540) {
            this.invokeStatic("java.lang.Boolean", "valueOf", TypeDesc.BOOLEAN.toObjectType(), new TypeDesc[]{TypeDesc.BOOLEAN});
            return;
        }
        Label nonZero = this.createLabel();
        Label done = this.createLabel();
        this.ifZeroComparisonBranch(nonZero, "!=");
        if (box) {
            TypeDesc newType = TypeDesc.BOOLEAN.toObjectType();
            this.loadStaticField(newType.getRootName(), "FALSE", newType);
            this.branch(done);
            nonZero.setLocation();
            this.loadStaticField(newType.getRootName(), "TRUE", newType);
        } else {
            this.loadConstant(false);
            this.branch(done);
            nonZero.setLocation();
            this.loadConstant(true);
        }
        done.setLocation();
    }

    private void convertPrimitive(int stackAdjust, byte op, int fpConvertMode) {
        if (fpConvertMode != 0) {
            switch (op) {
                case -122: {
                    this.invokeStatic("java.lang.Float", "intBitsToFloat", TypeDesc.FLOAT, new TypeDesc[]{TypeDesc.INT});
                    return;
                }
                case -118: {
                    this.invokeStatic("java.lang.Double", "longBitsToDouble", TypeDesc.DOUBLE, new TypeDesc[]{TypeDesc.LONG});
                    return;
                }
                case -117: {
                    if (fpConvertMode == 2) {
                        this.invokeStatic("java.lang.Float", "floatToRawIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
                    } else {
                        this.invokeStatic("java.lang.Float", "floatToIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
                    }
                    return;
                }
                case -113: {
                    if (fpConvertMode == 2) {
                        this.invokeStatic("java.lang.Double", "doubleToRawLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
                    } else {
                        this.invokeStatic("java.lang.Double", "doubleToLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
                    }
                    return;
                }
            }
        }
        this.addCode(stackAdjust, op);
    }

    private void nullConvert(Label end) {
        LocalVariable temp = this.createLocalVariable("temp", TypeDesc.OBJECT);
        this.storeLocal(temp);
        this.loadLocal(temp);
        Label notNull = this.createLabel();
        this.ifNullBranch(notNull, false);
        this.loadNull();
        this.branch(end);
        notNull.setLocation();
        this.loadLocal(temp);
    }

    private IllegalArgumentException invalidConversion(TypeDesc from, TypeDesc to) {
        throw new IllegalArgumentException("Invalid conversion: " + from.getFullName() + " to " + to.getFullName());
    }

    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-74, info);
    }

    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(className, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-74, info);
    }

    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeVirtual(this.getClassName(classDesc), methodName, ret, params);
    }

    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 0;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-72, info);
    }

    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(className, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 0;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-72, info);
    }

    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeStatic(this.getClassName(classDesc), methodName, ret, params);
    }

    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantInterfaceMethodInfo info = this.mCp.addConstantInterfaceMethod(className, methodName, ret, params);
        int paramCount = 1;
        if (params != null) {
            paramCount += this.argSize(params);
        }
        int stackAdjust = this.returnSize(ret) - paramCount;
        byte[] bytes = new byte[5];
        bytes[0] = -71;
        bytes[3] = (byte)paramCount;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, bytes, info);
    }

    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeInterface(this.getClassName(classDesc), methodName, ret, params);
    }

    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantMethod(superClassName, methodName, ret, params);
        int stackAdjust = this.returnSize(ret) - 1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeSuper(this.getClassName(superClassDesc), methodName, ret, params);
    }

    public void invokeConstructor(TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantConstructor(this.mClassFile.getClassName(), params);
        int stackAdjust = -1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeConstructor(String className, TypeDesc[] params) {
        ConstantMethodInfo info = this.mCp.addConstantConstructor(className, params);
        int stackAdjust = -1;
        if (params != null) {
            stackAdjust -= this.argSize(params);
        }
        this.addCode(stackAdjust, (byte)-73, info);
    }

    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        this.invokeConstructor(this.getClassName(classDesc), params);
    }

    public void invokeSuperConstructor(TypeDesc[] params) {
        this.invokeConstructor(this.mClassFile.getSuperClassName(), params);
    }

    private int returnSize(TypeDesc ret) {
        if (ret == null || ret == TypeDesc.VOID) {
            return 0;
        }
        if (ret.isDoubleWord()) {
            return 2;
        }
        return 1;
    }

    private int argSize(TypeDesc[] params) {
        int size = 0;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                size += this.returnSize(params[i]);
            }
        }
        return size;
    }

    public void newObject(TypeDesc type) {
        if (type.isArray()) {
            this.newObject(type, 1);
        } else {
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            this.addCode(1, (byte)-69, info);
        }
    }

    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions <= 0) {
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            this.addCode(1, (byte)-69, info);
            return;
        }
        TypeDesc componentType = type.getComponentType();
        if (dimensions == 1) {
            if (componentType.isPrimitive()) {
                this.addCode(0, (byte)-68, (byte)componentType.getTypeCode());
                return;
            }
            this.addCode(0, (byte)-67, this.mCp.addConstantClass(componentType));
            return;
        }
        int stackAdjust = -(dimensions - 1);
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        byte[] bytes = new byte[4];
        bytes[0] = -59;
        bytes[3] = (byte)dimensions;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, bytes, info);
    }

    public void dup() {
        this.addCode(1, (byte)89);
    }

    public void dupX1() {
        this.addCode(1, (byte)90);
    }

    public void dupX2() {
        this.addCode(1, (byte)91);
    }

    public void dup2() {
        this.addCode(2, (byte)92);
    }

    public void dup2X1() {
        this.addCode(2, (byte)93);
    }

    public void dup2X2() {
        this.addCode(2, (byte)94);
    }

    public void pop() {
        this.addCode(-1, (byte)87);
    }

    public void pop2() {
        this.addCode(-2, (byte)88);
    }

    public void swap() {
        this.addCode(0, (byte)95);
    }

    public void swap2() {
        this.dup2X2();
        this.pop2();
    }

    private void branch(int stackAdjust, Location location, byte opcode) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.BranchInstruction(instructionList, stackAdjust, opcode, location);
    }

    public void branch(Location location) {
        this.branch(0, location, (byte)-89);
    }

    public void ifNullBranch(Location location, boolean choice) {
        this.branch(-1, location, choice ? (byte)-58 : -57);
    }

    public void ifEqualBranch(Location location, boolean choice) {
        this.branch(-2, location, choice ? (byte)-91 : -90);
    }

    /*
     * WARNING - void declaration
     */
    public void ifZeroComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        void var3_3;
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -103;
        } else if (choice == "!=") {
            opcode = -102;
        } else if (choice == "<") {
            opcode = -101;
        } else if (choice == ">=") {
            opcode = -100;
        } else if (choice == ">") {
            opcode = -99;
        } else if (choice == "<=") {
            opcode = -98;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-1, location, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void ifComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        void var3_3;
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -97;
        } else if (choice == "!=") {
            opcode = -96;
        } else if (choice == "<") {
            opcode = -95;
        } else if (choice == ">=") {
            opcode = -94;
        } else if (choice == ">") {
            opcode = -93;
        } else if (choice == "<=") {
            opcode = -92;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-2, location, (byte)var3_3);
    }

    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SwitchInstruction(instructionList, cases, locations, defaultLocation);
    }

    public void jsr(Location location) {
        this.branch(1, location, (byte)-88);
    }

    public void ret(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.RetInstruction(instructionList, local);
    }

    /*
     * WARNING - void declaration
     */
    public void math(byte opcode) {
        void var2_2;
        switch (opcode) {
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                int stackAdjust = 0;
                break;
            }
            case -128: 
            case -126: 
            case -107: 
            case -106: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int stackAdjust = -1;
                break;
            }
            case -127: 
            case -125: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: {
                int stackAdjust = -2;
                break;
            }
            case -108: 
            case -105: 
            case -104: {
                int stackAdjust = -3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a math opcode: " + Opcode.getMnemonic(opcode));
            }
        }
        this.addCode((int)var2_2, opcode);
    }

    public void arrayLength() {
        this.addCode(0, (byte)-66);
    }

    public void throwObject() {
        this.addCode(-1, (byte)-65);
    }

    public void checkCast(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addCode(0, (byte)-64, info);
    }

    public void instanceOf(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addCode(0, (byte)-63, info);
    }

    public void integerIncrement(LocalVariable local, int amount) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        if (Short.MIN_VALUE <= amount && amount <= Short.MAX_VALUE) {
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.ShortIncrementInstruction(instructionList, local, (short)amount);
        } else {
            this.loadLocal(local);
            this.loadConstant(amount);
            this.math((byte)96);
            this.storeLocal(local);
        }
    }

    public void monitorEnter() {
        this.addCode(-1, (byte)-62);
    }

    public void monitorExit() {
        this.addCode(-1, (byte)-61);
    }

    public void nop() {
        this.addCode(0, (byte)0);
    }

    public void breakpoint() {
        this.addCode(0, (byte)-54);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

