# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicefabricmanagedclusters.aio import ServiceFabricManagedClustersManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceFabricManagedClustersManagementApplicationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceFabricManagedClustersManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_get(self, resource_group):
        response = await self.client.applications.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            application_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.applications.begin_create_or_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "managedIdentities": [{"name": "str", "principalId": "str"}],
                        "parameters": {"str": "str"},
                        "provisioningState": "str",
                        "upgradePolicy": {
                            "applicationHealthPolicy": {
                                "considerWarningAsError": bool,
                                "maxPercentUnhealthyDeployedApplications": 0,
                                "defaultServiceTypeHealthPolicy": {
                                    "maxPercentUnhealthyPartitionsPerService": 0,
                                    "maxPercentUnhealthyReplicasPerPartition": 0,
                                    "maxPercentUnhealthyServices": 0,
                                },
                                "serviceTypeHealthPolicyMap": {
                                    "str": {
                                        "maxPercentUnhealthyPartitionsPerService": 0,
                                        "maxPercentUnhealthyReplicasPerPartition": 0,
                                        "maxPercentUnhealthyServices": 0,
                                    }
                                },
                            },
                            "forceRestart": bool,
                            "instanceCloseDelayDuration": 0,
                            "recreateApplication": bool,
                            "rollingUpgradeMonitoringPolicy": {
                                "failureAction": "str",
                                "healthCheckRetryTimeout": "str",
                                "healthCheckStableDuration": "str",
                                "healthCheckWaitDuration": "str",
                                "upgradeDomainTimeout": "str",
                                "upgradeTimeout": "str",
                            },
                            "upgradeMode": "str",
                            "upgradeReplicaSetCheckTimeout": 0,
                        },
                        "version": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_update(self, resource_group):
        response = await (
            await self.client.applications.begin_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={"properties": {"parameters": {"str": "str"}}, "tags": {"str": "str"}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_delete(self, resource_group):
        response = await (
            await self.client.applications.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_list(self, resource_group):
        response = self.client.applications.list(
            resource_group_name=resource_group.name,
            cluster_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_read_upgrade(self, resource_group):
        response = await (
            await self.client.applications.begin_read_upgrade(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_resume_upgrade(self, resource_group):
        response = await (
            await self.client.applications.begin_resume_upgrade(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={"upgradeDomainName": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_start_rollback(self, resource_group):
        response = await (
            await self.client.applications.begin_start_rollback(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_update_upgrade(self, resource_group):
        response = await (
            await self.client.applications.begin_update_upgrade(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={
                    "name": "str",
                    "upgradeKind": "str",
                    "applicationHealthPolicy": {
                        "considerWarningAsError": bool,
                        "maxPercentUnhealthyDeployedApplications": 0,
                        "defaultServiceTypeHealthPolicy": {
                            "maxPercentUnhealthyPartitionsPerService": 0,
                            "maxPercentUnhealthyReplicasPerPartition": 0,
                            "maxPercentUnhealthyServices": 0,
                        },
                        "serviceTypeHealthPolicyMap": {
                            "str": {
                                "maxPercentUnhealthyPartitionsPerService": 0,
                                "maxPercentUnhealthyReplicasPerPartition": 0,
                                "maxPercentUnhealthyServices": 0,
                            }
                        },
                    },
                    "updateDescription": {
                        "rollingUpgradeMode": "str",
                        "failureAction": "str",
                        "forceRestart": bool,
                        "healthCheckRetryTimeoutInMilliseconds": "str",
                        "healthCheckStableDurationInMilliseconds": "str",
                        "healthCheckWaitDurationInMilliseconds": "str",
                        "instanceCloseDelayDurationInSeconds": 0,
                        "replicaSetCheckTimeoutInMilliseconds": 0,
                        "upgradeDomainTimeoutInMilliseconds": "str",
                        "upgradeTimeoutInMilliseconds": "str",
                    },
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_fetch_health(self, resource_group):
        response = await (
            await self.client.applications.begin_fetch_health(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={
                    "deployedApplicationsHealthStateFilter": "str",
                    "eventsHealthStateFilter": "str",
                    "excludeHealthStatistics": bool,
                    "servicesHealthStateFilter": "str",
                    "timeout": 0,
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_applications_begin_restart_deployed_code_package(self, resource_group):
        response = await (
            await self.client.applications.begin_restart_deployed_code_package(
                resource_group_name=resource_group.name,
                cluster_name="str",
                application_name="str",
                parameters={
                    "codePackageInstanceId": "str",
                    "codePackageName": "str",
                    "nodeName": "str",
                    "serviceManifestName": "str",
                    "servicePackageActivationId": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
