# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Literal, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient, MatchConditions
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models2
from .... import models as _models3
from ...._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ...._utils.utils import ClientMixinABC
from ....knowledgebases import models as _knowledgebases_models4
from ..._operations._operations import (
    build_search_index_analyze_text_request,
    build_search_index_create_alias_request,
    build_search_index_create_index_request,
    build_search_index_create_knowledge_base_request,
    build_search_index_create_knowledge_source_request,
    build_search_index_create_or_update_alias_request,
    build_search_index_create_or_update_index_request,
    build_search_index_create_or_update_knowledge_base_request,
    build_search_index_create_or_update_knowledge_source_request,
    build_search_index_create_or_update_synonym_map_request,
    build_search_index_create_synonym_map_request,
    build_search_index_delete_alias_request,
    build_search_index_delete_index_request,
    build_search_index_delete_knowledge_base_request,
    build_search_index_delete_knowledge_source_request,
    build_search_index_delete_synonym_map_request,
    build_search_index_get_alias_request,
    build_search_index_get_index_request,
    build_search_index_get_index_statistics_request,
    build_search_index_get_knowledge_base_request,
    build_search_index_get_knowledge_source_request,
    build_search_index_get_knowledge_source_status_request,
    build_search_index_get_service_statistics_request,
    build_search_index_get_synonym_map_request,
    build_search_index_get_synonym_maps_request,
    build_search_index_list_aliases_request,
    build_search_index_list_index_stats_summary_request,
    build_search_index_list_indexes_request,
    build_search_index_list_indexes_with_selected_properties_request,
    build_search_index_list_knowledge_bases_request,
    build_search_index_list_knowledge_sources_request,
    build_search_indexer_create_data_source_connection_request,
    build_search_indexer_create_indexer_request,
    build_search_indexer_create_or_update_data_source_connection_request,
    build_search_indexer_create_or_update_indexer_request,
    build_search_indexer_create_or_update_skillset_request,
    build_search_indexer_create_skillset_request,
    build_search_indexer_delete_data_source_connection_request,
    build_search_indexer_delete_indexer_request,
    build_search_indexer_delete_skillset_request,
    build_search_indexer_get_data_source_connection_request,
    build_search_indexer_get_data_source_connections_request,
    build_search_indexer_get_indexer_request,
    build_search_indexer_get_indexer_status_request,
    build_search_indexer_get_indexers_request,
    build_search_indexer_get_skillset_request,
    build_search_indexer_get_skillsets_request,
    build_search_indexer_reset_documents_request,
    build_search_indexer_reset_indexer_request,
    build_search_indexer_reset_skills_request,
    build_search_indexer_resync_request,
    build_search_indexer_run_indexer_request,
)
from .._configuration import SearchIndexClientConfiguration, SearchIndexerClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _SearchIndexClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], SearchIndexClientConfiguration]
):

    @overload
    async def _create_or_update_synonym_map(
        self,
        name: str,
        synonym_map: _models2.SynonymMap,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SynonymMap: ...
    @overload
    async def _create_or_update_synonym_map(
        self,
        name: str,
        synonym_map: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SynonymMap: ...
    @overload
    async def _create_or_update_synonym_map(
        self,
        name: str,
        synonym_map: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SynonymMap: ...

    @distributed_trace_async
    async def _create_or_update_synonym_map(
        self,
        name: str,
        synonym_map: Union[_models2.SynonymMap, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SynonymMap:
        """Creates a new synonym map or updates a synonym map if it already exists.

        :param name: The name of the synonym map. Required.
        :type name: str
        :param synonym_map: The definition of the synonym map to create or update. Is one of the
         following types: SynonymMap, JSON, IO[bytes] Required.
        :type synonym_map: ~azure.search.documents.indexes.models.SynonymMap or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SynonymMap] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(synonym_map, (IOBase, bytes)):
            _content = synonym_map
        else:
            _content = json.dumps(synonym_map, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_or_update_synonym_map_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SynonymMap, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_synonym_map(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a synonym map.

        :param name: The name of the synonym map. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_index_delete_synonym_map_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_synonym_map(self, name: str, **kwargs: Any) -> _models2.SynonymMap:
        """Retrieves a synonym map definition.

        :param name: The name of the synonym map. Required.
        :type name: str
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SynonymMap] = kwargs.pop("cls", None)

        _request = build_search_index_get_synonym_map_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SynonymMap, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _get_synonym_maps(
        self, *, select: Optional[list[str]] = None, **kwargs: Any
    ) -> _models2._models.ListSynonymMapsResult:
        """Lists all synonym maps available for a search service.

        :keyword select: Selects which top-level properties to retrieve. Specified as a comma-separated
         list of JSON property names, or '*' for all properties. The default is all properties. Default
         value is None.
        :paramtype select: list[str]
        :return: ListSynonymMapsResult. The ListSynonymMapsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models._models.ListSynonymMapsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2._models.ListSynonymMapsResult] = kwargs.pop("cls", None)

        _request = build_search_index_get_synonym_maps_request(
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models2._models.ListSynonymMapsResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_synonym_map(
        self, synonym_map: _models2.SynonymMap, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SynonymMap:
        """Creates a new synonym map.

        :param synonym_map: The definition of the synonym map to create. Required.
        :type synonym_map: ~azure.search.documents.indexes.models.SynonymMap
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_synonym_map(
        self, synonym_map: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SynonymMap:
        """Creates a new synonym map.

        :param synonym_map: The definition of the synonym map to create. Required.
        :type synonym_map: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_synonym_map(
        self, synonym_map: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SynonymMap:
        """Creates a new synonym map.

        :param synonym_map: The definition of the synonym map to create. Required.
        :type synonym_map: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_synonym_map(
        self, synonym_map: Union[_models2.SynonymMap, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SynonymMap:
        """Creates a new synonym map.

        :param synonym_map: The definition of the synonym map to create. Is one of the following types:
         SynonymMap, JSON, IO[bytes] Required.
        :type synonym_map: ~azure.search.documents.indexes.models.SynonymMap or JSON or IO[bytes]
        :return: SynonymMap. The SynonymMap is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SynonymMap
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SynonymMap] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(synonym_map, (IOBase, bytes)):
            _content = synonym_map
        else:
            _content = json.dumps(synonym_map, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_synonym_map_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SynonymMap, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_or_update_index(
        self,
        name: str,
        index: _models2.SearchIndex,
        *,
        allow_index_downtime: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndex: ...
    @overload
    async def _create_or_update_index(
        self,
        name: str,
        index: JSON,
        *,
        allow_index_downtime: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndex: ...
    @overload
    async def _create_or_update_index(
        self,
        name: str,
        index: IO[bytes],
        *,
        allow_index_downtime: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndex: ...

    @distributed_trace_async
    async def _create_or_update_index(
        self,
        name: str,
        index: Union[_models2.SearchIndex, JSON, IO[bytes]],
        *,
        allow_index_downtime: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndex:
        """Creates a new search index or updates an index if it already exists.

        :param name: The name of the index. Required.
        :type name: str
        :param index: The definition of the index to create or update. Is one of the following types:
         SearchIndex, JSON, IO[bytes] Required.
        :type index: ~azure.search.documents.indexes.models.SearchIndex or JSON or IO[bytes]
        :keyword allow_index_downtime: Allows new analyzers, tokenizers, token filters, or char filters
         to be added to an index by taking the index offline for at least a few seconds. This
         temporarily causes indexing and query requests to fail. Performance and write availability of
         the index can be impaired for several minutes after the index is updated, or longer for very
         large indexes. Default value is None.
        :paramtype allow_index_downtime: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndex] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(index, (IOBase, bytes)):
            _content = index
        else:
            _content = json.dumps(index, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_or_update_index_request(
            name=name,
            allow_index_downtime=allow_index_downtime,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndex, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_index(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a search index and all the documents it contains. This operation is permanent, with no
        recovery option. Make sure you have a master copy of your index definition, data ingestion
        code, and a backup of the primary data source in case you need to re-build the index.

        :param name: The name of the index. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_index_delete_index_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_index(self, name: str, **kwargs: Any) -> _models2.SearchIndex:
        """Retrieves an index definition.

        :param name: The name of the index. Required.
        :type name: str
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchIndex] = kwargs.pop("cls", None)

        _request = build_search_index_get_index_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndex, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _list_indexes(self, **kwargs: Any) -> AsyncItemPaged["_models2.SearchIndex"]:
        """Lists all indexes available for a search service.

        :return: An iterator like instance of SearchIndex
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models.SearchIndex]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2.SearchIndex]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_indexes_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2.SearchIndex], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def _list_indexes_with_selected_properties(
        self, *, select: Optional[list[str]] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models2._models.SearchIndexResponse"]:
        """Lists all indexes available for a search service.

        :keyword select: Selects which top-level properties to retrieve. Specified as a comma-separated
         list of JSON property names, or '*' for all properties. The default is all properties. Default
         value is None.
        :paramtype select: list[str]
        :return: An iterator like instance of SearchIndexResponse
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models._models.SearchIndexResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2._models.SearchIndexResponse]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_indexes_with_selected_properties_request(
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            # pylint: disable=protected-access
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2._models.SearchIndexResponse], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_index(
        self, index: _models2.SearchIndex, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndex:
        """Creates a new search index.

        :param index: The definition of the index to create. Required.
        :type index: ~azure.search.documents.indexes.models.SearchIndex
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_index(
        self, index: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndex:
        """Creates a new search index.

        :param index: The definition of the index to create. Required.
        :type index: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_index(
        self, index: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndex:
        """Creates a new search index.

        :param index: The definition of the index to create. Required.
        :type index: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_index(
        self, index: Union[_models2.SearchIndex, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SearchIndex:
        """Creates a new search index.

        :param index: The definition of the index to create. Is one of the following types:
         SearchIndex, JSON, IO[bytes] Required.
        :type index: ~azure.search.documents.indexes.models.SearchIndex or JSON or IO[bytes]
        :return: SearchIndex. The SearchIndex is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndex
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndex] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(index, (IOBase, bytes)):
            _content = index
        else:
            _content = json.dumps(index, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_index_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndex, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _get_index_statistics(self, name: str, **kwargs: Any) -> _models2.GetIndexStatisticsResult:
        """Returns statistics for the given index, including a document count and storage usage.

        :param name: The name of the index. Required.
        :type name: str
        :return: GetIndexStatisticsResult. The GetIndexStatisticsResult is compatible with
         MutableMapping
        :rtype: ~azure.search.documents.indexes.models.GetIndexStatisticsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.GetIndexStatisticsResult] = kwargs.pop("cls", None)

        _request = build_search_index_get_index_statistics_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.GetIndexStatisticsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _analyze_text(
        self, name: str, request: _models2.AnalyzeTextOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.AnalyzeResult: ...
    @overload
    async def _analyze_text(
        self, name: str, request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.AnalyzeResult: ...
    @overload
    async def _analyze_text(
        self, name: str, request: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.AnalyzeResult: ...

    @distributed_trace_async
    async def _analyze_text(
        self, name: str, request: Union[_models2.AnalyzeTextOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.AnalyzeResult:
        """Shows how an analyzer breaks text into tokens.

        :param name: The name of the index. Required.
        :type name: str
        :param request: The text and analyzer or analysis components to test. Is one of the following
         types: AnalyzeTextOptions, JSON, IO[bytes] Required.
        :type request: ~azure.search.documents.indexes.models.AnalyzeTextOptions or JSON or IO[bytes]
        :return: AnalyzeResult. The AnalyzeResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.AnalyzeResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.AnalyzeResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _content = json.dumps(request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_analyze_text_request(
            name=name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.AnalyzeResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_or_update_alias(
        self,
        name: str,
        alias: _models2.SearchAlias,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchAlias: ...
    @overload
    async def _create_or_update_alias(
        self,
        name: str,
        alias: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchAlias: ...
    @overload
    async def _create_or_update_alias(
        self,
        name: str,
        alias: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchAlias: ...

    @distributed_trace_async
    async def _create_or_update_alias(
        self,
        name: str,
        alias: Union[_models2.SearchAlias, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchAlias:
        """Creates a new search alias or updates an alias if it already exists.

        :param name: The name of the alias. Required.
        :type name: str
        :param alias: The definition of the alias to create or update. Is one of the following types:
         SearchAlias, JSON, IO[bytes] Required.
        :type alias: ~azure.search.documents.indexes.models.SearchAlias or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchAlias] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(alias, (IOBase, bytes)):
            _content = alias
        else:
            _content = json.dumps(alias, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_or_update_alias_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchAlias, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_alias(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a search alias and its associated mapping to an index. This operation is permanent,
        with no recovery option. The mapped index is untouched by this operation.

        :param name: The name of the alias. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_index_delete_alias_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_alias(self, name: str, **kwargs: Any) -> _models2.SearchAlias:
        """Retrieves an alias definition.

        :param name: The name of the alias. Required.
        :type name: str
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchAlias] = kwargs.pop("cls", None)

        _request = build_search_index_get_alias_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchAlias, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_aliases(self, **kwargs: Any) -> AsyncItemPaged["_models2.SearchAlias"]:
        """Lists all aliases available for a search service.

        :return: An iterator like instance of SearchAlias
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models.SearchAlias]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2.SearchAlias]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_aliases_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2.SearchAlias], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_alias(
        self, alias: _models2.SearchAlias, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchAlias:
        """Creates a new search alias.

        :param alias: The definition of the alias to create. Required.
        :type alias: ~azure.search.documents.indexes.models.SearchAlias
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_alias(
        self, alias: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchAlias:
        """Creates a new search alias.

        :param alias: The definition of the alias to create. Required.
        :type alias: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_alias(
        self, alias: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchAlias:
        """Creates a new search alias.

        :param alias: The definition of the alias to create. Required.
        :type alias: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_alias(
        self, alias: Union[_models2.SearchAlias, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SearchAlias:
        """Creates a new search alias.

        :param alias: The definition of the alias to create. Is one of the following types:
         SearchAlias, JSON, IO[bytes] Required.
        :type alias: ~azure.search.documents.indexes.models.SearchAlias or JSON or IO[bytes]
        :return: SearchAlias. The SearchAlias is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchAlias
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchAlias] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(alias, (IOBase, bytes)):
            _content = alias
        else:
            _content = json.dumps(alias, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_alias_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchAlias, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_or_update_knowledge_base(
        self,
        name: str,
        knowledge_base: _models2.KnowledgeBase,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeBase: ...
    @overload
    async def _create_or_update_knowledge_base(
        self,
        name: str,
        knowledge_base: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeBase: ...
    @overload
    async def _create_or_update_knowledge_base(
        self,
        name: str,
        knowledge_base: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeBase: ...

    @distributed_trace_async
    async def _create_or_update_knowledge_base(
        self,
        name: str,
        knowledge_base: Union[_models2.KnowledgeBase, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeBase:
        """Creates a new knowledge base or updates a knowledge base if it already exists.

        :param name: The name of the knowledge base. Required.
        :type name: str
        :param knowledge_base: The definition of the knowledge base to create or update. Is one of the
         following types: KnowledgeBase, JSON, IO[bytes] Required.
        :type knowledge_base: ~azure.search.documents.indexes.models.KnowledgeBase or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.KnowledgeBase] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(knowledge_base, (IOBase, bytes)):
            _content = knowledge_base
        else:
            _content = json.dumps(knowledge_base, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_or_update_knowledge_base_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeBase, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_knowledge_base(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a knowledge base.

        :param name: The name of the knowledge base. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_index_delete_knowledge_base_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_knowledge_base(self, name: str, **kwargs: Any) -> _models2.KnowledgeBase:
        """Retrieves a knowledge base definition.

        :param name: The name of the knowledge base. Required.
        :type name: str
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.KnowledgeBase] = kwargs.pop("cls", None)

        _request = build_search_index_get_knowledge_base_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeBase, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_knowledge_bases(self, **kwargs: Any) -> AsyncItemPaged["_models2.KnowledgeBase"]:
        """Lists all knowledge bases available for a search service.

        :return: An iterator like instance of KnowledgeBase
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models.KnowledgeBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2.KnowledgeBase]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_knowledge_bases_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2.KnowledgeBase], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_knowledge_base(
        self, knowledge_base: _models2.KnowledgeBase, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeBase:
        """Creates a new knowledge base.

        :param knowledge_base: The definition of the knowledge base to create. Required.
        :type knowledge_base: ~azure.search.documents.indexes.models.KnowledgeBase
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_knowledge_base(
        self, knowledge_base: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeBase:
        """Creates a new knowledge base.

        :param knowledge_base: The definition of the knowledge base to create. Required.
        :type knowledge_base: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_knowledge_base(
        self, knowledge_base: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeBase:
        """Creates a new knowledge base.

        :param knowledge_base: The definition of the knowledge base to create. Required.
        :type knowledge_base: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_knowledge_base(
        self, knowledge_base: Union[_models2.KnowledgeBase, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.KnowledgeBase:
        """Creates a new knowledge base.

        :param knowledge_base: The definition of the knowledge base to create. Is one of the following
         types: KnowledgeBase, JSON, IO[bytes] Required.
        :type knowledge_base: ~azure.search.documents.indexes.models.KnowledgeBase or JSON or IO[bytes]
        :return: KnowledgeBase. The KnowledgeBase is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.KnowledgeBase] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(knowledge_base, (IOBase, bytes)):
            _content = knowledge_base
        else:
            _content = json.dumps(knowledge_base, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_knowledge_base_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeBase, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_or_update_knowledge_source(
        self,
        name: str,
        knowledge_source: _models2.KnowledgeSource,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeSource: ...
    @overload
    async def _create_or_update_knowledge_source(
        self,
        name: str,
        knowledge_source: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeSource: ...
    @overload
    async def _create_or_update_knowledge_source(
        self,
        name: str,
        knowledge_source: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeSource: ...

    @distributed_trace_async
    async def _create_or_update_knowledge_source(
        self,
        name: str,
        knowledge_source: Union[_models2.KnowledgeSource, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeSource:
        """Creates a new knowledge source or updates an knowledge source if it already exists.

        :param name: The name of the knowledge source. Required.
        :type name: str
        :param knowledge_source: The definition of the knowledge source to create or update. Is one of
         the following types: KnowledgeSource, JSON, IO[bytes] Required.
        :type knowledge_source: ~azure.search.documents.indexes.models.KnowledgeSource or JSON or
         IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.KnowledgeSource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(knowledge_source, (IOBase, bytes)):
            _content = knowledge_source
        else:
            _content = json.dumps(knowledge_source, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_or_update_knowledge_source_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_knowledge_source(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes an existing knowledge source.

        :param name: The name of the knowledge source. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_index_delete_knowledge_source_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_knowledge_source(self, name: str, **kwargs: Any) -> _models2.KnowledgeSource:
        """Retrieves a knowledge source definition.

        :param name: The name of the knowledge source. Required.
        :type name: str
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.KnowledgeSource] = kwargs.pop("cls", None)

        _request = build_search_index_get_knowledge_source_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_knowledge_sources(self, **kwargs: Any) -> AsyncItemPaged["_models2.KnowledgeSource"]:
        """Lists all knowledge sources available for a search service.

        :return: An iterator like instance of KnowledgeSource
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models.KnowledgeSource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2.KnowledgeSource]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_knowledge_sources_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2.KnowledgeSource], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_knowledge_source(
        self, knowledge_source: _models2.KnowledgeSource, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeSource:
        """Creates a new knowledge source.

        :param knowledge_source: The definition of the knowledge source to create. Required.
        :type knowledge_source: ~azure.search.documents.indexes.models.KnowledgeSource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_knowledge_source(
        self, knowledge_source: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeSource:
        """Creates a new knowledge source.

        :param knowledge_source: The definition of the knowledge source to create. Required.
        :type knowledge_source: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_knowledge_source(
        self, knowledge_source: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.KnowledgeSource:
        """Creates a new knowledge source.

        :param knowledge_source: The definition of the knowledge source to create. Required.
        :type knowledge_source: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_knowledge_source(
        self, knowledge_source: Union[_models2.KnowledgeSource, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.KnowledgeSource:
        """Creates a new knowledge source.

        :param knowledge_source: The definition of the knowledge source to create. Is one of the
         following types: KnowledgeSource, JSON, IO[bytes] Required.
        :type knowledge_source: ~azure.search.documents.indexes.models.KnowledgeSource or JSON or
         IO[bytes]
        :return: KnowledgeSource. The KnowledgeSource is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.KnowledgeSource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.KnowledgeSource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(knowledge_source, (IOBase, bytes)):
            _content = knowledge_source
        else:
            _content = json.dumps(knowledge_source, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_index_create_knowledge_source_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeSource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_knowledge_source_status(
        self, name: str, **kwargs: Any
    ) -> _knowledgebases_models4.KnowledgeSourceStatus:
        """Retrieves the status of a knowledge source.

        :param name: The name of the knowledge source. Required.
        :type name: str
        :return: KnowledgeSourceStatus. The KnowledgeSourceStatus is compatible with MutableMapping
        :rtype: ~azure.search.documents.knowledgebases.models.KnowledgeSourceStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_knowledgebases_models4.KnowledgeSourceStatus] = kwargs.pop("cls", None)

        _request = build_search_index_get_knowledge_source_status_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_knowledgebases_models4.KnowledgeSourceStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_service_statistics(self, **kwargs: Any) -> _models2.SearchServiceStatistics:
        """Gets service level statistics for a search service.

        :return: SearchServiceStatistics. The SearchServiceStatistics is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchServiceStatistics
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchServiceStatistics] = kwargs.pop("cls", None)

        _request = build_search_index_get_service_statistics_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchServiceStatistics, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_index_stats_summary(self, **kwargs: Any) -> AsyncItemPaged["_models2.IndexStatisticsSummary"]:
        """Retrieves a summary of statistics for all indexes in the search service.

        :return: An iterator like instance of IndexStatisticsSummary
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.search.documents.indexes.models.IndexStatisticsSummary]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models2.IndexStatisticsSummary]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_search_index_list_index_stats_summary_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models2.IndexStatisticsSummary], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models3.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class _SearchIndexerClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], SearchIndexerClientConfiguration]
):

    @overload
    async def _create_or_update_data_source_connection(
        self,
        name: str,
        data_source: _models2.SearchIndexerDataSourceConnection,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection: ...
    @overload
    async def _create_or_update_data_source_connection(
        self,
        name: str,
        data_source: JSON,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection: ...
    @overload
    async def _create_or_update_data_source_connection(
        self,
        name: str,
        data_source: IO[bytes],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection: ...

    @distributed_trace_async
    async def _create_or_update_data_source_connection(
        self,
        name: str,
        data_source: Union[_models2.SearchIndexerDataSourceConnection, JSON, IO[bytes]],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection:
        """Creates a new datasource or updates a datasource if it already exists.

        :param name: The name of the datasource. Required.
        :type name: str
        :param data_source: The definition of the datasource to create or update. Is one of the
         following types: SearchIndexerDataSourceConnection, JSON, IO[bytes] Required.
        :type data_source: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection or
         JSON or IO[bytes]
        :keyword skip_indexer_reset_requirement_for_cache: Ignores cache reset requirements. Default
         value is None.
        :paramtype skip_indexer_reset_requirement_for_cache: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexerDataSourceConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(data_source, (IOBase, bytes)):
            _content = data_source
        else:
            _content = json.dumps(data_source, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_or_update_data_source_connection_request(
            name=name,
            skip_indexer_reset_requirement_for_cache=skip_indexer_reset_requirement_for_cache,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerDataSourceConnection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_data_source_connection(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a datasource.

        :param name: The name of the datasource. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_indexer_delete_data_source_connection_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_data_source_connection(self, name: str, **kwargs: Any) -> _models2.SearchIndexerDataSourceConnection:
        """Retrieves a datasource definition.

        :param name: The name of the datasource. Required.
        :type name: str
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchIndexerDataSourceConnection] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_data_source_connection_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerDataSourceConnection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _get_data_source_connections(
        self, *, select: Optional[list[str]] = None, **kwargs: Any
    ) -> _models2._models.ListDataSourcesResult:
        """Lists all datasources available for a search service.

        :keyword select: Selects which top-level properties to retrieve. Specified as a comma-separated
         list of JSON property names, or '*' for all properties. The default is all properties. Default
         value is None.
        :paramtype select: list[str]
        :return: ListDataSourcesResult. The ListDataSourcesResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models._models.ListDataSourcesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2._models.ListDataSourcesResult] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_data_source_connections_request(
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models2._models.ListDataSourcesResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_data_source_connection(
        self,
        data_source_connection: _models2.SearchIndexerDataSourceConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection:
        """Creates a new datasource.

        :param data_source_connection: The definition of the datasource to create. Required.
        :type data_source_connection:
         ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_data_source_connection(
        self, data_source_connection: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection:
        """Creates a new datasource.

        :param data_source_connection: The definition of the datasource to create. Required.
        :type data_source_connection: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_data_source_connection(
        self, data_source_connection: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection:
        """Creates a new datasource.

        :param data_source_connection: The definition of the datasource to create. Required.
        :type data_source_connection: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_data_source_connection(
        self, data_source_connection: Union[_models2.SearchIndexerDataSourceConnection, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SearchIndexerDataSourceConnection:
        """Creates a new datasource.

        :param data_source_connection: The definition of the datasource to create. Is one of the
         following types: SearchIndexerDataSourceConnection, JSON, IO[bytes] Required.
        :type data_source_connection:
         ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection or JSON or IO[bytes]
        :return: SearchIndexerDataSourceConnection. The SearchIndexerDataSourceConnection is compatible
         with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexerDataSourceConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(data_source_connection, (IOBase, bytes)):
            _content = data_source_connection
        else:
            _content = json.dumps(data_source_connection, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_data_source_connection_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerDataSourceConnection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def reset_indexer(self, name: str, **kwargs: Any) -> None:
        """Resets the change tracking state associated with an indexer.

        :param name: The name of the indexer. Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_indexer_reset_indexer_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def _resync(
        self,
        name: str,
        indexer_resync: _models2.IndexerResyncBody,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...
    @overload
    async def _resync(
        self, name: str, indexer_resync: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None: ...
    @overload
    async def _resync(
        self, name: str, indexer_resync: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None: ...

    @distributed_trace_async
    async def _resync(
        self, name: str, indexer_resync: Union[_models2.IndexerResyncBody, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Resync selective options from the datasource to be re-ingested by the indexer.".

        :param name: The name of the indexer. Required.
        :type name: str
        :param indexer_resync: The definition of the indexer resync options. Is one of the following
         types: IndexerResyncBody, JSON, IO[bytes] Required.
        :type indexer_resync: ~azure.search.documents.indexes.models.IndexerResyncBody or JSON or
         IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(indexer_resync, (IOBase, bytes)):
            _content = indexer_resync
        else:
            _content = json.dumps(indexer_resync, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_resync_request(
            name=name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def _reset_documents(
        self,
        name: str,
        keys_or_ids: Optional[_models2.DocumentKeysOrIds] = None,
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...
    @overload
    async def _reset_documents(
        self,
        name: str,
        keys_or_ids: Optional[JSON] = None,
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...
    @overload
    async def _reset_documents(
        self,
        name: str,
        keys_or_ids: Optional[IO[bytes]] = None,
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None: ...

    @distributed_trace_async
    async def _reset_documents(
        self,
        name: str,
        keys_or_ids: Optional[Union[_models2.DocumentKeysOrIds, JSON, IO[bytes]]] = None,
        *,
        overwrite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Resets specific documents in the datasource to be selectively re-ingested by the indexer.

        :param name: The name of the indexer. Required.
        :type name: str
        :param keys_or_ids: The keys or ids of the documents to be re-ingested. If keys are provided,
         the document key field must be specified in the indexer configuration. If ids are provided, the
         document key field is ignored. Is one of the following types: DocumentKeysOrIds, JSON,
         IO[bytes] Default value is None.
        :type keys_or_ids: ~azure.search.documents.indexes.models.DocumentKeysOrIds or JSON or
         IO[bytes]
        :keyword overwrite: If false, keys or ids will be appended to existing ones. If true, only the
         keys or ids in this payload will be queued to be re-ingested. Default value is None.
        :paramtype overwrite: bool
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if keys_or_ids else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if keys_or_ids else None
        _content = None
        if isinstance(keys_or_ids, (IOBase, bytes)):
            _content = keys_or_ids
        else:
            if keys_or_ids is not None:
                _content = json.dumps(keys_or_ids, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_search_indexer_reset_documents_request(
            name=name,
            overwrite=overwrite,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def run_indexer(self, name: str, **kwargs: Any) -> None:
        """Runs an indexer on-demand.

        :param name: The name of the indexer. Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_indexer_run_indexer_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def _create_or_update_indexer(
        self,
        name: str,
        indexer: _models2.SearchIndexer,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexer: ...
    @overload
    async def _create_or_update_indexer(
        self,
        name: str,
        indexer: JSON,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexer: ...
    @overload
    async def _create_or_update_indexer(
        self,
        name: str,
        indexer: IO[bytes],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexer: ...

    @distributed_trace_async
    async def _create_or_update_indexer(
        self,
        name: str,
        indexer: Union[_models2.SearchIndexer, JSON, IO[bytes]],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexer:
        """Creates a new indexer or updates an indexer if it already exists.

        :param name: The name of the indexer. Required.
        :type name: str
        :param indexer: The definition of the indexer to create or update. Is one of the following
         types: SearchIndexer, JSON, IO[bytes] Required.
        :type indexer: ~azure.search.documents.indexes.models.SearchIndexer or JSON or IO[bytes]
        :keyword skip_indexer_reset_requirement_for_cache: Ignores cache reset requirements. Default
         value is None.
        :paramtype skip_indexer_reset_requirement_for_cache: bool
        :keyword disable_cache_reprocessing_change_detection: Disables cache reprocessing change
         detection. Default value is None.
        :paramtype disable_cache_reprocessing_change_detection: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(indexer, (IOBase, bytes)):
            _content = indexer
        else:
            _content = json.dumps(indexer, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_or_update_indexer_request(
            name=name,
            skip_indexer_reset_requirement_for_cache=skip_indexer_reset_requirement_for_cache,
            disable_cache_reprocessing_change_detection=disable_cache_reprocessing_change_detection,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexer, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_indexer(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes an indexer.

        :param name: The name of the indexer. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_indexer_delete_indexer_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_indexer(self, name: str, **kwargs: Any) -> _models2.SearchIndexer:
        """Retrieves an indexer definition.

        :param name: The name of the indexer. Required.
        :type name: str
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchIndexer] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_indexer_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexer, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _get_indexers(
        self, *, select: Optional[list[str]] = None, **kwargs: Any
    ) -> _models2._models.ListIndexersResult:
        """Lists all indexers available for a search service.

        :keyword select: Selects which top-level properties to retrieve. Specified as a comma-separated
         list of JSON property names, or '*' for all properties. The default is all properties. Default
         value is None.
        :paramtype select: list[str]
        :return: ListIndexersResult. The ListIndexersResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models._models.ListIndexersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2._models.ListIndexersResult] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_indexers_request(
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models2._models.ListIndexersResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_indexer(
        self, indexer: _models2.SearchIndexer, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexer:
        """Creates a new indexer.

        :param indexer: The definition of the indexer to create. Required.
        :type indexer: ~azure.search.documents.indexes.models.SearchIndexer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_indexer(
        self, indexer: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexer:
        """Creates a new indexer.

        :param indexer: The definition of the indexer to create. Required.
        :type indexer: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_indexer(
        self, indexer: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexer:
        """Creates a new indexer.

        :param indexer: The definition of the indexer to create. Required.
        :type indexer: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_indexer(
        self, indexer: Union[_models2.SearchIndexer, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SearchIndexer:
        """Creates a new indexer.

        :param indexer: The definition of the indexer to create. Is one of the following types:
         SearchIndexer, JSON, IO[bytes] Required.
        :type indexer: ~azure.search.documents.indexes.models.SearchIndexer or JSON or IO[bytes]
        :return: SearchIndexer. The SearchIndexer is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(indexer, (IOBase, bytes)):
            _content = indexer
        else:
            _content = json.dumps(indexer, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_indexer_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexer, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_indexer_status(self, name: str, **kwargs: Any) -> _models2.SearchIndexerStatus:
        """Returns the current status and execution history of an indexer.

        :param name: The name of the indexer. Required.
        :type name: str
        :return: SearchIndexerStatus. The SearchIndexerStatus is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchIndexerStatus] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_indexer_status_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _create_or_update_skillset(
        self,
        name: str,
        skillset: _models2.SearchIndexerSkillset,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerSkillset: ...
    @overload
    async def _create_or_update_skillset(
        self,
        name: str,
        skillset: JSON,
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerSkillset: ...
    @overload
    async def _create_or_update_skillset(
        self,
        name: str,
        skillset: IO[bytes],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerSkillset: ...

    @distributed_trace_async
    async def _create_or_update_skillset(
        self,
        name: str,
        skillset: Union[_models2.SearchIndexerSkillset, JSON, IO[bytes]],
        *,
        skip_indexer_reset_requirement_for_cache: Optional[bool] = None,
        disable_cache_reprocessing_change_detection: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models2.SearchIndexerSkillset:
        """Creates a new skillset in a search service or updates the skillset if it already exists.

        :param name: The name of the skillset. Required.
        :type name: str
        :param skillset: The skillset containing one or more skills to create or update in a search
         service. Is one of the following types: SearchIndexerSkillset, JSON, IO[bytes] Required.
        :type skillset: ~azure.search.documents.indexes.models.SearchIndexerSkillset or JSON or
         IO[bytes]
        :keyword skip_indexer_reset_requirement_for_cache: Ignores cache reset requirements. Default
         value is None.
        :paramtype skip_indexer_reset_requirement_for_cache: bool
        :keyword disable_cache_reprocessing_change_detection: Disables cache reprocessing change
         detection. Default value is None.
        :paramtype disable_cache_reprocessing_change_detection: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        prefer: Literal["return=representation"] = kwargs.pop("prefer", _headers.pop("Prefer", "return=representation"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexerSkillset] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(skillset, (IOBase, bytes)):
            _content = skillset
        else:
            _content = json.dumps(skillset, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_or_update_skillset_request(
            name=name,
            skip_indexer_reset_requirement_for_cache=skip_indexer_reset_requirement_for_cache,
            disable_cache_reprocessing_change_detection=disable_cache_reprocessing_change_detection,
            etag=etag,
            match_condition=match_condition,
            prefer=prefer,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerSkillset, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _delete_skillset(
        self, name: str, *, etag: Optional[str] = None, match_condition: Optional[MatchConditions] = None, **kwargs: Any
    ) -> None:
        """Deletes a skillset in a search service.

        :param name: The name of the skillset. Required.
        :type name: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_search_indexer_delete_skillset_request(
            name=name,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_skillset(self, name: str, **kwargs: Any) -> _models2.SearchIndexerSkillset:
        """Retrieves a skillset in a search service.

        :param name: The name of the skillset. Required.
        :type name: str
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2.SearchIndexerSkillset] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_skillset_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerSkillset, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def _get_skillsets(
        self, *, select: Optional[list[str]] = None, **kwargs: Any
    ) -> _models2._models.ListSkillsetsResult:
        """List all skillsets in a search service.

        :keyword select: Selects which top-level properties to retrieve. Specified as a comma-separated
         list of JSON property names, or '*' for all properties. The default is all properties. Default
         value is None.
        :paramtype select: list[str]
        :return: ListSkillsetsResult. The ListSkillsetsResult is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models._models.ListSkillsetsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models2._models.ListSkillsetsResult] = kwargs.pop("cls", None)

        _request = build_search_indexer_get_skillsets_request(
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models2._models.ListSkillsetsResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_skillset(
        self, skillset: _models2.SearchIndexerSkillset, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexerSkillset:
        """Creates a new skillset in a search service.

        :param skillset: The skillset containing one or more skills to create in a search service.
         Required.
        :type skillset: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_skillset(
        self, skillset: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexerSkillset:
        """Creates a new skillset in a search service.

        :param skillset: The skillset containing one or more skills to create in a search service.
         Required.
        :type skillset: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_skillset(
        self, skillset: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models2.SearchIndexerSkillset:
        """Creates a new skillset in a search service.

        :param skillset: The skillset containing one or more skills to create in a search service.
         Required.
        :type skillset: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_skillset(
        self, skillset: Union[_models2.SearchIndexerSkillset, JSON, IO[bytes]], **kwargs: Any
    ) -> _models2.SearchIndexerSkillset:
        """Creates a new skillset in a search service.

        :param skillset: The skillset containing one or more skills to create in a search service. Is
         one of the following types: SearchIndexerSkillset, JSON, IO[bytes] Required.
        :type skillset: ~azure.search.documents.indexes.models.SearchIndexerSkillset or JSON or
         IO[bytes]
        :return: SearchIndexerSkillset. The SearchIndexerSkillset is compatible with MutableMapping
        :rtype: ~azure.search.documents.indexes.models.SearchIndexerSkillset
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.SearchIndexerSkillset] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(skillset, (IOBase, bytes)):
            _content = skillset
        else:
            _content = json.dumps(skillset, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_create_skillset_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.SearchIndexerSkillset, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _reset_skills(
        self, name: str, skill_names: _models2.SkillNames, *, content_type: str = "application/json", **kwargs: Any
    ) -> None: ...
    @overload
    async def _reset_skills(
        self, name: str, skill_names: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None: ...
    @overload
    async def _reset_skills(
        self, name: str, skill_names: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None: ...

    @distributed_trace_async
    async def _reset_skills(
        self, name: str, skill_names: Union[_models2.SkillNames, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Reset an existing skillset in a search service.

        :param name: The name of the skillset. Required.
        :type name: str
        :param skill_names: The names of the skills to reset. If not specified, all skills in the
         skillset will be reset. Is one of the following types: SkillNames, JSON, IO[bytes] Required.
        :type skill_names: ~azure.search.documents.indexes.models.SkillNames or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(skill_names, (IOBase, bytes)):
            _content = skill_names
        else:
            _content = json.dumps(skill_names, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_search_indexer_reset_skills_request(
            name=name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
