# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdminCredentials(_Model):
    """Credentials of administrator users for source and target servers.

    :ivar source_server_password: Password for the user of the source server. Required.
    :vartype source_server_password: str
    :ivar target_server_password: Password for the user of the target server. Required.
    :vartype target_server_password: str
    """

    source_server_password: str = rest_field(name="sourceServerPassword", visibility=["create", "update"])
    """Password for the user of the source server. Required."""
    target_server_password: str = rest_field(name="targetServerPassword", visibility=["create", "update"])
    """Password for the user of the target server. Required."""

    @overload
    def __init__(
        self,
        *,
        source_server_password: str,
        target_server_password: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdminCredentialsForPatch(_Model):
    """Credentials of administrator users for source and target servers.

    :ivar source_server_password: Password for the user of the source server.
    :vartype source_server_password: str
    :ivar target_server_password: Password for the user of the target server.
    :vartype target_server_password: str
    """

    source_server_password: Optional[str] = rest_field(name="sourceServerPassword", visibility=["update"])
    """Password for the user of the source server."""
    target_server_password: Optional[str] = rest_field(name="targetServerPassword", visibility=["update"])
    """Password for the user of the target server."""

    @overload
    def __init__(
        self,
        *,
        source_server_password: Optional[str] = None,
        target_server_password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    """


class AdministratorMicrosoftEntra(ProxyResource):
    """Server administrator associated to a Microsoft Entra principal.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a server administrator associated to a Microsoft Entra
     principal. Required.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.AdministratorMicrosoftEntraProperties
    """

    properties: "_models.AdministratorMicrosoftEntraProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a server administrator associated to a Microsoft Entra principal. Required."""

    __flattened_items = ["principal_type", "principal_name", "object_id", "tenant_id"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.AdministratorMicrosoftEntraProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AdministratorMicrosoftEntraAdd(_Model):
    """Server administrator associated to a Microsoft Entra principal.

    :ivar properties: Properties of the server administrator associated to a Microsoft Entra
     principal.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.AdministratorMicrosoftEntraPropertiesForAdd
    """

    properties: Optional["_models.AdministratorMicrosoftEntraPropertiesForAdd"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the server administrator associated to a Microsoft Entra principal."""

    __flattened_items = ["principal_type", "principal_name", "tenant_id"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AdministratorMicrosoftEntraPropertiesForAdd"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AdministratorMicrosoftEntraProperties(_Model):
    """Properties of a server administrator associated to a Microsoft Entra principal.

    :ivar principal_type: Type of Microsoft Entra principal to which the server administrator is
     associated. Known values are: "Unknown", "User", "Group", and "ServicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.postgresqlflexibleservers.models.PrincipalType
    :ivar principal_name: Name of the Microsoft Entra principal.
    :vartype principal_name: str
    :ivar object_id: Object identifier of the Microsoft Entra principal.
    :vartype object_id: str
    :ivar tenant_id: Identifier of the tenant in which the Microsoft Entra principal exists.
    :vartype tenant_id: str
    """

    principal_type: Optional[Union[str, "_models.PrincipalType"]] = rest_field(
        name="principalType", visibility=["read", "create", "update"]
    )
    """Type of Microsoft Entra principal to which the server administrator is associated. Known values
     are: \"Unknown\", \"User\", \"Group\", and \"ServicePrincipal\"."""
    principal_name: Optional[str] = rest_field(name="principalName", visibility=["read", "create", "update"])
    """Name of the Microsoft Entra principal."""
    object_id: Optional[str] = rest_field(name="objectId", visibility=["read", "create", "update"])
    """Object identifier of the Microsoft Entra principal."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update"])
    """Identifier of the tenant in which the Microsoft Entra principal exists."""

    @overload
    def __init__(
        self,
        *,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        principal_name: Optional[str] = None,
        object_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdministratorMicrosoftEntraPropertiesForAdd(_Model):  # pylint: disable=name-too-long
    """Properties of a server administrator associated to a Microsoft Entra principal.

    :ivar principal_type: Type of Microsoft Entra principal to which the server administrator is
     associated. Known values are: "Unknown", "User", "Group", and "ServicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.postgresqlflexibleservers.models.PrincipalType
    :ivar principal_name: Name of the Microsoft Entra principal.
    :vartype principal_name: str
    :ivar tenant_id: Identifier of the tenant in which the Microsoft Entra principal exists.
    :vartype tenant_id: str
    """

    principal_type: Optional[Union[str, "_models.PrincipalType"]] = rest_field(
        name="principalType", visibility=["read", "create", "update"]
    )
    """Type of Microsoft Entra principal to which the server administrator is associated. Known values
     are: \"Unknown\", \"User\", \"Group\", and \"ServicePrincipal\"."""
    principal_name: Optional[str] = rest_field(name="principalName", visibility=["read", "create", "update"])
    """Name of the Microsoft Entra principal."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["create", "update"])
    """Identifier of the tenant in which the Microsoft Entra principal exists."""

    @overload
    def __init__(
        self,
        *,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        principal_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdvancedThreatProtectionSettingsModel(ProxyResource):
    """Advanced threat protection settings of the server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Advanced threat protection properties.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.AdvancedThreatProtectionSettingsProperties
    """

    properties: Optional["_models.AdvancedThreatProtectionSettingsProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Advanced threat protection properties."""

    __flattened_items = ["state", "creation_time"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AdvancedThreatProtectionSettingsProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AdvancedThreatProtectionSettingsProperties(_Model):  # pylint: disable=name-too-long
    """Properties of advanced threat protection state for a server.

    :ivar state: Specifies the state of the advanced threat protection, whether it is enabled,
     disabled, or a state has not been applied yet on the server. Required. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.ThreatProtectionState
    :ivar creation_time: Specifies the creation time (UTC) of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    state: Union[str, "_models.ThreatProtectionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the state of the advanced threat protection, whether it is enabled, disabled, or a
     state has not been applied yet on the server. Required. Known values are: \"Enabled\" and
     \"Disabled\"."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """Specifies the creation time (UTC) of the policy."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.ThreatProtectionState"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthConfig(_Model):
    """Authentication configuration properties of a server.

    :ivar active_directory_auth: Indicates if the server supports Microsoft Entra authentication.
     Known values are: "Enabled" and "Disabled".
    :vartype active_directory_auth: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MicrosoftEntraAuth
    :ivar password_auth: Indicates if the server supports password based authentication. Known
     values are: "Enabled" and "Disabled".
    :vartype password_auth: str or ~azure.mgmt.postgresqlflexibleservers.models.PasswordBasedAuth
    :ivar tenant_id: Identifier of the tenant of the delegated resource.
    :vartype tenant_id: str
    """

    active_directory_auth: Optional[Union[str, "_models.MicrosoftEntraAuth"]] = rest_field(
        name="activeDirectoryAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the server supports Microsoft Entra authentication. Known values are: \"Enabled\"
     and \"Disabled\"."""
    password_auth: Optional[Union[str, "_models.PasswordBasedAuth"]] = rest_field(
        name="passwordAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the server supports password based authentication. Known values are: \"Enabled\"
     and \"Disabled\"."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the tenant of the delegated resource."""

    @overload
    def __init__(
        self,
        *,
        active_directory_auth: Optional[Union[str, "_models.MicrosoftEntraAuth"]] = None,
        password_auth: Optional[Union[str, "_models.PasswordBasedAuth"]] = None,
        tenant_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthConfigForPatch(_Model):
    """Authentication configuration properties of a server.

    :ivar active_directory_auth: Indicates if the server supports Microsoft Entra authentication.
     Known values are: "Enabled" and "Disabled".
    :vartype active_directory_auth: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MicrosoftEntraAuth
    :ivar password_auth: Indicates if the server supports password based authentication. Known
     values are: "Enabled" and "Disabled".
    :vartype password_auth: str or ~azure.mgmt.postgresqlflexibleservers.models.PasswordBasedAuth
    :ivar tenant_id: Identifier of the tenant of the delegated resource.
    :vartype tenant_id: str
    """

    active_directory_auth: Optional[Union[str, "_models.MicrosoftEntraAuth"]] = rest_field(
        name="activeDirectoryAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the server supports Microsoft Entra authentication. Known values are: \"Enabled\"
     and \"Disabled\"."""
    password_auth: Optional[Union[str, "_models.PasswordBasedAuth"]] = rest_field(
        name="passwordAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the server supports password based authentication. Known values are: \"Enabled\"
     and \"Disabled\"."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the tenant of the delegated resource."""

    @overload
    def __init__(
        self,
        *,
        active_directory_auth: Optional[Union[str, "_models.MicrosoftEntraAuth"]] = None,
        password_auth: Optional[Union[str, "_models.PasswordBasedAuth"]] = None,
        tenant_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Backup(_Model):
    """Backup properties of a server.

    :ivar backup_retention_days: Backup retention days for the server.
    :vartype backup_retention_days: int
    :ivar geo_redundant_backup: Indicates if the server is configured to create geographically
     redundant backups. Known values are: "Enabled" and "Disabled".
    :vartype geo_redundant_backup: str or
     ~azure.mgmt.postgresqlflexibleservers.models.GeographicallyRedundantBackup
    :ivar earliest_restore_date: Earliest restore point time (ISO8601 format) for a server.
    :vartype earliest_restore_date: ~datetime.datetime
    """

    backup_retention_days: Optional[int] = rest_field(
        name="backupRetentionDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup retention days for the server."""
    geo_redundant_backup: Optional[Union[str, "_models.GeographicallyRedundantBackup"]] = rest_field(
        name="geoRedundantBackup", visibility=["read", "create"]
    )
    """Indicates if the server is configured to create geographically redundant backups. Known values
     are: \"Enabled\" and \"Disabled\"."""
    earliest_restore_date: Optional[datetime.datetime] = rest_field(
        name="earliestRestoreDate", visibility=["read"], format="rfc3339"
    )
    """Earliest restore point time (ISO8601 format) for a server."""

    @overload
    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
        geo_redundant_backup: Optional[Union[str, "_models.GeographicallyRedundantBackup"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupAutomaticAndOnDemand(ProxyResource):
    """Properties of a backup.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a backup.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.BackupAutomaticAndOnDemandProperties
    """

    properties: Optional["_models.BackupAutomaticAndOnDemandProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a backup."""

    __flattened_items = ["backup_type", "completed_time", "source"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BackupAutomaticAndOnDemandProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupAutomaticAndOnDemandProperties(_Model):
    """Properties of a backup.

    :ivar backup_type: Type of backup. Known values are: "Full" and "Customer On-Demand".
    :vartype backup_type: str or ~azure.mgmt.postgresqlflexibleservers.models.BackupType
    :ivar completed_time: Time(ISO8601 format) at which the backup was completed.
    :vartype completed_time: ~datetime.datetime
    :ivar source: Source of the backup.
    :vartype source: str
    """

    backup_type: Optional[Union[str, "_models.BackupType"]] = rest_field(
        name="backupType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of backup. Known values are: \"Full\" and \"Customer On-Demand\"."""
    completed_time: Optional[datetime.datetime] = rest_field(
        name="completedTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time(ISO8601 format) at which the backup was completed."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source of the backup."""

    @overload
    def __init__(
        self,
        *,
        backup_type: Optional[Union[str, "_models.BackupType"]] = None,
        completed_time: Optional[datetime.datetime] = None,
        source: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupForPatch(_Model):
    """Backup properties of a server.

    :ivar backup_retention_days: Backup retention days for the server.
    :vartype backup_retention_days: int
    :ivar geo_redundant_backup: Indicates if the server is configured to create geographically
     redundant backups. Known values are: "Enabled" and "Disabled".
    :vartype geo_redundant_backup: str or
     ~azure.mgmt.postgresqlflexibleservers.models.GeographicallyRedundantBackup
    :ivar earliest_restore_date: Earliest restore point time (ISO8601 format) for a server.
    :vartype earliest_restore_date: ~datetime.datetime
    """

    backup_retention_days: Optional[int] = rest_field(
        name="backupRetentionDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup retention days for the server."""
    geo_redundant_backup: Optional[Union[str, "_models.GeographicallyRedundantBackup"]] = rest_field(
        name="geoRedundantBackup", visibility=["read"]
    )
    """Indicates if the server is configured to create geographically redundant backups. Known values
     are: \"Enabled\" and \"Disabled\"."""
    earliest_restore_date: Optional[datetime.datetime] = rest_field(
        name="earliestRestoreDate", visibility=["read"], format="rfc3339"
    )
    """Earliest restore point time (ISO8601 format) for a server."""

    @overload
    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupRequestBase(_Model):
    """BackupRequestBase is the base for all backup request.

    :ivar backup_settings: Backup Settings. Required.
    :vartype backup_settings: ~azure.mgmt.postgresqlflexibleservers.models.BackupSettings
    """

    backup_settings: "_models.BackupSettings" = rest_field(
        name="backupSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Settings. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_settings: "_models.BackupSettings",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupSettings(_Model):
    """The settings for the long term backup.

    :ivar backup_name: Backup Name for the current backup. Required.
    :vartype backup_name: str
    """

    backup_name: str = rest_field(name="backupName", visibility=["read", "create", "update", "delete", "query"])
    """Backup Name for the current backup. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupsLongTermRetentionOperation(ProxyResource):
    """Response for the LTR backup Operation API call.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Long Term Retention Backup Operation Resource Properties.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.LtrBackupOperationResponseProperties
    """

    properties: Optional["_models.LtrBackupOperationResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Long Term Retention Backup Operation Resource Properties."""

    __flattened_items = [
        "datasource_size_in_bytes",
        "data_transferred_in_bytes",
        "backup_name",
        "backup_metadata",
        "status",
        "start_time",
        "end_time",
        "percent_complete",
        "error_code",
        "error_message",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.LtrBackupOperationResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupsLongTermRetentionRequest(BackupRequestBase):
    """The request that is made for a long term retention backup.

    :ivar backup_settings: Backup Settings. Required.
    :vartype backup_settings: ~azure.mgmt.postgresqlflexibleservers.models.BackupSettings
    :ivar target_details: Backup store detail for target server. Required.
    :vartype target_details: ~azure.mgmt.postgresqlflexibleservers.models.BackupStoreDetails
    """

    target_details: "_models.BackupStoreDetails" = rest_field(
        name="targetDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup store detail for target server. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_settings: "_models.BackupSettings",
        target_details: "_models.BackupStoreDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupsLongTermRetentionResponse(_Model):
    """Response for the LTR backup API call.

    :ivar properties: Long Term Retention Backup Operation Resource Properties.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.LtrBackupOperationResponseProperties
    """

    properties: Optional["_models.LtrBackupOperationResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Long Term Retention Backup Operation Resource Properties."""

    __flattened_items = [
        "datasource_size_in_bytes",
        "data_transferred_in_bytes",
        "backup_name",
        "backup_metadata",
        "status",
        "start_time",
        "end_time",
        "percent_complete",
        "error_code",
        "error_message",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.LtrBackupOperationResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupsLongTermRetentionResponseProperties(_Model):  # pylint: disable=name-too-long
    """Response for the pre-backup request.

    :ivar number_of_containers: Number of storage containers the plugin will use during backup.
     More than one containers may be used for size limitations, parallelism, or redundancy etc.
     Required.
    :vartype number_of_containers: int
    """

    number_of_containers: int = rest_field(
        name="numberOfContainers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of storage containers the plugin will use during backup. More than one containers may be
     used for size limitations, parallelism, or redundancy etc. Required."""

    @overload
    def __init__(
        self,
        *,
        number_of_containers: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupStoreDetails(_Model):
    """Details about the target where the backup content will be stored.

    :ivar sas_uri_list: List of SAS uri of storage containers where backup data is to be
     streamed/copied. Required.
    :vartype sas_uri_list: list[str]
    """

    sas_uri_list: list[str] = rest_field(name="sasUriList", visibility=["read", "create", "update", "delete", "query"])
    """List of SAS uri of storage containers where backup data is to be streamed/copied. Required."""

    @overload
    def __init__(
        self,
        *,
        sas_uri_list: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapabilityBase(_Model):
    """Base object for representing capability.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    status: Optional[Union[str, "_models.CapabilityStatus"]] = rest_field(visibility=["read"])
    """The status of the capability. Known values are: \"Visible\", \"Available\", \"Default\", and
     \"Disabled\"."""
    reason: Optional[str] = rest_field(visibility=["read"])
    """The reason for the capability not being available."""


class Capability(CapabilityBase):
    """Capability for the Azure Database for PostgreSQL flexible server.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Name of flexible servers capabilities.
    :vartype name: str
    :ivar supported_server_editions: List of supported compute tiers.
    :vartype supported_server_editions:
     list[~azure.mgmt.postgresqlflexibleservers.models.ServerEditionCapability]
    :ivar supported_server_versions: List of supported major versions of PostgreSQL database
     engine.
    :vartype supported_server_versions:
     list[~azure.mgmt.postgresqlflexibleservers.models.ServerVersionCapability]
    :ivar supported_features: Features supported.
    :vartype supported_features:
     list[~azure.mgmt.postgresqlflexibleservers.models.SupportedFeature]
    :ivar fast_provisioning_supported: Indicates if fast provisioning is supported. 'Enabled' means
     fast provisioning is supported. 'Disabled' stands for fast provisioning is not supported. Will
     be deprecated in the future. Look to Supported Features for 'FastProvisioning'. Known values
     are: "Enabled" and "Disabled".
    :vartype fast_provisioning_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.FastProvisioningSupport
    :ivar supported_fast_provisioning_editions: List of compute tiers supporting fast provisioning.
    :vartype supported_fast_provisioning_editions:
     list[~azure.mgmt.postgresqlflexibleservers.models.FastProvisioningEditionCapability]
    :ivar geo_backup_supported: Indicates if geographically redundant backups are supported in this
     location. 'Enabled' means geographically redundant backups are supported. 'Disabled' stands for
     geographically redundant backup is not supported. Will be deprecated in the future. Look to
     Supported Features for 'GeoBackup'. Known values are: "Enabled" and "Disabled".
    :vartype geo_backup_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.GeographicallyRedundantBackupSupport
    :ivar zone_redundant_ha_supported: Indicates if high availability with zone redundancy is
     supported in this location. 'Enabled' means high availability with zone redundancy is
     supported. 'Disabled' stands for high availability with zone redundancy is not supported. Will
     be deprecated in the future. Look to Supported Features for  'ZoneRedundantHa'. Known values
     are: "Enabled" and "Disabled".
    :vartype zone_redundant_ha_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ZoneRedundantHighAvailabilitySupport
    :ivar zone_redundant_ha_and_geo_backup_supported: Indicates if high availability with zone
     redundancy is supported in conjunction with geographically redundant backups in this location.
     'Enabled' means high availability with zone redundancy is supported in conjunction with
     geographically redundant backups is supported. 'Disabled' stands for high availability with
     zone redundancy is supported in conjunction with geographically redundant backups is not
     supported. Will be deprecated in the future. Look to Supported Features for
     'ZoneRedundantHaAndGeoBackup'. Known values are: "Enabled" and "Disabled".
    :vartype zone_redundant_ha_and_geo_backup_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport
    :ivar storage_auto_growth_supported: Indicates if storage autogrow is supported in this
     location. 'Enabled' means storage autogrow is supported. 'Disabled' stands for storage autogrow
     is not supported. Will be deprecated in the future. Look to Supported Features for
     'StorageAutoGrowth'. Known values are: "Enabled" and "Disabled".
    :vartype storage_auto_growth_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.StorageAutoGrowthSupport
    :ivar online_resize_supported: Indicates if resizing the storage, without interrupting the
     operation of the database engine, is supported in this location for the given subscription.
     'Enabled' means resizing the storage without interrupting the operation of the database engine
     is supported. 'Disabled' means resizing the storage without interrupting the operation of the
     database engine is not supported. Will be deprecated in the future. Look to Supported Features
     for 'OnlineResize'. Known values are: "Enabled" and "Disabled".
    :vartype online_resize_supported: str or
     ~azure.mgmt.postgresqlflexibleservers.models.OnlineStorageResizeSupport
    :ivar restricted: Indicates if this location is restricted. 'Enabled' means location is
     restricted. 'Disabled' stands for location is not restricted. Will be deprecated in the future.
     Look to Supported Features for 'Restricted'. Known values are: "Enabled" and "Disabled".
    :vartype restricted: str or ~azure.mgmt.postgresqlflexibleservers.models.LocationRestricted
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of flexible servers capabilities."""
    supported_server_editions: Optional[list["_models.ServerEditionCapability"]] = rest_field(
        name="supportedServerEditions", visibility=["read"]
    )
    """List of supported compute tiers."""
    supported_server_versions: Optional[list["_models.ServerVersionCapability"]] = rest_field(
        name="supportedServerVersions", visibility=["read"]
    )
    """List of supported major versions of PostgreSQL database engine."""
    supported_features: Optional[list["_models.SupportedFeature"]] = rest_field(
        name="supportedFeatures", visibility=["read"]
    )
    """Features supported."""
    fast_provisioning_supported: Optional[Union[str, "_models.FastProvisioningSupport"]] = rest_field(
        name="fastProvisioningSupported", visibility=["read"]
    )
    """Indicates if fast provisioning is supported. 'Enabled' means fast provisioning is supported.
     'Disabled' stands for fast provisioning is not supported. Will be deprecated in the future.
     Look to Supported Features for 'FastProvisioning'. Known values are: \"Enabled\" and
     \"Disabled\"."""
    supported_fast_provisioning_editions: Optional[list["_models.FastProvisioningEditionCapability"]] = rest_field(
        name="supportedFastProvisioningEditions", visibility=["read"]
    )
    """List of compute tiers supporting fast provisioning."""
    geo_backup_supported: Optional[Union[str, "_models.GeographicallyRedundantBackupSupport"]] = rest_field(
        name="geoBackupSupported", visibility=["read"]
    )
    """Indicates if geographically redundant backups are supported in this location. 'Enabled' means
     geographically redundant backups are supported. 'Disabled' stands for geographically redundant
     backup is not supported. Will be deprecated in the future. Look to Supported Features for
     'GeoBackup'. Known values are: \"Enabled\" and \"Disabled\"."""
    zone_redundant_ha_supported: Optional[Union[str, "_models.ZoneRedundantHighAvailabilitySupport"]] = rest_field(
        name="zoneRedundantHaSupported", visibility=["read"]
    )
    """Indicates if high availability with zone redundancy is supported in this location. 'Enabled'
     means high availability with zone redundancy is supported. 'Disabled' stands for high
     availability with zone redundancy is not supported. Will be deprecated in the future. Look to
     Supported Features for  'ZoneRedundantHa'. Known values are: \"Enabled\" and \"Disabled\"."""
    zone_redundant_ha_and_geo_backup_supported: Optional[
        Union[str, "_models.ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport"]
    ] = rest_field(name="zoneRedundantHaAndGeoBackupSupported", visibility=["read"])
    """Indicates if high availability with zone redundancy is supported in conjunction with
     geographically redundant backups in this location. 'Enabled' means high availability with zone
     redundancy is supported in conjunction with geographically redundant backups is supported.
     'Disabled' stands for high availability with zone redundancy is supported in conjunction with
     geographically redundant backups is not supported. Will be deprecated in the future. Look to
     Supported Features for 'ZoneRedundantHaAndGeoBackup'. Known values are: \"Enabled\" and
     \"Disabled\"."""
    storage_auto_growth_supported: Optional[Union[str, "_models.StorageAutoGrowthSupport"]] = rest_field(
        name="storageAutoGrowthSupported", visibility=["read"]
    )
    """Indicates if storage autogrow is supported in this location. 'Enabled' means storage autogrow
     is supported. 'Disabled' stands for storage autogrow is not supported. Will be deprecated in
     the future. Look to Supported Features for 'StorageAutoGrowth'. Known values are: \"Enabled\"
     and \"Disabled\"."""
    online_resize_supported: Optional[Union[str, "_models.OnlineStorageResizeSupport"]] = rest_field(
        name="onlineResizeSupported", visibility=["read"]
    )
    """Indicates if resizing the storage, without interrupting the operation of the database engine,
     is supported in this location for the given subscription. 'Enabled' means resizing the storage
     without interrupting the operation of the database engine is supported. 'Disabled' means
     resizing the storage without interrupting the operation of the database engine is not
     supported. Will be deprecated in the future. Look to Supported Features for 'OnlineResize'.
     Known values are: \"Enabled\" and \"Disabled\"."""
    restricted: Optional[Union[str, "_models.LocationRestricted"]] = rest_field(visibility=["read"])
    """Indicates if this location is restricted. 'Enabled' means location is restricted. 'Disabled'
     stands for location is not restricted. Will be deprecated in the future. Look to Supported
     Features for 'Restricted'. Known values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapturedLog(ProxyResource):
    """Log file.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a log file.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.CapturedLogProperties
    """

    properties: Optional["_models.CapturedLogProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a log file."""

    __flattened_items = ["created_time", "last_modified_time", "size_in_kb", "type", "url"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CapturedLogProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CapturedLogProperties(_Model):
    """Properties of a log file.

    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: ~datetime.datetime
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: ~datetime.datetime
    :ivar size_in_kb: Size (in KB) of the log file.
    :vartype size_in_kb: int
    :ivar type: Type of log file. Can be 'ServerLogs' or 'UpgradeLogs'.
    :vartype type: str
    :ivar url: URL to download the log file from.
    :vartype url: str
    """

    created_time: Optional[datetime.datetime] = rest_field(
        name="createdTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation timestamp of the log file."""
    last_modified_time: Optional[datetime.datetime] = rest_field(
        name="lastModifiedTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Last modified timestamp of the log file."""
    size_in_kb: Optional[int] = rest_field(name="sizeInKb", visibility=["read", "create", "update", "delete", "query"])
    """Size (in KB) of the log file."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of log file. Can be 'ServerLogs' or 'UpgradeLogs'."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to download the log file from."""

    @overload
    def __init__(
        self,
        *,
        created_time: Optional[datetime.datetime] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        size_in_kb: Optional[int] = None,
        type: Optional[str] = None,
        url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityRequest(_Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the resource for which availability needs to be checked."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource type."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResponse(_Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or
     ~azure.mgmt.postgresqlflexibleservers.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the resource name is available."""
    reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The reason why the given name is not available. Known values are: \"Invalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed reason why the given name is not available."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Cluster(_Model):
    """Cluster properties of a server.

    :ivar cluster_size: Number of nodes assigned to the elastic cluster.
    :vartype cluster_size: int
    :ivar default_database_name: Default database name for the elastic cluster.
    :vartype default_database_name: str
    """

    cluster_size: Optional[int] = rest_field(
        name="clusterSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of nodes assigned to the elastic cluster."""
    default_database_name: Optional[str] = rest_field(
        name="defaultDatabaseName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default database name for the elastic cluster."""

    @overload
    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        default_database_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Configuration(ProxyResource):
    """Configuration (also known as server parameter).

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a configuration (also known as server parameter).
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.ConfigurationProperties
    """

    properties: Optional["_models.ConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a configuration (also known as server parameter)."""

    __flattened_items = [
        "value",
        "description",
        "default_value",
        "data_type",
        "allowed_values",
        "source",
        "is_dynamic_config",
        "is_read_only",
        "is_config_pending_restart",
        "unit",
        "documentation_link",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ConfigurationForUpdate(_Model):
    """Configuration (also known as server parameter).

    :ivar properties: Properties of a configuration (also known as server parameter).
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.ConfigurationProperties
    """

    properties: Optional["_models.ConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a configuration (also known as server parameter)."""

    __flattened_items = [
        "value",
        "description",
        "default_value",
        "data_type",
        "allowed_values",
        "source",
        "is_dynamic_config",
        "is_read_only",
        "is_config_pending_restart",
        "unit",
        "documentation_link",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ConfigurationProperties(_Model):
    """Properties of a configuration (also known as server parameter).

    :ivar value: Value of the configuration (also known as server parameter). Required to update
     the value assigned to a specific modifiable configuration.
    :vartype value: str
    :ivar description: Description of the configuration (also known as server parameter).
    :vartype description: str
    :ivar default_value: Value assigned by default to the configuration (also known as server
     parameter).
    :vartype default_value: str
    :ivar data_type: Data type of the configuration (also known as server parameter). Known values
     are: "Boolean", "Numeric", "Integer", "Enumeration", "String", and "Set".
    :vartype data_type: str or ~azure.mgmt.postgresqlflexibleservers.models.ConfigurationDataType
    :ivar allowed_values: Allowed values of the configuration (also known as server parameter).
    :vartype allowed_values: str
    :ivar source: Source of the value assigned to the configuration (also known as server
     parameter). Required to update the value assigned to a specific modifiable configuration.
    :vartype source: str
    :ivar is_dynamic_config: Indicates if it's a dynamic (true) or static (false) configuration
     (also known as server parameter). Static server parameters require a server restart after
     changing the value assigned to them, for the change to take effect. Dynamic server parameters
     do not require a server restart after changing the value assigned to them, for the change to
     take effect.
    :vartype is_dynamic_config: bool
    :ivar is_read_only: Indicates if it's a read-only (true) or modifiable (false) configuration
     (also known as server parameter).
    :vartype is_read_only: bool
    :ivar is_config_pending_restart: Indicates if the value assigned to the configuration (also
     known as server parameter) is pending a server restart for it to take effect.
    :vartype is_config_pending_restart: bool
    :ivar unit: Units in which the configuration (also known as server parameter) value is
     expressed.
    :vartype unit: str
    :ivar documentation_link: Link pointing to the documentation of the configuration (also known
     as server parameter).
    :vartype documentation_link: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Value of the configuration (also known as server parameter). Required to update the value
     assigned to a specific modifiable configuration."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the configuration (also known as server parameter)."""
    default_value: Optional[str] = rest_field(name="defaultValue", visibility=["read"])
    """Value assigned by default to the configuration (also known as server parameter)."""
    data_type: Optional[Union[str, "_models.ConfigurationDataType"]] = rest_field(name="dataType", visibility=["read"])
    """Data type of the configuration (also known as server parameter). Known values are: \"Boolean\",
     \"Numeric\", \"Integer\", \"Enumeration\", \"String\", and \"Set\"."""
    allowed_values: Optional[str] = rest_field(name="allowedValues", visibility=["read"])
    """Allowed values of the configuration (also known as server parameter)."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source of the value assigned to the configuration (also known as server parameter). Required to
     update the value assigned to a specific modifiable configuration."""
    is_dynamic_config: Optional[bool] = rest_field(name="isDynamicConfig", visibility=["read"])
    """Indicates if it's a dynamic (true) or static (false) configuration (also known as server
     parameter). Static server parameters require a server restart after changing the value assigned
     to them, for the change to take effect. Dynamic server parameters do not require a server
     restart after changing the value assigned to them, for the change to take effect."""
    is_read_only: Optional[bool] = rest_field(name="isReadOnly", visibility=["read"])
    """Indicates if it's a read-only (true) or modifiable (false) configuration (also known as server
     parameter)."""
    is_config_pending_restart: Optional[bool] = rest_field(name="isConfigPendingRestart", visibility=["read"])
    """Indicates if the value assigned to the configuration (also known as server parameter) is
     pending a server restart for it to take effect."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """Units in which the configuration (also known as server parameter) value is expressed."""
    documentation_link: Optional[str] = rest_field(name="documentationLink", visibility=["read"])
    """Link pointing to the documentation of the configuration (also known as server parameter)."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        source: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Database(ProxyResource):
    """Represents a database.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a database.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.DatabaseProperties
    """

    properties: Optional["_models.DatabaseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a database."""

    __flattened_items = ["charset", "collation"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DatabaseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DatabaseMigrationState(_Model):
    """Migration state of a database.

    :ivar database_name: Name of database.
    :vartype database_name: str
    :ivar migration_state: Migration state of a database. Known values are: "InProgress",
     "WaitingForCutoverTrigger", "Failed", "Canceled", "Succeeded", and "Canceling".
    :vartype migration_state: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationDatabaseState
    :ivar migration_operation: Migration operation of a database.
    :vartype migration_operation: str
    :ivar started_on: Start time of a migration state.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: End time of a migration state.
    :vartype ended_on: ~datetime.datetime
    :ivar full_load_queued_tables: Number of tables queued for the migration of a database.
    :vartype full_load_queued_tables: int
    :ivar full_load_errored_tables: Number of tables encountering errors during the migration of a
     database.
    :vartype full_load_errored_tables: int
    :ivar full_load_loading_tables: Number of tables loading during the migration of a database.
    :vartype full_load_loading_tables: int
    :ivar full_load_completed_tables: Number of tables loaded during the migration of a database.
    :vartype full_load_completed_tables: int
    :ivar cdc_update_counter: Change Data Capture update counter.
    :vartype cdc_update_counter: int
    :ivar cdc_delete_counter: Change Data Capture delete counter.
    :vartype cdc_delete_counter: int
    :ivar cdc_insert_counter: Change Data Capture insert counter.
    :vartype cdc_insert_counter: int
    :ivar applied_changes: Change Data Capture applied changes counter.
    :vartype applied_changes: int
    :ivar incoming_changes: Change Data Capture incoming changes counter.
    :vartype incoming_changes: int
    :ivar latency: Lag in seconds between source and target during online phase.
    :vartype latency: int
    :ivar message: Error message, if any, for the migration state.
    :vartype message: str
    """

    database_name: Optional[str] = rest_field(
        name="databaseName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of database."""
    migration_state: Optional[Union[str, "_models.MigrationDatabaseState"]] = rest_field(
        name="migrationState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration state of a database. Known values are: \"InProgress\", \"WaitingForCutoverTrigger\",
     \"Failed\", \"Canceled\", \"Succeeded\", and \"Canceling\"."""
    migration_operation: Optional[str] = rest_field(
        name="migrationOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration operation of a database."""
    started_on: Optional[datetime.datetime] = rest_field(
        name="startedOn", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of a migration state."""
    ended_on: Optional[datetime.datetime] = rest_field(
        name="endedOn", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of a migration state."""
    full_load_queued_tables: Optional[int] = rest_field(
        name="fullLoadQueuedTables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of tables queued for the migration of a database."""
    full_load_errored_tables: Optional[int] = rest_field(
        name="fullLoadErroredTables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of tables encountering errors during the migration of a database."""
    full_load_loading_tables: Optional[int] = rest_field(
        name="fullLoadLoadingTables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of tables loading during the migration of a database."""
    full_load_completed_tables: Optional[int] = rest_field(
        name="fullLoadCompletedTables", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of tables loaded during the migration of a database."""
    cdc_update_counter: Optional[int] = rest_field(
        name="cdcUpdateCounter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Change Data Capture update counter."""
    cdc_delete_counter: Optional[int] = rest_field(
        name="cdcDeleteCounter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Change Data Capture delete counter."""
    cdc_insert_counter: Optional[int] = rest_field(
        name="cdcInsertCounter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Change Data Capture insert counter."""
    applied_changes: Optional[int] = rest_field(
        name="appliedChanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """Change Data Capture applied changes counter."""
    incoming_changes: Optional[int] = rest_field(
        name="incomingChanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """Change Data Capture incoming changes counter."""
    latency: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Lag in seconds between source and target during online phase."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message, if any, for the migration state."""

    @overload
    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        migration_state: Optional[Union[str, "_models.MigrationDatabaseState"]] = None,
        migration_operation: Optional[str] = None,
        started_on: Optional[datetime.datetime] = None,
        ended_on: Optional[datetime.datetime] = None,
        full_load_queued_tables: Optional[int] = None,
        full_load_errored_tables: Optional[int] = None,
        full_load_loading_tables: Optional[int] = None,
        full_load_completed_tables: Optional[int] = None,
        cdc_update_counter: Optional[int] = None,
        cdc_delete_counter: Optional[int] = None,
        cdc_insert_counter: Optional[int] = None,
        applied_changes: Optional[int] = None,
        incoming_changes: Optional[int] = None,
        latency: Optional[int] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatabaseProperties(_Model):
    """Properties of a database.

    :ivar charset: Character set of the database.
    :vartype charset: str
    :ivar collation: Collation of the database.
    :vartype collation: str
    """

    charset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Character set of the database."""
    collation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Collation of the database."""

    @overload
    def __init__(
        self,
        *,
        charset: Optional[str] = None,
        collation: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataEncryption(_Model):
    """Data encryption properties of a server.

    :ivar primary_key_uri: URI of the key in Azure Key Vault used for data encryption of the
     primary storage associated to a server.
    :vartype primary_key_uri: str
    :ivar primary_user_assigned_identity_id: Identifier of the user assigned managed identity used
     to access the key in Azure Key Vault for data encryption of the primary storage associated to a
     server.
    :vartype primary_user_assigned_identity_id: str
    :ivar geo_backup_key_uri: Identifier of the user assigned managed identity used to access the
     key in Azure Key Vault for data encryption of the geographically redundant storage associated
     to a server that is configured to support geographically redundant backups.
    :vartype geo_backup_key_uri: str
    :ivar geo_backup_user_assigned_identity_id: Identifier of the user assigned managed identity
     used to access the key in Azure Key Vault for data encryption of the geographically redundant
     storage associated to a server that is configured to support geographically redundant backups.
    :vartype geo_backup_user_assigned_identity_id: str
    :ivar type: Data encryption type used by a server. Known values are: "SystemManaged" and
     "AzureKeyVault".
    :vartype type: str or ~azure.mgmt.postgresqlflexibleservers.models.DataEncryptionType
    :ivar primary_encryption_key_status: Status of key used by a server configured with data
     encryption based on customer managed key, to encrypt the primary storage associated to the
     server. Known values are: "Valid" and "Invalid".
    :vartype primary_encryption_key_status: str or
     ~azure.mgmt.postgresqlflexibleservers.models.EncryptionKeyStatus
    :ivar geo_backup_encryption_key_status: Status of key used by a server configured with data
     encryption based on customer managed key, to encrypt the geographically redundant storage
     associated to the server when it is configured to support geographically redundant backups.
     Known values are: "Valid" and "Invalid".
    :vartype geo_backup_encryption_key_status: str or
     ~azure.mgmt.postgresqlflexibleservers.models.EncryptionKeyStatus
    """

    primary_key_uri: Optional[str] = rest_field(
        name="primaryKeyURI", visibility=["read", "create", "update", "delete", "query"]
    )
    """URI of the key in Azure Key Vault used for data encryption of the primary storage associated to
     a server."""
    primary_user_assigned_identity_id: Optional[str] = rest_field(
        name="primaryUserAssignedIdentityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the user assigned managed identity used to access the key in Azure Key Vault for
     data encryption of the primary storage associated to a server."""
    geo_backup_key_uri: Optional[str] = rest_field(
        name="geoBackupKeyURI", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the user assigned managed identity used to access the key in Azure Key Vault for
     data encryption of the geographically redundant storage associated to a server that is
     configured to support geographically redundant backups."""
    geo_backup_user_assigned_identity_id: Optional[str] = rest_field(
        name="geoBackupUserAssignedIdentityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the user assigned managed identity used to access the key in Azure Key Vault for
     data encryption of the geographically redundant storage associated to a server that is
     configured to support geographically redundant backups."""
    type: Optional[Union[str, "_models.DataEncryptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Data encryption type used by a server. Known values are: \"SystemManaged\" and
     \"AzureKeyVault\"."""
    primary_encryption_key_status: Optional[Union[str, "_models.EncryptionKeyStatus"]] = rest_field(
        name="primaryEncryptionKeyStatus", visibility=["read"]
    )
    """Status of key used by a server configured with data encryption based on customer managed key,
     to encrypt the primary storage associated to the server. Known values are: \"Valid\" and
     \"Invalid\"."""
    geo_backup_encryption_key_status: Optional[Union[str, "_models.EncryptionKeyStatus"]] = rest_field(
        name="geoBackupEncryptionKeyStatus", visibility=["read"]
    )
    """Status of key used by a server configured with data encryption based on customer managed key,
     to encrypt the geographically redundant storage associated to the server when it is configured
     to support geographically redundant backups. Known values are: \"Valid\" and \"Invalid\"."""

    @overload
    def __init__(
        self,
        *,
        primary_key_uri: Optional[str] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        geo_backup_key_uri: Optional[str] = None,
        geo_backup_user_assigned_identity_id: Optional[str] = None,
        type: Optional[Union[str, "_models.DataEncryptionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbLevelValidationStatus(_Model):
    """Validation status summary for a database.

    :ivar database_name: Name of database.
    :vartype database_name: str
    :ivar started_on: Start time of a database level validation.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: End time of a database level validation.
    :vartype ended_on: ~datetime.datetime
    :ivar summary: Summary of database level validations.
    :vartype summary: list[~azure.mgmt.postgresqlflexibleservers.models.ValidationSummaryItem]
    """

    database_name: Optional[str] = rest_field(
        name="databaseName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of database."""
    started_on: Optional[datetime.datetime] = rest_field(
        name="startedOn", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of a database level validation."""
    ended_on: Optional[datetime.datetime] = rest_field(
        name="endedOn", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of a database level validation."""
    summary: Optional[list["_models.ValidationSummaryItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Summary of database level validations."""

    @overload
    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        started_on: Optional[datetime.datetime] = None,
        ended_on: Optional[datetime.datetime] = None,
        summary: Optional[list["_models.ValidationSummaryItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbServerMetadata(_Model):
    """Database server metadata.

    :ivar location: Location of database server.
    :vartype location: str
    :ivar version: Major version of PostgreSQL database engine.
    :vartype version: str
    :ivar storage_mb: Storage size (in MB) for database server.
    :vartype storage_mb: int
    :ivar sku: Compute tier and size of the database server. This object is empty for an Azure
     Database for PostgreSQL single server.
    :vartype sku: ~azure.mgmt.postgresqlflexibleservers.models.ServerSku
    """

    location: Optional[str] = rest_field(visibility=["read"])
    """Location of database server."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Major version of PostgreSQL database engine."""
    storage_mb: Optional[int] = rest_field(name="storageMb", visibility=["read", "create", "update", "delete", "query"])
    """Storage size (in MB) for database server."""
    sku: Optional["_models.ServerSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Compute tier and size of the database server. This object is empty for an Azure Database for
     PostgreSQL single server."""

    @overload
    def __init__(
        self,
        *,
        version: Optional[str] = None,
        storage_mb: Optional[int] = None,
        sku: Optional["_models.ServerSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DelegatedSubnetUsage(_Model):
    """Delegated subnet usage data.

    :ivar subnet_name: Name of the delegated subnet for which IP addresses are in use.
    :vartype subnet_name: str
    :ivar usage: Number of IP addresses used by the delegated subnet.
    :vartype usage: int
    """

    subnet_name: Optional[str] = rest_field(name="subnetName", visibility=["read"])
    """Name of the delegated subnet for which IP addresses are in use."""
    usage: Optional[int] = rest_field(visibility=["read"])
    """Number of IP addresses used by the delegated subnet."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.postgresqlflexibleservers.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.postgresqlflexibleservers.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.postgresqlflexibleservers.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FastProvisioningEditionCapability(CapabilityBase):
    """Capability of a fast provisioning compute tier.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar supported_tier: Compute tier supporting fast provisioning.
    :vartype supported_tier: str
    :ivar supported_sku: Compute name (SKU) supporting fast provisioning.
    :vartype supported_sku: str
    :ivar supported_storage_gb: Storage size (in GB) supporting fast provisioning.
    :vartype supported_storage_gb: int
    :ivar supported_server_versions: Major version of PostgreSQL database engine supporting fast
     provisioning.
    :vartype supported_server_versions: str
    :ivar server_count: Count of servers in cache matching this specification.
    :vartype server_count: int
    """

    supported_tier: Optional[str] = rest_field(name="supportedTier", visibility=["read"])
    """Compute tier supporting fast provisioning."""
    supported_sku: Optional[str] = rest_field(name="supportedSku", visibility=["read"])
    """Compute name (SKU) supporting fast provisioning."""
    supported_storage_gb: Optional[int] = rest_field(name="supportedStorageGb", visibility=["read"])
    """Storage size (in GB) supporting fast provisioning."""
    supported_server_versions: Optional[str] = rest_field(name="supportedServerVersions", visibility=["read"])
    """Major version of PostgreSQL database engine supporting fast provisioning."""
    server_count: Optional[int] = rest_field(name="serverCount", visibility=["read"])
    """Count of servers in cache matching this specification."""


class FirewallRule(ProxyResource):
    """Firewall rule.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of a firewall rule. Required.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.FirewallRuleProperties
    """

    properties: "_models.FirewallRuleProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a firewall rule. Required."""

    __flattened_items = ["start_ip_address", "end_ip_address"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.FirewallRuleProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FirewallRuleProperties(_Model):
    """Properties of a firewall rule.

    :ivar start_ip_address: IP address defining the start of the range of addresses of a firewall
     rule. Must be expressed in IPv4 format. Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: IP address defining the end of the range of addresses of a firewall rule.
     Must be expressed in IPv4 format. Required.
    :vartype end_ip_address: str
    """

    start_ip_address: str = rest_field(
        name="startIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """IP address defining the start of the range of addresses of a firewall rule. Must be expressed
     in IPv4 format. Required."""
    end_ip_address: str = rest_field(name="endIpAddress", visibility=["read", "create", "update", "delete", "query"])
    """IP address defining the end of the range of addresses of a firewall rule. Must be expressed in
     IPv4 format. Required."""

    @overload
    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HighAvailability(_Model):
    """High availability properties of a server.

    :ivar mode: High availability mode for a server. Known values are: "Disabled", "ZoneRedundant",
     and "SameZone".
    :vartype mode: str or
     ~azure.mgmt.postgresqlflexibleservers.models.PostgreSqlFlexibleServerHighAvailabilityMode
    :ivar state: Possible states of the standby server created when high availability is set to
     SameZone or ZoneRedundant. Known values are: "NotEnabled", "CreatingStandby",
     "ReplicatingData", "FailingOver", "Healthy", and "RemovingStandby".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.HighAvailabilityState
    :ivar standby_availability_zone: Availability zone associated to the standby server created
     when high availability is set to SameZone or ZoneRedundant.
    :vartype standby_availability_zone: str
    """

    mode: Optional[Union[str, "_models.PostgreSqlFlexibleServerHighAvailabilityMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """High availability mode for a server. Known values are: \"Disabled\", \"ZoneRedundant\", and
     \"SameZone\"."""
    state: Optional[Union[str, "_models.HighAvailabilityState"]] = rest_field(visibility=["read"])
    """Possible states of the standby server created when high availability is set to SameZone or
     ZoneRedundant. Known values are: \"NotEnabled\", \"CreatingStandby\", \"ReplicatingData\",
     \"FailingOver\", \"Healthy\", and \"RemovingStandby\"."""
    standby_availability_zone: Optional[str] = rest_field(
        name="standbyAvailabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Availability zone associated to the standby server created when high availability is set to
     SameZone or ZoneRedundant."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.PostgreSqlFlexibleServerHighAvailabilityMode"]] = None,
        standby_availability_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HighAvailabilityForPatch(_Model):
    """High availability properties of a server.

    :ivar mode: High availability mode for a server. Known values are: "Disabled", "ZoneRedundant",
     and "SameZone".
    :vartype mode: str or
     ~azure.mgmt.postgresqlflexibleservers.models.PostgreSqlFlexibleServerHighAvailabilityMode
    :ivar state: Possible states of the standby server created when high availability is set to
     SameZone or ZoneRedundant. Known values are: "NotEnabled", "CreatingStandby",
     "ReplicatingData", "FailingOver", "Healthy", and "RemovingStandby".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.HighAvailabilityState
    :ivar standby_availability_zone: Availability zone associated to the standby server created
     when high availability is set to SameZone or ZoneRedundant.
    :vartype standby_availability_zone: str
    """

    mode: Optional[Union[str, "_models.PostgreSqlFlexibleServerHighAvailabilityMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """High availability mode for a server. Known values are: \"Disabled\", \"ZoneRedundant\", and
     \"SameZone\"."""
    state: Optional[Union[str, "_models.HighAvailabilityState"]] = rest_field(visibility=["read"])
    """Possible states of the standby server created when high availability is set to SameZone or
     ZoneRedundant. Known values are: \"NotEnabled\", \"CreatingStandby\", \"ReplicatingData\",
     \"FailingOver\", \"Healthy\", and \"RemovingStandby\"."""
    standby_availability_zone: Optional[str] = rest_field(
        name="standbyAvailabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Availability zone associated to the standby server created when high availability is set to
     SameZone or ZoneRedundant."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.PostgreSqlFlexibleServerHighAvailabilityMode"]] = None,
        standby_availability_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImpactRecord(_Model):
    """Impact on some metric if this recommended action is applied.

    :ivar dimension_name: Dimension name.
    :vartype dimension_name: str
    :ivar unit: Dimension unit.
    :vartype unit: str
    :ivar query_id: Optional property that can be used to store the identifier of the query, if the
     metric is for a specific query.
    :vartype query_id: int
    :ivar absolute_value: Absolute value.
    :vartype absolute_value: float
    """

    dimension_name: Optional[str] = rest_field(
        name="dimensionName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Dimension name."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Dimension unit."""
    query_id: Optional[int] = rest_field(name="queryId", visibility=["read", "create", "update", "delete", "query"])
    """Optional property that can be used to store the identifier of the query, if the metric is for a
     specific query."""
    absolute_value: Optional[float] = rest_field(
        name="absoluteValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Absolute value."""

    @overload
    def __init__(
        self,
        *,
        dimension_name: Optional[str] = None,
        unit: Optional[str] = None,
        query_id: Optional[int] = None,
        absolute_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogSpecification(_Model):
    """Log specification for an operation.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Display name of the log.
    :vartype display_name: str
    :ivar blob_duration: Blob duration for the log.
    :vartype blob_duration: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the log."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the log."""
    blob_duration: Optional[str] = rest_field(
        name="blobDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Blob duration for the log."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LtrBackupOperationResponseProperties(_Model):
    """Response for the backup request.

    :ivar datasource_size_in_bytes: Size of datasource in bytes.
    :vartype datasource_size_in_bytes: int
    :ivar data_transferred_in_bytes: Data transferred in bytes.
    :vartype data_transferred_in_bytes: int
    :ivar backup_name: Name of Backup operation.
    :vartype backup_name: str
    :ivar backup_metadata: Metadata to be stored in RP. Store everything that will be required to
     perform a successful restore using this Recovery point. e.g. Versions, DataFormat etc.
    :vartype backup_metadata: str
    :ivar status: Service-set extensible enum indicating the status of operation. Required. Known
     values are: "Running", "Cancelled", "Failed", and "Succeeded".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.ExecutionStatus
    :ivar start_time: Start time of the operation. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: PercentageCompleted.
    :vartype percent_complete: float
    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    """

    datasource_size_in_bytes: Optional[int] = rest_field(
        name="datasourceSizeInBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of datasource in bytes."""
    data_transferred_in_bytes: Optional[int] = rest_field(
        name="dataTransferredInBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data transferred in bytes."""
    backup_name: Optional[str] = rest_field(
        name="backupName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of Backup operation."""
    backup_metadata: Optional[str] = rest_field(
        name="backupMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metadata to be stored in RP. Store everything that will be required to perform a successful
     restore using this Recovery point. e.g. Versions, DataFormat etc."""
    status: Union[str, "_models.ExecutionStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Service-set extensible enum indicating the status of operation. Required. Known values are:
     \"Running\", \"Cancelled\", \"Failed\", and \"Succeeded\"."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time of the operation. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time of the operation."""
    percent_complete: Optional[float] = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """PercentageCompleted."""
    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read"])
    """The error code."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """The error message."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.ExecutionStatus"],
        start_time: datetime.datetime,
        datasource_size_in_bytes: Optional[int] = None,
        data_transferred_in_bytes: Optional[int] = None,
        backup_name: Optional[str] = None,
        backup_metadata: Optional[str] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LtrPreBackupRequest(BackupRequestBase):
    """A request that is made for pre-backup.

    :ivar backup_settings: Backup Settings. Required.
    :vartype backup_settings: ~azure.mgmt.postgresqlflexibleservers.models.BackupSettings
    """

    @overload
    def __init__(
        self,
        *,
        backup_settings: "_models.BackupSettings",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LtrPreBackupResponse(_Model):
    """Response for the LTR pre-backup API call.

    :ivar properties: Additional Properties for the pre backup response. Required.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.BackupsLongTermRetentionResponseProperties
    """

    properties: "_models.BackupsLongTermRetentionResponseProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Properties for the pre backup response. Required."""

    __flattened_items = ["number_of_containers"]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.BackupsLongTermRetentionResponseProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MaintenanceWindow(_Model):
    """Maintenance window properties of a server.

    :ivar custom_window: Indicates whether custom window is enabled or disabled.
    :vartype custom_window: str
    :ivar start_hour: Start hour to be used for maintenance window.
    :vartype start_hour: int
    :ivar start_minute: Start minute to be used for maintenance window.
    :vartype start_minute: int
    :ivar day_of_week: Day of the week to be used for maintenance window.
    :vartype day_of_week: int
    """

    custom_window: Optional[str] = rest_field(
        name="customWindow", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether custom window is enabled or disabled."""
    start_hour: Optional[int] = rest_field(name="startHour", visibility=["read", "create", "update", "delete", "query"])
    """Start hour to be used for maintenance window."""
    start_minute: Optional[int] = rest_field(
        name="startMinute", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start minute to be used for maintenance window."""
    day_of_week: Optional[int] = rest_field(
        name="dayOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Day of the week to be used for maintenance window."""

    @overload
    def __init__(
        self,
        *,
        custom_window: Optional[str] = None,
        start_hour: Optional[int] = None,
        start_minute: Optional[int] = None,
        day_of_week: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceWindowForPatch(_Model):
    """Maintenance window properties of a server.

    :ivar custom_window: Indicates whether custom window is enabled or disabled.
    :vartype custom_window: str
    :ivar start_hour: Start hour to be used for maintenance window.
    :vartype start_hour: int
    :ivar start_minute: Start minute to be used for maintenance window.
    :vartype start_minute: int
    :ivar day_of_week: Day of the week to be used for maintenance window.
    :vartype day_of_week: int
    """

    custom_window: Optional[str] = rest_field(
        name="customWindow", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether custom window is enabled or disabled."""
    start_hour: Optional[int] = rest_field(name="startHour", visibility=["read", "create", "update", "delete", "query"])
    """Start hour to be used for maintenance window."""
    start_minute: Optional[int] = rest_field(
        name="startMinute", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start minute to be used for maintenance window."""
    day_of_week: Optional[int] = rest_field(
        name="dayOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Day of the week to be used for maintenance window."""

    @overload
    def __init__(
        self,
        *,
        custom_window: Optional[str] = None,
        start_hour: Optional[int] = None,
        start_minute: Optional[int] = None,
        day_of_week: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricSpecification(_Model):
    """Metric specification for an operation.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Display name of the metric.
    :vartype display_name: str
    :ivar display_description: Display description of the metric.
    :vartype display_description: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar aggregation_type: Aggregation type of the metric.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: Supported aggregation types for the metric.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: Supported time grain types for the metric.
    :vartype supported_time_grain_types: list[str]
    :ivar category: Category of the metric.
    :vartype category: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the metric."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the metric."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display description of the metric."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of the metric."""
    aggregation_type: Optional[str] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Aggregation type of the metric."""
    supported_aggregation_types: Optional[list[str]] = rest_field(
        name="supportedAggregationTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Supported aggregation types for the metric."""
    supported_time_grain_types: Optional[list[str]] = rest_field(
        name="supportedTimeGrainTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Supported time grain types for the metric."""
    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Category of the metric."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[list[str]] = None,
        supported_time_grain_types: Optional[list[str]] = None,
        category: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrateNetworkStatus(_Model):
    """The status of a network migration operation.

    :ivar subscription_id: The ID of the subscription.
    :vartype subscription_id: str
    :ivar resource_group_name: The name of the resource group.
    :vartype resource_group_name: str
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar state: The state of the network migration operation. Known values are: "Pending",
     "InProgress", "Succeeded", "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.NetworkMigrationState
    """

    subscription_id: Optional[str] = rest_field(
        name="subscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the subscription."""
    resource_group_name: Optional[str] = rest_field(
        name="resourceGroupName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the resource group."""
    server_name: Optional[str] = rest_field(
        name="serverName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the server."""
    state: Optional[Union[str, "_models.NetworkMigrationState"]] = rest_field(visibility=["read"])
    """The state of the network migration operation. Known values are: \"Pending\", \"InProgress\",
     \"Succeeded\", \"Failed\", \"CancelInProgress\", and \"Cancelled\"."""

    @overload
    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        server_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Migration(TrackedResource):
    """Properties of a migration.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Migration properties.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.MigrationProperties
    """

    properties: Optional["_models.MigrationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration properties."""

    __flattened_items = [
        "migration_id",
        "current_status",
        "migration_instance_resource_id",
        "migration_mode",
        "migration_option",
        "source_type",
        "ssl_mode",
        "source_db_server_metadata",
        "target_db_server_metadata",
        "source_db_server_resource_id",
        "source_db_server_fully_qualified_domain_name",
        "target_db_server_resource_id",
        "target_db_server_fully_qualified_domain_name",
        "secret_parameters",
        "dbs_to_migrate",
        "setup_logical_replication_on_source_db_if_needed",
        "overwrite_dbs_in_target",
        "migration_window_start_time_in_utc",
        "migration_window_end_time_in_utc",
        "migrate_roles",
        "start_data_migration",
        "trigger_cutover",
        "dbs_to_trigger_cutover_on",
        "cancel",
        "dbs_to_cancel_migration_on",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MigrationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MigrationNameAvailability(_Model):
    """Availability of a migration name.

    :ivar name: Name of the migration to check for validity and availability. Required.
    :vartype name: str
    :ivar type: Type of resource. Required.
    :vartype type: str
    :ivar name_available: Indicates if the migration name is available.
    :vartype name_available: bool
    :ivar reason: Migration name availability reason. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationNameAvailabilityReason
    :ivar message: Migration name availability message.
    :vartype message: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the migration to check for validity and availability. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of resource. Required."""
    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """Indicates if the migration name is available."""
    reason: Optional[Union[str, "_models.MigrationNameAvailabilityReason"]] = rest_field(visibility=["read"])
    """Migration name availability reason. Known values are: \"Invalid\" and \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Migration name availability message."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrationProperties(_Model):
    """Migration.

    :ivar migration_id: Identifier of a migration.
    :vartype migration_id: str
    :ivar current_status: Current status of a migration.
    :vartype current_status: ~azure.mgmt.postgresqlflexibleservers.models.MigrationStatus
    :ivar migration_instance_resource_id: Identifier of the private endpoint migration instance.
    :vartype migration_instance_resource_id: str
    :ivar migration_mode: Mode used to perform the migration: Online or Offline. Known values are:
     "Offline" and "Online".
    :vartype migration_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.MigrationMode
    :ivar migration_option: Supported option for a migration. Known values are: "Validate",
     "Migrate", and "ValidateAndMigrate".
    :vartype migration_option: str or ~azure.mgmt.postgresqlflexibleservers.models.MigrationOption
    :ivar source_type: Source server type used for the migration: ApsaraDB_RDS, AWS, AWS_AURORA,
     AWS_EC2, AWS_RDS, AzureVM, Crunchy_PostgreSQL, Digital_Ocean_Droplets,
     Digital_Ocean_PostgreSQL, EDB, EDB_Oracle_Server, EDB_PostgreSQL, GCP, GCP_AlloyDB,
     GCP_CloudSQL, GCP_Compute, Heroku_PostgreSQL, Huawei_Compute, Huawei_RDS, OnPremises,
     PostgreSQLCosmosDB, PostgreSQLFlexibleServer, PostgreSQLSingleServer, or Supabase_PostgreSQL.
     Known values are: "OnPremises", "AWS", "GCP", "AzureVM", "PostgreSQLSingleServer", "AWS_RDS",
     "AWS_AURORA", "AWS_EC2", "GCP_CloudSQL", "GCP_AlloyDB", "GCP_Compute", "EDB",
     "EDB_Oracle_Server", "EDB_PostgreSQL", "PostgreSQLFlexibleServer", "PostgreSQLCosmosDB",
     "Huawei_RDS", "Huawei_Compute", "Heroku_PostgreSQL", "Crunchy_PostgreSQL", "ApsaraDB_RDS",
     "Digital_Ocean_Droplets", "Digital_Ocean_PostgreSQL", and "Supabase_PostgreSQL".
    :vartype source_type: str or ~azure.mgmt.postgresqlflexibleservers.models.SourceType
    :ivar ssl_mode: SSL mode used by a migration. Default SSL mode for 'PostgreSQLSingleServer' is
     'VerifyFull'. Default SSL mode for other source types is 'Prefer'. Known values are: "Prefer",
     "Require", "VerifyCA", and "VerifyFull".
    :vartype ssl_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.SslMode
    :ivar source_db_server_metadata: Metadata of source database server.
    :vartype source_db_server_metadata:
     ~azure.mgmt.postgresqlflexibleservers.models.DbServerMetadata
    :ivar target_db_server_metadata: Metadata of target database server.
    :vartype target_db_server_metadata:
     ~azure.mgmt.postgresqlflexibleservers.models.DbServerMetadata
    :ivar source_db_server_resource_id: Identifier of the source database server resource, when
     'sourceType' is 'PostgreSQLSingleServer'. For other source types this must be set to
     ipaddress:port@username or hostname:port@username.
    :vartype source_db_server_resource_id: str
    :ivar source_db_server_fully_qualified_domain_name: Fully qualified domain name (FQDN) or IP
     address of the source server. This property is optional. When provided, the migration service
     will always use it to connect to the source server.
    :vartype source_db_server_fully_qualified_domain_name: str
    :ivar target_db_server_resource_id: Identifier of the target database server resource.
    :vartype target_db_server_resource_id: str
    :ivar target_db_server_fully_qualified_domain_name: Fully qualified domain name (FQDN) or IP
     address of the target server. This property is optional. When provided, the migration service
     will always use it to connect to the target server.
    :vartype target_db_server_fully_qualified_domain_name: str
    :ivar secret_parameters: Migration secret parameters.
    :vartype secret_parameters:
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationSecretParameters
    :ivar dbs_to_migrate: Names of databases to migrate.
    :vartype dbs_to_migrate: list[str]
    :ivar setup_logical_replication_on_source_db_if_needed: Indicates whether to setup logical
     replication on source server, if needed. Known values are: "True" and "False".
    :vartype setup_logical_replication_on_source_db_if_needed: str or
     ~azure.mgmt.postgresqlflexibleservers.models.LogicalReplicationOnSourceServer
    :ivar overwrite_dbs_in_target: Indicates if databases on the target server can be overwritten
     when already present. If set to 'False', when the migration workflow detects that the database
     already exists on the target server, it will wait for a confirmation. Known values are: "True"
     and "False".
    :vartype overwrite_dbs_in_target: str or
     ~azure.mgmt.postgresqlflexibleservers.models.OverwriteDatabasesOnTargetServer
    :ivar migration_window_start_time_in_utc: Start time (UTC) for migration window.
    :vartype migration_window_start_time_in_utc: ~datetime.datetime
    :ivar migration_window_end_time_in_utc: End time (UTC) for migration window.
    :vartype migration_window_end_time_in_utc: ~datetime.datetime
    :ivar migrate_roles: Indicates if roles and permissions must be migrated. Known values are:
     "True" and "False".
    :vartype migrate_roles: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MigrateRolesAndPermissions
    :ivar start_data_migration: Indicates if data migration must start right away. Known values
     are: "True" and "False".
    :vartype start_data_migration: str or
     ~azure.mgmt.postgresqlflexibleservers.models.StartDataMigration
    :ivar trigger_cutover: Indicates if cutover must be triggered for the entire migration. Known
     values are: "True" and "False".
    :vartype trigger_cutover: str or ~azure.mgmt.postgresqlflexibleservers.models.TriggerCutover
    :ivar dbs_to_trigger_cutover_on: When you want to trigger cutover for specific databases set
     'triggerCutover' to 'True' and the names of the specific databases in this array.
    :vartype dbs_to_trigger_cutover_on: list[str]
    :ivar cancel: Indicates if cancel must be triggered for the entire migration. Known values are:
     "True" and "False".
    :vartype cancel: str or ~azure.mgmt.postgresqlflexibleservers.models.Cancel
    :ivar dbs_to_cancel_migration_on: When you want to trigger cancel for specific databases set
     'triggerCutover' to 'True' and the names of the specific databases in this array.
    :vartype dbs_to_cancel_migration_on: list[str]
    """

    migration_id: Optional[str] = rest_field(name="migrationId", visibility=["read"])
    """Identifier of a migration."""
    current_status: Optional["_models.MigrationStatus"] = rest_field(name="currentStatus", visibility=["read"])
    """Current status of a migration."""
    migration_instance_resource_id: Optional[str] = rest_field(
        name="migrationInstanceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the private endpoint migration instance."""
    migration_mode: Optional[Union[str, "_models.MigrationMode"]] = rest_field(
        name="migrationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mode used to perform the migration: Online or Offline. Known values are: \"Offline\" and
     \"Online\"."""
    migration_option: Optional[Union[str, "_models.MigrationOption"]] = rest_field(
        name="migrationOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Supported option for a migration. Known values are: \"Validate\", \"Migrate\", and
     \"ValidateAndMigrate\"."""
    source_type: Optional[Union[str, "_models.SourceType"]] = rest_field(
        name="sourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source server type used for the migration: ApsaraDB_RDS, AWS, AWS_AURORA, AWS_EC2, AWS_RDS,
     AzureVM, Crunchy_PostgreSQL, Digital_Ocean_Droplets, Digital_Ocean_PostgreSQL, EDB,
     EDB_Oracle_Server, EDB_PostgreSQL, GCP, GCP_AlloyDB, GCP_CloudSQL, GCP_Compute,
     Heroku_PostgreSQL, Huawei_Compute, Huawei_RDS, OnPremises, PostgreSQLCosmosDB,
     PostgreSQLFlexibleServer, PostgreSQLSingleServer, or Supabase_PostgreSQL. Known values are:
     \"OnPremises\", \"AWS\", \"GCP\", \"AzureVM\", \"PostgreSQLSingleServer\", \"AWS_RDS\",
     \"AWS_AURORA\", \"AWS_EC2\", \"GCP_CloudSQL\", \"GCP_AlloyDB\", \"GCP_Compute\", \"EDB\",
     \"EDB_Oracle_Server\", \"EDB_PostgreSQL\", \"PostgreSQLFlexibleServer\",
     \"PostgreSQLCosmosDB\", \"Huawei_RDS\", \"Huawei_Compute\", \"Heroku_PostgreSQL\",
     \"Crunchy_PostgreSQL\", \"ApsaraDB_RDS\", \"Digital_Ocean_Droplets\",
     \"Digital_Ocean_PostgreSQL\", and \"Supabase_PostgreSQL\"."""
    ssl_mode: Optional[Union[str, "_models.SslMode"]] = rest_field(
        name="sslMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """SSL mode used by a migration. Default SSL mode for 'PostgreSQLSingleServer' is 'VerifyFull'.
     Default SSL mode for other source types is 'Prefer'. Known values are: \"Prefer\", \"Require\",
     \"VerifyCA\", and \"VerifyFull\"."""
    source_db_server_metadata: Optional["_models.DbServerMetadata"] = rest_field(
        name="sourceDbServerMetadata", visibility=["read"]
    )
    """Metadata of source database server."""
    target_db_server_metadata: Optional["_models.DbServerMetadata"] = rest_field(
        name="targetDbServerMetadata", visibility=["read"]
    )
    """Metadata of target database server."""
    source_db_server_resource_id: Optional[str] = rest_field(
        name="sourceDbServerResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the source database server resource, when 'sourceType' is
     'PostgreSQLSingleServer'. For other source types this must be set to ipaddress:port@username or
     hostname:port@username."""
    source_db_server_fully_qualified_domain_name: Optional[str] = rest_field(
        name="sourceDbServerFullyQualifiedDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified domain name (FQDN) or IP address of the source server. This property is
     optional. When provided, the migration service will always use it to connect to the source
     server."""
    target_db_server_resource_id: Optional[str] = rest_field(name="targetDbServerResourceId", visibility=["read"])
    """Identifier of the target database server resource."""
    target_db_server_fully_qualified_domain_name: Optional[str] = rest_field(
        name="targetDbServerFullyQualifiedDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified domain name (FQDN) or IP address of the target server. This property is
     optional. When provided, the migration service will always use it to connect to the target
     server."""
    secret_parameters: Optional["_models.MigrationSecretParameters"] = rest_field(
        name="secretParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration secret parameters."""
    dbs_to_migrate: Optional[list[str]] = rest_field(
        name="dbsToMigrate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Names of databases to migrate."""
    setup_logical_replication_on_source_db_if_needed: Optional[
        Union[str, "_models.LogicalReplicationOnSourceServer"]
    ] = rest_field(
        name="setupLogicalReplicationOnSourceDbIfNeeded", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether to setup logical replication on source server, if needed. Known values are:
     \"True\" and \"False\"."""
    overwrite_dbs_in_target: Optional[Union[str, "_models.OverwriteDatabasesOnTargetServer"]] = rest_field(
        name="overwriteDbsInTarget", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if databases on the target server can be overwritten when already present. If set to
     'False', when the migration workflow detects that the database already exists on the target
     server, it will wait for a confirmation. Known values are: \"True\" and \"False\"."""
    migration_window_start_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="migrationWindowStartTimeInUtc",
        visibility=["read", "create", "update", "delete", "query"],
        format="rfc3339",
    )
    """Start time (UTC) for migration window."""
    migration_window_end_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="migrationWindowEndTimeInUtc", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time (UTC) for migration window."""
    migrate_roles: Optional[Union[str, "_models.MigrateRolesAndPermissions"]] = rest_field(
        name="migrateRoles", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if roles and permissions must be migrated. Known values are: \"True\" and \"False\"."""
    start_data_migration: Optional[Union[str, "_models.StartDataMigration"]] = rest_field(
        name="startDataMigration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if data migration must start right away. Known values are: \"True\" and \"False\"."""
    trigger_cutover: Optional[Union[str, "_models.TriggerCutover"]] = rest_field(
        name="triggerCutover", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if cutover must be triggered for the entire migration. Known values are: \"True\" and
     \"False\"."""
    dbs_to_trigger_cutover_on: Optional[list[str]] = rest_field(
        name="dbsToTriggerCutoverOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """When you want to trigger cutover for specific databases set 'triggerCutover' to 'True' and the
     names of the specific databases in this array."""
    cancel: Optional[Union[str, "_models.Cancel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if cancel must be triggered for the entire migration. Known values are: \"True\" and
     \"False\"."""
    dbs_to_cancel_migration_on: Optional[list[str]] = rest_field(
        name="dbsToCancelMigrationOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """When you want to trigger cancel for specific databases set 'triggerCutover' to 'True' and the
     names of the specific databases in this array."""

    @overload
    def __init__(
        self,
        *,
        migration_instance_resource_id: Optional[str] = None,
        migration_mode: Optional[Union[str, "_models.MigrationMode"]] = None,
        migration_option: Optional[Union[str, "_models.MigrationOption"]] = None,
        source_type: Optional[Union[str, "_models.SourceType"]] = None,
        ssl_mode: Optional[Union[str, "_models.SslMode"]] = None,
        source_db_server_resource_id: Optional[str] = None,
        source_db_server_fully_qualified_domain_name: Optional[str] = None,
        target_db_server_fully_qualified_domain_name: Optional[str] = None,
        secret_parameters: Optional["_models.MigrationSecretParameters"] = None,
        dbs_to_migrate: Optional[list[str]] = None,
        setup_logical_replication_on_source_db_if_needed: Optional[
            Union[str, "_models.LogicalReplicationOnSourceServer"]
        ] = None,
        overwrite_dbs_in_target: Optional[Union[str, "_models.OverwriteDatabasesOnTargetServer"]] = None,
        migration_window_start_time_in_utc: Optional[datetime.datetime] = None,
        migration_window_end_time_in_utc: Optional[datetime.datetime] = None,
        migrate_roles: Optional[Union[str, "_models.MigrateRolesAndPermissions"]] = None,
        start_data_migration: Optional[Union[str, "_models.StartDataMigration"]] = None,
        trigger_cutover: Optional[Union[str, "_models.TriggerCutover"]] = None,
        dbs_to_trigger_cutover_on: Optional[list[str]] = None,
        cancel: Optional[Union[str, "_models.Cancel"]] = None,
        dbs_to_cancel_migration_on: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrationPropertiesForPatch(_Model):
    """Migration properties.

    :ivar source_db_server_resource_id: Identifier of the source database server resource, when
     'sourceType' is 'PostgreSQLSingleServer'. For other source types this must be set to
     ipaddress:port@username or hostname:port@username.
    :vartype source_db_server_resource_id: str
    :ivar source_db_server_fully_qualified_domain_name: Fully qualified domain name (FQDN) or IP
     address of the source server. This property is optional. When provided, the migration service
     will always use it to connect to the source server.
    :vartype source_db_server_fully_qualified_domain_name: str
    :ivar target_db_server_fully_qualified_domain_name: Fully qualified domain name (FQDN) or IP
     address of the target server. This property is optional. When provided, the migration service
     will always use it to connect to the target server.
    :vartype target_db_server_fully_qualified_domain_name: str
    :ivar secret_parameters: Migration secret parameters.
    :vartype secret_parameters:
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationSecretParametersForPatch
    :ivar dbs_to_migrate: Names of databases to migrate.
    :vartype dbs_to_migrate: list[str]
    :ivar setup_logical_replication_on_source_db_if_needed: Indicates whether to setup logical
     replication on source server, if needed. Known values are: "True" and "False".
    :vartype setup_logical_replication_on_source_db_if_needed: str or
     ~azure.mgmt.postgresqlflexibleservers.models.LogicalReplicationOnSourceServer
    :ivar overwrite_dbs_in_target: Indicates if databases on the target server can be overwritten
     when already present. If set to 'False', when the migration workflow detects that the database
     already exists on the target server, it will wait for a confirmation. Known values are: "True"
     and "False".
    :vartype overwrite_dbs_in_target: str or
     ~azure.mgmt.postgresqlflexibleservers.models.OverwriteDatabasesOnTargetServer
    :ivar migration_window_start_time_in_utc: Start time (UTC) for migration window.
    :vartype migration_window_start_time_in_utc: ~datetime.datetime
    :ivar migrate_roles: Indicates if roles and permissions must be migrated. Known values are:
     "True" and "False".
    :vartype migrate_roles: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MigrateRolesAndPermissions
    :ivar start_data_migration: Indicates if data migration must start right away. Known values
     are: "True" and "False".
    :vartype start_data_migration: str or
     ~azure.mgmt.postgresqlflexibleservers.models.StartDataMigration
    :ivar trigger_cutover: Indicates if cutover must be triggered for the entire migration. Known
     values are: "True" and "False".
    :vartype trigger_cutover: str or ~azure.mgmt.postgresqlflexibleservers.models.TriggerCutover
    :ivar dbs_to_trigger_cutover_on: When you want to trigger cutover for specific databases set
     'triggerCutover' to 'True' and the names of the specific databases in this array.
    :vartype dbs_to_trigger_cutover_on: list[str]
    :ivar cancel: Indicates if cancel must be triggered for the entire migration. Known values are:
     "True" and "False".
    :vartype cancel: str or ~azure.mgmt.postgresqlflexibleservers.models.Cancel
    :ivar dbs_to_cancel_migration_on: When you want to trigger cancel for specific databases set
     'triggerCutover' to 'True' and the names of the specific databases in this array.
    :vartype dbs_to_cancel_migration_on: list[str]
    :ivar migration_mode: Mode used to perform the migration: Online or Offline. Known values are:
     "Offline" and "Online".
    :vartype migration_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.MigrationMode
    """

    source_db_server_resource_id: Optional[str] = rest_field(
        name="sourceDbServerResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the source database server resource, when 'sourceType' is
     'PostgreSQLSingleServer'. For other source types this must be set to ipaddress:port@username or
     hostname:port@username."""
    source_db_server_fully_qualified_domain_name: Optional[str] = rest_field(
        name="sourceDbServerFullyQualifiedDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified domain name (FQDN) or IP address of the source server. This property is
     optional. When provided, the migration service will always use it to connect to the source
     server."""
    target_db_server_fully_qualified_domain_name: Optional[str] = rest_field(
        name="targetDbServerFullyQualifiedDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Fully qualified domain name (FQDN) or IP address of the target server. This property is
     optional. When provided, the migration service will always use it to connect to the target
     server."""
    secret_parameters: Optional["_models.MigrationSecretParametersForPatch"] = rest_field(
        name="secretParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration secret parameters."""
    dbs_to_migrate: Optional[list[str]] = rest_field(
        name="dbsToMigrate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Names of databases to migrate."""
    setup_logical_replication_on_source_db_if_needed: Optional[
        Union[str, "_models.LogicalReplicationOnSourceServer"]
    ] = rest_field(
        name="setupLogicalReplicationOnSourceDbIfNeeded", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether to setup logical replication on source server, if needed. Known values are:
     \"True\" and \"False\"."""
    overwrite_dbs_in_target: Optional[Union[str, "_models.OverwriteDatabasesOnTargetServer"]] = rest_field(
        name="overwriteDbsInTarget", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if databases on the target server can be overwritten when already present. If set to
     'False', when the migration workflow detects that the database already exists on the target
     server, it will wait for a confirmation. Known values are: \"True\" and \"False\"."""
    migration_window_start_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="migrationWindowStartTimeInUtc",
        visibility=["read", "create", "update", "delete", "query"],
        format="rfc3339",
    )
    """Start time (UTC) for migration window."""
    migrate_roles: Optional[Union[str, "_models.MigrateRolesAndPermissions"]] = rest_field(
        name="migrateRoles", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if roles and permissions must be migrated. Known values are: \"True\" and \"False\"."""
    start_data_migration: Optional[Union[str, "_models.StartDataMigration"]] = rest_field(
        name="startDataMigration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if data migration must start right away. Known values are: \"True\" and \"False\"."""
    trigger_cutover: Optional[Union[str, "_models.TriggerCutover"]] = rest_field(
        name="triggerCutover", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if cutover must be triggered for the entire migration. Known values are: \"True\" and
     \"False\"."""
    dbs_to_trigger_cutover_on: Optional[list[str]] = rest_field(
        name="dbsToTriggerCutoverOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """When you want to trigger cutover for specific databases set 'triggerCutover' to 'True' and the
     names of the specific databases in this array."""
    cancel: Optional[Union[str, "_models.Cancel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if cancel must be triggered for the entire migration. Known values are: \"True\" and
     \"False\"."""
    dbs_to_cancel_migration_on: Optional[list[str]] = rest_field(
        name="dbsToCancelMigrationOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """When you want to trigger cancel for specific databases set 'triggerCutover' to 'True' and the
     names of the specific databases in this array."""
    migration_mode: Optional[Union[str, "_models.MigrationMode"]] = rest_field(
        name="migrationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mode used to perform the migration: Online or Offline. Known values are: \"Offline\" and
     \"Online\"."""

    @overload
    def __init__(
        self,
        *,
        source_db_server_resource_id: Optional[str] = None,
        source_db_server_fully_qualified_domain_name: Optional[str] = None,
        target_db_server_fully_qualified_domain_name: Optional[str] = None,
        secret_parameters: Optional["_models.MigrationSecretParametersForPatch"] = None,
        dbs_to_migrate: Optional[list[str]] = None,
        setup_logical_replication_on_source_db_if_needed: Optional[
            Union[str, "_models.LogicalReplicationOnSourceServer"]
        ] = None,
        overwrite_dbs_in_target: Optional[Union[str, "_models.OverwriteDatabasesOnTargetServer"]] = None,
        migration_window_start_time_in_utc: Optional[datetime.datetime] = None,
        migrate_roles: Optional[Union[str, "_models.MigrateRolesAndPermissions"]] = None,
        start_data_migration: Optional[Union[str, "_models.StartDataMigration"]] = None,
        trigger_cutover: Optional[Union[str, "_models.TriggerCutover"]] = None,
        dbs_to_trigger_cutover_on: Optional[list[str]] = None,
        cancel: Optional[Union[str, "_models.Cancel"]] = None,
        dbs_to_cancel_migration_on: Optional[list[str]] = None,
        migration_mode: Optional[Union[str, "_models.MigrationMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrationResourceForPatch(_Model):
    """Migration.

    :ivar properties: Migration properties.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.MigrationPropertiesForPatch
    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.MigrationPropertiesForPatch"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Migration properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application-specific metadata in the form of key-value pairs."""

    __flattened_items = [
        "source_db_server_resource_id",
        "source_db_server_fully_qualified_domain_name",
        "target_db_server_fully_qualified_domain_name",
        "secret_parameters",
        "dbs_to_migrate",
        "setup_logical_replication_on_source_db_if_needed",
        "overwrite_dbs_in_target",
        "migration_window_start_time_in_utc",
        "migrate_roles",
        "start_data_migration",
        "trigger_cutover",
        "dbs_to_trigger_cutover_on",
        "cancel",
        "dbs_to_cancel_migration_on",
        "migration_mode",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.MigrationPropertiesForPatch"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MigrationSecretParameters(_Model):
    """Migration secret parameters.

    :ivar admin_credentials: Credentials of administrator users for source and target servers.
     Required.
    :vartype admin_credentials: ~azure.mgmt.postgresqlflexibleservers.models.AdminCredentials
    :ivar source_server_username: Gets or sets the name of the user for the source server. This
     user doesn't need to be an administrator.
    :vartype source_server_username: str
    :ivar target_server_username: Gets or sets the name of the user for the target server. This
     user doesn't need to be an administrator.
    :vartype target_server_username: str
    """

    admin_credentials: "_models.AdminCredentials" = rest_field(
        name="adminCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials of administrator users for source and target servers. Required."""
    source_server_username: Optional[str] = rest_field(name="sourceServerUsername", visibility=["create", "update"])
    """Gets or sets the name of the user for the source server. This user doesn't need to be an
     administrator."""
    target_server_username: Optional[str] = rest_field(name="targetServerUsername", visibility=["create", "update"])
    """Gets or sets the name of the user for the target server. This user doesn't need to be an
     administrator."""

    @overload
    def __init__(
        self,
        *,
        admin_credentials: "_models.AdminCredentials",
        source_server_username: Optional[str] = None,
        target_server_username: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrationSecretParametersForPatch(_Model):
    """Migration secret parameters.

    :ivar admin_credentials: Credentials of administrator users for source and target servers.
    :vartype admin_credentials:
     ~azure.mgmt.postgresqlflexibleservers.models.AdminCredentialsForPatch
    :ivar source_server_username: Gets or sets the name of the user for the source server. This
     user doesn't need to be an administrator.
    :vartype source_server_username: str
    :ivar target_server_username: Gets or sets the name of the user for the target server. This
     user doesn't need to be an administrator.
    :vartype target_server_username: str
    """

    admin_credentials: Optional["_models.AdminCredentialsForPatch"] = rest_field(
        name="adminCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials of administrator users for source and target servers."""
    source_server_username: Optional[str] = rest_field(name="sourceServerUsername", visibility=["update"])
    """Gets or sets the name of the user for the source server. This user doesn't need to be an
     administrator."""
    target_server_username: Optional[str] = rest_field(name="targetServerUsername", visibility=["update"])
    """Gets or sets the name of the user for the target server. This user doesn't need to be an
     administrator."""

    @overload
    def __init__(
        self,
        *,
        admin_credentials: Optional["_models.AdminCredentialsForPatch"] = None,
        source_server_username: Optional[str] = None,
        target_server_username: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MigrationStatus(_Model):
    """State of migration.

    :ivar state: State of migration. Known values are: "InProgress", "WaitingForUserAction",
     "Canceled", "Failed", "Succeeded", "ValidationFailed", and "CleaningUp".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.MigrationState
    :ivar error: Error message, if any, for the migration state.
    :vartype error: str
    :ivar current_sub_state_details: Current migration sub state details.
    :vartype current_sub_state_details:
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationSubstateDetails
    """

    state: Optional[Union[str, "_models.MigrationState"]] = rest_field(visibility=["read"])
    """State of migration. Known values are: \"InProgress\", \"WaitingForUserAction\", \"Canceled\",
     \"Failed\", \"Succeeded\", \"ValidationFailed\", and \"CleaningUp\"."""
    error: Optional[str] = rest_field(visibility=["read"])
    """Error message, if any, for the migration state."""
    current_sub_state_details: Optional["_models.MigrationSubstateDetails"] = rest_field(
        name="currentSubStateDetails", visibility=["read"]
    )
    """Current migration sub state details."""


class MigrationSubstateDetails(_Model):
    """Details of migration substate.

    :ivar current_sub_state: Substate of migration. Known values are:
     "PerformingPreRequisiteSteps", "WaitingForLogicalReplicationSetupRequestOnSourceDB",
     "WaitingForDBsToMigrateSpecification", "WaitingForTargetDBOverwriteConfirmation",
     "WaitingForDataMigrationScheduling", "WaitingForDataMigrationWindow", "MigratingData",
     "WaitingForCutoverTrigger", "CompletingMigration", "Completed",
     "CancelingRequestedDBMigrations", and "ValidationInProgress".
    :vartype current_sub_state: str or
     ~azure.mgmt.postgresqlflexibleservers.models.MigrationSubstate
    :ivar db_details:
    :vartype db_details: dict[str,
     ~azure.mgmt.postgresqlflexibleservers.models.DatabaseMigrationState]
    :ivar validation_details:
    :vartype validation_details: ~azure.mgmt.postgresqlflexibleservers.models.ValidationDetails
    """

    current_sub_state: Optional[Union[str, "_models.MigrationSubstate"]] = rest_field(
        name="currentSubState", visibility=["read"]
    )
    """Substate of migration. Known values are: \"PerformingPreRequisiteSteps\",
     \"WaitingForLogicalReplicationSetupRequestOnSourceDB\",
     \"WaitingForDBsToMigrateSpecification\", \"WaitingForTargetDBOverwriteConfirmation\",
     \"WaitingForDataMigrationScheduling\", \"WaitingForDataMigrationWindow\", \"MigratingData\",
     \"WaitingForCutoverTrigger\", \"CompletingMigration\", \"Completed\",
     \"CancelingRequestedDBMigrations\", and \"ValidationInProgress\"."""
    db_details: Optional[dict[str, "_models.DatabaseMigrationState"]] = rest_field(
        name="dbDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    validation_details: Optional["_models.ValidationDetails"] = rest_field(
        name="validationDetails", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        db_details: Optional[dict[str, "_models.DatabaseMigrationState"]] = None,
        validation_details: Optional["_models.ValidationDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameAvailabilityModel(CheckNameAvailabilityResponse):
    """Availability of a name.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or
     ~azure.mgmt.postgresqlflexibleservers.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    :ivar name: Name for which validity and availability was checked.
    :vartype name: str
    :ivar type: Type of resource. It can be 'Microsoft.DBforPostgreSQL/flexibleServers' or
     'Microsoft.DBforPostgreSQL/flexibleServers/virtualendpoints'.
    :vartype type: str
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name for which validity and availability was checked."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Type of resource. It can be 'Microsoft.DBforPostgreSQL/flexibleServers' or
     'Microsoft.DBforPostgreSQL/flexibleServers/virtualendpoints'."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameProperty(_Model):
    """Name property for quota usage.

    :ivar value: Name value.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name value."""
    localized_value: Optional[str] = rest_field(
        name="localizedValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized name."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Network(_Model):
    """Network properties of a server.

    :ivar public_network_access: Indicates if public network access is enabled or not. This is only
     supported for servers that are not integrated into a virtual network which is owned and
     provided by customer when server is deployed. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ServerPublicNetworkAccessState
    :ivar delegated_subnet_resource_id: Resource identifier of the delegated subnet. Required
     during creation of a new server, in case you want the server to be integrated into your own
     virtual network. For an update operation, you only have to provide this property if you want to
     change the value assigned for the private DNS zone.
    :vartype delegated_subnet_resource_id: str
    :ivar private_dns_zone_arm_resource_id: Identifier of the private DNS zone. Required during
     creation of a new server, in case you want the server to be integrated into your own virtual
     network. For an update operation, you only have to provide this property if you want to change
     the value assigned for the private DNS zone.
    :vartype private_dns_zone_arm_resource_id: str
    """

    public_network_access: Optional[Union[str, "_models.ServerPublicNetworkAccessState"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if public network access is enabled or not. This is only supported for servers that
     are not integrated into a virtual network which is owned and provided by customer when server
     is deployed. Known values are: \"Enabled\" and \"Disabled\"."""
    delegated_subnet_resource_id: Optional[str] = rest_field(
        name="delegatedSubnetResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource identifier of the delegated subnet. Required during creation of a new server, in case
     you want the server to be integrated into your own virtual network. For an update operation,
     you only have to provide this property if you want to change the value assigned for the private
     DNS zone."""
    private_dns_zone_arm_resource_id: Optional[str] = rest_field(
        name="privateDnsZoneArmResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the private DNS zone. Required during creation of a new server, in case you want
     the server to be integrated into your own virtual network. For an update operation, you only
     have to provide this property if you want to change the value assigned for the private DNS
     zone."""

    @overload
    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.ServerPublicNetworkAccessState"]] = None,
        delegated_subnet_resource_id: Optional[str] = None,
        private_dns_zone_arm_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ObjectRecommendation(ProxyResource):
    """Object recommendation properties.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar kind: Always empty.
    :vartype kind: str
    :ivar properties: Properties of an object recommendation.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.ObjectRecommendationProperties
    """

    kind: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Always empty."""
    properties: Optional["_models.ObjectRecommendationProperties"] = rest_field(visibility=["read"])
    """Properties of an object recommendation."""

    __flattened_items = [
        "initial_recommended_time",
        "last_recommended_time",
        "times_recommended",
        "improved_query_ids",
        "recommendation_reason",
        "current_state",
        "recommendation_type",
        "implementation_details",
        "analyzed_workload",
        "estimated_impact",
        "details",
    ]

    @overload
    def __init__(
        self,
        *,
        kind: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ObjectRecommendationDetails(_Model):
    """Recommendation details for the recommended action.

    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar schema: Schema name.
    :vartype schema: str
    :ivar table: Table name.
    :vartype table: str
    :ivar index_type: Index type.
    :vartype index_type: str
    :ivar index_name: Index name.
    :vartype index_name: str
    :ivar index_columns: Index columns.
    :vartype index_columns: list[str]
    :ivar included_columns: Index included columns.
    :vartype included_columns: list[str]
    """

    database_name: Optional[str] = rest_field(
        name="databaseName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Database name."""
    schema: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Schema name."""
    table: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Table name."""
    index_type: Optional[str] = rest_field(name="indexType", visibility=["read", "create", "update", "delete", "query"])
    """Index type."""
    index_name: Optional[str] = rest_field(name="indexName", visibility=["read", "create", "update", "delete", "query"])
    """Index name."""
    index_columns: Optional[list[str]] = rest_field(
        name="indexColumns", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index columns."""
    included_columns: Optional[list[str]] = rest_field(
        name="includedColumns", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index included columns."""

    @overload
    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        schema: Optional[str] = None,
        table: Optional[str] = None,
        index_type: Optional[str] = None,
        index_name: Optional[str] = None,
        index_columns: Optional[list[str]] = None,
        included_columns: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ObjectRecommendationProperties(_Model):
    """Object recommendation properties.

    :ivar initial_recommended_time: Creation time (UTC) of this recommendation.
    :vartype initial_recommended_time: ~datetime.datetime
    :ivar last_recommended_time: Last time (UTC) that this recommendation was produced.
    :vartype last_recommended_time: ~datetime.datetime
    :ivar times_recommended: Number of times this recommendation has been produced.
    :vartype times_recommended: int
    :ivar improved_query_ids: List of identifiers for all queries identified as targets for
     improvement if the recommendation is applied. The list is only populated for CREATE INDEX
     recommendations.
    :vartype improved_query_ids: list[int]
    :ivar recommendation_reason: Reason for this recommendation.
    :vartype recommendation_reason: str
    :ivar current_state: Current state.
    :vartype current_state: str
    :ivar recommendation_type: Type for this recommendation. Known values are: "CreateIndex",
     "DropIndex", "ReIndex", "AnalyzeTable", and "VacuumTable".
    :vartype recommendation_type: str or
     ~azure.mgmt.postgresqlflexibleservers.models.RecommendationTypeEnum
    :ivar implementation_details: Implementation details for the recommended action.
    :vartype implementation_details:
     ~azure.mgmt.postgresqlflexibleservers.models.ObjectRecommendationPropertiesImplementationDetails
    :ivar analyzed_workload: Workload information for the recommended action.
    :vartype analyzed_workload:
     ~azure.mgmt.postgresqlflexibleservers.models.ObjectRecommendationPropertiesAnalyzedWorkload
    :ivar estimated_impact: Estimated impact of this recommended action.
    :vartype estimated_impact: list[~azure.mgmt.postgresqlflexibleservers.models.ImpactRecord]
    :ivar details: Recommendation details for the recommended action.
    :vartype details: ~azure.mgmt.postgresqlflexibleservers.models.ObjectRecommendationDetails
    """

    initial_recommended_time: Optional[datetime.datetime] = rest_field(
        name="initialRecommendedTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation time (UTC) of this recommendation."""
    last_recommended_time: Optional[datetime.datetime] = rest_field(
        name="lastRecommendedTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Last time (UTC) that this recommendation was produced."""
    times_recommended: Optional[int] = rest_field(
        name="timesRecommended", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of times this recommendation has been produced."""
    improved_query_ids: Optional[list[int]] = rest_field(
        name="improvedQueryIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of identifiers for all queries identified as targets for improvement if the recommendation
     is applied. The list is only populated for CREATE INDEX recommendations."""
    recommendation_reason: Optional[str] = rest_field(
        name="recommendationReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reason for this recommendation."""
    current_state: Optional[str] = rest_field(
        name="currentState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current state."""
    recommendation_type: Optional[Union[str, "_models.RecommendationTypeEnum"]] = rest_field(
        name="recommendationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type for this recommendation. Known values are: \"CreateIndex\", \"DropIndex\", \"ReIndex\",
     \"AnalyzeTable\", and \"VacuumTable\"."""
    implementation_details: Optional["_models.ObjectRecommendationPropertiesImplementationDetails"] = rest_field(
        name="implementationDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Implementation details for the recommended action."""
    analyzed_workload: Optional["_models.ObjectRecommendationPropertiesAnalyzedWorkload"] = rest_field(
        name="analyzedWorkload", visibility=["read", "create", "update", "delete", "query"]
    )
    """Workload information for the recommended action."""
    estimated_impact: Optional[list["_models.ImpactRecord"]] = rest_field(name="estimatedImpact", visibility=["read"])
    """Estimated impact of this recommended action."""
    details: Optional["_models.ObjectRecommendationDetails"] = rest_field(visibility=["read"])
    """Recommendation details for the recommended action."""

    @overload
    def __init__(
        self,
        *,
        initial_recommended_time: Optional[datetime.datetime] = None,
        last_recommended_time: Optional[datetime.datetime] = None,
        times_recommended: Optional[int] = None,
        improved_query_ids: Optional[list[int]] = None,
        recommendation_reason: Optional[str] = None,
        current_state: Optional[str] = None,
        recommendation_type: Optional[Union[str, "_models.RecommendationTypeEnum"]] = None,
        implementation_details: Optional["_models.ObjectRecommendationPropertiesImplementationDetails"] = None,
        analyzed_workload: Optional["_models.ObjectRecommendationPropertiesAnalyzedWorkload"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ObjectRecommendationPropertiesAnalyzedWorkload(_Model):  # pylint: disable=name-too-long
    """Workload information for the recommended action.

    :ivar start_time: Start time (UTC) of the workload analyzed.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time (UTC) of the workload analyzed.
    :vartype end_time: ~datetime.datetime
    :ivar query_count: Number of queries from the workload that were examined to produce this
     recommendation. For DROP INDEX recommendations it's 0 (zero).
    :vartype query_count: int
    """

    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time (UTC) of the workload analyzed."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time (UTC) of the workload analyzed."""
    query_count: Optional[int] = rest_field(
        name="queryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of queries from the workload that were examined to produce this recommendation. For DROP
     INDEX recommendations it's 0 (zero)."""

    @overload
    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        query_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ObjectRecommendationPropertiesImplementationDetails(_Model):  # pylint: disable=name-too-long
    """Implementation details for the recommended action.

    :ivar method: Method of implementation for recommended action.
    :vartype method: str
    :ivar script: Implementation script for the recommended action.
    :vartype script: str
    """

    method: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Method of implementation for recommended action."""
    script: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Implementation script for the recommended action."""

    @overload
    def __init__(
        self,
        *,
        method: Optional[str] = None,
        script: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API operation definition.

    :ivar name: Name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: Localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.postgresqlflexibleservers.models.OperationDisplay
    :ivar is_data_action: Indicates if the operation is a data action.
    :vartype is_data_action: bool
    :ivar origin: Intended executor of the operation. Known values are: "NotSpecified", "user", and
     "system".
    :vartype origin: str or ~azure.mgmt.postgresqlflexibleservers.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.OperationProperties
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the operation being performed on this particular object."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation or action."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the operation is a data action."""
    origin: Optional[Union[str, "_models.OperationOrigin"]] = rest_field(visibility=["read"])
    """Intended executor of the operation. Known values are: \"NotSpecified\", \"user\", and
     \"system\"."""
    properties: Optional["_models.OperationProperties"] = rest_field(visibility=["read"])
    """Additional descriptions for the operation."""

    @overload
    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Display metadata associated with the operation.

    :ivar provider: Name of the resource provider.
    :vartype provider: str
    :ivar resource: Type of resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """Name of the resource provider."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """Type of resource on which the operation is performed."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """Name of the operation."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the operation."""


class OperationProperties(_Model):
    """Additional properties for operation metadata.

    :ivar service_specification: Service specification for the operation.
    :vartype service_specification:
     ~azure.mgmt.postgresqlflexibleservers.models.ServiceSpecification
    """

    service_specification: Optional["_models.ServiceSpecification"] = rest_field(
        name="serviceSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service specification for the operation."""

    @overload
    def __init__(
        self,
        *,
        service_specification: Optional["_models.ServiceSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """The private endpoint resource.

    :ivar id: The resource identifier of the private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier of the private endpoint."""


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["group_ids", "private_endpoint", "private_link_service_connection_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of the private endpoint connection.

    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.postgresqlflexibleservers.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.postgresqlflexibleservers.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.postgresqlflexibleservers.models.PrivateEndpointConnectionProvisioningState
    """

    group_ids: Optional[list[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group ids for the private endpoint resource."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.postgresqlflexibleservers.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaUsage(_Model):
    """Quota usage for servers.

    :ivar name: Name of quota usage for servers.
    :vartype name: ~azure.mgmt.postgresqlflexibleservers.models.NameProperty
    :ivar limit: Quota limit.
    :vartype limit: int
    :ivar unit: Quota unit.
    :vartype unit: str
    :ivar current_value: Current Quota usage value.
    :vartype current_value: int
    :ivar id: Fully qualified ARM resource Id.
    :vartype id: str
    """

    name: Optional["_models.NameProperty"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of quota usage for servers."""
    limit: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Quota limit."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Quota unit."""
    current_value: Optional[int] = rest_field(
        name="currentValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current Quota usage value."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified ARM resource Id."""

    @overload
    def __init__(
        self,
        *,
        name: Optional["_models.NameProperty"] = None,
        limit: Optional[int] = None,
        unit: Optional[str] = None,
        current_value: Optional[int] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Replica(_Model):
    """Replica properties of a server.

    :ivar role: Role of the server in a replication set. Known values are: "None", "Primary",
     "AsyncReplica", and "GeoAsyncReplica".
    :vartype role: str or ~azure.mgmt.postgresqlflexibleservers.models.ReplicationRole
    :ivar capacity: Maximum number of read replicas allowed for a server.
    :vartype capacity: int
    :ivar replication_state: Indicates the replication state of a read replica. This property is
     returned only when the target server is a read replica. Possible  values are Active, Broken,
     Catchup, Provisioning, Reconfiguring, and Updating. Known values are: "Active", "Catchup",
     "Provisioning", "Updating", "Broken", and "Reconfiguring".
    :vartype replication_state: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ReplicationState
    :ivar promote_mode: Type of operation to apply on the read replica. This property is write
     only. Standalone means that the read replica will be promoted to a standalone server, and will
     become a completely independent entity from the replication set. Switchover means that the read
     replica will roles with the primary server. Known values are: "Standalone" and "Switchover".
    :vartype promote_mode: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ReadReplicaPromoteMode
    :ivar promote_option: Data synchronization option to use when processing the operation
     specified in the promoteMode property. This property is write only. Known values are: "Planned"
     and "Forced".
    :vartype promote_option: str or
     ~azure.mgmt.postgresqlflexibleservers.models.ReadReplicaPromoteOption
    """

    role: Optional[Union[str, "_models.ReplicationRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the server in a replication set. Known values are: \"None\", \"Primary\",
     \"AsyncReplica\", and \"GeoAsyncReplica\"."""
    capacity: Optional[int] = rest_field(visibility=["read"])
    """Maximum number of read replicas allowed for a server."""
    replication_state: Optional[Union[str, "_models.ReplicationState"]] = rest_field(
        name="replicationState", visibility=["read"]
    )
    """Indicates the replication state of a read replica. This property is returned only when the
     target server is a read replica. Possible  values are Active, Broken, Catchup, Provisioning,
     Reconfiguring, and Updating. Known values are: \"Active\", \"Catchup\", \"Provisioning\",
     \"Updating\", \"Broken\", and \"Reconfiguring\"."""
    promote_mode: Optional[Union[str, "_models.ReadReplicaPromoteMode"]] = rest_field(
        name="promoteMode", visibility=["update"]
    )
    """Type of operation to apply on the read replica. This property is write only. Standalone means
     that the read replica will be promoted to a standalone server, and will become a completely
     independent entity from the replication set. Switchover means that the read replica will roles
     with the primary server. Known values are: \"Standalone\" and \"Switchover\"."""
    promote_option: Optional[Union[str, "_models.ReadReplicaPromoteOption"]] = rest_field(
        name="promoteOption", visibility=["update"]
    )
    """Data synchronization option to use when processing the operation specified in the promoteMode
     property. This property is write only. Known values are: \"Planned\" and \"Forced\"."""

    @overload
    def __init__(
        self,
        *,
        role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        promote_mode: Optional[Union[str, "_models.ReadReplicaPromoteMode"]] = None,
        promote_option: Optional[Union[str, "_models.ReadReplicaPromoteOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestartParameter(_Model):
    """PostgreSQL database engine restart parameters.

    :ivar restart_with_failover: Indicates if restart the PostgreSQL database engine should
     failover or switch over from primary to standby. This only works if server has high
     availability enabled.
    :vartype restart_with_failover: bool
    :ivar failover_mode: Failover mode. Known values are: "PlannedFailover", "ForcedFailover",
     "PlannedSwitchover", and "ForcedSwitchover".
    :vartype failover_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.FailoverMode
    """

    restart_with_failover: Optional[bool] = rest_field(
        name="restartWithFailover", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if restart the PostgreSQL database engine should failover or switch over from primary
     to standby. This only works if server has high availability enabled."""
    failover_mode: Optional[Union[str, "_models.FailoverMode"]] = rest_field(
        name="failoverMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Failover mode. Known values are: \"PlannedFailover\", \"ForcedFailover\",
     \"PlannedSwitchover\", and \"ForcedSwitchover\"."""

    @overload
    def __init__(
        self,
        *,
        restart_with_failover: Optional[bool] = None,
        failover_mode: Optional[Union[str, "_models.FailoverMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Server(TrackedResource):
    """Properties of a server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of a server.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.ServerProperties
    :ivar sku: Compute tier and size of a server.
    :vartype sku: ~azure.mgmt.postgresqlflexibleservers.models.Sku
    :ivar identity: User assigned managed identities assigned to the server.
    :vartype identity: ~azure.mgmt.postgresqlflexibleservers.models.UserAssignedIdentity
    """

    properties: Optional["_models.ServerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of a server."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Compute tier and size of a server."""
    identity: Optional["_models.UserAssignedIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """User assigned managed identities assigned to the server."""

    __flattened_items = [
        "administrator_login",
        "administrator_login_password",
        "version",
        "minor_version",
        "state",
        "fully_qualified_domain_name",
        "storage",
        "auth_config",
        "data_encryption",
        "backup",
        "network",
        "high_availability",
        "maintenance_window",
        "source_server_resource_id",
        "point_in_time_utc",
        "availability_zone",
        "replication_role",
        "replica_capacity",
        "replica",
        "create_mode",
        "private_endpoint_connections",
        "cluster",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ServerProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.UserAssignedIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ServerEditionCapability(CapabilityBase):
    """Capabilities in terms of compute tier.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Name of compute tier.
    :vartype name: str
    :ivar default_sku_name: Default compute name (SKU) for this computer tier.
    :vartype default_sku_name: str
    :ivar supported_storage_editions: List of storage editions supported by this compute tier and
     compute name.
    :vartype supported_storage_editions:
     list[~azure.mgmt.postgresqlflexibleservers.models.StorageEditionCapability]
    :ivar supported_server_skus: List of supported compute names (SKUs).
    :vartype supported_server_skus:
     list[~azure.mgmt.postgresqlflexibleservers.models.ServerSkuCapability]
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of compute tier."""
    default_sku_name: Optional[str] = rest_field(name="defaultSkuName", visibility=["read"])
    """Default compute name (SKU) for this computer tier."""
    supported_storage_editions: Optional[list["_models.StorageEditionCapability"]] = rest_field(
        name="supportedStorageEditions", visibility=["read"]
    )
    """List of storage editions supported by this compute tier and compute name."""
    supported_server_skus: Optional[list["_models.ServerSkuCapability"]] = rest_field(
        name="supportedServerSkus", visibility=["read"]
    )
    """List of supported compute names (SKUs)."""


class ServerForPatch(_Model):
    """Represents a server to be updated.

    :ivar sku: Compute tier and size of a server.
    :vartype sku: ~azure.mgmt.postgresqlflexibleservers.models.SkuForPatch
    :ivar identity: Describes the identity of the application.
    :vartype identity: ~azure.mgmt.postgresqlflexibleservers.models.UserAssignedIdentity
    :ivar properties: Properties of the server.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.ServerPropertiesForPatch
    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    sku: Optional["_models.SkuForPatch"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Compute tier and size of a server."""
    identity: Optional["_models.UserAssignedIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the identity of the application."""
    properties: Optional["_models.ServerPropertiesForPatch"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the server."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application-specific metadata in the form of key-value pairs."""

    __flattened_items = [
        "administrator_login",
        "administrator_login_password",
        "version",
        "storage",
        "backup",
        "high_availability",
        "maintenance_window",
        "auth_config",
        "data_encryption",
        "availability_zone",
        "create_mode",
        "replication_role",
        "replica",
        "network",
        "cluster",
    ]

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.SkuForPatch"] = None,
        identity: Optional["_models.UserAssignedIdentity"] = None,
        properties: Optional["_models.ServerPropertiesForPatch"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ServerProperties(_Model):
    """Properties of a server.

    :ivar administrator_login: Name of the login designated as the first password based
     administrator assigned to your instance of PostgreSQL. Must be specified the first time that
     you enable password based authentication on a server. Once set to a given value, it cannot be
     changed for the rest of the life of a server. If you disable password based authentication on a
     server which had it enabled, this password based role isn't deleted.
    :vartype administrator_login: str
    :ivar administrator_login_password: Password assigned to the administrator login. As long as
     password authentication is enabled, this password can be changed at any time.
    :vartype administrator_login_password: str
    :ivar version: Major version of PostgreSQL database engine. Known values are: "18", "17", "16",
     "15", "14", "13", "12", and "11".
    :vartype version: str or ~azure.mgmt.postgresqlflexibleservers.models.PostgresMajorVersion
    :ivar minor_version: Minor version of PostgreSQL database engine.
    :vartype minor_version: str
    :ivar state: Possible states of a server. Known values are: "Ready", "Dropping", "Disabled",
     "Starting", "Stopping", "Stopped", "Updating", "Restarting", "Inaccessible", and
     "Provisioning".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.ServerState
    :ivar fully_qualified_domain_name: Fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar storage: Storage properties of a server.
    :vartype storage: ~azure.mgmt.postgresqlflexibleservers.models.Storage
    :ivar auth_config: Authentication configuration properties of a server.
    :vartype auth_config: ~azure.mgmt.postgresqlflexibleservers.models.AuthConfig
    :ivar data_encryption: Data encryption properties of a server.
    :vartype data_encryption: ~azure.mgmt.postgresqlflexibleservers.models.DataEncryption
    :ivar backup: Backup properties of a server.
    :vartype backup: ~azure.mgmt.postgresqlflexibleservers.models.Backup
    :ivar network: Network properties of a server. Only required if you want your server to be
     integrated into a virtual network provided by customer.
    :vartype network: ~azure.mgmt.postgresqlflexibleservers.models.Network
    :ivar high_availability: High availability properties of a server.
    :vartype high_availability: ~azure.mgmt.postgresqlflexibleservers.models.HighAvailability
    :ivar maintenance_window: Maintenance window properties of a server.
    :vartype maintenance_window: ~azure.mgmt.postgresqlflexibleservers.models.MaintenanceWindow
    :ivar source_server_resource_id: Identifier of the server to be used as the source of the new
     server. Required when 'createMode' is 'PointInTimeRestore', 'GeoRestore', 'Replica', or
     'ReviveDropped'. This property is returned only when the target server is a read replica.
    :vartype source_server_resource_id: str
    :ivar point_in_time_utc: Creation time (in ISO8601 format) of the backup which you want to
     restore in the new server. It's required when 'createMode' is 'PointInTimeRestore',
     'GeoRestore', or 'ReviveDropped'.
    :vartype point_in_time_utc: ~datetime.datetime
    :ivar availability_zone: Availability zone of a server.
    :vartype availability_zone: str
    :ivar replication_role: Role of the server in a replication set. Known values are: "None",
     "Primary", "AsyncReplica", and "GeoAsyncReplica".
    :vartype replication_role: str or ~azure.mgmt.postgresqlflexibleservers.models.ReplicationRole
    :ivar replica_capacity: Maximum number of read replicas allowed for a server.
    :vartype replica_capacity: int
    :ivar replica: Read replica properties of a server. Required only in case that you want to
     promote a server.
    :vartype replica: ~azure.mgmt.postgresqlflexibleservers.models.Replica
    :ivar create_mode: Creation mode of a new server. Known values are: "Default", "Create",
     "Update", "PointInTimeRestore", "GeoRestore", "Replica", and "ReviveDropped".
    :vartype create_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.CreateMode
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     specified server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.postgresqlflexibleservers.models.PrivateEndpointConnection]
    :ivar cluster: Cluster properties of a server.
    :vartype cluster: ~azure.mgmt.postgresqlflexibleservers.models.Cluster
    """

    administrator_login: Optional[str] = rest_field(name="administratorLogin", visibility=["read", "create"])
    """Name of the login designated as the first password based administrator assigned to your
     instance of PostgreSQL. Must be specified the first time that you enable password based
     authentication on a server. Once set to a given value, it cannot be changed for the rest of the
     life of a server. If you disable password based authentication on a server which had it
     enabled, this password based role isn't deleted."""
    administrator_login_password: Optional[str] = rest_field(
        name="administratorLoginPassword", visibility=["create", "update"]
    )
    """Password assigned to the administrator login. As long as password authentication is enabled,
     this password can be changed at any time."""
    version: Optional[Union[str, "_models.PostgresMajorVersion"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Major version of PostgreSQL database engine. Known values are: \"18\", \"17\", \"16\", \"15\",
     \"14\", \"13\", \"12\", and \"11\"."""
    minor_version: Optional[str] = rest_field(name="minorVersion", visibility=["read"])
    """Minor version of PostgreSQL database engine."""
    state: Optional[Union[str, "_models.ServerState"]] = rest_field(visibility=["read"])
    """Possible states of a server. Known values are: \"Ready\", \"Dropping\", \"Disabled\",
     \"Starting\", \"Stopping\", \"Stopped\", \"Updating\", \"Restarting\", \"Inaccessible\", and
     \"Provisioning\"."""
    fully_qualified_domain_name: Optional[str] = rest_field(name="fullyQualifiedDomainName", visibility=["read"])
    """Fully qualified domain name of a server."""
    storage: Optional["_models.Storage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage properties of a server."""
    auth_config: Optional["_models.AuthConfig"] = rest_field(
        name="authConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Authentication configuration properties of a server."""
    data_encryption: Optional["_models.DataEncryption"] = rest_field(
        name="dataEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data encryption properties of a server."""
    backup: Optional["_models.Backup"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Backup properties of a server."""
    network: Optional["_models.Network"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network properties of a server. Only required if you want your server to be integrated into a
     virtual network provided by customer."""
    high_availability: Optional["_models.HighAvailability"] = rest_field(
        name="highAvailability", visibility=["read", "create", "update", "delete", "query"]
    )
    """High availability properties of a server."""
    maintenance_window: Optional["_models.MaintenanceWindow"] = rest_field(
        name="maintenanceWindow", visibility=["read", "update"]
    )
    """Maintenance window properties of a server."""
    source_server_resource_id: Optional[str] = rest_field(name="sourceServerResourceId", visibility=["read", "create"])
    """Identifier of the server to be used as the source of the new server. Required when 'createMode'
     is 'PointInTimeRestore', 'GeoRestore', 'Replica', or 'ReviveDropped'. This property is returned
     only when the target server is a read replica."""
    point_in_time_utc: Optional[datetime.datetime] = rest_field(
        name="pointInTimeUTC", visibility=["create"], format="rfc3339"
    )
    """Creation time (in ISO8601 format) of the backup which you want to restore in the new server.
     It's required when 'createMode' is 'PointInTimeRestore', 'GeoRestore', or 'ReviveDropped'."""
    availability_zone: Optional[str] = rest_field(name="availabilityZone", visibility=["read", "create"])
    """Availability zone of a server."""
    replication_role: Optional[Union[str, "_models.ReplicationRole"]] = rest_field(
        name="replicationRole", visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the server in a replication set. Known values are: \"None\", \"Primary\",
     \"AsyncReplica\", and \"GeoAsyncReplica\"."""
    replica_capacity: Optional[int] = rest_field(name="replicaCapacity", visibility=["read"])
    """Maximum number of read replicas allowed for a server."""
    replica: Optional["_models.Replica"] = rest_field(visibility=["read", "update"])
    """Read replica properties of a server. Required only in case that you want to promote a server."""
    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(
        name="createMode", visibility=["create", "update"]
    )
    """Creation mode of a new server. Known values are: \"Default\", \"Create\", \"Update\",
     \"PointInTimeRestore\", \"GeoRestore\", \"Replica\", and \"ReviveDropped\"."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections associated with the specified server."""
    cluster: Optional["_models.Cluster"] = rest_field(visibility=["read", "create", "update"])
    """Cluster properties of a server."""

    @overload
    def __init__(
        self,
        *,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "_models.PostgresMajorVersion"]] = None,
        storage: Optional["_models.Storage"] = None,
        auth_config: Optional["_models.AuthConfig"] = None,
        data_encryption: Optional["_models.DataEncryption"] = None,
        backup: Optional["_models.Backup"] = None,
        network: Optional["_models.Network"] = None,
        high_availability: Optional["_models.HighAvailability"] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        source_server_resource_id: Optional[str] = None,
        point_in_time_utc: Optional[datetime.datetime] = None,
        availability_zone: Optional[str] = None,
        replication_role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        replica: Optional["_models.Replica"] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        cluster: Optional["_models.Cluster"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerPropertiesForPatch(_Model):
    """Properties of a server.

    :ivar administrator_login: Name of the login designated as the first password based
     administrator assigned to your instance of PostgreSQL. Must be specified the first time that
     you enable password based authentication on a server. Once set to a given value, it cannot be
     changed for the rest of the life of a server. If you disable password based authentication on a
     server which had it enabled, this password based role isn't deleted.
    :vartype administrator_login: str
    :ivar administrator_login_password: Password assigned to the administrator login. As long as
     password authentication is enabled, this password can be changed at any time.
    :vartype administrator_login_password: str
    :ivar version: Major version of PostgreSQL database engine. Known values are: "18", "17", "16",
     "15", "14", "13", "12", and "11".
    :vartype version: str or ~azure.mgmt.postgresqlflexibleservers.models.PostgresMajorVersion
    :ivar storage: Storage properties of a server.
    :vartype storage: ~azure.mgmt.postgresqlflexibleservers.models.Storage
    :ivar backup: Backup properties of a server.
    :vartype backup: ~azure.mgmt.postgresqlflexibleservers.models.BackupForPatch
    :ivar high_availability: High availability properties of a server.
    :vartype high_availability:
     ~azure.mgmt.postgresqlflexibleservers.models.HighAvailabilityForPatch
    :ivar maintenance_window: Maintenance window properties of a server.
    :vartype maintenance_window:
     ~azure.mgmt.postgresqlflexibleservers.models.MaintenanceWindowForPatch
    :ivar auth_config: Authentication configuration properties of a server.
    :vartype auth_config: ~azure.mgmt.postgresqlflexibleservers.models.AuthConfigForPatch
    :ivar data_encryption: Data encryption properties of a server.
    :vartype data_encryption: ~azure.mgmt.postgresqlflexibleservers.models.DataEncryption
    :ivar availability_zone: Availability zone of a server.
    :vartype availability_zone: str
    :ivar create_mode: Update mode of an existing server. Known values are: "Default" and "Update".
    :vartype create_mode: str or ~azure.mgmt.postgresqlflexibleservers.models.CreateModeForPatch
    :ivar replication_role: Role of the server in a replication set. Known values are: "None",
     "Primary", "AsyncReplica", and "GeoAsyncReplica".
    :vartype replication_role: str or ~azure.mgmt.postgresqlflexibleservers.models.ReplicationRole
    :ivar replica: Read replica properties of a server. Required only in case that you want to
     promote a server.
    :vartype replica: ~azure.mgmt.postgresqlflexibleservers.models.Replica
    :ivar network: Network properties of a server. Only required if you want your server to be
     integrated into a virtual network provided by customer.
    :vartype network: ~azure.mgmt.postgresqlflexibleservers.models.Network
    :ivar cluster: Cluster properties of a server.
    :vartype cluster: ~azure.mgmt.postgresqlflexibleservers.models.Cluster
    """

    administrator_login: Optional[str] = rest_field(name="administratorLogin", visibility=["read"])
    """Name of the login designated as the first password based administrator assigned to your
     instance of PostgreSQL. Must be specified the first time that you enable password based
     authentication on a server. Once set to a given value, it cannot be changed for the rest of the
     life of a server. If you disable password based authentication on a server which had it
     enabled, this password based role isn't deleted."""
    administrator_login_password: Optional[str] = rest_field(name="administratorLoginPassword", visibility=["update"])
    """Password assigned to the administrator login. As long as password authentication is enabled,
     this password can be changed at any time."""
    version: Optional[Union[str, "_models.PostgresMajorVersion"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Major version of PostgreSQL database engine. Known values are: \"18\", \"17\", \"16\", \"15\",
     \"14\", \"13\", \"12\", and \"11\"."""
    storage: Optional["_models.Storage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Storage properties of a server."""
    backup: Optional["_models.BackupForPatch"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Backup properties of a server."""
    high_availability: Optional["_models.HighAvailabilityForPatch"] = rest_field(
        name="highAvailability", visibility=["read", "create", "update", "delete", "query"]
    )
    """High availability properties of a server."""
    maintenance_window: Optional["_models.MaintenanceWindowForPatch"] = rest_field(
        name="maintenanceWindow", visibility=["read", "update"]
    )
    """Maintenance window properties of a server."""
    auth_config: Optional["_models.AuthConfigForPatch"] = rest_field(
        name="authConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """Authentication configuration properties of a server."""
    data_encryption: Optional["_models.DataEncryption"] = rest_field(
        name="dataEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Data encryption properties of a server."""
    availability_zone: Optional[str] = rest_field(
        name="availabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Availability zone of a server."""
    create_mode: Optional[Union[str, "_models.CreateModeForPatch"]] = rest_field(
        name="createMode", visibility=["update"]
    )
    """Update mode of an existing server. Known values are: \"Default\" and \"Update\"."""
    replication_role: Optional[Union[str, "_models.ReplicationRole"]] = rest_field(
        name="replicationRole", visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the server in a replication set. Known values are: \"None\", \"Primary\",
     \"AsyncReplica\", and \"GeoAsyncReplica\"."""
    replica: Optional["_models.Replica"] = rest_field(visibility=["read", "update"])
    """Read replica properties of a server. Required only in case that you want to promote a server."""
    network: Optional["_models.Network"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network properties of a server. Only required if you want your server to be integrated into a
     virtual network provided by customer."""
    cluster: Optional["_models.Cluster"] = rest_field(visibility=["read", "update"])
    """Cluster properties of a server."""

    @overload
    def __init__(
        self,
        *,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "_models.PostgresMajorVersion"]] = None,
        storage: Optional["_models.Storage"] = None,
        backup: Optional["_models.BackupForPatch"] = None,
        high_availability: Optional["_models.HighAvailabilityForPatch"] = None,
        maintenance_window: Optional["_models.MaintenanceWindowForPatch"] = None,
        auth_config: Optional["_models.AuthConfigForPatch"] = None,
        data_encryption: Optional["_models.DataEncryption"] = None,
        availability_zone: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateModeForPatch"]] = None,
        replication_role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        replica: Optional["_models.Replica"] = None,
        network: Optional["_models.Network"] = None,
        cluster: Optional["_models.Cluster"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerSku(_Model):
    """Compute information of a server.

    :ivar name: Compute tier and size of the database server. This object is empty for an Azure
     Database for PostgreSQL single server.
    :vartype name: str
    :ivar tier: Tier of the compute assigned to a server. Known values are: "Burstable",
     "GeneralPurpose", and "MemoryOptimized".
    :vartype tier: str or ~azure.mgmt.postgresqlflexibleservers.models.SkuTier
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Compute tier and size of the database server. This object is empty for an Azure Database for
     PostgreSQL single server."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tier of the compute assigned to a server. Known values are: \"Burstable\", \"GeneralPurpose\",
     and \"MemoryOptimized\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerSkuCapability(CapabilityBase):
    """Capabilities in terms of compute.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Name of the compute (SKU).
    :vartype name: str
    :ivar v_cores: vCores available for this compute.
    :vartype v_cores: int
    :ivar supported_iops: Maximum IOPS supported by this compute.
    :vartype supported_iops: int
    :ivar supported_memory_per_vcore_mb: Supported memory (in MB) per virtual core assigned to this
     compute.
    :vartype supported_memory_per_vcore_mb: int
    :ivar supported_zones: List of supported availability zones. E.g. '1', '2', '3'.
    :vartype supported_zones: list[str]
    :ivar supported_ha_mode: Modes of high availability supported for this compute.
    :vartype supported_ha_mode: list[str or
     ~azure.mgmt.postgresqlflexibleservers.models.HighAvailabilityMode]
    :ivar supported_features: Features supported.
    :vartype supported_features:
     list[~azure.mgmt.postgresqlflexibleservers.models.SupportedFeature]
    :ivar security_profile: Security profile of the compute. Indicates if it's a Confidential
     Compute virtual machine.
    :vartype security_profile: str
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the compute (SKU)."""
    v_cores: Optional[int] = rest_field(name="vCores", visibility=["read"])
    """vCores available for this compute."""
    supported_iops: Optional[int] = rest_field(name="supportedIops", visibility=["read"])
    """Maximum IOPS supported by this compute."""
    supported_memory_per_vcore_mb: Optional[int] = rest_field(name="supportedMemoryPerVcoreMb", visibility=["read"])
    """Supported memory (in MB) per virtual core assigned to this compute."""
    supported_zones: Optional[list[str]] = rest_field(name="supportedZones", visibility=["read"])
    """List of supported availability zones. E.g. '1', '2', '3'."""
    supported_ha_mode: Optional[list[Union[str, "_models.HighAvailabilityMode"]]] = rest_field(
        name="supportedHaMode", visibility=["read"]
    )
    """Modes of high availability supported for this compute."""
    supported_features: Optional[list["_models.SupportedFeature"]] = rest_field(
        name="supportedFeatures", visibility=["read"]
    )
    """Features supported."""
    security_profile: Optional[str] = rest_field(name="securityProfile", visibility=["read"])
    """Security profile of the compute. Indicates if it's a Confidential Compute virtual machine."""


class ServerVersionCapability(CapabilityBase):
    """Capabilities in terms of major versions of PostgreSQL database engine.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Major version of PostgreSQL database engine.
    :vartype name: str
    :ivar supported_versions_to_upgrade: Major versions of PostgreSQL database engine to which this
     version can be automatically upgraded.
    :vartype supported_versions_to_upgrade: list[str]
    :ivar supported_features: Features supported.
    :vartype supported_features:
     list[~azure.mgmt.postgresqlflexibleservers.models.SupportedFeature]
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Major version of PostgreSQL database engine."""
    supported_versions_to_upgrade: Optional[list[str]] = rest_field(
        name="supportedVersionsToUpgrade", visibility=["read"]
    )
    """Major versions of PostgreSQL database engine to which this version can be automatically
     upgraded."""
    supported_features: Optional[list["_models.SupportedFeature"]] = rest_field(
        name="supportedFeatures", visibility=["read"]
    )
    """Features supported."""


class ServiceSpecification(_Model):
    """Service specification for an operation.

    :ivar metric_specifications: Metric specifications for the operation.
    :vartype metric_specifications:
     list[~azure.mgmt.postgresqlflexibleservers.models.MetricSpecification]
    :ivar log_specifications: Log specifications for the operation.
    :vartype log_specifications:
     list[~azure.mgmt.postgresqlflexibleservers.models.LogSpecification]
    """

    metric_specifications: Optional[list["_models.MetricSpecification"]] = rest_field(
        name="metricSpecifications", visibility=["read"]
    )
    """Metric specifications for the operation."""
    log_specifications: Optional[list["_models.LogSpecification"]] = rest_field(
        name="logSpecifications", visibility=["read"]
    )
    """Log specifications for the operation."""


class Sku(_Model):
    """Compute information of a server.

    :ivar name: Name by which is known a given compute size assigned to a server. Required.
    :vartype name: str
    :ivar tier: Tier of the compute assigned to a server. Required. Known values are: "Burstable",
     "GeneralPurpose", and "MemoryOptimized".
    :vartype tier: str or ~azure.mgmt.postgresqlflexibleservers.models.SkuTier
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name by which is known a given compute size assigned to a server. Required."""
    tier: Union[str, "_models.SkuTier"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tier of the compute assigned to a server. Required. Known values are: \"Burstable\",
     \"GeneralPurpose\", and \"MemoryOptimized\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: Union[str, "_models.SkuTier"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkuForPatch(_Model):
    """Compute information of a server.

    :ivar name: Name by which is known a given compute size assigned to a server.
    :vartype name: str
    :ivar tier: Tier of the compute assigned to a server. Known values are: "Burstable",
     "GeneralPurpose", and "MemoryOptimized".
    :vartype tier: str or ~azure.mgmt.postgresqlflexibleservers.models.SkuTier
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name by which is known a given compute size assigned to a server."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tier of the compute assigned to a server. Known values are: \"Burstable\", \"GeneralPurpose\",
     and \"MemoryOptimized\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Storage(_Model):
    """Storage properties of a server.

    :ivar storage_size_gb: Size of storage assigned to a server.
    :vartype storage_size_gb: int
    :ivar auto_grow: Flag to enable or disable the automatic growth of storage size of a server
     when available space is nearing zero and conditions allow for automatically growing storage
     size. Known values are: "Enabled" and "Disabled".
    :vartype auto_grow: str or ~azure.mgmt.postgresqlflexibleservers.models.StorageAutoGrow
    :ivar tier: Storage tier of a server. Known values are: "P1", "P2", "P3", "P4", "P6", "P10",
     "P15", "P20", "P30", "P40", "P50", "P60", "P70", and "P80".
    :vartype tier: str or
     ~azure.mgmt.postgresqlflexibleservers.models.AzureManagedDiskPerformanceTier
    :ivar iops: Maximum IOPS supported for storage. Required when type of storage is PremiumV2_LRS
     or UltraSSD_LRS.
    :vartype iops: int
    :ivar throughput: Maximum throughput supported for storage. Required when type of storage is
     PremiumV2_LRS or UltraSSD_LRS.
    :vartype throughput: int
    :ivar type: Type of storage assigned to a server. Allowed values are Premium_LRS,
     PremiumV2_LRS, or UltraSSD_LRS. If not specified, it defaults to Premium_LRS. Known values are:
     "Premium_LRS", "PremiumV2_LRS", and "UltraSSD_LRS".
    :vartype type: str or ~azure.mgmt.postgresqlflexibleservers.models.StorageType
    """

    storage_size_gb: Optional[int] = rest_field(
        name="storageSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of storage assigned to a server."""
    auto_grow: Optional[Union[str, "_models.StorageAutoGrow"]] = rest_field(
        name="autoGrow", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to enable or disable the automatic growth of storage size of a server when available space
     is nearing zero and conditions allow for automatically growing storage size. Known values are:
     \"Enabled\" and \"Disabled\"."""
    tier: Optional[Union[str, "_models.AzureManagedDiskPerformanceTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage tier of a server. Known values are: \"P1\", \"P2\", \"P3\", \"P4\", \"P6\", \"P10\",
     \"P15\", \"P20\", \"P30\", \"P40\", \"P50\", \"P60\", \"P70\", and \"P80\"."""
    iops: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum IOPS supported for storage. Required when type of storage is PremiumV2_LRS or
     UltraSSD_LRS."""
    throughput: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum throughput supported for storage. Required when type of storage is PremiumV2_LRS or
     UltraSSD_LRS."""
    type: Optional[Union[str, "_models.StorageType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of storage assigned to a server. Allowed values are Premium_LRS, PremiumV2_LRS, or
     UltraSSD_LRS. If not specified, it defaults to Premium_LRS. Known values are: \"Premium_LRS\",
     \"PremiumV2_LRS\", and \"UltraSSD_LRS\"."""

    @overload
    def __init__(
        self,
        *,
        storage_size_gb: Optional[int] = None,
        auto_grow: Optional[Union[str, "_models.StorageAutoGrow"]] = None,
        tier: Optional[Union[str, "_models.AzureManagedDiskPerformanceTier"]] = None,
        iops: Optional[int] = None,
        throughput: Optional[int] = None,
        type: Optional[Union[str, "_models.StorageType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageEditionCapability(CapabilityBase):
    """Capabilities in terms of storage tier.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Name of storage tier.
    :vartype name: str
    :ivar default_storage_size_mb: Default storage size (in MB) for this storage tier.
    :vartype default_storage_size_mb: int
    :ivar supported_storage_mb: Configurations of storage supported for this storage tier.
    :vartype supported_storage_mb:
     list[~azure.mgmt.postgresqlflexibleservers.models.StorageMbCapability]
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of storage tier."""
    default_storage_size_mb: Optional[int] = rest_field(name="defaultStorageSizeMb", visibility=["read"])
    """Default storage size (in MB) for this storage tier."""
    supported_storage_mb: Optional[list["_models.StorageMbCapability"]] = rest_field(
        name="supportedStorageMb", visibility=["read"]
    )
    """Configurations of storage supported for this storage tier."""


class StorageMbCapability(CapabilityBase):
    """Storage size (in MB) capability.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar supported_iops: Minimum IOPS supported by the storage size.
    :vartype supported_iops: int
    :ivar supported_maximum_iops: Maximum IOPS supported by the storage size.
    :vartype supported_maximum_iops: int
    :ivar storage_size_mb: Minimum supported size (in MB) of storage.
    :vartype storage_size_mb: int
    :ivar maximum_storage_size_mb: Maximum supported size (in MB) of storage.
    :vartype maximum_storage_size_mb: int
    :ivar supported_throughput: Minimum supported throughput (in MB/s) of storage.
    :vartype supported_throughput: int
    :ivar supported_maximum_throughput: Maximum supported throughput (in MB/s) of storage.
    :vartype supported_maximum_throughput: int
    :ivar default_iops_tier: Default IOPS for this tier and storage size.
    :vartype default_iops_tier: str
    :ivar supported_iops_tiers: List of all supported storage tiers for this tier and storage size.
    :vartype supported_iops_tiers:
     list[~azure.mgmt.postgresqlflexibleservers.models.StorageTierCapability]
    """

    supported_iops: Optional[int] = rest_field(name="supportedIops", visibility=["read"])
    """Minimum IOPS supported by the storage size."""
    supported_maximum_iops: Optional[int] = rest_field(name="supportedMaximumIops", visibility=["read"])
    """Maximum IOPS supported by the storage size."""
    storage_size_mb: Optional[int] = rest_field(name="storageSizeMb", visibility=["read"])
    """Minimum supported size (in MB) of storage."""
    maximum_storage_size_mb: Optional[int] = rest_field(name="maximumStorageSizeMb", visibility=["read"])
    """Maximum supported size (in MB) of storage."""
    supported_throughput: Optional[int] = rest_field(name="supportedThroughput", visibility=["read"])
    """Minimum supported throughput (in MB/s) of storage."""
    supported_maximum_throughput: Optional[int] = rest_field(name="supportedMaximumThroughput", visibility=["read"])
    """Maximum supported throughput (in MB/s) of storage."""
    default_iops_tier: Optional[str] = rest_field(name="defaultIopsTier", visibility=["read"])
    """Default IOPS for this tier and storage size."""
    supported_iops_tiers: Optional[list["_models.StorageTierCapability"]] = rest_field(
        name="supportedIopsTiers", visibility=["read"]
    )
    """List of all supported storage tiers for this tier and storage size."""


class StorageTierCapability(CapabilityBase):
    """Capability of a storage tier.

    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    :ivar name: Name of the storage tier.
    :vartype name: str
    :ivar iops: Supported IOPS for the storage tier.
    :vartype iops: int
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the storage tier."""
    iops: Optional[int] = rest_field(visibility=["read"])
    """Supported IOPS for the storage tier."""


class SupportedFeature(_Model):
    """Features supported.

    :ivar name: Name of the feature.
    :vartype name: str
    :ivar status: Status of the feature. Indicates if the feature is enabled or not. Known values
     are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.FeatureStatus
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the feature."""
    status: Optional[Union[str, "_models.FeatureStatus"]] = rest_field(visibility=["read"])
    """Status of the feature. Indicates if the feature is enabled or not. Known values are:
     \"Enabled\" and \"Disabled\"."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.postgresqlflexibleservers.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.postgresqlflexibleservers.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TuningOptions(ProxyResource):
    """Impact on some metric if this recommended action is applied.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.postgresqlflexibleservers.models.TuningOptionsProperties
    """

    properties: Optional["_models.TuningOptionsProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.TuningOptionsProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TuningOptionsProperties(_Model):
    """Properties of a tuning option.

    :ivar state: State of the tuning option.
    :vartype state: str
    """

    state: Optional[str] = rest_field(visibility=["read"])
    """State of the tuning option."""


class UserAssignedIdentity(_Model):
    """Identities associated with a server.

    :ivar user_assigned_identities: Map of user assigned managed identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.postgresqlflexibleservers.models.UserIdentity]
    :ivar principal_id: Identifier of the object of the service principal associated to the user
     assigned managed identity.
    :vartype principal_id: str
    :ivar type: Types of identities associated with a server. Required. Known values are: "None",
     "UserAssigned", "SystemAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.postgresqlflexibleservers.models.IdentityType
    :ivar tenant_id: Identifier of the tenant of a server.
    :vartype tenant_id: str
    """

    user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Map of user assigned managed identities."""
    principal_id: Optional[str] = rest_field(
        name="principalId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the object of the service principal associated to the user assigned managed
     identity."""
    type: Union[str, "_models.IdentityType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Types of identities associated with a server. Required. Known values are: \"None\",
     \"UserAssigned\", \"SystemAssigned\", and \"SystemAssigned,UserAssigned\"."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """Identifier of the tenant of a server."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = None,
        principal_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserIdentity(_Model):
    """User assigned managed identity associated with a server.

    :ivar principal_id: Identifier of the object of the service principal associated to the user
     assigned managed identity.
    :vartype principal_id: str
    :ivar client_id: Identifier of the client of the service principal associated to the user
     assigned managed identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(
        name="principalId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the object of the service principal associated to the user assigned managed
     identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the client of the service principal associated to the user assigned managed
     identity."""

    @overload
    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        client_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidationDetails(_Model):
    """Details for the validation for migration.

    :ivar status: Validation status for migration. Known values are: "Failed", "Succeeded", and
     "Warning".
    :vartype status: str or ~azure.mgmt.postgresqlflexibleservers.models.ValidationState
    :ivar validation_start_time_in_utc: Start time (UTC) for validation.
    :vartype validation_start_time_in_utc: ~datetime.datetime
    :ivar validation_end_time_in_utc: End time (UTC) for validation.
    :vartype validation_end_time_in_utc: ~datetime.datetime
    :ivar server_level_validation_details: Details of server level validations.
    :vartype server_level_validation_details:
     list[~azure.mgmt.postgresqlflexibleservers.models.ValidationSummaryItem]
    :ivar db_level_validation_details: Details of server level validations.
    :vartype db_level_validation_details:
     list[~azure.mgmt.postgresqlflexibleservers.models.DbLevelValidationStatus]
    """

    status: Optional[Union[str, "_models.ValidationState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Validation status for migration. Known values are: \"Failed\", \"Succeeded\", and \"Warning\"."""
    validation_start_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="validationStartTimeInUtc", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start time (UTC) for validation."""
    validation_end_time_in_utc: Optional[datetime.datetime] = rest_field(
        name="validationEndTimeInUtc", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time (UTC) for validation."""
    server_level_validation_details: Optional[list["_models.ValidationSummaryItem"]] = rest_field(
        name="serverLevelValidationDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of server level validations."""
    db_level_validation_details: Optional[list["_models.DbLevelValidationStatus"]] = rest_field(
        name="dbLevelValidationDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of server level validations."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ValidationState"]] = None,
        validation_start_time_in_utc: Optional[datetime.datetime] = None,
        validation_end_time_in_utc: Optional[datetime.datetime] = None,
        server_level_validation_details: Optional[list["_models.ValidationSummaryItem"]] = None,
        db_level_validation_details: Optional[list["_models.DbLevelValidationStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidationMessage(_Model):
    """Validation message object.

    :ivar state: Severity of validation message. Known values are: "Failed", "Succeeded", and
     "Warning".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.ValidationState
    :ivar message: Validation message string.
    :vartype message: str
    """

    state: Optional[Union[str, "_models.ValidationState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Severity of validation message. Known values are: \"Failed\", \"Succeeded\", and \"Warning\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Validation message string."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ValidationState"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ValidationSummaryItem(_Model):
    """Validation summary object.

    :ivar type: Validation type.
    :vartype type: str
    :ivar state: Validation status for migration. Known values are: "Failed", "Succeeded", and
     "Warning".
    :vartype state: str or ~azure.mgmt.postgresqlflexibleservers.models.ValidationState
    :ivar messages: Validation messages.
    :vartype messages: list[~azure.mgmt.postgresqlflexibleservers.models.ValidationMessage]
    """

    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Validation type."""
    state: Optional[Union[str, "_models.ValidationState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Validation status for migration. Known values are: \"Failed\", \"Succeeded\", and \"Warning\"."""
    messages: Optional[list["_models.ValidationMessage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Validation messages."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[str] = None,
        state: Optional[Union[str, "_models.ValidationState"]] = None,
        messages: Optional[list["_models.ValidationMessage"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualEndpoint(ProxyResource):
    """Pair of virtual endpoints for a server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.postgresqlflexibleservers.models.SystemData
    :ivar properties: Properties of the pair of virtual endpoints.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.VirtualEndpointResourceProperties
    """

    properties: Optional["_models.VirtualEndpointResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the pair of virtual endpoints."""

    __flattened_items = ["endpoint_type", "members", "virtual_endpoints"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualEndpointResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualEndpointResourceForPatch(_Model):
    """Pair of virtual endpoints for a server.

    :ivar properties: Properties of the pair of virtual endpoints.
    :vartype properties:
     ~azure.mgmt.postgresqlflexibleservers.models.VirtualEndpointResourceProperties
    """

    properties: Optional["_models.VirtualEndpointResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the pair of virtual endpoints."""

    __flattened_items = ["endpoint_type", "members", "virtual_endpoints"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualEndpointResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualEndpointResourceProperties(_Model):
    """Properties of a pair of virtual endpoints.

    :ivar endpoint_type: Type of endpoint for the virtual endpoints. "ReadWrite"
    :vartype endpoint_type: str or ~azure.mgmt.postgresqlflexibleservers.models.VirtualEndpointType
    :ivar members: List of servers that one of the virtual endpoints can refer to.
    :vartype members: list[str]
    :ivar virtual_endpoints: List of virtual endpoints for a server.
    :vartype virtual_endpoints: list[str]
    """

    endpoint_type: Optional[Union[str, "_models.VirtualEndpointType"]] = rest_field(
        name="endpointType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of endpoint for the virtual endpoints. \"ReadWrite\""""
    members: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of servers that one of the virtual endpoints can refer to."""
    virtual_endpoints: Optional[list[str]] = rest_field(name="virtualEndpoints", visibility=["read"])
    """List of virtual endpoints for a server."""

    @overload
    def __init__(
        self,
        *,
        endpoint_type: Optional[Union[str, "_models.VirtualEndpointType"]] = None,
        members: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkSubnetUsageModel(_Model):
    """Virtual network subnet usage data.

    :ivar delegated_subnets_usage:
    :vartype delegated_subnets_usage:
     list[~azure.mgmt.postgresqlflexibleservers.models.DelegatedSubnetUsage]
    :ivar location: location of the delegated subnet usage.
    :vartype location: str
    :ivar subscription_id: subscriptionId of the delegated subnet usage.
    :vartype subscription_id: str
    """

    delegated_subnets_usage: Optional[list["_models.DelegatedSubnetUsage"]] = rest_field(
        name="delegatedSubnetsUsage", visibility=["read"]
    )
    location: Optional[str] = rest_field(visibility=["read"])
    """location of the delegated subnet usage."""
    subscription_id: Optional[str] = rest_field(name="subscriptionId", visibility=["read"])
    """subscriptionId of the delegated subnet usage."""


class VirtualNetworkSubnetUsageParameter(_Model):
    """Virtual network subnet usage parameter.

    :ivar virtual_network_arm_resource_id: Virtual network resource id.
    :vartype virtual_network_arm_resource_id: str
    """

    virtual_network_arm_resource_id: Optional[str] = rest_field(
        name="virtualNetworkArmResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual network resource id."""

    @overload
    def __init__(
        self,
        *,
        virtual_network_arm_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
