# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNetworkWatchersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_create_or_update(self, resource_group):
        response = self.client.network_watchers.create_or_update(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_get(self, resource_group):
        response = self.client.network_watchers.get(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_delete(self, resource_group):
        response = self.client.network_watchers.begin_delete(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_update_tags(self, resource_group):
        response = self.client.network_watchers.update_tags(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_list(self, resource_group):
        response = self.client.network_watchers.list(
            resource_group_name=resource_group.name,
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_list_all(self, resource_group):
        response = self.client.network_watchers.list_all(
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_get_topology(self, resource_group):
        response = self.client.network_watchers.get_topology(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "targetResourceGroupName": "str",
                "targetSubnet": {"id": "str"},
                "targetVirtualNetwork": {"id": "str"},
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_verify_ip_flow(self, resource_group):
        response = self.client.network_watchers.begin_verify_ip_flow(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "direction": "str",
                "localIPAddress": "str",
                "localPort": "str",
                "protocol": "str",
                "remoteIPAddress": "str",
                "remotePort": "str",
                "targetResourceId": "str",
                "targetNicResourceId": "str",
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_next_hop(self, resource_group):
        response = self.client.network_watchers.begin_get_next_hop(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "destinationIPAddress": "str",
                "sourceIPAddress": "str",
                "targetResourceId": "str",
                "targetNicResourceId": "str",
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_vm_security_rules(self, resource_group):
        response = self.client.network_watchers.begin_get_vm_security_rules(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"targetResourceId": "str"},
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_troubleshooting(self, resource_group):
        response = self.client.network_watchers.begin_get_troubleshooting(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"storageId": "str", "storagePath": "str", "targetResourceId": "str"},
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_troubleshooting_result(self, resource_group):
        response = self.client.network_watchers.begin_get_troubleshooting_result(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"targetResourceId": "str"},
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_set_flow_log_configuration(self, resource_group):
        response = self.client.network_watchers.begin_set_flow_log_configuration(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "enabled": bool,
                "storageId": "str",
                "targetResourceId": "str",
                "enabledFilteringCriteria": "str",
                "flowAnalyticsConfiguration": {
                    "networkWatcherFlowAnalyticsConfiguration": {
                        "enabled": bool,
                        "trafficAnalyticsInterval": 0,
                        "workspaceId": "str",
                        "workspaceRegion": "str",
                        "workspaceResourceId": "str",
                    }
                },
                "format": {"type": "str", "version": 0},
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "recordTypes": "str",
                "retentionPolicy": {"days": 0, "enabled": False},
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_flow_log_status(self, resource_group):
        response = self.client.network_watchers.begin_get_flow_log_status(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"targetResourceId": "str"},
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_check_connectivity(self, resource_group):
        response = self.client.network_watchers.begin_check_connectivity(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "destination": {"address": "str", "port": 0, "resourceId": "str"},
                "source": {"resourceId": "str", "port": 0},
                "preferredIPVersion": "str",
                "protocol": "str",
                "protocolConfiguration": {
                    "HTTPConfiguration": {
                        "headers": [{"name": "str", "value": "str"}],
                        "method": "str",
                        "validStatusCodes": [0],
                    }
                },
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_azure_reachability_report(self, resource_group):
        response = self.client.network_watchers.begin_get_azure_reachability_report(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "endTime": "2020-02-20 00:00:00",
                "providerLocation": {"country": "str", "city": "str", "state": "str"},
                "startTime": "2020-02-20 00:00:00",
                "azureLocations": ["str"],
                "providers": ["str"],
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_list_available_providers(self, resource_group):
        response = self.client.network_watchers.begin_list_available_providers(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={"azureLocations": ["str"], "city": "str", "country": "str", "state": "str"},
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_watchers_begin_get_network_configuration_diagnostic(self, resource_group):
        response = self.client.network_watchers.begin_get_network_configuration_diagnostic(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            parameters={
                "profiles": [
                    {
                        "destination": "str",
                        "destinationPort": "str",
                        "direction": "str",
                        "protocol": "str",
                        "source": "str",
                    }
                ],
                "targetResourceId": "str",
                "verbosityLevel": "str",
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
