# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AccountEncryption(_Model):
    """Encryption settings.

    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Microsoft.NetApp, Microsoft.KeyVault. Known values are: "Microsoft.NetApp" and
     "Microsoft.KeyVault".
    :vartype key_source: str or ~azure.mgmt.netapp.models.KeySource
    :ivar key_vault_properties: Properties provided by KeVault. Applicable if keySource is
     'Microsoft.KeyVault'.
    :vartype key_vault_properties: ~azure.mgmt.netapp.models.KeyVaultProperties
    :ivar identity: Identity used to authenticate to KeyVault. Applicable if keySource is
     'Microsoft.KeyVault'.
    :vartype identity: ~azure.mgmt.netapp.models.EncryptionIdentity
    """

    key_source: Optional[Union[str, "_models.KeySource"]] = rest_field(
        name="keySource", visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp,
     Microsoft.KeyVault. Known values are: \"Microsoft.NetApp\" and \"Microsoft.KeyVault\"."""
    key_vault_properties: Optional["_models.KeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'."""
    identity: Optional["_models.EncryptionIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'."""

    @overload
    def __init__(
        self,
        *,
        key_source: Optional[Union[str, "_models.KeySource"]] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        identity: Optional["_models.EncryptionIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountProperties(_Model):
    """NetApp account properties.

    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar active_directories: Active Directories.
    :vartype active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    :ivar encryption: Encryption settings.
    :vartype encryption: ~azure.mgmt.netapp.models.AccountEncryption
    :ivar disable_showmount: Shows the status of disableShowmount for all volumes under the
     subscription, null equals false.
    :vartype disable_showmount: bool
    :ivar nfs_v4_id_domain: Domain for NFSv4 user ID mapping. This property will be set for all
     NetApp accounts in the subscription and region and only affect non ldap NFSv4 volumes.
    :vartype nfs_v4_id_domain: str
    :ivar multi_ad_status: MultiAD Status for the account. Known values are: "Disabled" and
     "Enabled".
    :vartype multi_ad_status: str or ~azure.mgmt.netapp.models.MultiAdStatus
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    active_directories: Optional[list["_models.ActiveDirectory"]] = rest_field(
        name="activeDirectories", visibility=["read", "create", "update", "delete", "query"]
    )
    """Active Directories."""
    encryption: Optional["_models.AccountEncryption"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption settings."""
    disable_showmount: Optional[bool] = rest_field(name="disableShowmount", visibility=["read"])
    """Shows the status of disableShowmount for all volumes under the subscription, null equals false."""
    nfs_v4_id_domain: Optional[str] = rest_field(
        name="nfsV4IDDomain", visibility=["read", "create", "update", "delete", "query"]
    )
    """Domain for NFSv4 user ID mapping. This property will be set for all NetApp accounts in the
     subscription and region and only affect non ldap NFSv4 volumes."""
    multi_ad_status: Optional[Union[str, "_models.MultiAdStatus"]] = rest_field(
        name="multiAdStatus", visibility=["read"]
    )
    """MultiAD Status for the account. Known values are: \"Disabled\" and \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        active_directories: Optional[list["_models.ActiveDirectory"]] = None,
        encryption: Optional["_models.AccountEncryption"] = None,
        nfs_v4_id_domain: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ActiveDirectory(_Model):
    """Active Directory.

    :ivar active_directory_id: Id of the Active Directory.
    :vartype active_directory_id: str
    :ivar username: A domain user account with permission to create machine accounts.
    :vartype username: str
    :ivar password: Plain text password of Active Directory domain administrator, value is masked
     in the response.
    :vartype password: str
    :ivar domain: Name of the Active Directory domain.
    :vartype domain: str
    :ivar dns: Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory
     domain.
    :vartype dns: str
    :ivar status: Status of the Active Directory. Known values are: "Created", "InUse", "Deleted",
     "Error", and "Updating".
    :vartype status: str or ~azure.mgmt.netapp.models.ActiveDirectoryStatus
    :ivar status_details: Any details in regards to the Status of the Active Directory.
    :vartype status_details: str
    :ivar smb_server_name: NetBIOS name of the SMB server. This name will be registered as a
     computer account in the AD and used to mount volumes.
    :vartype smb_server_name: str
    :ivar organizational_unit: The Organizational Unit (OU) within the Windows Active Directory.
    :vartype organizational_unit: str
    :ivar site: The Active Directory site the service will limit Domain Controller discovery to.
    :vartype site: str
    :ivar backup_operators: Users to be added to the Built-in Backup Operator active directory
     group. A list of unique usernames without domain specifier.
    :vartype backup_operators: list[str]
    :ivar administrators: Users to be added to the Built-in Administrators active directory group.
     A list of unique usernames without domain specifier.
    :vartype administrators: list[str]
    :ivar kdc_ip: kdc server IP address for the active directory machine. This optional parameter
     is used only while creating kerberos volume.
    :vartype kdc_ip: str
    :ivar ad_name: Name of the active directory machine. This optional parameter is used only while
     creating kerberos volume.
    :vartype ad_name: str
    :ivar server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is
     required to have base64 encoded Active Directory Certificate Service's self-signed root CA
     certificate, this optional parameter is used only for dual protocol with LDAP user-mapping
     volumes.
    :vartype server_root_ca_certificate: str
    :ivar aes_encryption: If enabled, AES encryption will be enabled for SMB communication.
    :vartype aes_encryption: bool
    :ivar ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
    :vartype ldap_signing: bool
    :ivar security_operators: Domain Users in the Active directory to be given SeSecurityPrivilege
     privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames
     without domain specifier.
    :vartype security_operators: list[str]
    :ivar ldap_over_tls: Specifies whether or not the LDAP traffic needs to be secured via TLS.
    :vartype ldap_over_tls: bool
    :ivar allow_local_nfs_users_with_ldap: If enabled, NFS client local users can also (in addition
     to LDAP users) access the NFS volumes.
    :vartype allow_local_nfs_users_with_ldap: bool
    :ivar encrypt_dc_connections: If enabled, Traffic between the SMB server to Domain Controller
     (DC) will be encrypted.
    :vartype encrypt_dc_connections: bool
    :ivar ldap_search_scope: LDAP Search scope options.
    :vartype ldap_search_scope: ~azure.mgmt.netapp.models.LdapSearchScopeOpt
    :ivar preferred_servers_for_ldap_client: Comma separated list of IPv4 addresses of preferred
     servers for LDAP client. At most two comma separated IPv4 addresses can be passed.
    :vartype preferred_servers_for_ldap_client: str
    """

    active_directory_id: Optional[str] = rest_field(
        name="activeDirectoryId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Id of the Active Directory."""
    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A domain user account with permission to create machine accounts."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Plain text password of Active Directory domain administrator, value is masked in the response."""
    domain: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the Active Directory domain."""
    dns: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain."""
    status: Optional[Union[str, "_models.ActiveDirectoryStatus"]] = rest_field(visibility=["read"])
    """Status of the Active Directory. Known values are: \"Created\", \"InUse\", \"Deleted\",
     \"Error\", and \"Updating\"."""
    status_details: Optional[str] = rest_field(name="statusDetails", visibility=["read"])
    """Any details in regards to the Status of the Active Directory."""
    smb_server_name: Optional[str] = rest_field(
        name="smbServerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetBIOS name of the SMB server. This name will be registered as a computer account in the AD
     and used to mount volumes."""
    organizational_unit: Optional[str] = rest_field(
        name="organizationalUnit", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Organizational Unit (OU) within the Windows Active Directory."""
    site: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Active Directory site the service will limit Domain Controller discovery to."""
    backup_operators: Optional[list[str]] = rest_field(
        name="backupOperators", visibility=["read", "create", "update", "delete", "query"]
    )
    """Users to be added to the Built-in Backup Operator active directory group. A list of unique
     usernames without domain specifier."""
    administrators: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Users to be added to the Built-in Administrators active directory group. A list of unique
     usernames without domain specifier."""
    kdc_ip: Optional[str] = rest_field(name="kdcIP", visibility=["read", "create", "update", "delete", "query"])
    """kdc server IP address for the active directory machine. This optional parameter is used only
     while creating kerberos volume."""
    ad_name: Optional[str] = rest_field(name="adName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the active directory machine. This optional parameter is used only while creating
     kerberos volume."""
    server_root_ca_certificate: Optional[str] = rest_field(
        name="serverRootCACertificate", visibility=["read", "create", "update", "delete", "query"]
    )
    """When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active
     Directory Certificate Service's self-signed root CA certificate, this optional parameter is
     used only for dual protocol with LDAP user-mapping volumes."""
    aes_encryption: Optional[bool] = rest_field(
        name="aesEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled, AES encryption will be enabled for SMB communication."""
    ldap_signing: Optional[bool] = rest_field(
        name="ldapSigning", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether or not the LDAP traffic needs to be signed."""
    security_operators: Optional[list[str]] = rest_field(
        name="securityOperators", visibility=["read", "create", "update", "delete", "query"]
    )
    """Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB
     Continuously available shares for SQL). A list of unique usernames without domain specifier."""
    ldap_over_tls: Optional[bool] = rest_field(
        name="ldapOverTLS", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether or not the LDAP traffic needs to be secured via TLS."""
    allow_local_nfs_users_with_ldap: Optional[bool] = rest_field(
        name="allowLocalNfsUsersWithLdap", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes."""
    encrypt_dc_connections: Optional[bool] = rest_field(
        name="encryptDCConnections", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted."""
    ldap_search_scope: Optional["_models.LdapSearchScopeOpt"] = rest_field(
        name="ldapSearchScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """LDAP Search scope options."""
    preferred_servers_for_ldap_client: Optional[str] = rest_field(
        name="preferredServersForLdapClient", visibility=["read", "create", "update", "delete", "query"]
    )
    """Comma separated list of IPv4 addresses of preferred servers for LDAP client. At most two comma
     separated IPv4 addresses can be passed."""

    @overload
    def __init__(
        self,
        *,
        active_directory_id: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        domain: Optional[str] = None,
        dns: Optional[str] = None,
        smb_server_name: Optional[str] = None,
        organizational_unit: Optional[str] = None,
        site: Optional[str] = None,
        backup_operators: Optional[list[str]] = None,
        administrators: Optional[list[str]] = None,
        kdc_ip: Optional[str] = None,
        ad_name: Optional[str] = None,
        server_root_ca_certificate: Optional[str] = None,
        aes_encryption: Optional[bool] = None,
        ldap_signing: Optional[bool] = None,
        security_operators: Optional[list[str]] = None,
        ldap_over_tls: Optional[bool] = None,
        allow_local_nfs_users_with_ldap: Optional[bool] = None,
        encrypt_dc_connections: Optional[bool] = None,
        ldap_search_scope: Optional["_models.LdapSearchScopeOpt"] = None,
        preferred_servers_for_ldap_client: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthorizeRequest(_Model):
    """Authorize request.

    :ivar remote_volume_resource_id: Resource id of the remote volume.
    :vartype remote_volume_resource_id: str
    """

    remote_volume_resource_id: Optional[str] = rest_field(
        name="remoteVolumeResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource id of the remote volume."""

    @overload
    def __init__(
        self,
        *,
        remote_volume_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    """


class Backup(ProxyResource):
    """Backup under a Backup Vault.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: Backup Properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.BackupProperties
    """

    properties: "_models.BackupProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Backup Properties. Required."""

    __flattened_items = [
        "backup_id",
        "creation_date",
        "snapshot_creation_date",
        "completion_date",
        "provisioning_state",
        "size",
        "label",
        "backup_type",
        "failure_reason",
        "volume_resource_id",
        "use_existing_snapshot",
        "snapshot_name",
        "backup_policy_resource_id",
        "is_large_volume",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.BackupProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupPatch(_Model):
    """Backup patch.

    :ivar properties: Backup Patch Properties.
    :vartype properties: ~azure.mgmt.netapp.models.BackupPatchProperties
    """

    properties: Optional["_models.BackupPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Patch Properties."""

    __flattened_items = ["label"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BackupPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupPatchProperties(_Model):
    """Backup patch properties.

    :ivar label: Label for backup.
    :vartype label: str
    """

    label: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Label for backup."""

    @overload
    def __init__(
        self,
        *,
        label: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupPolicy(TrackedResource):
    """Backup policy information.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Backup policy Properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.BackupPolicyProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.BackupPolicyProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup policy Properties. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = [
        "backup_policy_id",
        "provisioning_state",
        "daily_backups_to_keep",
        "weekly_backups_to_keep",
        "monthly_backups_to_keep",
        "volumes_assigned",
        "enabled",
        "volume_backups",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.BackupPolicyProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupPolicyPatch(_Model):
    """Backup policy Details for create and update.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Backup policy Properties.
    :vartype properties: ~azure.mgmt.netapp.models.BackupPolicyProperties
    """

    location: Optional[str] = rest_field(visibility=["read", "create"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.BackupPolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup policy Properties."""

    __flattened_items = [
        "backup_policy_id",
        "provisioning_state",
        "daily_backups_to_keep",
        "weekly_backups_to_keep",
        "monthly_backups_to_keep",
        "volumes_assigned",
        "enabled",
        "volume_backups",
    ]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BackupPolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupPolicyProperties(_Model):
    """Backup policy properties.

    :ivar backup_policy_id: Backup Policy GUID ID.
    :vartype backup_policy_id: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar daily_backups_to_keep: Daily backups count to keep.
    :vartype daily_backups_to_keep: int
    :ivar weekly_backups_to_keep: Weekly backups count to keep.
    :vartype weekly_backups_to_keep: int
    :ivar monthly_backups_to_keep: Monthly backups count to keep.
    :vartype monthly_backups_to_keep: int
    :ivar volumes_assigned: Volumes using current backup policy.
    :vartype volumes_assigned: int
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar volume_backups: A list of volumes assigned to this policy.
    :vartype volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    backup_policy_id: Optional[str] = rest_field(name="backupPolicyId", visibility=["read"])
    """Backup Policy GUID ID."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    daily_backups_to_keep: Optional[int] = rest_field(
        name="dailyBackupsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Daily backups count to keep."""
    weekly_backups_to_keep: Optional[int] = rest_field(
        name="weeklyBackupsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Weekly backups count to keep."""
    monthly_backups_to_keep: Optional[int] = rest_field(
        name="monthlyBackupsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Monthly backups count to keep."""
    volumes_assigned: Optional[int] = rest_field(name="volumesAssigned", visibility=["read"])
    """Volumes using current backup policy."""
    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The property to decide policy is enabled or not."""
    volume_backups: Optional[list["_models.VolumeBackups"]] = rest_field(name="volumeBackups", visibility=["read"])
    """A list of volumes assigned to this policy."""

    @overload
    def __init__(
        self,
        *,
        daily_backups_to_keep: Optional[int] = None,
        weekly_backups_to_keep: Optional[int] = None,
        monthly_backups_to_keep: Optional[int] = None,
        enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupProperties(_Model):
    """Backup properties.

    :ivar backup_id: UUID v4 used to identify the Backup.
    :vartype backup_id: str
    :ivar creation_date: The creation date of the backup.
    :vartype creation_date: ~datetime.datetime
    :ivar snapshot_creation_date: The snapshot creation date of the backup.
    :vartype snapshot_creation_date: ~datetime.datetime
    :ivar completion_date: The completion date of the backup.
    :vartype completion_date: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar size: Size of backup in bytes.
    :vartype size: int
    :ivar label: Label for backup.
    :vartype label: str
    :ivar backup_type: Type of backup Manual or Scheduled. Known values are: "Manual" and
     "Scheduled".
    :vartype backup_type: str or ~azure.mgmt.netapp.models.BackupType
    :ivar failure_reason: Failure reason.
    :vartype failure_reason: str
    :ivar volume_resource_id: ResourceId used to identify the Volume. Required.
    :vartype volume_resource_id: str
    :ivar use_existing_snapshot: Manual backup an already existing snapshot. This will always be
     false for scheduled backups and true/false for manual backups.
    :vartype use_existing_snapshot: bool
    :ivar snapshot_name: The name of the snapshot.
    :vartype snapshot_name: str
    :ivar backup_policy_resource_id: ResourceId used to identify the backup policy.
    :vartype backup_policy_resource_id: str
    :ivar is_large_volume: Specifies if the backup is for a large volume.
    :vartype is_large_volume: bool
    """

    backup_id: Optional[str] = rest_field(name="backupId", visibility=["read"])
    """UUID v4 used to identify the Backup."""
    creation_date: Optional[datetime.datetime] = rest_field(name="creationDate", visibility=["read"], format="rfc3339")
    """The creation date of the backup."""
    snapshot_creation_date: Optional[datetime.datetime] = rest_field(
        name="snapshotCreationDate", visibility=["read"], format="rfc3339"
    )
    """The snapshot creation date of the backup."""
    completion_date: Optional[datetime.datetime] = rest_field(
        name="completionDate", visibility=["read"], format="rfc3339"
    )
    """The completion date of the backup."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    size: Optional[int] = rest_field(visibility=["read"])
    """Size of backup in bytes."""
    label: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Label for backup."""
    backup_type: Optional[Union[str, "_models.BackupType"]] = rest_field(name="backupType", visibility=["read"])
    """Type of backup Manual or Scheduled. Known values are: \"Manual\" and \"Scheduled\"."""
    failure_reason: Optional[str] = rest_field(name="failureReason", visibility=["read"])
    """Failure reason."""
    volume_resource_id: str = rest_field(name="volumeResourceId", visibility=["read", "create"])
    """ResourceId used to identify the Volume. Required."""
    use_existing_snapshot: Optional[bool] = rest_field(name="useExistingSnapshot", visibility=["read", "create"])
    """Manual backup an already existing snapshot. This will always be false for scheduled backups and
     true/false for manual backups."""
    snapshot_name: Optional[str] = rest_field(name="snapshotName", visibility=["read", "create"])
    """The name of the snapshot."""
    backup_policy_resource_id: Optional[str] = rest_field(name="backupPolicyResourceId", visibility=["read"])
    """ResourceId used to identify the backup policy."""
    is_large_volume: Optional[bool] = rest_field(name="isLargeVolume", visibility=["read"])
    """Specifies if the backup is for a large volume."""

    @overload
    def __init__(
        self,
        *,
        volume_resource_id: str,
        label: Optional[str] = None,
        use_existing_snapshot: Optional[bool] = None,
        snapshot_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupRestoreFiles(_Model):
    """Restore payload for Single File Backup Restore.

    :ivar file_list: List of files to be restored. Required.
    :vartype file_list: list[str]
    :ivar restore_file_path: Destination folder where the files will be restored. The path name
     should start with a forward slash. If it is omitted from request then restore is done at the
     root folder of the destination volume by default.
    :vartype restore_file_path: str
    :ivar destination_volume_id: Resource Id of the destination volume on which the files need to
     be restored. Required.
    :vartype destination_volume_id: str
    """

    file_list: list[str] = rest_field(name="fileList", visibility=["read", "create", "update", "delete", "query"])
    """List of files to be restored. Required."""
    restore_file_path: Optional[str] = rest_field(
        name="restoreFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Destination folder where the files will be restored. The path name should start with a forward
     slash. If it is omitted from request then restore is done at the root folder of the destination
     volume by default."""
    destination_volume_id: str = rest_field(
        name="destinationVolumeId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Id of the destination volume on which the files need to be restored. Required."""

    @overload
    def __init__(
        self,
        *,
        file_list: list[str],
        destination_volume_id: str,
        restore_file_path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupsMigrationRequest(_Model):
    """Migrate Backups Request.

    :ivar backup_vault_id: The ResourceId of the Backup Vault. Required.
    :vartype backup_vault_id: str
    """

    backup_vault_id: str = rest_field(name="backupVaultId", visibility=["read", "create", "update", "delete", "query"])
    """The ResourceId of the Backup Vault. Required."""

    @overload
    def __init__(
        self,
        *,
        backup_vault_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupStatus(_Model):
    """Backup status.

    :ivar healthy: Backup health status.
    :vartype healthy: bool
    :ivar relationship_status: Status of the backup mirror relationship. Known values are: "Idle",
     "Transferring", "Failed", and "Unknown".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.VolumeBackupRelationshipStatus
    :ivar mirror_state: The status of the backup. Known values are: "Uninitialized", "Mirrored",
     and "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar unhealthy_reason: Reason for the unhealthy backup relationship.
    :vartype unhealthy_reason: str
    :ivar error_message: Displays error message if the backup is in an error state.
    :vartype error_message: str
    :ivar last_transfer_size: Displays the last transfer size.
    :vartype last_transfer_size: int
    :ivar last_transfer_type: Displays the last transfer type.
    :vartype last_transfer_type: str
    :ivar total_transfer_bytes: Displays the total bytes transferred.
    :vartype total_transfer_bytes: int
    :ivar transfer_progress_bytes: Displays the total number of bytes transferred for the ongoing
     operation.
    :vartype transfer_progress_bytes: int
    """

    healthy: Optional[bool] = rest_field(visibility=["read"])
    """Backup health status."""
    relationship_status: Optional[Union[str, "_models.VolumeBackupRelationshipStatus"]] = rest_field(
        name="relationshipStatus", visibility=["read"]
    )
    """Status of the backup mirror relationship. Known values are: \"Idle\", \"Transferring\",
     \"Failed\", and \"Unknown\"."""
    mirror_state: Optional[Union[str, "_models.MirrorState"]] = rest_field(name="mirrorState", visibility=["read"])
    """The status of the backup. Known values are: \"Uninitialized\", \"Mirrored\", and \"Broken\"."""
    unhealthy_reason: Optional[str] = rest_field(name="unhealthyReason", visibility=["read"])
    """Reason for the unhealthy backup relationship."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """Displays error message if the backup is in an error state."""
    last_transfer_size: Optional[int] = rest_field(name="lastTransferSize", visibility=["read"])
    """Displays the last transfer size."""
    last_transfer_type: Optional[str] = rest_field(name="lastTransferType", visibility=["read"])
    """Displays the last transfer type."""
    total_transfer_bytes: Optional[int] = rest_field(name="totalTransferBytes", visibility=["read"])
    """Displays the total bytes transferred."""
    transfer_progress_bytes: Optional[int] = rest_field(name="transferProgressBytes", visibility=["read"])
    """Displays the total number of bytes transferred for the ongoing operation."""


class BackupVault(TrackedResource):
    """Backup Vault information.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Backup Vault Properties.
    :vartype properties: ~azure.mgmt.netapp.models.BackupVaultProperties
    """

    properties: Optional["_models.BackupVaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Vault Properties."""

    __flattened_items = ["provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BackupVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BackupVaultPatch(_Model):
    """Backup Vault information.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupVaultProperties(_Model):
    """Backup Vault properties.

    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""


class BreakFileLocksRequest(_Model):
    """Break file locks request.

    :ivar client_ip: To clear file locks on a volume for a particular client.
    :vartype client_ip: str
    :ivar confirm_running_disruptive_operation: Break File locks could be a disruptive operation
     for application as locks on the volume will be broken, if want to process, set to true.
    :vartype confirm_running_disruptive_operation: bool
    """

    client_ip: Optional[str] = rest_field(name="clientIp", visibility=["read", "create", "update", "delete", "query"])
    """To clear file locks on a volume for a particular client."""
    confirm_running_disruptive_operation: Optional[bool] = rest_field(
        name="confirmRunningDisruptiveOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Break File locks could be a disruptive operation for application as locks on the volume will be
     broken, if want to process, set to true."""

    @overload
    def __init__(
        self,
        *,
        client_ip: Optional[str] = None,
        confirm_running_disruptive_operation: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BreakReplicationRequest(_Model):
    """Break replication request.

    :ivar force_break_replication: If replication is in status transferring and you want to force
     break the replication, set to true.
    :vartype force_break_replication: bool
    """

    force_break_replication: Optional[bool] = rest_field(
        name="forceBreakReplication", visibility=["read", "create", "update", "delete", "query"]
    )
    """If replication is in status transferring and you want to force break the replication, set to
     true."""

    @overload
    def __init__(
        self,
        *,
        force_break_replication: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CapacityPool(TrackedResource):
    """Capacity pool resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Capacity pool properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.PoolProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.PoolProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Capacity pool properties. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = [
        "pool_id",
        "size",
        "service_level",
        "provisioning_state",
        "total_throughput_mibps",
        "utilized_throughput_mibps",
        "custom_throughput_mibps",
        "qos_type",
        "cool_access",
        "encryption_type",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.PoolProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CapacityPoolPatch(_Model):
    """Capacity pool patch resource.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Capacity pool properties.
    :vartype properties: ~azure.mgmt.netapp.models.PoolPatchProperties
    """

    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.PoolPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Capacity pool properties."""

    __flattened_items = ["size", "qos_type", "cool_access", "custom_throughput_mibps"]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.PoolPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ChangeKeyVault(_Model):
    """Change key vault request.

    :ivar key_vault_uri: The URI of the key vault/managed HSM that should be used for encryption.
     Required.
    :vartype key_vault_uri: str
    :ivar key_name: The name of the key that should be used for encryption. Required.
    :vartype key_name: str
    :ivar key_vault_resource_id: Azure resource ID of the key vault/managed HSM that should be used
     for encryption.
    :vartype key_vault_resource_id: str
    :ivar key_vault_private_endpoints: Pairs of virtual network ID and private endpoint ID. Every
     virtual network that has volumes encrypted with customer-managed keys needs its own key vault
     private endpoint. Required.
    :vartype key_vault_private_endpoints: list[~azure.mgmt.netapp.models.KeyVaultPrivateEndpoint]
    """

    key_vault_uri: str = rest_field(name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"])
    """The URI of the key vault/managed HSM that should be used for encryption. Required."""
    key_name: str = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the key that should be used for encryption. Required."""
    key_vault_resource_id: Optional[str] = rest_field(
        name="keyVaultResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the key vault/managed HSM that should be used for encryption."""
    key_vault_private_endpoints: list["_models.KeyVaultPrivateEndpoint"] = rest_field(
        name="keyVaultPrivateEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes
     encrypted with customer-managed keys needs its own key vault private endpoint. Required."""

    @overload
    def __init__(
        self,
        *,
        key_vault_uri: str,
        key_name: str,
        key_vault_private_endpoints: list["_models.KeyVaultPrivateEndpoint"],
        key_vault_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckAvailabilityResponse(_Model):
    """Information regarding availability of a resource.

    :ivar is_available: <code>true</code> indicates name is valid and available. <code>false</code>
     indicates the name is invalid, unavailable, or both.
    :vartype is_available: bool
    :ivar reason: <code>Invalid</code> indicates the name provided does not match Azure App Service
     naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and
     is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.netapp.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    is_available: Optional[bool] = rest_field(
        name="isAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """<code>true</code> indicates name is valid and available. <code>false</code> indicates the name
     is invalid, unavailable, or both."""
    reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """<code>Invalid</code> indicates the name provided does not match Azure App Service naming
     requirements. <code>AlreadyExists</code> indicates that the name is already in use and is
     therefore unavailable. Known values are: \"Invalid\" and \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If reason == invalid, provide the user with the reason why the given name is invalid, and
     provide the resource naming requirements so that the user can select a valid name. If reason ==
     AlreadyExists, explain that resource name is already in use, and direct them to select a
     different name."""

    @overload
    def __init__(
        self,
        *,
        is_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterPeerCommandResponse(_Model):
    """Information about cluster peering process.

    :ivar peer_accept_command: A command that needs to be run on the external ONTAP to accept
     cluster peering.  Will only be present if <code>clusterPeeringStatus</code> is
     <code>pending</code>.
    :vartype peer_accept_command: str
    """

    peer_accept_command: Optional[str] = rest_field(
        name="peerAcceptCommand", visibility=["read", "create", "update", "delete", "query"]
    )
    """A command that needs to be run on the external ONTAP to accept cluster peering.  Will only be
     present if <code>clusterPeeringStatus</code> is <code>pending</code>."""

    @overload
    def __init__(
        self,
        *,
        peer_accept_command: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DailySchedule(_Model):
    """Daily Schedule properties.

    :ivar snapshots_to_keep: Daily snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: int
    """

    snapshots_to_keep: Optional[int] = rest_field(
        name="snapshotsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Daily snapshot count to keep."""
    hour: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which hour in UTC timezone a snapshot should be taken."""
    minute: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which minute snapshot should be taken."""
    used_bytes: Optional[int] = rest_field(name="usedBytes", visibility=["read", "create", "update", "delete", "query"])
    """Resource size in bytes, current storage usage for the volume in bytes."""

    @overload
    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DestinationReplication(_Model):
    """Destination replication properties.

    :ivar resource_id: The resource ID of the remote volume.
    :vartype resource_id: str
    :ivar replication_type: Indicates whether the replication is cross zone or cross region. Known
     values are: "CrossRegionReplication" and "CrossZoneReplication".
    :vartype replication_type: str or ~azure.mgmt.netapp.models.ReplicationType
    :ivar region: The remote region for the destination volume.
    :vartype region: str
    :ivar zone: The remote zone for the destination volume.
    :vartype zone: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of the remote volume."""
    replication_type: Optional[Union[str, "_models.ReplicationType"]] = rest_field(
        name="replicationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the replication is cross zone or cross region. Known values are:
     \"CrossRegionReplication\" and \"CrossZoneReplication\"."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The remote region for the destination volume."""
    zone: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The remote zone for the destination volume."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        replication_type: Optional[Union[str, "_models.ReplicationType"]] = None,
        region: Optional[str] = None,
        zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Dimension(_Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display name of dimension."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of dimension."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionIdentity(_Model):
    """Identity used to authenticate with key vault.

    :ivar principal_id: The principal ID (object ID) of the identity used to authenticate with key
     vault. Read-only.
    :vartype principal_id: str
    :ivar user_assigned_identity: The ARM resource identifier of the user assigned identity used to
     authenticate with key vault. Applicable if identity.type has 'UserAssigned'. It should match
     key of identity.userAssignedIdentities.
    :vartype user_assigned_identity: str
    :ivar federated_client_id: ClientId of the multi-tenant Entra ID Application. Used to access
     cross-tenant keyvaults.
    :vartype federated_client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID (object ID) of the identity used to authenticate with key vault. Read-only."""
    user_assigned_identity: Optional[str] = rest_field(
        name="userAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM resource identifier of the user assigned identity used to authenticate with key vault.
     Applicable if identity.type has 'UserAssigned'. It should match key of
     identity.userAssignedIdentities."""
    federated_client_id: Optional[str] = rest_field(
        name="federatedClientId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ClientId of the multi-tenant Entra ID Application. Used to access cross-tenant keyvaults."""

    @overload
    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        federated_client_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionTransitionRequest(_Model):
    """Encryption transition request.

    :ivar virtual_network_id: Identifier for the virtual network. Required.
    :vartype virtual_network_id: str
    :ivar private_endpoint_id: Identifier of the private endpoint to reach the Azure Key Vault.
     Required.
    :vartype private_endpoint_id: str
    """

    virtual_network_id: str = rest_field(
        name="virtualNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier for the virtual network. Required."""
    private_endpoint_id: str = rest_field(
        name="privateEndpointId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the private endpoint to reach the Azure Key Vault. Required."""

    @overload
    def __init__(
        self,
        *,
        virtual_network_id: str,
        private_endpoint_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.netapp.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.netapp.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.netapp.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportPolicyRule(_Model):
    """Volume Export Policy Rule.

    :ivar rule_index: Order index.
    :vartype rule_index: int
    :ivar unix_read_only: Read only access.
    :vartype unix_read_only: bool
    :ivar unix_read_write: Read and write access.
    :vartype unix_read_write: bool
    :ivar kerberos5_read_only: Kerberos5 Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_read_only: bool
    :ivar kerberos5_read_write: Kerberos5 Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_read_write: bool
    :ivar kerberos5_i_read_only: Kerberos5i Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_i_read_only: bool
    :ivar kerberos5_i_read_write: Kerberos5i Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_i_read_write: bool
    :ivar kerberos5_p_read_only: Kerberos5p Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_p_read_only: bool
    :ivar kerberos5_p_read_write: Kerberos5p Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_p_read_write: bool
    :ivar cifs: Allows CIFS protocol.
    :vartype cifs: bool
    :ivar nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes.
    :vartype nfsv3: bool
    :ivar nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes.
    :vartype nfsv41: bool
    :ivar allowed_clients: Client ingress specification as comma separated string with IPv4 CIDRs,
     IPv4 host addresses and host names.
    :vartype allowed_clients: str
    :ivar has_root_access: Has root access to volume.
    :vartype has_root_access: bool
    :ivar chown_mode: This parameter specifies who is authorized to change the ownership of a file.
     restricted - Only root user can change the ownership of the file. unrestricted - Non-root users
     can change ownership of files that they own. Known values are: "Restricted" and "Unrestricted".
    :vartype chown_mode: str or ~azure.mgmt.netapp.models.ChownMode
    """

    rule_index: Optional[int] = rest_field(name="ruleIndex", visibility=["read", "create", "update", "delete", "query"])
    """Order index."""
    unix_read_only: Optional[bool] = rest_field(
        name="unixReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Read only access."""
    unix_read_write: Optional[bool] = rest_field(
        name="unixReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """Read and write access."""
    kerberos5_read_only: Optional[bool] = rest_field(
        name="kerberos5ReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later."""
    kerberos5_read_write: Optional[bool] = rest_field(
        name="kerberos5ReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later."""
    kerberos5_i_read_only: Optional[bool] = rest_field(
        name="kerberos5iReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later."""
    kerberos5_i_read_write: Optional[bool] = rest_field(
        name="kerberos5iReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later."""
    kerberos5_p_read_only: Optional[bool] = rest_field(
        name="kerberos5pReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later."""
    kerberos5_p_read_write: Optional[bool] = rest_field(
        name="kerberos5pReadWrite", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later."""
    cifs: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Allows CIFS protocol."""
    nfsv3: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Allows NFSv3 protocol. Enable only for NFSv3 type volumes."""
    nfsv41: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes."""
    allowed_clients: Optional[str] = rest_field(
        name="allowedClients", visibility=["read", "create", "update", "delete", "query"]
    )
    """Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and
     host names."""
    has_root_access: Optional[bool] = rest_field(
        name="hasRootAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Has root access to volume."""
    chown_mode: Optional[Union[str, "_models.ChownMode"]] = rest_field(
        name="chownMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """This parameter specifies who is authorized to change the ownership of a file. restricted - Only
     root user can change the ownership of the file. unrestricted - Non-root users can change
     ownership of files that they own. Known values are: \"Restricted\" and \"Unrestricted\"."""

    @overload
    def __init__(
        self,
        *,
        rule_index: Optional[int] = None,
        unix_read_only: Optional[bool] = None,
        unix_read_write: Optional[bool] = None,
        kerberos5_read_only: Optional[bool] = None,
        kerberos5_read_write: Optional[bool] = None,
        kerberos5_i_read_only: Optional[bool] = None,
        kerberos5_i_read_write: Optional[bool] = None,
        kerberos5_p_read_only: Optional[bool] = None,
        kerberos5_p_read_write: Optional[bool] = None,
        cifs: Optional[bool] = None,
        nfsv3: Optional[bool] = None,
        nfsv41: Optional[bool] = None,
        allowed_clients: Optional[str] = None,
        has_root_access: Optional[bool] = None,
        chown_mode: Optional[Union[str, "_models.ChownMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FilePathAvailabilityRequest(_Model):
    """File path availability request content - availability is based on the name and the subnetId.

    :ivar name: File path to verify. Required.
    :vartype name: str
    :ivar subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Required.
    :vartype subnet_id: str
    :ivar availability_zone: The Azure Resource logical availability zone which is used within zone
     mapping lookup for the subscription and region. The lookup will retrieve the physical zone
     where volume is placed.
    :vartype availability_zone: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """File path to verify. Required."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Required."""
    availability_zone: Optional[str] = rest_field(
        name="availabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Resource logical availability zone which is used within zone mapping lookup for the
     subscription and region. The lookup will retrieve the physical zone where volume is placed."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        subnet_id: str,
        availability_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetGroupIdListForLDAPUserRequest(_Model):
    """Get group Id list for LDAP User request.

    :ivar username: username is required to fetch the group to which user is part of. Required.
    :vartype username: str
    """

    username: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """username is required to fetch the group to which user is part of. Required."""

    @overload
    def __init__(
        self,
        *,
        username: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetGroupIdListForLDAPUserResponse(_Model):
    """Group Id list for Ldap user.

    :ivar group_ids_for_ldap_user: Group Id list.
    :vartype group_ids_for_ldap_user: list[str]
    """

    group_ids_for_ldap_user: Optional[list[str]] = rest_field(
        name="groupIdsForLdapUser", visibility=["read", "create", "update", "delete", "query"]
    )
    """Group Id list."""

    @overload
    def __init__(
        self,
        *,
        group_ids_for_ldap_user: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetKeyVaultStatusResponse(_Model):
    """Result of getKeyVaultStatus with information about how volumes under NetApp account are
    encrypted.

    :ivar properties: Represents the properties of the getKeyVaultStatus.
    :vartype properties: ~azure.mgmt.netapp.models.GetKeyVaultStatusResponseProperties
    """

    properties: Optional["_models.GetKeyVaultStatusResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the properties of the getKeyVaultStatus."""

    __flattened_items = ["key_vault_uri", "key_name", "key_vault_resource_id", "key_vault_private_endpoints"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GetKeyVaultStatusResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GetKeyVaultStatusResponseProperties(_Model):
    """Properties which represents Change key vault status.

    :ivar key_vault_uri: The URI of the key vault/managed HSM that should be used for encryption.
    :vartype key_vault_uri: str
    :ivar key_name: The name of the key that should be used for encryption.
    :vartype key_name: str
    :ivar key_vault_resource_id: Azure resource ID of the key vault/managed HSM that should be used
     for encryption.
    :vartype key_vault_resource_id: str
    :ivar key_vault_private_endpoints: Pairs of virtual network ID and private endpoint ID. Every
     virtual network that has volumes encrypted with customer-managed keys needs its own key vault
     private endpoint.
    :vartype key_vault_private_endpoints: list[~azure.mgmt.netapp.models.KeyVaultPrivateEndpoint]
    """

    key_vault_uri: Optional[str] = rest_field(
        name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URI of the key vault/managed HSM that should be used for encryption."""
    key_name: Optional[str] = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the key that should be used for encryption."""
    key_vault_resource_id: Optional[str] = rest_field(
        name="keyVaultResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure resource ID of the key vault/managed HSM that should be used for encryption."""
    key_vault_private_endpoints: Optional[list["_models.KeyVaultPrivateEndpoint"]] = rest_field(
        name="keyVaultPrivateEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes
     encrypted with customer-managed keys needs its own key vault private endpoint."""

    @overload
    def __init__(
        self,
        *,
        key_vault_uri: Optional[str] = None,
        key_name: Optional[str] = None,
        key_vault_resource_id: Optional[str] = None,
        key_vault_private_endpoints: Optional[list["_models.KeyVaultPrivateEndpoint"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HourlySchedule(_Model):
    """Hourly Schedule properties.

    :ivar snapshots_to_keep: Hourly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: int
    """

    snapshots_to_keep: Optional[int] = rest_field(
        name="snapshotsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Hourly snapshot count to keep."""
    minute: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which minute snapshot should be taken."""
    used_bytes: Optional[int] = rest_field(name="usedBytes", visibility=["read", "create", "update", "delete", "query"])
    """Resource size in bytes, current storage usage for the volume in bytes."""

    @overload
    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultPrivateEndpoint(_Model):
    """Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes
    encrypted with customer-managed keys needs its own key vault private endpoint.

    :ivar virtual_network_id: Identifier for the virtual network id.
    :vartype virtual_network_id: str
    :ivar private_endpoint_id: Identifier of the private endpoint to reach the Azure Key Vault.
    :vartype private_endpoint_id: str
    """

    virtual_network_id: Optional[str] = rest_field(
        name="virtualNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier for the virtual network id."""
    private_endpoint_id: Optional[str] = rest_field(
        name="privateEndpointId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the private endpoint to reach the Azure Key Vault."""

    @overload
    def __init__(
        self,
        *,
        virtual_network_id: Optional[str] = None,
        private_endpoint_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultProperties(_Model):
    """Properties of key vault.

    :ivar key_vault_id: UUID v4 used to identify the Azure Key Vault configuration.
    :vartype key_vault_id: str
    :ivar key_vault_uri: The Uri of KeyVault. Required.
    :vartype key_vault_uri: str
    :ivar key_name: The name of KeyVault key. Required.
    :vartype key_name: str
    :ivar key_vault_resource_id: The resource ID of KeyVault.
    :vartype key_vault_resource_id: str
    :ivar status: Status of the KeyVault connection. Known values are: "Created", "InUse",
     "Deleted", "Error", and "Updating".
    :vartype status: str or ~azure.mgmt.netapp.models.KeyVaultStatus
    """

    key_vault_id: Optional[str] = rest_field(name="keyVaultId", visibility=["read"])
    """UUID v4 used to identify the Azure Key Vault configuration."""
    key_vault_uri: str = rest_field(name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"])
    """The Uri of KeyVault. Required."""
    key_name: str = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of KeyVault key. Required."""
    key_vault_resource_id: Optional[str] = rest_field(
        name="keyVaultResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of KeyVault."""
    status: Optional[Union[str, "_models.KeyVaultStatus"]] = rest_field(visibility=["read"])
    """Status of the KeyVault connection. Known values are: \"Created\", \"InUse\", \"Deleted\",
     \"Error\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        key_vault_uri: str,
        key_name: str,
        key_vault_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LdapSearchScopeOpt(_Model):
    """LDAP search scope.

    :ivar user_dn: This specifies the user DN, which overrides the base DN for user lookups.
    :vartype user_dn: str
    :ivar group_dn: This specifies the group DN, which overrides the base DN for group lookups.
    :vartype group_dn: str
    :ivar group_membership_filter: This specifies the custom LDAP search filter to be used when
     looking up group membership from LDAP server.
    :vartype group_membership_filter: str
    """

    user_dn: Optional[str] = rest_field(name="userDN", visibility=["read", "create", "update", "delete", "query"])
    """This specifies the user DN, which overrides the base DN for user lookups."""
    group_dn: Optional[str] = rest_field(name="groupDN", visibility=["read", "create", "update", "delete", "query"])
    """This specifies the group DN, which overrides the base DN for group lookups."""
    group_membership_filter: Optional[str] = rest_field(
        name="groupMembershipFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """This specifies the custom LDAP search filter to be used when looking up group membership from
     LDAP server."""

    @overload
    def __init__(
        self,
        *,
        user_dn: Optional[str] = None,
        group_dn: Optional[str] = None,
        group_membership_filter: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListQuotaReportResponse(_Model):
    """Quota Report for volume.

    :ivar quota_report_records: List of quota reports.
    :vartype quota_report_records: list[~azure.mgmt.netapp.models.QuotaReport]
    """

    quota_report_records: Optional[list["_models.QuotaReport"]] = rest_field(
        name="quotaReportRecords", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of quota reports."""

    @overload
    def __init__(
        self,
        *,
        quota_report_records: Optional[list["_models.QuotaReport"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListQuotaReportResult(_Model):
    """

    * Result of ListQuotaReportResponse.

    :ivar properties: Represents the properties of the ListQuotaReport.
    :vartype properties: ~azure.mgmt.netapp.models.ListQuotaReportResponse
    """

    properties: Optional["_models.ListQuotaReportResponse"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the properties of the ListQuotaReport."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ListQuotaReportResponse"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListReplicationsRequest(_Model):
    """Body for the list replications endpoint. If supplied, the body will be used as a filter for
    example to exclude deleted replications. If omitted, the endpoint returns all replications.

    :ivar exclude: Exclude Replications filter. 'None' returns all replications, 'Deleted' excludes
     deleted replications. Default is 'None'. Known values are: "None" and "Deleted".
    :vartype exclude: str or ~azure.mgmt.netapp.models.Exclude
    """

    exclude: Optional[Union[str, "_models.Exclude"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Exclude Replications filter. 'None' returns all replications, 'Deleted' excludes deleted
     replications. Default is 'None'. Known values are: \"None\" and \"Deleted\"."""

    @overload
    def __init__(
        self,
        *,
        exclude: Optional[Union[str, "_models.Exclude"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogSpecification(_Model):
    """Log Definition of a single resource metric.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of log specification."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of log specification."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.netapp.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.netapp.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricSpecification(_Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar supported_aggregation_types: Support metric aggregation type.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.netapp.models.MetricAggregationType]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    :ivar enable_regional_mdm_account: Whether or not the service is using regional MDM accounts.
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.netapp.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    :ivar is_internal: Whether the metric is internal.
    :vartype is_internal: bool
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of metric specification."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of metric specification."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display description of metric specification."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit could be Bytes or Count."""
    supported_aggregation_types: Optional[list[Union[str, "_models.MetricAggregationType"]]] = rest_field(
        name="supportedAggregationTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Support metric aggregation type."""
    supported_time_grain_types: Optional[list[str]] = rest_field(
        name="supportedTimeGrainTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The supported time grain types for the metrics."""
    internal_metric_name: Optional[str] = rest_field(
        name="internalMetricName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The internal metric name."""
    enable_regional_mdm_account: Optional[bool] = rest_field(
        name="enableRegionalMdmAccount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether or not the service is using regional MDM accounts."""
    source_mdm_account: Optional[str] = rest_field(
        name="sourceMdmAccount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source MDM account."""
    source_mdm_namespace: Optional[str] = rest_field(
        name="sourceMdmNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source MDM namespace."""
    dimensions: Optional[list["_models.Dimension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Dimensions of blobs, including blob type and access tier."""
    aggregation_type: Optional[str] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Aggregation type could be Average."""
    fill_gap_with_zero: Optional[bool] = rest_field(
        name="fillGapWithZero", visibility=["read", "create", "update", "delete", "query"]
    )
    """The property to decide fill gap with zero or not."""
    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The category this metric specification belong to, could be Capacity."""
    resource_id_dimension_name_override: Optional[str] = rest_field(
        name="resourceIdDimensionNameOverride", visibility=["read", "create", "update", "delete", "query"]
    )
    """Account Resource Id."""
    is_internal: Optional[bool] = rest_field(
        name="isInternal", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the metric is internal."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        supported_aggregation_types: Optional[list[Union[str, "_models.MetricAggregationType"]]] = None,
        supported_time_grain_types: Optional[list[str]] = None,
        internal_metric_name: Optional[str] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        dimensions: Optional[list["_models.Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        is_internal: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MonthlySchedule(_Model):
    """Monthly Schedule properties.

    :ivar snapshots_to_keep: Monthly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar days_of_month: Indicates which days of the month snapshot should be taken. A comma
     delimited string.
    :vartype days_of_month: str
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: int
    """

    snapshots_to_keep: Optional[int] = rest_field(
        name="snapshotsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Monthly snapshot count to keep."""
    days_of_month: Optional[str] = rest_field(
        name="daysOfMonth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates which days of the month snapshot should be taken. A comma delimited string."""
    hour: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which hour in UTC timezone a snapshot should be taken."""
    minute: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which minute snapshot should be taken."""
    used_bytes: Optional[int] = rest_field(name="usedBytes", visibility=["read", "create", "update", "delete", "query"])
    """Resource size in bytes, current storage usage for the volume in bytes."""

    @overload
    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        days_of_month: Optional[str] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MountTargetProperties(_Model):
    """Mount target properties.

    :ivar mount_target_id: UUID v4 used to identify the MountTarget.
    :vartype mount_target_id: str
    :ivar file_system_id: UUID v4 used to identify the MountTarget. Required.
    :vartype file_system_id: str
    :ivar ip_address: The mount target's IPv4 address.
    :vartype ip_address: str
    :ivar smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
    :vartype smb_server_fqdn: str
    """

    mount_target_id: Optional[str] = rest_field(name="mountTargetId", visibility=["read"])
    """UUID v4 used to identify the MountTarget."""
    file_system_id: str = rest_field(name="fileSystemId", visibility=["read", "create", "update", "delete", "query"])
    """UUID v4 used to identify the MountTarget. Required."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """The mount target's IPv4 address."""
    smb_server_fqdn: Optional[str] = rest_field(
        name="smbServerFqdn", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SMB server's Fully Qualified Domain Name, FQDN."""

    @overload
    def __init__(
        self,
        *,
        file_system_id: str,
        smb_server_fqdn: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetAppAccount(TrackedResource):
    """NetApp account resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: NetApp Account properties.
    :vartype properties: ~azure.mgmt.netapp.models.AccountProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.netapp.models.ManagedServiceIdentity
    """

    properties: Optional["_models.AccountProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """NetApp Account properties."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    __flattened_items = [
        "provisioning_state",
        "active_directories",
        "encryption",
        "disable_showmount",
        "nfs_v4_id_domain",
        "multi_ad_status",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.AccountProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class NetAppAccountPatch(_Model):
    """NetApp account patch resource.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: NetApp Account properties.
    :vartype properties: ~azure.mgmt.netapp.models.AccountProperties
    :ivar identity: The identity used for the resource.
    :vartype identity: ~azure.mgmt.netapp.models.ManagedServiceIdentity
    """

    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.AccountProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """NetApp Account properties."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity used for the resource."""

    __flattened_items = [
        "provisioning_state",
        "active_directories",
        "encryption",
        "disable_showmount",
        "nfs_v4_id_domain",
        "multi_ad_status",
    ]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.AccountProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class NetworkSiblingSet(_Model):
    """Describes the contents of a network sibling set.

    :ivar network_sibling_set_id: Network Sibling Set ID for a group of volumes sharing networking
     resources in a subnet.
    :vartype network_sibling_set_id: str
    :ivar subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}.
    :vartype subnet_id: str
    :ivar network_sibling_set_state_id: Network sibling set state Id identifying the current state
     of the sibling set.
    :vartype network_sibling_set_state_id: str
    :ivar network_features: Network features available to the volume, or current state of update.
     Known values are: "Basic", "Standard", "Basic_Standard", and "Standard_Basic".
    :vartype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    :ivar provisioning_state: Gets the status of the NetworkSiblingSet at the time the operation
     was called. Known values are: "Succeeded", "Failed", "Canceled", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.netapp.models.NetworkSiblingSetProvisioningState
    :ivar nic_info_list: List of NIC information.
    :vartype nic_info_list: list[~azure.mgmt.netapp.models.NicInfo]
    """

    network_sibling_set_id: Optional[str] = rest_field(
        name="networkSiblingSetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network Sibling Set ID for a group of volumes sharing networking resources in a subnet."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create"])
    """The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}."""
    network_sibling_set_state_id: Optional[str] = rest_field(
        name="networkSiblingSetStateId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network sibling set state Id identifying the current state of the sibling set."""
    network_features: Optional[Union[str, "_models.NetworkFeatures"]] = rest_field(
        name="networkFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network features available to the volume, or current state of update. Known values are:
     \"Basic\", \"Standard\", \"Basic_Standard\", and \"Standard_Basic\"."""
    provisioning_state: Optional[Union[str, "_models.NetworkSiblingSetProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets the status of the NetworkSiblingSet at the time the operation was called. Known values
     are: \"Succeeded\", \"Failed\", \"Canceled\", and \"Updating\"."""
    nic_info_list: Optional[list["_models.NicInfo"]] = rest_field(
        name="nicInfoList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of NIC information."""

    @overload
    def __init__(
        self,
        *,
        network_sibling_set_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        network_sibling_set_state_id: Optional[str] = None,
        network_features: Optional[Union[str, "_models.NetworkFeatures"]] = None,
        nic_info_list: Optional[list["_models.NicInfo"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NicInfo(_Model):
    """NIC information and list of volumes for which the NIC has the primary mount IP Address.

    :ivar ip_address: IP Address.
    :vartype ip_address: str
    :ivar volume_resource_ids: Volume resource Ids.
    :vartype volume_resource_ids: list[str]
    """

    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read"])
    """IP Address."""
    volume_resource_ids: Optional[list[str]] = rest_field(
        name="volumeResourceIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume resource Ids."""

    @overload
    def __init__(
        self,
        *,
        volume_resource_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Microsoft.NetApp REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.netapp.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar properties: Properties of operation, include metric specifications.
    :vartype properties: ~azure.mgmt.netapp.models.OperationProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation name: {provider}/{resource}/{operation}."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Display metadata associated with the operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The origin of operations."""
    properties: Optional["_models.OperationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of operation, include metric specifications."""

    __flattened_items = ["service_specification"]

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class OperationDisplay(_Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft NetApp.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Service provider: Microsoft NetApp."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource on which the operation is performed etc."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of operation: get, read, delete, etc."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation description."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationProperties(_Model):
    """Properties of operation, include metric specifications.

    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.netapp.models.ServiceSpecification
    """

    service_specification: Optional["_models.ServiceSpecification"] = rest_field(
        name="serviceSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """One property of operation, include metric specifications."""

    @overload
    def __init__(
        self,
        *,
        service_specification: Optional["_models.ServiceSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PeerClusterForVolumeMigrationRequest(_Model):
    """Source Cluster properties for a cluster peer request.

    :ivar peer_ip_addresses: A list of IC-LIF IPs that can be used to connect to the On-prem
     cluster. Required.
    :vartype peer_ip_addresses: list[str]
    """

    peer_ip_addresses: list[str] = rest_field(
        name="peerIpAddresses", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of IC-LIF IPs that can be used to connect to the On-prem cluster. Required."""

    @overload
    def __init__(
        self,
        *,
        peer_ip_addresses: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlacementKeyValuePairs(_Model):
    """Application specific parameters for the placement of volumes in the volume group.

    :ivar key: Key for an application specific parameter for the placement of volumes in the volume
     group. Required.
    :vartype key: str
    :ivar value: Value for an application specific parameter for the placement of volumes in the
     volume group. Required.
    :vartype value: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key for an application specific parameter for the placement of volumes in the volume group.
     Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Value for an application specific parameter for the placement of volumes in the volume group.
     Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PoolChangeRequest(_Model):
    """Pool change request.

    :ivar new_pool_resource_id: Resource id of the pool to move volume to. Required.
    :vartype new_pool_resource_id: str
    """

    new_pool_resource_id: str = rest_field(
        name="newPoolResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource id of the pool to move volume to. Required."""

    @overload
    def __init__(
        self,
        *,
        new_pool_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PoolPatchProperties(_Model):
    """Patchable pool properties.

    :ivar size: Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value
     must be multiple of 1099511627776).
    :vartype size: int
    :ivar qos_type: The qos type of the pool. Known values are: "Auto" and "Manual".
    :vartype qos_type: str or ~azure.mgmt.netapp.models.QosType
    :ivar cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
    :vartype cool_access: bool
    :ivar custom_throughput_mibps: Maximum throughput in MiB/s that can be achieved by this pool
     and this will be accepted as input only for manual qosType pool with Flexible service level.
    :vartype custom_throughput_mibps: int
    """

    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be
     multiple of 1099511627776)."""
    qos_type: Optional[Union[str, "_models.QosType"]] = rest_field(
        name="qosType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The qos type of the pool. Known values are: \"Auto\" and \"Manual\"."""
    cool_access: Optional[bool] = rest_field(
        name="coolAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled (true) the pool can contain cool Access enabled volumes."""
    custom_throughput_mibps: Optional[int] = rest_field(
        name="customThroughputMibps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum throughput in MiB/s that can be achieved by this pool and this will be accepted as
     input only for manual qosType pool with Flexible service level."""

    @overload
    def __init__(
        self,
        *,
        size: Optional[int] = None,
        qos_type: Optional[Union[str, "_models.QosType"]] = None,
        cool_access: Optional[bool] = None,
        custom_throughput_mibps: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PoolProperties(_Model):
    """Pool properties.

    :ivar pool_id: UUID v4 used to identify the Pool.
    :vartype pool_id: str
    :ivar size: Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value
     must be multiple of 1099511627776). Required.
    :vartype size: int
    :ivar service_level: The service level of the file system. Required. Known values are:
     "Standard", "Premium", "Ultra", "StandardZRS", and "Flexible".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar total_throughput_mibps: Total throughput of pool in MiB/s.
    :vartype total_throughput_mibps: float
    :ivar utilized_throughput_mibps: Utilized throughput of pool in MiB/s.
    :vartype utilized_throughput_mibps: float
    :ivar custom_throughput_mibps: Maximum throughput in MiB/s that can be achieved by this pool
     and this will be accepted as input only for manual qosType pool with Flexible service level.
    :vartype custom_throughput_mibps: int
    :ivar qos_type: The qos type of the pool. Known values are: "Auto" and "Manual".
    :vartype qos_type: str or ~azure.mgmt.netapp.models.QosType
    :ivar cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
    :vartype cool_access: bool
    :ivar encryption_type: Encryption type of the capacity pool, set encryption type for data at
     rest for this pool and all volumes in it. This value can only be set when creating new pool.
     Known values are: "Single" and "Double".
    :vartype encryption_type: str or ~azure.mgmt.netapp.models.EncryptionType
    """

    pool_id: Optional[str] = rest_field(name="poolId", visibility=["read"])
    """UUID v4 used to identify the Pool."""
    size: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be
     multiple of 1099511627776). Required."""
    service_level: Union[str, "_models.ServiceLevel"] = rest_field(
        name="serviceLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The service level of the file system. Required. Known values are: \"Standard\", \"Premium\",
     \"Ultra\", \"StandardZRS\", and \"Flexible\"."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    total_throughput_mibps: Optional[float] = rest_field(name="totalThroughputMibps", visibility=["read"])
    """Total throughput of pool in MiB/s."""
    utilized_throughput_mibps: Optional[float] = rest_field(name="utilizedThroughputMibps", visibility=["read"])
    """Utilized throughput of pool in MiB/s."""
    custom_throughput_mibps: Optional[int] = rest_field(
        name="customThroughputMibps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum throughput in MiB/s that can be achieved by this pool and this will be accepted as
     input only for manual qosType pool with Flexible service level."""
    qos_type: Optional[Union[str, "_models.QosType"]] = rest_field(
        name="qosType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The qos type of the pool. Known values are: \"Auto\" and \"Manual\"."""
    cool_access: Optional[bool] = rest_field(
        name="coolAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled (true) the pool can contain cool Access enabled volumes."""
    encryption_type: Optional[Union[str, "_models.EncryptionType"]] = rest_field(
        name="encryptionType", visibility=["read", "create"]
    )
    """Encryption type of the capacity pool, set encryption type for data at rest for this pool and
     all volumes in it. This value can only be set when creating new pool. Known values are:
     \"Single\" and \"Double\"."""

    @overload
    def __init__(
        self,
        *,
        size: int,
        service_level: Union[str, "_models.ServiceLevel"],
        custom_throughput_mibps: Optional[int] = None,
        qos_type: Optional[Union[str, "_models.QosType"]] = None,
        cool_access: Optional[bool] = None,
        encryption_type: Optional[Union[str, "_models.EncryptionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QueryNetworkSiblingSetRequest(_Model):
    """Network sibling set query.

    :ivar network_sibling_set_id: Network Sibling Set ID for a group of volumes sharing networking
     resources in a subnet. Required.
    :vartype network_sibling_set_id: str
    :ivar subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}.
     Required.
    :vartype subnet_id: str
    """

    network_sibling_set_id: str = rest_field(
        name="networkSiblingSetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network Sibling Set ID for a group of volumes sharing networking resources in a subnet.
     Required."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create"])
    """The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}.
     Required."""

    @overload
    def __init__(
        self,
        *,
        network_sibling_set_id: str,
        subnet_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaAvailabilityRequest(_Model):
    """Quota availability request content.

    :ivar name: Name of the resource to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots",
     "Microsoft.NetApp/netAppAccounts/backupVaults/backups", and
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/backups".
    :vartype type: str or ~azure.mgmt.netapp.models.CheckQuotaNameResourceTypes
    :ivar resource_group: Resource group name. Required.
    :vartype resource_group: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the resource to verify. Required."""
    type: Union[str, "_models.CheckQuotaNameResourceTypes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource type used for verification. Required. Known values are:
     \"Microsoft.NetApp/netAppAccounts\", \"Microsoft.NetApp/netAppAccounts/capacityPools\",
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes\",
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots\",
     \"Microsoft.NetApp/netAppAccounts/backupVaults/backups\", and
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes/backups\"."""
    resource_group: str = rest_field(name="resourceGroup", visibility=["read", "create", "update", "delete", "query"])
    """Resource group name. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckQuotaNameResourceTypes"],
        resource_group: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaItem(ProxyResource):
    """Information regarding Quota Item.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: QuotaItem properties.
    :vartype properties: ~azure.mgmt.netapp.models.QuotaItemProperties
    """

    properties: Optional["_models.QuotaItemProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """QuotaItem properties."""

    __flattened_items = ["current", "default", "usage"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.QuotaItemProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class QuotaItemProperties(_Model):
    """QuotaItem Properties.

    :ivar current: The current quota value.
    :vartype current: int
    :ivar default: The default quota value.
    :vartype default: int
    :ivar usage: The usage quota value.
    :vartype usage: int
    """

    current: Optional[int] = rest_field(visibility=["read"])
    """The current quota value."""
    default: Optional[int] = rest_field(visibility=["read"])
    """The default quota value."""
    usage: Optional[int] = rest_field(visibility=["read"])
    """The usage quota value."""


class QuotaReport(_Model):
    """Quota report record properties.

    :ivar quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
     "IndividualUserQuota", and "IndividualGroupQuota".
    :vartype quota_type: str or ~azure.mgmt.netapp.models.QuotaType
    :ivar quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID can
     be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
     running <wmic useraccount where name='user-name' get sid>.
    :vartype quota_target: str
    :ivar quota_limit_used_in_ki_bs: Specifies the current usage in kibibytes for the user/group
     quota.
    :vartype quota_limit_used_in_ki_bs: int
    :ivar quota_limit_total_in_ki_bs: Specifies the total size limit in kibibytes for the
     user/group quota.
    :vartype quota_limit_total_in_ki_bs: int
    :ivar percentage_used: Percentage of used size compared to total size.
    :vartype percentage_used: float
    :ivar is_derived_quota: Flag to indicate whether the quota is derived from default quota.
    :vartype is_derived_quota: bool
    """

    quota_type: Optional[Union[str, "_models.QuotaType"]] = rest_field(
        name="quotaType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of quota. Known values are: \"DefaultUserQuota\", \"DefaultGroupQuota\",
     \"IndividualUserQuota\", and \"IndividualGroupQuota\"."""
    quota_target: Optional[str] = rest_field(
        name="quotaTarget", visibility=["read", "create", "update", "delete", "query"]
    )
    """UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running
     ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic
     useraccount where name='user-name' get sid>."""
    quota_limit_used_in_ki_bs: Optional[int] = rest_field(
        name="quotaLimitUsedInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the current usage in kibibytes for the user/group quota."""
    quota_limit_total_in_ki_bs: Optional[int] = rest_field(
        name="quotaLimitTotalInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the total size limit in kibibytes for the user/group quota."""
    percentage_used: Optional[float] = rest_field(
        name="percentageUsed", visibility=["read", "create", "update", "delete", "query"]
    )
    """Percentage of used size compared to total size."""
    is_derived_quota: Optional[bool] = rest_field(
        name="isDerivedQuota", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to indicate whether the quota is derived from default quota."""

    @overload
    def __init__(
        self,
        *,
        quota_type: Optional[Union[str, "_models.QuotaType"]] = None,
        quota_target: Optional[str] = None,
        quota_limit_used_in_ki_bs: Optional[int] = None,
        quota_limit_total_in_ki_bs: Optional[int] = None,
        percentage_used: Optional[float] = None,
        is_derived_quota: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuotaReportFilterRequest(_Model):
    """Quota report filters. When filtering by quotaType or quotaTarget, both properties must be
    supplied together. This constraint is enforced by the service/API at runtime, and requests
    violating this rule will return a validation error. The usageThresholdPercentage filter is
    independent and can be used alone or in combination with quotaType and quotaTarget to further
    refine results.

    :ivar quota_type: Type of quota. If provided, quotaTarget must also be specified. The quotaType
     and quotaTarget properties are optional, but when filtering by quota type, quotaType and
     quotaTarget must be supplied together. Service/API will return an error if only one is
     provided. Known values are: "DefaultUserQuota", "DefaultGroupQuota", "IndividualUserQuota", and
     "IndividualGroupQuota".
    :vartype quota_type: str or ~azure.mgmt.netapp.models.QuotaType
    :ivar quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID can
     be found by running 'id' or 'getent' command for the user or group and SID can be found by
     running <wmic useraccount where name='user-name' get sid>. If provided, quotaType must also be
     specified. The quotaType and quotaTarget properties are optional, but when filtering by quota
     target, quotaType and quotaTarget must be supplied together. Service/API will return an error
     if only one is provided.
    :vartype quota_target: str
    :ivar usage_threshold_percentage: The usageThresholdPercentage filter takes the usage threshold
     percentage and returns records where the usage is greater than or equal to the input value.
     This is an optional property.
    :vartype usage_threshold_percentage: int
    """

    quota_type: Optional[Union[str, "_models.QuotaType"]] = rest_field(
        name="quotaType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of quota. If provided, quotaTarget must also be specified. The quotaType and quotaTarget
     properties are optional, but when filtering by quota type, quotaType and quotaTarget must be
     supplied together. Service/API will return an error if only one is provided. Known values are:
     \"DefaultUserQuota\", \"DefaultGroupQuota\", \"IndividualUserQuota\", and
     \"IndividualGroupQuota\"."""
    quota_target: Optional[str] = rest_field(
        name="quotaTarget", visibility=["read", "create", "update", "delete", "query"]
    )
    """UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running
     'id' or 'getent' command for the user or group and SID can be found by running <wmic
     useraccount where name='user-name' get sid>. If provided, quotaType must also be specified. The
     quotaType and quotaTarget properties are optional, but when filtering by quota target,
     quotaType and quotaTarget must be supplied together. Service/API will return an error if only
     one is provided."""
    usage_threshold_percentage: Optional[int] = rest_field(
        name="usageThresholdPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The usageThresholdPercentage filter takes the usage threshold percentage and returns records
     where the usage is greater than or equal to the input value. This is an optional property."""

    @overload
    def __init__(
        self,
        *,
        quota_type: Optional[Union[str, "_models.QuotaType"]] = None,
        quota_target: Optional[str] = None,
        usage_threshold_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RansomwareProtectionPatchSettings(_Model):
    """Advanced Ransomware Protection reports (ARP) updatable settings.

    :ivar desired_ransomware_protection_state: The desired value of the ARP feature state available
     to the volume. Known values are: "Disabled" and "Enabled".
    :vartype desired_ransomware_protection_state: str or
     ~azure.mgmt.netapp.models.DesiredRansomwareProtectionState
    """

    desired_ransomware_protection_state: Optional[Union[str, "_models.DesiredRansomwareProtectionState"]] = rest_field(
        name="desiredRansomwareProtectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired value of the ARP feature state available to the volume. Known values are:
     \"Disabled\" and \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        desired_ransomware_protection_state: Optional[Union[str, "_models.DesiredRansomwareProtectionState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RansomwareProtectionSettings(_Model):
    """Advanced Ransomware Protection reports (ARP) settings.

    :ivar desired_ransomware_protection_state: The desired value of the Advanced Ransomware
     Protection feature state available to the volume. Known values are: "Disabled" and "Enabled".
    :vartype desired_ransomware_protection_state: str or
     ~azure.mgmt.netapp.models.DesiredRansomwareProtectionState
    :ivar actual_ransomware_protection_state: The actual state of the Advanced Ransomware
     Protection feature currently active on the volume. Known values are: "Disabled", "Enabled",
     "Learning", and "Paused".
    :vartype actual_ransomware_protection_state: str or
     ~azure.mgmt.netapp.models.ActualRansomwareProtectionState
    """

    desired_ransomware_protection_state: Optional[Union[str, "_models.DesiredRansomwareProtectionState"]] = rest_field(
        name="desiredRansomwareProtectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired value of the Advanced Ransomware Protection feature state available to the volume.
     Known values are: \"Disabled\" and \"Enabled\"."""
    actual_ransomware_protection_state: Optional[Union[str, "_models.ActualRansomwareProtectionState"]] = rest_field(
        name="actualRansomwareProtectionState", visibility=["read"]
    )
    """The actual state of the Advanced Ransomware Protection feature currently active on the volume.
     Known values are: \"Disabled\", \"Enabled\", \"Learning\", and \"Paused\"."""

    @overload
    def __init__(
        self,
        *,
        desired_ransomware_protection_state: Optional[Union[str, "_models.DesiredRansomwareProtectionState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RansomwareReport(ProxyResource):
    """Advanced Ransomware Protection (ARP) report Get details of the specified Advanced Ransomware
    Protection report (ARP). ARP reports are created with a list of suspected files when it detects
    any combination of high data entropy, abnormal volume activity with data encryption, and
    unusual file extensions. ARP creates snapshots named Anti_ransomware_backup when it detects a
    potential ransomware threat. You can use one of these ARP snapshots or another snapshot of your
    volume to restore data.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: Advanced Ransomware Protection reports Properties.
    :vartype properties: ~azure.mgmt.netapp.models.RansomwareReportProperties
    """

    properties: Optional["_models.RansomwareReportProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Advanced Ransomware Protection reports Properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RansomwareReportProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RansomwareReportProperties(_Model):
    """Advanced Ransomware Protection (ARP) report properties.

    Evaluate the report to determine whether the activity is acceptable (false positive) or whether
    an attack seems malicious using the ClearSuspects operation.

    Advanced Ransomware Protection (ARP) creates snapshots named Anti_ransomware_backup when it
    detects a potential ransomware threat. You can use one of the ARP snapshots or another snapshot
    of your volume to restore data.

    :ivar event_time: The creation date and time of the report.
    :vartype event_time: ~datetime.datetime
    :ivar state: State of the Advanced Ransomware Protection (ARP) report. Known values are:
     "Active" and "Resolved".
    :vartype state: str or ~azure.mgmt.netapp.models.RansomwareReportState
    :ivar severity: Severity of the Advanced Ransomware Protection (ARP) report. Known values are:
     "None", "Low", "Moderate", and "High".
    :vartype severity: str or ~azure.mgmt.netapp.models.RansomwareReportSeverity
    :ivar cleared_count: The number of cleared suspects identified by the ARP report.
    :vartype cleared_count: int
    :ivar reported_count: The number of suspects identified by the ARP report.
    :vartype reported_count: int
    :ivar suspects: Suspects identified in an ARP report.
    :vartype suspects: list[~azure.mgmt.netapp.models.RansomwareSuspects]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    event_time: Optional[datetime.datetime] = rest_field(name="eventTime", visibility=["read"], format="rfc3339")
    """The creation date and time of the report."""
    state: Optional[Union[str, "_models.RansomwareReportState"]] = rest_field(visibility=["read"])
    """State of the Advanced Ransomware Protection (ARP) report. Known values are: \"Active\" and
     \"Resolved\"."""
    severity: Optional[Union[str, "_models.RansomwareReportSeverity"]] = rest_field(visibility=["read"])
    """Severity of the Advanced Ransomware Protection (ARP) report. Known values are: \"None\",
     \"Low\", \"Moderate\", and \"High\"."""
    cleared_count: Optional[int] = rest_field(name="clearedCount", visibility=["read"])
    """The number of cleared suspects identified by the ARP report."""
    reported_count: Optional[int] = rest_field(name="reportedCount", visibility=["read"])
    """The number of suspects identified by the ARP report."""
    suspects: Optional[list["_models.RansomwareSuspects"]] = rest_field(visibility=["read"])
    """Suspects identified in an ARP report."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""


class RansomwareSuspects(_Model):
    """List of suspects identified in an Advanced Ransomware Protection (ARP) report.

    :ivar extension: Suspect File extension.
    :vartype extension: str
    :ivar resolution: ARP report suspect resolution. Known values are: "PotentialThreat" and
     "FalsePositive".
    :vartype resolution: str or ~azure.mgmt.netapp.models.RansomwareSuspectResolution
    :ivar file_count: The number of suspect files at the time of ARP report, this number can change
     as files get created and report status progresses.
    :vartype file_count: int
    :ivar suspect_files: Suspect files.
    :vartype suspect_files: list[~azure.mgmt.netapp.models.SuspectFile]
    """

    extension: Optional[str] = rest_field(visibility=["read"])
    """Suspect File extension."""
    resolution: Optional[Union[str, "_models.RansomwareSuspectResolution"]] = rest_field(visibility=["read"])
    """ARP report suspect resolution. Known values are: \"PotentialThreat\" and \"FalsePositive\"."""
    file_count: Optional[int] = rest_field(name="fileCount", visibility=["read"])
    """The number of suspect files at the time of ARP report, this number can change as files get
     created and report status progresses."""
    suspect_files: Optional[list["_models.SuspectFile"]] = rest_field(name="suspectFiles", visibility=["read"])
    """Suspect files."""


class RansomwareSuspectsClearRequest(_Model):
    """Clear suspects for Advanced Ransomware Protection (ARP) report.

    :ivar resolution: ARP report suspect resolution. Required. Known values are: "PotentialThreat"
     and "FalsePositive".
    :vartype resolution: str or ~azure.mgmt.netapp.models.RansomwareSuspectResolution
    :ivar extensions: List of file extensions resolved (PotentialThreat or FalsePositive).
     Required.
    :vartype extensions: list[str]
    """

    resolution: Union[str, "_models.RansomwareSuspectResolution"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """ARP report suspect resolution. Required. Known values are: \"PotentialThreat\" and
     \"FalsePositive\"."""
    extensions: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of file extensions resolved (PotentialThreat or FalsePositive). Required."""

    @overload
    def __init__(
        self,
        *,
        resolution: Union[str, "_models.RansomwareSuspectResolution"],
        extensions: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReestablishReplicationRequest(_Model):
    """Re-establish request object supplied in the body of the operation.

    :ivar source_volume_id: Resource id of the source volume for the replication.
    :vartype source_volume_id: str
    """

    source_volume_id: Optional[str] = rest_field(
        name="sourceVolumeId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource id of the source volume for the replication."""

    @overload
    def __init__(
        self,
        *,
        source_volume_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegionInfo(_Model):
    """Provides region specific information.

    :ivar storage_to_network_proximity: Provides storage to network proximity information in the
     region. Known values are: "Default", "T1", "T2", "AcrossT2", "T1AndT2", "T1AndAcrossT2",
     "T2AndAcrossT2", and "T1AndT2AndAcrossT2".
    :vartype storage_to_network_proximity: str or
     ~azure.mgmt.netapp.models.RegionStorageToNetworkProximity
    :ivar availability_zone_mappings: Provides logical availability zone mappings for the
     subscription for a region.
    :vartype availability_zone_mappings:
     list[~azure.mgmt.netapp.models.RegionInfoAvailabilityZoneMappingsItem]
    """

    storage_to_network_proximity: Optional[Union[str, "_models.RegionStorageToNetworkProximity"]] = rest_field(
        name="storageToNetworkProximity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provides storage to network proximity information in the region. Known values are: \"Default\",
     \"T1\", \"T2\", \"AcrossT2\", \"T1AndT2\", \"T1AndAcrossT2\", \"T2AndAcrossT2\", and
     \"T1AndT2AndAcrossT2\"."""
    availability_zone_mappings: Optional[list["_models.RegionInfoAvailabilityZoneMappingsItem"]] = rest_field(
        name="availabilityZoneMappings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provides logical availability zone mappings for the subscription for a region."""

    @overload
    def __init__(
        self,
        *,
        storage_to_network_proximity: Optional[Union[str, "_models.RegionStorageToNetworkProximity"]] = None,
        availability_zone_mappings: Optional[list["_models.RegionInfoAvailabilityZoneMappingsItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegionInfoAvailabilityZoneMappingsItem(_Model):
    """RegionInfoAvailabilityZoneMappingsItem.

    :ivar availability_zone: Logical availability zone.
    :vartype availability_zone: str
    :ivar is_available: Available availability zone.
    :vartype is_available: bool
    """

    availability_zone: Optional[str] = rest_field(
        name="availabilityZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical availability zone."""
    is_available: Optional[bool] = rest_field(
        name="isAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available availability zone."""

    @overload
    def __init__(
        self,
        *,
        availability_zone: Optional[str] = None,
        is_available: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegionInfoResource(ProxyResource):
    """Information regarding regionInfo Item.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: regionInfo properties.
    :vartype properties: ~azure.mgmt.netapp.models.RegionInfo
    """

    properties: Optional["_models.RegionInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """regionInfo properties."""

    __flattened_items = ["storage_to_network_proximity", "availability_zone_mappings"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RegionInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class RelocateVolumeRequest(_Model):
    """Relocate volume request.

    :ivar creation_token: New creation token for the volume that controls the mount point name.
    :vartype creation_token: str
    """

    creation_token: Optional[str] = rest_field(
        name="creationToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """New creation token for the volume that controls the mount point name."""

    @overload
    def __init__(
        self,
        *,
        creation_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemotePath(_Model):
    """The full path to a volume that is to be migrated into ANF. Required for Migration volumes.

    :ivar external_host_name: The Path to a ONTAP Host. Required.
    :vartype external_host_name: str
    :ivar server_name: The name of a server on the ONTAP Host. Required.
    :vartype server_name: str
    :ivar volume_name: The name of a volume on the server. Required.
    :vartype volume_name: str
    """

    external_host_name: str = rest_field(
        name="externalHostName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Path to a ONTAP Host. Required."""
    server_name: str = rest_field(name="serverName", visibility=["read", "create", "update", "delete", "query"])
    """The name of a server on the ONTAP Host. Required."""
    volume_name: str = rest_field(name="volumeName", visibility=["read", "create", "update", "delete", "query"])
    """The name of a volume on the server. Required."""

    @overload
    def __init__(
        self,
        *,
        external_host_name: str,
        server_name: str,
        volume_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Replication(_Model):
    """Replication properties.

    :ivar replication_id: UUID v4 used to identify the replication.
    :vartype replication_id: str
    :ivar endpoint_type: Indicates whether the local volume is the source or destination for the
     Volume Replication. Known values are: "src" and "dst".
    :vartype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :ivar replication_schedule: Schedule. Known values are: "_10minutely", "hourly", and "daily".
    :vartype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
    :ivar remote_volume_resource_id: The resource ID of the remote volume.
    :vartype remote_volume_resource_id: str
    :ivar remote_volume_region: The remote region for the other end of the Volume Replication.
    :vartype remote_volume_region: str
    :ivar mirror_state: The status of the replication. Known values are: "Uninitialized",
     "Mirrored", and "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.ReplicationMirrorState
    :ivar replication_creation_time: Replication creation time.
    :vartype replication_creation_time: ~datetime.datetime
    :ivar replication_deletion_time: Replication deletion time.
    :vartype replication_deletion_time: ~datetime.datetime
    """

    replication_id: Optional[str] = rest_field(name="replicationId", visibility=["read"])
    """UUID v4 used to identify the replication."""
    endpoint_type: Optional[Union[str, "_models.EndpointType"]] = rest_field(
        name="endpointType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the local volume is the source or destination for the Volume Replication.
     Known values are: \"src\" and \"dst\"."""
    replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = rest_field(
        name="replicationSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule. Known values are: \"_10minutely\", \"hourly\", and \"daily\"."""
    remote_volume_resource_id: Optional[str] = rest_field(
        name="remoteVolumeResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of the remote volume."""
    remote_volume_region: Optional[str] = rest_field(
        name="remoteVolumeRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The remote region for the other end of the Volume Replication."""
    mirror_state: Optional[Union[str, "_models.ReplicationMirrorState"]] = rest_field(
        name="mirrorState", visibility=["read"]
    )
    """The status of the replication. Known values are: \"Uninitialized\", \"Mirrored\", and
     \"Broken\"."""
    replication_creation_time: Optional[datetime.datetime] = rest_field(
        name="replicationCreationTime", visibility=["read"], format="rfc3339"
    )
    """Replication creation time."""
    replication_deletion_time: Optional[datetime.datetime] = rest_field(
        name="replicationDeletionTime", visibility=["read"], format="rfc3339"
    )
    """Replication deletion time."""

    @overload
    def __init__(
        self,
        *,
        endpoint_type: Optional[Union[str, "_models.EndpointType"]] = None,
        replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = None,
        remote_volume_resource_id: Optional[str] = None,
        remote_volume_region: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationObject(_Model):
    """Replication properties.

    :ivar replication_id: Id.
    :vartype replication_id: str
    :ivar endpoint_type: Indicates whether the local volume is the source or destination for the
     Volume Replication. Known values are: "src" and "dst".
    :vartype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :ivar replication_schedule: Schedule. Known values are: "_10minutely", "hourly", and "daily".
    :vartype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
    :ivar remote_volume_resource_id: The resource ID of the remote volume. Required for cross
     region and cross zone replication.
    :vartype remote_volume_resource_id: str
    :ivar remote_path: The full path to a volume that is to be migrated into ANF. Required for
     Migration volumes.
    :vartype remote_path: ~azure.mgmt.netapp.models.RemotePath
    :ivar remote_volume_region: The remote region for the other end of the Volume Replication.
    :vartype remote_volume_region: str
    :ivar destination_replications: A list of destination replications.
    :vartype destination_replications: list[~azure.mgmt.netapp.models.DestinationReplication]
    """

    replication_id: Optional[str] = rest_field(name="replicationId", visibility=["read"])
    """Id."""
    endpoint_type: Optional[Union[str, "_models.EndpointType"]] = rest_field(name="endpointType", visibility=["read"])
    """Indicates whether the local volume is the source or destination for the Volume Replication.
     Known values are: \"src\" and \"dst\"."""
    replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = rest_field(
        name="replicationSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule. Known values are: \"_10minutely\", \"hourly\", and \"daily\"."""
    remote_volume_resource_id: Optional[str] = rest_field(name="remoteVolumeResourceId", visibility=["read", "create"])
    """The resource ID of the remote volume. Required for cross region and cross zone replication."""
    remote_path: Optional["_models.RemotePath"] = rest_field(name="remotePath", visibility=["read", "create"])
    """The full path to a volume that is to be migrated into ANF. Required for Migration volumes."""
    remote_volume_region: Optional[str] = rest_field(
        name="remoteVolumeRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The remote region for the other end of the Volume Replication."""
    destination_replications: Optional[list["_models.DestinationReplication"]] = rest_field(
        name="destinationReplications", visibility=["read"]
    )
    """A list of destination replications."""

    @overload
    def __init__(
        self,
        *,
        replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = None,
        remote_volume_resource_id: Optional[str] = None,
        remote_path: Optional["_models.RemotePath"] = None,
        remote_volume_region: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationStatus(_Model):
    """Replication status.

    :ivar healthy: Replication health check.
    :vartype healthy: bool
    :ivar relationship_status: Status of the mirror relationship. Known values are: "Idle" and
     "Transferring".
    :vartype relationship_status: str or
     ~azure.mgmt.netapp.models.VolumeReplicationRelationshipStatus
    :ivar mirror_state: The status of the replication. Known values are: "Uninitialized",
     "Mirrored", and "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar total_progress: The progress of the replication.
    :vartype total_progress: str
    :ivar error_message: Displays error message if the replication is in an error state.
    :vartype error_message: str
    """

    healthy: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Replication health check."""
    relationship_status: Optional[Union[str, "_models.VolumeReplicationRelationshipStatus"]] = rest_field(
        name="relationshipStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the mirror relationship. Known values are: \"Idle\" and \"Transferring\"."""
    mirror_state: Optional[Union[str, "_models.MirrorState"]] = rest_field(
        name="mirrorState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the replication. Known values are: \"Uninitialized\", \"Mirrored\", and
     \"Broken\"."""
    total_progress: Optional[str] = rest_field(
        name="totalProgress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The progress of the replication."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Displays error message if the replication is in an error state."""

    @overload
    def __init__(
        self,
        *,
        healthy: Optional[bool] = None,
        relationship_status: Optional[Union[str, "_models.VolumeReplicationRelationshipStatus"]] = None,
        mirror_state: Optional[Union[str, "_models.MirrorState"]] = None,
        total_progress: Optional[str] = None,
        error_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceNameAvailabilityRequest(_Model):
    """Resource name availability request content.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots",
     "Microsoft.NetApp/netAppAccounts/backupVaults/backups", and
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/backups".
    :vartype type: str or ~azure.mgmt.netapp.models.CheckNameResourceTypes
    :ivar resource_group: Resource group name. Required.
    :vartype resource_group: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name to verify. Required."""
    type: Union[str, "_models.CheckNameResourceTypes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource type used for verification. Required. Known values are:
     \"Microsoft.NetApp/netAppAccounts\", \"Microsoft.NetApp/netAppAccounts/capacityPools\",
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes\",
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots\",
     \"Microsoft.NetApp/netAppAccounts/backupVaults/backups\", and
     \"Microsoft.NetApp/netAppAccounts/capacityPools/volumes/backups\"."""
    resource_group: str = rest_field(name="resourceGroup", visibility=["read", "create", "update", "delete", "query"])
    """Resource group name. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckNameResourceTypes"],
        resource_group: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreStatus(_Model):
    """Restore status.

    :ivar healthy: Restore health status.
    :vartype healthy: bool
    :ivar relationship_status: Status of the restore SnapMirror relationship. Known values are:
     "Idle", "Transferring", "Failed", and "Unknown".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.VolumeRestoreRelationshipStatus
    :ivar mirror_state: The status of the restore. Known values are: "Uninitialized", "Mirrored",
     and "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar unhealthy_reason: Reason for the unhealthy restore relationship.
    :vartype unhealthy_reason: str
    :ivar error_message: Displays error message if the restore is in an error state.
    :vartype error_message: str
    :ivar total_transfer_bytes: Displays the total bytes transferred.
    :vartype total_transfer_bytes: int
    """

    healthy: Optional[bool] = rest_field(visibility=["read"])
    """Restore health status."""
    relationship_status: Optional[Union[str, "_models.VolumeRestoreRelationshipStatus"]] = rest_field(
        name="relationshipStatus", visibility=["read"]
    )
    """Status of the restore SnapMirror relationship. Known values are: \"Idle\", \"Transferring\",
     \"Failed\", and \"Unknown\"."""
    mirror_state: Optional[Union[str, "_models.MirrorState"]] = rest_field(name="mirrorState", visibility=["read"])
    """The status of the restore. Known values are: \"Uninitialized\", \"Mirrored\", and \"Broken\"."""
    unhealthy_reason: Optional[str] = rest_field(name="unhealthyReason", visibility=["read"])
    """Reason for the unhealthy restore relationship."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """Displays error message if the restore is in an error state."""
    total_transfer_bytes: Optional[int] = rest_field(name="totalTransferBytes", visibility=["read"])
    """Displays the total bytes transferred."""


class ServiceSpecification(_Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications: list[~azure.mgmt.netapp.models.MetricSpecification]
    :ivar log_specifications: Log specification of operation.
    :vartype log_specifications: list[~azure.mgmt.netapp.models.LogSpecification]
    """

    metric_specifications: Optional[list["_models.MetricSpecification"]] = rest_field(
        name="metricSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric specifications of operation."""
    log_specifications: Optional[list["_models.LogSpecification"]] = rest_field(
        name="logSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Log specification of operation."""

    @overload
    def __init__(
        self,
        *,
        metric_specifications: Optional[list["_models.MetricSpecification"]] = None,
        log_specifications: Optional[list["_models.LogSpecification"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Snapshot(ProxyResource):
    """Snapshot of a Volume.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: Snapshot Properties.
    :vartype properties: ~azure.mgmt.netapp.models.SnapshotProperties
    :ivar location: Resource location. Required.
    :vartype location: str
    """

    properties: Optional["_models.SnapshotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot Properties."""
    location: str = rest_field(visibility=["read", "create"])
    """Resource location. Required."""

    __flattened_items = ["snapshot_id", "created", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: Optional["_models.SnapshotProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SnapshotPatch(_Model):
    """Snapshot of a Volume."""


class SnapshotPolicy(TrackedResource):
    """Snapshot policy information.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Snapshot policy Properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.SnapshotPolicyProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    """

    properties: "_models.SnapshotPolicyProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot policy Properties. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""

    __flattened_items = [
        "hourly_schedule",
        "daily_schedule",
        "weekly_schedule",
        "monthly_schedule",
        "enabled",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.SnapshotPolicyProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SnapshotPolicyPatch(_Model):
    """Snapshot policy Details for create and update.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Snapshot Policy properties.
    :vartype properties: ~azure.mgmt.netapp.models.SnapshotPolicyProperties
    """

    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.SnapshotPolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot Policy properties."""

    __flattened_items = [
        "hourly_schedule",
        "daily_schedule",
        "weekly_schedule",
        "monthly_schedule",
        "enabled",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.SnapshotPolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SnapshotPolicyProperties(_Model):
    """Snapshot policy properties.

    :ivar hourly_schedule: Schedule for hourly snapshots.
    :vartype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :ivar daily_schedule: Schedule for daily snapshots.
    :vartype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :ivar weekly_schedule: Schedule for weekly snapshots.
    :vartype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :ivar monthly_schedule: Schedule for monthly snapshots.
    :vartype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    hourly_schedule: Optional["_models.HourlySchedule"] = rest_field(
        name="hourlySchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule for hourly snapshots."""
    daily_schedule: Optional["_models.DailySchedule"] = rest_field(
        name="dailySchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule for daily snapshots."""
    weekly_schedule: Optional["_models.WeeklySchedule"] = rest_field(
        name="weeklySchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule for weekly snapshots."""
    monthly_schedule: Optional["_models.MonthlySchedule"] = rest_field(
        name="monthlySchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Schedule for monthly snapshots."""
    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The property to decide policy is enabled or not."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""

    @overload
    def __init__(
        self,
        *,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        daily_schedule: Optional["_models.DailySchedule"] = None,
        weekly_schedule: Optional["_models.WeeklySchedule"] = None,
        monthly_schedule: Optional["_models.MonthlySchedule"] = None,
        enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SnapshotPolicyVolumeList(_Model):
    """Volumes associated with snapshot policy.

    :ivar value: The Volume items on this page. Required.
    :vartype value: list[~azure.mgmt.netapp.models.Volume]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    value: list["_models.Volume"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Volume items on this page. Required."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The link to the next page of items."""

    @overload
    def __init__(
        self,
        *,
        value: list["_models.Volume"],
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SnapshotProperties(_Model):
    """Snapshot properties.

    :ivar snapshot_id: UUID v4 used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar created: The creation date of the snapshot.
    :vartype created: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    snapshot_id: Optional[str] = rest_field(name="snapshotId", visibility=["read"])
    """UUID v4 used to identify the Snapshot."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc3339")
    """The creation date of the snapshot."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""


class SnapshotRestoreFiles(_Model):
    """Restore payload for Single File Snapshot Restore.

    :ivar file_paths: List of files to be restored. Required.
    :vartype file_paths: list[str]
    :ivar destination_path: Destination folder where the files will be restored.
    :vartype destination_path: str
    """

    file_paths: list[str] = rest_field(name="filePaths", visibility=["read", "create", "update", "delete", "query"])
    """List of files to be restored. Required."""
    destination_path: Optional[str] = rest_field(
        name="destinationPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Destination folder where the files will be restored."""

    @overload
    def __init__(
        self,
        *,
        file_paths: list[str],
        destination_path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubvolumeInfo(ProxyResource):
    """Subvolume Information properties.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: Subvolume Properties.
    :vartype properties: ~azure.mgmt.netapp.models.SubvolumeProperties
    """

    properties: Optional["_models.SubvolumeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subvolume Properties."""

    __flattened_items = ["path", "size", "parent_path", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubvolumeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubvolumeModel(_Model):
    """Result of the post subvolume and action is to get metadata of the subvolume.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: It represents the minimal properties of the subvolume.
    :vartype properties: ~azure.mgmt.netapp.models.SubvolumeModelProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    properties: Optional["_models.SubvolumeModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """It represents the minimal properties of the subvolume."""

    __flattened_items = [
        "path",
        "parent_path",
        "size",
        "bytes_used",
        "permissions",
        "creation_time_stamp",
        "accessed_time_stamp",
        "modified_time_stamp",
        "changed_time_stamp",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubvolumeModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubvolumeModelProperties(_Model):
    """Properties which represents actual subvolume model which is stored as a file in the system.

    :ivar path: Path to the subvolume.
    :vartype path: str
    :ivar parent_path: Path to the parent subvolume.
    :vartype parent_path: str
    :ivar size: Size of subvolume.
    :vartype size: int
    :ivar bytes_used: Bytes used.
    :vartype bytes_used: int
    :ivar permissions: Permissions of the subvolume.
    :vartype permissions: str
    :ivar creation_time_stamp: Creation time and date.
    :vartype creation_time_stamp: ~datetime.datetime
    :ivar accessed_time_stamp: Most recent access time and date.
    :vartype accessed_time_stamp: ~datetime.datetime
    :ivar modified_time_stamp: Most recent modification time and date.
    :vartype modified_time_stamp: ~datetime.datetime
    :ivar changed_time_stamp: Most recent change time and date.
    :vartype changed_time_stamp: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Path to the subvolume."""
    parent_path: Optional[str] = rest_field(
        name="parentPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Path to the parent subvolume."""
    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Size of subvolume."""
    bytes_used: Optional[int] = rest_field(name="bytesUsed", visibility=["read", "create", "update", "delete", "query"])
    """Bytes used."""
    permissions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Permissions of the subvolume."""
    creation_time_stamp: Optional[datetime.datetime] = rest_field(
        name="creationTimeStamp", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Creation time and date."""
    accessed_time_stamp: Optional[datetime.datetime] = rest_field(
        name="accessedTimeStamp", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Most recent access time and date."""
    modified_time_stamp: Optional[datetime.datetime] = rest_field(
        name="modifiedTimeStamp", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Most recent modification time and date."""
    changed_time_stamp: Optional[datetime.datetime] = rest_field(
        name="changedTimeStamp", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Most recent change time and date."""
    provisioning_state: Optional[str] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure lifecycle management."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        parent_path: Optional[str] = None,
        size: Optional[int] = None,
        bytes_used: Optional[int] = None,
        permissions: Optional[str] = None,
        creation_time_stamp: Optional[datetime.datetime] = None,
        accessed_time_stamp: Optional[datetime.datetime] = None,
        modified_time_stamp: Optional[datetime.datetime] = None,
        changed_time_stamp: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubvolumePatchParams(_Model):
    """Parameters with which a subvolume can be updated.

    :ivar size: Truncate subvolume to the provided size in bytes.
    :vartype size: int
    :ivar path: path to the subvolume.
    :vartype path: str
    """

    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Truncate subvolume to the provided size in bytes."""
    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """path to the subvolume."""

    @overload
    def __init__(
        self,
        *,
        size: Optional[int] = None,
        path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubvolumePatchRequest(_Model):
    """Subvolume Patch Request properties.

    :ivar properties: Subvolume Properties.
    :vartype properties: ~azure.mgmt.netapp.models.SubvolumePatchParams
    """

    properties: Optional["_models.SubvolumePatchParams"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subvolume Properties."""

    __flattened_items = ["size", "path"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubvolumePatchParams"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubvolumeProperties(_Model):
    """This represents path associated with the subvolume.

    :ivar path: Path to the subvolume.
    :vartype path: str
    :ivar size: Truncate subvolume to the provided size in bytes.
    :vartype size: int
    :ivar parent_path: parent path to the subvolume.
    :vartype parent_path: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Path to the subvolume."""
    size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Truncate subvolume to the provided size in bytes."""
    parent_path: Optional[str] = rest_field(
        name="parentPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """parent path to the subvolume."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        size: Optional[int] = None,
        parent_path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SuspectFile(_Model):
    """Suspect file information.

    :ivar suspect_file_name: Suspect filename.
    :vartype suspect_file_name: str
    :ivar file_timestamp: The creation date and time of the file.
    :vartype file_timestamp: ~datetime.datetime
    """

    suspect_file_name: Optional[str] = rest_field(name="suspectFileName", visibility=["read"])
    """Suspect filename."""
    file_timestamp: Optional[datetime.datetime] = rest_field(
        name="fileTimestamp", visibility=["read"], format="rfc3339"
    )
    """The creation date and time of the file."""


class SvmPeerCommandResponse(_Model):
    """Information about svm peering process.

    :ivar svm_peering_command: A command that needs to be run on the external ONTAP to accept svm
     peering.  Will only be present if <code>svmPeeringStatus</code> is <code>pending</code>.
    :vartype svm_peering_command: str
    """

    svm_peering_command: Optional[str] = rest_field(
        name="svmPeeringCommand", visibility=["read", "create", "update", "delete", "query"]
    )
    """A command that needs to be run on the external ONTAP to accept svm peering.  Will only be
     present if <code>svmPeeringStatus</code> is <code>pending</code>."""

    @overload
    def __init__(
        self,
        *,
        svm_peering_command: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateNetworkSiblingSetRequest(_Model):
    """Network sibling set update.

    :ivar network_sibling_set_id: Network Sibling Set ID for a group of volumes sharing networking
     resources in a subnet. Required.
    :vartype network_sibling_set_id: str
    :ivar subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}.
     Required.
    :vartype subnet_id: str
    :ivar network_sibling_set_state_id: Network sibling set state Id identifying the current state
     of the sibling set. Required.
    :vartype network_sibling_set_state_id: str
    :ivar network_features: Network features available to the volume. Required. Known values are:
     "Basic", "Standard", "Basic_Standard", and "Standard_Basic".
    :vartype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    """

    network_sibling_set_id: str = rest_field(
        name="networkSiblingSetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network Sibling Set ID for a group of volumes sharing networking resources in a subnet.
     Required."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create"])
    """The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Example
     /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}.
     Required."""
    network_sibling_set_state_id: str = rest_field(
        name="networkSiblingSetStateId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network sibling set state Id identifying the current state of the sibling set. Required."""
    network_features: Union[str, "_models.NetworkFeatures"] = rest_field(
        name="networkFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network features available to the volume. Required. Known values are: \"Basic\", \"Standard\",
     \"Basic_Standard\", and \"Standard_Basic\"."""

    @overload
    def __init__(
        self,
        *,
        network_sibling_set_id: str,
        subnet_id: str,
        network_sibling_set_state_id: str,
        network_features: Union[str, "_models.NetworkFeatures"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UsageName(_Model):
    """The name of the usage.

    :ivar value: The name of the usage.
    :vartype value: str
    :ivar localized_value: The localized name of the usage.
    :vartype localized_value: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the usage."""
    localized_value: Optional[str] = rest_field(
        name="localizedValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The localized name of the usage."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UsageProperties(_Model):
    """Usage properties.

    :ivar current_value: The current usage value for the subscription.
    :vartype current_value: int
    :ivar limit: The limit of the usage.
    :vartype limit: int
    :ivar unit: The unit of the usage.
    :vartype unit: str
    """

    current_value: Optional[int] = rest_field(name="currentValue", visibility=["read"])
    """The current usage value for the subscription."""
    limit: Optional[int] = rest_field(visibility=["read"])
    """The limit of the usage."""
    unit: Optional[str] = rest_field(visibility=["read"])
    """The unit of the usage."""


class UsageResult(_Model):
    """Usages entity model.

    :ivar id: The id of the usage.
    :vartype id: str
    :ivar name: The name of the usage.
    :vartype name: ~azure.mgmt.netapp.models.UsageName
    :ivar properties: Usage properties.
    :vartype properties: ~azure.mgmt.netapp.models.UsageProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The id of the usage."""
    name: Optional["_models.UsageName"] = rest_field(visibility=["read"])
    """The name of the usage."""
    properties: Optional["_models.UsageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Usage properties."""

    __flattened_items = ["current_value", "limit", "unit"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UsageProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class Volume(TrackedResource):
    """Volume resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Volume properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeProperties
    :ivar etag: "If etag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.").
    :vartype etag: str
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    """

    properties: "_models.VolumeProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Volume properties. Required."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """\"If etag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\")."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create"])
    """The availability zones."""

    __flattened_items = [
        "file_system_id",
        "creation_token",
        "service_level",
        "usage_threshold",
        "export_policy",
        "protocol_types",
        "provisioning_state",
        "snapshot_id",
        "delete_base_snapshot",
        "backup_id",
        "baremetal_tenant_id",
        "subnet_id",
        "network_features",
        "effective_network_features",
        "network_sibling_set_id",
        "storage_to_network_proximity",
        "mount_targets",
        "volume_type",
        "data_protection",
        "accept_grow_capacity_pool_for_short_term_clone_split",
        "is_restoring",
        "snapshot_directory_visible",
        "kerberos_enabled",
        "security_style",
        "smb_encryption",
        "smb_access_based_enumeration",
        "smb_non_browsable",
        "smb_continuously_available",
        "throughput_mibps",
        "actual_throughput_mibps",
        "encryption_key_source",
        "key_vault_private_endpoint_resource_id",
        "ldap_enabled",
        "cool_access",
        "coolness_period",
        "cool_access_retrieval_policy",
        "cool_access_tiering_policy",
        "unix_permissions",
        "clone_progress",
        "file_access_logs",
        "avs_data_store",
        "data_store_resource_id",
        "is_default_quota_enabled",
        "default_user_quota_in_ki_bs",
        "default_group_quota_in_ki_bs",
        "maximum_number_of_files",
        "volume_group_name",
        "capacity_pool_resource_id",
        "proximity_placement_group",
        "t2_network",
        "volume_spec_name",
        "encrypted",
        "placement_rules",
        "enable_subvolumes",
        "provisioned_availability_zone",
        "is_large_volume",
        "originating_resource_id",
        "inherited_size_in_bytes",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VolumeProperties",
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeBackupProperties(_Model):
    """Volume Backup Properties.

    :ivar backup_policy_id: Backup Policy Resource ID.
    :vartype backup_policy_id: str
    :ivar policy_enforced: Policy Enforced.
    :vartype policy_enforced: bool
    :ivar backup_vault_id: Backup Vault Resource ID.
    :vartype backup_vault_id: str
    """

    backup_policy_id: Optional[str] = rest_field(
        name="backupPolicyId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Policy Resource ID."""
    policy_enforced: Optional[bool] = rest_field(
        name="policyEnforced", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy Enforced."""
    backup_vault_id: Optional[str] = rest_field(
        name="backupVaultId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Vault Resource ID."""

    @overload
    def __init__(
        self,
        *,
        backup_policy_id: Optional[str] = None,
        policy_enforced: Optional[bool] = None,
        backup_vault_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeBackups(_Model):
    """Volume details using the backup policy.

    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :ivar volume_resource_id: ResourceId used to identify the Volume.
    :vartype volume_resource_id: str
    :ivar backups_count: Total count of backups for volume.
    :vartype backups_count: int
    :ivar policy_enabled: Policy enabled.
    :vartype policy_enabled: bool
    """

    volume_name: Optional[str] = rest_field(
        name="volumeName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume name."""
    volume_resource_id: Optional[str] = rest_field(
        name="volumeResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceId used to identify the Volume."""
    backups_count: Optional[int] = rest_field(
        name="backupsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total count of backups for volume."""
    policy_enabled: Optional[bool] = rest_field(
        name="policyEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy enabled."""

    @overload
    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        volume_resource_id: Optional[str] = None,
        backups_count: Optional[int] = None,
        policy_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeGroup(_Model):
    """Volume group resource.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Volume group properties.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeGroupListProperties
    """

    location: Optional[str] = rest_field(visibility=["read", "create"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    properties: Optional["_models.VolumeGroupListProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume group properties."""

    __flattened_items = ["provisioning_state", "group_meta_data"]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.VolumeGroupListProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeGroupDetails(ProxyResource):
    """Volume group resource for create.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar properties: Volume group properties.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeGroupProperties
    :ivar location: Resource location.
    :vartype location: str
    """

    properties: Optional["_models.VolumeGroupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume group properties."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """Resource location."""

    __flattened_items = ["provisioning_state", "group_meta_data", "volumes"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VolumeGroupProperties"] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeGroupListProperties(_Model):
    """Volume group properties.

    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar group_meta_data: Volume group details.
    :vartype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    group_meta_data: Optional["_models.VolumeGroupMetaData"] = rest_field(
        name="groupMetaData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume group details."""

    @overload
    def __init__(
        self,
        *,
        group_meta_data: Optional["_models.VolumeGroupMetaData"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeGroupMetaData(_Model):
    """Volume group properties.

    :ivar group_description: Group Description.
    :vartype group_description: str
    :ivar application_type: Application Type. Known values are: "SAP-HANA" and "ORACLE".
    :vartype application_type: str or ~azure.mgmt.netapp.models.ApplicationType
    :ivar application_identifier: Application specific identifier.
    :vartype application_identifier: str
    :ivar global_placement_rules: Application specific placement rules for the volume group.
    :vartype global_placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
    :ivar volumes_count: Number of volumes in volume group.
    :vartype volumes_count: int
    """

    group_description: Optional[str] = rest_field(
        name="groupDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Group Description."""
    application_type: Optional[Union[str, "_models.ApplicationType"]] = rest_field(
        name="applicationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application Type. Known values are: \"SAP-HANA\" and \"ORACLE\"."""
    application_identifier: Optional[str] = rest_field(
        name="applicationIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application specific identifier."""
    global_placement_rules: Optional[list["_models.PlacementKeyValuePairs"]] = rest_field(
        name="globalPlacementRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application specific placement rules for the volume group."""
    volumes_count: Optional[int] = rest_field(name="volumesCount", visibility=["read"])
    """Number of volumes in volume group."""

    @overload
    def __init__(
        self,
        *,
        group_description: Optional[str] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        application_identifier: Optional[str] = None,
        global_placement_rules: Optional[list["_models.PlacementKeyValuePairs"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeGroupProperties(_Model):
    """Volume group properties.

    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar group_meta_data: Volume group details.
    :vartype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
    :ivar volumes: List of volumes from group.
    :vartype volumes: list[~azure.mgmt.netapp.models.VolumeGroupVolumeProperties]
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    group_meta_data: Optional["_models.VolumeGroupMetaData"] = rest_field(
        name="groupMetaData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume group details."""
    volumes: Optional[list["_models.VolumeGroupVolumeProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of volumes from group."""

    @overload
    def __init__(
        self,
        *,
        group_meta_data: Optional["_models.VolumeGroupMetaData"] = None,
        volumes: Optional[list["_models.VolumeGroupVolumeProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeGroupVolumeProperties(_Model):
    """Volume resource.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone.
    :vartype zones: list[str]
    :ivar properties: Volume properties. Required.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create"])
    """Availability Zone."""
    properties: "_models.VolumeProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Volume properties. Required."""

    __flattened_items = [
        "file_system_id",
        "creation_token",
        "service_level",
        "usage_threshold",
        "export_policy",
        "protocol_types",
        "provisioning_state",
        "snapshot_id",
        "delete_base_snapshot",
        "backup_id",
        "baremetal_tenant_id",
        "subnet_id",
        "network_features",
        "effective_network_features",
        "network_sibling_set_id",
        "storage_to_network_proximity",
        "mount_targets",
        "volume_type",
        "data_protection",
        "accept_grow_capacity_pool_for_short_term_clone_split",
        "is_restoring",
        "snapshot_directory_visible",
        "kerberos_enabled",
        "security_style",
        "smb_encryption",
        "smb_access_based_enumeration",
        "smb_non_browsable",
        "smb_continuously_available",
        "throughput_mibps",
        "actual_throughput_mibps",
        "encryption_key_source",
        "key_vault_private_endpoint_resource_id",
        "ldap_enabled",
        "cool_access",
        "coolness_period",
        "cool_access_retrieval_policy",
        "cool_access_tiering_policy",
        "unix_permissions",
        "clone_progress",
        "file_access_logs",
        "avs_data_store",
        "data_store_resource_id",
        "is_default_quota_enabled",
        "default_user_quota_in_ki_bs",
        "default_group_quota_in_ki_bs",
        "maximum_number_of_files",
        "volume_group_name",
        "capacity_pool_resource_id",
        "proximity_placement_group",
        "t2_network",
        "volume_spec_name",
        "encrypted",
        "placement_rules",
        "enable_subvolumes",
        "provisioned_availability_zone",
        "is_large_volume",
        "originating_resource_id",
        "inherited_size_in_bytes",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.VolumeProperties",
        name: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        zones: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumePatch(_Model):
    """Volume patch resource.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Patchable volume properties.
    :vartype properties: ~azure.mgmt.netapp.models.VolumePatchProperties
    """

    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource location."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Resource Id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.VolumePatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Patchable volume properties."""

    __flattened_items = [
        "service_level",
        "usage_threshold",
        "export_policy",
        "protocol_types",
        "throughput_mibps",
        "data_protection",
        "is_default_quota_enabled",
        "default_user_quota_in_ki_bs",
        "default_group_quota_in_ki_bs",
        "unix_permissions",
        "cool_access",
        "coolness_period",
        "cool_access_retrieval_policy",
        "cool_access_tiering_policy",
        "snapshot_directory_visible",
        "smb_access_based_enumeration",
        "smb_non_browsable",
    ]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VolumePatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumePatchProperties(_Model):
    """Patchable volume properties.

    :ivar service_level: The service level of the file system. Known values are: "Standard",
     "Premium", "Ultra", "StandardZRS", and "Flexible".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a soft
     quota used for alerting only. For regular volumes, valid values are in the range 50GiB to
     100TiB. For large volumes, valid values are in the range 100TiB to 500TiB, and on an
     exceptional basis, from to 2400GiB to 2400TiB. Values expressed in bytes as multiples of 1 GiB.
    :vartype usage_threshold: int
    :ivar export_policy: Set of export policy rules.
    :vartype export_policy: ~azure.mgmt.netapp.models.VolumePatchPropertiesExportPolicy
    :ivar protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
    :vartype protocol_types: list[str]
    :ivar throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
     this will be accepted as input only for manual qosType volume.
    :vartype throughput_mibps: float
    :ivar data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :vartype data_protection: ~azure.mgmt.netapp.models.VolumePatchPropertiesDataProtection
    :ivar is_default_quota_enabled: Specifies if default quota is enabled for the volume.
    :vartype is_default_quota_enabled: bool
    :ivar default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
    :vartype default_user_quota_in_ki_bs: int
    :ivar default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
    :vartype default_group_quota_in_ki_bs: int
    :ivar unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First
     digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit
     selects permission for the owner of the file: read (4), write (2) and execute (1). Third
     selects permissions for other users in the same group. the fourth for other users not in the
     group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
     users.
    :vartype unix_permissions: str
    :ivar cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
    :vartype cool_access: bool
    :ivar coolness_period: Specifies the number of days after which data that is not accessed by
     clients will be tiered.
    :vartype coolness_period: int
    :ivar cool_access_retrieval_policy: coolAccessRetrievalPolicy determines the data retrieval
     behavior from the cool tier to standard storage based on the read pattern for cool access
     enabled volumes. The possible values for this field are: Default - Data will be pulled from
     cool tier to standard storage on random reads. This policy is the default. OnRead - All
     client-driven data read is pulled from cool tier to standard storage on both sequential and
     random reads. Never - No client-driven data is pulled from cool tier to standard storage. Known
     values are: "Default", "OnRead", and "Never".
    :vartype cool_access_retrieval_policy: str or
     ~azure.mgmt.netapp.models.CoolAccessRetrievalPolicy
    :ivar cool_access_tiering_policy: coolAccessTieringPolicy determines which cold data blocks are
     moved to cool tier. The possible values for this field are: Auto - Moves cold user data blocks
     in both the Snapshot copies and the active file system to the cool tier tier. This policy is
     the default. SnapshotOnly - Moves user data blocks of the Volume Snapshot copies that are not
     associated with the active file system to the cool tier. Known values are: "Auto" and
     "SnapshotOnly".
    :vartype cool_access_tiering_policy: str or ~azure.mgmt.netapp.models.CoolAccessTieringPolicy
    :ivar snapshot_directory_visible: If enabled (true) the volume will contain a read-only
     snapshot directory which provides access to each of the volume's snapshots.
    :vartype snapshot_directory_visible: bool
    :ivar smb_access_based_enumeration: Enables access-based enumeration share property for SMB
     Shares. Only applicable for SMB/DualProtocol volume. Known values are: "Disabled" and
     "Enabled".
    :vartype smb_access_based_enumeration: str or
     ~azure.mgmt.netapp.models.SmbAccessBasedEnumeration
    :ivar smb_non_browsable: Enables non-browsable property for SMB Shares. Only applicable for
     SMB/DualProtocol volume. Known values are: "Disabled" and "Enabled".
    :vartype smb_non_browsable: str or ~azure.mgmt.netapp.models.SmbNonBrowsable
    """

    service_level: Optional[Union[str, "_models.ServiceLevel"]] = rest_field(
        name="serviceLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The service level of the file system. Known values are: \"Standard\", \"Premium\", \"Ultra\",
     \"StandardZRS\", and \"Flexible\"."""
    usage_threshold: Optional[int] = rest_field(
        name="usageThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum storage quota allowed for a file system in bytes. This is a soft quota used for
     alerting only. For regular volumes, valid values are in the range 50GiB to 100TiB. For large
     volumes, valid values are in the range 100TiB to 500TiB, and on an exceptional basis, from to
     2400GiB to 2400TiB. Values expressed in bytes as multiples of 1 GiB."""
    export_policy: Optional["_models.VolumePatchPropertiesExportPolicy"] = rest_field(
        name="exportPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of export policy rules."""
    protocol_types: Optional[list[str]] = rest_field(
        name="protocolTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of protocol types, default NFSv3, CIFS for SMB protocol."""
    throughput_mibps: Optional[float] = rest_field(
        name="throughputMibps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum throughput in MiB/s that can be achieved by this volume and this will be accepted as
     input only for manual qosType volume."""
    data_protection: Optional["_models.VolumePatchPropertiesDataProtection"] = rest_field(
        name="dataProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """DataProtection type volumes include an object containing details of the replication."""
    is_default_quota_enabled: Optional[bool] = rest_field(
        name="isDefaultQuotaEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies if default quota is enabled for the volume."""
    default_user_quota_in_ki_bs: Optional[int] = rest_field(
        name="defaultUserQuotaInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4
     KiBs applies ."""
    default_group_quota_in_ki_bs: Optional[int] = rest_field(
        name="defaultGroupQuotaInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4
     KiBs applies."""
    unix_permissions: Optional[str] = rest_field(
        name="unixPermissions", visibility=["read", "create", "update", "delete", "query"]
    )
    """UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set
     user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the
     owner of the file: read (4), write (2) and execute (1). Third selects permissions for other
     users in the same group. the fourth for other users not in the group. 0755 - gives
     read/write/execute permissions to owner and read/execute to group and other users."""
    cool_access: Optional[bool] = rest_field(
        name="coolAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether Cool Access(tiering) is enabled for the volume."""
    coolness_period: Optional[int] = rest_field(
        name="coolnessPeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the number of days after which data that is not accessed by clients will be tiered."""
    cool_access_retrieval_policy: Optional[Union[str, "_models.CoolAccessRetrievalPolicy"]] = rest_field(
        name="coolAccessRetrievalPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard
     storage based on the read pattern for cool access enabled volumes. The possible values for this
     field are: Default - Data will be pulled from cool tier to standard storage on random reads.
     This policy is the default. OnRead - All client-driven data read is pulled from cool tier to
     standard storage on both sequential and random reads. Never - No client-driven data is pulled
     from cool tier to standard storage. Known values are: \"Default\", \"OnRead\", and \"Never\"."""
    cool_access_tiering_policy: Optional[Union[str, "_models.CoolAccessTieringPolicy"]] = rest_field(
        name="coolAccessTieringPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """coolAccessTieringPolicy determines which cold data blocks are moved to cool tier. The possible
     values for this field are: Auto - Moves cold user data blocks in both the Snapshot copies and
     the active file system to the cool tier tier. This policy is the default. SnapshotOnly - Moves
     user data blocks of the Volume Snapshot copies that are not associated with the active file
     system to the cool tier. Known values are: \"Auto\" and \"SnapshotOnly\"."""
    snapshot_directory_visible: Optional[bool] = rest_field(
        name="snapshotDirectoryVisible", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled (true) the volume will contain a read-only snapshot directory which provides access
     to each of the volume's snapshots."""
    smb_access_based_enumeration: Optional[Union[str, "_models.SmbAccessBasedEnumeration"]] = rest_field(
        name="smbAccessBasedEnumeration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables access-based enumeration share property for SMB Shares. Only applicable for
     SMB/DualProtocol volume. Known values are: \"Disabled\" and \"Enabled\"."""
    smb_non_browsable: Optional[Union[str, "_models.SmbNonBrowsable"]] = rest_field(
        name="smbNonBrowsable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables non-browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume.
     Known values are: \"Disabled\" and \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        service_level: Optional[Union[str, "_models.ServiceLevel"]] = None,
        usage_threshold: Optional[int] = None,
        export_policy: Optional["_models.VolumePatchPropertiesExportPolicy"] = None,
        protocol_types: Optional[list[str]] = None,
        throughput_mibps: Optional[float] = None,
        data_protection: Optional["_models.VolumePatchPropertiesDataProtection"] = None,
        is_default_quota_enabled: Optional[bool] = None,
        default_user_quota_in_ki_bs: Optional[int] = None,
        default_group_quota_in_ki_bs: Optional[int] = None,
        unix_permissions: Optional[str] = None,
        cool_access: Optional[bool] = None,
        coolness_period: Optional[int] = None,
        cool_access_retrieval_policy: Optional[Union[str, "_models.CoolAccessRetrievalPolicy"]] = None,
        cool_access_tiering_policy: Optional[Union[str, "_models.CoolAccessTieringPolicy"]] = None,
        snapshot_directory_visible: Optional[bool] = None,
        smb_access_based_enumeration: Optional[Union[str, "_models.SmbAccessBasedEnumeration"]] = None,
        smb_non_browsable: Optional[Union[str, "_models.SmbNonBrowsable"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumePatchPropertiesDataProtection(_Model):
    """DataProtection type volumes include an object containing details of the replication.

    :ivar backup: Backup Properties.
    :vartype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :ivar snapshot: Snapshot properties.
    :vartype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    :ivar ransomware_protection: Advanced Ransomware Protection updatable settings.
    :vartype ransomware_protection: ~azure.mgmt.netapp.models.RansomwareProtectionPatchSettings
    """

    backup: Optional["_models.VolumeBackupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Properties."""
    snapshot: Optional["_models.VolumeSnapshotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot properties."""
    ransomware_protection: Optional["_models.RansomwareProtectionPatchSettings"] = rest_field(
        name="ransomwareProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Advanced Ransomware Protection updatable settings."""

    @overload
    def __init__(
        self,
        *,
        backup: Optional["_models.VolumeBackupProperties"] = None,
        snapshot: Optional["_models.VolumeSnapshotProperties"] = None,
        ransomware_protection: Optional["_models.RansomwareProtectionPatchSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumePatchPropertiesExportPolicy(_Model):
    """Set of export policy rules.

    :ivar rules: Export policy rule.
    :vartype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    rules: Optional[list["_models.ExportPolicyRule"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Export policy rule."""

    @overload
    def __init__(
        self,
        *,
        rules: Optional[list["_models.ExportPolicyRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeProperties(_Model):
    """Volume properties.

    :ivar file_system_id: Unique FileSystem Identifier.
    :vartype file_system_id: str
    :ivar creation_token: A unique file path for the volume. Used when creating mount targets.
     Required.
    :vartype creation_token: str
    :ivar service_level: The service level of the file system. Known values are: "Standard",
     "Premium", "Ultra", "StandardZRS", and "Flexible".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a soft
     quota used for alerting only. For regular volumes, valid values are in the range 50GiB to
     100TiB. For large volumes, valid values are in the range 100TiB to 500TiB, and on an
     exceptional basis, from to 2400GiB to 2400TiB. Values expressed in bytes as multiples of 1 GiB.
     Required.
    :vartype usage_threshold: int
    :ivar export_policy: Set of export policy rules.
    :vartype export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
    :ivar protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
    :vartype protocol_types: list[str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar snapshot_id: Resource identifier used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar delete_base_snapshot: If enabled (true) the snapshot the volume was created from will be
     automatically deleted after the volume create operation has finished.  Defaults to false.
    :vartype delete_base_snapshot: bool
    :ivar backup_id: Resource identifier used to identify the Backup.
    :vartype backup_id: str
    :ivar baremetal_tenant_id: Unique Baremetal Tenant Identifier.
    :vartype baremetal_tenant_id: str
    :ivar subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Required.
    :vartype subnet_id: str
    :ivar network_features: The original value of the network features type available to the volume
     at the time it was created. Known values are: "Basic", "Standard", "Basic_Standard", and
     "Standard_Basic".
    :vartype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    :ivar effective_network_features: The effective value of the network features type available to
     the volume, or current effective state of update. Known values are: "Basic", "Standard",
     "Basic_Standard", and "Standard_Basic".
    :vartype effective_network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    :ivar network_sibling_set_id: Network Sibling Set ID for the the group of volumes sharing
     networking resources.
    :vartype network_sibling_set_id: str
    :ivar storage_to_network_proximity: Provides storage to network proximity information for the
     volume. Known values are: "Default", "T1", "T2", and "AcrossT2".
    :vartype storage_to_network_proximity: str or
     ~azure.mgmt.netapp.models.VolumeStorageToNetworkProximity
    :ivar mount_targets: List of mount targets.
    :vartype mount_targets: list[~azure.mgmt.netapp.models.MountTargetProperties]
    :ivar volume_type: What type of volume is this. For destination volumes in Cross Region
     Replication, set type to DataProtection. For creating clone volume, set type to ShortTermClone.
    :vartype volume_type: str
    :ivar data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :vartype data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
    :ivar accept_grow_capacity_pool_for_short_term_clone_split: While auto splitting the short term
     clone volume, if the parent pool does not have enough space to accommodate the volume after
     split, it will be automatically resized, which will lead to increased billing. To accept
     capacity pool size auto grow and create a short term clone volume, set the property as
     accepted. Known values are: "Accepted" and "Declined".
    :vartype accept_grow_capacity_pool_for_short_term_clone_split: str or
     ~azure.mgmt.netapp.models.AcceptGrowCapacityPoolForShortTermCloneSplit
    :ivar is_restoring: Restoring.
    :vartype is_restoring: bool
    :ivar snapshot_directory_visible: If enabled (true) the volume will contain a read-only
     snapshot directory which provides access to each of the volume's snapshots (defaults to true).
    :vartype snapshot_directory_visible: bool
    :ivar kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos_enabled: bool
    :ivar security_style: The security style of volume, default unix, defaults to ntfs for dual
     protocol or CIFS protocol. Known values are: "ntfs" and "unix".
    :vartype security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
    :ivar smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
     SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
    :vartype smb_encryption: bool
    :ivar smb_access_based_enumeration: Enables access-based enumeration share property for SMB
     Shares. Only applicable for SMB/DualProtocol volume. Known values are: "Disabled" and
     "Enabled".
    :vartype smb_access_based_enumeration: str or
     ~azure.mgmt.netapp.models.SmbAccessBasedEnumeration
    :ivar smb_non_browsable: Enables non-browsable property for SMB Shares. Only applicable for
     SMB/DualProtocol volume. Known values are: "Disabled" and "Enabled".
    :vartype smb_non_browsable: str or ~azure.mgmt.netapp.models.SmbNonBrowsable
    :ivar smb_continuously_available: Enables continuously available share property for smb volume.
     Only applicable for SMB volume.
    :vartype smb_continuously_available: bool
    :ivar throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
     this will be accepted as input only for manual qosType volume.
    :vartype throughput_mibps: float
    :ivar actual_throughput_mibps: Actual throughput in MiB/s for auto qosType volumes calculated
     based on size and serviceLevel.
    :vartype actual_throughput_mibps: float
    :ivar encryption_key_source: Source of key used to encrypt data in volume. Applicable if NetApp
     account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive)
     are: 'Microsoft.NetApp, Microsoft.KeyVault'. Known values are: "Microsoft.NetApp" and
     "Microsoft.KeyVault".
    :vartype encryption_key_source: str or ~azure.mgmt.netapp.models.EncryptionKeySource
    :ivar key_vault_private_endpoint_resource_id: The resource ID of private endpoint for KeyVault.
     It must reside in the same VNET as the volume. Only applicable if encryptionKeySource =
     'Microsoft.KeyVault'.
    :vartype key_vault_private_endpoint_resource_id: str
    :ivar ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
    :vartype ldap_enabled: bool
    :ivar cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
    :vartype cool_access: bool
    :ivar coolness_period: Specifies the number of days after which data that is not accessed by
     clients will be tiered.
    :vartype coolness_period: int
    :ivar cool_access_retrieval_policy: coolAccessRetrievalPolicy determines the data retrieval
     behavior from the cool tier to standard storage based on the read pattern for cool access
     enabled volumes. The possible values for this field are: Default - Data will be pulled from
     cool tier to standard storage on random reads. This policy is the default. OnRead - All
     client-driven data read is pulled from cool tier to standard storage on both sequential and
     random reads. Never - No client-driven data is pulled from cool tier to standard storage. Known
     values are: "Default", "OnRead", and "Never".
    :vartype cool_access_retrieval_policy: str or
     ~azure.mgmt.netapp.models.CoolAccessRetrievalPolicy
    :ivar cool_access_tiering_policy: coolAccessTieringPolicy determines which cold data blocks are
     moved to cool tier. The possible values for this field are: Auto - Moves cold user data blocks
     in both the Snapshot copies and the active file system to the cool tier tier. This policy is
     the default. SnapshotOnly - Moves user data blocks of the Volume Snapshot copies that are not
     associated with the active file system to the cool tier. Known values are: "Auto" and
     "SnapshotOnly".
    :vartype cool_access_tiering_policy: str or ~azure.mgmt.netapp.models.CoolAccessTieringPolicy
    :ivar unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First
     digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit
     selects permission for the owner of the file: read (4), write (2) and execute (1). Third
     selects permissions for other users in the same group. the fourth for other users not in the
     group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
     users.
    :vartype unix_permissions: str
    :ivar clone_progress: When a volume is being restored from another volume's snapshot, will show
     the percentage completion of this cloning process. When this value is empty/null there is no
     cloning process currently happening on this volume. This value will update every 5 minutes
     during cloning.
    :vartype clone_progress: int
    :ivar file_access_logs: Flag indicating whether file access logs are enabled for the volume,
     based on active diagnostic settings present on the volume. Known values are: "Enabled" and
     "Disabled".
    :vartype file_access_logs: str or ~azure.mgmt.netapp.models.FileAccessLogs
    :ivar avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution (AVS)
     datastore purpose. Known values are: "Enabled" and "Disabled".
    :vartype avs_data_store: str or ~azure.mgmt.netapp.models.AvsDataStore
    :ivar data_store_resource_id: Data store resource unique identifier.
    :vartype data_store_resource_id: list[str]
    :ivar is_default_quota_enabled: Specifies if default quota is enabled for the volume.
    :vartype is_default_quota_enabled: bool
    :ivar default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
    :vartype default_user_quota_in_ki_bs: int
    :ivar default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
    :vartype default_group_quota_in_ki_bs: int
    :ivar maximum_number_of_files: Maximum number of files allowed. Needs a service request in
     order to be changed. Only allowed to be changed if volume quota is more than 4TiB.
    :vartype maximum_number_of_files: int
    :ivar volume_group_name: Volume Group Name.
    :vartype volume_group_name: str
    :ivar capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through
     volume group.
    :vartype capacity_pool_resource_id: str
    :ivar proximity_placement_group: Proximity placement group associated with the volume.
    :vartype proximity_placement_group: str
    :ivar t2_network: T2 network information.
    :vartype t2_network: str
    :ivar volume_spec_name: Volume spec name is the application specific designation or identifier
     for the particular volume in a volume group for e.g. data, log.
    :vartype volume_spec_name: str
    :ivar encrypted: Specifies if the volume is encrypted or not. Only available on volumes created
     or updated after 2022-01-01.
    :vartype encrypted: bool
    :ivar placement_rules: Application specific placement rules for the particular volume.
    :vartype placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
    :ivar enable_subvolumes: Flag indicating whether subvolume operations are enabled on the
     volume. Known values are: "Enabled" and "Disabled".
    :vartype enable_subvolumes: str or ~azure.mgmt.netapp.models.EnableSubvolumes
    :ivar provisioned_availability_zone: The availability zone where the volume is provisioned.
     This refers to the logical availability zone where the volume resides.
    :vartype provisioned_availability_zone: str
    :ivar is_large_volume: Specifies whether volume is a Large Volume or Regular Volume.
    :vartype is_large_volume: bool
    :ivar originating_resource_id: Id of the snapshot or backup that the volume is restored from.
    :vartype originating_resource_id: str
    :ivar inherited_size_in_bytes: Space shared by short term clone volume with parent volume in
     bytes.
    :vartype inherited_size_in_bytes: int
    """

    file_system_id: Optional[str] = rest_field(name="fileSystemId", visibility=["read"])
    """Unique FileSystem Identifier."""
    creation_token: str = rest_field(name="creationToken", visibility=["read", "create"])
    """A unique file path for the volume. Used when creating mount targets. Required."""
    service_level: Optional[Union[str, "_models.ServiceLevel"]] = rest_field(
        name="serviceLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The service level of the file system. Known values are: \"Standard\", \"Premium\", \"Ultra\",
     \"StandardZRS\", and \"Flexible\"."""
    usage_threshold: int = rest_field(name="usageThreshold", visibility=["read", "create", "update", "delete", "query"])
    """Maximum storage quota allowed for a file system in bytes. This is a soft quota used for
     alerting only. For regular volumes, valid values are in the range 50GiB to 100TiB. For large
     volumes, valid values are in the range 100TiB to 500TiB, and on an exceptional basis, from to
     2400GiB to 2400TiB. Values expressed in bytes as multiples of 1 GiB. Required."""
    export_policy: Optional["_models.VolumePropertiesExportPolicy"] = rest_field(
        name="exportPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of export policy rules."""
    protocol_types: Optional[list[str]] = rest_field(
        name="protocolTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of protocol types, default NFSv3, CIFS for SMB protocol."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """Azure lifecycle management."""
    snapshot_id: Optional[str] = rest_field(name="snapshotId", visibility=["read", "create"])
    """Resource identifier used to identify the Snapshot."""
    delete_base_snapshot: Optional[bool] = rest_field(
        name="deleteBaseSnapshot", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled (true) the snapshot the volume was created from will be automatically deleted after
     the volume create operation has finished.  Defaults to false."""
    backup_id: Optional[str] = rest_field(name="backupId", visibility=["read", "create"])
    """Resource identifier used to identify the Backup."""
    baremetal_tenant_id: Optional[str] = rest_field(name="baremetalTenantId", visibility=["read"])
    """Unique Baremetal Tenant Identifier."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Resource URI for a delegated subnet. Must have the delegation
     Microsoft.NetApp/volumes. Required."""
    network_features: Optional[Union[str, "_models.NetworkFeatures"]] = rest_field(
        name="networkFeatures", visibility=["read", "create"]
    )
    """The original value of the network features type available to the volume at the time it was
     created. Known values are: \"Basic\", \"Standard\", \"Basic_Standard\", and \"Standard_Basic\"."""
    effective_network_features: Optional[Union[str, "_models.NetworkFeatures"]] = rest_field(
        name="effectiveNetworkFeatures", visibility=["read"]
    )
    """The effective value of the network features type available to the volume, or current effective
     state of update. Known values are: \"Basic\", \"Standard\", \"Basic_Standard\", and
     \"Standard_Basic\"."""
    network_sibling_set_id: Optional[str] = rest_field(name="networkSiblingSetId", visibility=["read"])
    """Network Sibling Set ID for the the group of volumes sharing networking resources."""
    storage_to_network_proximity: Optional[Union[str, "_models.VolumeStorageToNetworkProximity"]] = rest_field(
        name="storageToNetworkProximity", visibility=["read"]
    )
    """Provides storage to network proximity information for the volume. Known values are:
     \"Default\", \"T1\", \"T2\", and \"AcrossT2\"."""
    mount_targets: Optional[list["_models.MountTargetProperties"]] = rest_field(
        name="mountTargets", visibility=["read"]
    )
    """List of mount targets."""
    volume_type: Optional[str] = rest_field(name="volumeType", visibility=["read", "create"])
    """What type of volume is this. For destination volumes in Cross Region Replication, set type to
     DataProtection. For creating clone volume, set type to ShortTermClone."""
    data_protection: Optional["_models.VolumePropertiesDataProtection"] = rest_field(
        name="dataProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """DataProtection type volumes include an object containing details of the replication."""
    accept_grow_capacity_pool_for_short_term_clone_split: Optional[
        Union[str, "_models.AcceptGrowCapacityPoolForShortTermCloneSplit"]
    ] = rest_field(name="acceptGrowCapacityPoolForShortTermCloneSplit", visibility=["read", "create"])
    """While auto splitting the short term clone volume, if the parent pool does not have enough space
     to accommodate the volume after split, it will be automatically resized, which will lead to
     increased billing. To accept capacity pool size auto grow and create a short term clone volume,
     set the property as accepted. Known values are: \"Accepted\" and \"Declined\"."""
    is_restoring: Optional[bool] = rest_field(name="isRestoring", visibility=["read"])
    """Restoring."""
    snapshot_directory_visible: Optional[bool] = rest_field(
        name="snapshotDirectoryVisible", visibility=["read", "create", "update", "delete", "query"]
    )
    """If enabled (true) the volume will contain a read-only snapshot directory which provides access
     to each of the volume's snapshots (defaults to true)."""
    kerberos_enabled: Optional[bool] = rest_field(name="kerberosEnabled", visibility=["read", "create"])
    """Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later."""
    security_style: Optional[Union[str, "_models.SecurityStyle"]] = rest_field(
        name="securityStyle", visibility=["read", "create"]
    )
    """The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS
     protocol. Known values are: \"ntfs\" and \"unix\"."""
    smb_encryption: Optional[bool] = rest_field(
        name="smbEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be
     used with swagger version 2020-08-01 or later."""
    smb_access_based_enumeration: Optional[Union[str, "_models.SmbAccessBasedEnumeration"]] = rest_field(
        name="smbAccessBasedEnumeration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables access-based enumeration share property for SMB Shares. Only applicable for
     SMB/DualProtocol volume. Known values are: \"Disabled\" and \"Enabled\"."""
    smb_non_browsable: Optional[Union[str, "_models.SmbNonBrowsable"]] = rest_field(
        name="smbNonBrowsable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables non-browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume.
     Known values are: \"Disabled\" and \"Enabled\"."""
    smb_continuously_available: Optional[bool] = rest_field(
        name="smbContinuouslyAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables continuously available share property for smb volume. Only applicable for SMB volume."""
    throughput_mibps: Optional[float] = rest_field(
        name="throughputMibps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum throughput in MiB/s that can be achieved by this volume and this will be accepted as
     input only for manual qosType volume."""
    actual_throughput_mibps: Optional[float] = rest_field(name="actualThroughputMibps", visibility=["read"])
    """Actual throughput in MiB/s for auto qosType volumes calculated based on size and serviceLevel."""
    encryption_key_source: Optional[Union[str, "_models.EncryptionKeySource"]] = rest_field(
        name="encryptionKeySource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source of key used to encrypt data in volume. Applicable if NetApp account has
     encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are:
     'Microsoft.NetApp, Microsoft.KeyVault'. Known values are: \"Microsoft.NetApp\" and
     \"Microsoft.KeyVault\"."""
    key_vault_private_endpoint_resource_id: Optional[str] = rest_field(
        name="keyVaultPrivateEndpointResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the
     volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'."""
    ldap_enabled: Optional[bool] = rest_field(name="ldapEnabled", visibility=["read", "create"])
    """Specifies whether LDAP is enabled or not for a given NFS volume."""
    cool_access: Optional[bool] = rest_field(
        name="coolAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether Cool Access(tiering) is enabled for the volume."""
    coolness_period: Optional[int] = rest_field(
        name="coolnessPeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the number of days after which data that is not accessed by clients will be tiered."""
    cool_access_retrieval_policy: Optional[Union[str, "_models.CoolAccessRetrievalPolicy"]] = rest_field(
        name="coolAccessRetrievalPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard
     storage based on the read pattern for cool access enabled volumes. The possible values for this
     field are: Default - Data will be pulled from cool tier to standard storage on random reads.
     This policy is the default. OnRead - All client-driven data read is pulled from cool tier to
     standard storage on both sequential and random reads. Never - No client-driven data is pulled
     from cool tier to standard storage. Known values are: \"Default\", \"OnRead\", and \"Never\"."""
    cool_access_tiering_policy: Optional[Union[str, "_models.CoolAccessTieringPolicy"]] = rest_field(
        name="coolAccessTieringPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """coolAccessTieringPolicy determines which cold data blocks are moved to cool tier. The possible
     values for this field are: Auto - Moves cold user data blocks in both the Snapshot copies and
     the active file system to the cool tier tier. This policy is the default. SnapshotOnly - Moves
     user data blocks of the Volume Snapshot copies that are not associated with the active file
     system to the cool tier. Known values are: \"Auto\" and \"SnapshotOnly\"."""
    unix_permissions: Optional[str] = rest_field(
        name="unixPermissions", visibility=["read", "create", "update", "delete", "query"]
    )
    """UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set
     user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the
     owner of the file: read (4), write (2) and execute (1). Third selects permissions for other
     users in the same group. the fourth for other users not in the group. 0755 - gives
     read/write/execute permissions to owner and read/execute to group and other users."""
    clone_progress: Optional[int] = rest_field(name="cloneProgress", visibility=["read"])
    """When a volume is being restored from another volume's snapshot, will show the percentage
     completion of this cloning process. When this value is empty/null there is no cloning process
     currently happening on this volume. This value will update every 5 minutes during cloning."""
    file_access_logs: Optional[Union[str, "_models.FileAccessLogs"]] = rest_field(
        name="fileAccessLogs", visibility=["read"]
    )
    """Flag indicating whether file access logs are enabled for the volume, based on active diagnostic
     settings present on the volume. Known values are: \"Enabled\" and \"Disabled\"."""
    avs_data_store: Optional[Union[str, "_models.AvsDataStore"]] = rest_field(
        name="avsDataStore", visibility=["read", "create"]
    )
    """Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose.
     Known values are: \"Enabled\" and \"Disabled\"."""
    data_store_resource_id: Optional[list[str]] = rest_field(name="dataStoreResourceId", visibility=["read"])
    """Data store resource unique identifier."""
    is_default_quota_enabled: Optional[bool] = rest_field(
        name="isDefaultQuotaEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies if default quota is enabled for the volume."""
    default_user_quota_in_ki_bs: Optional[int] = rest_field(
        name="defaultUserQuotaInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4
     KiBs applies ."""
    default_group_quota_in_ki_bs: Optional[int] = rest_field(
        name="defaultGroupQuotaInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4
     KiBs applies."""
    maximum_number_of_files: Optional[int] = rest_field(name="maximumNumberOfFiles", visibility=["read"])
    """Maximum number of files allowed. Needs a service request in order to be changed. Only allowed
     to be changed if volume quota is more than 4TiB."""
    volume_group_name: Optional[str] = rest_field(name="volumeGroupName", visibility=["read"])
    """Volume Group Name."""
    capacity_pool_resource_id: Optional[str] = rest_field(
        name="capacityPoolResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pool Resource Id used in case of creating a volume through volume group."""
    proximity_placement_group: Optional[str] = rest_field(
        name="proximityPlacementGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """Proximity placement group associated with the volume."""
    t2_network: Optional[str] = rest_field(name="t2Network", visibility=["read"])
    """T2 network information."""
    volume_spec_name: Optional[str] = rest_field(
        name="volumeSpecName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume spec name is the application specific designation or identifier for the particular
     volume in a volume group for e.g. data, log."""
    encrypted: Optional[bool] = rest_field(visibility=["read"])
    """Specifies if the volume is encrypted or not. Only available on volumes created or updated after
     2022-01-01."""
    placement_rules: Optional[list["_models.PlacementKeyValuePairs"]] = rest_field(
        name="placementRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application specific placement rules for the particular volume."""
    enable_subvolumes: Optional[Union[str, "_models.EnableSubvolumes"]] = rest_field(
        name="enableSubvolumes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag indicating whether subvolume operations are enabled on the volume. Known values are:
     \"Enabled\" and \"Disabled\"."""
    provisioned_availability_zone: Optional[str] = rest_field(name="provisionedAvailabilityZone", visibility=["read"])
    """The availability zone where the volume is provisioned. This refers to the logical availability
     zone where the volume resides."""
    is_large_volume: Optional[bool] = rest_field(name="isLargeVolume", visibility=["read", "create"])
    """Specifies whether volume is a Large Volume or Regular Volume."""
    originating_resource_id: Optional[str] = rest_field(name="originatingResourceId", visibility=["read"])
    """Id of the snapshot or backup that the volume is restored from."""
    inherited_size_in_bytes: Optional[int] = rest_field(name="inheritedSizeInBytes", visibility=["read"])
    """Space shared by short term clone volume with parent volume in bytes."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        creation_token: str,
        usage_threshold: int,
        subnet_id: str,
        service_level: Optional[Union[str, "_models.ServiceLevel"]] = None,
        export_policy: Optional["_models.VolumePropertiesExportPolicy"] = None,
        protocol_types: Optional[list[str]] = None,
        snapshot_id: Optional[str] = None,
        delete_base_snapshot: Optional[bool] = None,
        backup_id: Optional[str] = None,
        network_features: Optional[Union[str, "_models.NetworkFeatures"]] = None,
        volume_type: Optional[str] = None,
        data_protection: Optional["_models.VolumePropertiesDataProtection"] = None,
        accept_grow_capacity_pool_for_short_term_clone_split: Optional[
            Union[str, "_models.AcceptGrowCapacityPoolForShortTermCloneSplit"]
        ] = None,
        snapshot_directory_visible: Optional[bool] = None,
        kerberos_enabled: Optional[bool] = None,
        security_style: Optional[Union[str, "_models.SecurityStyle"]] = None,
        smb_encryption: Optional[bool] = None,
        smb_access_based_enumeration: Optional[Union[str, "_models.SmbAccessBasedEnumeration"]] = None,
        smb_non_browsable: Optional[Union[str, "_models.SmbNonBrowsable"]] = None,
        smb_continuously_available: Optional[bool] = None,
        throughput_mibps: Optional[float] = None,
        encryption_key_source: Optional[Union[str, "_models.EncryptionKeySource"]] = None,
        key_vault_private_endpoint_resource_id: Optional[str] = None,
        ldap_enabled: Optional[bool] = None,
        cool_access: Optional[bool] = None,
        coolness_period: Optional[int] = None,
        cool_access_retrieval_policy: Optional[Union[str, "_models.CoolAccessRetrievalPolicy"]] = None,
        cool_access_tiering_policy: Optional[Union[str, "_models.CoolAccessTieringPolicy"]] = None,
        unix_permissions: Optional[str] = None,
        avs_data_store: Optional[Union[str, "_models.AvsDataStore"]] = None,
        is_default_quota_enabled: Optional[bool] = None,
        default_user_quota_in_ki_bs: Optional[int] = None,
        default_group_quota_in_ki_bs: Optional[int] = None,
        capacity_pool_resource_id: Optional[str] = None,
        proximity_placement_group: Optional[str] = None,
        volume_spec_name: Optional[str] = None,
        placement_rules: Optional[list["_models.PlacementKeyValuePairs"]] = None,
        enable_subvolumes: Optional[Union[str, "_models.EnableSubvolumes"]] = None,
        is_large_volume: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumePropertiesDataProtection(_Model):
    """DataProtection type volumes include an object containing details of the replication.

    :ivar backup: Backup Properties.
    :vartype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :ivar replication: Replication properties.
    :vartype replication: ~azure.mgmt.netapp.models.ReplicationObject
    :ivar snapshot: Snapshot properties.
    :vartype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    :ivar volume_relocation: VolumeRelocation properties.
    :vartype volume_relocation: ~azure.mgmt.netapp.models.VolumeRelocationProperties
    :ivar ransomware_protection: Advanced Ransomware Protection settings.
    :vartype ransomware_protection: ~azure.mgmt.netapp.models.RansomwareProtectionSettings
    """

    backup: Optional["_models.VolumeBackupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup Properties."""
    replication: Optional["_models.ReplicationObject"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Replication properties."""
    snapshot: Optional["_models.VolumeSnapshotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot properties."""
    volume_relocation: Optional["_models.VolumeRelocationProperties"] = rest_field(
        name="volumeRelocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """VolumeRelocation properties."""
    ransomware_protection: Optional["_models.RansomwareProtectionSettings"] = rest_field(
        name="ransomwareProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Advanced Ransomware Protection settings."""

    @overload
    def __init__(
        self,
        *,
        backup: Optional["_models.VolumeBackupProperties"] = None,
        replication: Optional["_models.ReplicationObject"] = None,
        snapshot: Optional["_models.VolumeSnapshotProperties"] = None,
        volume_relocation: Optional["_models.VolumeRelocationProperties"] = None,
        ransomware_protection: Optional["_models.RansomwareProtectionSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumePropertiesExportPolicy(_Model):
    """Set of export policy rules.

    :ivar rules: Export policy rule.
    :vartype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    rules: Optional[list["_models.ExportPolicyRule"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Export policy rule."""

    @overload
    def __init__(
        self,
        *,
        rules: Optional[list["_models.ExportPolicyRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeQuotaRule(TrackedResource):
    """Quota Rule of a Volume.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Volume Quota Rule Properties.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeQuotaRulesProperties
    """

    properties: Optional["_models.VolumeQuotaRulesProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume Quota Rule Properties."""

    __flattened_items = ["provisioning_state", "quota_size_in_ki_bs", "quota_type", "quota_target"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VolumeQuotaRulesProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeQuotaRulePatch(_Model):
    """Patchable Quota Rule of a Volume.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Volume Quota Rule Properties.
    :vartype properties: ~azure.mgmt.netapp.models.VolumeQuotaRulesProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.VolumeQuotaRulesProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Volume Quota Rule Properties."""

    __flattened_items = ["provisioning_state", "quota_size_in_ki_bs", "quota_type", "quota_target"]

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VolumeQuotaRulesProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VolumeQuotaRulesProperties(_Model):
    """Volume Quota Rule properties.

    :ivar provisioning_state: Gets the status of the VolumeQuotaRule at the time the operation was
     called. Known values are: "Accepted", "Creating", "Patching", "Updating", "Deleting", "Moving",
     "Failed", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.netapp.models.NetAppProvisioningState
    :ivar quota_size_in_ki_bs: Size of quota.
    :vartype quota_size_in_ki_bs: int
    :ivar quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
     "IndividualUserQuota", and "IndividualGroupQuota".
    :vartype quota_type: str or ~azure.mgmt.netapp.models.QuotaType
    :ivar quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID can
     be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
     running <wmic useraccount where name='user-name' get sid>.
    :vartype quota_target: str
    """

    provisioning_state: Optional[Union[str, "_models.NetAppProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Gets the status of the VolumeQuotaRule at the time the operation was called. Known values are:
     \"Accepted\", \"Creating\", \"Patching\", \"Updating\", \"Deleting\", \"Moving\", \"Failed\",
     and \"Succeeded\"."""
    quota_size_in_ki_bs: Optional[int] = rest_field(
        name="quotaSizeInKiBs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of quota."""
    quota_type: Optional[Union[str, "_models.QuotaType"]] = rest_field(name="quotaType", visibility=["read", "create"])
    """Type of quota. Known values are: \"DefaultUserQuota\", \"DefaultGroupQuota\",
     \"IndividualUserQuota\", and \"IndividualGroupQuota\"."""
    quota_target: Optional[str] = rest_field(name="quotaTarget", visibility=["read", "create"])
    """UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running
     ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic
     useraccount where name='user-name' get sid>."""

    @overload
    def __init__(
        self,
        *,
        quota_size_in_ki_bs: Optional[int] = None,
        quota_type: Optional[Union[str, "_models.QuotaType"]] = None,
        quota_target: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeRelocationProperties(_Model):
    """Volume relocation properties.

    :ivar relocation_requested: Has relocation been requested for this volume.
    :vartype relocation_requested: bool
    :ivar ready_to_be_finalized: Has relocation finished and is ready to be cleaned up.
    :vartype ready_to_be_finalized: bool
    """

    relocation_requested: Optional[bool] = rest_field(
        name="relocationRequested", visibility=["read", "create", "update", "delete", "query"]
    )
    """Has relocation been requested for this volume."""
    ready_to_be_finalized: Optional[bool] = rest_field(name="readyToBeFinalized", visibility=["read"])
    """Has relocation finished and is ready to be cleaned up."""

    @overload
    def __init__(
        self,
        *,
        relocation_requested: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeRevert(_Model):
    """revert a volume to the snapshot.

    :ivar snapshot_id: Resource id of the snapshot.
    :vartype snapshot_id: str
    """

    snapshot_id: Optional[str] = rest_field(
        name="snapshotId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource id of the snapshot."""

    @overload
    def __init__(
        self,
        *,
        snapshot_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeSnapshotProperties(_Model):
    """Volume Snapshot Properties.

    :ivar snapshot_policy_id: Snapshot Policy ResourceId.
    :vartype snapshot_policy_id: str
    """

    snapshot_policy_id: Optional[str] = rest_field(
        name="snapshotPolicyId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Snapshot Policy ResourceId."""

    @overload
    def __init__(
        self,
        *,
        snapshot_policy_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WeeklySchedule(_Model):
    """Weekly Schedule properties, make a snapshot every week at a specific day or days.

    :ivar snapshots_to_keep: Weekly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar day: Indicates which weekdays snapshot should be taken, accepts a comma separated list of
     week day names in english.
    :vartype day: str
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: int
    """

    snapshots_to_keep: Optional[int] = rest_field(
        name="snapshotsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Weekly snapshot count to keep."""
    day: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day
     names in english."""
    hour: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which hour in UTC timezone a snapshot should be taken."""
    minute: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which minute snapshot should be taken."""
    used_bytes: Optional[int] = rest_field(name="usedBytes", visibility=["read", "create", "update", "delete", "query"])
    """Resource size in bytes, current storage usage for the volume in bytes."""

    @overload
    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        day: Optional[str] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
