# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.managementgroups.aio import ManagementGroupsAPI

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagementGroupsAPIHierarchySettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagementGroupsAPI, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_hierarchy_settings_list(self, resource_group):
        response = await self.client.hierarchy_settings.list(
            group_id="str",
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_hierarchy_settings_get(self, resource_group):
        response = await self.client.hierarchy_settings.get(
            group_id="str",
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_hierarchy_settings_create_or_update(self, resource_group):
        response = await self.client.hierarchy_settings.create_or_update(
            group_id="str",
            create_tenant_settings_request={
                "defaultManagementGroup": "str",
                "requireAuthorizationForGroupCreation": bool,
            },
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_hierarchy_settings_update(self, resource_group):
        response = await self.client.hierarchy_settings.update(
            group_id="str",
            create_tenant_settings_request={
                "defaultManagementGroup": "str",
                "requireAuthorizationForGroupCreation": bool,
            },
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_hierarchy_settings_delete(self, resource_group):
        response = await self.client.hierarchy_settings.delete(
            group_id="str",
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...
