# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.edgeactions.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.edgeactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeAction(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.edgeactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionProperties
    :ivar sku: The sku type of the edge action. Required.
    :vartype sku: ~azure.mgmt.edgeactions.models.SkuType
    """

    properties: Optional["_models.EdgeActionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    sku: "_models.SkuType" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku type of the edge action. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.SkuType",
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EdgeActionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionAttachment(_Model):
    """Edge action attachment information.

    :ivar id: The edge action attachment id.
    :vartype id: str
    :ivar attached_resource_id: The attached resource Id. Required.
    :vartype attached_resource_id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The edge action attachment id."""
    attached_resource_id: str = rest_field(name="attachedResourceId", visibility=["read", "create", "update"])
    """The attached resource Id. Required."""

    @overload
    def __init__(
        self,
        *,
        attached_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionExecutionFilter(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.edgeactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionExecutionFilterProperties
    """

    properties: Optional["_models.EdgeActionExecutionFilterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EdgeActionExecutionFilterProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionExecutionFilterProperties(_Model):
    """Properties for edge action execution filter.

    :ivar version_id: The referenced versionId of the edgeaction version. Required.
    :vartype version_id: str
    :ivar last_update_time: The last update time in UTC for the execution filter.
    :vartype last_update_time: ~datetime.datetime
    :ivar execution_filter_identifier_header_name: Custom Header Key associated with the execution
     filter. Required.
    :vartype execution_filter_identifier_header_name: str
    :ivar execution_filter_identifier_header_value: Custom Header Value associated with the
     execution filter. Required.
    :vartype execution_filter_identifier_header_value: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", and "Upgrading".
    :vartype provisioning_state: str or ~azure.mgmt.edgeactions.models.ProvisioningState
    """

    version_id: str = rest_field(name="versionId", visibility=["read", "create", "update"])
    """The referenced versionId of the edgeaction version. Required."""
    last_update_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """The last update time in UTC for the execution filter."""
    execution_filter_identifier_header_name: str = rest_field(
        name="executionFilterIdentifierHeaderName", visibility=["read", "create", "update"]
    )
    """Custom Header Key associated with the execution filter. Required."""
    execution_filter_identifier_header_value: str = rest_field(
        name="executionFilterIdentifierHeaderValue", visibility=["read", "create", "update"]
    )
    """Custom Header Value associated with the execution filter. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", and \"Upgrading\"."""

    @overload
    def __init__(
        self,
        *,
        version_id: str,
        execution_filter_identifier_header_name: str,
        execution_filter_identifier_header_value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionExecutionFilterUpdate(_Model):
    """The type used for update operations of the EdgeActionExecutionFilter.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionExecutionFilterUpdateProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.EdgeActionExecutionFilterUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EdgeActionExecutionFilterUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionExecutionFilterUpdateProperties(_Model):  # pylint: disable=name-too-long
    """The updatable properties of the EdgeActionExecutionFilter.

    :ivar version_id: The referenced versionId of the edgeaction version.
    :vartype version_id: str
    :ivar execution_filter_identifier_header_name: Custom Header Key associated with the execution
     filter.
    :vartype execution_filter_identifier_header_name: str
    :ivar execution_filter_identifier_header_value: Custom Header Value associated with the
     execution filter.
    :vartype execution_filter_identifier_header_value: str
    """

    version_id: Optional[str] = rest_field(name="versionId", visibility=["read", "create", "update"])
    """The referenced versionId of the edgeaction version."""
    execution_filter_identifier_header_name: Optional[str] = rest_field(
        name="executionFilterIdentifierHeaderName", visibility=["read", "create", "update"]
    )
    """Custom Header Key associated with the execution filter."""
    execution_filter_identifier_header_value: Optional[str] = rest_field(
        name="executionFilterIdentifierHeaderValue", visibility=["read", "create", "update"]
    )
    """Custom Header Value associated with the execution filter."""

    @overload
    def __init__(
        self,
        *,
        version_id: Optional[str] = None,
        execution_filter_identifier_header_name: Optional[str] = None,
        execution_filter_identifier_header_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionProperties(_Model):
    """Represents an edge action properties.

    :ivar provisioning_state: The provisioning state of the edge action. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", and "Upgrading".
    :vartype provisioning_state: str or ~azure.mgmt.edgeactions.models.ProvisioningState
    :ivar attachments: A list of attachments for the edge action. Required.
    :vartype attachments: list[~azure.mgmt.edgeactions.models.EdgeActionAttachment]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the edge action. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Provisioning\", and \"Upgrading\"."""
    attachments: list["_models.EdgeActionAttachment"] = rest_field(visibility=["read"])
    """A list of attachments for the edge action. Required."""


class EdgeActionPropertiesUpdate(_Model):
    """Represents an edge action properties."""


class EdgeActionUpdate(_Model):
    """The type used for update operations of the EdgeAction.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionPropertiesUpdate
    :ivar sku: The sku type of the edge action.
    :vartype sku: ~azure.mgmt.edgeactions.models.SkuTypeUpdate
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.EdgeActionPropertiesUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    sku: Optional["_models.SkuTypeUpdate"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku type of the edge action."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EdgeActionPropertiesUpdate"] = None,
        sku: Optional["_models.SkuTypeUpdate"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionVersion(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.edgeactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionVersionProperties
    """

    properties: Optional["_models.EdgeActionVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EdgeActionVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionVersionProperties(_Model):
    """Represents an edge action version.

    :ivar deployment_type: The deployment type. Required. Known values are: "zip", "file", and
     "others".
    :vartype deployment_type: str or ~azure.mgmt.edgeactions.models.EdgeActionVersionDeploymentType
    :ivar validation_status: The validation status. Known values are: "Succeeded" and "Failed".
    :vartype validation_status: str or
     ~azure.mgmt.edgeactions.models.EdgeActionVersionValidationStatus
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", and "Upgrading".
    :vartype provisioning_state: str or ~azure.mgmt.edgeactions.models.ProvisioningState
    :ivar is_default_version: The active state. Required. Known values are: "True" and "False".
    :vartype is_default_version: str or ~azure.mgmt.edgeactions.models.EdgeActionIsDefaultVersion
    :ivar last_package_update_time: The last update time in UTC for package update.
    :vartype last_package_update_time: ~datetime.datetime
    """

    deployment_type: Union[str, "_models.EdgeActionVersionDeploymentType"] = rest_field(
        name="deploymentType", visibility=["read", "create", "update"]
    )
    """The deployment type. Required. Known values are: \"zip\", \"file\", and \"others\"."""
    validation_status: Optional[Union[str, "_models.EdgeActionVersionValidationStatus"]] = rest_field(
        name="validationStatus", visibility=["read"]
    )
    """The validation status. Known values are: \"Succeeded\" and \"Failed\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", and \"Upgrading\"."""
    is_default_version: Union[str, "_models.EdgeActionIsDefaultVersion"] = rest_field(
        name="isDefaultVersion", visibility=["read", "create", "update"]
    )
    """The active state. Required. Known values are: \"True\" and \"False\"."""
    last_package_update_time: Optional[datetime.datetime] = rest_field(
        name="lastPackageUpdateTime", visibility=["read"], format="rfc3339"
    )
    """The last update time in UTC for package update."""

    @overload
    def __init__(
        self,
        *,
        deployment_type: Union[str, "_models.EdgeActionVersionDeploymentType"],
        is_default_version: Union[str, "_models.EdgeActionIsDefaultVersion"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionVersionUpdate(_Model):
    """The type used for update operations of the EdgeActionVersion.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.edgeactions.models.EdgeActionVersionUpdateProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.EdgeActionVersionUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EdgeActionVersionUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeActionVersionUpdateProperties(_Model):
    """The updatable properties of the EdgeActionVersion.

    :ivar deployment_type: The deployment type. Known values are: "zip", "file", and "others".
    :vartype deployment_type: str or ~azure.mgmt.edgeactions.models.EdgeActionVersionDeploymentType
    :ivar is_default_version: The active state. Known values are: "True" and "False".
    :vartype is_default_version: str or ~azure.mgmt.edgeactions.models.EdgeActionIsDefaultVersion
    """

    deployment_type: Optional[Union[str, "_models.EdgeActionVersionDeploymentType"]] = rest_field(
        name="deploymentType", visibility=["read", "create", "update"]
    )
    """The deployment type. Known values are: \"zip\", \"file\", and \"others\"."""
    is_default_version: Optional[Union[str, "_models.EdgeActionIsDefaultVersion"]] = rest_field(
        name="isDefaultVersion", visibility=["read", "create", "update"]
    )
    """The active state. Known values are: \"True\" and \"False\"."""

    @overload
    def __init__(
        self,
        *,
        deployment_type: Optional[Union[str, "_models.EdgeActionVersionDeploymentType"]] = None,
        is_default_version: Optional[Union[str, "_models.EdgeActionIsDefaultVersion"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.edgeactions.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.edgeactions.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.edgeactions.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkuType(_Model):
    """The SKU type for the edge action.

    :ivar name: The name of the SKU. Required.
    :vartype name: str
    :ivar tier: The tier of the SKU. Required.
    :vartype tier: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Required."""
    tier: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tier of the SKU. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkuTypeUpdate(_Model):
    """The SKU type for update operations.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU.
    :vartype tier: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU."""
    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tier of the SKU."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.edgeactions.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.edgeactions.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VersionCode(_Model):
    """Version code information for edge action.

    :ivar content: The version code deployment content. Required.
    :vartype content: str
    :ivar name: The version code name. Required.
    :vartype name: str
    """

    content: str = rest_field(visibility=["read", "create", "update"])
    """The version code deployment content. Required."""
    name: str = rest_field(visibility=["read", "create", "update"])
    """The version code name. Required."""

    @overload
    def __init__(
        self,
        *,
        content: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
