# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.batch import BatchManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-batch
# USAGE
    python pool_create_virtual_machine_configuration.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = BatchManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.pool.create(
        resource_group_name="default-azurebatch-japaneast",
        account_name="sampleacct",
        pool_name="testpool",
        parameters={
            "properties": {
                "deploymentConfiguration": {
                    "virtualMachineConfiguration": {
                        "dataDisks": [
                            {
                                "caching": "ReadWrite",
                                "diskSizeGB": 30,
                                "lun": 0,
                                "managedDisk": {"storageAccountType": "StandardSSD_LRS"},
                            },
                            {
                                "caching": "None",
                                "diskSizeGB": 200,
                                "lun": 1,
                                "managedDisk": {"storageAccountType": "Premium_LRS"},
                            },
                        ],
                        "diskEncryptionConfiguration": {"targets": ["OsDisk", "TemporaryDisk"]},
                        "imageReference": {
                            "offer": "WindowsServer",
                            "publisher": "MicrosoftWindowsServer",
                            "sku": "2016-Datacenter-SmallDisk",
                            "version": "latest",
                        },
                        "licenseType": "Windows_Server",
                        "nodeAgentSkuId": "batch.node.windows amd64",
                        "nodePlacementConfiguration": {"policy": "Zonal"},
                        "osDisk": {"ephemeralOSDiskSettings": {"placement": "CacheDisk"}},
                        "windowsConfiguration": {"enableAutomaticUpdates": False},
                    }
                },
                "networkConfiguration": {
                    "endpointConfiguration": {
                        "inboundNatPools": [
                            {
                                "backendPort": 12001,
                                "frontendPortRangeEnd": 15100,
                                "frontendPortRangeStart": 15000,
                                "name": "testnat",
                                "networkSecurityGroupRules": [
                                    {
                                        "access": "Allow",
                                        "priority": 150,
                                        "sourceAddressPrefix": "192.100.12.45",
                                        "sourcePortRanges": ["1", "2"],
                                    },
                                    {
                                        "access": "Deny",
                                        "priority": 3500,
                                        "sourceAddressPrefix": "*",
                                        "sourcePortRanges": ["*"],
                                    },
                                ],
                                "protocol": "TCP",
                            }
                        ]
                    }
                },
                "scaleSettings": {"autoScale": {"evaluationInterval": "PT5M", "formula": "$TargetDedicatedNodes=1"}},
                "vmSize": "STANDARD_D4",
            }
        },
    )
    print(response)


# x-ms-original-file: 2025-06-01/PoolCreate_VirtualMachineConfiguration.json
if __name__ == "__main__":
    main()
