/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.atomicterms;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_atom_length
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term tatom = args[0];
        Term tlength = args[1];
        if (tatom instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(tatom instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, tatom);
        }
        AtomTerm atom = (AtomTerm)tatom;
        if (tlength instanceof VariableTerm) {
            IntegerTerm ilength = IntegerTerm.get(atom.value.length());
            VariableTerm vlength = (VariableTerm)tlength;
            interpreter.addVariableUndo(vlength);
            vlength.value = ilength;
            return 1;
        }
        if (tlength instanceof IntegerTerm) {
            IntegerTerm ilength = (IntegerTerm)tlength;
            if (ilength.value < 0) {
                PrologException.domainError(TermConstants.notLessThanZeroAtom, tlength);
            }
            if (ilength.value == atom.value.length()) {
                return 1;
            }
            return -1;
        }
        PrologException.typeError(TermConstants.integerAtom, tlength);
        return -1;
    }
}

