/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/********************************************************************/

#include <gl.h>
#include <math.h>
#include "graph.h"

extern int   obj_index;
extern Box   *box;
extern Obj   *obj;
extern Flag  flag;
extern View  view;
extern float sizze;
extern long int   win[4];
extern int   text_in;
extern void  (*drawf)();


float Identity[4][4] =
{
  { 1.0,0.0,0.0,0.0},
  { 0.0,1.0,0.0,0.0},
  { 0.0,0.0,1.0,0.0},
  { 0.0,0.0,0.0,1.0}
};

float  back_color[3];
int    depth_color[6] = {0,0,0,0,255,0};

/*******************************************
 *
 * make_object()
 *
 *******************************************/

make_object()
{
  /*
   *  i.e. if not freezed
   */
  if(flag.redraw) 
    {
      /*
       *  if light properties changed , need to redefine them
       */
      if(flag.light)
	{
	  if(flag.need_redefine_lm) def_light_model();
	  if(flag.need_redefine_mp) def_material(); 
	}
      winset(win[0]);
      { 
	if(flag.light) mmode(MVIEWING);
	else mmode(MSINGLE);
	if(view.proj_flag == PERSPECTIVE) 
	  perspective(view.fovy,view.aspect,view.pnear,view.pfar);
	else
	  ortho(view.left,view.right,view.bottom,
		view.top,view.near,view.far);
	
	if(flag.light) loadmatrix(Identity);
	lookat(view.vx,view.vy,view.vz,view.px,
	       view.py,view.pz,view.twist);
      }
      
      /*
       * bind the new light src and ...
       */
      if(flag.light && (flag.need_redefine_lm || flag.need_redefine_mp))
	{
	  depthcue(0);
	  bind_light_model(); 
	  flag.need_redefine_lm = 0;
	  flag.need_redefine_mp = 0;
	}
      
      /*
       * set up the  the z buffer
       */
      if(flag.depthcue)
	{
	  zbuffer(1); lsetdepth(0,0x007fff); zclear();
	}
      else if(flag.zbuffer_flag ) 
	{
	  zbuffer(1); lsetdepth(0,0x7fffff); zclear();
	} 
      else zbuffer(0);

      if(flag.cmap_flag)   color(0);
      else                 c3f(back_color);
      clear();

      if(flag.bulb_flag && flag.light) make_bulbs();
      
      if(flag.depthcue)
	{
	  depthcue(1);
	  if(!flag.cmap_flag)
	    lRGBrange(depth_color[2],depth_color[0],depth_color[1],
		      depth_color[5],depth_color[3],depth_color[4],0,0x007fff);
	  else
	    lshaderange(3329,3583,0,0x007fff);
	}

      if(flag.sp_flag) 
	{
	  if(flag.light)  lmbind(MATERIAL,SLICEPLANEMAT);	    
	  else 
	    {
	      if(flag.cmap_flag) color(3327);
	      else cpack(0x00afffaf);
	    }
	  draw_slice_plane();
	}

      if(flag.mode_flag == 0 || flag.mode_flag == 1) 
	{
	  if(!flag.mode_flag)
	    translate(view.x_trans,view.y_trans,view.z_trans);
	  scale(view.x_scale,view.y_scale,view.z_scale);
	  set_rotation(view.rot_old_flag,view.x_rot,view.y_rot,view.z_rot);
	  if(flag.mode_flag)
	    translate(view.x_trans,view.y_trans,view.z_trans);
	}

      if(flag.coor_flag)
	{
	  if(flag.depthcue)
	    {
	      if(!flag.cmap_flag)
		lRGBrange(depth_color[1],depth_color[2],depth_color[0],
			  depth_color[4],depth_color[5],
			  depth_color[3],0,0x007fff);
	      else 
		lshaderange(2561,2815,0,0x007fff);
	    }
	  else if(flag.cmap_flag) color(3839);
	  else cpack(0x00ff00ff);
	  draw_coor(sizze,1);
	}

      if(flag.big_box_flag) 
	{
	  if(flag.depthcue)
	    {
	      if(!flag.cmap_flag)
		lRGBrange(depth_color[0],depth_color[2],depth_color[1],
			  depth_color[3],depth_color[5],
			  depth_color[4],0,0x007fff);
	      else 
		lshaderange(2817,3071,0,0x007fff);
	    }
	  else if(flag.cmap_flag) color(2810);
	  else cpack(0x0000af00);
	  
	  draw_big_box();
	}
      
      if(flag.depthcue)
	{
	  if(!flag.cmap_flag)
	    lRGBrange(depth_color[0],depth_color[1],depth_color[2],
		      depth_color[3],depth_color[4],depth_color[5],0,0x007fff);
	  else 
	    lshaderange(3584,3840,0,0x007fff);
	}


      drawf();

      
      obj_index = 0; 
      if(flag.buffer_flag) swapbuffers();

      if(flag.slice && flag.slice_draw && flag.sp_flag)
	{
	  winset(win[2]);
	  draw_slice();
	  obj_index = 0; 
	}
    }
  if( flag.box_flag) 
    {
      winset(win[1]);
      ortho(- 2.7* sizze, 2.7* sizze, - 2.7* sizze, 2.7* sizze,
	     - 2.4 *sizze, 4.0* sizze);
      lookat(0.,0.,sizze,0.,0.,0.,0);
      scale(box->x_scale,box->y_scale,box->z_scale);
      translate(box->x_trans,box->y_trans,box->z_trans);
      rotate(box->x_rot,'x'); rotate(box->y_rot,'y'); rotate(box->z_rot,'z');
      mk_ov_box();
      swapbuffers();
    }
}

/***************************************************************/
/*
 * draw a box around the object
 */

extern float obox[8][3];  
draw_big_box()
{
  bgnline();
  v3f(obox[0]);    v3f(obox[1]);   v3f(obox[2]);   v3f(obox[3]); 
  v3f(obox[0]);   v3f(obox[4]); 
  v3f(obox[5]);   v3f(obox[6]);    v3f(obox[7]);  v3f(obox[4]); 
  endline();
  bgnline();
  v3f(obox[1]); v3f(obox[5]);
  endline();
  bgnline();
  v3f(obox[2]); v3f(obox[6]);
  endline();
  bgnline();
  v3f(obox[3]); v3f(obox[7]);
  endline();
}
/***************************************************************/
