
/******************************************************************
 *
 *  IRISPLOT
 *              ------------------ message1.c 
 *
 * Copyright 1990 Zou Maorong
 *
 ******************************************************************/

#include <stdio.h>
#include <math.h>
#include "graph.h"

extern Obj   *obj;
extern Flag  flag;
extern View  view;
extern Light *light;
extern Slice *slice;
extern Lmodel *lmodel;

extern struct text_line 
{
  char *buf;
  int index,color;
  struct text_line *prev, *next;
} *Text;
extern int text_in;

char text_buffer[256];
static int current_color = 0;

struct text_line *current_last_line = (struct text_line *) NULL;
char   *malloc(), *strcpy();
int    strlen();

/***************************************************************/


#define Red 1
#define Grn 2
#define Blu 3
#define Cya 4
#define Yel 5
#define Mag 6

show_view()
{
  current_color = (rand() >>5)%7;
  if(view.proj_flag == ORTHOGONAL)
    (void)sprintf(text_buffer,"orthogonal(%f %f %f %f %f %f)",
		  view.left,view.right,view.bottom,view.top,
		  view.near,view.far);
  else
    (void)sprintf(text_buffer,"perspective(%d %f %f %f)",view.fovy,
		  view.aspect,view.pnear,view.pfar);
  add_a_line_to_text(text_buffer);
  current_color = (rand() >>5)%7;
  (void)sprintf(text_buffer,"lookat( %f %f %f %f %f %f %d)",
		view.vx,view.vy,view.vz,view.px,view.py,view.pz,view.twist);
  add_a_line_to_text(text_buffer);  
  add_a_line_to_text(" ");

  update_messages();
}

show_slice()
{
  (void)sprintf(text_buffer,"Slicing information:");
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  current_color = (rand() >>5)%7;
  (void)sprintf(text_buffer,
		"Plane normal:  ( %f , %f , %f)",
		slice->vx,slice->vy,slice->vz);
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);  
  (void)sprintf(text_buffer,"Dist from the origin = %f",slice->dist);
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  add_a_line_to_text(" ");

  update_messages();
}

show_material(i,j)
     int i,j;
{
  (void)sprintf(text_buffer,"\t Object %d Material %d ",i+1,j+1);
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,
		"EMISSION %f   %f  %f ",*(((obj + i)->mat + j)->mater +1),
		*(((obj + i)->mat + j)->mater +2),
		*(((obj + i)->mat + j)->mater +3));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,
		"AMBIENT %f   %f  %f ",*(((obj + i)->mat + j)->mater +5),
		*(((obj + i)->mat + j)->mater +6),
		*(((obj + i)->mat + j)->mater +7));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,
		"DIFFUSE %f   %f  %f ",*(((obj + i)->mat + j)->mater +9),
		*(((obj + i)->mat + j)->mater +10),
		*(((obj + i)->mat + j)->mater +11));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,
		"SPECULAR %f   %f  %f ",*(((obj + i)->mat + j)->mater +13),
		*(((obj + i)->mat + j)->mater +14),
		*(((obj + i)->mat + j)->mater +15));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"SHININESS %f ",
		*(((obj + i)->mat + j)->mater +17));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"ALPHA %f ",*(((obj + i)->mat + j)->mater +19));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);  
  add_a_line_to_text(" ");

  update_messages();
}

show_lmodel()
{
  (void)sprintf(text_buffer,"\t L Model ");
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"AMBIENT %f   %f  %f ", *(lmodel->token +1) , 
	 *(lmodel->token + 2), *(lmodel->token + 3));  
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"LOCALVIEWER   %f ", *(lmodel->token + 5));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"ATTENUATION  %f   %f", *(lmodel->token + 7),
	 *(lmodel->token + 8));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"ATTENUATION2  %f", *(lmodel->token + 10));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"TWOSIDE %f", *(lmodel->token + 12));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  add_a_line_to_text(" ");

  update_messages();
}

show_lsrc(nu)
     int nu;
{
  (void)sprintf(text_buffer,"\t L Source   %d ",nu );
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"AMBIENT  %f  %f  %f",*( (light + nu)->token + 10),
	 *( (light + nu)->token + 11),
	 *( (light + nu)->token + 12) );
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"LCOLOR  %f  %f  %f",*( (light + nu)->token + 1),
	 *( (light + nu)->token + 2),
	 *( (light + nu)->token + 3) );
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"POSITION  %f  %f  %f  %f",
		*( (light + nu)->token + 5),
		*( (light + nu)->token + 6) ,
		*( (light + nu)->token + 7),*( (light + nu)->token +8) );
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"SPOTDIRECTION  %f  %f  %f",
		*( (light + nu)->token + 14),
		*( (light + nu)->token + 15),
		*( (light + nu)->token + 16) );
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  (void)sprintf(text_buffer,"SPOTLIGHT  %f  %f",
		*( (light + nu)->token + 18),
		*( (light + nu)->token + 19));
  current_color = (rand() >>5)%7;
  add_a_line_to_text(text_buffer);
  add_a_line_to_text(" ");

  update_messages();
}

/***************************************************************/

initialize_message()
{
  current_color = (rand() >>5)%7;
  add_a_line_to_text(" ");
  /* 
   * add_a_line_to_text("      Irisplot Message Window ");
   * add_a_line_to_text(" ");
   */

}

free_message()
{
  struct text_line *temp_line1, *temp_line = Text;
  while(temp_line)
    {
      temp_line1 = temp_line->next;
      (void)free( (char *)temp_line->buf);
      (void)free((char *)temp_line);
      temp_line = temp_line1;
    }
  Text = (struct text_line *)NULL;
  current_last_line = (struct text_line *)NULL;
  reset_scroll();
}
/***************************************************************/

add_a_line_to_text(line_str)
     char *line_str;
{
  register int c_index;
  struct text_line **current_line,*prev;
  
  if(current_last_line)
    {
      prev = current_last_line;
      c_index = current_last_line->index;
      current_line = &(current_last_line->next);      
    }
  else
    {
      prev = (struct text_line *) NULL;
      c_index = 0;
      current_line = &(Text);
    }
  
  (*current_line) = (struct text_line *)
    malloc((unsigned) sizeof(struct text_line));
  (*current_line)->prev = prev;
  (*current_line)->next = (struct text_line *)NULL;
  (*current_line)->index = c_index + 1;
  (*current_line)->color = current_color;
  (*current_line)->buf = 
    (char *)malloc((unsigned)(strlen(line_str)+1)* sizeof(char));
  (void)strcpy((*current_line)->buf,line_str);
  current_last_line = (*current_line);
  text_in++;
}
/**************************************************************/
