/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/********************************************************************/
/*
 *  manage the graphics
 */

#include <gl.h>
#include <device.h>
#include <stdio.h>
#include "graph.h"

extern void printerror();

/*************************** 
 *
 * global variables 
 *
 ***************************/

int    *def_style;
Obj    *obj;
Box    *box;
Light  *light;
Lmodel *lmodel;
Menu   *menu;
Slice  *slice;
oview  *ooview;
Flag   flag;
View   view;
int    mat_index,obj_index;
float  sizze;
float  *m_props;
char   **menu_string;
void   (*drawf)();
void   (*pre_ini_obj)();
int    getpid();

/******************************************************/

graphic_manager(ini_fun,func,pview,style,mat_props,m_string)
     void   (*func)();
     void   (*ini_fun)();
     oview   *pview;
     int    *style;
     float  *mat_props;
     char   **m_string;
{
  menu_string = m_string;
  m_props = mat_props;
  def_style = style;
  ooview  = (oview *)pview;
  pre_ini_obj = ini_fun;
  drawf = func;

  srand(getpid());

  initialize_gp();
  ini_vp();
  frontbuffer(1);  

  if(flag.box_flag) ini_box();

  /*
   * when initialize material stuff, need menu to be allocated
   */
  allocate_menu();

  if(flag.light) ini_lm();

  int_obj_mat();
  if( pre_ini_obj) pre_ini_obj();

  if(flag.light) get_properties(m_props);

  if(flag.slice) ini_slice();

  if(flag.cmap_flag)  def_color(); 

  define_line_style();
  
  /*
   * lots of trouble was made by ...
   */
  make_menu();

  make_object();

  if(flag.buffer_flag)  frontbuffer(0);
    
  while(1) 
    {
      if(flag.save_image_flag)
	{
	  save_image_to_file();
	  get_out();
	}
      while(!(qtest()));
      process_input();  
    }
}
/******************************************************/
set_config() 
{
  /* initialize_gp(); */
}
/******************************************************/  
def_color()
{
  int i;
  for(i = 0; i < 256; i++)
    {
      mapcolor(2560+i,i,0,0);
      mapcolor(2816+i,0,i,0);
      mapcolor(3072+i,0,0,i);
      mapcolor(3328+i,i,i,0);
      mapcolor(3584+i,0,i,i);
      mapcolor(3840+i,i,i,i);
    }
}
/******************************************************/
cmap_on()
{
  flag.cmap_flag = 1; flag.light = 0;
}
/******************************************************/
reset()
{
  if(flag.box_flag)
    ini_box();
  ini_vp();
  if(flag.light)
    ini_lm();
  flag.local_light = 0;
  int_obj_mat();
  pre_ini_obj();
  flag.need_redefine_mp = 1;
  flag.need_redefine_lm = 1;
  if(flag.light)
    get_properties(m_props);
  if(flag.slice) 
    {
      ini_slice();
      flag.slice_draw = 1;
    }
  if(flag.cmap_flag)  
    def_color(); 
  make_object();
  update_main_menu();

  if(flag.light)
    {
      update_on_light_menu(0);
      update_lmodel_menu();
    }
  if(flag.slice)
    {
      update_slice_menu();
      flag.slice_draw = 0;
    }
}
/******************************************************/
extern int base_box;

initialize()
{
  flag.mode_flag = 0;         flag.box_flag = 0; 
  flag.cmap_flag = 0;         flag.sp_flag = 0;
  flag.light = 1;             flag.slice = 0; 
  flag.slice_draw = 0;        flag.zbuffer_flag = 1;
  flag.redraw = 1;            flag.coor_flag = 0;
  flag.depthcue = 0;          flag.buffer_flag = 1;
  flag.big_box_flag = 0;      flag.bulb_flag = 0;
  flag.need_redefine_lm = 1;  flag.need_redefine_mp = 1;
  flag.show_message_flag = 0; flag.r_coor_flag = 0;  
  flag.random_color = 0;      flag.local_light =0;
  flag.save_image_flag = 0;

  base_box = 0; 

  obj      = (Obj *)   NULL;
  box      = (Box *)   NULL;
  light    = (Light *) NULL;
  slice    = (Slice *) NULL;
  menu     = (Menu  *) NULL;
}

/*****************************************************/
image_saving_on(i)
     int i;
{
  flag.save_image_flag = i;
}
/*****************************************************/

extern int base_box;

 base_on()
{
  base_box = 1;
}
/*****************************************************/
 big_box_on()
{
  flag.big_box_flag = 1;     
}
/*****************************************************/
 coor_axes_on()
{
  flag.coor_flag = 1;
}
/*****************************************************/
bulb_on()
{
  flag.bulb_flag = 1;
}
/*****************************************************/
doublebuffer_off()
{
  flag.buffer_flag = 0;
}
/*****************************************************/
depthcue_on()
{
  flag.depthcue = 1;
  flag.light = 0;
}
/*****************************************************/
light_on()
{
  flag.light = 1;
}
light_off()
{
  flag.light = 0;
}

/*******************************************************/
zbuffer_off()
{
  flag.zbuffer_flag = 0;
}
/*****************************************************/
slice_on()
{
  flag.slice = 1;   flag.sp_flag = 1;  flag.slice_draw = 1;
}
box_on()
{
  flag.box_flag = 1;
}

rot_mode(i)
     int i;
{
  flag.mode_flag = i;
}

/******************************************************
  modeling routine 
******************************************************/

do_translate(xv,yv,zv)
     float xv,yv,zv;
{
  if(! ((obj+obj_index)->tr_flag)) 
    {
      (obj+obj_index)->x_trans += xv;
      (obj+obj_index)->y_trans += yv;
      (obj+obj_index)->z_trans += zv;
      (obj+obj_index)->tr_flag = 1;
    }
}

do_rotate(xr,yr,zr)
     short xr,yr,zr;
{
  if(! ((obj+obj_index)->ro_flag)) 
    {
      (obj+obj_index)->x_rot += xr;
      (obj+obj_index)->y_rot += yr;
      (obj+obj_index)->z_rot += zr;  
      (obj+obj_index)->ro_flag = 1;
    }
}

do_scale(xs,ys,zs)
     float xs,ys,zs;
{
  if(! ((obj+obj_index)->sc_flag))
    {
      (obj+obj_index)->x_scale *= xs;
      (obj+obj_index)->y_scale *= ys;
      (obj+obj_index)->z_scale *= zs;
      (obj+obj_index)->sc_flag = 1;
    }
}

/******************************************************/
define_line_style()
{
  deflinestyle(1,0x3FFF); /* long dash */
  deflinestyle(2,0x5555); /* dotted */
  deflinestyle(3,0x3333); /* short dash */
  deflinestyle(4,0xB5AD); /* dotdashed */  
}
/******************************************************/
