/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/*****************************************************************
 *
 *  set up  the necessary stuff for the object the application 
 *  program  defined 
 *
 *****************************************************************/

#include <gl.h>
#include <device.h>
#include <math.h>
#include <string.h>
#include <stdio.h>
#include "graph.h"

extern int     *def_style;
extern Obj     *obj;
extern Menu    *menu;
extern View    view;
extern Flag    flag;
extern short   anglex,angley,anglez;
extern float   factor;
extern float   sizze;
extern int     mat_index,obj_index;
extern char    **menu_string;
extern int     update_rot();

int            *obj_style;
void           printerror();
char           *malloc();
/*
 * variables for the objects or the materials menu
 */

char BIG_materials[ ] = "Materials%t|No. 1|No. 2|No. 3|No. 4|No. 5|No. 6|No. 7|No. 8|No. 9|No.10|No.11|No.12|No.13|No.14|No.15|No.16|No.17|No.18|No.19|No.20|No.21|No.22|No.23|No.24|No.25|No.26|No.27|No.28|No.29|No.30|No.31|No.32|No.33|No.34|No.35|No.36|No.37|No.38|No.39|No.40|No.41|No.42|No.43|No.44|No.45";

char BIG_objects[ ] = "Objects%t|No. 1|No. 2|No. 3|No. 4|No. 5|No. 6|No. 7|No. 8|No. 9|No.10|No.11|No.12|No.13|No.14|No.15|No.16|No.17|No.18|No.19|No.20|No.21|No.22|No.23|No.24|No.25|No.26|No.27|No.28|No.29|No.30|No.31|No.32|No.33|No.34|No.35|No.36|No.37|No.38|No.39|No.40|No.41|No.42|No.43|No.44|No.45";


/***********************************
 *
 * int_obj_mat() 
 * locate space for objects , 
 * materials ... and initialize them
 * to the defaults
 *
 ************************************/

int default_style[2] = {1,1};

int_obj_mat()
{
  int  j,k,ll,nn;

  k = 0; ll = 10; nn=0;

  obj_style = default_style;
  if( def_style != NULL)
    obj_style = def_style;
  if( obj_style[0] <= 0)
    nn = 1;
  for(j = 0; j <= obj_style[0]; j++)
    {
      if(*(obj_style + j) > 100 || *(obj_style + j) <= 0 )
	nn = 1;
    }
  if(nn)
    {
      printerror("Too man objects or materials");
      return; 
    }
  j = 0;
  nn = 0;

  nn = 10 + 6 * obj_style[0];
  if(!obj)
    { if(!menu_string)
	{
	  menu->obj_list_content=(char *)malloc((unsigned)nn * sizeof(char));
	  (void) strncpy(menu->obj_list_content,BIG_objects,(unsigned int)nn);
	  *(menu->obj_list_content + nn-1) = '\0';
	  menu->obj_list_menu = defpup(menu->obj_list_content);
	}
      else
	menu->obj_list_menu = defpup(menu_string[0]);
      
      obj = (Obj *) malloc( (unsigned) obj_style[0] * sizeof(Obj));
      for(nn = 0; nn <  obj_style[0]; nn++ )
	(obj + nn)->mat = (Mat *) NULL;
    }

  while(j < obj_style[0] )
    {
      (obj+j)->x_scale = 1.0; (obj+j)->y_scale = 1.0; (obj+j)->z_scale = 1.0; 
      (obj+j)->x_trans = 0.0; (obj+j)->y_trans = 0.0; (obj+j)->z_trans = 0.0; 
      (obj+j)->x_rot  =  0 ; (obj+j)->y_rot  =  0 ; (obj+j)->z_rot  =  0 ; 
      (obj+j)->rot_old = (obj+j)->rot_new = XYZ;
      (obj+j)->tr_flag = (obj+j)->ro_flag = (obj+j)->sc_flag = 0;
      (obj+j)->draw = 1;

      if(flag.light )
	{
	  if( !( (obj + j)->mat))
	    {
	      (obj + j)->mat =
		( Mat *)malloc((unsigned) obj_style[j+1] * sizeof(Mat));

	      nn =  12 + 6 * obj_style[j+1] ;
	      if(!menu_string)
		{
		  (obj+j)->menu_content = 
		    (char *)malloc((unsigned) nn * sizeof(char));
		  (void) strncpy((obj+j)->menu_content,BIG_materials,
				 (unsigned int)nn); 
		  *((obj+j)->menu_content + nn -1) = '\0';
		  (obj+j)->material_menu = defpup( (obj+j)->menu_content);
		}
	      else 
		  (obj+j)->material_menu = defpup(menu_string[j+1]);
	    }
      
	  k = 0;
	  while( k < obj_style[j+1]) 
	    {
	      ((obj+j)->mat+k)->mat_index = ll++;
	      ((obj+j)->mat+k)->mat_change = 1;

	      *(((obj+j)->mat+k)->mater) = EMISSION;
	      *(((obj+j)->mat+k)->mater + 1) = 0.10;
	      *(((obj+j)->mat+k)->mater + 2) = 0.10;
	      *(((obj+j)->mat+k)->mater + 3) = 0.10;
	      *(((obj+j)->mat+k)->mater + 4) = AMBIENT;
	      *(((obj+j)->mat+k)->mater + 5) = 0.2;
	      *(((obj+j)->mat+k)->mater + 6) = 0.2;
	      *(((obj+j)->mat+k)->mater + 7) = 0.2;
	      *(((obj+j)->mat+k)->mater + 8) = DIFFUSE;
	      *(((obj+j)->mat+k)->mater + 9) = 0.8;      
	      *(((obj+j)->mat+k)->mater + 10) = 0.3;      
	      *(((obj+j)->mat+k)->mater + 11) = 0.8;      
	      *(((obj+j)->mat+k)->mater + 12) = SPECULAR;
	      *(((obj+j)->mat+k)->mater + 13) = 0.6;      
	      *(((obj+j)->mat+k)->mater + 14) = 0.6;      
	      *(((obj+j)->mat+k)->mater + 15) = 0.6;      
	      *(((obj+j)->mat+k)->mater + 16) = SHININESS;
	      *(((obj+j)->mat+k)->mater + 17) = 5.0;      
	      *(((obj+j)->mat+k)->mater + 18) = ALPHA;
	      *(((obj+j)->mat+k)->mater + 19) = 1.0;      
	      *(((obj+j)->mat+k)->mater + 20) = LMNULL; 
	      k++;
	    }
	}
      j++;
    }
}

/*****************************************
 *
 * local_model()
 * modify the objects, object materials 
 * according to the input
 *
 ******************************************/
local_model()
{
  int menu_val,menu_val1,menu_val2;

  menu_val = dopup(menu->obj_list_menu);
  if(menu_val <= 0)
    { qreset(); return; }

  flag.slice_draw = 1;
  update_local_menu(menu_val-1);
  
  menu_val1 = dopup(menu->local_menu);
  if(menu_val1 <= 0)
    { qreset(); return;}
  else if(menu_val1 == 1)
    {
      if( ((obj+menu_val - 1)->draw))
	change_obj( (obj+menu_val - 1));
      else
	(void) dopup(menu->warning_menu);
    }
  else if(menu_val1 == 2 && flag.light) 
    {
      if( ((obj+menu_val - 1)->draw))
	{
	  menu_val2 = dopup( (obj+menu_val - 1)->material_menu);
	  if(menu_val2 <= 0)
	    {  qreset();  return;}
	  change_material(menu_val - 1, menu_val2 - 1);
	}
      else
	(void) dopup(menu->warning_menu);
    }
  else
    {
      if( ((obj+menu_val - 1)->draw))
	((obj+menu_val - 1)->draw) = 0;
      else
	((obj+menu_val - 1)->draw) = 1;
      make_object();
      update_local_menu(menu_val-1);
    }
  flag.slice_draw = 0;
  qreset();
}
/********************************
 *
 * change_obj()
 * coordinate transformation for 
 * different objects
 *
 ********************************/

change_obj(obj_ptr)
     Obj *obj_ptr;
{
  int menu_val, menu_val1, dev, x0, x1, dx; 
  short val;

  menu_val = dopup(menu->obj_menu);
  if(menu_val <= 0) return;   
 tryagain:
  if(menu_val == 1)  {
    menu_val1 = dopup(menu->rot_menu);
    if(menu_val1 <= 0) return;
    (obj_ptr->rot_new) = menu_val1;
    if(flag.mode_flag == 2 || flag.mode_flag == 3) {
      if(! update_rot(obj_ptr->rot_old, obj_ptr->rot_new ,
		      obj_ptr->x_rot+ view.x_rot,
		      obj_ptr->y_rot+ view.y_rot,
		      obj_ptr->z_rot+ view.z_rot)) {
	obj_ptr->x_rot = anglex - view.x_rot;
	obj_ptr->y_rot = angley - view.y_rot;
	obj_ptr->z_rot = anglez - view.z_rot; } 
    }
    if(flag.mode_flag == 0 || flag.mode_flag == 1) {
      if(! update_rot(obj_ptr->rot_old, obj_ptr->rot_new ,obj_ptr->x_rot,
		      obj_ptr->y_rot,obj_ptr->z_rot)) {
	obj_ptr->x_rot = anglex ;
	obj_ptr->y_rot = angley ;
	obj_ptr->z_rot = anglez ; }
    }
    obj_ptr->rot_old = menu_val1;
  }

  else if(menu_val == 2) menu_val1 = dopup(menu->scale_menu);
  else if(menu_val == 3) menu_val1 = dopup(menu->trans_menu);
  if(menu_val1 <= 0) return; 

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = x1 - x0;
      switch(menu_val)
	{
	case 2:
	  if(menu_val1 == 1)
	    {
	        obj_ptr->x_scale += 0.0005* (float) dx;
		obj_ptr->y_scale += 0.0005* (float) dx;
		obj_ptr->z_scale += 0.0005* (float) dx;
	      }
	  else if(menu_val1 == 2)  obj_ptr->x_scale += 0.0005* (float) dx;
	  else if(menu_val1 == 3)  obj_ptr->y_scale += 0.0005* (float) dx;
	  else if(menu_val1 == 4)  obj_ptr->z_scale += 0.0005* (float) dx;
	  break;
	case 1:
	  if(menu_val1 == 1) {
	    obj_ptr->x_rot += (short)(0.05*(float) dx);
	    obj_ptr->x_rot %= 3600;}
	  else if(menu_val1 == 2)  {
	    obj_ptr->y_rot += (short)(0.05*(float) dx);
	    obj_ptr->y_rot %= 3600;}	    
	  else if(menu_val1 == 3) {
	    obj_ptr->z_rot += (short)(0.05*(float) dx);
	    obj_ptr->z_rot %= 3600;}
	  break;
	case 3:
	  if(menu_val1 == 1)  obj_ptr->x_trans += factor * (float) dx;
	  else if(menu_val1 == 2)  obj_ptr->y_trans += factor * (float) dx;
	  else if(menu_val1 == 3)  obj_ptr->z_trans += factor * (float) dx;
	  break;	  
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE)  goto tryagain;
}

/*****************************************************
 *
 * change_material()
 * modify materials for each object
 *
 *****************************************************/
change_material(i,j)
     int i, j;
{
  int menu_val, menu_val1, dev,x0, x1;
  float dx;
  short val;


 tryagain:
  menu_val = dopup(menu->material_menu);
  if(menu_val <= 0 )  return;
  else if(menu_val >= 1 && menu_val <= 4)
    menu_val1 = dopup(menu->rgb_menu);
  if(menu_val1 <= 0) return; 

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      flag.need_redefine_mp = 1;

      ((obj + i)->mat +j)->mat_change = 1;
      x1 = getvaluator(MOUSEX);
      dx = 0.0002*(x1 - x0);
      switch(menu_val)
	{
	case 1:
	  if(menu_val1 == 1)
	    {
	      *(((obj + i)->mat + j)->mater +1) += dx;
	      *(((obj + i)->mat + j)->mater +2) += dx;
	      *(((obj + i)->mat + j)->mater +3) += dx;
	    }
	  else if(menu_val1 == 2)  
	    *(((obj + i)->mat + j)->mater +1) += dx;
	  else if(menu_val1 == 3) 
	    *(((obj + i)->mat + j)->mater +2) += dx;
	  else if(menu_val1 == 4) 
	    *(((obj + i)->mat + j)->mater +3) += dx;

	  if(*(((obj + i)->mat + j)->mater +1) >= 1.0)
	    *(((obj + i)->mat + j)->mater +1) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +1) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +1) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +2) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +2) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +2) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +2) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +3) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +3) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +3) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +3) = 0.0;
	  break;
	case 2:
	  if(menu_val1 == 1)
	    {
	      *(((obj + i)->mat + j)->mater +5) += dx;
	      *(((obj + i)->mat + j)->mater +6) += dx;
	      *(((obj + i)->mat + j)->mater +7) += dx;
	    }
	  else if(menu_val1 == 2)  
	    *(((obj + i)->mat + j)->mater +5) += dx;
	  else if(menu_val1 == 3) 
	    *(((obj + i)->mat + j)->mater +6) += dx;
	  else if(menu_val1 == 4) 
	    *(((obj + i)->mat + j)->mater +7) += dx;

	  if(*(((obj + i)->mat + j)->mater +5) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +5) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +5) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +5) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +6) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +6) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +6) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +6) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +7) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +7) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +7) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +7) = 0.0;
	  break;
	case 3:
	  if(menu_val1 == 1)
	    {
	      *(((obj + i)->mat + j)->mater +9) += dx;
	      *(((obj + i)->mat + j)->mater +10) += dx;
	      *(((obj + i)->mat + j)->mater +11) += dx;
	    }
	  else if(menu_val1 == 2)  
	    *(((obj + i)->mat + j)->mater +9) += dx;
	  else if(menu_val1 == 3) 
	    *(((obj + i)->mat + j)->mater +10) += dx;
	  else if(menu_val1 == 4) 
	    *(((obj + i)->mat + j)->mater +11) += dx;
	  
	  if(*(((obj + i)->mat + j)->mater +9) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +9) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +9) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +9) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +10) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +10) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +10) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +10) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +11) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +11) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +11) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +11) = 0.0;
	  break;
	case 4:
	  if(menu_val1 == 1)
	    {
	      *(((obj + i)->mat + j)->mater +13) += dx;
	      *(((obj + i)->mat + j)->mater +14) += dx;
	      *(((obj + i)->mat + j)->mater +15) += dx;
	    }
	  else if(menu_val1 == 2)  
	    *(((obj + i)->mat + j)->mater +13) += dx;
	  else if(menu_val1 == 3) 
	    *(((obj + i)->mat + j)->mater +14) += dx;
	  else  if(menu_val1 == 4) 
	    *(((obj + i)->mat + j)->mater +15) += dx;

	  if(*(((obj + i)->mat + j)->mater +13) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +13) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +13) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +13) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +14) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +14) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +14) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +14) = 0.0;
	  if(*(((obj + i)->mat + j)->mater +15) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +15) = 1.0;
	  else if(*(((obj + i)->mat + j)->mater +15) <= 0.0) 
	    *(((obj + i)->mat + j)->mater +15) = 0.0;
	  break;
	case 5:
	  *(((obj + i)->mat + j)->mater +17)+= 10.0 * dx;
	  if(*(((obj + i)->mat + j)->mater +17)<= 0.) 
	    *(((obj + i)->mat + j)->mater +17)= 0;
	  else if(*(((obj + i)->mat + j)->mater +17)>= 128.0)
	    *(((obj + i)->mat + j)->mater +17) = 128.0;
	  break;
	case 6:
	  *(((obj + i)->mat + j)->mater +19) += dx;
	  if(*(((obj + i)->mat + j)->mater +19) <= 0.) 
	    *(((obj + i)->mat + j)->mater +19) = 0;
	  else if(*(((obj + i)->mat + j)->mater +19) >= 1.0) 
	    *(((obj + i)->mat + j)->mater +19) = 1.0;
	  break;
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE)
    {
      if(flag.show_message_flag) 
	show_material(i,j);  
      goto try1;
    }
  if(dev == RIGHTMOUSE)
    {
      if(flag.show_message_flag) 
	show_material(i,j); 
      goto tryagain;
    }
}

/*****************************************
 *
 * def_material()
 *
 *****************************************/
def_material()
{
  int i,j;

  for(i = 0; i < obj_style[0]; ) 
    {
      for(j = 0; j < obj_style[i+1]; j++) 
	{    
	  if(((obj + i)->mat +j)->mat_change)  
	    {
	      lmdef(DEFMATERIAL,((obj + i)->mat +j)->mat_index,21,
		    ((obj + i)->mat +j)->mater);
	      ((obj + i)->mat +j)->mat_change = 0;
	    }  	
	}
      i++;
    }
}
/************************************
 *
 * bgnmaterial()
 *
 ************************************/
bgnmaterial()
{
  if(flag.light)
    {
      lmbind(MATERIAL,((obj + obj_index)->mat + mat_index)->mat_index);
      mat_index++;
    }
}
endmaterial()
{
}
bind_material(ii,jj)
     int ii, jj;
{
  if(flag.light)
    lmbind(MATERIAL,((obj + ii)->mat + jj)->mat_index);
}
/***********************************
 *
 *  bgntransparent()
 *
 ************************************/
bgntransparent()
{
  blendfunction(BF_SA,BF_MSA);
}

endtransparent()
{
  blendfunction(BF_ONE,BF_ZERO);
}
/*************************************
 *
 *  bgnobj()
 *  load the transformation matrix 
 *  for each object
 *
 *************************************/
bgnobj()
{
  mat_index = 0;

  if( !( (obj+obj_index)->draw))
    return(0);
  pushmatrix();

  if(flag.mode_flag == 0 || flag.mode_flag == 1)
    {
      if(!flag.mode_flag) 
	{
	  translate( (obj+obj_index)->x_trans ,
		    (obj+obj_index)->y_trans ,
		    (obj+obj_index)->z_trans ); 
	}
      scale(((obj+obj_index)->x_scale) ,
	    ((obj+obj_index)->y_scale)  ,
	    ((obj+obj_index)->z_scale)  );
      set_rotation( (obj+obj_index)->rot_old ,
		   (obj+obj_index)->x_rot ,
		   (obj+obj_index)->y_rot ,
		   (obj+obj_index)->z_rot ); 
      if(flag.mode_flag) 
	{
	  translate( (obj+obj_index)->x_trans ,
		    (obj+obj_index)->y_trans ,
		    (obj+obj_index)->z_trans ); 
	}
    }

  if(flag.mode_flag == 2 || flag.mode_flag == 3) 
    {
      if(flag.mode_flag == 2) 
	{
	  translate( (obj+obj_index)->x_trans + view.x_trans,
		    (obj+obj_index)->y_trans + view.y_trans,
		    (obj+obj_index)->z_trans + view.z_trans); 
	}
      scale(((obj+obj_index)->x_scale) * view.x_scale,
	    ((obj+obj_index)->y_scale)  * view.y_scale,
	    ((obj+obj_index)->z_scale)  * view.z_scale );
      set_rotation( (obj+obj_index)->rot_old ,
		   (obj+obj_index)->x_rot + view.x_rot, 
		   (obj+obj_index)->y_rot + view.y_rot,
		   (obj+obj_index)->z_rot + view.z_rot); 
      if(flag.mode_flag == 3) 
	{
	  translate( (obj+obj_index)->x_trans + view.x_trans,
		    (obj+obj_index)->y_trans + view.y_trans,
		    (obj+obj_index)->z_trans + view.z_trans); 
	}
    }
  if(flag.coor_flag)
    { 
      if(flag.cmap_flag) color(3071);
      else cpack(0x00ffff00); 
      draw_coor(0.5* sizze,1);
    }
  return(1);
}

/*****************************************/  
endobj()
{
  if( ((obj+obj_index)->draw))
    popmatrix();
  obj_index += 1;
}
/**************************************/
void printerror(str)
     char *str;
{
  (void) (void)fprintf(stderr,"%s\n",str);
}
/**************************************/

