/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/**************************************************************/

#include <gl.h>
#include <math.h>
#include "graph.h"

#define ABS(x) ((x)>0.0?(x):-(x))

extern Light  *light;
extern Flag   flag;

static float bubs[18][3];
static float nbubs[12][3];
static float e1[3],e2[3],e3[3];

static float lig_material[] =
{
  EMISSION,0.0,0.0,0.0,
  SPECULAR,1.0,1.0,1.0,
  DIFFUSE, 0.0,0.0,0.0,
  AMBIENT, 0.0,0.0,0.0,
  SHININESS,60.0,
  LMNULL
};

static float lig_material1[] =
{
  EMISSION,0.0,0.,0.0,
  AMBIENT, 0.2,0.2,0.2,
  SPECULAR,0.8,0.8,0.8,
  DIFFUSE, 0.4,0.4,0.4,
  SHININESS,30.0,
  LMNULL
};

/******************************************************/

compute_bub(nnn)
     int nnn;
{
  float norm;
  int i;

  if( *((light+nnn)->token+8) == 0.0 ||
      ((light+nnn)->spot) == 0.0)
    {
      e3[0] = *((light+nnn)->token+5);
      e3[1] = *((light+nnn)->token+6);
      e3[2] = *((light+nnn)->token+7);
    }
  else
    {
      e3[0] = -( *((light+nnn)->token+14) );
      e3[1] = -( *((light+nnn)->token+15) );
      e3[2] = -( *((light+nnn)->token+16) );
    }

  norm = sqrt(e3[0]*e3[0]+e3[1]*e3[1]+e3[2]*e3[2]);
  e3[0] /= norm; e3[1] /= norm; e3[2] /= norm;

  e1[0] = e3[1]* 1.32146 - e3[2]*1.98564;
  e1[1] = e3[2]* 2.87543 - e3[0]*1.32146;
  e1[2] = e3[0]* 1.98564 - e3[1]*2.87543;

  norm = sqrt(e1[0]*e1[0]+e1[1]*e1[1]+e1[2]*e1[2]);
  e1[0] /= norm; e1[1] /= norm; e1[2] /= norm;

  e2[0] = e3[1]*e1[2] - e3[2]*e1[1];
  e2[1] = e3[2]*e1[0] - e3[0]*e1[2];
  e2[2] = e3[0]*e1[1] - e3[1]*e1[0];
  
  bubs[0][0] = e1[0];
  bubs[0][1] = e1[1];
  bubs[0][2] = e1[2];
  bubs[1][0] = 0.5* e1[0] + 0.866* e2[0];
  bubs[1][1] = 0.5* e1[1] + 0.866* e2[1];
  bubs[1][2] = 0.5* e1[2] + 0.866* e2[2];
  bubs[2][0] = bubs[1][0] - e1[0];
  bubs[2][1] = bubs[1][1] - e1[1];
  bubs[2][2] = bubs[1][2] - e1[2];
  bubs[3][0]= -e1[0];  bubs[3][1]= -e1[1];  bubs[3][2] = -e1[2];
  bubs[4][0]= -bubs[1][0];  bubs[4][1]= -bubs[1][1];  bubs[4][2] = -bubs[1][2];
  bubs[5][0]= -bubs[2][0];  bubs[5][1]= -bubs[2][1];  bubs[5][2] = -bubs[2][2];

  for(i = 0; i < 6; i++)
    {
      bubs[i+6][0] = bubs[i][0]* 0.5 + e3[0];
      bubs[i+6][1] = bubs[i][1]* 0.5 + e3[1];
      bubs[i+6][2] = bubs[i][2]* 0.5 + e3[2] ;
      bubs[i+12][0] =bubs[i][0]* 0.5 + 3.0* e3[0] ;
      bubs[i+12][1] =bubs[i][1]* 0.5 + 3.0* e3[1] ;
      bubs[i+12][2] =bubs[i][2]* 0.5 + 3.0* e3[2] ;
    }

  nbubs[0][0] = 0.612*e1[0]+0.354*e2[0]+0.707*e3[0];
  nbubs[0][1] = 0.612*e1[1]+0.354*e2[1]+0.707*e3[1];
  nbubs[0][2] = 0.612*e1[2]+0.354*e2[2]+0.707*e3[2];
  nbubs[1][0] = 0.5*e2[0]+0.866*e3[0];
  nbubs[1][1] = 0.5*e2[1]+0.866*e3[1];
  nbubs[1][2] = 0.5*e2[2]+0.866*e3[2];
  nbubs[2][0] = -1.224*e1[0]+nbubs[0][0];
  nbubs[2][1] = -1.224*e1[1]+nbubs[0][1];
  nbubs[2][2] = -1.224*e1[2]+nbubs[0][2];
  nbubs[3][0] = - nbubs[0][0]+ 1.414*e3[0];
  nbubs[3][1] = - nbubs[0][1]+ 1.414*e3[1];
  nbubs[3][2] = - nbubs[0][2]+ 1.414*e3[2];
  nbubs[4][0] = - e2[0]+nbubs[1][0];
  nbubs[4][1] = - e2[1]+nbubs[1][1];
  nbubs[4][2] = - e2[2]+nbubs[1][2];
  nbubs[5][0] = nbubs[0][0] - 0.708*e2[0];
  nbubs[5][1] = nbubs[0][1] - 0.708*e2[1];
  nbubs[5][2] = nbubs[0][2] - 0.708*e2[2];
  nbubs[6][0] = 0.866*e1[0]+0.5*e2[0];
  nbubs[6][1] = 0.866*e1[1]+0.5*e2[1];
  nbubs[6][2] = 0.866*e1[2]+0.5*e2[2];
  nbubs[7][0] = e2[0];nbubs[7][1] = e2[1];nbubs[7][2] = e2[2];
  nbubs[8][0] = -0.866*e1[0]+0.5*e2[0];
  nbubs[8][1] = -0.866*e1[1]+0.5*e2[1];
  nbubs[8][2] = -0.866*e1[2]+0.5*e2[2];
  nbubs[9][0] =  nbubs[8][0] - e2[0];
  nbubs[9][1] =  nbubs[8][1] - e2[1];
  nbubs[9][2] =  nbubs[8][2] - e2[2];
  nbubs[10][0] = -e2[0];nbubs[10][1] = -e2[1];nbubs[10][2] = -e2[2];
  nbubs[11][0] = nbubs[6][0]-e2[0];
  nbubs[11][1] = nbubs[6][1]-e2[1];
  nbubs[11][2] = nbubs[6][2]-e2[2];

  lig_material[1] = *((light+nnn)->token + 1);
  lig_material[2] = *((light+nnn)->token + 2);
  lig_material[3] = *((light+nnn)->token + 3);
  lmdef(DEFMATERIAL,4311,19,lig_material);
  lig_material1[1] = 0.1 * lig_material[1];
  lig_material1[2] = 0.1 * lig_material[2];
  lig_material1[3] = 0.1 * lig_material[3];
  lmdef(DEFMATERIAL,4312,19,lig_material1);
}


make_a_bulb(nnn)
     int nnn;
{
  pushmatrix();
  translate(*((light+nnn)->token+5),*((light+nnn)->token+6),
	    *((light+nnn)->token+7));
  scale(*((light+nnn)->token +21),*((light+nnn)->token +21),
	*((light+nnn)->token +21));

  lmbind(MATERIAL,4312);  
  n3f(nbubs[0]);
  bgnpolygon();
  v3f(bubs[0]); v3f(bubs[1]); 
  v3f(bubs[7]);  v3f(bubs[6]); 
  endpolygon();
  n3f(nbubs[1]);
  bgnpolygon();
  v3f(bubs[1]); v3f(bubs[2]); 
  v3f(bubs[8]);  v3f(bubs[7]); 
  endpolygon();
  n3f(nbubs[2]);
  bgnpolygon();
  v3f(bubs[2]); v3f(bubs[3]); 
  v3f(bubs[9]);  v3f(bubs[8]); 
  endpolygon();
  n3f(nbubs[3]);
  bgnpolygon();
  v3f(bubs[3]); v3f(bubs[4]); 
  v3f(bubs[10]);  v3f(bubs[9]); 
  endpolygon();
  n3f(nbubs[4]);
  bgnpolygon();
  v3f(bubs[4]); v3f(bubs[5]); 
  v3f(bubs[11]);  v3f(bubs[10]); 
  endpolygon();
  n3f(nbubs[5]);
  bgnpolygon();
  v3f(bubs[5]); v3f(bubs[0]); 
  v3f(bubs[6]);  v3f(bubs[11]); 
  endpolygon();

  n3f(nbubs[6]);
  bgnpolygon();
  v3f(bubs[6]); v3f(bubs[7]); 
  v3f(bubs[13]);  v3f(bubs[12]); 
  endpolygon();
  n3f(nbubs[7]);
  bgnpolygon();
  v3f(bubs[7]); v3f(bubs[8]); 
  v3f(bubs[14]);  v3f(bubs[13]); 
  endpolygon();
  n3f(nbubs[8]);
  bgnpolygon();
  v3f(bubs[8]); v3f(bubs[9]); 
  v3f(bubs[15]);  v3f(bubs[14]); 
  endpolygon();
  n3f(nbubs[9]);
  bgnpolygon();
  v3f(bubs[9]); v3f(bubs[10]); 
  v3f(bubs[16]);  v3f(bubs[15]); 
  endpolygon();
  n3f(nbubs[10]);
  bgnpolygon();
  v3f(bubs[10]); v3f(bubs[11]); 
  v3f(bubs[17]);  v3f(bubs[16]); 
  endpolygon();
  n3f(nbubs[11]);
  bgnpolygon();
  v3f(bubs[11]); v3f(bubs[6]); 
  v3f(bubs[12]);  v3f(bubs[17]); 
  endpolygon();

  n3f(e3);
  bgnpolygon();
  v3f(bubs[12]);  v3f(bubs[13]);  v3f(bubs[14]);
  v3f(bubs[15]);  v3f(bubs[16]);  v3f(bubs[17]);
  endpolygon();
  lmbind(MATERIAL,4311);
  e3[0] *= -1.0;  e3[1] *= -1.0;  e3[2] *= -1.0;
  n3f(e3);
  bgnpolygon();
  v3f(bubs[0]);  v3f(bubs[1]);  v3f(bubs[2]);
  v3f(bubs[3]);  v3f(bubs[4]);  v3f(bubs[5]);
  endpolygon();  
  popmatrix(); 
}

make_bulbs()
{
  register int i;
  for(i = 0; i < 8; i++)
    {
      if( (light+i)->on)
	{
	  compute_bub(i);
	  make_a_bulb(i);
	  if(flag.coor_flag)
	    {
	      lmbind(MATERIAL,4311);
	      move(0.0,0.0,0.0);
	      draw(*((light+i)->token+5),*((light+i)->token+6),
		   *((light+i)->token+7));
	    }
	}
    }
}
/*************************************************************/
