/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/*******************************************************************
 *
 * initialize the light source; light model and material properties
 * from the definition array 'mat_properties'
 *
 *******************************************************************/

#include <gl.h>
#include <stdio.h>
#include "graph.h"
#include "constants.h"

extern int    *obj_style;
extern Obj    *obj;
extern Lmodel *lmodel;
extern Light  *light;
extern Flag   flag;
extern void   printerror();

/*******************************************************/

get_properties(fptr)
     float *fptr;
{
  float *ptr;
  int lo, lm, i, lnu;

  lo = -1; 
  lm = -1; 
  i = 0; 
  lnu = -1;
  ptr = fptr;
  if(ptr == NULL ) return;
  if(*ptr == BGNDEFINITION) ptr++;
  else printerror("WARNING: Bad lighting ... definition");
  
  while( *ptr != ENDDEFINITION) 
    {
      if( *ptr == ENDMATERIAL || *ptr == ENDLMODEL || *ptr == ENDLIGHT)
	ptr++;
      /*
       *  define lighting model
       */
      if( *ptr == BGNLMODEL)
	{
	  ptr++; i = 0;
	  while( *ptr != ENDLMODEL) 
	    {
	      i++;
	      if( *ptr == AMBIENT) 
		{
		  ptr++;
		  *(lmodel->token +1) = *ptr; ptr++;
		  *(lmodel->token +2) = *ptr; ptr++;
		  *(lmodel->token +3) = *ptr;  ptr++;
		}
	      if(*ptr == LOCALVIEWER) 
		{
		  ptr++;
		  *(lmodel->token +5) = *ptr;  ptr++;
		}
	      if( *ptr == ATTENUATION) 
		{
		  ptr++;
		  *(lmodel->token +7) = *ptr;  ptr++;
		  *(lmodel->token +8) = *ptr;  ptr++;
		}
	      if( *ptr == ATTENUATION2) 
		{
		  ptr++;
		  *(lmodel->token +10) = *ptr;  ptr++;
		}
	      if( *ptr == TWOSIDE) 
		{
		  ptr++;
		  *(lmodel->token +12) = *ptr;  ptr++;
		}
	      if(i > 6)
		{
		  printerror(" 'ENDLMODEL' missing ");
		  return; 
		}
	    }
	}
      /*
       *  define light source 
       */
      if(*ptr == BGNLIGHT)
	{
	  ptr++;   i = 0;  lnu = -1;
	  while(*ptr != ENDLIGHT) 
	    {
	      i++;
	      if(*ptr == NEWLIGHT) 
		{
		  ptr++; lnu++;
		}
	      if(lnu == -1)
		{
		  printerror("WARNING: 'NEWLIGHT' missing in deflight");
		  lnu = 0; 
		}
	      if(lnu == 8)
		{
		  printerror("ERROR: Too many light source definitions");
		  return;
		}	
	      if(i >= 80)
		{
		  printerror("ERROR: Bad light definitions ");
		  return;
		}
	      if(*ptr == ON)
		{
		  (light + lnu)->on = 1;
		  ptr++;
		}
	
	      if(*ptr == LCOLOR) 
		{
		  ptr++;
		  *((light + lnu)->token + 1) = *ptr;  ptr++;
		  *((light + lnu)->token + 2) = *ptr;  ptr++;
		  *((light + lnu)->token + 3) = *ptr;  ptr++;
		}
	      if(*ptr == POSITION) 
		{
		  ptr++;
		  *((light + lnu)->token + 5) = *ptr;  ptr++;
		  *((light + lnu)->token + 6) = *ptr;  ptr++;
		  *((light + lnu)->token + 7) = *ptr;  ptr++;
		  *((light + lnu)->token + 8) = *ptr;  ptr++;
		}
	      if(*ptr == AMBIENT) 
		{
		  ptr++;
		  *((light + lnu)->token + 10) = *ptr;  ptr++;
		  *((light + lnu)->token + 11) = *ptr;  ptr++;
		  *((light + lnu)->token + 12) = *ptr;  ptr++;
		}  
	      if(*ptr == SPOTDIRECTION) 
		{
		  ptr++;
		  *((light + lnu)->token + 14) = *ptr;  ptr++;
		  *((light + lnu)->token + 15) = *ptr;  ptr++;
		  *((light + lnu)->token + 16) = *ptr;  ptr++;
		}
	      if(*ptr == SPOTLIGHT) 
		{
		  ptr++;
		  *((light + lnu)->token + 18) = *ptr;  ptr++;
		  *((light + lnu)->token + 19) = *ptr;  ptr++;
		}
	    }
	}
    
      /*
       *  define materials 
       */
      if(*ptr == BGNMATERIAL) 
	{
	  ptr++;
	  while( *ptr != ENDMATERIAL) 
	    {
	      if(*ptr == NEWOBJECT) { ptr++; lo++; lm = -1;}
	      if( *ptr == NEWMATERIAL) { ptr++; lm++; }
	      if( lo == -1) 
		{
		  printerror("WARNING: 'NEWMATERIAL' mising in defmaterial");
		  lo = 0;
		}
	      if( lm == obj_style[lo+1])  
		{
		  printerror("WARNING: Bad material definition format");
		  lo++; lm = -1;
		}
	
	      if( lo == obj_style[0]) 
		{
		  printerror("ERROR: Too many material definitions."); return;
		}
	      if( lm == -1) 
		{
		  printerror("WARNING: Bad material definition format ");
		  lm = 0; 
		}
	      if( *ptr == DIFFUSE) 
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +9) = *ptr ;  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +10) = *ptr ; ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +11) = *ptr ; ptr++; 
		}
	      if(*ptr == EMISSION)
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +1) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +2) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +3) = *ptr ;
		  ptr++;
		}
	      if(*ptr == AMBIENT)
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +5) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +6) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +7) = *ptr ;
		  ptr++; 
		}
	      
	      if(*ptr == SPECULAR)
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +13) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +14) = *ptr ;
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +15) = *ptr ;
		  ptr++;
		}
	      if(*ptr == SHININESS) 
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm)->mater +17) = *ptr ;
		  ptr++;
		}
	      if(*ptr == ALPHA)
		{
		  ptr++;
		  *( ( (obj + lo)->mat + lm )->mater +19) = *ptr ;
		  ptr++;
		}
	    }
	}
    }
}
/*******************************************************/
