(*
$File: Compiler/PAT_BINDINGS.sml $
$Date: 1992/09/17 14:18:01 $
$Revision: 1.1 $
$Locker:  $
*)

(*$PAT_BINDINGS*)

signature PAT_BINDINGS =
  sig
    type lab
    type TypeInfo
    type var
    type lvar
    type pat
    type (''a, 'b) map
    type CEnv

    datatype BindingTree =
        TUPLEbtree of (lab, TypeInfo * lvar * BindingTree) map
      | CONbtree   of {child: BindingTree, childLvar: lvar}
      | EXCONbtree of {child: BindingTree, childLvar: lvar}
      | NILbtree

    val patBindings: (lvar * pat) -> (BindingTree * CEnv)

    type StringTree
    val layoutPatBindings: BindingTree * CEnv -> StringTree
  end;
