(* Unification of structures in Modules;
   matching of structures agains signatures.
   See the Definition, Sections 5.9 -- 5.12 *)

(*
$File: Common/MODULE_UNIFY.sml $
$Date: 1992/04/07 14:56:32 $
$Revision: 1.7 $
$Locker: birkedal $
*)

(*$MODULE_UNIFY*)

signature MODULE_UNIFY = 
sig
  type StrName and TyStr
  type NameSet
  type Assembly
  type Realisation
  type longstrid and longtycon

  type ErrorInfo
  datatype UnifyResult =
      OK of Realisation
    | ERROR of ErrorInfo

  val unifyStr: NameSet * Assembly * (StrName * longstrid) list -> UnifyResult
  and unifyTy : NameSet * Assembly * (TyStr   * longtycon) list -> UnifyResult
end;
