(* The environments  in the static semantics of Modules, Definition page 31. *)

(*
$File: Common/MODULE_ENVIRONMENTS.sml $
$Date: 1993/03/05 14:38:44 $
$Revision: 1.8 $
$Locker: birkedal $
*)

(*$MODULE_ENVIRONMENTS*)
signature MODULE_ENVIRONMENTS =
  sig
    (********
    Constructors
    ********)

    eqtype con

    (********
    TypeSchemes
    ********)

    type TypeScheme

    (********
    Constructor environments
    ********)

    type ConEnv
    val domCE    : ConEnv -> con list
    and emptyCE  : ConEnv
    and ClosCE   : ConEnv -> ConEnv
    and singleCE : con * TypeScheme -> ConEnv
    and CE_plus_CE : ConEnv * ConEnv -> ConEnv

    (********
    Identifiers
    ********)

    type id

    (********
    Variable environments
    ********)

    type VarEnv
    val emptyVE : VarEnv
    and singleVarVE  : id  * TypeScheme -> VarEnv
    and VE_plus_VE   : VarEnv  * VarEnv -> VarEnv
    and VEdom        : VarEnv -> id EqSet.Set
    and ClosVE       : VarEnv -> VarEnv
    and ClosCE_to_VE : ConEnv -> VarEnv

    (********
    Exception constructors
    ********)

    type excon

    (****
    Types
    ****)

    type Type

    (********
    Exception constructor environments
    ********)

    type ExConEnv
    val emptyEE    : ExConEnv
    and singleEE   : excon * Type -> ExConEnv
    and EEdom      : ExConEnv -> excon EqSet.Set
    and EE_plus_EE : ExConEnv * ExConEnv -> ExConEnv
    and VE_of_EE   : ExConEnv -> VarEnv

    (********
    Type functions
    ********)

    eqtype TypeFcn

    (********
    Type structures
    ********)

    type TyStr
    val mkTyStr : TypeFcn * ConEnv -> TyStr
    and unTyStr : TyStr -> TypeFcn * ConEnv

    (********
    Type constructors
    ********)

    type tycon

    (********
    Type environments
    ********)

    type TyEnv
    val emptyTE    : TyEnv
    and singleTE   : tycon * TyStr -> TyEnv
    and TE_plus_TE : TyEnv * TyEnv -> TyEnv
    and TEdom      : TyEnv -> tycon list

    (********
    Name sets
    ********)

    type NameSet
    val NameSetUnion : NameSet * NameSet -> NameSet
    and NameSetMinus : NameSet * NameSet -> NameSet

    (********
    Environments
    ********)

   (* In impTyVars{E,G,F}, we only need the tyvars to print them in error
      messages. *)

    eqtype TyVar
    structure TVResult:
      sig
	datatype T = IMP_OK
		   | FAULT of TyVar list
      end

    type Env
    val emptyE   : Env
    and E_plus_E : Env * Env -> Env
    and namesE   : Env -> NameSet
    and VE_in_E  : VarEnv -> Env
    and TE_in_E  : TyEnv -> Env
    and impTyVarsE  : Env -> TVResult.T
    and VE_and_EE_in_E : VarEnv * ExConEnv -> Env
    and VE_and_TE_in_E : VarEnv * TyEnv -> Env

    val bogus_Env: Env
    (********
    Structure identifiers
    ********)

    type strid

    (********
    Structures
    ********)

    type Str
    val bogus_Str: Str

    (********
    Structure environments
    ********)

    type StrEnv
    val emptySE    : StrEnv
    and singleSE   : strid * Str -> StrEnv
    and SE_plus_SE : StrEnv * StrEnv -> StrEnv
    and SEdom      : StrEnv -> strid list
    and SE_in_E    : StrEnv -> Env  

    (********
    Core level contexts
    ********)

    type Context
    val C_cplus_TE   : Context * TyEnv -> Context
    and Lookup_tycon : Context * tycon -> TyStr Option

    (********
    Realisations
    ********)

    type Realisation

    (********
    The static basis
    ********)

    type Basis  
    val emptyB    : Basis
    and initialB  : Basis
    and B_plus_E  : Basis * Env     -> Basis
    and B_cplus_E : Basis * Env     -> Basis
    and B_plus_N  : Basis * NameSet -> Basis
    and B_plus_B  : Basis * Basis   -> Basis
    and C_of_B    : Basis -> Context
    and N_of_B    : Basis -> NameSet
    and E_in_B    : NameSet * Env  -> Basis
    and onB       : Realisation * Basis -> Basis

    val bogus_Basis: Basis

    (********
    Signatures
    ********)

    type Sig

    (********
    Signature identifiers
    ********)

    type sigid

    (********
    Signature environments
    ********)

    type SigEnv 
    val emptyG   : SigEnv
    and singleG  : sigid  * Sig    -> SigEnv
    and G_plus_G : SigEnv * SigEnv -> SigEnv
    and B_plus_G : Basis  * SigEnv -> Basis
    and namesG   : SigEnv -> NameSet
    and G_in_B   : NameSet * SigEnv -> Basis
    and Gdom     : SigEnv -> sigid EqSet.Set
    and impTyVarsG : SigEnv -> TVResult.T

    (********
    Functor signatures
    ********)

    type FunSig

    (********
    Functor identifiers
    ********)

    type funid

    (********
    Functor environments
    ********)

    type FunEnv 
    val emptyF   : FunEnv
    and singleF  : funid  * FunSig -> FunEnv
    and F_plus_F : FunEnv * FunEnv -> FunEnv
    and B_plus_F : Basis  * FunEnv -> Basis
    and namesF   : FunEnv -> NameSet
    and Fdom     : FunEnv -> funid EqSet.Set
    and F_in_B   : NameSet * FunEnv -> Basis
    and impTyVarsF : FunEnv -> TVResult.T

    (********
    Qualified structure identifiers
    ********)

    type longstrid

    (********
    Qualified type constructors
    ********)

    type longtycon

    (********
    Lookup functions for the static basis
    ********)

    val lookup_lstrid : Basis * longstrid -> Str Option
    and lookup_ltycon : Basis * longtycon -> TyStr Option
    and lookup_sigid  : Basis * sigid     -> Sig Option
    and lookup_funid  : Basis * funid     -> FunSig Option

    (********
    Structure Names
    ********)

    type StrName

    (********
    Assemblies
    ********)

    type Assembly
    val mkAssembly    : Basis -> Assembly
    and singleA_Str   : Str   -> Assembly
    and singleA_TyStr : TyStr -> Assembly
    and onA    : Realisation * Assembly -> Assembly
    and union  : Assembly    * Assembly -> Assembly
    and emptyA : Assembly

    val bogus_Assembly: Assembly

    (********
    Check for a cyclic assembly
    ********)

    val cyclic : Assembly -> longstrid Option

    (********
    Find the structure offspring of a structure
    ********)

    type offspring_Str
    val Alookup_Str : Assembly * StrName -> offspring_Str
    and Aoffspring_Str_Fold : (((strid * StrName) * 'b) -> 'b) -> 'b -> offspring_Str -> 'b

    val bogus_OffspringStr: offspring_Str

    (********
    Find the type offspring of a structure
    ********)

    type offspring_Ty
    val Alookup_Ty : Assembly *  StrName -> offspring_Ty
    and Aoffspring_Ty_Fold : (((tycon * TyStr) * 'b) -> 'b) -> 'b -> offspring_Ty -> 'b

    val bogus_OffspringTy: offspring_Ty

    (********
    Lookup function for assemblies
    ********)

    val Alookup_TypeFcn : Assembly * TypeFcn -> TyStr

    (********
    Get an instance of a signature
    *********
    The assembly contains any new names which have been introduced
    ********)

    val Sig_instance : Sig -> Str * Assembly

    (********
    Result from the `covers' function
    ********)

    datatype Tail = TYCON of tycon | STRID of strid
    datatype CoverResult = OK | NOT_OK of strid list * Tail

    (********
    The `covers' function
    ********)

    val covers : NameSet * Assembly * Str -> CoverResult

    type StringTree
    val layoutBasis: Basis -> StringTree

   (* Needed for top-level printout: *)
    type Report
    val F_of_B: Basis -> FunEnv
    val G_of_B: Basis -> SigEnv
    val E_of_B: Basis -> Env
    val reportFunEnv: (funid * FunSig -> Report) * FunEnv -> Report
    val reportSigEnv: (sigid * Sig -> Report) * SigEnv -> Report
  end;
