#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Online (term)


************************************************************
*                                                          *
*   Subroutine Online_Help                                 *
*                                                          *
*      This subroutine displays a help menu to the user    *
*      from which instructions pertaining to the options   *  
*      offered in the main menu are available.  The 14     *
*      external help files are:                            *
*                                                          *
*        1  Overview              8  Tic Marks             *
*        2  Terminal Type         9  Labels                *
*        3  Data Input           10  Color                 *
*        4  Window               11  Shading               *
*        5  Plot Type            12  Debug                 *
*        6  Line Type            13  What have I done!?    *
*        7  Interpolation        14  Version 2 mods        *
*                                15  Quit help             *
*                                                          *
*      A call to Gethlp displays the file selected.        *
*      The user may quit this menu by entering option 15.  *
*      After quitting the help menu the user may choose    *
*      to enter a new terminal type.                       *
*                                                          *
************************************************************


        Integer term,option
        Character ans

        Character*40 trmset(6)
        Data         trmset/'Gigi (ReGIS graphics)',
     +                      'VT240 (ReGIS graphics)',
     +                      'VT240 (Tektronix emulation)',
     +                      'Tektronix 4014 (enhanced graphics)',
     +                      'Sun Workstation (w/ tektools)',
     +                      'IBM Personal Computer - color graphics'/

        option = 0
  100   IF (option.NE.15) THEN
    1     Call clear(term)
          Write (*,10)
   10     Format (/,15x,'Help!',
     +            //,5x,'Help is available in the following areas:',//
     +         ,10x,'1.  Overview',20x,'8.  Tic Marks?',//
     +         ,10x,'2.  Terminal Type?',14x,'9.  Labels?'//
     +         ,10x,'3.  Data Input?',16x,'10.  Color?',//
     +         ,10x,'4.  Window?',20x,'11.  Shading?',//
     +         ,10x,'5.  Plot Type?',17x,'12.  Debug?',//
     +         ,10x,'6.  Line Type?',17x,'13.  WHAT HAVE I DONE!?',//
     +         ,10x,'7.  Interpolation?',13x,'14.  Version 2 ',
     +         'modifications'//,30x,'15.  Quit Help'/)
          Write (*,20)
   20     Format (5x,'Enter option (1 - 15) ...')

*         (* Get the user's response *)
          Read (*,'(i2)',err=1) option

          IF (option.GE.1.AND.option.LE.14) CALL Gethlp(term,option)

*         (* Allow user to reset terminal if desired *)
          IF (option.EQ.2) THEN
    2       Call clear(term)
            Write (*,30) trmset(term)
   30       Format (//,5x,'Your current terminal setting is: '/,a40,//,
     +      5x,'Do you wish to change your terminal setting? (Y/N)')
            Read (*,'(a1)',err=2) ans
            IF (ans.EQ.'Y'.OR.ans.EQ.'y') THEN
              Call clear(term)
              Call Termcp(term)
            ENDIF
          ENDIF

          GOTO 100
        ENDIF

        RETURN
        END
