/*
 * VB Support Module
 *
 * This module is required to support a Visual Basic API into the
 * MSQL DLL.
 *
 * It is not part of the MSQL API.
 */
#include <windows.h>
#include <memory.h>
#include <string.h>
#include "msql.h"

#ifndef MIN
#define MIN(A,B) ((A) < (B) ? (A) : (B))
#endif

/*
 * Return the error text for an message
 *
 * Expects a pointer to a string of length 160
 */
int EXPORT 
VbsGetErrorText(char *s)
{
	memcpy(s, msqlErrMsg, 160);
	return(0); /* In VB void functions cannot return anything */
}

/*
 * To convert data from The 'C' linked list to a Basic string
 * use this function.
 *
 *	first perform a fetch.
 *	then get an m_row
 *	then call this function to copy the data from an mrow
 *		into a char array.
 *
 *	Returns the length copied into the buffer.
 *
 *	Should be using the lengths in the field information.
 * 
 */
int EXPORT
VbsMROW2Char(m_row m_row, char *pcDest, int iOffset, int iMaxLen)
{
	char *pcSrc;
	int iSrcLen;
	int iReturnLen;
	int iPad;
	
	iSrcLen = strlen(*m_row);
	if (iOffset > iSrcLen)
	{
		return(0);
	}
	pcSrc = (*m_row) + iOffset;
	iReturnLen = MIN(iMaxLen, iSrcLen - iOffset);
	strncpy(pcDest, pcSrc, iReturnLen);
	for (iPad = iReturnLen; iPad < iMaxLen; iPad++)
		pcDest[iPad] = '\0';			/* Pad out with spaces */
	return(iReturnLen);
}

/*
 * Convert the m_field structure to values which can be processed from visual
 * basic.
 *
 */
struct FieldData {
    char szFieldName[16];
    char szTableName[16];
    int iType;
    int iLength;
    int iFlags;
};

int EXPORT
VbsMFIELD2(m_field *pMField, struct FieldData *pFD)
{
	int iSrcLen, iPad;
	
	pFD->iType = pMField->type;
	pFD->iLength = pMField->length;
	pFD->iFlags = pMField->flags;
	
	iSrcLen = strlen(pMField->table);
	iSrcLen = MIN(16, iSrcLen);
	memcpy(pFD->szTableName, pMField->table, iSrcLen);
	for (iPad = iSrcLen; iPad < 16; iPad++)
		pFD->szTableName[iPad] = '\0';			/* Pad out with spaces */
	
	iSrcLen = strlen(pMField->name);
	iSrcLen = MIN(16, iSrcLen);
	memcpy(pFD->szFieldName, pMField->name, iSrcLen);
	for (iPad = iSrcLen; iPad < 16; iPad++)
		pFD->szFieldName[iPad] = '\0';			/* Pad out with spaces */
	return(0);
}

/*
 * Return the number of rows in a result. In 'C'
 * this is done as a macro.
 */
int EXPORT
VbsMsqlNumRows(m_result *pMResult)
{
	return(msqlNumRows(pMResult));
}
int EXPORT
VbsMsqlNumFields(m_result *pMResult)
{
	return(msqlNumFields(pMResult));
}

static void
strpad(char *pcDest, char *pcSrc, int iLen)
{
	/* Ensures that a string is copied and padded out with
	 * spaces to the desired length. 
	 */
	while (iLen--)
		if (*pcSrc)
			*pcDest++ = *pcSrc++;
		else
			*pcDest++ = ' ';
}

/*
 * This function copies the block of data from the row
 * pointer into a data buffer. The data area should have
 * a mask set up by VB to match the row. Types are not
 * the responsibilty of this function.
 */
int EXPORT
VbsMROW2Buffer(m_row m_row, m_result *pMResult, char *pcDest, int iMaxLen)
{
	/*
	 * Need to traverse the definitions of the fields,
	 */
	int iOff = 0;
	m_field *curField;
	
	pMResult->fieldCursor = pMResult->fieldData;
	while (iOff < msqlNumFields(pMResult))
	{
		curField = msqlFetchField(pMResult);
		switch (curField->type)
		{
		/*
		 * I am currently only dealing with char types.
		 */
		case CHAR_TYPE:
			if (m_row[iOff])
				strpad(pcDest, m_row[iOff], curField->length);
			else
				strpad(pcDest, "", curField->length);
			pcDest += curField->length;
		}
		iOff++;
	}
	return(0);
}

/*
 * This function copies a numbered field from the m_row data area
 * to a destination buffer. The field number is identified by the
 * field index.
 */
int EXPORT
VbsField2Buffer(m_row m_row, m_result *pMResult, char *pcDest, int iOffset, int iMaxLen)
{
	/*
	 * Need to traverse the definitions of the fields,
	 */
	int iOff = 0;
	m_field *curField;
	
	/*
	 * Rewind the field cursor to the first field
	 */
	pMResult->fieldCursor = pMResult->fieldData;
	while (iOff < msqlNumFields(pMResult))
	{
		curField = msqlFetchField(pMResult);
		if (iOff == iOffset) /* Found*/
		{
			switch (curField->type)
			{
			/*
			 * I am currently only dealing with char types.
			 */
			case CHAR_TYPE:
				if (m_row[iOff])
					strpad(pcDest, m_row[iOff], curField->length);
				else
					strpad(pcDest, "", curField->length);
				break;
			}
			break;
		}
		iOff++;
	}
	return(0);
}

