/* Klaus Thiele (kth@oblib.teuto.de) - June '95 */
/*
INTERFACE TO
  mSQL
REVISION HISTORY
  07/10/95 API release 1.00
DESCRIPTION
  This file contains structure definitions and defined constants used to
  interface with mSQL. For a more complete definition see "SQLBASE: C
  Programmer's Guide".
*/

#ifndef SQL
#define SQL

/* VERSION NUMBER */
#define   SQLVERS   60000               /* version number                   */
#define   SQLAPIV   00100               /* API version number               */

#define PTR *

typedef   unsigned char     ubyte1;
typedef   unsigned short    ubyte2;
typedef   unsigned long     ubyte4;
typedef   ubyte1            byte1;
typedef   short             byte2;
typedef   long              byte4;
typedef   unsigned char PTR ubyte1p;

#define SQLTAPI int

typedef   ubyte2    SQLTCUR;   /* cursor number                     */
typedef   byte2     SQLTRCD;   /* return codes                      */
typedef   ubyte2    SQLTDAL;   /* data length                       */
typedef   ubyte1p   SQLTDAP;   /* data pointer                      */
typedef   ubyte1p   SQLTBNP;   /* bind name pointer                 */
typedef   ubyte1    SQLTBNL;   /* bind name length                  */
typedef   ubyte1    SQLTBNN;   /* bind number                       */
typedef   ubyte1    SQLTSCA;   /* scale                             */
typedef   ubyte1    SQLTSLC;   /* select list column                */
typedef   ubyte1    SQLTPDL;   /* program data length               */
typedef   ubyte1    SQLTPDT;   /* program data type                 */
typedef   ubyte1    SQLTCDL;   /* column data length                */
typedef   ubyte1    SQLTFSC;   /* fetch status code                 */
typedef   ubyte2    SQLTEPO;   /* error position                    */
typedef   ubyte1    SQLTNSI;   /* number of select items            */
typedef   ubyte1    SQLTNBV;   /* number of bind variables          */
typedef   byte4     SQLTROW;   /* number of rows                    */
typedef   ubyte1    SQLTDDL;   /* database data length              */
typedef   ubyte1    SQLTDDT;   /* database data type                */
typedef   ubyte1p   SQLTCHP;   /* column header pointer             */
typedef   ubyte1    SQLTCTY;   /* command type                      */
typedef   ubyte1    SQLTCHL;   /* column header length              */
typedef   ubyte1    SQLTPRE;   /* precision                         */
typedef   ubyte1    SQLTRBF;   /* roll back flag                    */
typedef   ubyte4    SQLTDPV;   /* database parameter value          */
typedef   ubyte1p   SQLTILV;   /* isolation level string            */
typedef   byte4     SQLTXER;   /* extended error #                  */
typedef   ubyte1    SQLTNML;   /* number length                     */
typedef   ubyte2    SQLTPTY;   /* set/get parameter type            */
typedef   ubyte1p   SQLTNMP;   /* number pointer                    */

/* FETCH RETURN CODES */
#define   FETRTRU   1                   /* data truncated                   */
#define   FETRSIN   2                   /* signed number fetched            */
#define   FETRDNN   3                   /* data is not numeric              */
#define   FETRNOF   4                   /* numeric overflow                 */
#define   FETRDTN   5                   /* data type not supported          */
#define   FETRDND   6                   /* data is not in date format       */
#define   FETRNUL   7                   /* data is null                     */

/* DATABASE DATA TYPES */
#define   SQLDCHR   1                   /* character data type              */
#define   SQLDNUM   2                   /* numeric data type                */
#define   SQLDDAT   3                   /* date-time data type              */
#define   SQLDLON   4                   /* long data type                   */
#define   SQLDDTE   5                   /* date (only) data type            */
#define   SQLDTIM   6                   /* time (only) data type            */

/* PROGRAM DATA TYPES */
#define   SQLPBUF   1                   /* buffer                           */
#define   SQLPSTR   2                   /* string (zero terminated)         */
#define   SQLPUCH   3                   /* unsigned char                    */
#define   SQLPSCH   4                   /* char                             */
#define   SQLPUIN   5                   /* unsigned int                     */
#define   SQLPSIN   6                   /* int                              */
#define   SQLPULO   7                   /* unsigned long                    */
#define   SQLPSLO   8                   /* long                             */
#define   SQLPFLT   9                   /* float                            */
#define   SQLPDOU   10                  /* double                           */
#define   SQLPDAT   11                  /* datetime format                  */
#define   SQLPTIM   12                  /* time only format                 */

/* EXTERNAL DATA TYPES */
#define   SQLEINT   1                   /* INTEGER                          */
#define   SQLECHR   2                   /* CHAR                             */
#define   SQLEDOU   3                   /* DOUBLE (mSQL - REAL)             */

/* NULL POINTER */
#define   SQLNPTR   (ubyte1 PTR)0       /* null pointer                     */

/* RESULT COMMAND TYPES */
#define   SQLTSEL   1                   /* select                           */
#define   SQLTINS   2                   /* insert                           */
#define   SQLTCTB   3                   /* create table                     */
#define   SQLTUPD   4                   /* update                           */
#define   SQLTDEL   5                   /* delete                           */
#define   SQLTDTB   8                   /* drop table                       */

/* MAXIMUM SIZES */
#define   SQLMERR   255                 /* error message length             */

/* defines for SQLETX() and SQLTEM(): error text type parameters            */
#define   SQLXMSG   1                   /* retrieve error message text      */

/* SIZES */
#define   SQLSNUM   12                  /* numeric program buffer size      */
#define   SQLSDAT   SQLSNUM             /* date-time program buffer size    */

/* SET and GET PARAMETER TYPES */
/*      Global parameters */
#define   SQLPNIE   9                   /* null indicator error             */

/*      Server specific parameters */
#define   SQLPBRN   1003                /* brand of database                */

/* defines for database brands */
#define   SQLBSQB    1                  /* SQLBASE                          */
#define   SQLBORA    4                  /* Oracle                           */
#define   SQLBIGW    5                  /* Informix                         */
#define   SQLBSYB    8                  /* Sybase SQL Server                */
#define   SQLBING   15                  /* Ingres                           */
#define   SQLBSUP   20                  /* Cincom SUPRA                     */
#define   SQLBOR7   28                  /* Oracle version 7                 */
#define   SQLBODB   31                  /* ODBC Router                      */
#define   SQLBMSQ   98                  /* mSQL                             */

/* Cursor specific parameters */
#define   SQLPPCX   3003                /* preserve context (0 or 1)        */
#define   SQLPFRS   3004                /* front end result sets            */
#define   SQLPCMP   3019                /* Compress messages sent to server */
#define   SQLPOPL   3021                /* optimizer level                  */

/* SQL FUNCTION PROTOTYPES */
SQLTAPI sqlbnd(SQLTCUR cur, SQLTBNP bnp, SQLTBNL bnl,          /* bind data by name     */
               SQLTDAP dap, SQLTDAL dal, SQLTSCA sca,
               SQLTPDT pdt);
SQLTAPI sqlbnn(SQLTCUR cur, SQLTBNN bnn, SQLTDAP dap,          /* bind data by number   */
               SQLTDAL dal, SQLTSCA sca, SQLTPDT pdt);
SQLTAPI sqlcbv(SQLTCUR cur);                                   /* clear bind variables  */
SQLTAPI sqlcex(SQLTCUR cur, SQLTDAP dap, SQLTDAL dal);         /* compile and execute   */
SQLTAPI sqlcmt(SQLTCUR cur);                                   /* CoMmiT     */
SQLTAPI sqlcnc(SQLTCUR *curp, SQLTDAP dbnamp, SQLTDAL dbnaml, SQLTDAP host); /* connect */
SQLTAPI sqlcnr(SQLTCUR *curp, SQLTDAP dbnamp, SQLTDAL dbnaml, SQLTDAP host); /* connect... */
SQLTAPI sqlcom(SQLTCUR cur, SQLTDAP cmdp, SQLTDAL cmdl);       /* compile    */
SQLTAPI sqlcrs(SQLTCUR cur, SQLTDAP rsp, SQLTDAL rsl );        /* close result/restrict set mode */
SQLTAPI sqlcty(SQLTCUR cur, SQLTCTY PTR cty);                  /* command type */
SQLTAPI sqldbn(SQLTDAP serverid, SQLTDAP buffer, SQLTDAL length); /* DataBase Names */
SQLTAPI sqldbt(SQLTCUR cur, SQLTDAP buffer, SQLTDAL length);      /* DataBase Tables */
SQLTAPI sqldes(SQLTCUR cur, SQLTSLC slc, SQLTDDT PTR ddt,      /* DEScribe item in a SELECT */
               SQLTDDL PTR ddl, SQLTCHP chp, SQLTCHL PTR chlp,
               SQLTPRE PTR prep, SQLTSCA PTR scap);
SQLTAPI sqldis(SQLTCUR cur);                                   /* disconnect */
SQLTAPI sqldon( );                                             /* DONe       */
SQLTAPI sqldsc(SQLTCUR cur, SQLTSLC slc, SQLTDDT PTR edt,      /* DeSCribe item in a SELECT */
               SQLTDDL PTR edl, SQLTCHP chp, SQLTCHL PTR chlp,
               SQLTPRE PTR prep, SQLTSCA PTR scap );
SQLTAPI sqlepo(SQLTCUR cur, SQLTEPO PTR epo);                  /* errorposition */
SQLTAPI sqlerr(SQLTRCD error, SQLTDAP msg);                    /* error         */
SQLTAPI sqlexe(SQLTCUR cur);                                   /* execute       */
SQLTAPI sqlfet(SQLTCUR cur);                                   /* fetch         */
SQLTAPI sqlget(SQLTCUR cur, SQLTPTY parm, SQLTDAP p, SQLTDAL PTR l); /* GET parameter     */
SQLTAPI sqlnsi(SQLTCUR cur, SQLTNSI PTR nsi);                  /* get # of select items   */
SQLTAPI sqlnbv(SQLTCUR cur, SQLTNBV PTR nbv);                  /* get # of bind variables */
SQLTAPI sqlnrr(SQLTCUR cur, SQLTROW PTR rcountp);              /* get # of rows           */
SQLTAPI sqlprs(SQLTCUR cur, SQLTROW row);                      /* position in result set  */
SQLTAPI sqlrcd(SQLTCUR cur, SQLTRCD PTR rcd);                  /* returncode     */
SQLTAPI sqlrbf(SQLTCUR cur, SQLTRBF PTR rbf);                  /* Roll Back Flag */
SQLTAPI sqlrbk(SQLTCUR cur);                                   /* RollBacK       */
SQLTAPI sqlrow(SQLTCUR cur, SQLTROW PTR row);                  /* number of ROWs */
SQLTAPI sqlset(SQLTCUR cur, SQLTPTY parm, SQLTDAP p, SQLTDAL l);   /* SET parameter */
SQLTAPI sqlssb(SQLTCUR cur, SQLTSLC slc, SQLTPDT pdt, SQLTDAP pbp, /* set buffer    */
               SQLTPDL pdl, SQLTSCA sca, SQLTCDL PTR pcv,
               SQLTFSC PTR pfc);
SQLTAPI sqlsil(SQLTCUR cur, SQLTILV isolation);                      /* Set Isolation Level */
SQLTAPI sqlspr(SQLTCUR cur);                                         /* stop restriction mode            */
SQLTAPI sqlsrs(SQLTCUR cur);                                         /* start result/restrict set mode   */
SQLTAPI sqltem(SQLTCUR cur, SQLTXER PTR xer, SQLTPTY msgtyp,         /* tokenize error message           */
               SQLTDAP bfp, SQLTDAL bfl, SQLTDAL PTR txtlen);
SQLTAPI sqlxpd(SQLTNMP op, SQLTNML PTR olp, SQLTDAP ip,              /* eXtended convert Picture to Date */
               SQLTDAP pp, SQLTDAL pl);
SQLTAPI sqlxdp(SQLTDAP op, SQLTDAL ol, SQLTNMP ip, SQLTNML il,       /* eXtended convert Date to Picture */
               SQLTDAP pp, SQLTDAL pl);

#endif
