/*
** example2.c
** 
**
** Klaus Thiele (kth@oblib.teuto.de) - June '95
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sql.h>
#include <errsql.h>

int failure( SQLTCUR csr, char *msg );

int main( void ) {

SQLTCUR   csr;        /* the Cursor                          */
SQLTDAP   stmt;       /* SQL Statement                       */
SQLTRCD   rcd;        /* returncode                          */

SQLTNSI   nsi;
SQLTDDT   ddt;
SQLTDDL   ddl;

int       i;

char      nr[5];
char      name[46];
int       age;
double    money;
char      flag;

char      errmsg[SQLMERR];

   /* connect cursor to local database */
   if( rcd = sqlcnc(&csr, "SQLBASE/SYSADM/SYSADM", 0, NULL) ) {
         sqlerr( rcd, errmsg );
         printf("CONNECT failed.\n%s\n", errmsg);
         return( 1 );
   } else
      printf("Connection Established\n");


   /* setup statement */
   stmt = "SELECT NAME, NR, FLAG, AGE, MONEY FROM PERSDAT "
                 "WHERE NAME LIKE :bname "
                 "ORDER BY AGE DESC";

   /* compile statement */
   if( sqlcom(csr, stmt, 0) )
      failure(csr, "COMPILE");

   /* get # of select items */
   if( sqlnsi(csr, &nsi) )
      failure(csr, "SQLNSI");

   /* describe the select items */
   for( i = 1; i <= nsi; i++ ) {

      if( sqldsc(csr, i, &ddt, &ddl, 0, SQLNPTR, SQLNPTR, SQLNPTR) )
      failure(csr, "SQLDSC");

      printf("Item %d: typ %d, length %d\n", i, ddt, ddl);
   }

   /* set bind variable */
   if( sqlbnd(csr, "bname", 0, name, 0, 0, SQLPSTR) )
      failure(csr, "BIND");

   /* set select buffer */
   if( sqlssb(csr, 1, SQLPSTR, name, sizeof(name), 0, SQLNPTR, SQLNPTR) ||
       sqlssb(csr, 2, SQLPSTR, nr,   sizeof(nr), 0, SQLNPTR, SQLNPTR) ||
       sqlssb(csr, 3, SQLPSCH, (SQLTDAP)&flag, sizeof(flag), 0, SQLNPTR, SQLNPTR) ||
       sqlssb(csr, 4, SQLPSIN, (SQLTDAP)&age, sizeof(age), 0, SQLNPTR, SQLNPTR) ||
       sqlssb(csr, 5, SQLPDOU, (SQLTDAP)&money, sizeof(money), 0, SQLNPTR, SQLNPTR) )
      failure( csr, "SET BUFFER" );

   /* initialize the bind-variable */
   strcpy( name, "%Thiele%" );

   /* execute the statement */
   if( sqlexe(csr) )
      failure(csr, "EXECUTE");

   /* fetch rows */
   while( sqlfet(csr) == 0 )
      printf("sqlfet: %s - %s, %d, %.2f, %c\n", nr, name, age, money, flag);


   /* rollback and disconnect all cursors ... */
   sqldon();


   /* ok, now we get an error because the cursor was 
      already disconnected by sqldone() 
   */
   if( rcd = sqldis(csr) ) {
      sqlerr(rcd, errmsg);
      printf("DISCONNECT failed\n%s\n", errmsg);
   } else
      printf("Disconnect performed\n");

   return(0);
}

int failure( SQLTCUR csr, char *msg ) {

SQLTRCD rcd;
char    errmsg[SQLMERR];

   sqlrcd(csr, &rcd);
   sqlerr(rcd, errmsg);
   printf("Failure on %s\n", msg);
   printf("[%d]: %s\n", rcd, errmsg);
   sqldis(csr);

   exit( 1 );
}
