#include <stdio.h>
#include "sql.h"

/*----------------------------------------------------------------*/
/*  Example of compiling an SQL statement and then executing it.  */
/*----------------------------------------------------------------*/

int main( void ) {

SQLTCUR cur;		/* SQLBASE cursor number  */
SQLTRCD rcd;		/* return code		  */

static char cmd_create[] =	/* CREATE TABLE command   */
  "CREATE TABLE EMP (EMP_NAME CHAR(20), EMP_NO INTEGER, EMP_DOB REAL)";

  /*
  ** CONNECT TO THE DATABASE
  */
  if (rcd = sqlcnc(&cur, "SQLBASE", 0, NULL)) {
    printf("FAILURE ON CONNECT %d\n",rcd);
    exit(1);
  }

  /*
  ** COMPILE CREATE TABLE SQL STATEMENT
  */
  if (rcd = sqlcom(cur, cmd_create, 0)) {
    printf("FAILURE ON COMPILE, rcd = %d\n",rcd);
    sqldis(cur);
    exit(1);
  }

  /*
  ** EXECUTE CREATE TABLE SQL STATEMENT
  */
  if (rcd = sqlexe(cur))
    printf("CANNOT CREATE TABLE, rcd = %d\n",rcd);
  else
    printf("TABLE SUCCESSFULLY CREATED \n");

  /*
  ** DISCONNECT FROM THE DATABASE
  */
  if (rcd = sqldis(cur))
    printf("FAILURE ON DISCONNECT %d\n",rcd);

  return( 0 );
}
