// Header zwindef.h to define some global types
// and include files for cross platform compatibilty
#ifndef __ZWINDEF_H
#define __ZWINDEF_H

#pragma cplusplus on

//Cross platform typedefs and defines
typedef int ZFont;

#define APPLICATION_QUIT 0xFFFFFFFF
#define NIL				0L
#define CR				0x0D
#define LF				0x0A
#define MAX_WINDOW_LINES 100
#define MAX_WINDOW_LINE_LEN 100
#define MAX_EVENTS 200


typedef struct { 
	private:
		int X;
		int Y;
		unsigned H;
		unsigned W;
	public:
	ZRect(int x=0,int y=0,unsigned w=0,unsigned h=0){SetX(x);SetY(y);SetH(h);SetW(w);return 0;}
	void SetAll(int x,int y,unsigned w,unsigned h){SetX(x);SetY(y);SetH(h);SetW(w);}
	void SetX(int x){X=x;}
	void SetY(int y){Y=y;}
	void SetH(unsigned h){H=h;}
	void SetW(unsigned w){W=w;}
	int GetX(){return X;}
	int GetY(){return Y;}
	unsigned GetW(){return W;}
	unsigned GetH(){return H;}
	} ZRect;


/*
******************************
Macintosh Operating System 7.0
******************************

Definitions, typedefs, structs, etc for a MacOS 7.0 compatitble compilation
*/
#ifdef PLATFORM_MAC
	#ifdef PLATFORM_X11
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_X11
	#ifdef PLATFORM_MSWINDOWS
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_MSWINDOWS
	#include <Types.h>
	#include <QuickDraw.h>
	#include <Windows.h>
	#include <Fonts.h>
	#include <Controls.h>
	#include <Dialogs.h>
	#include <Menus.h>
	#include <Devices.h>
	#include <Memory.h>
	#include <Events.h>
	#include <Desk.h>
	#include <OSEvents.h>
	#include <OSUtils.h>
	#include <ToolUtils.h>
	#include <TextUtils.h>
	#include <StandardFile.h>
	#include <Errors.h>
	#include <Resources.h>
	#include <DiskInit.h>

	#define EOL CR
	#define FALSE			false
	#define TRUE			true
	#define LAST_MENU		3		/* Number of menus */
	#define APPLE_MENU		128		/* Menu ID for Apple menu */
	#define FILE_MENU		129		/* Menu ID for File menu */
	#define EDIT_MENU		130		/* Menu ID for Edit menu */
	#define RESOURCE_ID		127		/* Starting index into the menu array */
	#define ABOUT_BOX_ID	128		/* Resource IDs for our windows & dialogs */
	#define INIT_X			112		/* Coords for disk init dialog box */
	#define INIT_Y			80
	#define APPEND_MENU		0
	#define CHAR_CODE_MASK	255
	#define IN_FRONT		-1
	#define NO_CURSOR		0L
	#define ONE_FILE_TYPE	1
	#define LONG_NAP		60L

	typedef CursHandle TZCursor;
	typedef WindowPtr TZWindow;
	typedef Boolean BOOL;
	typedef OSErr ZError;
	typedef unsigned long DWORD;

#endif //PLATFORM_MAC







/*
**********************************
MS Windows 3.1 (Operating System)?
**********************************

Definitions, typedefs, structs, etc for a MS Windows 3.1 compatitble compilation
*/

#ifdef PLATFORM_MSWINDOWS
	#ifdef PLATFORM_X11
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_X11
	#ifdef PLATFORM_MAC
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_MAC
	#include <windows.h>
	typedef DWORD ZError;
	typedef HWND TZWindow;
	typedef HCURSOR TZCursor;
	typedef DWORD TZError;
	typedef COLORREF ZColor;

	#define TRUE 1
	#define FALSE 0
	#define EOL CRLF
#endif //PLATFORM_MSWINDOWS





/*
**************************
X11 R6 Interface
**************************

Definitions, typedefs, structs, etc for a X11 R6 compatitble compilation
*/
#ifdef PLATFORM_X11
	#ifdef PLATFORM_MSWINDOWS
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_MSWINDOWS
	#ifdef PLATFORM_MAC
		#pragma error Can not compile for more than one platform simulatneously
	#endif //PLATFORM_MAC
	#include <X11/Xlib.h>
	#include <X11/Xutil.h>
	
	typedef int BOOL;
	typedef int ZError;
	typedef unsigned long DWORD;
	typedef Window TZWindow;
	typedef DWORD TZCursor;

	#define TRUE 1
	#define FALSE 0
	#define EOL LF
 #endif //PLATFORM_X11

#endif // __ZWINDEF_H