head	1.4;
access;
symbols;
locks
	PTI:1.4; strict;
comment	@ * @;


1.4
date	96.08.04.11.57.57;	author PTI;	state Exp;
branches;
next	1.3;

1.3
date	96.08.01.23.36.43;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.07.24.22.12.28;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.46.32;	author PTI;	state Exp;
branches;
next	;


desc
@Dump databases so they can be restored.
@


1.4
log
@removed #define conflict for WATCOM
@
text
@/*
**      msqldump.c  - Dump a tables contents and format to an ASCII file
**
**
** Original version written by Igor Romanenko (igor@@frog.kiev.ua) under
** the name of msqlsave.c and placed in the public domain.  This program
** remains in the public domain to continue the spirit of its original
** author although the modifications made to the original program are :-
**
**                   Copyright (c) 1994  David J. Hughes
**
**
** This software is provided "as is" without any expressed or implied warranty.
**
** The author's original notes follow :-
**
**              ******************************************************
**              *                                                    *
**              * MSQLSAVE.C -- saves the contents of an mSQL table  *
**              *               in .msql format.                     *
**              *                                                    *
**              * AUTHOR: Igor Romanenko (igor@@frog.kiev.ua)         *
**              * DATE:   December 3, 1994                           *
**              * WARRANTY: None, expressed, impressed, implied      *
**              *           or other                                 *
**              * STATUS: Public domain                              *
**              *                                                    *
**              ******************************************************
*/

#include <stdio.h>
#ifdef WINSOCK
#  include <winsock.h>
#  undef APIENTRY
#  define APIENTRY
#endif
#include <common/portable.h>
#include "msql.h"


/* Exit codes */

#define EX_USAGE 1
#define EX_MSQLERR 2
#define EX_CONSCHECK 3

char    usage[] = "\n\n\
usage:  %s [-h host] [-vtdc] database [table]\n\n\
        Produce an ASCII dump of a database table or an entire database\n\n\
        -h      Use mSQL server on remote host\n\
        -v      Verbose mode\n\
        -t      Do not produce the table creation information\n\
        -d      Do not produce the data insertion information\n\
        -c      Complete INSERT statements (including field names)\n\
\n";

int     verbose = 0,
        tFlag = 0,
        cFlag = 0,
        dFlag = 0;
int     sock = -1;
char    insert_pat[5 * 1024];



/*
** DBerror -- prints mSQL error message and exits the program.
*/

void DBerror()
{
#ifndef UNIX
                /*
                 * OS2 & WINNT
                 */
        fprintf(stderr, "mSQL error: %s\n", msqlGetErrMsg(NULL));
#else
                /*
                 * UNIX
                 */
        fprintf(stderr, "mSQL error: %s\n", msqlErrMsg);
#endif
        if ( sock != -1 )
                msqlClose(sock);
                  exit(EX_MSQLERR);
}


char *escapeText(str)
        char    *str;
{
        register char   *cp,
                        *cp2,
                        *tmp;
        int     numQuotes;

        cp = str;
        numQuotes = 0;
                  while((cp = (char *)index(cp,'\'')))
        {
                numQuotes++;
                cp++;
        }
        cp = str;
                  while((cp = (char *)index(cp,'\\')))
        {
                numQuotes++;
                cp++;
        }

        if (numQuotes)
        {
                                         tmp = (char *)malloc(strlen(str)+numQuotes+1);
                cp2 = tmp;
                cp = str;
                while(*cp)
                {
                        if (*cp == '\'' || *cp == '\\')
                                *cp2++='\\';
                        *cp2++ = *cp++;
                }
                *cp2 = '\0';
                return(tmp);
        }
        else
        {
                return((char *)strdup(str));
        }
}


/*
** dbConnect -- connects to the host and selects DB.
**            Also checks whether the tablename is a valid table name.
*/

void dbConnect(host,database)
        char    *host,
                *database;
{
        if (verbose)
        {
                fprintf(stderr, "Connecting to %s...\n",
                        host ? host : MSQL_LOCALHOST);
        }
        sock = msqlConnect(host);
        if ( sock == -1 )
                DBerror();
        if ( verbose )
                fprintf(stderr, "Selecting data base %s...\n", database);
        if ( msqlSelectDB(sock, database) == -1 )
                DBerror();
}



/*
** dbDisconnect -- disconnects from the host.
*/

void dbDisconnect(host)
        char    *host;
{
        if (verbose)
        {
                fprintf(stderr, "Disconnecting from %s...\n",
                        host ? host : MSQL_LOCALHOST);
        }
        msqlClose(sock);
}



/*
** getStructure -- retrievs database structure, prints out corresponding
**                 CREATE statement and fills out insert_pat.
*/

int getTableStructure(table)
        char    *table;
{
        m_field         *mf;
        m_result        *tableRes;
        int             init = 1,
                        numFields;

        if (verbose)
        {
                fprintf(stderr, "Retrieving table structure for table %s...\n",
                        table);
        }
        if (!(tableRes = msqlListFields(sock, table)))
        {
                fprintf(stderr, "mSQL error: No such table - %s\n", table);
                                         exit(EX_MSQLERR);
        }

        if (!tFlag)
        {
                printf("\n#\n# Table structure for table '%s'\n#\n",table);
                printf("CREATE TABLE %s (\n", table);
        }

        if (cFlag)
                sprintf(insert_pat, "INSERT INTO %s (", table);
        else
                sprintf(insert_pat, "INSERT INTO %s VALUES (", table);

        while(mf=msqlFetchField(tableRes))
        {
                if (init)
                {
                        init = 0;
                }
                else
                {
                        if (!tFlag)
                                printf(",\n");
                        if (cFlag)
                                strcat(insert_pat,", ");
                }
                if (cFlag)
                        strcat(insert_pat,mf->name);
                if (!tFlag)
                {
                        printf("  %s ", mf->name);
                        switch(mf->type)
                        {
                                case INT_TYPE:
                                        printf("INT");
                                        break;
                                case CHAR_TYPE:
                                        printf("CHAR(%d)", mf->length);
                                        break;
                                case REAL_TYPE:
                                        printf("REAL");
                                        break;
                                default:
                                        fprintf(stderr,
                                                "Unknown field type: %d\n",
                                                mf->type);
                                        exit(EX_CONSCHECK);
                        }

                        if(IS_NOT_NULL(mf->flags) )
                                printf(" NOT NULL");
                        if(IS_PRI_KEY(mf->flags) )
                                printf(" PRIMARY KEY");
                }
        }
        if (!tFlag)
                printf("\n) \\g\n\n");
        if (cFlag)
                strcat(insert_pat,") VALUES (");
        numFields = msqlNumFields(tableRes);
        msqlFreeResult(tableRes);
        return(numFields);
}




/*
** dumpTable saves database contents as a series of INSERT statements.
*/

void dumpTable(numFields,table)
        int     numFields;
        char    *table;
{
        char            query[48],
                        *tmp;
        m_result        *res;
        m_field         *field;
        m_row           row;
        int             i;
        int             init = 1;

        if (verbose)
                fprintf(stderr, "Sending SELECT query...\n");
        printf("\n#\n# Dumping data for table '%s'\n#\n\n",table);
        sprintf(query, "SELECT * FROM %s", table);
        if (msqlQuery(sock, query) == -1)
                                         DBerror();
        if (!(res=msqlStoreResult()))
                DBerror();
        if (verbose)
        {
                fprintf(stderr, "Retrieved %d rows. Processing...\n",
                        msqlNumRows(res) );
        }
        if (msqlNumFields(res) != numFields)
        {
                fprintf(stderr,"Error in field count!  Aborting.\n\n");
                exit(EX_CONSCHECK);
        }

                  while (row=msqlFetchRow(res))
        {
                printf("%s", insert_pat);
                init = 1;
                msqlFieldSeek(res,0);
                for (i = 0; i < msqlNumFields(res); i++)
                {
                                                                if (!(field = msqlFetchField(res)))
                        {
                                fprintf(stderr,"Not enough fields! Aborting\n");
                                exit(EX_CONSCHECK);
                        }
                        if (!init )
                                printf(",");
                        else
                                init=0;
                        if (row[i])
                        {
                                if (field->type == CHAR_TYPE)
                                {
                                        tmp = escapeText(row[i]);
                                        printf("\'%s\'", tmp);
                                        free(tmp);
                                }
                                else
                                {
                                        printf("%s", row[i]);
                                }
                        }
                        else
                        {
                                printf("NULL");
                        }
                }
                printf(")\\g\n");
        }
}



char *getTableName()
{
        static m_result *res = NULL;
        m_row           row;

        if (!res)
        {
                res = msqlListTables(sock);
                if (!res)
                        return(NULL);
        }
        row = msqlFetchRow(res);
        if (row)
        {
                return((char *)row[0]);
        }
        else
        {
                                         msqlFreeResult(res);
                return(NULL);
        }
}




main(argc, argv)
        int     argc;
        char    *argv[];
{
        int     c,
                                         numRows,
                                         errFlag = 0;
                  char    *host = NULL,
                                         *database = NULL,
                                         *table = NULL;
#ifndef UNIX
                                         /*
                 * OS2 & WINNT
                 */
        int optind     = 1;

        while( argc > optind && '-' == argv[optind][0] )
        {
                                         switch( argv[optind][1] )
                {
                        case 'h':
                                if ( host || argc <= optind )
                                        errFlag++;
                                                                                  else
                                        host = argv[++optind];
                                break;

                        case 'v':
                                if (verbose)
                                        errFlag++;
                                else
                                                                                                         verbose++;
                                break;

                        case 't':
                                if (tFlag)
                                                                                                         errFlag++;
                                else
                                        tFlag++;
                                break;

                        case 'c':
                                if (cFlag)
                                        errFlag++;
                                                                                  else
                                        cFlag++;
                                break;

                        case 'd':
                                                                                  if (dFlag)
                                        errFlag++;
                                else
                                        dFlag++;
                                break;

                        case '?':
                        default:
                                                                                  errFlag++;
                }
                optind++;
        }

                  printf("\n");
        if ( argc <= optind )
        {
                errFlag++;
        }
#else
                /*
                 * UNIX
                                          */
        extern  char *optarg;
                  extern  int optind;

        /*
                  ** Check out the args
        */
        while((c=getopt(argc,argv,"h:vtcd"))!= -1)
        {
                switch(c)
                {
                        case 'h':
                                if (host)
                                                                                                         errFlag++;
                                else
                                        host = optarg;
                                                                                  break;

                                                                case 'v':
                                if (verbose)
                                        errFlag++;
                                else
                                        verbose++;
                                break;

                        case 't':
                                                                                  if (tFlag)
                                        errFlag++;
                                else
                                                                                                         tFlag++;
                                break;

                        case 'c':
                                if (cFlag)
                                        errFlag++;
                                else
                                        cFlag++;
                                break;

                        case 'd':
                                if (dFlag)
                                        errFlag++;
                                                                                  else
                                        dFlag++;
                                                                                  break;

                        case '?':
                                errFlag++;
                }
        }
#endif
        if (errFlag)
        {
                fprintf(stderr,usage, argv[0]);
                exit(EX_USAGE);
                  }

                  if (optind < argc)
                database = argv[optind++];
        if (optind < argc)
                table = argv[optind++];

        if (!database)
        {
                fprintf(stderr,usage, argv[0]);
                exit(EX_USAGE);
        }

                  /*
        ** If we don't have a hostname have a look at MSQL_HOST
                  */
        if (!host)
        {
                host = (char *)getenv("MSQL_HOST");
        }

        printf("#\n# mSQL Dump  (requires mSQL-1.0.6 or better)\n#\n");
        printf("# Host: %s    Database: %s\n",
            host ? host : MSQL_LOCALHOST, database);
        printf("#--------------------------------------------------------\n\n");

                  dbConnect(host,database);
        if (table)
        {
                                         numRows = getTableStructure(table);
                if (!dFlag)
                        dumpTable(numRows,table);
                  }
        else
                  {
                while((table = getTableName()))
                {
                        numRows = getTableStructure(table);
                        if (!dFlag)
                                dumpTable(numRows,table);
                }
        }
                  dbDisconnect(host);
                  printf("\n");
                  exit(0);
}


@


1.3
log
@Removed references to WSAStartUp and WSACleanUp.
@
text
@d34 1
d85 1
a85 1
		  exit(EX_MSQLERR);
d99 1
a99 1
		  while((cp = (char *)index(cp,'\'')))
d105 1
a105 1
		  while((cp = (char *)index(cp,'\\')))
d113 1
a113 1
					 tmp = (char *)malloc(strlen(str)+numQuotes+1);
d195 1
a195 1
					 exit(EX_MSQLERR);
d284 1
a284 1
					 DBerror();
d298 1
a298 1
		  while (row=msqlFetchRow(res))
d305 1
a305 1
								if (!(field = msqlFetchField(res)))
d356 1
a356 1
					 msqlFreeResult(res);
d369 5
a373 5
					 numRows,
					 errFlag = 0;
		  char    *host = NULL,
					 *database = NULL,
					 *table = NULL;
d375 1
a375 1
					 /*
d382 1
a382 1
					 switch( argv[optind][1] )
d387 1
a387 1
										  else
d395 1
a395 1
													 verbose++;
d400 1
a400 1
													 errFlag++;
d408 1
a408 1
										  else
d413 1
a413 1
										  if (dFlag)
d421 1
a421 1
										  errFlag++;
d426 1
a426 1
		  printf("\n");
d434 1
a434 1
					  */
d436 1
a436 1
		  extern  int optind;
d439 1
a439 1
		  ** Check out the args
d447 1
a447 1
													 errFlag++;
d450 1
a450 1
										  break;
d452 1
a452 1
								case 'v':
d460 1
a460 1
										  if (tFlag)
d463 1
a463 1
													 tFlag++;
d476 1
a476 1
										  else
d478 1
a478 1
										  break;
d489 1
a489 1
		  }
d491 1
a491 1
		  if (optind < argc)
d502 1
a502 1
		  /*
d504 1
a504 1
		  */
d515 1
a515 1
		  dbConnect(host,database);
d518 1
a518 1
					 numRows = getTableStructure(table);
d521 1
a521 1
		  }
d523 1
a523 1
		  {
d531 3
a533 3
		  dbDisconnect(host);
		  printf("\n");
		  exit(0);
@


1.2
log
@Ported to use winsock.h
@
text
@a372 5
#ifdef WINSOCK
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;
#endif
a513 7
#ifdef WINSOCK
		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
		  {
			 printf("Error : Unable to initialise WINSOCK\n");
			 exit(1);
		  }
#endif
a531 3
#ifdef WINSOCK
		 WSACleanup();
#endif
@


1.1
log
@Initial revision
@
text
@d32 4
d84 1
a84 1
        exit(EX_MSQLERR);
d98 1
a98 1
        while((cp = (char *)index(cp,'\'')))
d104 1
a104 1
        while((cp = (char *)index(cp,'\\')))
d112 1
a112 1
                tmp = (char *)malloc(strlen(str)+numQuotes+1);
d194 1
a194 1
                exit(EX_MSQLERR);
d283 1
a283 1
                DBerror();
d297 1
a297 1
        while (row=msqlFetchRow(res))
d304 1
a304 1
                        if (!(field = msqlFetchField(res)))
d355 1
a355 1
                msqlFreeResult(res);
d368 10
a377 5
                numRows,
                errFlag = 0;
        char    *host = NULL,
                *database = NULL,
                *table = NULL;
d379 1
a379 1
                /*
d386 1
a386 1
                switch( argv[optind][1] )
d391 1
a391 1
                                else
d399 1
a399 1
                                        verbose++;
d404 1
a404 1
                                        errFlag++;
d412 1
a412 1
                                else
d417 1
a417 1
                                if (dFlag)
d425 1
a425 1
                                errFlag++;
d430 1
a430 1
        printf("\n");
d438 1
a438 1
                 */
d440 1
a440 1
        extern  int optind;
d443 1
a443 1
        ** Check out the args
d451 1
a451 1
                                        errFlag++;
d454 1
a454 1
                                break;
d456 1
a456 1
                        case 'v':
d464 1
a464 1
                                if (tFlag)
d467 1
a467 1
                                        tFlag++;
d480 1
a480 1
                                else
d482 1
a482 1
                                break;
d493 1
a493 1
        }
d495 1
a495 1
        if (optind < argc)
d506 1
a506 1
        /*
d508 1
a508 1
        */
d518 9
a526 1
        dbConnect(host,database);
d529 1
a529 1
                numRows = getTableStructure(table);
d532 1
a532 1
        }
d534 1
a534 1
        {
d542 6
a547 3
        dbDisconnect(host);
        printf("\n");
        exit(0);
@
