#include <OI/oi.H>

/*
 *	simple menus
 *
 *	This program was created to introduce the programmer to 
 *	building menus.  This program simply shows how to build all
 *	of the menu types using a simple predefined menu.
 *
 *	Please refer to the README file for information on other demos
 *	which demonstrate how to associate objects to menus, dynamically
 *	build menus, and associate callbacks to menu cells.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech
 *			set_associated_object()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_menu
 *			general information on menus
 *		- OI_menu_cell
 *			general information on menu cells
 *		- OI_button_menu
 *		- OI_excl_check_menu
 *		- OI_excl_rect_menu
 *		- OI_poly_check_menu
 *		- OI_poly_rect_menu
 */


/*
 *	The OI_cell_spec structure is documented in the OI_menu_cell man page.
 *	For review, the structure is:
 *		struct OI_cell_spec {
 *			char			*namp ;		- ptr to name string for cell
 *			char			*labelp ;	- ptr to string for cell label
 *			OI_action_fn		*fnp ;		- function to execute when cell fires
 *			OI_callback		*objp ;		- ptr to user obj if callback is a 
 *									C++ member function
 *			OI_action_memfn		*memfnp ;	- member func to execute when cell fires
 *			void			*argp ;		- ptr to user arg to pass to callback
 *			OI_menu_cell_type	type;		- Icon type as defined in defs.H
 *			struct	_OI_menu_spec	*menu_ptr;	- Pointer to walking menu
 *			OI_number		wid ;		- width of pixmap
 *			OI_number		ht ;		- height of pixmap
 *			OI_number		dpth ;		- depth of pixmap
 *		};
 */
static OI_cell_spec
colors[] =
{
	{"red","red",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"orange","orange",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"yellow","yellow",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"green","green",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"blue","blue",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"indigo","indigo",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
	{"violet","violet",NULL,NULL,NULL_PMF,NULL,OI_TEXT_CELL,NULL,0,0,0},
};

void
main (int argc, char**argv)
{
	OI_connection	*conp ;
	OI_app_window	*wp ;
	OI_menu		*menu ;
	OI_static_text	*txt ;

	
	/*
	 *	Open a connection.
	 */
	if (conp = OI_init(&argc, argv, "HelloWorld")) {
		/*
		 *	create the application window.
		 *	set layout to row major.
		 */
		wp = oi_create_app_window("main",200,100,"Main Window") ;
		wp->set_layout( OI_layout_row );

		/*
		 *	the simplest button example involves creating a menu,
		 *	in this case a button menu, from a predefined list of
		 *	cells.  Refer to the OI man pages on OI_button_menu
		 *	for the parameters.  Note that the variable used to
		 *	manipulate the button menu is an OI_menu*.  This slightly
		 *	simplifies things if you later decide to create an
		 *	OI_excl_check_menu instead.
		 */
		menu = oi_create_button_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "button_menu" );
		menu->layout_associated_object( wp, 1, 1, OI_ACTIVE );
		
		/*
		 *	In fact, while we're at it... let's use the cell spec structure
		 *	to demonstrate how easy it is to make every type of menu.
		 *
		 *	Please note that this implies that an OI_cell_spec structure is quite reuseable,
		 *	As a caveat, please note that the objects that one makes (cells and menus) can only
		 *	be used once.  Parenting them in one place, then parenting them elsewhere as the 
		 *	effect of moving them.  If one desires multiple copies of a menu, investigate
		 *	the clone member function documented in OI_d_tech.
		 */
		menu = oi_create_excl_check_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "excl_check_menu" );
		menu->layout_associated_object( wp, 2, 1, OI_ACTIVE );
	
		menu = oi_create_excl_rect_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "excl_rect_menu" );
		menu->layout_associated_object( wp, 3, 1, OI_ACTIVE );
	
		menu = oi_create_poly_check_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "poly_check_menu" );
		menu->layout_associated_object( wp, 4, 1, OI_ACTIVE );
	
		menu = oi_create_poly_rect_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "poly_rect_menu" );
		menu->layout_associated_object( wp, 5, 1, OI_ACTIVE );


		/*
		 *	In fact, while we're at it, the following lines of code again reuse the
		 *	`colors' OI_cell_spec to present abbreviated menus for three types
		 *	of menus:
		 *		OI_BUTTON_MENU
		 *		OI_EXCL_CHECK_MENU
		 *		OI_EXCL_RECT_MENU
		 *	We currently do not support POLY abbreviated menus.
		 *	These menus will be layed out in the second row.
		 */
		menu = oi_create_abbr_menu(
			"colorMenu", OI_BUTTON_MENU, OI_n_cells(colors), colors, OI_VERTICAL, "button_menu" );
		menu->layout_associated_object( wp, 1, 2, OI_ACTIVE );

		menu = oi_create_abbr_menu(
			"colorMenu", OI_EXCL_CHECK_MENU, OI_n_cells(colors), colors, OI_VERTICAL, "excl_check_menu" );
		menu->layout_associated_object( wp, 2, 2, OI_ACTIVE );
	
		menu = oi_create_abbr_menu(
			"colorMenu", OI_EXCL_RECT_MENU, OI_n_cells(colors), colors, OI_VERTICAL, "excl_rect_menu" );
		menu->layout_associated_object( wp, 3, 2, OI_ACTIVE );
	
		/*
		 *	And, of course, the final example shows all types of scroll menus.
		 *	In this example I've decided to only display the vertical scroll bar,
		 *	and to change the number of cells that are displayed (3rd parameter).
		 */
		menu = oi_create_scroll_menu(
			"colorMenu", OI_SCROLL_BAR_VERTICAL, 4, OI_BUTTON_MENU,
			OI_n_cells(colors), colors, OI_VERTICAL, "button_menu" );
		menu->layout_associated_object( wp, 1, 3, OI_ACTIVE );

		menu = oi_create_scroll_menu(
			"colorMenu", OI_SCROLL_BAR_VERTICAL, 5, OI_EXCL_CHECK_MENU,
			OI_n_cells(colors), colors, OI_VERTICAL, "excl_check_menu" );
		menu->layout_associated_object( wp, 2, 3, OI_ACTIVE );
	
		menu = oi_create_scroll_menu(
			"colorMenu", OI_SCROLL_BAR_VERTICAL, 5, OI_EXCL_RECT_MENU,
			OI_n_cells(colors), colors, OI_VERTICAL, "excl_rect_menu" );
		menu->layout_associated_object( wp, 3, 3, OI_ACTIVE );
	
		menu = oi_create_scroll_menu(
			"colorMenu", OI_SCROLL_BAR_VERTICAL, 6, OI_POLY_CHECK_MENU,
			OI_n_cells(colors), colors, OI_VERTICAL, "poly_check_menu" );
		menu->layout_associated_object( wp, 4, 3, OI_ACTIVE );
	
		menu = oi_create_scroll_menu(
			"colorMenu", OI_SCROLL_BAR_VERTICAL, 7, OI_POLY_RECT_MENU,
			OI_n_cells(colors), colors, OI_VERTICAL, "poly_rect_menu" );
		menu->layout_associated_object( wp, 5, 3, OI_ACTIVE );

		/*
		 *	popup menu
		 */

		txt = oi_create_static_text( "txt", "Press Here" );
		txt->layout_associated_object( wp, 6, 1, OI_ACTIVE );
		menu = oi_create_button_menu(
			"colorMenu", OI_n_cells(colors), colors, OI_VERTICAL, "button_menu" );
		menu->set_associated_object( txt, OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE_NOT_DISPLAYED );
	
	

		/*
		 *	display main window.
		 *	begin interaction.
		 */
		wp->set_associated_object(wp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE) ;
		OI_begin_interaction() ;
	}

	/*
	 *	Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini() ;
}
