/*
 ***************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1993, ParcPlace Systems, Inc. All rights reserved.
 *
 ***************************************************************************
 *
 *	File:	config.H
 *
 *	Function(s):
 *
 *	Description:
 *		Configuration for different systems for our header files.
 *		Make sure all #defines here start with OI_ to avoid name
 *		conflicts.
 *
 *	RCSid = "$Id: config.H,v 1.1.1.1 1993/06/01 22:53:15 mth Exp $"
 *
 ***************************************************************************
 */

#ifndef	OI_config_H
#define OI_config_H

/*
 * Most systems define fd_set in sys/types.h.  However, AIX defines it
 * in sys/select.h.  HPUX does odd things.  It defines select as
 * taking an int *, when it really takes a fd_set *.  So there is a
 * special define for HP_UX here that impacts all selects in the
 * library.
 */
#if	defined(_AIX)
#  define	OI_FD_SET_H_FILE	<sys/select.h>
#else
#  if	defined(linux)
#    define	OI_FD_SET_H_FILE	<sys/time.h>
#  else
#    define	OI_FD_SET_H_FILE	<sys/types.h>
#  endif
#endif

#if	defined(hpux)
#define	OI_SELECT_FD_TYPE	int
#else
#define	OI_SELECT_FD_TYPE	fd_set
#endif

#endif	/* OI_config_H */
