/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	bastxt.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_base_text class header
 *
 *	RCSid = "$Id: bastxt.H,v 4.11.1.1 1993/06/01 22:52:55 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_bastxt_H
#define OI_bastxt_H

#ifndef OI_lngsrvinp_H
#include <OI/lngsrvinp.H>
#endif /* OI_lngsrvinp_H */

	// class forward reference declarations
	class OI_base_text;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#define	OI_MT_DEF_NCHAR	80	/* default # chars per line initially */

 /* ctl_bits private bits */
#define		OI_BASE_TEXT_IN_CONSTRUCTOR	0x1L	/* 1 => in constructor for this object */

		struct	OI_line	{		/* descriptor for a single line */
				OI_number	max_c ;		/* max # chars txtp has room for */
				OI_number	len ;		/* current # chars in *txtp */
				OI_number	exp_len ;	/* length of line with tabs expanded */
				OI_enhance	eol_enh ;	/* end of line enhancement */
				OI_string	*txtp ;		/* ptr to line's text, NULL if not allocated */
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		


		enum OI_mt_mode	{		/* input mode */
			OI_mt_mode_insert	= 1,			/* insert character between existing characters */
			OI_MT_MODE_INSERT	= OI_mt_mode_insert,
			OI_mt_mode_replace	= 2,			/* replace character under cursor */
			OI_MT_MODE_REPLACE	= OI_mt_mode_replace
		} ;
		enum OI_mt_char_chk_status {	/* return values for per character validation functions */
			OI_mt_char_chk_bad	= 0,			/* reject, character typed is invalid */
			OI_MT_CHAR_CHK_BAD	= OI_mt_char_chk_bad,
			OI_mt_char_chk_insert	= 1,			/* ok, insert character typed */
			OI_MT_CHAR_CHK_INSERT	= OI_mt_char_chk_insert,
			OI_mt_char_chk_ignore	= 2,			/* ok, ignore character typed */
			OI_MT_CHAR_CHK_IGNORE	= OI_mt_char_chk_ignore
		} ;
		enum OI_mt_entry_chk_status {	/* return values for end of entry validation functions */
			OI_mt_entry_chk_bad	= 0,			/* reject, entry is invalid */
			OI_MT_ENTRY_CHK_BAD	= OI_mt_entry_chk_bad,
			OI_mt_entry_chk_ok	= 1,			/* ok */
			OI_MT_ENTRY_CHK_OK	= OI_mt_entry_chk_ok,
			OI_mt_entry_chk_ignore	= 2,			/* ok, ignore newline character */
			OI_MT_ENTRY_CHK_IGNORE	= OI_mt_entry_chk_ignore
		} ;

#ifdef TYPEDEF_MEMFN
	typedef	OI_mt_entry_chk_status	OI_mt_entry_check_fn(OI_base_text*,void*,OI_mt_entry_chk_status,OI_number) ;
			/* function to check validity of line entered */
	typedef	OI_mt_entry_chk_status	OI_callback::OI_mt_entry_check_memfn(OI_base_text*,void*,OI_mt_entry_chk_status,OI_number) ;
			/* member function to check validity of line entered */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_mt_entry_chk_status	(*OI_mt_entry_check_fnp)(OI_base_text*,void*,OI_mt_entry_chk_status,OI_number) ;
			/* function to check validity of line entered */
	typedef	OI_mt_entry_chk_status	(OI_callback::*OI_mt_entry_check_memfnp)(OI_base_text*,void*,OI_mt_entry_chk_status,OI_number) ;
			/* member function to check validity of line entered */

#ifdef TYPEDEF_MEMFN
	typedef	OI_mt_char_chk_status	OI_mt_char_check_fn(OI_base_text*,void*,OI_mt_char_chk_status,OI_number,OI_number,char) ;
			/* function to check validity of char entered */
	typedef	OI_mt_char_chk_status	OI_callback::OI_mt_char_check_memfn(OI_base_text*,void*,OI_mt_char_chk_status,OI_number,OI_number,char) ;
			/* member function to check validity of char entered */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_mt_char_chk_status	(*OI_mt_char_check_fnp)(OI_base_text*,void*,OI_mt_char_chk_status,OI_number,OI_number,char) ;
			/* function to check validity of char entered */
	typedef	OI_mt_char_chk_status	(OI_callback::*OI_mt_char_check_memfnp)(OI_base_text*,void*,OI_mt_char_chk_status,OI_number,OI_number,char) ;
			/* member function to check validity of char entered */

#ifdef TYPEDEF_MEMFN
	typedef	void	OI_mt_char_chg_fn(OI_base_text*,void*) ;
			/* function to call whenever char has changed */
	typedef	void	OI_callback::OI_mt_char_chg_memfn(OI_base_text*,void*) ;
			/* member function to call whenever char has changed */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_mt_char_chg_fnp)(OI_base_text*,void*) ;
			/* function to call whenever char has changed */
	typedef	void	(OI_callback::*OI_mt_char_chg_memfnp)(OI_base_text*,void*) ;
			/* member function to call whenever char has changed */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		Definitions in this section were previously documented, but have been marked as
		//		obsolete.  These definitions have been removed from the programmer's manual.
		//		These definitions are subject to removal from the toolkit and should no longer be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	OI_mt_entry_chk_status	OI_mt_entry_chk_fn(OI_base_text*,void*,OI_number) ;
			/* function to check validity of line entered */
	typedef	OI_mt_entry_chk_status	OI_callback::OI_mt_entry_chk_memfn(OI_base_text*,void*,OI_number) ;
			/* member function to check validity of line entered */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_mt_entry_chk_status	(*OI_mt_entry_chk_fnp)(OI_base_text*,void*,OI_number) ;
			/* function to check validity of line entered */
	typedef	OI_mt_entry_chk_status	(OI_callback::*OI_mt_entry_chk_memfnp)(OI_base_text*,void*,OI_number) ;
			/* member function to check validity of line entered */

#ifdef TYPEDEF_MEMFN
	typedef	OI_mt_char_chk_status	OI_mt_char_chk_fn(OI_base_text*,void*,OI_number,OI_number,char) ;
			/* function to check validity of char entered */
	typedef	OI_mt_char_chk_status	OI_callback::OI_mt_char_chk_memfn(OI_base_text*,void*,OI_number,OI_number,char) ;
			/* member function to check validity of char entered */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_mt_char_chk_status	(*OI_mt_char_chk_fnp)(OI_base_text*,void*,OI_number,OI_number,char) ;
			/* function to check validity of char entered */
	typedef	OI_mt_char_chk_status	(OI_callback::*OI_mt_char_chk_memfnp)(OI_base_text*,void*,OI_number,OI_number,char) ;
			/* member function to check validity of char entered */

	class OI_base_text : public OI_lang_server_input {
	 private:
			unsigned long	ctl_bits ;		/* object specific control bits */
	 protected:
		static	XrmQuark	q_rightMargin;

	 public:
		static	XrmQuark	q_cbMtCharChk ;		/* OBSOLETE quark for character validation callback */
		static	XrmQuark	q_cbMtEntryChk ;	/* OBSOLETE quark for end of entry validation callback */
		static	XrmQuark	q_cbClick ;		/* quark for end of entry validation callback */
		static	XrmQuark	q_cbMtCharChg ;		/* quark for character change callback */
		static	XrmQuark	q_cbMtCharCheck ;	/* quark for character validation callback */
		static	XrmQuark	q_cbMtEntryCheck ;	/* quark for end of entry validation callback */
		static	OI_class	*clsp ;			/* ptr to class record */

	 private:
			void		construct(OI_number,OI_number,OI_number,OI_number) ;
			void		set_in_my_constructor()	{ctl_bits|=OI_BASE_TEXT_IN_CONSTRUCTOR;}
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_BASE_TEXT_IN_CONSTRUCTOR;}
			OI_bool		in_my_constructor()	{return((ctl_bits&OI_BASE_TEXT_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			void		refresh_my_callback(OI_cb_inf*) ;
			OI_bool		res_click_select( void * );			/* click selection allowed */
			OI_bool		res_inactive_cursor( void * );			/* inactive cursor displayed */
			OI_bool		res_kb_input(void *);				/* kbd input allowed */
			OI_bool		res_right_margin(void*);				/* resolve rightMargin resource */
			OI_bool		res_set_cols(void *);				/* initial line width in chars */
			OI_bool		res_set_lines(void *);				/* initial number of lines */
			OI_bool		res_set_text_to_string(void *);			/* input line of text */
			OI_bool		res_tab_width(void *) ;				/* tab width increment */
			OI_bool		res_text_file(void *);				/* input text file */
			OI_bool		res_view_n_lines(void *);			/* view height in lines */
			OI_bool		res_view_n_chars(void *);			/* view width in chars */
			OI_bool		res_wrap(void*);				/* resolve wrap resource */
			char		*string_text();					/* if single line, then text */

	 protected:
					OI_base_text(OI_class *clsp, const char *usr_namp);
		virtual	OI_stat		set_text_cb(OI_text_fnp fp, OI_callback *objp, OI_text_memfnp mfp) = 0 ;	/* set text */

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					~OI_base_text() ;				/* destructor */
		static	OI_bool		init(OI_connection*) ;
		virtual	OI_stat		insert_chars_gen(OI_number,OI_number,OI_number,const char*,OI_number* =NULL,OI_number* =NULL,
						OI_bool=OI_NO, OI_char_encode_type=OI_char_encode_none) = 0 ;
											/* add char substring to line */
		virtual	OI_stat		insert_line_gen(OI_number,OI_bool,const char*,OI_char_encode_type) = 0;
											/* insert new line of text */
			OI_bool		is_write_resq(XrmQuark);
 		virtual	OI_line		*line(OI_number lin) = 0;
		virtual	OI_bool		new_right_margin(OI_number) = 0 ;
 		virtual	OI_string	*ply_text(OI_number lin) = 0;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		set_char_chk(OI_mt_char_chk_fnp fp=NULL, void *argp=NULL) ;	// OBSOLETE, use set_char_check
		virtual	void		set_char_chk(OI_callback *objp, OI_mt_char_chk_memfnp mfp, void *argp=NULL) ;	// OBSOLETE, use set_char_check
		virtual	void		set_entry_chk(OI_mt_entry_chk_fnp fp=NULL, void *argp=NULL) ;	// OBSOLETE, use set_entry_check
		virtual	void		set_entry_chk(OI_callback *objp, OI_mt_entry_chk_memfnp mfp, void *argp=NULL) ;	// OBSOLETE, use set_entry_check
		virtual	OI_stat		set_view(OI_number, OI_number) ; 			/* OBSOLETE; use set_view_size */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	char		*alpha_value() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_click_select() = 0 ;
		virtual	void		allow_inactive_cursor() = 0 ;
		virtual	void		allow_kb_input() = 0 ;
		virtual	void		allow_wrap() = 0 ;
		virtual	OI_stat		append_file(const char *fn, OI_bool scroll=OI_no) = 0;	/* append contents of file to text */
		virtual	OI_stat		append_file(FILE *fp, OI_bool scroll=OI_no) = 0;	/* append contents of file to text */
		virtual	OI_stat		append_string(const char *str,OI_bool scroll=OI_no) = 0;
												/* append contents of string to text */
		virtual	OI_number	char_width() = 0 ;
		virtual	OI_stat		char_xy_position(OI_number,OI_number,long*,long*) = 0 ;	/* get xy position for line/char posn */
		virtual	void		clear_enhance(OI_number) = 0 ;				/* clear all enhancements on a line */
		virtual	void		clear_modified() = 0 ;
		virtual	void		clear_prog_modified() = 0 ;
		virtual	void		clear_user_modified() = 0 ;
			void		clear_text() 		{set_text(NULL); }		/* clear all lines */
		virtual	char		*current_file() = 0 ;					/* name of initial contents file */
		virtual	OI_number	cursor_char() = 0 ;					/* cursor char #, 0-len */
		virtual	OI_number	cursor_column() = 0 ;					/* cursor column #, 0-exp len */
		virtual	OI_number	cursor_line() = 0 ;					/* cursor line #, 0-n_lin */
			OI_stat		delete_char(OI_number ln, OI_number cn) ; 		/* remove char from line */
		virtual	OI_stat		delete_chars(OI_number,OI_number,OI_number) = 0 ;	/* remove substring from line */
		virtual	OI_stat		delete_line(OI_number) = 0 ;				/* remove line */
		virtual	OI_stat		delete_lines(OI_number,OI_number) = 0 ;			/* remove lines */
		virtual	void		disallow_click_select() = 0 ;
		virtual	void		disallow_inactive_cursor() = 0 ;
		virtual	void		disallow_kb_input() = 0 ;
		virtual	void		disallow_wrap() = 0 ;
		virtual	OI_bool		exec_cmd(const char *str,OI_base_text *outp=NULL,OI_base_text *errp=NULL,OI_bool append=OI_no) = 0;
												/* exec text or string as commands */
		virtual	OI_bool		find_string(OI_number*,OI_number*,const char*,OI_bool=OI_no,OI_bool=OI_no) = 0 ;
		virtual	OI_enhance	get_enhance(OI_number,OI_number) = 0 ;			/* get enhance for a character */
			OI_stat		insert_char(OI_number ln, OI_number cn, char ch, OI_number *nlp=NULL,OI_number *ncp=NULL) ;
			OI_stat		insert_chars(OI_number ln, OI_number cn, OI_number n, const char *cp, OI_number *nlp=NULL,
						OI_number *ncp=NULL) ;				/* add char substring to line */
			OI_stat		insert_line(OI_number,const char*) ;			/* insert new line of text */
			OI_stat		insert_scroll_chars(OI_number ln, OI_number cn, OI_number n, const char *cp, OI_number *nlp=NULL,
						OI_number *ncp=NULL) ;
			OI_stat		insert_scroll_line(OI_number,const char*) ;
												/* insert new line of text,
												   discard 1st line if no space */
		virtual	OI_bool		is_click_select() = 0 ;
		virtual	OI_bool		is_inactive_cursor() = 0 ;
		virtual	OI_bool		is_kb_input() = 0 ;
		virtual	OI_bool		is_modified() = 0 ;
		virtual	OI_bool		is_prog_modified() = 0 ;
		virtual	OI_bool		is_user_modified() = 0 ;
		virtual	OI_bool		is_wrap() = 0 ;
		virtual	OI_number	line_height() = 0 ;
		virtual	OI_number	line_width(OI_number) = 0 ;				/* get width of text line */
		virtual	OI_number	max_chars() = 0 ;
		virtual	OI_number	max_lines() = 0 ;
		virtual	OI_number	max_n_chars() = 0 ;					/* max # chars */
		virtual	OI_number	max_n_pixels() = 0 ;					/* max # pixels */
		virtual	OI_mt_mode	mode() = 0 ;						/* get current insert mode */
		virtual	OI_number	n_lines() = 0 ;						/* # active lines */
		virtual	OI_stat		output_text(const char *fn, OI_bool append=OI_no) = 0;	/* write text to file */
		virtual	OI_stat		output_text(FILE *fp, OI_bool append=OI_no) = 0;	/* write text to file */
		virtual	void		pan_paint(OI_panner*,void*,XExposeEvent*) ;		/* paint miniature of object for panner */
		virtual	void		remove_enhance(OI_number,OI_number,OI_number,OI_enhance) = 0 ;
												/* unenhance portion of text */
			OI_stat		replace_char(OI_number ln, OI_number cn, char ch) ; 	/* replace single char of line */
		virtual	OI_stat		replace_chars(OI_number,OI_number,OI_number,const char*) = 0 ;
												/* replace substring of line */
		virtual	OI_stat		replace_line(OI_number,const char*) = 0 ;		/* replace text for an existing line */
		virtual	OI_number	right_margin() = 0 ;
		virtual	void		scroll(OI_ctlr_1d*,void*,OI_scroll_event,long) ;
		virtual	void		scroll_2d(OI_panner*,void*,OI_scroll_event,long,long) ;
		virtual	OI_bool		selection_coords(OI_number *slin, OI_number *schr, OI_number *elin, OI_number *echr) = 0 ;
												/* return coords of selection */
		virtual char		*selection_data(Atom) = 0 ;				/* get selection's data */
		virtual	char		*selection_data(const char *) = 0 ;			/* get selection's data */
		virtual	void		set_char_chg(OI_mt_char_chg_fnp fp, void *argp=NULL) ;
		virtual	void		set_char_chg(OI_callback *objp, OI_mt_char_chg_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_char_check(OI_mt_char_check_fnp fp=NULL, void *argp=NULL) ;
		virtual	void		set_char_check(OI_callback *objp, OI_mt_char_check_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_cols(OI_number mx_c) = 0 ;				/* change initial max # chars/line */
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,const char*,const char*,
						const char* =NULL) = 0;				/* enhance portion of text */
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,PIXEL=OI_UNKNOWN_PIXEL,PIXEL=OI_UNKNOWN_PIXEL,
						const char* =NULL) = 0;				/* enhance portion of text */
		virtual	void		set_entry_check(OI_mt_entry_check_fnp fp=NULL, void *argp=NULL) ;
		virtual	void		set_entry_check(OI_callback *objp, OI_mt_entry_check_memfnp mfp, void *argp=NULL) ;
		virtual	OI_stat		set_lines(OI_number) = 0 ;				/* set max # lines */
		virtual	void		set_mode(OI_mt_mode md) = 0 ;				/* set insert mode */
		virtual	OI_stat		set_position(OI_number,OI_number,OI_psn_type=OI_psn_default) = 0 ;	/* psn csr in view */
		virtual	OI_bool		set_right_margin(OI_number) = 0 ;
		virtual	OI_stat		set_tab_width(OI_number tw) = 0;			/* set # chars in tab width increment */
		virtual	OI_stat		set_tabs_custom(OI_number *, OI_number, OI_number =8) = 0;	/* set custom tabstops table */
			OI_stat		set_text(OI_text_fnp fp) ;				/* set text */
			OI_stat		set_text(OI_callback *objp, OI_text_memfnp mfp) ;
		virtual	OI_stat		set_text_to_file(const char *fn) = 0 ;			/* set text to contents of file */
		virtual	OI_stat		set_text_to_file(FILE *fp) = 0 ;			/* set text to contents of file */
		virtual	OI_stat		set_text_to_string(const char *str) = 0 ;		/* set text to contents of string */
		virtual	OI_stat		set_view_size(OI_number vln, OI_number vch) = 0 ;	/* change viewport size */
		virtual	OI_number	tab_width() = 0 ;					/* # chars in tab width increment */
		virtual	char		*text(OI_number) = 0 ;					/* get ptr to line of text */
		virtual	void		ulcwf(OI_number *uln, OI_number *uch) = 0 ;		/* line/char # of upper left corner of
												   viewport */
		virtual	OI_number	ulcwf_char() = 0 ;					/* char # of ULC of viewport */
		virtual	OI_number	ulcwf_line() = 0 ;					/* line # of ULC of viewport */
		virtual	OI_number	ulcwf_pixel() = 0 ;					/* pixel # of char in ULC of viewport */
		virtual	void		view_size(OI_number *vln, OI_number *vch) = 0 ;		/* # lines/chars in viewport */
		virtual	OI_number	view_n_lines() = 0 ;					/* # lines in viewport */
		virtual	OI_number	view_n_chars() = 0 ;					/* # chars in viewport */
		virtual	OI_stat		view_char_position(long,long,OI_number*,OI_number*) = 0 ;
		virtual	void		wrap(OI_number=0,OI_number=0) = 0 ;			/* wrap text */
												/* get ln/ch posn for xy posn in viewport */
		virtual	OI_stat		xy_char_position(long,long,OI_number*,OI_number*) = 0 ;	/* get line/char position for xy posn */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_bastxt_H */
