/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mnu.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_menu class header
 *		The application public functions for OI_menu define the functions
 *		available to an application for all menus.  All functions are
 *		applicable to all menus, regardless of a menu's specific type.
 *
 *	RCSid = "$Id: mnu.H,v 4.22.1.1 1993/06/01 22:55:32 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_mnu_H
#define OI_mnu_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

#ifndef OI_mnucel_H
#include <OI/mnucel.H>
#endif /* OI_mnucel_H */

#define OI_MENU_PUSHPIN_ROW		0
#define OI_MENU_PUSHPIN_COLUMN		0
#define OI_MENU_TITLE_ROW		OI_MENU_PUSHPIN_ROW
#define OI_MENU_TITLE_COLUMN		(OI_MENU_PUSHPIN_COLUMN+1)
#define OI_MENU_SEP_ROW			(OI_MENU_TITLE_ROW+1)
#define OI_MENU_SEP_COLUMN		0
#define OI_MENU_CELL_LAYOUT_OFFSET	0

	// forward reference declaration
	class OI_menu;
	class OI_mdl_menu;

		struct OI_menu_spec {
			char		*namp ;		/* ptr to name for menu */
			OI_number	n_cell ;	/* # cells */
			OI_cell_spec	*cell_specp ;	/* ptr to vector of cell specs */
			OI_orient	ornt ;		/* orientation of menu */
			char		*titlep ;	/* ptr to title string */
			long		ctl_bits ;	/* misc control bits (OI_MENU_PUSHPIN, OI_MENU_NO_PERSISTENT,
								OI_MENU_NO_OUTLINE_CELL, OI_MENU_UNSEL) */
			OI_class	**menu_type ;	/* type of menu desired */
		} ;

#define OI_MENU_BVL_SPACE	2
#define OI_MENU_BDR_WID		1
#define OI_MENU_SHADOW_WID	6
#define	OI_MX_CELL		1000	/* max # cells locally allocated before using malloc for oi_setup_cells interface */
#define	OI_MX_MENU		100	/* max # menus allowed in any one constructor operation */
#define	OI_MENU_VIS_CTR		10	/* # iterations between visibility checks to prevent hang */
#define	OI_MENU_DRAG_DELTA	10	/* default ptr motion to bring up pull_down/pull_right */

 /* object specific control bits */
#define	OI_MENU_POPUP			0x1L		/* menu is a temporarily displayed popup */
#define	OI_MENU_SHADOW			0x2L		/* menu is shadowed */
#define	OI_menu_pushpin			0x4L		/* menu has pushpin */
#define	OI_MENU_PUSHPIN			OI_menu_pushpin
#define	OI_MENU_PINNED			0x8L		/* menu is pinned up */
#define	OI_MENU_DRAG_SELECT		0x10L		/* menu allows draging the pointer between cells to select them */
#define	OI_MENU_SAVE_UNDER		0x20L		/* popup should use save unders */
#define	OI_MENU_PD			0x40L		/* 1 => menu is a pulldown */

#define	OI_MENU_PIN_PAINTED		0x100L		/* menu title and decoration has been painted (cleared when 0 count expose event comes in) */
#define	OI_MENU_POPUP_EVENTS		0x400L		/* 1 => popup events are currently on the object */

#define	OI_MENU_TITLE_PAINTED		0x800L		/* title has been painted */
#define	OI_menu_unsel			0x1000L		/* Note!!! used only in OI_menu_spec.ctl_bits; exclusive menu allows deselection */
#define	OI_MENU_UNSEL			OI_menu_unsel
#define	OI_MENU_OUTLINE_CELL		0x2000L		/* menu paints outline of cell when not selected (default) */
#define	OI_menu_no_outline_cell		0x2000L		/* Note!!! used ONLY in OI_menu_spec.ctl_bits (it contradicts OI_MENU_OUTLINE_CELL)! */
#define	OI_MENU_NO_OUTLINE_CELL		OI_menu_no_outline_cell
#define	OI_MENU_BUSY			0x4000L		/* menu busy (a user interaction sequence is in progress) */
#define OI_MENU_PERSISTENT		0x8000L		/* menu stays popped up until cell is done firing (default) */
#define OI_menu_no_persistent		0x8000L		/* Note!!! used ONLY in OI_menu_spec.ctl_bits (it contradicts OI_MENU_PERSISTENT)! */
#define OI_MENU_NO_PERSISTENT		OI_menu_no_persistent
#define	OI_MENU_POINTER_GRABBED		0x10000L	/* is the pointer grabbed for this menu? */
#define	OI_MENU_TEMP_TITLE		0x20000L	/* menu has temporary title supplied when pinned */
#define	OI_MENU_BVL_PAINTED		0x40000L	/* has the 3D bevel been painted */
#define	OI_MENU_HAS_BVL			0x80000L	/* has a 3D bevel */
#define	OI_MENU_IS_UNDERLYING		0x100000L	/* This is an underlying menu (ie. in case of scollmenu or abbrmenu */
#define	OI_MENU_PINNED_PENDING		0x200000L	/* Are we in the middle of pinning this menu ? */
#define OI_MENU_POPUP_TRANS_INSTALLED 	0x800000L	/* popup translations have been installed on the parent */
#define OI_MENU_MAIN_MENU	 	0x1000000L	/* this menu is the main menu */
#define OI_MENU_DISPATCH_PUSHED	 	0x2000000L	/* has the dispatch level been pushed? */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_menu_end_fn)(OI_menu*, OI_menu_cell *, void *, OI_number) ;
	typedef	void	(OI_callback::OI_menu_end_memfn)(OI_menu*, OI_menu_cell *, void *, OI_number) ;
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_menu_end_fnp)(OI_menu*, OI_menu_cell *, void *, OI_number) ;
	typedef	void	(OI_callback::*OI_menu_end_memfnp)(OI_menu*, OI_menu_cell *, void *, OI_number) ;

	class OI_menu : public OI_w_d_tech {
			OI_mdl_menu	*mdl_dep ;		/* ptr to model dependent aspects of OI_box object */
			unsigned long	ctl_bits ;		/* object specific control bits */
			OI_origin	popup_org ;		/* orig loc of button press for popup, before mods to force on screen */
		static	OI_number	dsp_lvl;		/* Dispatch push/pop level count for nested menus. */
		protected:
		static	XrmQuark	q_title;
		static	XrmQuark	q_cellOutline;
		static	XrmQuark	q_labelRightSpace;
		static	XrmQuark	q_menuTrigger;
		static	XrmQuark	q_wrapLimit;
			OI_menu_cell	*cur_cellp;		/* current cell during mouse traversal */
			OI_menu_cell	*fired_cellp;		/* cell that was fired */
			OI_number	shad_wid;		/* shadow width for popups */
			Window		shad_win;		/* shadow window for popups */
			OI_number	saved_bdr_wid;		/* saved border width prior to popup */
			OI_xy		dec_siz ;		/* decoration size, this + max_basic_siz is menu size */
			OI_xy		max_basic_siz ;		/* max basic cell size */
			OI_orient	orient ;		/* menu orientation */
			OI_number	acc_lbl_siz;		/* size of max accelerator label */
			OI_number	trg ;			/* button number for OI_BTN_SELECT trigger */
			OI_number	mnu_trg ;		/* button number for OI_BTN_MENU trigger */
			OI_number	def_trg ;		/* button number for default selection trigger */
			OI_number	trg_mods ;		/* modifier bits for OI_BTN_SELECT trigger */
			OI_number	mnu_trg_mods ;		/* modifier bits for OI_BTN_MENU trigger */
			OI_number	def_trg_mods ;		/* modifier bits for default selection trigger */
			OI_number	btn ;			/* # of button being processed, 0=>nothing active */
			Time		tim ;			/* time of last button press/release event */
 			OI_menu		*subact;		/* Object which was sub activated. Else NULL. */
			OI_d_tech	*prev_focus_obj;	/* OI object where the previous keyboard focus was set */
			OI_menu		*pined_for;		/* what menu this one was pinned for */
			OI_menu		*pined_for_me;		/* what menu is pinned for this one */
			OI_menu		*pined_for_lst;		/* list of pinned for menus */
			OI_menu		*pined_nxt;		/* pointer to next menu in pinned_for list */
			OI_menu		*pined_prv;		/* pointer to previous menu in pinned_for list */
			OI_number	lbl_right_space;	/* space between horizontal label and object */
			OI_menu_cell	*orig_cellp;		/* original cell that got the button press */
			OI_tabstops	*tabs;			/* ptr to tabstops table */
			OI_number	wrap_lmt;		/* wrap limit on cells */
		 public:
		static	OI_class	*clsp ;			/* ptr to class record */
		static	XrmQuark	q_cbPin ;		/* quark for pin callback */
		static	XrmQuark	q_cbUnpin ;		/* quark for unpin callback */
		static	XrmQuark	q_cbMenuEnd ;		/* quark for end of menu interaction callback */
		static	XrmQuark	q_cbPrePopup ;		/* quark for prepopup callback */

		 private:
			void		allow_popup_events()	{ctl_bits |= OI_MENU_POPUP_EVENTS;}
			void		construct(OI_orient, const char *title) ;
			void		disallow_popup_events()	{ctl_bits &= ~OI_MENU_POPUP_EVENTS;}
			OI_bool		is_popup_events()	{return ((ctl_bits&OI_MENU_POPUP_EVENTS) ? OI_yes : OI_no);}
		virtual	void		set_model_info() ;					/* set properties related to model */
			void		unpin_descendants() ;					/* unpin menu and all submenus */
			void		new_tabstops();						/* set new tabs in all cells and title */

		protected:
					OI_menu(const char *usr_namp, OI_orient or, const char *title) ;
					OI_menu(OI_class *clsp, const char *usr_namp, OI_orient or, const char *title) ;
					~OI_menu() ;

		virtual	void		new_model(OI_model_type) ;
			void		paint_title(OI_bool) ;
			void		paint_decoration(const XEvent*) ;				/* paint menu decoration */
			void		clear_painted() ;
			void		pin_resize();

 		virtual	void		post_associate();					/* Do install-popup-translations. */
			void		move_window(Window, int, int);
			void		res_title(void *);					/* callback for title resource */
		friend	void	dmpOI_menu(OI_menu*) ;

		public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_menu_cell	*abbr_cell() = 0 ;					/* cell to display in abbreviated menu */
			OI_number	accelerator_label_size()	{ return (acc_lbl_siz); }
			void		actual_pin();						/* actually pin a menu */
			void		add_to_pinned_for_list(OI_menu *);
			void		adjust_pushpin_loc();
		virtual	OI_number	alignment_loc_x(OI_alignment = OI_alignment_default);
		virtual	OI_number	alignment_loc_y(OI_alignment = OI_alignment_default);
			void		allow_bevel()			{ctl_bits |= OI_MENU_HAS_BVL;}
			void		allow_busy()			{ctl_bits |= OI_MENU_BUSY;}
			void		allow_dispatch_pushed()		{ctl_bits |= OI_MENU_DISPATCH_PUSHED;}
			void		allow_drag_select()		{ctl_bits |= OI_MENU_DRAG_SELECT;}
		virtual	void		allow_main_menu();
			void		allow_pinned_menu()		{ctl_bits |= OI_MENU_PINNED;}
			void		allow_pointer_grabbed()		{ctl_bits |= OI_MENU_POINTER_GRABBED;}
			void		allow_popup()			{ctl_bits |= OI_MENU_POPUP; }
			void		allow_popup_translations()	{ctl_bits |= OI_MENU_POPUP_TRANS_INSTALLED;}
		virtual	void		allow_resel() = 0 ;
			void		allow_save_under()		{ctl_bits |= OI_MENU_SAVE_UNDER;}
			void		allow_shadow()			{ctl_bits |= OI_MENU_SHADOW;}
			void		allow_underlying_menu()				{ctl_bits |= OI_MENU_IS_UNDERLYING;}
		virtual	void		allow_unsel() = 0 ;
			OI_number	button()			{ return(btn); }
		virtual	PIXEL		cell_bkg_paint_pixel(OI_menu_cell *);
		virtual	PIXEL		cell_fg_paint_pixel(OI_menu_cell *);
		virtual	PIXEL		cell_fg_reverse_paint_pixel(OI_menu_cell *);
		virtual	void		cell_new_bvl_width(OI_menu_cell *) ;			/* change bevel width of a cell */
		virtual	void		cell_paint(OI_menu_cell*) = 0 ;				/* paint a cell */
//		virtual	void		cell_resized(OI_menu_cell*, void *) = 0 ;		/* callback for when a cell has resized */
		virtual	void		cell_set_xtra(OI_menu_cell *) ;				/* change extra spacing of a cell */
		virtual	OI_menu_cell	*cell_to_fire(OI_menu_cell*,OI_bool=OI_no) = 0 ;			/* determine proper cell to fire */
			void		check_popup_translations();
			void		clear_busy() ;
			void		clear_pinned_pending()		{ ctl_bits &= ~OI_MENU_PINNED_PENDING; }
		virtual	void		clear_selected_cell(OI_menu_cell *);
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	void		clone_adjust_after_descendants(OI_d_tech*) ;
#ifdef TL_NOT_USED
			void		clone_children(OI_menu*) ;
#endif /* TL_NOT_USED */
		virtual	OI_stat		create() ;
			OI_menu_cell	*current_cell()			{return(cur_cellp);}
			long		def_loc_x() ;
			long		def_loc_y() ;
			OI_number	def_trigger()			{return(def_trg);}
			OI_number	def_trigger_mods()		{return(def_trg_mods);}
			OI_bool		default_trigger(OI_number b, OI_number m) ;
			void		del_from_pinned_for_list(OI_menu *);
		virtual	void		delete_all_delayed() ;					/* mark object for delayed delete_all */
			void		disallow_bevel()		{ctl_bits &= ~OI_MENU_HAS_BVL;}
			void		disallow_busy()			{ ctl_bits &= ~OI_MENU_BUSY; }
			void		disallow_dispatch_pushed()	{ctl_bits &= ~OI_MENU_DISPATCH_PUSHED;}
			void		disallow_drag_select()		{ctl_bits &= ~OI_MENU_DRAG_SELECT;}
		virtual	void		disallow_main_menu();
			void		disallow_pinned_menu()		{ctl_bits &= ~OI_MENU_PINNED;}
			void		disallow_pointer_grabbed()	{ctl_bits &= ~OI_MENU_POINTER_GRABBED;}
			void		disallow_popup()		{ctl_bits &= ~OI_MENU_POPUP; }
			void		disallow_popup_translations()	{ctl_bits &= ~OI_MENU_POPUP_TRANS_INSTALLED; }
		virtual	void		disallow_resel() = 0 ;
			void		disallow_save_under()		{ctl_bits &= ~OI_MENU_SAVE_UNDER;}
			void		disallow_shadow()		{ctl_bits &= ~OI_MENU_SHADOW;}
		virtual	void		disallow_unsel() = 0 ;
/*KNOWN*/	virtual	void		do_resize() ;
			OI_number	drag_delta()			{return(OI_MENU_DRAG_DELTA);}
		virtual	OI_menu_cell	*find_cell(int,int) ;					/* find cell at (x,y) */
			OI_menu_cell	*find_visible_cell(int,int) ;				/* find visible cell at (x,y) */
		virtual	void		fire_cell(OI_menu_cell *) = 0;
			OI_menu_cell	*fired_cell()			{return(fired_cellp);}
		virtual	Cursor		grab_cursor() ;
		virtual	void		handle_delete_window();
		virtual	OI_bool		has_submenu() = 0;
			OI_d_tech	*in_ancestor_menu(OI_number,OI_number) ;		/* check if ptr is in an ancestor menu */
		static	OI_bool		init(OI_connection*) ;
		virtual	void		init_selections() ;					/* initialize preselected cells */
		virtual	OI_number	inter_cell_x() = 0 ;
		virtual	OI_number	inter_cell_y() = 0 ;
			OI_bool		is_bevel()			{return(OI_bool)((ctl_bits&OI_MENU_HAS_BVL) != 0);}
			OI_bool		is_busy()			{ return((ctl_bits & OI_MENU_BUSY) ? OI_yes : OI_no); }
			OI_bool		is_dispatch_pushed()		{return ((ctl_bits & OI_MENU_DISPATCH_PUSHED)?OI_yes:OI_no); }
			OI_bool		is_drag_select()		{ return((ctl_bits & OI_MENU_DRAG_SELECT) ? OI_yes : OI_no); }
			OI_bool		is_main_menu()			{return(OI_bool)((ctl_bits&OI_MENU_MAIN_MENU) != 0);}
			OI_bool		is_menu();
			OI_bool		is_pinned_menu()		{return(OI_bool)((ctl_bits&OI_MENU_PINNED)?OI_yes:OI_no); }
			OI_bool		is_pinned_pending()		{return(OI_bool)((ctl_bits&OI_MENU_PINNED_PENDING) != 0);}
			OI_bool		is_pointer_grabbed()		{return(OI_bool)((ctl_bits&OI_MENU_POINTER_GRABBED) != 0);}
			OI_bool		is_popup()			{return(OI_bool)((ctl_bits&OI_MENU_POPUP) != 0);}
			OI_bool		is_popup_translations()		{return((OI_bool)((ctl_bits&OI_MENU_POPUP_TRANS_INSTALLED) != 0)); }
			OI_bool		is_pull();
		virtual	OI_bool		is_resel() = 0 ;
			OI_bool		is_save_under()			{return((ctl_bits&OI_MENU_SAVE_UNDER)?OI_yes:OI_no);}
			OI_bool		is_shadow()			{return(OI_bool)((ctl_bits&OI_MENU_SHADOW) != 0);}
			OI_bool		is_underlying_menu()		{return(OI_bool)((ctl_bits&OI_MENU_IS_UNDERLYING) != 0);}
		virtual	OI_bool		is_unsel() = 0 ;
			OI_bool		is_write_resq(XrmQuark);
		virtual	void		leave_menu();						/* the pointer has left the menu */
		virtual	void		make_cell_visible(OI_menu_cell *);
/*KNOWN*/	virtual	OI_number	max_basic_size_x();
/*KNOWN*/	virtual	OI_number	max_basic_size_y();
			OI_bool		menu_trigger(OI_number b, OI_number m)	{ if ((b==mnu_trg) && (m==mnu_trg_mods)) return(OI_yes) ; else return(OI_no); }
		virtual	OI_menu_cell	**multi_default_cell() = 0 ;
			void		new_bvl_width(OI_number);
		virtual void		new_font(OI_font *, OI_charset=OI_charset_latin1);	/* change font generically */
			void		new_label_right_space(OI_number);
			OI_stat		new_menu_trigger(OI_number, OI_number=0) ;
		virtual	void		new_title(const char *title, OI_char_encode_type);
		virtual	void		new_wrap_limit(OI_number);
		virtual	OI_number	num_abbr_cell() = 0 ;					/* cell to display in abbreviated menu */
		virtual	OI_number	*num_multi_default_cell(OI_number*) = 0 ;
		virtual	OI_stat		num_set_abbr_cell(OI_number) = 0 ;			/* cell to display in abbreviated menu */
			OI_menu_cell	*original_cell()		{ return (orig_cellp); }
			OI_menu		*outside_menu();					/* return outside menu of this cell. */
			OI_menu_cell	*parent_menu_cell();
		virtual	OI_menu		*pin(OI_bool = OI_yes);					/* pin up menu */
		virtual	OI_string	*ply_title() ;
		virtual	void		popup();
		virtual	OI_bool		popup_focus_frame_width();	/* should popup menu use a focus frame? */
			void		popup_resize(OI_bool = OI_yes);
			void		pre_popup();
			OI_d_tech	*prev_focus_object()		{return(prev_focus_obj);}
			void		property_notify(const XEvent*) ;
			void		propogate_pinned_for(OI_menu *);			/* propgate pinned_for members */
			OI_menu		*pinned_for()			{ return(pined_for); }
			OI_menu		*pinned_for_list()		{ return(pined_for_lst); }
			OI_menu		*pinned_for_me()		{ return(pined_for_me); }
			OI_menu		*pinned_next()			{ return(pined_nxt); }
			OI_menu		*pinned_prev()			{ return(pined_prv); }
			void		pop_dispatch_level(OI_bool=OI_no);			/* Pop dsp_lvl */
			void		push_dispatch_level();					/* Update dsp_lvl and push dispatch if not done.*/
			OI_bool		pulldown() ;
		virtual	void		pseudo_delete() ;
			void		release_stuckup() ;					/* release ancestors in stuckup mode */
		virtual	void		reorder_cells();
			void		res_cell_outline(void *);				/* resource setting callback */
			void		res_persistent(void *);					/* resource setting callback */
			void		res_pushpin(void *);					/* resource setting callback */
			void		res_label_right_space(void *);
			void		res_wrap_limit(void *);
		virtual	OI_stat		select_cell(OI_bool,OI_menu_cell*, OI_bool=OI_no, OI_bool=OI_yes) = 0 ;		/* select a particular cell */
		virtual	OI_stat		set_abbr_cell(const char*) = 0 ;				/* cell to display in abbreviated menu */
/*KNOWN*/		void		set_accelerator_label_size(OI_number s)	{ acc_lbl_siz = s; }
			void		set_busy() ;
 			void		set_button(OI_number b)		{btn = b;}
			void		set_current_cell(OI_menu_cell *cp)	{cur_cellp = cp; }
			OI_stat		set_def_trigger(OI_number, OI_number=0) ;
			void		set_fired_cell(OI_menu_cell *f)		{ fired_cellp = f; }
/*KNOWN*/		void		set_max_basic_size(OI_number x, OI_number y) ;
/*KNOWN*/		void		set_max_basic_size_x(OI_number x)	{max_basic_siz.x=x;}
/*KNOWN*/		void		set_max_basic_size_y(OI_number y)	{max_basic_siz.y=y;}
			void		set_original_cell(OI_menu_cell *p)	{ orig_cellp = p; }
			void		set_pinned_for(OI_menu *p)	{ pined_for = p; }
			void		set_pinned_for_me(OI_menu *p)	{ pined_for_me = p; }
			void		set_pinned_next(OI_menu *m)	{ pined_nxt = m; }
			void		set_pinned_pending()		{ ctl_bits |= OI_MENU_PINNED_PENDING; }
			void		set_pinned_prev(OI_menu *m)	{ pined_prv = m; }
			void		set_popup_loc(long x, long y)	{ popup_org.x=x; popup_org.y=y; }
			void		set_prev_focus_object(OI_d_tech *d)		{prev_focus_obj = d;}
			void		set_pulldown(OI_bool) ;
		virtual	void		set_selected_cell(OI_menu_cell *);
 			void		set_sub_act(OI_menu *mp)	{ subact=mp; }
			void		set_time(Time t)		{ tim=t; }
		virtual	OI_menu_cell	*start_current_cell() = 0;
		virtual	void		stick() ;						/* force active in stuckup mode */
 			OI_menu		*sub_act()			{ return(subact); }	/* ptr to sub-menu if one is active */
			void		sub_position(OI_number,OI_number) ;			/* position menu as a submenu */
		virtual	OI_tabstops	*tabstops();
			Time		time()				{ return(tim); }
			OI_number	title_loc_x();
			OI_number	title_loc_y();
			OI_number	title_size_x();
			OI_number	title_size_y();
		virtual	void		toggle_main_menu(OI_d_tech*, const XEvent*, const char* const *, unsigned int *);
			OI_bool		trigger(OI_number b, OI_number m) ;
		virtual	void		unparent() ;
		virtual	void		unpin(OI_d_tech* =NULL, const XEvent* =NULL, const char* const * =NULL, unsigned int* =NULL) ;	/* unpin menu */
			void		unpin_del() ;						/* delete an unpinned menu */
		virtual	void		unpopup() ;
		virtual	void		xlower() ;
		virtual	void		xmap() ;
		virtual	void		xmapraised() ;
		virtual	void		xraise() ;
		virtual	void		xunmap() ;
 		virtual	void		activate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		deactivate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		deactivate_all(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		menu_key(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			void		take_down_non_persistent();
			void		outside_event(const XEvent *, void *);			/* func to process event from "outside" window */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;		/* chk if object is suitable as child */
		virtual	OI_stat		set_state(OI_state) ;				/* change state */
	virtual const char		*wm_name();					/* string for WM_NAME property */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		add_cell(OI_menu_cell*, OI_number, OI_bool=OI_yes) = 0 ;	/* add a cell to a menu */
		virtual	void		allow_cell_outline() ;				/* paint cell outline when not selected */
		virtual	void		allow_persistent() ;
		virtual	void		allow_pushpin() ;
			void		allow_tearoff()				{ allow_pushpin(); }
		virtual	OI_number	cell_number(const char *) = 0 ;
		virtual	OI_menu_cell	*default_cell()	= 0 ;
		virtual	void		disallow_cell_outline() ;			/* don't paint cell outline when not selected */
		virtual	void		disallow_persistent() ;
		virtual	void		disallow_pushpin() ;
			void		disallow_tearoff()			{ disallow_pushpin(); }
		virtual	OI_bool		is_cell_outline() ;
		virtual	OI_bool		is_persistent() ;
		virtual	OI_bool		is_pinned() ;
			OI_bool		is_torn_off()				{ return (is_pinned()); }
		virtual	OI_bool		is_pushpin() ;
			OI_bool		is_tearoff()				{ return(is_pushpin()); }
			OI_number	label_right_space()		{return(lbl_right_space);}
			OI_number	menu_trigger()			{return(mnu_trg);}
			OI_number	menu_trigger_mods()		{return(mnu_trg_mods);}
		virtual	OI_menu_cell	**multi_selected(OI_number* =NULL) = 0 ;	/* get ptr to list of selected cells */
		virtual	OI_menu_cell	*next_selection(OI_menu_cell*) = 0 ;
		virtual	OI_number	num_cells() = 0 ;
		virtual	OI_number	num_default_cell() = 0 ;
		virtual	OI_number	*num_multi_selected(OI_number*) = 0 ;		/* get ptr to list of numbers of selected cells */
		virtual	OI_stat		num_select(OI_bool, OI_number, OI_bool=OI_yes) = 0 ;		/* set numbered cell on/off */
		virtual	OI_number	num_selected() = 0 ;
		virtual	OI_stat		num_set_default_cell(OI_number) = 0 ;
		virtual	OI_menu_cell	*numbered_cell(OI_number) = 0 ;
		virtual	OI_orient	orientation() ;
			void		popup_loc(long *xp, long*yp) ;
			long		popup_loc_x()			{ return(popup_org.x); }
			long		popup_loc_y()			{ return(popup_org.y); }
		virtual	OI_stat		select(OI_bool, const char*, OI_bool=OI_yes) = 0 ;			/* set named cell on/off */
		virtual	OI_menu_cell	*selected() = 0 ;
		virtual	OI_stat		set_default_cell(const char*) = 0 ;			/* setup cell as default */
			void		set_label_right_space(OI_number);
		virtual	void		set_menu_end(OI_menu_end_fnp fp, void *argp = NULL) ;
		virtual	void		set_menu_end(OI_callback *objp, OI_menu_end_memfnp mfp, void *argp = NULL) ;
			OI_stat		set_menu_trigger(OI_number, OI_number=0) ;
			void		set_pin(OI_pin_fnp, void* =NULL) ;
			void		set_pin(OI_callback*, OI_pin_memfnp, void * =NULL) ;
		virtual	void		set_pre_popup(OI_pre_popup_fnp, void* =NULL) ;
		virtual	void		set_pre_popup(OI_callback*, OI_pre_popup_memfnp, void * =NULL) ;
		virtual	void		set_tab_width(OI_number) ;
		virtual	void		set_tabs_custom(OI_number *, OI_number, OI_number =8) ;
			void		set_title(const char *title);
		virtual	OI_stat		set_trigger(OI_number, OI_number=0) ;
			void		set_unpin(OI_pin_fnp, void* =NULL) ;
			void		set_unpin(OI_callback*, OI_pin_memfnp, void * =NULL) ;
			void		set_wrap_limit(OI_number);
		virtual	char		*title() ;
			OI_number	trigger()			{return(trg);}
			OI_number	trigger_mods()			{return(trg_mods);}
			OI_number	wrap_limit()			{return(wrap_lmt); }
	};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

	OI_menu_cell **oi_setup_cells(OI_number*, OI_cell_spec*, OI_menu_cell**, OI_number=0) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_mnu_H */
