/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lmwrap.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_layout_wrapped_* class header
 *
 *	RCSid = "$Id: lmwrap.H,v 4.14.1.1 1993/06/01 22:55:23 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lmwrap_H
#define OI_lmwrap_H

#ifndef OI_lmrc_H
#include <OI/lmrc.H>
#endif /* OI_lmrc_H */

/******************************
 *	wrapped_row
 ******************************/

		class	OI_lm_wrapped_row_box : public OI_lm_col_box	{				/* wrapped_row major row item */
		 public:
						OI_lm_wrapped_row_box();
		virtual				~OI_lm_wrapped_row_box() ;
		virtual	void			insert_slot(OI_number,OI_lm_box*,OI_lm_glue* =NULL,OI_lm_glue* =NULL) ;
		virtual	OI_lm_box		*next_box(const OI_layout_slot*) const ;
		virtual	OI_lm_box		*prev_box(const OI_layout_slot*) const ;
		} ;

 /* OI_lm_wrapped_* private control bits */
#define		OI_LM_NEEDS_WRAP		0x1							/* 1 => needs to be re-wrapped */
#define		OI_LM_NEEDS_SPACE		0x2							/* 1 => needs to be re-mini-spaced */

		class	OI_lm_wrapped_row : public OI_lm_row	{					/* wrapped row layout method */
			unsigned short		ctl_bits ;						/* control bits */
			OI_number		nwrap ;							/* # of items before a wrap is needed */
			OI_number		wrap_sp ;						/* spacing between wrapped mini-rows */
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
		 protected:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_wrapped_row(OI_d_tech *dtp) ;
		virtual				~OI_lm_wrapped_row() ;
			void			clear_needs_respace()	{ ctl_bits &= ~OI_LM_NEEDS_SPACE; }
			void			clear_needs_rewrap()	{ ctl_bits &= ~OI_LM_NEEDS_WRAP; }
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
			OI_bool			needs_respace() const	{ return((ctl_bits & OI_LM_NEEDS_SPACE) ? OI_YES : OI_NO); }
			OI_bool			needs_rewrap() const	{ return((ctl_bits & OI_LM_NEEDS_WRAP) ? OI_YES : OI_NO); }
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const ;
			void			rewrap() ;
			void			set_needs_respace()	{ ctl_bits |= OI_LM_NEEDS_SPACE; }
			void			set_needs_rewrap()	{ ctl_bits |= OI_LM_NEEDS_WRAP; }
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	void			force_layout() ;
		virtual	void			remove(OI_d_tech *) ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			set_wrap(OI_number) ;
			void			set_wrap_space(OI_number) ;
			OI_number		wrap_num() const	{ return(nwrap); }
			OI_number		wrap_space() const	{ return(wrap_sp); }
		} ;

/******************************
 *	wrapped_column
 ******************************/

		class	OI_lm_wrapped_column_box : public OI_lm_row_box	{				/* wrapped_column major row item */
		 public:
						OI_lm_wrapped_column_box();
		virtual				~OI_lm_wrapped_column_box() ;
		virtual	void			insert_slot(OI_number,OI_lm_box*,OI_lm_glue* =NULL,OI_lm_glue* =NULL) ;
		virtual	OI_lm_box		*next_box(const OI_layout_slot*)  const;
		virtual	OI_lm_box		*prev_box(const OI_layout_slot*)  const;
		} ;

		class	OI_lm_wrapped_column : public OI_lm_column	{				/* wrapped column layout method */
			unsigned short		ctl_bits ;						/* control bits */
			OI_number		nwrap ;							/* # of items before a wrap is needed */
			OI_number		wrap_sp ;						/* spacing between wrapped mini-columns */
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
		 protected:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_wrapped_column(OI_d_tech *dtp) ;
		virtual				~OI_lm_wrapped_column() ;
			void			clear_needs_respace()	{ ctl_bits &= ~OI_LM_NEEDS_SPACE; }
			void			clear_needs_rewrap()	{ ctl_bits &= ~OI_LM_NEEDS_WRAP; }
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
			OI_bool			needs_respace() const	{ return((ctl_bits & OI_LM_NEEDS_SPACE) ? OI_YES : OI_NO); }
			OI_bool			needs_rewrap() const	{ return((ctl_bits & OI_LM_NEEDS_WRAP) ? OI_YES : OI_NO); }
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const ;
			void			rewrap() ;
			void			set_needs_respace()	{ ctl_bits |= OI_LM_NEEDS_SPACE; }
			void			set_needs_rewrap()	{ ctl_bits |= OI_LM_NEEDS_WRAP; }
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	void			force_layout() ;
		virtual	void			remove(OI_d_tech *) ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
			void			set_wrap(OI_number) ;
			void			set_wrap_space(OI_number) ;
			OI_number		wrap_num() const	{ return(nwrap); }
			OI_number		wrap_space() const	{ return(wrap_sp); }
		} ;

#endif /* OI_lmwrap_H */
