/*
 * smore.C -- Demo program like more, but with an OI front end.
 */

/*
 *	smore is a simple more program that uses scroll text, menus
 * and entry_fields.  Simply type a filename into the entry field, and
 * the scroll text will be updated to display that filename (if
 * possible) or return an error message (if not).
 *
 *	The scroll text is a size tracking object, so it will respond
 * correctly to all resize events.  The entry field is also a size
 * tracker, and will respond as well.
 *
 * Functions used:
 *
 *	OI_intro (3O)
 *		OI_begin_interaction()
 *		OI_end_interaction()
 *		OI_fini()
 *		OI_init()
 *		OI_translate_filename()
 *	OI_app_window (3O)
 *		set_main_menu()
 *	OI_button_menu (3O)
 *	OI_d_tech (3O)
 *		descendant()
 *		layout_associated_object()
 *		push_help_str()
 *		root()
 *		set_associated_object()
 *		set_layout()
 *		set_size_track()
 *	OI_entry_field (3O)
 *		part_text()
 *		set_entry_check()
 *			OI_EF_ENTRY_CHK_OK
 *			OI_EF_ENTRY_CHK_BAD
 *		set_text()
 *	OI_multi_text (3O)
 *		set_text_to_file()
 *	OI_scroll_text (3O)
 *		disallow_kb_input()
 *
 * Object tree
 *	topLevel (app_window)
 *		mainMenu (button_menu)
 *		fileEF (entry_field)
 *		fileWindow (scroll_text)
 */

/* Header Files */

# include <OI/oi.H>

/* Macro Definitions */

#define FILE_EF_NAME "fileEF"
#define SCROLL_TEXT_NAME "fileWindow"

/* Variable Definitions */

static	OI_cell_spec	menu1[] =
{
	{NULL,"Exit",(OI_action_fnp)&OI_end_interaction},
};

/* Function Declarations */

OI_ef_entry_chk_status new_file (OI_entry_field *efp, void *)
{
	OI_scroll_text *text = (OI_scroll_text *) efp->root ()->descendant (SCROLL_TEXT_NAME);
	char buffer[1024];
	
	if (text->set_text_to_file (efp->part_text ()) != OI_OK) {
		sprintf (buffer, "Unable to display %s", efp->part_text ());
		text->push_help_str (buffer);
		return OI_EF_ENTRY_CHK_BAD;
	}

	efp->set_text (OI_translate_filename (efp->part_text ()), OI_NO);
	return OI_EF_ENTRY_CHK_OK;
}

int main(int argc, char *argv[])
{
	OI_connection  *conp;
	OI_app_window  *top_level;
	OI_button_menu *menup;
	OI_entry_field *efp;
	OI_scroll_text *text;
	
	/*
	 * Open a connection.
	 */
	if (conp = OI_init (&argc, argv, "More Demo Program"))
	{
		/*
		 * Create the OI_tests main window.  Make it row layout.
		 */
		top_level = oi_create_app_window("topLevel",1,1,"smore");
		top_level->set_layout (OI_layout_row);

		/*
		 * Create menu (two button) and associate to the main window.  Also, make this a main menu for motif.
		 */
		menup = oi_create_button_menu ("mainMenu", OI_n_cells(menu1), &menu1[0], OI_HORIZONTAL, NULL);
		top_level->set_main_menu (menup);

		/*
		 * Create me a text field on top of a entry field. Make it a size tracker and put at top of window.
		 */
		efp = oi_create_entry_field (FILE_EF_NAME, 80, "File to view:", "", 1024);
		efp->set_size_track (OI_size_track_horizontal);
		efp->set_entry_chk (&new_file);
		efp->layout_associated_object (top_level, 0, 2, OI_ACTIVE);
		
		/*
		 * Now we create a scroll box.  Make it readonly.  If there was a command line arg,
		 * Then assume that it was a filename and try to set the text of the scroll text to
		 * filename.
		 */
		text = oi_create_scroll_text (SCROLL_TEXT_NAME, OI_SCROLL_BAR_LEFT | OI_SCROLL_BAR_TOP, 25, 80, 0, 0);
		text->disallow_kb_input();
		if (argc > 1) {
			if (text->set_text_to_file (argv[1]) == OI_OK)
				efp->set_text (OI_translate_filename (argv[1]), OI_NO);
		}
		text->set_size_track (OI_size_track_full);
		text->layout_associated_object (top_level, 0, 3, OI_ACTIVE);

		/*
		 * Setup mouseless movement between objects
		 */
		efp->set_next (text);
		text->set_next (efp);

		/*
		 * OK, display main window.
		 */
		top_level->set_associated_object(top_level->root(),OI_DEF_LOC, OI_DEF_LOC,OI_ACTIVE);
		OI_begin_interaction();
	}

	/*
	 * Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini();
	return( 0 );
}
