//
//  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
//  Copyright (c) 1988, 1989, 1990  John Stanback
//
//  Project:    OS/2 PM Port of GNU CHESS 4.0 (PmChess)
//
//  Version:    1994-4-17
//
//   Porter:    Ported to Windows 3.0 by Darly Baker
//
//   Porter:    Ported to OS/2 1.2+ by Kent Cedola
//
//   Porter:    Revised and ported to OS/2 2.1 by Yibing Fan
//
//   System:    OS2 2.1 using emx0.8g 
////
//  Remarks:    This code converted from Windows to PM using a straight port
//              method with some editing improvements.  Some of the logic
//              required for poor old Windows has been removed since super-
//              duper OS/2 is better with memory...
//
//  Fuctions defined in this module:
//      Initialize_dist (void)
//      Initialize_moves (void)
//      int init_main (HWND hWnd)
//      void NewGame (HWND hWnd)
//
//  License:
//
//    CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
//    WARRANTY.  No author or distributor accepts responsibility to anyone for
//    the consequences of using it or for whether it serves any particular
//    purpose or works at all, unless he says so in writing.  Refer to the
//    CHESS General Public License for full details.
//
//    Everyone is granted permission to copy, modify and redistribute CHESS,
//    but only under the conditions described in the CHESS General Public
//    License.  A copy of this license is supposed to have been given to you
//    along with CHESS so you can know your rights and responsibilities.  It
//    should be in a file named COPYING.  Among other things, the copyright
//    notice and this notice must be preserved on all copies.
//

#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "PmChess.h"
#include "GnuChess.h"
#include "Defs.h"


extern HWND hStats;

extern short   distdata[64][64],   taxidata[64][64];

extern FILE *hashfile;
extern short stage, stage2, Developed[2];
extern short ChkFlag[MAXDEPTH], CptrFlag[MAXDEPTH], PawnThreat[MAXDEPTH];
extern short Pscore[MAXDEPTH], Tscore[MAXDEPTH];
extern short rehash, BAwindow, BBwindow, WAwindow, WBwindow;
extern long  Level;
extern unsigned int TTadd;
unsigned int ttbllimit;

extern int UseBook;
extern struct hashval   hashcode[2][7][64];

//extern unsigned char   * history;

extern short board[64], color[64];

extern unsigned char   nextpos[8][64][64];
extern unsigned char   nextdir[8][64][64];
/*
  ptype is used to separate white and black pawns, like this;
  ptyp = ptype[side][piece]
  piece can be used directly in nextpos/nextdir when generating moves
  for pieces that are not black pawns.
*/
const short ptype[2][8] =
{
  {no_piece, pawn, knight, bishop, rook, queen, king, no_piece},
  {no_piece, bpawn, knight, bishop, rook, queen, king, no_piece}};

static short direc[8][8] =
{
  {0, 0, 0, 0, 0, 0, 0, 0},
  {10, 9, 11, 0, 0, 0, 0, 0},
  {8, -8, 12, -12, 19, -19, 21, -21},
  {9, 11, -9, -11, 0, 0, 0, 0},
  {1, 10, -1, -10, 0, 0, 0, 0},
  {1, 10, -1, -10, 9, 11, -9, -11},
  {1, 10, -1, -10, 9, 11, -9, -11},
  {-10, -9, -11, 0, 0, 0, 0, 0}};

static short max_steps[8] =
{0, 2, 1, 7, 7, 7, 1, 2};

static short nunmap[120] =
{
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, 0, 1, 2, 3, 4, 5, 6, 7, -1,
  -1, 8, 9, 10, 11, 12, 13, 14, 15, -1,
  -1, 16, 17, 18, 19, 20, 21, 22, 23, -1,
  -1, 24, 25, 26, 27, 28, 29, 30, 31, -1,
  -1, 32, 33, 34, 35, 36, 37, 38, 39, -1,
  -1, 40, 41, 42, 43, 44, 45, 46, 47, -1,
  -1, 48, 49, 50, 51, 52, 53, 54, 55, -1,
  -1, 56, 57, 58, 59, 60, 61, 62, 63, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

const short Stboard[64] =
{rook, knight, bishop, queen, king, bishop, knight, rook,
 pawn, pawn, pawn, pawn, pawn, pawn, pawn, pawn,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 pawn, pawn, pawn, pawn, pawn, pawn, pawn, pawn,
 rook, knight, bishop, queen, king, bishop, knight, rook};

const short Stcolor[64] =
{white, white, white, white, white, white, white, white,
 white, white, white, white, white, white, white, white,
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
 black, black, black, black, black, black, black, black,
 black, black, black, black, black, black, black, black};

/* given epsquare, from where can a pawn be taken? */
const short epmove1[64] =
{0, 1, 2, 3, 4, 5, 6, 7,
 8, 9, 10, 11, 12, 13, 14, 15,
 16, 24, 25, 26, 27, 28, 29, 30,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39,
 40, 32, 33, 34, 35, 36, 37, 38,
 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 61, 62, 63};
const short epmove2[64] =
{0, 1, 2, 3, 4, 5, 6, 7,
 8, 9, 10, 11, 12, 13, 14, 15,
 25, 26, 27, 28, 29, 30, 31, 23,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39,
 33, 34, 35, 36, 37, 38, 39, 47,
 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 61, 62, 63};

void
Initialize_dist (void)
{
  register short a, b, d, di;

  for (a = 0; a < 64; a++)
    for (b = 0; b < 64; b++)
      {
        d = abs (column (a) - column (b));
        di = abs (row (a) - row (b));
        taxidata[a][b] = d + di;
        distdata[a][b] = (d > di ? d : di);
      }
}

int InitFlag = false;
void
Initialize_moves (void)

/*
  This procedure pre-calculates all moves for every piece from every square.
  This data is stored in nextpos/nextdir and used later in the move generation
  routines.
*/

{
  short ptyp, po, p0, d, di, s, delta;
  unsigned char   *ppos,   *pdir;
  short dest[8][8];
  short steps[8];
  short sorted[8];

  for (ptyp = 0; ptyp < 8; ptyp++)
    for (po = 0; po < 64; po++)
      for (p0 = 0; p0 < 64; p0++)
        {
	  nextpos[ptyp][po][p0] = (UCHAR)po;
	  nextdir[ptyp][po][p0] = (UCHAR)po;
        }
  for (ptyp = 1; ptyp < 8; ptyp++)
    for (po = 21; po < 99; po++)
      if (nunmap[po] >= 0)
        {
	  ppos = nextpos[ptyp][nunmap[po]];
	  pdir = nextdir[ptyp][nunmap[po]];
          /* dest is a function of direction and steps */
          for (d = 0; d < 8; d++)
            {
              dest[d][0] = nunmap[po];
              delta = direc[ptyp][d];
              if (delta != 0)
                {
                  p0 = po;
                  for (s = 0; s < max_steps[ptyp]; s++)
                    {
                      p0 = p0 + delta;
                      /*
                        break if (off board) or
                        (pawns only move two steps from home square)
                      */
                      if (nunmap[p0] < 0 || ((ptyp == pawn || ptyp == bpawn)
                          && s > 0 && (d > 0 || Stboard[nunmap[po]] != pawn)))
                        break;
                      else
                        dest[d][s] = nunmap[p0];
                    }
                }
              else
                s = 0;

              /*
                sort dest in number of steps order
                currently no sort is done due to compability with
                the move generation order in old gnu chess
              */
              steps[d] = s;
              for (di = d; s > 0 && di > 0; di--)
                if (steps[sorted[di - 1]] == 0) /* should be: < s */
                  sorted[di] = sorted[di - 1];
                else
                  break;
              sorted[di] = d;
            }

          /*
            update nextpos/nextdir,
            pawns have two threads (capture and no capture)
          */
          p0 = nunmap[po];
          if (ptyp == pawn || ptyp == bpawn)
            {
              for (s = 0; s < steps[0]; s++)
                {
                  ppos[p0] = (unsigned char) dest[0][s];
                  p0 = dest[0][s];
                }
              p0 = nunmap[po];
              for (d = 1; d < 3; d++)
                {
                  pdir[p0] = (unsigned char) dest[d][0];
                  p0 = dest[d][0];
                }
            }
          else
            {
              pdir[p0] = (unsigned char) dest[sorted[0]][0];
              for (d = 0; d < 8; d++)
                for (s = 0; s < steps[sorted[d]]; s++)
                  {
                    ppos[p0] = (unsigned char) dest[sorted[d]][s];
                    p0 = dest[sorted[d]][s];
                    if (d < 7)
                      pdir[p0] = (unsigned char) dest[sorted[d + 1]][0];
                    /* else is already initialized */
                  }
            }
        }
}


/* hmm.... shouldn`t main be moved to the interface routines */
int init_main (HWND hWnd)
{
  short int ahead = true, hash = true;
  CHAR *Lang=NULL;
  Level = 0;
  TCflag = false;
  OperatorTime = 0;
  Initialize ();
  InitConst (Lang);
  Initialize_dist ();
  Initialize_moves ();
  NewGame (hWnd);

  flag.easy = ahead;
  flag.hash = hash;
  hashfile = NULL;
  return (0);
}


void NewGame (HWND hWnd)

/*
  Reset the board and other variables to start a new game.
*/

{
  short l, c, p;
  compptr = oppptr = 0;

  stage = stage2 = -1;          /* the game is not yet started */

  if ( flag.post ) {
      WinSendMsg(hStats, WM_SYSCOMMAND, MPFROMSHORT(SC_CLOSE), 0);
      flag.post = false;
  }

  flag.mate = flag.quit = flag.reverse = flag.bothsides = false;
  flag.force = false;
  flag.hash = flag.easy = flag.beep = flag.rcptr = true;
  NodeCnt = et0 = epsquare = 0;
  dither = 0;
  WAwindow = 90;
  WBwindow = 90;
  BAwindow = 90;
  BBwindow = 90;
  xwndw = 90;
  MaxSearchDepth = 29;
  contempt = 0;
  GameCnt = 0;
  Game50 = 1;
  hint = 0x0C14;
  ZeroRPT ();
  Developed[white] = Developed[black] = false;
  castld[white] = castld[black] = false;
  PawnThreat[0] = CptrFlag[0] = false;
  Pscore[0] = 12000;
  Tscore[0] = 12000;
  opponent = white;
  computer = black;
  for (l = 0; l < 2000; l++)
      Tree[l].f = Tree[l].t = 0;
  srand ((unsigned int) 1);
  if (!InitFlag)
    {
  for (c = white; c <= black; c++)
    for (p = pawn; p <= king; p++)
      for (l = 0; l < 64; l++)
        {
	  hashcode[c][p][l].key = (((unsigned long) urand ()));
	  hashcode[c][p][l].key += (((unsigned long) urand ()) << 16);
	  hashcode[c][p][l].bd = (((unsigned long) urand ()));
	  hashcode[c][p][l].bd += (((unsigned long) urand ()) << 16);
        }
     }
  for (l = 0; l < 64; l++)
    {
      board[l] = Stboard[l];
      color[l] = Stcolor[l];
      Mvboard[l] = 0;
    }
  InitializeStats ();
  time0 = time ((long *) 0);
  ElapsedTime (1);
  flag.regularstart = true;
  if (UseBook) { Book = BOOKFAIL; }
          else { Book = 0; } 
          /* endif */

  if (!InitFlag)
    {
      if (TCflag) SetTimeControl ();
      else if (MaxResponseTime == 0)
      {
        OperatorTime = 1;
        TCmoves = 60;
        TCminutes = 5;
        TCflag = (TCmoves > 1);
        SetTimeControl ();
      }

      UpdateDisplay (hWnd, 0, 0, 1, 0);
      GetOpenings ( hWnd);
      Initialize_ttable();
      InitFlag = true;
    }
  if(TTadd){ZeroTTable (); TTadd = 0;}
}

#ifdef ttblsz

void Initialize_ttable ()
{
  int doit = true;
  if (rehash < 0) rehash = MAXrehash;
while(doit && ttblsize > MINTTABLE){
  ttable[0] = (struct hashentry *)malloc((unsigned)(sizeof(struct hashentry)*(ttblsize+rehash)));
  ttable[1] = (struct hashentry *)malloc((unsigned)(sizeof(struct hashentry)*(ttblsize+rehash)));
  if(ttable[0] == NULL || ttable[1] == NULL){
  if(ttable[0] != NULL)free(ttable[0]);
  ttblsize = ttblsize>>1;
  } else doit = false;
}
  if(ttable[0] == NULL || ttable[1] == NULL){ perror("memory alloc");exit(1);}
/*
  printf("transposition table is %d\n",ttblsize);
*/
  ttbllimit = (ttblsize<<1) - (ttblsize>>2);
}

#endif /* ttblsz */

void
InitConst (char *lang)
{
  FILE *constfile;
  char s[256];
  char sl[5];
  int len, entry;
  char *p, *q;
  constfile = fopen (LANGFILE, "r");
  if (!constfile)
    {
      printf ("NO LANGFILE\n");
      exit (1);
    }
  while (fgets (s, sizeof (s), constfile))
    {
      if (s[0] == '!')
	continue;
      len = strlen (s);
      for (q = &s[len]; q > &s[8]; q--)
	if (*q == '}')
	  break;
      if (q == &s[8])
	{
	  printf ("{ error in cinstfile\n");
	  exit (1);
	}
      *q = '\0';
      if (s[3] != ':' || s[7] != ':' || s[8] != '{')
	{
	  printf ("Langfile format error %s\n", s);
	  exit (1);
	}
      s[3] = s[7] = '\0';
      if (lang == NULL)
	{
	  lang = sl;
	  strcpy (sl, &s[4]);
	}
      if (strcmp (&s[4], lang))
	continue;
      entry = atoi (s);
      if (entry < 0 || entry >= CPSIZE)
	{
	  printf ("Langfile number error\n");
	  exit (1);
	}
      for (q = p = &s[9]; *p; p++)
	{
	  if (*p != '\\')
	    {
	      *q++ = *p;
	    }
	  else if (*(p + 1) == 'n')
	    {
	      *q++ = '\n';
	      p++;
	    }
	}
      *q = '\0';
      if (entry < 0 || entry > 255)
	{
	  printf ("Langfile error %d\n", entry);
	  exit (0);
	}
      CP[entry] = (char *) malloc ((unsigned) strlen (&s[9]) + 1);
      if (CP[entry] == NULL)
	{
	  perror ("malloc");
	  exit (0);
	}
      strcpy (CP[entry], &s[9]);

    }
  fclose (constfile);
}
