/****	Command processing	****/

/*	Copyright (C) 1989, 1990 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */

#include "common.h"
#include <sys/types.h>
#include "cmd.h"
#include <ctype.h>



#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 3  20-Feb-89	M. A. Patton	First release version.
 3A  1-Aug-89	M. A. Patton	NULL now redundant.
 3B 10-Feb-90	M. A. Patton	Added initialization in DoCommand to get past
				compiler warnings, committed a neatness.
 3C  6-Mar-90	M. A. Patton	Added more of above (missed one).
 5  14-Jun-90	M. A. Patton	Added arg for functions.

#endif
/****	Helper routine to do search down a command table.	****/



static char *
MatchCommand(str,cmd)
register char *str, *cmd;
{   while (*cmd != '\0')
    {	if (upcase(*cmd) != upcase(*str))
	{   if ((*str == '\0') || (isspace(*str)))
		return (str);
	    return (NULL);
	}
	cmd++;
	str++;
    }
    if ((*str == '\0') || (isspace(*str)))
	return (str);
    return(NULL);
}
/****	Main routine called to act on a command.	****/



int
DoCommand(inp,tbl)
char *inp;
CmdTable *tbl;
{   CmdTable *mtch = NULL;
    char *rest = NULL;

    while (isspace(*inp))
	inp++;
    while (tbl->cmd != NULL)
    {	char *temp;
	if ((temp=MatchCommand(inp,tbl->cmd)) != NULL)
	{   if (mtch != NULL)
		return(FALSE);
	    mtch = tbl;
	    rest = temp;
	}
	tbl++;
    }
    if (mtch == NULL)
	return (FALSE);
    (*(mtch->func))(mtch->arg, rest);
    return (TRUE);
}
