/*

MET2.C - Reads in metafiles, regardless of whether they have
         a placeable header.
         (C) 1993, Dennis Chuah

*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <metafile.h>


HMETAFILE WINAPI GetMetaFileBetter (LPCSTR path, METAFILEHEADER far *lpMh)
  {HFILE hFile;
   long filelen, read;
   HMETAFILE hMetafile;
   METAFILEHEADER mh;
   HGLOBAL handle;
   void huge *hpVoid;

   /* Open disk metafile */
   hFile = _lopen (path, READ);
   if (hFile == HFILE_ERROR) return NULL;

   /* Find the size of the metafile */
   filelen = _llseek (hFile, 0L, 2);
   if (filelen == HFILE_ERROR)
     {_lclose (hFile);
      return NULL;
     }
   if (_llseek (hFile, 0L, 0) == HFILE_ERROR)
     {_lclose (hFile);
      return NULL;
     }

   /* See if it is a placeable metafile */
   read = _lread (hFile, &mh, sizeof (METAFILEHEADER));
   if (read < sizeof (METAFILEHEADER) || read == HFILE_ERROR)
     {_lclose (hFile);
      return NULL;
     }
   if (mh.key != 0x9AC6CDD7L)
     {_lclose (hFile);	// If it is, use GetMetaFile
      return GetMetaFile (path);
     } // endif

   /* Read the rest of the file in and convert to a HMETAFILE */
   filelen -= sizeof (METAFILEHEADER);
   hpVoid = GlobalAllocPtr (GHND, filelen);
   if (hpVoid == NULL)
     {_lclose (hFile);
      return NULL;
     } // endif
   read = _hread (hFile, hpVoid, filelen);
   if (read == -1 || read < filelen)
     {(void) GlobalFreePtr (hpVoid);
      _lclose (hFile);
      return NULL;
     } // endif
   handle = GlobalPtrHandle (hpVoid);
   hMetafile = (HMETAFILE) SetMetaFileBitsBetter ((HMETAFILE) handle);
   /* Note: don't need to free memory as that will be done by
      DeleteMetaFile -- see SetMetaFileBits docs */

   /* If supplied placeable metafile header is valid, return header
      information */
   if (!IsBadHugeReadPtr (lpMh, sizeof (METAFILEHEADER)))
     {hmemcpy (lpMh, &mh, sizeof (METAFILEHEADER));
     } // endif

   _lclose (hFile);
   return hMetafile;
  } // end GetMetafileBetter

