<%@ Import Namespace="System.Runtime.InteropServices" %>

<script language="vb" runat="server">
   ' --------------------------------------------------------------------------------
   ' Sample web page to generate and update TreeGrid data, using TreeGrid.dll
   ' This is a simple version of the SrcPage.aspx without caching, loging and tmp files deleting
   ' This is version in Visual Basic
   ' This page can be used as data source for examples, use Examples/Main/Examples.html?src=../AspNet/VBAjaxDLLServerPageSimple.aspx
   ' TreeGrid.dll must be placed in the ../../Server/ directory, or the path must be changed in Init() function
   ' Uses data from ../Data/ directory, or the path must be changed in Init() function
   ' Shows server paging features
   ' --------------------------------------------------------------------------------
   Private Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs)
      RunInit()
   End Sub
   ' ----------------------------------------------------------------------------------------------------
   Private Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs)
      Try
         Dim F As String : F = Request.Params("Function")
         If F = "LoadBody" Then
            Response.Write(FuncLoadBody(Request.Params("File"), Request.Params("Def"), Request.Params("Data"), Request.Params("Bonus")))
         ElseIf F = "LoadPage" Then
            Response.Write(FuncLoadPage(Request.Params("File"), Request.Params("Def"), Request.Params("Data"), Request.Params("Bonus")))
         ElseIf F = "Save" Then
            Response.Write(FuncSave(Request.Params("File"), Request.Params("Def"), Request.Params("Data"), Request.Params("Bonus")))
         Else
            Response.Write(GetError(-3, "Wrong function requested"))
         End If
      Catch ex As Exception
         Response.Write(GetError(-3, ex.Message))
      End Try
   End Sub
   ' ----------------------------------------------------------------------------------------------------
   
   ' ----------------------------------------------------------------------------------------------------
   ' Inicialization and TreeGrid.dll loading
   Private Sub RunInit()
      Path = System.IO.Path.GetDirectoryName(Context.Request.PhysicalPath) + "\\"
      Loaded = Not LoadLibrary(Path + "..\\..\\Server\\TreeGrid.dll").Equals(IntPtr.Zero)
      Path = Path + "..\\ServerDLL\\"
   End Sub
   ' ----------------------------------------------------------------------------------------------------
   Private Path As String     ' Path to data directory
   Private Loaded As Boolean  ' If DLL successfuly loaded
   ' ----------------------------------------------------------------------------------------------------
   ' TreeGrid.dll import
   Declare Auto Function LoadLibrary Lib "kernel32.dll" (ByVal lpFileName As String) As IntPtr
   Declare Unicode Function CreateGrid Lib "TreeGrid.dll" (ByVal Data As String, ByVal Layout As String, ByVal Defaults As String, ByVal Text As String, ByVal Bonus As String, ByVal Bonus2 As String) As Integer
   Declare Unicode Function UpdateGrid Lib "TreeGrid.dll" (ByVal Index As Integer, ByVal Bonus As String) As Integer
   Declare Unicode Function FindGrid Lib "TreeGrid.dll" (ByVal Cfg As String) As Integer
   Declare Unicode Function DeleteGrid Lib "TreeGrid.dll" (ByVal Index As Integer) As Integer
   Declare Unicode Sub Clear Lib "TreeGrid.dll" ()
   Declare Unicode Function GetBody Lib "TreeGrid.dll" (ByVal Index As Integer, ByVal Cfg As String) As String
   Declare Unicode Function GetPage Lib "TreeGrid.dll" (ByVal Index As Integer, ByVal Cfg As String) As String
   Declare Unicode Function Save Lib "TreeGrid.dll" (ByVal Index As Integer, ByVal Input As String) As Integer
   Declare Unicode Function SaveToFile Lib "TreeGrid.dll" (ByVal Index As Integer, ByVal FileName As String, ByVal Type As Integer) As Integer
   Declare Unicode Function LastError Lib "TreeGrid.dll" () As String
   ' ----------------------------------------------------------------------------------------------------
   ' Returns Xml with given error message
   Private Function GetError(ByVal num As Integer, ByVal mess As String) As String
      Dim Err As String : Err = LastError()
      If Err <> Nothing And Err <> "" Then mess = mess + "&#x0A;&#x0A;" + Err.Replace("&", "&amp;").Replace("<", "&lt;").Replace("""", "&quot;")
      Return "<Grid><IO Result='" + num.ToString() + "' Message=""" + mess + """/></Grid>"
   End Function
   ' ----------------------------------------------------------------------------------------------------
   ' Returns Grids index for given file or <0 for error
   Private Function GetIndex(ByVal File As String, ByVal Def As String, ByVal Cfg As String, ByVal Bonus As String) As Integer
      If File = "" Then Return -1
      Dim Index As Integer
      Index = FindGrid(Cfg)
      If Index >= 0 Then
         UpdateGrid(Index, Bonus)
         Return Index
      End If
      Dim ID As String : ID = Context.Request.ServerVariables("REMOTE_HOST").Replace(":", "_") + File
      If System.IO.File.Exists(Path + "tmp\\" + ID) Then
         Return CreateGrid(Path + "tmp\\" + ID, Path + Def, Path + "..\\..\\Grid\\Defaults.xml", Path + "..\\..\\Grid\\Text.xml", Bonus, Nothing)
      Else
         Return CreateGrid(Path + File, Path + Def, Path + "..\\..\\Grid\\Defaults.xml", Path + "..\\..\\Grid\\Text.xml", Bonus, Nothing)
      End If
      
   End Function
   ' ----------------------------------------------------------------------------------------------------
   ' Returns grid data, for Paging==3 returns only empty pages with information about their content
   ' Data contains XML with grid settings - sorting and filters
   Private Function FuncLoadBody(ByVal File As String, ByVal Def As String, ByVal Data As String, ByVal Bonus As String) As String
      If Loaded = False Then Return GetError(-5, "TreeGrid.dll not found")
      Dim Index As Integer : Index = GetIndex(File, Def, Data, Bonus)
      If Index < 0 Then Return GetError(-1, "Server DLL Error: TreeGrid data not found or server has not permission to read them&#x0A;Data are located at /Examples/ServerDLL/")
      Dim Ret As String : Ret = GetBody(Index, Data)
      If Ret Is Nothing Then Return GetError(-4, "Server DLL Error: TreeGrid data cannot be loaded")
      Dim ID As String : ID = Context.Request.ServerVariables("REMOTE_HOST").Replace(":", "_") + File
      SaveToFile(Index, Path + "tmp\\" + ID, 0)
      Return Ret
   End Function
   ' ----------------------------------------------------------------------------------------------------
   ' Returns children of one page or one row
   ' Data contains XML with page index or row id and grid settings - sorting and filters
   Private Function FuncLoadPage(ByVal File As String, ByVal Def As String, ByVal Data As String, ByVal Bonus As String) As String
      If Loaded = False Then Return GetError(-5, "TreeGrid.dll not found")
      Dim Index As Integer : Index = GetIndex(File, Def, Data, Bonus)
      If Index < 0 Then Return GetError(-1, "Server DLL Error: TreeGrid data not found")
      Dim Ret As String : Ret = GetPage(Index, Data)
      If Ret Is Nothing Then Return GetError(-3, "Server DLL Error: Configuration changed, you need to reload grid!")
      Return Ret
   End Function
   ' ----------------------------------------------------------------------------------------------------
   ' Saves changed data to XML file
   ' Data contains XML with changed rows
   Private Function FuncSave(ByVal File As String, ByVal Def As String, ByVal Data As String, ByVal Bonus As String) As String
      If Loaded = False Then Return GetError(-5, "TreeGrid.dll not found")
      Dim Index As Integer : Index = GetIndex(File, Def, Data, Bonus)
      If Index < 0 Then Return GetError(-1, "Server DLL Error: TreeGrid data not found")
      Dim Ret As Integer : Ret = Save(Index, Data)
      If Ret < 0 Then Return GetError(Ret, "Server DLL Error: Changes were not saved")
      If Ret > 0 Then Return GetError(0, "Server DLL Warning: Not all data were successfully saved !")
      Dim ID As String : ID = Context.Request.ServerVariables("REMOTE_HOST").Replace(":", "_") + File
      SaveToFile(Index, Path + "tmp\\" + ID, 0)
      Return GetError(0, "")
   End Function
   ' ----------------------------------------------------------------------------------------------------
</script>


