/*
    Scriptol Gui using Java
    This may be template for your scriptol-java gui based programs,
    reuse it freely...
    Files used:
    - Path.sol
    - AListen.class
    - IListen.class
    - Java runtime
*/

include "Path.sol"


import

  class java.lang.Object
  /class

  class java.awt.Font
     void Font(string, int, int)
     void setFont(string, int, int)
  /class

  class java.lang.System
     string getProperty(string)
     void exit(int)
  /class

  class java.awt.Label
    void setText(string)
    void setFont(java.awt.Font)
    void setBounds(int, int, int, int)
  /class

  class java.awt.TextField
    void setText(string)
    string getText()
    void setFont(java.awt.Font)
    void setBounds(int, int, int, int)
  /class

  class java.awt.Button
     void setLabel(string)
     void setFont(java.awt.Font)
     void setBounds(int, int, int, int)
  /class


  class java.awt.MenuItem
     void setLabel(string)
     void setFont(java.awt.Font)
  /class

 class java.awt.Menu
    void setLabel(string)
    void setFont(java.awt.Font)
    void add(MenuItem)
    void addSeparator()
 /class

 class java.awt.MenuBar
   void add(Menu)
   void setHelpMenu(Menu);
 /class

 class java.awt.Choice
   void setBounds(int, int, int, int)
   void addItem(string)
   void select(string)
   string getSelectedItem()
 /class

 class java.awt.Frame
    boolean visible
    void setVisible(boolean)
    void setFont(java.awt.Font)
    void setSize(int, int)
    void setLocation(int, int)
    void show()
    void setTitle(text)
    void validate()
    void dispose()
    void add(dyn, dyn = nil)
    void sleep(int)
    void setMenuBar(MenuBar)
 /class

 class java.awt.FileDialog
   void setParent(Frame)
   void setTitle(string)
   void setMode(int)
   void setDirectory(string)
   void show()
   string getFile()
   string getDirectory()
 /class

 class java.awt.Panel
   void setLayout(java.lang.Object)
   void setFont(java.awt.Font)
   void add(java.lang.Object)
 /class

/import

import
 class java AListen        ` class created for events
    int addList(Object)
    int add(MenuItem)
    void setState(int)
    int getState()
    int getCode()
 /class

 class java IListen        ` for item selection
    int addList(Object)
    int add(Choice)
    void setState(int)
    int getState()
    int getCode()
 /class
/import

` these java constants must be defined as Php doesn't recognize static attributes

enum PLAIN, BOLD, ITALIC
enum LOAD, SAVE
enum ACTION_OPEN, ACTION_SAVE, ACTION_EXIT


class UserInterface
   Frame gui              ` main windows
   AListen jd             ` java event listener
   IListen il             ` java item selection listener
   int BUTTON_CLICK
   int BUTTON_EXIT
   int BUTTON_JAVA
   int BUTTON_OS
   int MENU_OPEN
   int MENU_SAVE
   int MENU_EXIT
   int MENU_HELP
   int CHOICE_LIST
   Label lab
   TextField myText
   MenuBar mainMenu
   Font menuFont
   Font textFont
   Menu menuFile
   Choice choiceSquare


   void UserInterface()


     menuFont.setFont("Dialog", PLAIN, 16)
     textFont.setFont("Dialog", PLAIN, 18)

     gui.setTitle("Scriptol Gui Demo with events")
     gui.setSize(400,300)
     gui.setLocation(50,50)
     gui.setMenuBar(mainMenu)

     myText.setText("Hello world of Scriptol programmers!")

     menuFile.setLabel("File")


     // Menu file

     menuFile.setFont(menuFont)

     MenuItem miOpen
     miOpen.setLabel("Open")
     miOpen.setFont(menuFont)
     menuFile.add(miOpen)
     MENU_OPEN = jd.add(miOpen)

     MenuItem miSave
     miSave.setLabel("Save")
     miSave.setFont(menuFont)
     menuFile.add(miSave);
     MENU_SAVE = jd.add(miSave)

     menuFile.addSeparator();
  
     MenuItem miExit
     miExit.setLabel("Exit");
     miExit.setFont(menuFont);
     menuFile.add(miExit);
     MENU_EXIT = jd.add(miExit)

     mainMenu.add(menuFile);

     `` Menu help

     Menu menuHelp
     menuHelp.setLabel("Help")
     menuHelp.setFont(menuFont);
     mainMenu.setHelpMenu(menuHelp);
     mainMenu.add(menuHelp);

     MenuItem miHelp
     miHelp.setLabel("Help")
     miHelp.setFont(menuFont);
     menuHelp.add(miHelp)
     MENU_HELP = jd.add(miHelp)

     `` Window

     Panel myPanel
     myPanel.setLayout(null)
     myPanel.setFont(menuFont)
     gui.add("Center", myPanel)

     Label title
     title.setText("Type some text here:")
     title.setBounds(16,16, 200, 20)
     myPanel.add(title)

     myText.setBounds(16, 40, 250, 24)
     myPanel.add(myText)

     Button bClick
     bClick.setLabel("Click me")
     bClick.setBounds(8, 120, 84, 32)
     myPanel.add(bClick)
     BUTTON_CLICK = jd.add(bClick)

     Button bJava
     bJava.setLabel("Java")
     bJava.setBounds(101, 120, 84, 32)
     myPanel.add(bJava)
     BUTTON_JAVA = jd.add(bJava)

     Button bOs
     bOs.setLabel("Os version")
     bOs.setBounds(192, 120, 100, 32)
     myPanel.add(bOs)
     BUTTON_OS = jd.add(bOs)

     Button bExit
     bExit.setLabel("Exit")
     bExit.setBounds(298, 120, 84, 32)
     myPanel.add(bExit)
     BUTTON_EXIT = jd.add(bExit)

     lab.setBounds(16, 80, 300, 24)
     lab.setFont(textFont)
     myPanel.add(lab)

     choiceSquare.setBounds(32, 180, 48, 22)
     choiceSquare.addItem("3x")
     choiceSquare.addItem("5x")
     choiceSquare.addItem("7x")
     CHOICE_LIST = il.add(choiceSquare)
     myPanel.add(choiceSquare)
     choiceSquare.select("3x")

     gui.validate()

   return

   void show()
       gui.setVisible(true)
   return

   void close()
      gui.dispose()
   return

   void setAction(AListen j)
      jd = j
   return

   void setFrame(Frame f)
      gui = f
   return

   Frame getFrame() return gui
   AListen getAction() return jd
   IListen getItem() return il
   text getText() return myText.getText()

   void setText(text t)
     lab.setText(t)
   return

   void choiceUpdate()
     text t = choiceSquare.getSelectedItem()
     t + " selected"
     lab.setText(t)
   return

/class


` interface to file dialog box

class FileDemo
  text fileName
  text dirName
  text pathName
  text extension
  Frame gui

  void setFrame(Frame f) : gui = f; return
  void setGui(UserInterface ui)
    gui = ui.getFrame()
  return

  boolean loadDialog(text title)
    FileDialog fd
    fd.setParent(gui)
    fd.setTitle(title)
    fd.setMode(LOAD)
    fd.setDirectory(".")
    fd.show()

    fileName  = fd.getFile()
    dirName   = fd.getDirectory()
    pathName  = Path.merge(dirName, fileName)
    extension = Path.getExtension(fileName)
  return fileName != null

  boolean actionOpen()
   if not loadDialog("Load") return false
  return true

  boolean actionSave()
   if not loadDialog("Save") return false
  return true


/class


` main loop

void main()

  UserInterface user
  AListen click
  IListen item
  System infos
  FileDemo filer

  click  = user.getAction()
  item = user.getItem()
  filer.setGui(user)

  user.show()

  int code
  int state
  text prop

  ` select action according to button or menu clicked

  while forever
    state = click.getState()
    if state != 0
      code = click.getCode()
      click.setState(0)
      if code
      = user.BUTTON_EXIT:   break
      = user.BUTTON_CLICK:  user.setText(user.getText())
      = user.BUTTON_JAVA:
                            prop = infos.getProperty("java.version")
                            user.setText("Java " + prop)
      = user.BUTTON_OS:
                            text osname = infos.getProperty("os.name")
                            text osver  = infos.getProperty("os.version")
                            user.setText("OS " + prop + " " + osver)
      = user.MENU_OPEN:
                            filer.actionOpen()
                            user.setText(filer.fileName + " selected for loading");
      = user.MENU_SAVE:
                            filer.actionSave()
                            user.setText(filer.fileName + " selected for saving)");
      = user.MENU_EXIT:     break
      = user.MENU_HELP:     user.setText("Help selected")
      else
        print "unknow command"
      /if
    /if

    state = item.getState()
    if state <> 0
       code = item.getCode()
       item.setState(0)
       if code
       = user.CHOICE_LIST:  user.choiceUpdate()
       /if
    /if

  /while

  user.close()
  infos.exit(0)

return

main()

