` Scriptol examples
` Generic quick sort function
` Using functions as parameters for processing any kind of object
` Similar to genSort with example of class.


` Arguments are copy of the original variables, unless they are "alias",

int compare(dyn a, dyn b)
  if a
  < b: return -1        ` if a < b returns -1
  > b: return 1         ` if a > b returns 1
  /if
return 0   ` if a = b returns 0


` Arguments are aliases here
` aliases are just local names for the original variables

void swapdyn(alias dyn a, alias dyn b)
   dyn temp = a; a = b; b = temp
return


` New types are declared for the use of function as arguments

define COMPFUN = "compare"
define SWAPFUN = "swapdyn"


` The name of the array is an alias for the original array, that is sorted
` two functions are used as parameters

void quickSort(COMPFUN comp, SWAPFUN sw, alias array theArray, int first, int last)
  int f = first
  int l = last
  dyn item = theArray[(f + l) / 2]

  do
    while comp(theArray[f] , item) = -1  let f + 1
    while comp(item , theArray[l]) = -1  let l - 1
    if f <= l
      sw($theArray[f], $theArray[l])
      f + 1
      l - 1
    /if
  /do while f <= l

  if first < l ?  quickSort(comp, sw, theArray, first, l)
  if f < last  ?  quickSort(comp, sw, theArray, f, last)

return


` Defining an new type of objects to be sorted

class demo
  int key
  text value
  void demo(int k, text t)
    key = k
    value = t
  return
/class


` Creating a compare function for the new kind of object

int compareDemo(dyn a, dyn b)
  demo x = a.toObject()
  demo y = b.toObject()

  if (x = null) or (y = null)
     print "null objects, error..."
     exit()
  /if

  int xk = x.key
  int yk = y.key
  if xk < yk return -1
  if xk > yk return 1
return 0


` Main function - Using the same sort algorithm with
` two kind of objects: integer and demo

int main()
 array theArray = (10, 5, 8, 1, 126, 33, 12, 5, 7, 1000, 2)
 print "QSort2 - sorting an array using functions as parameters"
 quickSort("compare", "swapdyn", theArray, 0, theArray.size() - 1)
 theArray.display()

 ` Objects to be sorted

 demo ship     = demo(4, "ship")
 demo car      = demo(2, "car")
 demo airplane = demo(1, "airplane")
 demo train    = demo(5, "train")
 demo rocket   = demo(3, "rocket")
 array a2 = array(ship, car, airplane, train, rocket)

 print "Using the same algorithm, but different objects and functions"
 quickSort("compareDemo", "swapdyn", a2, 0, a2.size() - 1)

 ` Displaying the sorted array of "demo" objects

 scan a2
  dyn d = a2[]
  demo x = d.toObject()
  print x.value
 /scan

return 0

main()

