        .286P

	INCLUDE REGS286.INC

DGROUP group _DATA

	extrn _myexcep13:near
	extrn _protected_to_real:near

_DATA segment word public 'DATA'
        extrn _code16sel:word           ;  16 bit PRG selectors
	extrn _data16sel:word		;
        extrn _stack16sel:word          ;
	extrn _stackp16:word		;  16 bit stackp32

	extrn _reg:REG286		;  regs for exceptions
	extrn _faultno:word
_DATA ends

_TEXT segment byte public 'CODE'
        assume cs:_TEXT,ds:DGROUP

        public _load_ds
_load_ds proc near
        push    ax
        mov     ax,0000h    ; value will override by entering prot mode
        mov     ds,ax
        pop     ax
        ret
_load_ds        endp

; this proc is called after exception handler return from DPMI-server
; cs:eip and ss:esp set
exception_after_return proc near	; called after FAR-RET from exception
	call	_load_ds		; get extender ds
	push	ds
	pop	es			; make ds=es

	call	_myexcep13		; c-handler
	jmp	_protected_to_real	; if return, shut down
exception_after_return endp


; EXCEPTIONS
;
;  DPMI-rules:
; - return with far return , org SS:SP CS:IP Eflags will restored
; - all fault have error code (only valid for 08,0A-0E)
; - handler must preserve and restore all registers
; - handler will be called on a locked stack with interrupts disabled
; - handler must return or jump to the next handler
; - handler can modify exception stack, but not return cs,eip
;   it must return to the orginal handler
; - called only for protected mode exceptions
;
;        exception STACK
;          0 : bp  (our,not default)
;          2 : return ip (to host)
;          4 : return cs  (to host)
;          6 : error
;          8 : IP (orginal)
;         10 : CS (orginal)
;         12 : flags
;         14 : SP
;         16 : SS

	public _excep13_286
_excep13_286 proc far
	push	word ptr 13
	jmp	short exceptionhandler

public _excep0_286
_excep0_286:
	push	word ptr 0
	jmp	short exceptionhandler

public _excep1_286
_excep1_286:
	push	word ptr 1
	jmp	short exceptionhandler

public _excep2_286
_excep2_286:
	push	word ptr 2
	jmp	short exceptionhandler

public _excep3_286
_excep3_286:
	push	word ptr 3
	jmp	short exceptionhandler

public _excep4_286
_excep4_286:
	push	word ptr 4
	jmp	short exceptionhandler

public _excep5_286
_excep5_286:
	push	word ptr 5
	jmp	short exceptionhandler

public _excep6_286
_excep6_286:
	push	word ptr 6
	jmp	short exceptionhandler

public _excep7_286
_excep7_286:
	push	word ptr 7
	jmp	short exceptionhandler

public _excep8_286
_excep8_286:
	push	word ptr 8
	jmp	short exceptionhandler

public _excep9_286
_excep9_286:
	push	word ptr 9
	jmp	short exceptionhandler

public _excep10_286
_excep10_286:
	push	word ptr 10
	jmp	short exceptionhandler

public _excep11_286
_excep11_286:
	push	word ptr 11
	jmp	short exceptionhandler

public _excep12_286
_excep12_286:
	push	word ptr 12
	jmp	short exceptionhandler

public _excep14_286
_excep14_286:
	push	word ptr 14
	jmp	short exceptionhandler

public _excep15_286
_excep15_286:
	push	word ptr 14
	jmp	short exceptionhandler

public _excep16_286
_excep16_286:
	push	word ptr 14
	jmp	short exceptionhandler

public _excep17_286
_excep17_286:
	push	word ptr 14
	jmp	short exceptionhandler


exceptionhandler:
	push ds
	call _load_ds

	mov	word ptr DGROUP:_reg.r_ax, ax
	mov	word ptr DGROUP:_reg.r_bx, bx
	mov	word ptr DGROUP:_reg.r_cx, cx
	mov	word ptr DGROUP:_reg.r_dx, dx
	mov	word ptr DGROUP:_reg.r_bp, bp
	mov	word ptr DGROUP:_reg.r_di, di
	mov	word ptr DGROUP:_reg.r_si, si
	mov	word ptr DGROUP:_reg.r_es, es

	pop	ax
	mov	word ptr DGROUP:_reg.r_ds, ax
	pop	ax
	mov	word ptr DGROUP:_faultno, ax

	push	bp
	mov	bp,sp

        mov     ax,word ptr [bp+6]
        mov     word ptr DGROUP:_reg.r_err,ax

        mov     ax,word ptr [bp+8]
        mov     word ptr DGROUP:_reg.r_ip,ax

        mov     ax,word ptr [bp+10]
        mov     word ptr DGROUP:_reg.r_cs,ax

        mov     ax,word ptr [bp+12]
        mov     word ptr DGROUP:_reg.r_flags,ax

        mov     ax,word ptr [bp+14]
        mov     word ptr DGROUP:_reg.r_sp,ax

        mov     ax,word ptr [bp+16]
        mov     word ptr DGROUP:_reg.r_ss,ax

    ; set return address

	mov	ax, offset exception_after_return
        mov     word ptr [bp+8],ax          ; set ip

	mov	ax, cs
        mov     word ptr [bp+10],ax         ; set cs

        mov     ax, word ptr DGROUP:_stackp16
	mov	word ptr [bp+14],ax	    ; set sp

	mov	ax, ds
        mov     word ptr [bp+16],ax         ; set ss

	pop	bp
        retf
_excep13_286  endp



_TEXT ends

      end
