/* CDROMDM.C - Programmed by Maarten Hofman */
/* 120793: Started programming */
/* 130793: Continued programming */
/* 140793: Random tracks */
/* 190793: Drive is a constant instead of 3 */

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <stdlib.h>
#include "cddrive.h"
#include "titles.h"
#include "cdromdm.h"

long int disk[101][2],endsector;
int low,high,lasttrack,programme[100],programming,programlength,pause;
int programloc,all,music;
char timing[12];

int rnd(int max) {
  return((int)(((double)rand()*max)/((double)RAND_MAX+1)+1));
}

static void check_all(void) {
  gotoxy(1,24);
  switch(query_error()) {
    case NO_ERROR:
      textcolor(LIGHTCYAN);
      cprintf("No error                      ");
      break;
    case GENERAL_FAILURE:
      textcolor(LIGHTRED);
      cprintf("General failure               ");
      break;
    default:
      textcolor(LIGHTRED);
      cprintf("%.3d            ",query_error());
  }
  textcolor(RED);
  if(query_busy()) {
    cprintf("B ");
  }
  else {
    cprintf("  ");
  }
  if(query_done()) {
    cprintf("D ");
  }
  else {
    cprintf("  ");
  }
  textcolor(BROWN);
  if(pause) {
    cprintf("Paused ");
    return;
  }
  switch(programming) {
    case 0:
      cprintf("Normal ");
      break;
    case 1:
      cprintf("Program");
      break;
    case 2:
      cprintf("Running");
  }
}

static char *length_to_time(long int length) {
int minute,second;

  minute=length/4500;
  second=(length-minute*4500)/75;
  sprintf(timing,"%.2u:%.2u",minute,second);
  return(timing);
}

static void print_track(int track,int color,int suppress) {
char *title;

  gotoxy(track*3-2,1);
  textattr(color);
  cprintf("%d",track);
  if(suppress) return;
  gotoxy(7,TRACK_HEIGHT);
  textcolor(WHITE);
  cprintf("*                                                             ");
  if((title=query_title(track))!=NULL) {
    gotoxy(7,TRACK_HEIGHT);
    cprintf("%s",title);
  }
  gotoxy(1,TRACK_HEIGHT);
  textcolor(LIGHTMAGENTA);
  cprintf("%s",length_to_time(disk[track][1]));
}

static void reset_stereo(void) {
  gotoxy(50,24);
  textcolor(GREEN);
  audio_channel_control(DRIVE,INPUT_CHANNEL_0,0);
  audio_channel_control(DRIVE,INPUT_CHANNEL_1,1);
  cprintf("Normal Stereo");
  music=0;
}

static void get_disk_info(void) {
int i,minute,second;

  gotoxy(1,24);
  textcolor(LIGHTGRAY);
  cprintf("Please wait, checking disk...");
  low=audio_disk_info(DRIVE,LOWEST_TRACK);
  high=audio_disk_info(DRIVE,HIGHEST_TRACK);
  for(i=low;i<=high;i++) {
    disk[i][0]=get_track_address(DRIVE,i);
    if(i>low) {
      disk[i-1][1]=redbook_to_hsg(disk[i][0])-redbook_to_hsg(disk[i-1][0])-9;
    }
  }
  disk[high+1][0]=get_track_address(DRIVE,LEAD_OUT_TRACK);
  endsector=redbook_to_hsg(disk[high+1][0])-9;
  disk[high][1]=endsector-redbook_to_hsg(disk[high][0]);
  clrscr();
  gotoxy(3,3);
  textcolor(GREEN);
  cprintf("Track Time");
  gotoxy(22,3);
  textcolor(CYAN);
  cprintf("Disk Time");
  gotoxy(1,10);
  textcolor(LIGHTGRAY);
  cprintf("1-9: Number input   0: 10 input     -: 10+ input");
  gotoxy(1,11);
  cprintf("r: Start programme  p: Programme    a: Repeat");
  gotoxy(1,12);
  cprintf("s: Stop programme   =: Pause        n: New disk");
  gotoxy(1,13);
  cprintf(",: Previous number  .: Next number  /: Random play");
  gotoxy(1,14);
  cprintf("q: quit            ");
  for(i=low;i<=high;i++) print_track(i,BLUE,1);
  lasttrack=0;
  gotoxy(1,23);
  textcolor(LIGHTMAGENTA);
  minute=(disk[high+1][0]&0x00ff0000)>>16;
  cprintf("%d:",minute);
  second=(disk[high+1][0]&0x0000ff00)>>8;
  cprintf("%d ",second);
  textattr(YELLOW);
  fix_titles(disk[high+1][0]);
  reset_stereo();
}

void static play_track(int track,int etal) {
long int fin;

  fin=etal?endsector-redbook_to_hsg(disk[track][0]):disk[track][1];
  if((track<low)||(track>high)) return;
  play_audio(DRIVE,disk[track][0],fin);
}

void play_next_stored(void) {
  print_track(programme[programloc],MAGENTA,1);
  lasttrack=0;
  if(++programloc<programlength) {
    play_track(programme[programloc],0);
  }
  else {
    if(!all) {
      programming=1;
      return;
    }
    programloc=0;
    play_track(programme[programloc],0);
  }
}

main() {
int i,quit,total,track,exists,guess,j,music;
unsigned char *qchannel;
time_t tmptime;

  get_disk_info();
  quit=total=pause=music=0;
  _setcursortype(_NOCURSOR);
  srand(time(&tmptime));
  while(!quit) {
    qchannel=audio_qchannel_info(DRIVE);
    check_all();
    if((track=qchannel[TRACK_NUMBER])!=lasttrack) {
      if(lasttrack!=0) {
	if(programming) {
	  print_track(lasttrack,MAGENTA,1);
	}
	else {
	  print_track(lasttrack,BLUE,1);
	}
      }
      print_track(track,LIGHTBLUE+BLINK,0);
      lasttrack=track;
    }
    textcolor(LIGHTGREEN);
    print_time(qchannel[RUN_MINUTES],qchannel[RUN_SECONDS],1,4);
    textcolor(LIGHTCYAN);
    print_time(qchannel[DISK_MINUTES],qchannel[DISK_SECONDS],20,4);
    if((!query_done())&&(!pause)) {
      if(programming==2) {
	play_next_stored();
      }
      if((!programming)&&all) {
	if(lasttrack) print_track(lasttrack,BLUE,0);
	play_track(1,1);
      }
    }
    if(programming==2) if(!query_done()) if(!pause) play_next_stored();
    if(kbhit()) {
      switch(getch()) {
	case 'q':
	  quit=1;
	  break;
	  case '0': total++;
	  case '9': total++;
	  case '8': total++;
	  case '7': total++;
	  case '6': total++;
	  case '5': total++;
	  case '4': total++;
	  case '3': total++;
	  case '2': total++;
	  case '1':
	    total++;
	    if((total<low)||(total>high)) break;
	    if(!programming) {
	      play_track(total,1);
	      check_all();
	      total=0;
	      break;
	    }
	    if(programming==2) break;
	    exists=0;
	    for(i=0;i<programlength;i++) if(programme[i]==total) exists=1;
	    if(exists) break;
	    programme[programlength++]=total;
	    print_track(total,MAGENTA,1);
	    total=0;
	    break;
	  case '-':
	    total+=10;
	    break;
	  case '=':
	    if(!pause) {
	      stop_audio(DRIVE);
	    }
	    else {
	      resume_audio(DRIVE);
	    }
	    pause=1-pause;
	    break;
	  case 'n':
	    if(query_error()!=NO_ERROR) break;
	    if(device_status(DRIVE)&DOOR_OPEN) break;
	    get_disk_info();
	    programming=0;
	    break;
	  case ',':
	    switch(programming) {
	      case 0:
		play_track(lasttrack-1,1);
		break;
	      case 2:
		print_track(programme[programloc],MAGENTA,1);
		lasttrack=0;
		if(--programloc<0) programloc=0;
		play_track(programme[programloc],0);
	    }
	    break;
	  case '.':
	    switch(programming) {
	      case 0:
		play_track(lasttrack+1,1);
		break;
	      case 2:
		play_next_stored();
	    }
	    break;
	  case 'p':
	    if(programming) break;
	    programming=1;
	    programlength=0;
	    stop_audio(DRIVE);
	    if(lasttrack) print_track(lasttrack,BLUE,1);
	    break;
	  case 'r':
	    if(!programming) break;
	    if(!programlength) {
	      programming=0;
	      break;
	    }
	    if((programming==2)&&lasttrack) print_track(lasttrack,MAGENTA,1);
	    programming=2;
	    programloc=0;
	    lasttrack=0;
	    play_track(programme[0],0);
	    break;
	  case 's':
	    if(!programming) break;
	    programming=0;
	    stop_audio(DRIVE);
	    for(i=0;i<programlength;i++) print_track(programme[i],BLUE,1);
	    lasttrack=0;
	    break;
	  case '/':
	    if(programming) break;
	    programlength=0;
	    stop_audio(DRIVE);
	    for(i=low;i<=high;i++) {
	      exists=1;
	      while(exists) {
		guess=rnd(high-low+1);
		exists=0;
		for(j=0;j<programlength;j++) {
		  if(programme[j]==guess) exists=1;
		}
	      }
	      programme[programlength++]=guess;
	      print_track(guess,MAGENTA,1);
	    }
	    programming=2;
	    programloc=0;
	    lasttrack=0;
	    play_track(programme[0],0);
	    break;
	  case 'c':
	    if(programming!=1) break;
	    if(!programlength) break;
	    programlength--;
	    break;
	  case 'm':
	    if(++music>3) music=0;
	    gotoxy(50,24);
	    textcolor(GREEN);
	    switch(music) {
	      case 0:
		reset_stereo();
		break;
	      case 1:
		audio_channel_control(DRIVE,INPUT_CHANNEL_0,1);
		cprintf("Right Mono   ");
		break;
	      case 2:
		audio_channel_control(DRIVE,INPUT_CHANNEL_1,0);
		cprintf("Phase Stereo ");
		break;
	      case 3:
		audio_channel_control(DRIVE,INPUT_CHANNEL_0,0);
		cprintf("Left Mono    ");
		break;
	    }
	    break;
	  case 'a':
	    all=1-all;
	    gotoxy(43,24);
	    if(!all) {
	      cprintf("      ");
	    }
	    else {
	      textcolor(DARKGRAY);
	      cprintf("Repeat");
	    }
	    break;
      }
    }
  }
  return(0);
}
