/******************DPMI, SB/SBPro/SB16/GUS detection routines****************

	Written by Barry Egerter	INTERNET: barry.egerter@softnet.com
	Public Domain 1994


	The following routines will detect DPMI and SB-compatible soundcards.
	If you have a use for them, go ahead and steal them.  :)

	The Gravis detection is false, since it merely checks for the 
	environment variable. The SB routines do the same to obtain the IRQ
	once a card is found. If you know how to actually find the card's
	IRQ without reading the environment variables, let me know!

****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#define RESETS 10
#define RESETTIMES 50

/* I/O Port offsets. */

#define CMS1DataPortOffset 0x00  // CM/S 1-6  Data port.             Write Only.
#define CMS1AddrPortOffset 0x01  // CM/S 1-6  Address port.          Write Only.
#define CMS2DataPortOffset 0x02  // CM/S 7-12 Data port.             Write Only.
#define CMS2AddrPortOffset 0x03  // CM/S 7-12 Address port.          Write Only.

#define MixAddrPortOffset 0x04  // Mixer register port.            Write Only.
#define MixDataPortOffset 0x05  // Mixer data port.                Read/Write.

#define FMStatPortOffset  0x08  // Mono FM Status port.            Read  Only.
#define FMAddrPortOffset  0x08  // Mono FM Address port.           Write Only.
#define FMDataPortOffset  0x09  // Mono FM Data port.              Write Only.

#define LFMStatPortOffset 0x00  // Left FM Status port.            Read  Only.
#define LFMAddrPortOffset 0x00  // Left FM Address port.           Write Only.
#define LFMDataPortOffset 0x01  // Left FM Data port.              Write Only.

#define RFMStatPortOffset 0x02  // Right FM Status port.           Read  Only.
#define RFMAddrPortOffset 0x02  // Right FM Address port.          Write Only.
#define RFMDataPortOffset 0x03  // Right FM Data port.             Write Only.

#define DSPResetPortOffset 0x06  // DSP Reset port.                  Write Only.
#define DSPReadPortOffset  0x0A  // DSP Read data port.              Read  Only.
#define DSPLifePortOffset  0x0A  // DSP Read data port.              Read  Only.
#define DSPWStatPortOffset 0x0C  // DSP Write buffer status port.    Write Only.
#define DSPWritePortOffset 0x0C  // DSP Write data port.             Write Only.
#define DSPRStatPortOffset 0x0E  // DSP Read buffer status port.     Read  Only.
#define DSP8AckPortOffset  0x0E  //  8 bit DMA IRQ Acknowledge port. Write Only.
#define DSP16AckPortOffset 0x0F  // 16 bit DMA IRQ Acknowledge port. Write Only.

#define CDDataPortOffset   0x10  // CD-ROM Data port.                Read  Only.
#define CDCmdPortOffset    0x10  // CD-ROM Command port.             Write Only.
#define CDStatPortOffset   0x11  // CD-ROM Status port.              Read  Only.
#define CDResetPortOffset  0x12  // CD-ROM Reset port.               Write Only.
#define CDEnablePortOffset 0x13  // CD-ROM Enable port.              Write Only.

#define sdcSendOneSample  0x10  // Send a sample to the DAC directly (mono mode only).
#define sdcStartLSpeedDMA 0x14  // Start a low-speed DMA transfer.
#define sdcSetTimeConst   0x40  // Set the time constant.
#define sdcSetHSpeedSize  0x48  // Set hi-speed DMA transfer length.
#define sdcStartHSpeedDMA 0x91  // Start a hi-speed DMA transfer.
#define sdcTurnOnSpeaker  0xD1  // Turn on the SB speaker.
#define sdcTurnOffSpeaker 0xD3  // Turn off the SB speaker.
#define sdcGetDSPVersion  0xE1  // Get the DSP version number.
#define sdcGetCopyright   0xE3  // Get the card copyright string.

#define SbDefTimeout 0  // Default DSP timeout

#define mxrDataReset    0x00
#define mxrDACVolume    0x04
#define mxrMicMixing    0x0A
#define mxrInSetting    0x0C
#define mxrOutSetting   0x0E
#define mxrMasterVolume 0x22
#define mxrFMVolume     0x26
#define mxrCDVolume     0x28
#define mxrLineVolume   0x2E


// Bit masks for the mixer registers.

#define mxiFilterVal 0x38
#define mxiADCVal    0x06
#define mxoFilterNeg 0x20
#define mxoStereoOn  0x02

#define mvMaster     0
#define mvVoice      1
#define	mvFM         2
#define	mvLine       3
#define	mvMicrophone 4
#define	mvSpeaker    5
#define	mvCD         6

unsigned char SbProRegs[7] = { 0x22, 0x04, 0x26, 0x2E, 0x0A, 0x00, 0x28 };
unsigned char Sb16Regs[7] = { 0x30, 0x32, 0x34, 0x38, 0x3A, 0x3B, 0x34 };



unsigned io_port;
unsigned sbversion;
char sbprodetected;
char sb16detected;


/****************************SoundBlaster Routines**************************/
void SbWriteByte(unsigned char b)
{
  delay(SbDefTimeout);
  outportb( io_port + DSPWritePortOffset, b);
}

unsigned char SbReadByte(void)
{
  delay(SbDefTimeout);
  return inportb(io_port + DSPReadPortOffset);
}


unsigned char SbReadMixerReg( unsigned char reg )
{
  outportb(io_port + MixAddrPortOffset, reg);
  return inportb( io_port + MixDataPortOffset );
}

void SbWriteMixerReg( unsigned char reg, unsigned char val )
{
  outportb( io_port + MixAddrPortOffset, reg );
  outportb( io_port + MixDataPortOffset, val );
}


char wmixerdetect(void)
{
  unsigned savereg, newreg;
  savereg = SbReadMixerReg(0x22);
  SbWriteMixerReg(0x22, 243);
  newreg = SbReadMixerReg(0x22);
  SbWriteMixerReg(0x22, savereg);
  if (newreg == 243) return 1;
  else return 0;
}


/************************************************************************}
{ This function returns TRUE if a soundblaster PRO is found. The hi-byte }
{ and the low-byte will contain the DSP version number. I do not use the }
{ low-byte because I'm not interested in that, I just want to know if    }
{ the DSP version number is 2.x or 3.x (for soundblaster PRO)           */

void getdspversion(void)
{
  unsigned char sbmaj, sbmin;
  SbWriteByte(sdcGetDSPVersion);
  while ( (sbmaj=SbReadByte()) == 0xaa );
  sbmin = SbReadByte();
  sbversion=(sbmaj << 8) + sbmin;
  sbprodetected = (wmixerdetect()) && (sbversion < 0x400);
  sb16detected = (wmixerdetect()) && (sbversion >= 0x400);
}


/************************************************************************}
{ Reset the soundblaster (if present) and get the correct I/O-port       }
{ This routine works with all soundblaster card versions                */

int wsbdetect(void)
{
  unsigned nr_resets, times_reset;
  int sbdetected = 0;

  io_port   = 0x210;
  nr_resets = RESETS;
  while ( (io_port <= 0x260) && (!sbdetected) )
  {
    outportb(io_port + DSPResetPortOffset, 1);
    outportb(io_port + DSPResetPortOffset, 0);
    times_reset = RESETTIMES;
    while ((times_reset > 0) && (inportb(io_port + DSPRStatPortOffset) < 128)) times_reset--;
    if ( (times_reset == 0) || (inportb(io_port + DSPReadPortOffset) != 0xAA) )
    {
      nr_resets--;
      if (nr_resets==0)
      {
	nr_resets = RESETS;
	io_port += 0x10;
      }
    }
    else
      sbdetected = 1;
  }
  if (sbdetected) getdspversion();
  return sbdetected;
}


void MixerGetVolume(char reg, unsigned char *VolLeft, unsigned char *VolRight)
{
  unsigned char Addr;

  if (sb16detected) Addr = Sb16Regs[reg];
    else Addr = SbProRegs[reg];

  *VolLeft  = 0;
  *VolRight = 0;

  if (reg == mvMicrophone) {
    if (sb16detected) *VolLeft = SbReadMixerReg(Addr);
      else *VolLeft = SbReadMixerReg(Addr) << 5;
    *VolRight = *VolLeft;
  }
  else if (reg == mvSpeaker) {
    if (sb16detected) *VolLeft = SbReadMixerReg(Addr);
    *VolRight = *VolLeft;
  }
  else if (sb16detected) {
    *VolLeft  = SbReadMixerReg(Addr);
    *VolRight = SbReadMixerReg(Addr + 1);
  }
  else {
    *VolLeft  = SbReadMixerReg(Addr);
    *VolRight = (*VolLeft) << 4;
    *VolLeft  = (*VolLeft) & (0xF0);
  }
}


int getirq(void)
{
   char *blaster;
   int interupt;
   int ctr = 0;

   blaster = getenv("BLASTER");	/* Get the BLASTER environment string */
   if (blaster == NULL)
     return 0;

   while ( (toupper (*blaster) != 'I') && (ctr < 15))
   {
     blaster++;
     ctr++;
   }				/* Find the "I" value */
   if (ctr == 15)
     return 0;
   blaster++;			/* Get the number after the I */
   interupt = atoi (blaster);
   return interupt;		/* Return it as the interrupt # */
}


void check_ultrasound ()
{
   char *ultra;

   ultra = getenv("ULTRASND");	/* Check for Ultrasound init string */
   if (ultra == NULL)
     return;

   printf ("\nSuspected Gravis Ultrasound card --- Using SBOS for SB emulation.\n\n");

   printf ("Gravis card installed at:\n");
   printf ("PORT         : %i\n", atoi (ultra) );
   while (*ultra != ',') ultra++;
   ultra++;
   printf ("Playback DMA : %i\n", atoi (ultra) );
   while (*ultra != ',') ultra++;
   ultra++;
   printf ("Record DMA   : %i\n", atoi (ultra) );
   while (*ultra != ',') ultra++;
   ultra++;
   printf ("MAIN IRQ     : %i\n", atoi (ultra) );
   while (*ultra != ',') ultra++;
   ultra++;
   printf ("SB/MIDI IRQ  : %i\n", atoi (ultra) );
   printf ("\n\n\n");
}


/*
INT 2F - DOS Protected-Mode Interface - DETECT MODE
	AX = 1686h
Return: AX = 0000h if operating in protected mode under DPMI (INT 31 available)
	AX nonzero if in real/V86 mode or no DPMI (INT 31 not available)
SeeAlso: AX=1687h


INT 2F - DOS Protected-Mode Interface - INSTALLATION CHECK
	AX = 1687h
Return: AX = 0000h if installed
	    BX = flags
		bit 0: 32-bit programs supported
	    CL = processor type (02h=80286, 03h=80386, 04h=80486)
	    DH = DPMI major version
	    DL = two-digit DPMI minor version (binary)
	    SI = number of paragraphs of DOS extender private data
	    ES:DI -> DPMI mode-switch entry point
	AX nonzero if not installed
SeeAlso: AX=1686h,AX=43E0h,AX=DE01h/BX=4450h,AX=FB42h/BX=0001h
SeeAlso: INT 31/AX=0400h,INT 31/AX=5702h,INT 38/AH=10h
*/

void dpmicheck(void)
{
  union REGS inregs, outregs;
  inregs.x.ax = 0x1687;
  int86(0x2f, &inregs, &outregs);
  if (outregs.x.ax == 0)
  {
    printf("DPMI installed.\n");
    if (outregs.h.cl == 2) 
      printf("80286 processor detected\n");
    else if (outregs.h.cl == 3) 
      printf("80386 processor detected\n");
    else if (outregs.h.cl == 4) 
      printf("80486 processor detected\n");
    inregs.x.ax = 0x1686;
    int86(0x2f, &inregs, &outregs);
    if (outregs.h.cl == 0) 
      printf("Running in protected mode.\n");
    else printf("Operating in V86 (real) mode.\n");
  }
  else printf("No DPMI found.\n");
}




void main(void)
{
  unsigned char lv, rv;

  printf("\n\n\n");
  dpmicheck ();
  if (wsbdetect ()) 
  {
    printf("\nSB detected at port %x, IRQ %i\n", io_port, getirq () );
    printf("SoundBlaster version %d.", (sbversion >> 8) );

    if ( (unsigned char)sbversion < 10) 
      printf("0");
    printf("%d\n", (unsigned char) sbversion);

    if (sbprodetected) 
      printf("SoundBlaster Pro detected\n");
    else printf("Pro NOT detected\n");

    if (sb16detected) 
      printf("SoundBlaster 16 detected\n");
    else printf("SB16 NOT detected\n");

    if ( (sbprodetected || sb16detected) ) 
    {
      printf("\n\nVolume Levels:\n");
      MixerGetVolume( mvMaster, &lv, &rv);
      printf("Master        Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvVoice, &lv, &rv);
      printf("Voice         Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvFM, &lv, &rv);
      printf("FM            Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvLine, &lv, &rv);
      printf("Line          Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvMicrophone, &lv, &rv);
      printf("Microphone    Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvSpeaker, &lv, &rv);
      printf("Speaker       Left: %3d    Right: %3d\n",lv,rv);
      MixerGetVolume( mvCD, &lv, &rv);
      printf("CD            Left: %3d    Right: %3d\n",lv,rv);
      lv = (SbReadMixerReg(mxrOutSetting) & mxoStereoOn);
      if (lv>0) 
	printf("\n\nStereo mode on.\n");
      else printf("\n\nMono mode on.\n");
    }
    check_ultrasound ();
  }
  else printf("SB not found.\n");
}
