/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 11                        
                                                                            
Shows the use of wgetblockwidth and wgetblockheight, and demonstrates       
the resize procedure.                                                       
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 WGT1.BLK, WGT1.PAL                                                         
                                                                            
ͼ
*/

#include <wgt4.h>

int i,x,y;
int oldmode;
block part1;			/* part of the screen */
color pal[256];

void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode=wgetmode();
  vga256();

  part1=wloadblock("wgt1.blk");
  wloadpalette("wgt1.pal",pal);
  wsetpalette(0,255,pal);
  wputblock(0,0,part1,0);


  wsetscreen(part1);
  wsetcolor(0);
  wbar(300,0,319,199);
  wbar(0,180,319,199);
  wnormscreen();
  /* Note that the graphic is stored with a black around so it will
     erase itself when shrinking. */

  getch();
  wcls(0);
  x = wgetblockwidth(part1);
  y = wgetblockheight(part1);

  wsetmode(oldmode);   		   /* notice how you can go between text */
  gotoxy(1,1);	       		   /* and graphics modes, but you must reset */
  printf("Block width : %i\n",x);  /* the colours if you've changed them. */
  printf("Block height: %i\n",y);
  printf("Block size is %u bytes.",x*y+4);
  printf("\nPress any key to resize...");
  getch();
  vga256();
  wsetpalette(0,255,pal);

  wclip(0,0,319,199);
  do {
    for (i = 25; i < 100; i += 2)
      wresize(0,0,80 + i,50 + i,part1,NORMAL);
    for (i = 100; i > 25; i -= 2)
      wresize(0,0,80 + i,50 + i,part1,NORMAL);
  } while (!kbhit());
  getch();

  wfreeblock(part1);
  wsetmode(oldmode);
}