"""
t3SRCF.py

Provides a class representing a source file descriptor block in a t3 image
file.
"""

import struct
from t3Block import *

class SRCF_Block(Block):
	"""
	A source file descriptor block. There should only be one such block in any
	image file, but it is not mandatory that there should be any. It will
	normally only be included for debugging purposes.
	"""
	name = "Source File Descriptor Block"
	debug = True

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		n = struct.unpack("<H", self.datastream.read(2))[0]
		sizeofslr = struct.unpack("<H", self.datastream.read(2))[0]
		entries = []
		for i in xrange(n):
			frdict = {}
			size, idx, lfn = struct.unpack("<I2H", self.datastream.read(8))
			fn = self.datastream.read(lfn)
			frdict["i_index"] = idx
			frdict["s_filename"] = fn
			records = []
			nrec = struct.unpack("<I", self.datastream.read(4))[0]
			for j in xrange(nrec):
				scln, bcaddr = struct.unpack("<2I", self.datastream.read(8))
				records.append((scln, bcaddr))
			frdict["l_records"] = records
			entries.append(frdict)
		self.data["l_entries"] = entries

	def report_data(self):
		sl = []
		for entry in self.data["l_entries"]:
			sl.append("index of master source file record: ")
			sl.append(str(entry["i_index"]) + "\n")
			sl.append("filename: " + entry["s_filename"] + "\n")
			for record in entry["l_records"]:
				sl.append("\tln/addr: ")
				sl.append(str(record[0]) + "\t" + str(record[1]))
				sl.append("\n")
		return "".join(sl)