"""
t3CPDF.py

Provides a class representing constant pool definition block in a t3 image
file.
"""

import struct
from t3Block import *

class CPDF_Block(Block):
	"""
	A constant pool definition block. The image file must have one such block
	for each constant pool it defines.
	"""
	name = "Constant Pool Definition Block"

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		id, npages, sizeofpage = struct.unpack("<HII", self.datastream.read(10))
		self.data["i_poolIdentifier"] = id
		self.data["b_bytecodePool"] = (id == 1)
		self.data["b_constantDataPool"] = (id == 2)
		self.data["i_numberOfPages"] = npages
		self.data["i_sizeOfPage"] = sizeofpage
		
	def report_data(self):
		sl = []
		sl.append("pool identifier: ")
		sl.append(str(self.data["i_poolIdentifier"]) + "\n")
		sl.append("is a bytecode pool: ")
		sl.append(str(self.data["b_bytecodePool"]) + "\n")
		sl.append("is a constant data pool: ")
		sl.append(str(self.data["b_constantDataPool"]) + "\n")
		sl.append("number of pages: ")
		sl.append(str(self.data["i_numberOfPages"]) + "\n")
		sl.append("size of page: ")
		sl.append(str(self.data["i_sizeOfPage"]) + "\n")
		return "".join(sl)