#define PROGRAMNAME "WinTADS"
/* Version number is in OEM.H */

#define MAXBUF 1000

/* Regular messages */
#define  strix_PrefsFileName 1
#define  strix_RestoreGame 2
#define  strix_SaveGameAs 3
#define  strix_OpenGame 4
#define  strix_WriteScript 5
#define  strix_BindGame 6
#define  strix_UnbindGame 7
#define  strix_GameKey1 8
#define  strix_GameKey2 9
#define  strix_GameKey3 10
#define  strix_GameKey4 11
#define  strix_SaveKey1 12
#define  strix_SaveKey2 13
#define  strix_SaveKey3 14
#define  strix_SaveKey4 15

// The start of the TADS string resources
#define  strix_TADSRes 16

/* for cutbuf */
#define op_Yank 1
#define op_Wipe 2
#define op_Copy 3
#define op_YankReplace 4
#define op_Kill 5
#define op_Untype 6
#define op_Erase 7

/* for movecursor and delete */
#define op_ForeChar 1
#define op_BackChar 2
#define op_ForeWord 3
#define op_BackWord 4
#define op_ForeLine 5
#define op_BackLine 6
#define op_BeginLine 7
#define op_EndLine 8
#define op_Line 9

/* for scroll */
#define op_UpLine 1
#define op_DownLine 2
#define op_UpPage 3
#define op_DownPage 4
#define op_ToTop 5
#define op_ToBottom 6

#define op_Enter 1
/* for redraw */
#define op_TextWin 1
/* for meta */
#define op_Cancel 1
#define op_Escape 2
#define op_DefineMacro 3
#define op_ExplainKey 4
/* for redraw */
#define op_Screen 1
#define op_AllWindows 3

#define gcblack (0)
#define gcwhite (1)
#define gcflip (2)

#define keytype_main (0)
#define keytype_macro (256)
#define keytype_virtual (0x100)
#define keytype_ctrl (0x200)
#define keytype_shift (0x400)
#define keytype_alt (0x800)
#define keytype_Mask (0xF00)
#define NUMCOMMANDS (4096) /* 16*256 */

/* Special formatting characters which are used in display_char() */
#define HILIGHT_ON		'\002'
#define HILIGHT_OFF		'\001'
#define HTML4_CHARACTER	'\003'

/* The four special character sets I use to display HTML 4 characters */
#define HTML4_DEFAULT		0
#define HTML4_ANSI			1
#define HTML4_EASTEUROPE	2
#define HTML4_SYMBOL		3

typedef void (*cmdfunc_ptr)(short operand);

typedef struct cmdentry_t {
    cmdfunc_ptr func;
    short operand;
    short ignoremods;
    char *name;
} cmdentry;

typedef struct stream_t {
	short	streambuf[MAXBUF];
	BOOL	bStreamLocked;	/* Is the stream in use? */
	LONG	curpos;			/* Where's the end of the stream? */
} stream;

typedef struct binding_t {
	unsigned short key;
	short which; /* keytype_* */
	char *name;
} binding;

// Only used for special TADS keys
typedef struct altbinding_t {
	unsigned short key;
	short which;
	short TADSvalue;
} altbinding;

extern void xio_pause(void);

extern VOID mySetRect(PRECT prect, LONG xL, LONG yT, LONG xR, LONG yB);

extern LONG TestBinding(PSZ pszTADS);
extern DWORD BindCode(LPDWORD pdw);
extern DWORD UnbindCode(LPDWORD pdw);

extern void DisplayMessage(PSZ pszString);
extern void DisplayInformation(PSZ pszString);
extern void DisplayError(PSZ pszString);

extern void initialize_screen(void);
extern void reset_screen(void);
extern void display_string(unsigned char *str);//###char
extern int input_line(int buflen, unsigned char *buffer, int timeout, int *readpos);//###char
extern void clear_text_window(void);
extern int input_character(int timeout);
extern void select_status_mode(int mode);
extern int get_status_mode(void);
extern void mainwin_activate(BOOL turnon);
extern void mainwin_caret_changed(BOOL turnon);

extern short getch_wait_stream(stream *st, DWORD outtime);
extern int putch_wait_stream(stream *st, short c, DWORD outtime);
extern void clear_stream(stream *st);

extern void xtext_init(void);
extern void xtext_free(void);
extern void xtext_add(unsigned char ch, long pos); //###char
extern void xtext_replace(long pos, long oldlen, unsigned char *buf, long newlen); //###char
extern HFONT *xtext_get_last_style();
extern void xtext_setstyle(long pos, HFONT *attr);
extern void xtext_adjust(void);
extern void xtext_resize(short xpos, short ypos, short width, short height);
extern void xtext_get_text_area(RECT *box);
extern void xtext_redraw(HDC hdc);
extern void xtext_hitdown(short xpos, short ypos, unsigned short button, unsigned short mods, short clicknum);
extern void xtext_hitmove(short xpos, short ypos, unsigned short button, unsigned short mods, short clicknum);
extern void xtext_hitup(short xpos, short ypos, unsigned short button, unsigned short mods, short clicknum);
extern void xtext_end_visible(void);
extern void xtext_set_lastseen(void);
extern void xtext_clear_window(void);
extern void xtext_line_timeout(void);
extern BOOL xtext_find(BOOL fForward, BOOL fCase, unsigned char *word); //###char
extern void xtext_end(void);

extern void mainwin_caret_changed(BOOL turnon);

extern void scroll_splat(short msg);
extern void scroll_to(long newscrollline);

extern char *xkey_get_key_name(short key);
extern void xkey_parse_bindings(char *str);
extern cmdentry *xkey_find_cmd_by_name(char *str);

extern BOOL stuff_kbd_stream(short c);
extern BOOL stuff_kbd_stream_with_string(unsigned char *str);

extern VOID SetStatusTextLeft(PSZ pszNewText);
extern VOID StatusInsertLeft(unsigned char c);
extern VOID SetStatusTextRight(PSZ pszNewText);
extern VOID ClearStatus(VOID);
extern BOOL AdjustStatusBar(HWND hwnd);
extern int StatusBarHeight(HWND hwnd);

extern VOID MyShowScrollBar(BOOL fShow);

extern SHORT UpdateFonts(HDC hdc, BOOL fUpdate);
extern void DisplayInformation(PSZ pszString);

extern void SetMessageBoxText(PSZ pszNewText, BOOL bTimeout);

extern void xted_init(int buflen, unsigned char *buffer, int *readpos, int *killflag); //###char
extern void xted_insert(short ch);
extern void xted_delete(short op);
extern void xted_enter(short op);
extern void xted_scroll(short op);
extern void xted_movecursor(short op);
extern void xted_movedot(short op);
extern void xted_cutbuf(short op);
extern void xted_history(short op);
extern void xted_option_capability(BOOL *cuttable, BOOL *copyable);
extern void xted_noop(short op);
extern void xtexted_redraw(short op);
extern void xtexted_meta(short op);
extern void xted_macro(short op);
extern void xted_macro_enter(short op);
extern void xted_define_macro_text(short keynum, unsigned char *text);//###char
extern void xted_define_macro(short keynum);
extern void xstat_reset_window_size(short op);
extern void xtexted_modify(short keynum, short op);
extern short xtexted_getmodifymode(BOOL clearit);

extern VOID TweakMacroMenus(VOID);

extern void copy_selec_to_clip(unsigned char *buf, long len);//###char
extern PSZ copy_clip_to_string(VOID);

extern void XSetUpHDC(HDC hdc);
extern void XKnowIgnorance(void);
extern void XClearWindow(HDC hdc);
extern void XSetFont(HDC hdc, HFONT font);
extern void XClearArea(HDC hdc, LONG xpos, LONG ypos, LONG wid, LONG hgt);
extern void XClipToValid(HWND win, HDC hdc);
extern void XDrawString(HDC hdc, HFONT font, short xpos, short ypos, unsigned char *buf, long len);//###char
extern void XDrawReverseString(HDC hdc, HFONT font, short xpos, short ypos, short fieldwid,
		unsigned char *buf, long len);//###char
extern void XFillRectangle(HDC hdc, short pattern, short xpos, short ypos, short wid, short hgt);
extern void XFillRectangleColor(HDC hdc, LONG lcol, short xpos, short ypos, 
		short wid, short hgt);
extern void XDrawRectangle(HDC hdc, short xpos, short ypos, short wid, short hgt);
extern void XDrawLine(HDC hdc, short xpos, short ypos, short xpos2, short ypos2);
extern void XCopyArea(HWND win, short xpos, short ypos, short wid, short hgt, 
		short destxpos, short destypos);
extern void XTextExtents(HDC hdc, HFONT font, unsigned char *buf, long len, short *width);//###char
extern void XCharPos(HDC hdc, HFONT font, unsigned char *buf, long len, int *positions);//###char
extern void XShowDot(HDC hdc, BOOL bFlag);
extern void XDrawDot(HDC hdc, short xpos, short ypos);
extern void XBlinkDot(HDC hdc);
extern void XSetForeColor(ULONG newcol);
extern void XSetBackColor(ULONG newcol);
