/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.  
 *   
 *   This is a starter TADS source file.  This is a complete TADS game
 *   that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "advanced" starter game - it has only the minimum set of
 *   definitions needed for a working game.  If you would like some more
 *   examples, create a new game, and choose the "introductory" version
 *   when asked for the type of starter game to create.  
 */

/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT

/* include the standard TADS libraries */
#include <adv.t>
#include <gameinfo.t>
#include <std.t>

/* at game startup, turn on HTML mode */
replace commonInit: function
{
    /* display the special code sequence to turn on HTML recognition */
    "\H+";
}

/* 
 *   Retrieve the card-catalog information for the game.  This information
 *   is written to a file called GameInfo.txt during preinit, and can then
 *   be stored in the compiled .gam file for retrieval by automated tools.
 *   This information is useful for archive maintainers and other
 *   searching and browsing tools.  
 */
getGameInfo: function
{
    /* build and return the game information list */
    return ['IFID', '$IFID$',
            'Name', '$TITLE$',
            'Byline', 'by $AUTHOR$',
            'HtmlByline', 'by <a href="mailto:$EMAIL$">$AUTHOR$</a>'
            'Desc', '$DESC$',
            'HtmlDesc', '$HTMLDESC$'
            'Version', '1.0',
            'ReleaseDate', getGameInfoToday(),
            'Language', 'en-US',
            'PresentationProfile', 'Multimedia'];
}

/* starting location */
startroom: room
    sdesc = "Start Room"
    ldesc = "This is the starting room. "
;
