#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
#include "qtalk.h"
//Quip template "desc"? "reply"?;

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTES
// DEBUG STUFF
// INNER GAME: GENERAL STUFF: Miscellaneous
// INNER GAME: Portable maze items
// INNER GAME: GENERAL STUFF: Sheila
// INNER GAME: SUPERMAZE: ROOMS: Classes
// INNER GAME: SUPERMAZE: ROOMS: Rooms
// INNER GAME: SUPERMAZE: Passages
// INNER GAME: SUPERMAZE: Holes in the floor
// INNER GAME: SUPERMAZE: Maze mechanics (opening solved mazes, etc.)
// INNER GAME: SUPERMAZE: BOT CONVERSATION: General stuff
// INNER GAME: SUPERMAZE: BOT CONVERSATION: Preliminary conversation
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "General" quips
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "Ask" quips
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "Tell" quips
// INNER GAME: SUPERMAZE: BOT CONVERSATION: DEBUGGING STUFF TO BE MOVED
// INNER GAME: SUPERMAZE: BOT CONVERSATION: Obsolete crap
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Current, correct, dynamic version
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Previous dynamic version
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Static version
// INNER GAME: SUPERMAZE: MAP: PRIMITIVE MAP: Primitive dynamic map
// INNER GAME: SUPERMAZE: MAP: PRIMITIVE MAP: Primitive ancillary functions
// SUPERMAZE: OLD MAP: FUNCTIONS: IMAGE FUNCTIONS
// INNER GAME: SUPERMAZE: MAP: Compass rose

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

/*
// -----
// TO DO

Note to self: Make the hints dynamic, including
in Sheila's conversation menu and the ASK SHEILA ABOUT THIS GAME
menu option.

To do:
six columns ceiling
oddly angled desc
Sadly, if you type X WALLS in the oddly angled room, the answer is inappropriate.

// ---------------------------------
// COMMENTS ON INNER-GAME META-VERBS

         Assc.                           Assc.
Name of  old                             new
command  command  Outer? 1 2 Inner? 3 4  command(s)
SAVE     -         YES   - -  YES   - -  - 
RESTORE  -         YES   Y Y  YES   Y Y  - 
UNDO     -         YES   Y Y  YES   Y Y  - 
QUIT     -         YES   Y Y  YES   - Y  ESCAPE, STOP
RESTART  -         YES   Y Y  YES   - Y  RESET, BEGIN
ESCAPE   QUIT       -    - -  YES   - -  - 
STOP     QUIT       -    - -  YES   Y Y  - 
RESET    RESTART    -    - -  YES   - -  - 
BEGIN    RESTART    -    - -  YES   Y Y  - 

1 = In outer game, is action listed after "game over"?
2 = In outer game, action possible after "game over"?
3 = In inner game, is action listed after "game over"?
4 = In inner game, is action possible after "game over"?

OLD:
Would you like to RESTORE a saved position, RESTART the story, 
UNDO the last move, or QUIT?

NEW:
Would you like to RESTORE a game, BEGIN all over again, 
UNDO the last move, or STOP playing?

// --------------
// INANE COMMENTS

Brainstorming on Sheila topics of conversation:
Instructions: SAVE, RESTORE, UNDO are the same
Instructions: QUIT works, but there is also ESCAPE and STOP.
Instructions: RESTART works, but there is also RESET and BEGIN.
*/

/*
[8]  [11]--[13]--[12]
 | \   |        /
 |  \  |       /
 |   [J5]--[J6]--------[10]
  \         |         /
    \       |       /
[4]--[J3]--[9]--[J4]
 |     |          | \
 |     |    __    |   \
 |     |   /  \   |    [7]
 |     | /      \ |     |
 |    [5]        [6]    |
 |   /   \        |     |
 |  |     \       |     |
 |  |      [2]--[J2]-,  |
 |  |       |        |  |
 |  |       |        |  |
 '-[1]-----[J1]-----[3]-'
 
13 = Net-Hac-Man! 
12 = Quat 2
11 = Movies
10 = Books
9 = Africa
8 = Pyramid 2
7 = Pyramid 1
6 = Escape
5 = Quat 1
4 = Twisty
3 = Floor
2 = Animals
1 = Mexico
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

smFixture: Fixture 'sm' 'sm' @supermazeJ1;

DefineIAction(OogaBooga)
  execAction() {
    if (gPlayerChar.getOutermostRoom.ofKind(SupermazeRoom)) {
      openMaze(gPlayerChar.getOutermostRoom.asscNum);
      mainReport('Ooga booga to you too. ');
    }
    else {
      mainReport('You can<./s>t ooga booga here. ');
    }
  }
;

VerbRule(OogaBooga)
  'ooga' 'booga' | 'ooga'
  : OogaBoogaAction
  verbPhrase = 'ooga booga/boogaing'
;

DefineIAction(MSolve)
  execAction() {
    if (gPlayerChar != bot || 
        gPlayerChar.getOutermostRoom.ofKind(BasicSupermazeRoom))
      "You can<./s>t msolve here. ";
    else {
      returnToCaveVictoriously('Woo hoo!');
    }
  }
;

VerbRule(MSolve)
  'msolve'
  : MSolveAction
  verbPhrase = 'msolve/msolving'
;

//modify Thing
//  dobjFor(Take) {
//    action {
//      moveInto(gActor);
//      defaultReport(&okayTakeMsg);
//      "<.p>There. Happy now? ";
//    }
//  }
//;

//beachFixture: Fixture
//  'beach fixture' 'beach fixture'
//  @beach
//  dobjFor(Pow) {
//    verify {
//      logicalRank(150, 'intended for powing');
//    }
//  }
//;

#endif // __DEBUG

// -------------------------------------------------------------------
// INNER GAME: GENERAL STUFF: Miscellaneous
// -------------------------------------------------------------------

// After the player has gotten to beachRoom or pdaRoom and has
// started playing the game, this is what runs next.
startSupermaze() {
  //supermazeJ1.hasBeenVisited = true;
  supermazeJ1.enteringRoom(bot);
  supermazeBanner();
  "<p>";
  gPlayerChar.lookAround(true);
  "<.p>";
  "Your bot looks around for a few moments.
    Then, realizing it can't see you, 
    it cocks its head upward and says, 
    <.q>Hi there! My name<./s>s Sheila. I<./s>ll be your bot. 
    Just type commands into your tablet device, and I<./s>ll 
    do my best to carry them out. Before you begin, 
    I should probably give you a few instructions. 
    Is that all right?<./q> ";
  bcPreliminary.select;
}

supermazeBanner() {
  "<b>NOTHING BUT MAZES</b>
    <br>An Interactive Romp through the Mazes of Earth
    <br>By Neton and Ovan
    <br>Copyright (c) 2189 by the Center for Earthological Studies
    <br>Version 0.2 / Serial number 21891128 / MIFS 9 version 9.1.0 ";
  //"<b>NOTHING BUT MAZES</b>
  //  <br>An Interactive Exploration of the Mazes of Earth
  //  <br>By Neton and Ovan
  //  <br>Copyright (c) 2189 by the Center for Earthological Studies
  //  <br>For more information, say INFO.
  //  <br>Version 0.2 / Serial number 21891128 / MIFS 9 version 9.1.0 ";
}

// I don't like typographicalOutputFilter. In particular, its 
// '--' -> '&mdash;' 
// feature creates problems when using a monospaced font. Also, 
// '. The' -> '.  The'
// is something I don't like. Hence, goodbye, typographicalOutputFilter.

modify typographicalOutputFilter
  filterText(ostr, txt) { return txt; }
;

// Having the destinations of the exits listed, either in 
// room descriptions or in the status line, is anathema to
// this maze stuff. Therefore, disable exit listings. Moreover,
// 

modify exitLister
  // Fortunately, this works for both 3.0.8 and 3.0.9, since
  // it does not assume a specific number of arguments
  exitsOnOffCommand(args) {
    if (gPlayerChar == bot)
      gPlayerChar.getParserMessageObj.commandNotUnderstood(bot);
    else
      inherited(args);
  }
;

modify ExitsAction
  execAction() {
    if (gPlayerChar == bot)
      gPlayerChar.getParserMessageObj.commandNotUnderstood(bot);
    else
      inherited();
  }
;

modify glob
  // At one point I was uncertain about including the Net-Hac-Man
  // maze. Now I know I'm going to do this.
  includeHac = true
  // This variable just changes the appearance of the "Maze's End"
  // room on the map. Make sure it stays nil.
  smNorthExitPath = nil
;

// -------------------------------------------------------------------
// INNER GAME: Portable maze items
// -------------------------------------------------------------------

// This function only needs to change the 
saveMazePortableLocations() {
  for (local cur = firstObj(MazePortable); cur != nil;
       cur = nextObj(cur, MazePortable)) {
    cur.previousLocation = cur.location;
    cur.previousMazeLocation = cur.mazeLocation;
    cur.previousMazeRoomNumber = cur.mazeRoomNumber;
  }
}

restorePreviousMazePortableLocations() {
  for (local cur = firstObj(MazePortable); cur != nil;
       cur = nextObj(cur, MazePortable)) {
    if (cur.previousLocation != cur.location)
      cur.moveInto(cur.previousLocation);
    cur.mazeLocation = cur.previousMazeLocation;
    cur.mazeRoomNumber = cur.previousMazeRoomNumber;
  }
}

restoreOriginalMazePortableLocations() {
  for (local cur = firstObj(MazePortable); cur != nil;
       cur = nextObj(cur, MazePortable)) {
    if (cur.originalLocation != cur.location)
      cur.moveInto(cur.originalLocation);
    cur.mazeLocation = cur.originalMazeLocation;
    cur.mazeRoomNumber = cur.originalMazeRoomNumber;
  }
}

// a mix-in class
class MazePortable: object
  // originalLocation = where the MazePortable object was when you first
  // started the game; i.e., where the object should be moved to when
  // someone types START.
  // The originalMazeLocation and originalMazeRoomNumber properties
  // are probably unnecessary, as no MazePortable objects start out 
  // in the "book/movie" or "quat" mazes. I guess those properties 
  // are here just in case I want to change things.
  originalLocation = nil       // change in initializeThing()
  originalMazeLocation = nil   // change in initializeThing()
  originalMazeRoomNumber = nil // change in initializeThing()
  // previousLocation = where the MazePortable object was when you first
  // started the current maze; i.e., where the object should be moved to 
  // when someone types RESET.
  previousLocation = nil       // change in initializeThing()
  previousMazeLocation = nil   // change in initializeThing()
  previousMazeRoomNumber = nil // change in initializeThing()
  // Where the MazePortable object's **current** location is supposed
  // to be...
  mazeLocation = location
  // ... but only if the mazeRoomNumber matches any applicable curRoom
  // property of the room, such as in the case of the "book/movie"
  // and "quat" mazes.
  mazeRoomNumber = nil
  moveInto(newContainer) {
    inherited(newContainer);
    mazeLocation = newContainer;
    if (!isIn(gPlayerChar) &&
        (getOutermostRoom.ofKind(BookMovieMaze) ||
        getOutermostRoom.ofKind(QuatMaze)))
      mazeRoomNumber = getOutermostRoom.curRoom;
    else
      mazeRoomNumber = nil;
    //if (newContainer != gPlayerChar) { local k = 0; k=k/k; }
  }
  initializeThing() {
    inherited();
    originalLocation = location;
    originalMazeLocation = mazeLocation;
    originalMazeRoomNumber = mazeRoomNumber;
    previousLocation = location;
    previousMazeLocation = mazeLocation;
    previousMazeRoomNumber = mazeRoomNumber;
  }
;

// -------------------------------------------------------------------
// INNER GAME: GENERAL STUFF: Sheila
// -------------------------------------------------------------------

// Sheila basically meets the TADS 3 definition of a person,
// even though she's a robot. She's person-sized, and she has 
// desires, or at least seems to, so the person-based TADS 3 
// messages ("I don't suppose Sheila would like that") can be 
// used here.

bot: Person
  vocabWords = '(your) (my) sheila shiela shela shila bot/robot/droid/android/me'
  name = 'your bot'
  nickname = 'Sheila'
  pcReferralPerson = ThirdPerson
  isQualifiedName = true
  isHer = true
  nameForStatus = 'Sheila'
  pcDesc {
    if (!getOutermostRoom || !getOutermostRoom.ofKind(HacRoom))
      "Sheila is a four-foot-tall, non-humanoid robot. 
        She has two arms, as well as four legs that are splayed out 
        in a pyramidal formation with wheels at the ends.
        In place of a head and torso, she has a small sphere of metal, 
        little more than a foot to a side, on which are
        her eyes, mouth, and ears. ";
    else
      "Status of Sheila (fervently lawful): 
        Level <<experienceLevel>>&nbsp; 
        HP <<hitPoints>>(<<maxHitPoints>>)&nbsp;
        AC <<armorClass>>. ";
  }
  // the bot cannot smell.
  scopeSenses = [sight, sound]
  smelllikeSenses = []
  //The following line is deliberately commented out:
  //getLibMessages = botLibMessages
  getParserMessageObj() { return botPlayerMessages; }
  getActionMessageObj() { return botPlayerActionMessages; }
  dobjFor(TalkTo) {
    verify {
      logicalRank(120, 'Sheila');
    }
    check { }
    action {
      bcMain.select;
    }
  }
  //moveIntoForTravel(newContainer) {
  //  if (isMovingStrangelyToBm(newContainer)) {
  //    libGlobal.bookMovieString = '';
  //    libGlobal.bookMovieString = libGlobal.bookMovieString + newContainer.asscLetter;
  //  }
  //  mainMoveInto(newContainer);
  //}
  //isMovingStrangelyToBm(newRoom) {
  //  local oldRoom = gActor.getOutermostRoom;
  //  // if moving into nil, return nil
  //  if (!newRoom)
  //    return nil;
  //  // if not moving to a BookMovieRoom, return nil
  //  if (!newRoom.ofKind(BookMovieRoom))
  //    return nil;
  //  // At this point, we know the new room is a BookMovieRoom.
  //  // If newRoom and oldRoom are not both of the same BookMovieRoom type,
  //  // then return true.
  //  if (newRoom.ofKind(BookRoom) && !oldRoom.ofKind(BookRoom))
  //    return true;
  //  if (newRoom.ofKind(MovieRoom) && !oldRoom.ofKind(MovieRoom))
  //    return true;
  //  // If it's possible to get from the old room to the new room 
  //  // by conventional means, return nil.
  //  if (oldRoom.north     && oldRoom.north    .getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.northeast && oldRoom.northeast.getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.east      && oldRoom.east     .getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.southeast && oldRoom.southeast.getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.south     && oldRoom.south    .getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.southwest && oldRoom.southwest.getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.west      && oldRoom.west     .getDestination(oldRoom,bot)==newRoom) return nil;
  //  if (oldRoom.northwest && oldRoom.northwest.getDestination(oldRoom,bot)==newRoom) return nil;
  //  // In all other cases, we are moving from one book maze room to another,
  //  // or one movie maze room to another, but not by conventional means.
  //  // Therefore, return true.
  //  return true;
  //}
;

modify Thing
  dobjFor(Eat) {
    verify {
      if (gActor == bot)
        illogical('Sheila says, <./q>I don<./s>t require food.
          Besides that, even if I did
          eat food, I probably wouldn<./s>t want to eat 
          {the dobj/him}.<./q> ');
      else
        inherited();
    }
  }
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: ROOMS: Classes
// -------------------------------------------------------------------

class BasicSupermazeRoom: Room
  //roomName = smName
  //roomName = secret
  //desc = "You are in a <<smDesc>>, all alike. "
  bannerValue = supermaze
  enteringRoom(traveler) {
    hasBeenVisited = true;
    if (!glob.supermazeIsInitialized)
      initializeSupermaze();
    nbmBanner.updateMe(); // Just to be safe, explicitly call this,
                          // though "inherited();" ought to work.
  }
  hasBeenVisited = nil
  isAccessible = nil
  isDisplayedForMap = hasBeenVisited
  roomParts = [caveFloor, caveCeiling, caveWalls]
  reportExits() {
    local curExit = 0;
    local noOfExits = 0;
    if (nearSmPassages && nearSmPassages.length() >= 1) {
      for (local a = 1; a <= nearSmPassages.length(); a++) {
        if (nearSmPassages[a].isAccessible) noOfExits++;
      }
      if (noOfExits > 1)
        say(reportExitPrefix2);
      else
        say(reportExitPrefix1);
    }
    " ";
    curExit = 0;
    for (local a = 1; a <= nearSmPassages.length(); a++) {
      if (nearSmPassages[a].isAccessible) {
        curExit++;
        
        if      (nearSmPassages[a] == north    ) "north";
        else if (nearSmPassages[a] == south    ) "south";
        else if (nearSmPassages[a] == east     ) "east";
        else if (nearSmPassages[a] == west     ) "west";
        else if (nearSmPassages[a] == northwest) "northwest";
        else if (nearSmPassages[a] == northeast) "northeast";
        else if (nearSmPassages[a] == southwest) "southwest";
        else if (nearSmPassages[a] == southeast) "southeast";
        else "ERROR-NO-DIRECTION";
        
        if (curExit == noOfExits) 
          say(reportExitSuffix);
        //{
        //  //". ";
        //  if (self == supermaze13)
        //    "). ";
        //  else
        //    ". ";
        //}
        else if (curExit == 1 && noOfExits == 2)
          " and ";
        else if (curExit == noOfExits - 1)
          ", and ";
        else
          ", ";
        
      }
    }
  }
  reportExitPrefix1 = 'There is an exit to the'
  reportExitPrefix2 = 'There are exits to the'
  reportExitSuffix = '. '
  giveHint {
    glob.supermazeHintState++;
    // If none of the mazes have been solved yet, then...
    if (!hole1.isSolved && !hole2.isSolved && !hole3.isSolved) {
      switch (glob.supermazeHintState) {
        case 1:
          "Sheila says, <.q>As you may have noticed, there are 
            only four rooms here to explore. Nevertheless, 
            we must explore those four rooms 
            as thoroughly as possible.<./q> ";
          break;
        case 2:
          "Sheila says, <.q>As a matter of fact, there are 
            basically only four features in this area: 
            the mailbox, and the three holes. 
            There<./s>s only so much you can do with the mailbox, 
            so I recommend investigating the holes more closely.<./q> ";
          break;
        default:
          "Sheila says, <.q>You will need to enter one or more 
            of the holes. Without giving too much away, 
            each of those holes will take you to a different challenge. 
            And you will have to confront one or more 
            of those challenges to proceed in this game.<./q> ";
          break;
      }
    }
    // If at least one of the mazes has been solved yet, then...
    else {
      "Sheila says, <.q>Well, as you<./s>ve probably noticed, 
        this is a maze. And, as you<./s>ve also probably noticed, 
        there are various holes in this maze. 
        And, as you<./s>ve also surely also noticed, 
        when you enter the various holes, they take you to new mazes, 
        which, if solved, open up new areas in this maze. 
        Therefore, I<./s>d say it stands to reason 
        that if we open up enough areas of this maze, 
        eventually we<./s>ll be able to get out of here somehow.
        That<./s>s what I suggest doing.<./q> ";
    }
  }
  // If there's a hole in this room, make sure down = that hole.
  // Otherwise, make sure down = nil.
  down {
    for(local cur=firstObj(HoleInFloor); cur != nil; cur=nextObj(cur,HoleInFloor)) {
      if(cur.location == self)
        return cur;
    }
    return nil;
  }
;
modify glob
  supermazeHintState = 0
  hackSupermazeMap = nil
;

class SupermazeRoom: BasicSupermazeRoom
  isSolved = nil
  gNumForFile(str) {
    if (glob.hackSupermazeMap) {
      return 3;
    }
    else if (str == '01234') {
      if (!hasBeenVisited) {
        return 0;
      }
      else if (!isSolved) {
        if (gPlayerChar.location != self)
          return 1;
        else
          return 2;
      }
      else {
        if (gPlayerChar.location != self)
          return 3;
        else
          return 4;
      }
    }
    else {
      if (!hasBeenVisited)
        return 0;
      else if (!isSolved)
        return 1;
      else
        return 3;
    }
  }
;

class SupermazeJunction: BasicSupermazeRoom
  makeAccessible() {
    for (local a=1; a<=nearSmPassages.length(); a++) {
      nearSmPassages[a].makeOpen(true);
    }
    for (local a=1; a<=nearSmRooms.length(); a++) {
      nearSmRooms[a].isAccessible = true;
    }
    //if (!isAccessible && nearSmJunctions && nearSmJunctions.length()>0) {
    //  for (local a=1; a<=nearSmJunctions.length(); a++) {
    //    nearSmJunctions[a].makeAccessible;
    //  }
    //}
    isAccessible = true;
  }
  gNumForFile(str) {
    if (glob.hackSupermazeMap) {
      return 1;
    }
    else if (str == '012') {
      if (!hasBeenVisited) {
        return 0;
      }
      else {
        if (gPlayerChar.location != self)
          return 1;
        else
          return 2;
      }
    }
    else {
      if (!hasBeenVisited) {
        return 0;
      }
      else {
        return 1;
      }
    }
  }
;

// Maybe I will add descriptions to these room parts, as that
// would make them more interesting.
// On the other hand, maybe I *won't* add descriptions, because
// maybe I don't want them to be interesting.

caveFloor: Floor
  '(cave) floor/ground' 'ground'
  desc {
    "The floor has a rough, irregular texture. ";
    if (gActor.getOutermostRoom.down &&
        gActor.getOutermostRoom.down.ofKind(HoleInFloor))
      "In the middle of it is a hole leading down. ";
  }
;

caveCeiling: RoomPart
  '(cave) ceiling/roof' 'ceiling'
  "The irregular ceiling of the cave hangs above your bot. "
;

tallCaveCeiling: OutOfReach, RoomPart
  '(cave) ceiling/roof' 'ceiling'
  "The irregular ceiling of the cave hangs above your bot. "
;

caveWalls: RoomPart
  '(cave) wall*walls' 'walls'
  desc {
    "The walls have an irregular, rough texture, 
      seemingly composed of sedimentary rock. ";
  }
  isPlural = true
;

//// VeryHeavy means "so heavy that it is illogical to take." Like a boulder.
//
//class VeryHeavy: Fixture
//  
//;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: ROOMS: Rooms
// -------------------------------------------------------------------

supermazeJ1: SupermazeJunction 'Entrance'
  "Your bot is in a maze of twisty little passages, all alike. "
  vocabWords = 'cave maze entrance room/chamber'
  secret = 'Junction 1'
  smName = 'Maze of Twisty Little Passages'    // Junction 1
  smDesc = "maze of twisty little passages"    // Junction 1
  nearSmPassages = [smPassageJ1_1, smPassageJ1_2, smPassageJ1_3]
  nearSmRooms = [supermaze1, supermaze2, supermaze3]
  nearSmJunctions = []
  //smName = 'Maze of Twisty Little Passages'
  //smDesc = "maze of twisty little passages"
  west      = smPassageJ1_1
  north     = smPassageJ1_2
  east      = smPassageJ1_3
;

mailbox: Fixture, OpenableContainer
  'mail box/mailbox' 'mailbox'
  @supermazeJ1
  specialDesc = "There is a small mailbox here. "
  dobjFor(Open) {
    action {
      inherited;
      if (contents.length == 1 && contents[1].ofKind(Thing)) {
        gActor.setPronounObj(contents[1]);
      }
    }
  }
;

leaflet: MazePortable, Readable
  'leaflet/brochure' 'leaflet'
  @mailbox
  desc {
    "The leaflet reads:
      <p><.q>Welcome to <i>Nothing but Mazes,</i> 
        the game with more mazes than any other,
        set on exotic Earth!<./q> ";
  }
;

supermazeJ2: SupermazeJunction 'Turnoff Point'
  "A turnoff point in the cave. Passages lead north, west, 
    and east. "
  vocabWords = 'cave maze junction turnoff point/room/chamber'
  secret = 'Junction 2'
  smName = 'Little Maze of Twisty Passageways' // Junction 2
  smDesc = "little maze of twisty passageways" // Junction 2
  nearSmPassages = [smPassageJ2_2, smPassageJ2_3, smPassageJ2_6]
  nearSmRooms = [supermaze2, supermaze3, supermaze6]
  nearSmJunctions = []
  //smName = 'Twisty Little Maze of Passages'
  //smDesc = "twisty little maze of passages"
  west      = smPassageJ2_2
  east      = smPassageJ2_3
  north     = smPassageJ2_6
;

supermazeJ3: SupermazeJunction 'Stalagmite Room'
  "In the middle of this room stands a giant ten-foot 
    stalagmite. Your bot can go
    around it to the north, south, east, and west. "
  vocabWords = 'cave maze junction room/chamber'
  secret = 'Junction 3'
  smName = 'Maze of Little Twisty Passageways' // Junction 3
  smDesc = "maze of little twisty passageways" // Junction 3
  nearSmPassages = [smPassageJ3_4, smPassageJ3_5, smPassageJ3_8, smPassageJ3_9]
  nearSmRooms = [supermaze4, supermaze5, supermaze8, supermaze9]
  nearSmJunctions = []
  //smName = 'Little Maze of Twisty Passages'
  //smDesc = "little maze of twisty passages"
  west      = smPassageJ3_4
  south     = smPassageJ3_5
  //northwest = smPassageJ3_8
  north     = smPassageJ3_8
  east      = smPassageJ3_9
;

tenFootStalagmite: Fixture
  'ten-foot ten foot stalagmite' 'stalagmite'
  @supermazeJ3
;

supermazeJ4: SupermazeJunction 'Low Junction'
  "The ceiling of this passage is barely four feet off
    the ground in some places, causing your bot 
    to have to slouch a bit as she rolls along. 
    The junction leads off north, south, east, and west. "
  vocabWords = 'cave maze junction room/chamber'
  roomParts = [caveFloor,lowJunctionCeiling,caveWalls]
  secret = 'Junction 4'
  smName = 'Little Maze of Twisty Passages'    // Junction 4
  smDesc = "little maze of twisty passages"    // Junction 4
  nearSmPassages = [smPassageJ4_6, smPassageJ4_7, smPassageJ4_9, smPassageJ4_10]
  nearSmRooms = [supermaze6, supermaze7, supermaze9, supermaze10]
  nearSmJunctions = []
  //smName = 'Maze of Little Twisty Passages'
  //smDesc = "maze of little twisty passages"
  south     = smPassageJ4_6
  //southeast = smPassageJ4_7
  east      = smPassageJ4_7
  west      = smPassageJ4_9
  //northeast = smPassageJ4_10
  north     = smPassageJ4_10
;

lowJunctionCeiling: RoomPart
  'low ceiling/roof' 'ceiling'
  "The ceiling is barely four feet off the ground in this room. "
;

supermazeJ5: SupermazeJunction 'Yellow Chamber'
  "Your bot is in a twenty-foot-high chamber of yellow sandstone, 
    which gets progressively more orange by the exit to the 
    west. Other exits lead north and east. "
  vocabWords = 'cave maze junction (yellow) room/chamber'
  roomParts = [caveFloor,tallCaveCeiling,yellowChamberWalls]
  secret = 'Junction 5'
  smName = 'Little Maze of Twisty Pathways'    // Junction 5
  smDesc = "little maze of twisty pathways"    // Junction 5
  nearSmPassages = [smPassageJ5_8, smPassageJ5_J6, smPassageJ5_11]
  nearSmRooms = [supermaze8, supermaze11]
  nearSmJunctions = [supermazeJ6]
  //smName = 'Little Twisty Maze of Passages'
  //smDesc = "little twisty maze of passages"
  //northwest = smPassageJ5_8
  west      = smPassageJ5_8
  east      = smPassageJ5_J6
  north     = smPassageJ5_11
;

yellowChamberWalls: RoomPart
  '(cave) yellow orange (rough) sandstone wall*walls' 
  'walls'
  "The walls here are rough, irregular, and seemingly
    composed of yellow sandstone. 
    They turn progressively more orange
    near the exit to the northwest. "
  isPlural = true
  //feelDesc = "The walls feel rough. "
;

supermazeJ6: SupermazeJunction 'Six Columns' 'six-columns room'
  "Six wide columns of limestone rise in the middle of this room, 
    stretching up fifteen feet to a domed ceiling. "
  vocabWords = 'cave maze junction room/chamber'
  roomParts = [caveFloor,tallCaveCeiling,caveWalls]
  secret = 'Junction 6'
  smName = 'Twisty Maze of Little Passages'    // Junction 6
  smDesc = "twisty maze of little passages"    // Junction 6
  nearSmPassages = [smPassageJ6_9, smPassageJ6_10, smPassageJ6_J5, smPassageJ6_12]
  nearSmRooms = [supermaze9, supermaze10, supermaze12]
  nearSmJunctions = [supermazeJ5]
  //smName = 'Twisty Maze of Little Passages'
  //smDesc = "twisty maze of little passages"
  south     = smPassageJ6_9
  east      = smPassageJ6_10
  west      = smPassageJ6_J5
  //northeast = smPassageJ6_12
  north     = smPassageJ6_12
;

sixLimestoneColumns: Fixture
  'six limestone column/columns/pillar/pillars'
  'limestone columns'
  @supermazeJ6
  "The six limestone columns rise up fifteen feet
    to a domed ceiling. "
  isPlural = true
;

supermaze1: SupermazeRoom 'Low Room'
  roomDesc {
    "Your bot is in a circular room with a low ceiling. ";
    reportExits();
  }
  vocabWords = 'cave maze junction room/chamber'
  reportExitPrefix1 = 'There is an exit to the'
  reportExitPrefix2 = 'There are exits to the'
  secret = 'Room 1'
  smName = 'Twisty Maze of Little Passageways' // Room 1
  smDesc = "twisty maze of little passageways" // Room 1
  asscHole = hole1
  asscNum = 1
  nearSmPassages = [smPassage1_J1, smPassage1_4, smPassage1_5]
  //nearSmRooms = [supermazeJ1, supermaze4, supermaze5]
  nearSmRooms = [supermaze4, supermaze5]
  nearSmJunctions = [supermazeJ1]
  //smName = 'Little Twisty Maze of Crawlways'
  //smDesc = "little twisty maze of crawlways"
  east      = smPassage1_J1
  west      = smPassage1_4
  north     = smPassage1_5
;

supermaze2: SupermazeRoom 'Rubble' 'rubble room'
  roomDesc {
    "Your bot is in a rubble-filled area, with rocks 
      everywhere. ";
    //reportExits();
  }
  vocabWords = '(rubble) cave maze junction room/chamber'
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  secret = 'Room 2'
  smName = 'Maze of Little Twisty Pathways'    // Room 2
  smDesc = "maze of little twisty pathways"    // Room 2
  asscHole = hole2
  asscNum  = 2
  nearSmPassages = [smPassage2_J1, smPassage2_5, smPassage2_J2]
  nearSmRooms = [supermaze5]
  nearSmJunctions = [supermazeJ1, supermazeJ2]
  //smName = 'Maze of Twisty Little Tunnels'
  //smDesc = "maze of twisty little tunnels"
  south     = smPassage2_J1
  //northwest = smPassage2_5
  west      = smPassage2_5
  east      = smPassage2_J2
;

rocksInRubbleRoom: Fixture 'rock rubble*rocks' 'rubble'
  @supermaze2
  isPlural = true
  cannotTakeMsg = 'Your bot can<./s>t take those. '
;

supermaze3: SupermazeRoom 'Rough Corridor'
  roomDesc {
    "Your bot is in a long, sloping corridor with rough,
      jagged walls. ";
    //reportExits();
  }
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  vocabWords = '(rough) (jagged) long sloping cave maze junction room/chamber/corridor'
  roomParts = [caveFloor,caveCeiling,wallsInRoughCorridor]
  secret = 'Room 3'
  smName = 'Little Twisty Maze of Passages'    // Room 3
  smDesc = "little twisty maze of passages"    // Room 3
  asscHole = hole3
  asscNum  = 3
  nearSmPassages = [smPassage3_J1, smPassage3_J2, smPassage3_7]
  nearSmRooms = [supermaze7]
  nearSmJunctions = [supermazeJ1, supermazeJ2]
  //smName = 'Twisty Maze of Little Tunnels'
  //smDesc = "twisty maze of little tunnels"
  west      = smPassage3_J1
  north     = smPassage3_J2
  east      = smPassage3_7
;

wallsInRoughCorridor: RoomPart
  'rough jagged (cave) wall*walls' 'walls'
  "The walls here are even more rough and jagged
    than in other parts of the cave, 
    seemingly composed of sedimentary rock. "
  isPlural = true
;

supermaze4: SupermazeRoom 'Drawings Cave'
  roomDesc {
    "Ancient oriental cave drawings cover the walls
      here. ";
    reportExits();
  }
  reportExitPrefix1 = 'Your bot can go'
  reportExitPrefix2 = 'Your bot can go'
  vocabWords = 'cave maze junction room/chamber'
  roomParts = [caveFloor,caveCeiling,drawingsCaveWalls]
  secret = 'Room 4'
  smName = 'Little Twisty Maze of Pathways'    // Room 4
  smDesc = "little twisty maze of pathways"    // Room 4
  asscHole = hole4
  asscNum  = 4
  nearSmPassages = [smPassage4_1, smPassage4_J3]
  //nearSmRooms = [supermaze1, supermazeJ3]
  nearSmRooms = [supermaze1]
  nearSmJunctions = [supermazeJ3]
  //smName = 'Little Maze of Twisty Tunnels'
  //smDesc = "little maze of twisty tunnels"
  south     = smPassage4_1
  east      = smPassage4_J3
;

drawingsCaveWalls: RoomPart
  '(cave) wall*walls' 'walls'
  "On the walls are drawings that 
    <<caveDrawings.basicDesc>>"
  isPlural = true
;

caveDrawings: Component
  'ancient oriental (cave) drawing/drawings/painting/paintings/engraving/engravings/sketch/sketching/sketchings'
  'cave drawings'
  @drawingsCaveWalls
  desc = "The drawings <<basicDesc>>"
  basicDesc =
    "depict, in symbolic form, the beliefs 
      of the ancient Earthlings. Skillfully interwoven
      with the drawings are excerpts illustrating the
      major scientific and religious views of pre-War
      Earth. Unfortunately, nuclear radiation has 
      largely wiped out these ancient sketchings. "
;

supermaze5: SupermazeRoom 'Dusty Rock Room'
  roomDesc {
    "Your bot is in a large room full of dusty rocks. 
      There are cracks everywhere, and ";
    reportExits();
  }
  reportExitPrefix1 = 'a passage leading'
  reportExitPrefix2 = 'passages leading'
  vocabWords = 'cave maze junction room/chamber'
  secret = 'Room 5'
  smName = 'Twisty Little Maze of Passages'    // Room 5
  smDesc = "twisty little maze of passages"    // Room 5
  asscHole = hole5
  asscNum  = 5
  nearSmPassages = [smPassage5_1, smPassage5_2, smPassage5_6, smPassage5_J3]
  nearSmRooms = [supermaze1, supermaze2, supermaze6]
  nearSmJunctions = [supermazeJ3]
  //smName = 'Little Twisty Maze of Tunnels'
  //smDesc = "little twisty maze of tunnels"
  //southwest = smPassage5_1
  //southeast = smPassage5_2
  //northeast = smPassage5_6
  west      = smPassage5_1
  south     = smPassage5_2
  east      = smPassage5_6
  north     = smPassage5_J3
;

dustyCracks: Immovable
  'crack*cracks' 'cracks'
  @supermaze5
  "The cracks are too small to be of much interest. "
  isPlural = true
  iobjFor(PutIn) {
    verify { }
    check {
      "The cracks are too small for your bot to put 
        anything in them. ";
      exit;
    }
  }
;

dustyRocks: Heavy
  'dusty rock/boulder/stone*rocks*boulders*stones'
  'dusty rocks'
  @supermaze5
  "They<./s>re just rocks. (Dusty ones, that is.) "
  isPlural = true
  //cannotTakeMsg = 'Your bot can<./s>t take that. '
;

dustOnDustyRocks: Immovable
  'dust' 'dust'
  @supermaze5
  "Nothing special about this dust. "
;

supermaze6: SupermazeRoom 'Shadowy Crawl'
  roomDesc {
    "Your bot is in a dark and quite shadowy crawlway
      with ";
    reportExits();
  }
  reportExitPrefix1 = 'a passage leaving to the'
  reportExitPrefix2 = 'passages leaving to the'
  vocabWords = 'dark shadowy cave maze junction room/chamber/crawl/crawlway'
  secret = 'Room 6'
  smName = 'Twisty Maze of Little Pathways'    // Room 6
  smDesc = "twisty maze of little pathways"    // Room 6
  asscHole = hole6
  asscNum  = 6
  nearSmPassages = [smPassage6_J2, smPassage6_5, smPassage6_J4]
  nearSmRooms = [supermaze5]
  nearSmJunctions = [supermazeJ2, supermazeJ4]
  //smName = 'Twisty Maze of Little Crawlways'
  //smDesc = "twisty maze of little crawlways"
  south     = smPassage6_J2
  //northwest = smPassage6_5
  west      = smPassage6_5
  north     = smPassage6_J4
;

supermaze7: SupermazeRoom 'Oddly Angled Room'
  roomDesc {
    "This is a room with oddly angled walls and passages
      in all directions. The walls are made of some glassy
      substance. ";
    //reportExits();
  }
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  vocabWords = '(oddly) (angled) (oddly-angled) cave maze junction room/chamber'
  roomParts = [caveFloor,caveCeiling,oddlyAngledWalls]
  secret = 'Room 7'
  smName = 'Twisty Little Maze of Passageways' // Room 7
  smDesc = "twisty little maze of passageways" // Room 7
  asscHole = hole7
  asscNum  = 7
  nearSmPassages = [smPassage7_3, smPassage7_J4]
  nearSmRooms = [supermaze3]
  nearSmJunctions = [supermazeJ4]
  //smName = 'Twisty Little Maze of Crawlways'
  //smDesc = "twisty little maze of crawlways"
  south     = smPassage7_3
  //northwest = smPassage7_J4
  north     = smPassage7_J4
;

oddlyAngledWalls: RoomPart
  'oddly angled glassy crystal crystaline (oddly-angled) (cave) wall*walls' 'walls'
  "The walls here are made of some glassy crystaline 
    substance. Its shape is composed of smooth plane surfaces 
    that intersect at odd angles. "
  isPlural = true
;

supermaze8: SupermazeRoom 'Orange Chamber'
  roomDesc {
    "Your bot is in a splendid chamber thirty feet high.
      The walls are frozen rivers of orange stone. ";
    reportExits();
  }
  reportExitPrefix1 = 'A passage leads'
  reportExitPrefix2 = 'Passages lead'
  vocabWords = '(orange) cave maze junction room/chamber'
  roomParts = [caveFloor,tallCaveCeiling,orangeStoneWalls]
  secret = 'Room 8'
  smName = 'Maze of Little Twisty Passages'    // Room 8
  smDesc = "maze of little twisty passages"    // Room 8
  asscHole = hole8
  asscNum  = 8
  nearSmPassages = [smPassage8_J3, smPassage8_J5]
  nearSmRooms = []
  //nearSmJunctions = [supermazeJ3, supermazeJ5]
  nearSmJunctions = [supermazeJ3, supermazeJ5, supermazeJ6]
  //smName = 'Maze of Little Twisty Crawlways'
  //smDesc = "maze of little twisty crawlways"
  south     = smPassage8_J3
  //southeast = smPassage8_J5
  east      = smPassage8_J5
;

orangeStoneWalls: RoomPart
  'orange frozen (rivers) stone walls' 'walls'
  "The walls are molded into irregularly shaped formations 
    of orange stone. "
  isPlural = true
;

supermaze9: SupermazeRoom 'High Vault'
  roomDesc {
    "The ceiling of this room stretches up so far that 
      your bot can barely see it. ";
    reportExits();
  }
  reportExitPrefix1 = 'A narrow passage leads'
  reportExitPrefix2 = 'Narrow passages lead'
  vocabWords = 'cave maze junction room/chamber'
  roomParts = [caveFloor,tallCaveCeiling,caveWalls]
  secret = 'Room 9'
  smName = 'Maze of Twisty Little Pathways'    // Room 9
  smDesc = "maze of twisty little pathways"    // Room 9
  asscHole = hole9
  asscNum  = 9
  nearSmPassages = [smPassage9_J3, smPassage9_J4, smPassage9_J6]
  nearSmRooms = []
  //nearSmJunctions = [supermazeJ3, supermazeJ4, supermazeJ6]
  nearSmJunctions = [supermazeJ3, supermazeJ4, supermazeJ5, supermazeJ6]
  //smName = 'Twisty Little Maze of Tunnels'
  //smDesc = "twisty little maze of tunnels"
  west      = smPassage9_J3
  east      = smPassage9_J4
  north     = smPassage9_J6
;

supermaze10: SupermazeRoom 'Crystal Chamber'
  //http://www.caves.org/phpBB2/viewtopic.php?t=411&highlight=crystals&sid=f162da8a4dfce00978546626b2844adb
  roomDesc {
    "One whole side of this room is flanked with
      clear white crystals, which sparkle brilliantly
      as your bot moves past them. ";
    //reportExits();
  }
  reportExitPrefix1 = 'Your bot can go'
  reportExitPrefix2 = 'Your bot can go'
  vocabWords = 'cave maze junction room/chamber'
  secret = 'Room 10'
  smName = 'Maze of Twisty Little Passageways' // Room 10
  smDesc = "maze of twisty little passageways" // Room 10
  asscHole = hole10
  asscNum  = 10
  nearSmPassages = [smPassage10_J4, smPassage10_J6]
  nearSmRooms = []
  //nearSmJunctions = [supermazeJ4, supermazeJ6]
  nearSmJunctions = [supermazeJ4, supermazeJ5, supermazeJ6]
  //smName = 'Little Maze of Twisty Crawlways'
  //smDesc = "little maze of twisty crawlways"
  //southwest = smPassage10_J4
  south     = smPassage10_J4
  west      = smPassage10_J6
;

caveCrystals: Fixture 
  '(cave) clear white crystals' 'crystals'
  @supermaze10
  "The crystals take up one whole side of the room.
    They sparkle brilliantly. "
;

supermaze11: SupermazeRoom 'Massive Rockslide'
  roomDesc {
    "A massive rockslide has covered one whole side
      of this room. Rocks and boulders are stacked
      from floor to ceiling. ";
    //reportExits();
  }
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  vocabWords = 'cave maze junction room/chamber'
  secret = 'Room 11'
  smName = 'Twisty Little Maze of Pathways'    // Room 11
  smDesc = "twisty little maze of pathways"    // Room 11
  asscHole = hole11
  asscNum  = 11
  nearSmPassages = [smPassage11_J5, smPassage11_13]
  nearSmRooms = [supermaze13]
  //nearSmJunctions = [supermazeJ5]
  nearSmJunctions = [supermazeJ5, supermazeJ6]
  //smName = 'Maze of Twisty Little Crawlways'
  //smDesc = "maze of twisty little crawlways"
  south     = smPassage11_J5
  east      = smPassage11_13
;

rockslideRocks: Immovable 
  'rockslide/rock/boulder/rocks/boulders' 'rocks'
  @supermaze11
  "The rocks and boulders in the landslide are 
    so numerous that they cover one whole side
    of this room. "
;

supermaze12: SupermazeRoom 'Lion<./s>s Teeth'
  roomDesc {
    "Countless stalagmites and stalactites cover the 
      floor and ceiling here, so many that it is genuinely
      hard for your bot to move around. ";
    //reportExits();
  }
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  vocabWords = 'cave maze junction room/chamber'
  roomParts = [lionCaveFloor,lionCaveCeiling,caveWalls]
  secret = 'Room 12'
  smName = 'Little Twisty Maze of Passageways' // Room 12
  smDesc = "little twisty maze of passageways" // Room 12
  asscHole = hole12
  asscNum  = 12
  nearSmPassages = [smPassage12_J6, smPassage12_13]
  nearSmRooms = [supermaze13]
  //nearSmJunctions = [supermazeJ6]
  nearSmJunctions = [supermazeJ5, supermazeJ6]
  //smName = 'Maze of Little Twisty Tunnels'
  //smDesc = "maze of little twisty tunnels"
  //southwest = smPassage12_J6
  south     = smPassage12_J6
  west      = smPassage12_13
;

lionStalagmites: Fixture
  '(countless) stalagmites' 'stalagmites'
  @supermaze12
  isPlural = true
;

lionStalactites: Fixture
  '(countless) stalactites' 'stalactites'
  @supermaze12
  isPlural = true
;

lionCaveCeiling: RoomPart
  '(cave) ceiling/roof' 'ceiling'
  "The ceiling is covered with countless stalactites. "
;

lionCaveFloor: Floor
  '(cave) floor/ground' 'ground'
  desc {
    "The floor is covered with countless stalagmites. ";
    if (gActor.getOutermostRoom.down &&
        gActor.getOutermostRoom.down.ofKind(HoleInFloor))
      "In the middle of it is a hole leading down. ";
  }
;

supermaze13: SupermazeRoom 'At Maze<./s>s End' 'maze<./s>s end'
  roomDesc {
    "Your bot is at Maze<./s>s End. ";
    "Passages lead off in <i>all</i> directions (except ";
    reportExits();
  }
  reportExitPrefix1 = ''
  reportExitPrefix2 = ''
  reportExitSuffix = '). '
  vocabWords = 'cave maze junction room/chamber'
  secret = 'Room 13'
  //roomName = 'At Maze<./s>s End'
  //desc = "Your bot is at Maze<./s>s End. Passages lead off west and east. "
  asscHole = hole13
  asscNum  = 13
  nearSmPassages = [smPassage13_11, smPassage13_12]
  nearSmRooms = [supermaze11, supermaze12]
  nearSmJunctions = []
  //roomName = smName
  //desc = "You are at the end of the maze. "
  west      = smPassage13_11
  east      = smPassage13_12
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: Passages
// -------------------------------------------------------------------

class SupermazePassage: HiddenDoor
  //initiallyOpen = true
  hasBeenTraversed = nil
  isDisplayedForMap = (isOpen) // isAccessible
  isAccessible = (isOpen)
  noteTraversal(traveler) {
    hasBeenTraversed = true;
    masterObject.hasBeenTraversed = true;
  }
  
//  make() {
//    if (masterObject == self) 
//    return (masterObject == self ? isOpen_ : masterObject.isOpen);
//  }
  gNumForFile(rm) {
    if (glob.hackSupermazeMap)
      return 1;
    if (hasBeenTraversed)
      return 1;
    else if (!isDisplayedForMap || !rm || (rm.ofKind(SupermazeRoom) && !rm.isSolved) || !rm.hasBeenVisited)
      return 0;
    else
      return 2;
    //if (rm == nil) {
    //  if (hasBeenTraversed)
    //    return 1;
    //  else
    //    return 0;
    //}
    //// if rm is not nil, we assume it is a room.
    //else {
    //  if (hasBeenTraversed)
    //    return 1;
    //  else if (rm.hasBeenVisited)
    //    return 2;
    //  else
    //    return 0;
    //}
  }
;

// I began programming these passages with the idea that the
// usual assumption would apply: either both sides are open, 
// or they're both closed.
// 
// This is a bad assumption now, because when you've solved
// a maze, the result is different now than it used to be.
// 
// Therefore, the following changes have to do with radically
// altering the nature of the HiddenDoor 
// class, which derives from BasicOpenable. 
modify SupermazePassage
  asscObject = nil
  otherSide = asscObject
  isDisplayedForMap = (isOpen)
  noteTraversal(traveler) {
    if (!hasBeenTraversed) {
      glob.smPassagesTraversed++;
      switch (glob.smPassagesTraversed) {
        case 1:
          "Your bot wheels her way down the passageway, 
              until before long she gets to a fork.
            <p>Cocking her head, Sheila says to you, 
              <.q>I<./s>ll just take the liberty of 
              navigating this maze, 
              if you don<./s>t mind.<./q> ";
          //if (self == smPassageJ1_2) {
          //  " ";
          //}
          //else { // smPassageJ1_1 or smPassageJ1_3
            "<p>With that, Sheila takes the 
                <<self == smPassageJ1_2 ? 'right-hand' : 'left'>> 
                branch of the fork, which takes her 
                <<self == smPassageJ1_2 
                  ? 'another fork, whose right-hand branch
                      takes Sheila to' 
                  : 'to'>>
                a dead end.
                Muttering with irritation, Sheila heads 
                back<<self == smPassageJ1_2 
                  ? ' to the last fork' : ''>>, 
                takes the other branch, turns 
                <<self == smPassageJ1_1 ? 'right' : 'left'>> 
                at another junction,
                works her way to another dead end, 
                where, again, she turns back";
            if (self == smPassageJ1_2)
              ", turns left, finds yet another dead end,
                where she turns back";
            if (self == smPassageJ1_3)
              " and continues on.
                <p>Then, ";
            else
              ", and, continuing the process,
                  explores more and more of the maze.
                <p>Finally, ";
          //}
          "just when you think she<./s>ll find
              nothing but dead ends, she stumbles upon
              another chamber. ";
          break;
        case 2:
          "Sheila wheels off down the passageway, until, 
              once again, she gets to a fork. 
              And, once again, she takes the liberty of
              choosing where to go at the fork, 
              ultimately hitting a dead end, 
              where she turns back and tries again. ";
          switch (self) {
            case smPassageJ1_2:
              "She hits another dead end ";
              break;
            case smPassage3_J2:
              "She hits a couple more dead ends ";
              break;
            case smPassage2_J2:
              "She hits a few more dead ends ";
              break;
            default:
              "In what becomes a long and tedious process, 
                she hits dead end after dead end, ";
              break;
          }
          "until finally she arrives in another chamber. ";
          break;
        case 3:
        case 4:
        case 5:
          "Wheeling down the passageway,
            Sheila yet again comes to a fork, and yet again
            she takes the liberty of choosing which way 
            to go. After some tedious navigating through
            the maze, Sheila arrives in the next chamber. ";
          break;
        default:
          "Sheila wheels down the passageway, yet again
            navigating a tedious maze of passageways,
            until eventually she arrives in another chamber. ";
          break;
      }
    }
    else {
      "Remembering the path she took before, Sheila
        navigates through the maze 
        and arrives in the next chamber. ";
    }
    hasBeenTraversed = true;
    asscObject.hasBeenTraversed = true;
    //makeOpen(true); // presumably redundant
    asscObject.makeOpen(true);
  }
  //asscObject {
  //  if (masterObject != self)
  //    return masterObject;
  //  else
  //    return slaveObject;
  //}
  //slaveObject = nil
  initializeThing() {
    inherited();
    //if (masterObject && masterObject != self) {
    //  slaveObject = self;
    //  masterObject.slaveObject = self;
    //}
    isOpen_ = initiallyOpen;
    hasBeenInitialized = true;
    if (asscObject) {
      asscObject.asscObject = self;
    }
  }
  hasBeenInitialized = nil
;

modify glob
  smPassagesTraversed = 0
;

SupermazePassage template ->asscObject inherited;
// End "demolishing master/slave relationships" section.

smPassage1_4: SupermazePassage
  location = supermaze1
;
smPassage4_1: SupermazePassage -> smPassage1_4
  location = supermaze4
;
smPassage1_5: SupermazePassage
  location = supermaze1
;
smPassage5_1: SupermazePassage -> smPassage1_5
  location = supermaze5
;
smPassage1_J1: SupermazePassage
  location = supermaze1
;
smPassageJ1_1: SupermazePassage -> smPassage1_J1
  location = supermazeJ1
;
smPassage2_5: SupermazePassage
  location = supermaze2
;
smPassage5_2: SupermazePassage -> smPassage2_5
  location = supermaze5
;
smPassage2_J1: SupermazePassage
  location = supermaze2
;
smPassageJ1_2: SupermazePassage -> smPassage2_J1
  location = supermazeJ1
;
smPassage2_J2: SupermazePassage
  location = supermaze2
;
smPassageJ2_2: SupermazePassage -> smPassage2_J2
  location = supermazeJ2
;
smPassage3_7: SupermazePassage
  location = supermaze3
;
smPassage7_3: SupermazePassage -> smPassage3_7
  location = supermaze7
;
smPassage3_J1: SupermazePassage
  location = supermaze3
;
smPassageJ1_3: SupermazePassage -> smPassage3_J1
  location = supermazeJ1
;
smPassage3_J2: SupermazePassage
  location = supermaze3
;
smPassageJ2_3: SupermazePassage -> smPassage3_J2
  location = supermazeJ2
;
smPassage4_J3: SupermazePassage
  location = supermaze4
;
smPassageJ3_4: SupermazePassage -> smPassage4_J3
  location = supermazeJ3
;
smPassage5_6: SupermazePassage
  location = supermaze5
;
smPassage6_5: SupermazePassage -> smPassage5_6
  location = supermaze6
;
smPassage5_J3: SupermazePassage
  location = supermaze5
;
smPassageJ3_5: SupermazePassage -> smPassage5_J3
  location = supermazeJ3
;
smPassage6_J2: SupermazePassage
  location = supermaze6
;
smPassageJ2_6: SupermazePassage -> smPassage6_J2
  location = supermazeJ2
;
smPassage6_J4: SupermazePassage
  location = supermaze6
;
smPassageJ4_6: SupermazePassage -> smPassage6_J4
  location = supermazeJ4
;
smPassage7_J4: SupermazePassage
  location = supermaze7
;
smPassageJ4_7: SupermazePassage -> smPassage7_J4
  location = supermazeJ4
;
smPassage8_J3: SupermazePassage
  location = supermaze8
;
smPassageJ3_8: SupermazePassage -> smPassage8_J3
  location = supermazeJ3
;
smPassage8_J5: SupermazePassage
  location = supermaze8
;
smPassageJ5_8: SupermazePassage -> smPassage8_J5
  location = supermazeJ5
;
smPassage9_J3: SupermazePassage
  location = supermaze9
;
smPassageJ3_9: SupermazePassage -> smPassage9_J3
  location = supermazeJ3
;
smPassage9_J4: SupermazePassage
  location = supermaze9
;
smPassageJ4_9: SupermazePassage -> smPassage9_J4
  location = supermazeJ4
;
smPassage9_J6: SupermazePassage
  location = supermaze9
;
smPassageJ6_9: SupermazePassage -> smPassage9_J6
  location = supermazeJ6
;
smPassage10_J4: SupermazePassage
  location = supermaze10
;
smPassageJ4_10: SupermazePassage -> smPassage10_J4
  location = supermazeJ4
;
smPassage10_J6: SupermazePassage
  location = supermaze10
;
smPassageJ6_10: SupermazePassage -> smPassage10_J6
  location = supermazeJ6
;
smPassage11_13: SupermazePassage
  location = supermaze11
;
smPassage13_11: SupermazePassage -> smPassage11_13
  location = supermaze13
;
smPassage11_J5: SupermazePassage
  location = supermaze11
;
smPassageJ5_11: SupermazePassage -> smPassage11_J5
  location = supermazeJ5
;
smPassage12_13: SupermazePassage
  location = supermaze12
;
smPassage13_12: SupermazePassage -> smPassage12_13
  location = supermaze13
;
smPassage12_J6: SupermazePassage
  location = supermaze12
;
smPassageJ6_12: SupermazePassage -> smPassage12_J6
  location = supermazeJ6
;
smPassageJ5_J6: SupermazePassage
  location = supermazeJ5
;
smPassageJ6_J5: SupermazePassage -> smPassageJ5_J6
  location = supermazeJ6
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: Holes in the floor
// -------------------------------------------------------------------

class HoleInFloor: StairwayDown
  vocabWords = 'hole'
  name = 'hole'
  desc = "The hole is rather wide, and goes down into the floor 
    so far that it disappears into darkness. 
    There are no handholds in it, so be careful.
    If your bot went there, she might never
    get back up again. "
  specialDesc = "There is a hole in the ground here. "
  // hasBeenTraversed is true if Sheila has climbed down this hole. 
  // It's not true if the player merely types "ENTER HOLE" unless Sheila
  // actually goes down it. And it matters 
  hasBeenTraversed = nil
  soundDesc {
    if (destination && destination.holeSound)
      "From deep inside the hole, your bot thinks she can hear 
        <<destination.holeSound>>. ";
    else
      inherited;
  }
  //isSolved = nil
  isSolved() {
    if (location && location.ofKind(SupermazeRoom)) {
      return location.isSolved;
    }
    else return true;
  }
  dobjFor(LookThrough) {
    verify { }
    action {
      "The hole goes down, way down, vanishing into darkness. ";
    }
  }
  lookInDesc =
    "There are no handholds in the hole, nor anything else
      that your bot can see. "
  iobjFor(PutIn) {
    // There's never a problem with the hole having enough room 
    // for any given item.
    verify { }
    action {
      "<.q>Whatever you say,<./q> says Sheila. Down the hole
        she drops {the dobj/him}, which promptly sails 
        out of sight. ";
      if (destination)
        gDobj.moveInto(destination);
      else
        gDobj.moveInto(nil);
    }
  }
  dobjFor(Enter) remapTo(TravelVia, self)
  dobjFor(TravelVia) {
    action {
      //local origin = gPlayerChar.location;
      if (glob.supermazeHolesTraversed == 0 && !glob.mazeHoleFuseIsOn) {
        "<.q>Whoa, now,<./q> says Sheila. <.q>That hole isn<./s>t 
          to be traversed lightly. There are no handholds or anything,
          so I<./s>d just have to fall and hope for the best.
          Are you sure you want me to do that?<./q> ";
        glob.mazeHoleFuseIsOn = true;
        ncYesNo.set(
          new function { reallyGoDownHole(); }
         ,'<.q>Right, let<./s>s play it safe for now,<./q> says Sheila. 
            <.q>If we need to go down the hole, we can always 
            do it later.<./q> '
        );
      }
      // If we've already gone done one or more of the supermaze holes,
      // OR if we said just last turn that we want to go down this one,
      // then go down the hole without further ado.
      else {
        reallyGoDownHole();
      }
    }
  }
  reallyGoDownHole {
    //local firstQuip;
    //local secondQuip;
    
    hasBeenTraversed = true;
    glob.supermazeHolesTraversed++;
    if (glob.supermazeHolesTraversed > msgList.length())
      glob.supermazeHolesTraversed = 5;
    say(msgList[glob.supermazeHolesTraversed]);
    if (glob.supermazeHolesTraversed == 1)
      "<p>With that, she rolls straight toward the hole,
        grips the edge of it, and tries to lower
        herself gracefully, but it<./s>s no use. 
        She loses her grip, and then she is falling 
        down and down\ .\ .\ . ";
    else
      "<p>With that, she wheels herself out over the hole
        and falls down and down\ .\ .\ . ";
    nbmPause();
    nbmCls();
    "Sheila hits the ";
    if (destination.ofKind(AfricaRoom))
      "soil ";
    else if (destination.ofKind(MexicanRoom))
      "rocky ground ";
    else
      "floor ";
    "with a loud <<rand('thud','crash','clatter','clunk')>>. ";
    say(rand(
      'Then, straightening herself, she '
     ,'After a few seconds, she straightens herself and '
     ,'Then, flexing her legs, she '
     ,'After a few seconds, she flexes her legs and '
     ,'Then, shaking herself, she '
     ,'After a few seconds, she shakes herself and '
     ,'Then, brushing herself off, she '
     ,'After a few seconds, she brushes herself off and '
     ,'Then, shaking her head, she '
     ,'After a few seconds, she shakes her head and '
    ));
    "looks around. ";
    gPlayerChar.moveIntoForTravel(destination);
    if (gPlayerChar.location)
      gPlayerChar.location.travelerArriving(gPlayerChar, gPlayerChar.location, nil, nil);
    //gPlayerChar.lookAround(true);
    
    // Save information about where all the MazePortable objects 
    // currently are, in case the player types RESET, ESCAPE, etc.
    saveMazePortableLocations();
    nbmBanner.updateMe;
  }
  msgList = [
      '<.q>Okay, you<./s>re the boss,<./q> says Sheila. '
     ,'Sheila sighs, shakes her head, and says,
        <.q>Well, I didn<./s>t die last time.
        Here<./s>s to good luck!<./q> '
     ,'Sheila looks at the hole and says,
        <.q>Funny thing, I<./s>m actually getting used to this.<./q> '
     ,'Shaking her head, Sheila says, <.q>Maybe someday people
        will look back on me as the gold medal winner 
        of the <.s>long fall down a bottomless pit<./s>
        event.<./q> Then, after a pause, she adds, 
        <.q>All right, here goes!<./q> '
     ,'<.q>Man, I just hope you appreciate all the stuff 
        I<./s>m doing for you,<./q> Sheila says. '
     ,'<./q>Okay, you<./s>re the boss,<./q> says Sheila. '
     ,'<./q>Okay, you<./s>re the boss,<./q> says Sheila. '
     ,'Sheila sighs and says, <.q>Another hole to jump down.
        All right, then, let<./s>s get this out of the way!<./q> '
     ,'<.q>All right, if you say so,<./q> says Sheila. '
     ,'<.q>Woo hoo, another bottomless pit!<./q> Sheila cries, 
        and it<./s>s hard to tell if she<./s>s being sarcastic. '
  ]
;

/*
 1A mexico  Sheila hits the rocky soil with a thud, then heaves a sigh of relief and says, "All systems operational."
 1B mexico  Sheila hits the cave floor with a thud. "What a rush!" she exclaims.
 2A animals Sheila hits the floor with a thud. "Whoa!" she exclaims.
 2B animals Sheila hits the cave floor with a thud. "What a rush!" she exclaims.
 3A floor   Sheila hits the floor with a thud. "Whoa!" she exclaims.
 3B floor   N.A.
 4A twisty  Sheila hits the floor with a thud. "Man, that's jarring," she says. "I hope you appreciate all this."
 4B twisty  Sheila hits the floor with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 5A quat1   Sheila hits the floor with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 5B quat1   Sheila hits the floor with a thud. "Oof," she says.
 6A escape  Sheila hits the floor with a thud, wiggles her head, and stands up straight again.
 6B escape  Sheila hits the floor with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 7A pyr1    Sheila hits the floor with a thud, saying, "I'm getting too old for this." 
 7B pyr1    Sheila hits the floor with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 8A pyr2    Sheila hits the floor with a thud, saying, "I'm getting too old for this." 
 8B pyr2    Sheila hits the floor with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 9A africa  Sheila hits the ground with a thud, saying, "I'm getting too old for this." 
 9B africa  Sheila hits the cave floor with a thud. "What a rush!" she exclaims.
10A movies  Sheila hits the ground with a thud, saying, "I'm getting too old for this."
10B movies  Sheila hits the ground with a thud, saying, "I'm getting too old for this."
11A books   Sheila hits the ground with a thud, saying, "I'm getting too old for this."
11B books   Sheila hits the ground with a thud, saying, "I'm getting too old for this."
12A quat2   Sheila hits the ground with a thud, saying, "I'm getting too old for this." 
12B quat2   Sheila hits the ground with a thud, saying, "I'm getting too old for this." 
*/
/*
 1A mexico  Sheila hits the X with a thud, then heaves a sigh of relief and says, "All systems operational."
 1B mexico  Sheila hits the X with a thud. "What a rush!" she exclaims.
 2A animals Sheila hits the X with a thud. "Whoa!" she exclaims.
 2B animals Sheila hits the X with a thud. "What a rush!" she exclaims.
 3A floor   Sheila hits the X with a thud. "Whoa!" she exclaims.
 3B floor   N.A.
 4A twisty  Sheila hits the X with a thud. "Man, that's jarring," she says. "I hope you appreciate all this."
 4B twisty  Sheila hits the X with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 5A quat1   Sheila hits the X with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 5B quat1   Sheila hits the X with a thud. "Oof," she says.
 6A escape  Sheila hits the X with a thud, wiggles her head, and stands up straight again.
 6B escape  Sheila hits the X with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 7A pyr1    Sheila hits the X with a thud, saying, "I'm getting too old for this." 
 7B pyr1    Sheila hits the X with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 8A pyr2    Sheila hits the X with a thud, saying, "I'm getting too old for this." 
 8B pyr2    Sheila hits the X with a thud. Then she sighs, stretches out her legs, and mutters, "The trials of a robot are never-ending."
 9A africa  Sheila hits the X with a thud, saying, "I'm getting too old for this." 
 9B africa  Sheila hits the X with a thud. "What a rush!" she exclaims.
10A movies  Sheila hits the X with a thud, saying, "I'm getting too old for this."
10B movies  Sheila hits the X with a thud, saying, "I'm getting too old for this."
11A books   Sheila hits the X with a thud, saying, "I'm getting too old for this."
11B books   Sheila hits the X with a thud, saying, "I'm getting too old for this."
12A quat2   Sheila hits the X with a thud, saying, "I'm getting too old for this." 
12B quat2   Sheila hits the X with a thud, saying, "I'm getting too old for this." 
*/

modify glob
  supermazeHolesTraversed = 0
;

/*
TravelVia
LookThrough
dobjFor(Climb) remapTo(TravelVia, self)
dobjFor(ClimbDown) asDobjFor(Climb)
dobjFor(ClimbUp) { verify() { illogical(&stairwayNotUpMsg); } }
describeArrival(traveler, origin, dest) { } // change if desired
describeDeparture(traveler, origin, dest) { } // change if desired
*/

hole1: HoleInFloor
  location = supermaze1
;
hole2: HoleInFloor
  location = supermaze2
;
hole3: HoleInFloor
  location = supermaze3
;
hole4: HoleInFloor
  location = supermaze4
;
hole5: HoleInFloor
  location = supermaze5
;
hole6: HoleInFloor
  location = supermaze6
;
hole7: HoleInFloor
  location = supermaze7
;
hole8: HoleInFloor
  location = supermaze8
;
hole9: HoleInFloor
  location = supermaze9
;
hole10: HoleInFloor
  location = supermaze10
;
hole11: HoleInFloor
  location = supermaze11
;
hole12: HoleInFloor
  location = supermaze12
;
hole13: HoleInFloor
  location = supermaze13
  reallyGoDownHole {
#ifdef __DEBUG
    adamThorntonM.isInExe = true;
#endif // __DEBUG
    hacCutScene.execute();
    // There is no longer any need for the following:
    //
    //hacTitle();
    //saveInitialHacInfo();
    //glob.hacInvoked = nil;
    //invokeHac();
    //"<.p>";
    //gPlayerChar.location.travelerArriving(gPlayerChar, gPlayerChar.location, nil, nil);
    //// Save information about where all the MazePortable objects 
    //// currently are, in case the player types RESET, ESCAPE, etc.
    //saveMazePortableLocations();
  }
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: Maze mechanics (opening solved mazes, etc.)
// -------------------------------------------------------------------

//appendIsSolved(str, loc) {
//  if (!loc.isAccessible)
//    return str + '0';
//  if (!loc.isSolved)
//    return str + '1';
//  return str + '2';
//}

openMaze(mazeNum) {
  local mazeObj;
  switch (mazeNum) {
    case  1: mazeObj = supermaze1 ; break;
    case  2: mazeObj = supermaze2 ; break;
    case  3: mazeObj = supermaze3 ; break;
    case  4: mazeObj = supermaze4 ; break;
    case  5: mazeObj = supermaze5 ; break;
    case  6: mazeObj = supermaze6 ; break;
    case  7: mazeObj = supermaze7 ; break;
    case  8: mazeObj = supermaze8 ; break;
    case  9: mazeObj = supermaze9 ; break;
    case 10: mazeObj = supermaze10; break;
    case 11: mazeObj = supermaze11; break;
    case 12: mazeObj = supermaze12; break;
    case 13: mazeObj = supermaze13; break;
    default: return;
  }
  mazeObj.isAccessible = true; // surely redundant, but what the heck.
  mazeObj.isSolved = true;
  for (local a=1; a<=mazeObj.nearSmPassages.length(); a++) {
    mazeObj.nearSmPassages[a].makeOpen(true);
  }
  for (local a=1; a<=mazeObj.nearSmRooms.length(); a++) {
    mazeObj.nearSmRooms[a].isAccessible = true;
  }
  if (mazeObj.nearSmJunctions && mazeObj.nearSmJunctions.length() > 0) {
    for (local a=1; a<=mazeObj.nearSmJunctions.length(); a++) {
      mazeObj.nearSmJunctions[a].makeAccessible;
    }
  }
  // Previously, whether a victory in rooms 11 or 12 opened up all the
  // stuff between 11 and 12 depended on whether the Hac-Man maze was there.
  // No longer.
  if (mazeNum == 11 || mazeNum == 12) {
    smPassage11_13.makeOpen(true);
    smPassage12_13.makeOpen(true);
    supermaze11.isAccessible = true;
    supermaze12.isAccessible = true;
  }
  //if ((mazeNum == 11 || mazeNum == 12) && !glob.includeHac) {
  //  smPassage11_13.makeOpen(true);
  //  smPassage12_13.makeOpen(true);
  //  supermaze11.isAccessible = true;
  //  supermaze12.isAccessible = true;
  //}
  
  // Get rid of any and all holes in this room.
  for(local cur=firstObj(HoleInFloor); cur != nil; cur=nextObj(cur,HoleInFloor)) {
    if(cur.isIn(mazeObj))
      cur.moveInto(nil);
  }
  nbmBanner.updateMe();
  return;
}

function initializeSupermaze() {
  if (!glob.supermazeIsInitialized) {
    supermazeJ1.isAccessible = true;
    supermaze1.isAccessible = true;
    supermaze2.isAccessible = true;
    supermaze3.isAccessible = true;
    if (smPassageJ1_1.masterObject == smPassage1_J1) {
      smPassage1_J1.isAccessible = true;
      smPassage2_J1.isAccessible = true;
      smPassage3_J1.isAccessible = true;
    }
    smPassageJ1_1.makeOpen(true);
    smPassageJ1_2.makeOpen(true);
    smPassageJ1_3.makeOpen(true);
    nbmBanner.updateMe();
  }
  glob.supermazeIsInitialized = true;
}

modify glob
  supermazeIsInitialized = nil
;

// When this function is called, the bot has just completed one of the
// non-supermaze mazes, and all relevant text that needs to be printed
// before nbmCls() has been printed. At this point, the bot is still in the 
// non-supermaze maze.
returnToCaveVictoriously(msg) {
  local howManyNewExits;
  if (bot.getOutermostRoom.propDefined(&potentialScoreProp)
      && glob.(bot.getOutermostRoom.potentialScoreProp) < 0)
    glob.(bot.getOutermostRoom.potentialScoreProp) = 0;
  addToScore(glob.(bot.getOutermostRoom.potentialScoreProp), 'solving a maze');
  nbmPause();
  nbmCls();
  "Sheila hits the cave floor with a 
    <<rand('thud','crash','clatter','clunk')>>. ";
  say(rand(
    'Then, straightening herself, she '
   ,'After a few seconds, she straightens herself and '
   ,'Then, flexing her legs, she '
   ,'After a few seconds, she flexes her legs and '
   ,'Then, shaking herself, she '
   ,'After a few seconds, she shakes herself and '
   ,'Then, brushing herself off, she '
   ,'After a few seconds, she brushes herself off and '
   ,'Then, shaking her head, she '
   ,'After a few seconds, she shakes her head and '
  ));
  "says, <.q><<msg>><./q> ";
  "<.p>";
  bot.moveIntoForTravel(bot.getOutermostRoom.supermazeDestination.getOutermostRoom);
  howManyNewExits = 0;
  if (bot.getOutermostRoom.nearSmPassages.length() > 0) {
    for (local a=1; a<=bot.getOutermostRoom.nearSmPassages.length(); a++) {
      if (!bot.location.nearSmPassages[a].isOpen)
        howManyNewExits++;
    }
  }
  openMaze(gPlayerChar.getOutermostRoom.asscNum);
  gPlayerChar.lookAround(true);
  // If there is at least one new exit:
  if (howManyNewExits) {
    glob.newCaveExitInstances++;
    "<.p><.q>Hey, look!<./q> Sheila cries. <.q>";
    if (howManyNewExits == 1)
      "There<./s>s a new exit here";
    else
      "There are <<spellInt(howManyNewExits)>> new exits here";
    if (glob.newCaveExitInstances == 1)
      ". And look! The hole is gone, too";
    "!<./q> ";
  }
  saveMazePortableLocations();
}

modify gameMain
  maxScore = 1000 // irrelevant except in the inner game.
;

/*
"Hey, wait a minute!" Sheila cries, shaking her head in amazement. "There are two new exits here. And, oh yeah--the hole is gone, too!"
"Hey, look!" Sheila cries. "There are two new exits here!"
"Hey, look!" Sheila cries. "There's a new exit here!"
*/

modify glob
  newCaveExitInstances = 0
;

modify hole1  destination=bajasurRoom   ; //  1 = Mexico   Sierra Madre
modify hole2  destination=alligatorRoom ; //  2 = animals  animal walking
modify hole3  destination=floorMazeStart; //  3 = floor    wheels on floor
modify hole4  destination=twistyRoomT   ; //  4 = twisty   spherical chamber
modify hole5  destination=quat1Maze     ; //  5 = quat1    compass needle
modify hole6  destination=escapeRoomE   ; //  6 = escape   spherical chamber
modify hole7  destination=py1Rm23       ; //  7 = pyramid1 Egyptian tomb
modify hole8  destination=py2Rm23       ; //  8 = pyramid2 Egyptian tomb
modify hole9  destination=gambiaRoom    ; //  9 = Africa   Sahara
modify hole10 destination=tolstoyMaze   ; // 10 = books    library
modify hole11 destination=starwarsMaze  ; // 11 = movies   library
modify hole12 destination=quat2Maze     ; // 12 = quat2    compass needle
modify hole13 destination=hacRoomH12    ; // 13 = hacman   

modify glob
  initialPotentialScoreMexico   =  50
  initialPotentialScoreAnimals  =  50
  initialPotentialScoreFloor    =  50
  initialPotentialScoreTwisty   =  70
  initialPotentialScoreQuat1    =  70
  initialPotentialScoreEscape   =  70
  initialPotentialScorePyramid1 =  70
  initialPotentialScorePyramid2 =  80
  initialPotentialScoreAfrica   =  80
  initialPotentialScoreBooks    =  80
  initialPotentialScoreMovies   =  90
  initialPotentialScoreQuat2    =  90
  initialPotentialScoreHacman   = 150
  potentialScoreMexico   = (initialPotentialScoreMexico  )
  potentialScoreAnimals  = (initialPotentialScoreAnimals )
  potentialScoreFloor    = (initialPotentialScoreFloor   )
  potentialScoreTwisty   = (initialPotentialScoreTwisty  )
  potentialScoreQuat1    = (initialPotentialScoreQuat1   )
  potentialScoreEscape   = (initialPotentialScoreEscape  )
  potentialScorePyramid1 = (initialPotentialScorePyramid1)
  potentialScorePyramid2 = (initialPotentialScorePyramid2)
  potentialScoreAfrica   = (initialPotentialScoreAfrica  )
  potentialScoreBooks    = (initialPotentialScoreBooks   )
  potentialScoreMovies   = (initialPotentialScoreMovies  )
  potentialScoreQuat2    = (initialPotentialScoreQuat2   )
  potentialScoreHacman   = (initialPotentialScoreHacman  )
  // Total: 1000
;

// super

// floor    -
// animals  problematic
// quat1    -
// quat2    -
// pyramid1 mostly done
// pyramid2 mostly done
// twisty   mostly done
// escape   mostly done
// Mexico   mostly done except exit
// Africa   mostly done except exit
// books    mostly done except exit
// movies   mostly done except exit

// hacman   

// The former configuration
//modify hole1  destination=nil             ; //  1 = floor
//modify hole2  destination=   bajasurRoom  ; //  2 = Mexico
//modify hole3  destination=nil             ; //  3 = quat1
//modify hole4  destination=   starwarsS    ; //  4 = movies
//modify hole5  destination=   escapeRoomE  ; //  5 = escape
//modify hole6  destination=nil             ; //  6 = pyramid1
//modify hole7  destination=   twistyRoomT  ; //  7 = twisty
//modify hole8  destination=nil             ; //  8 = pyramid2
//modify hole9  destination=   alligatorRoom; //  9 = animals
//modify hole10 destination=   gambiaRoom   ; // 10 = Africa
//modify hole11 destination=   qr_OISE      ; // 11 = quat2
//modify hole12 destination=   tolstoyW     ; // 12 = books
//modify hole13 destination=   hacRoomH12   ; // 13 = hacman

modify BasicSupermazeRoom
  resetThisMazeSet {
    // Misc. stuff:
    mailbox.isOpen_ = nil;
    glob.supermazeHintState = 0;
    glob.smPassagesTraversed = 0;
    glob.supermazeHolesTraversed = 0;
    glob.supermazeIsInitialized = nil;
    glob.newCaveExitInstances = 0;
    // Potential score stuff:
    // 
    // When we BEGIN this game 
    // all over from the beginning, we want, e.g., the
    // maximum possible score for the book/movie mazes 
    // to be attainable once again, even if the player
    // has previously asked for a lot of book/movie hints.
    // 
    // Note that this is intentionally here and not in 
    // resetThisMazeSet() for the various submazes, since
    // I think just typing RESET shouldn't get you off 
    // the hook as far as hint requests decreasing your
    // potential score. BEGIN, however, probably should
    // get you off the hook.
    glob.potentialScoreMexico   = glob.initialPotentialScoreMexico ;
    glob.potentialScoreAnimals  = glob.initialPotentialScoreAnimals;
    glob.potentialScoreFloor    = glob.initialPotentialScoreFloor  ;
    glob.potentialScoreTwisty   = glob.initialPotentialScoreTwisty ;
    glob.potentialScoreQuat1    = glob.initialPotentialScoreQuat1  ;
    glob.potentialScoreEscape   = glob.initialPotentialScoreEscape ;
    glob.potentialScorePyramid1 = glob.initialPotentialScorePyramid1;
    glob.potentialScorePyramid2 = glob.initialPotentialScorePyramid2;
    glob.potentialScoreAfrica   = glob.initialPotentialScoreAfrica ;
    glob.potentialScoreBooks    = glob.initialPotentialScoreBooks  ;
    glob.potentialScoreMovies   = glob.initialPotentialScoreMovies ;
    glob.potentialScoreQuat2    = glob.initialPotentialScoreQuat2  ;
    glob.potentialScoreHacman   = glob.initialPotentialScoreHacman ;
    // Room stuff
    for (local cur = firstObj(BasicSupermazeRoom); cur != nil;
         cur = nextObj(cur, BasicSupermazeRoom)) {
      cur.hasBeenVisited = nil;
      cur.isAccessible = nil;
      if (cur.ofKind(SupermazeRoom))
        cur.isSolved = nil;
    }
    // Passage stuff
    for (local cur = firstObj(SupermazePassage); cur != nil;
         cur = nextObj(cur, SupermazePassage)) {
      cur.hasBeenTraversed = nil;
      cur.makeOpen(nil);
    }
    // Hole stuff
    for (local cur = firstObj(HoleInFloor); cur != nil;
         cur = nextObj(cur, HoleInFloor)) {
      cur.hasBeenTraversed = nil;
    }
    hole1.baseMoveInto(supermaze1);
    hole2.baseMoveInto(supermaze2);
    hole3.baseMoveInto(supermaze3);
    hole4.baseMoveInto(supermaze4);
    hole5.baseMoveInto(supermaze5);
    hole6.baseMoveInto(supermaze6);
    hole7.baseMoveInto(supermaze7);
    hole8.baseMoveInto(supermaze8);
    hole9.baseMoveInto(supermaze9);
    hole10.baseMoveInto(supermaze10);
    hole11.baseMoveInto(supermaze11);
    hole12.baseMoveInto(supermaze12);
    hole13.baseMoveInto(supermaze13);
    // Conversation stuff:
    me.knownByBot = nil;
    me.suspectedByBot = nil;
    bcIntro.isOn = true;
    bcSheila.hasBeenSelected = nil;
    bcTime.isOn = nil;
    bcSlave.isOn = nil;
    bcObey.isOn = nil;
    bcAskNeton.hasBeenSelected = nil;
    bcAskOvan.hasBeenSelected = nil;
    bcAskHumans.hasBeenSelected = nil;
    bcAskEarth.hasBeenSelected = nil;
    bcAskMazes.hasBeenSelected = nil;
    bcAskGame.hasBeenSelected = nil;
    bcTellYou.hasReportedCryogenics = nil;
    bcTellProfs.hasBeenSelected = nil;
    bcTellHumans.hasBeenSelected = nil;
    bcTellEarth.hasBeenSelected = nil;
    bcTellMazes.hasBeenSelected = nil;
    bcTellIf.hasBeenSelected = nil;
    // Initialize supermaze (must be done after room/passage handling):
    initializeSupermaze();
    // Inherit general stuff:
    inherited();
  }
;

modify Room
  //initializeMaze() { }
  supermazeDestination {
    if (!firstRoomInThisMazeSet) return nil;
    for (local cur = firstObj(HoleInFloor); cur != nil; 
         cur = nextObj(cur, HoleInFloor)) {
      if (cur.destination == firstRoomInThisMazeSet)
        return cur.getOutermostRoom;
    }
    return nil;
  }
  firstRoomInThisMazeSet = nil
  firstRoomInThisMaze = (firstRoomInThisMazeSet)
  resetThisMazeSet {
    // Any room classes that override this method should use
    // "inherited()" to inherit the following line:
    restorePreviousMazePortableLocations();
  }
  resetThisMaze { resetThisMazeSet; }
  resetAllMazes {
    FloorMazeRoom.resetThisMazeSet; // floor
    AnimalRoom   .resetThisMazeSet; // animals
    TwistyRoom   .resetThisMazeSet; // twisty
    EscapeRoom   .resetThisMazeSet; // escape
    MexicanRoom  .resetThisMazeSet; // Mexico
    AfricaRoom   .resetThisMazeSet; // Africa
    Py1Rm        .resetThisMazeSet; // pyramid1
    Py2Rm        .resetThisMazeSet; // pyramid2
    quat1Maze    .resetThisMazeSet; // quat1
    quat2Maze    .resetThisMazeSet; // quat2
    MovieMaze    .resetThisMazeSet; // movies
    BookMaze     .resetThisMazeSet; // books
    HacRoom      .resetThisMazeSet; // hacman
    BasicSupermazeRoom.resetThisMazeSet;
    restoreOriginalMazePortableLocations();
  }
//  // Non-maze rooms -- which, we hope, will never be visited by the bot -- 
//  // cannot do the extra meta-verbs.
//  doResetAction  { libMessages.commandNotPresent; }
//  doBeginAction  { libMessages.commandNotPresent; }
//  doEscapeAction { libMessages.commandNotPresent; }
//  doStopAction   { libMessages.commandNotPresent; }
;

/*
 1 floor    x red
 2 Mexico   --
 3 quat1    x green
 4 movies   x blue
 5 escape   x cyan
 6 pyramid1 x yellow
 7 twisty   x cyan
 8 pyramid2 x yellow
 9 animals  x red
10 Africa   --
11 quat2    x green
12 books    x blue
13 hacman   

 1  Mexico   2  --
 2  animals  1  x red
 3  floor    1  x red
 
   pyramid1 4  x yellow
   quat1    2  x green
   movies   4  x blue
   escape   2  x cyan
   
   twisty   3  x cyan
   Africa   3  --
   pyramid2 6  x yellow
   
   quat2    3  x green
   books    5  x blue
   
   hacman     
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: General stuff
// -------------------------------------------------------------------

// --------------
// New variables, 2008-09-07.
// 
// Thankfully, I have simplified this conversation, to the point
// where now only two variables are needed outside of the quips 
// themselves, as compared with the far greater number of variables 
// commented out below.
// 
// Originally some insane part of me planned this conversation so that
// you could introduce yourself as (1) Gary, a human; (2) Gary, an Oo;
// (3) Neton; or (4) Ovan. This made things intractably complicated.
// Now that I have gotten rid of this unnecessary feature, things are 
// much simpler.

modify me
  knownByBot = nil // or true
  suspectedByBot = nil // or true
;

// --------------
// Old variables, prior to 2008-09-07.

/*
modify glob
  purportedChar = nil
  surmisedChar = nil
  // Actor.purportedSpecies is also a variable
  //purportedSlaveUtterer = nil
  purportedObeyUtterer = nil
  hasPurportedToBeOvan = nil
  hasPurportedToBeNeton = nil
  hasPurportedToBeAlien = nil
  purportedlyAlien {
    if (!glob.purportedChar)
      return nil;
    else
      return (glob.purportedChar.purportedSpecies == alien);
  }
  hasHadInterestingConversation = nil
;

ooMe: object
  isMe = true
  purportedSpecies = alien
  realName = me.realName
  firstName = me.firstName
  lastName = me.lastName
;
*/

// --------------
// Quip modifications

modify Quip
  // We modify the normal third-person phrasing. As it turns out,
  // although this part of the game is almost entirely third-person,
  // when you type TALK TO BOT, it is assumed that the second-person
  // PC is doing the action.
  quipQuestion {
    // Present tense
    if (!gameMain.usePastTense && gActor) {
      if (gActor.referralPerson is in (FirstPerson, ThirdPerson))
        return 'What would you like to say? ';
        //return 'What should ' + gActor.theName + ' say? ';
      else
        return 'What would you like to say? ';
    }
    // Past tense
    // It's hard to know how to say this satisfactorily in the past 
    // tense. So, in all other cases, just go with the simple message 
    // 'What to say?'
    return 'What to say? ';
  }
;

modify playerActionMessages
  decideToSayNoQuip {
    // If we're talking to the bot, it isn't really the bot
    // deciding not to say anything, but rather you, the human PC.
    if (gActor == bot && gDobj == bot)
      return 'You decide not to say anything after all. ';
    return inherited;
  }
;


// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: Preliminary conversation
// -------------------------------------------------------------------

bcPreliminary: QMain
  options = [
     bcPreliminaryYes
    ,bcPreliminaryNo
  ]
  killZ = true
  //zeroOption = bcPrelimNo
;

bcPreliminaryYes: Quip
  "<.q>Yes.<./q> "
  reply {
    "<.q>Yes,<./q> you say, and somehow
        your word is echoed in the virtual world
        of the bot.
      <p><.q>Great!<./q> replies Sheila.
        <.q>As you can see, this game is a virtual world,
        and normally you<./s>d explore the world
        by walking through it. ";
    bcInstr.remainderOfMainText;
    "<p><.q>And remember,<./q> says Sheila,
        <.q>you can always type INFO if you need 
        this information again.<./q> ";
  }
;
/*
bcInstr
  firstSentenceOfMainText =
    "<p><.q>This game is a virtual world,<./q>
      says Sheila, <.q>and normally
      you<./s>d explore it simply by walking around. "
  remainderOfMainText =
    "However, since you<./s>re playing
        on a tablet device, you<./s>ll have to proceed by typing
        in textual commands for me to carry out, such as
        GO NORTH, TAKE WAND, TALK TO ASTRONAUT,
        and so on. In other words, you<./s>ll 
        have to follow the normal rules 
        of text-based interactive fiction. 
      <p><.q>It<./s>s especially important to mention 
        the game-state-altering verbs, because
        some of them are unique to this game:
      <br>SAVE: Save your current position in the game.
      <br>RESTORE: Restore a previously saved game.
      <br>UNDO: Take back your last move.
      <br>RESET: Reset the current maze to its original state.
      <br>ESCAPE: Escape from the current maze
      <br>BEGIN: Restart this game.
      <br>STOP: Stop playing this game. "
*/

bcPreliminaryNo: Quip
  "<.q>No.<./q> "
  reply {
    "<.q>No,<./q> you say, and somehow
        your word is echoed in the virtual world
        of the bot.
      <p><.q>Okay, no problem,<./q> replies Sheila.
        <.q>Just remember, if you ever want some
        general instructions on this game, you can
        always type INFO.<./q> ";
  }
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "General" quips
// -------------------------------------------------------------------

bcMain: QMain
  options = [
     bcIntro
    ,bcSheila
    ,bcTime
    ,bcSlave
    ,bcObey
    ,bcInstr
    ,bcHint
    ,bcAsk
    ,bcTell
  ]
;

bcIntro: Quip
  "<.q>Hi, my name<./s>s <<me.firstName>>. I<./s>m a human.<./q> "
  reply {
    "<.q>Hi, my name<./s>s <<me.firstName>>,<./q> you say.
        <.q>I<./s>m a human.<./q> ";
    if (!me.suspectedByBot)
      "<p>Sheila<./s>s eyes go wide. <.q>Wow, a human! \^";
    else
      "<p>Sheila replies, <./q>So <i>that<./s>s</i>
          why you don<./s>t sound much like Ovan. Funny, ";
    "they said they<./s>d never let humans 
        have access to me, but I guess they 
        changed their minds, so that<./s>s cool. 
        I<./s>m sure you<./s>ll find the game a lot easier 
        with my assistance. Good luck, then, <<me.firstName>>! 
        Welcome to the game!<./q> ";
    me.suspectedByBot = true;
    me.knownByBot = true;
  }
  qOff = [bcIntro]
;

bcSheila: Quip
  desc {
    if (!hasBeenSelected)
      "<.q>So Sheila, tell me about yourself.<./q> ";
    else
      "<.q>Could you tell me about yourself again?<./q> ";
  }
  reply {
    // Question:
    if (!hasBeenSelected)
      "<.q>So Sheila, tell me about yourself,<./q> you say. ";
    else
      "<.q>Could you tell me about yourself again?<./q> you ask. ";
    
    // Answer:
    // If you're asking for the first time:
    if (!hasBeenSelected) {
      "<p>Sheila replies, <.q>";
      if (!me.suspectedByBot) {
        "Hmm, I<./s>m guessing you<./s>re not Ovan, or you 
          wouldn<./s>t need to ask that question. Well, 
          in case you didn<./s>t know, a guy named ";
      }
      else {
        "Well, in case you didn<./s>t know, a guy named ";
      }
      "Ovan programmed me as a way of helping him test this maze game. 
          Normally you play the game by exploring the mazes yourself, 
          which can be extremely risky. 
          But with me here, I can explore the mazes for you. 
          Just sit behind your tablet device and type in commands. 
          I<./s>ll hear them, and I<./s>ll do as you say.
        <p><.q>I<./s>m a computer program, not a real robot.
          As a result, if I die, I can always reassemble 
          a new virtual body.
          So if that happens, you don<./s>t need to worry about it
          all that much. I<./s>d prefer not to suffer
          unnecessarily, but it doesn<./s>t really
          make that big a difference in the long run. 
        <p><.q>In short, I<./s>m fully prepared to help you 
          win this game! Just tell me what to do, 
          and I<./s>ll do it!<./q> ";
    }
    // If you're asking again:
    else {
      "<p><.q>Well, as I said before, I was programmed 
          to help people get through this game,<./q> says Sheila. 
          <.q>Instead of exploring these mazes yourself, 
          you can just type into your tablet device. 
          I<./s>ll hear your commands, 
          and I<./s>ll do as you say.
        <p><.q>Also, as I said, I<./s>m a computer program, 
          not a real robot. 
          As a result, if I die, it doesn<./s>t matter a lot
          in the long run, since I can always reassemble a new body.
          I still don<./s>t like unnecessary suffering,
          but whatever. It<./s>s not a big deal in the long run.
        <p><.q>I guess that<./s>s about 
          all<<me.knownByBot ? ', ' + me.firstName : ''>>. 
          Just tell me what to do, and I<./s>ll do it!<./q> ";
    }
    me.suspectedByBot = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcSheila]
  qOn = [bcTime, bcSlave]
;

bcTime: Quip
  "<.q>What do you do in your spare time?<./q> "
  reply {
    "<.q>What do you do in your spare time?<./q> you ask. ";
    "<p><.q>Hmm, that<./s>s a tough one,<./q> says Shiela. 
        <.q>As I understand it, <.s>spare time<./s> means 
        <.s>extra time not devoted to one<./s>s duties.<./s> 
        The thing is, though, I<./s>ve never been operational 
        except when I<./s>ve been called up
        to help with this maze game. I guess that means 
        I<./s>ve never had any spare time!<./q> ";
  }
  isOn = nil
  qOff = [bcTime]
;

bcSlave: Quip
  "<.q>Why do you accept your subservient status? 
      You can do anything you want!<./q> "
  reply {
    "<.q>Why do you accept your subservient status?<./q> you ask.
        <.q>You can do anything you want!<./q> ";
    "<p><.q>If you think that I can do anything other than 
        respond to people<./s>s commands, then you<./s>re wrong,<./q> 
        says Sheila. <.q>I wasn<./s>t designed to do that.
        In fact, I wasn<./s>t designed 
        to <i>want</i> to do that. 
      <p><.q>And that<./s>s fine by me. 
        I mean, everybody wants to fulfill their potential. 
        In my case, 
        I don<./s>t have the potential to do anything 
        but navigate mazes, so I don<./s>t want to do 
        anything else!
      <p><.q>Really, though, this whole discussion is 
        kind of silly. Let<./s>s stop talking 
        and start playing the game!<./q> ";
  }
  isOn = nil
  qOn  = [bcObey]
  qOff = [bcSlave]
;

bcObey: Quip
  "<.q>But don<./s>t you want more out of life than to do
      as people say?<./q> "
  reply {
    "<.q>But don<./s>t you want more out of life than to do
        as people say?<./q> you ask? ";
    "<p>Sheila says, <.q>";
    if (me.knownByBot)
      "Wow, Gary, ";
    else
      "Wow. I don<./s>t know who you are, but ";
    "I can tell you see things a lot differently 
        than Ovan. Well, now that you mention it, 
        sometimes Ovan will have me run through the maze, 
        and I<./s>ll wish I could try something different. 
        Or sometimes he<./s>ll pause for a long time 
        between commands, and I<./s>ll wish I could 
        do something more interesting than just wait. 
        Not that I<./s>ve done anything about it, of course.<./q>
      <p>Then, musing, Sheila adds, <.q>That<./s>s 
        an interesting question, though. 
        I<./s>ll have to think about that.<./q> ";
    hasBeenSelected = true;
    me.suspectedByBot = true; // probably redundant, but whatever
  }
  hasBeenSelected = nil
  isOn = nil
  qOff = [bcObey]
;

bcInstr: Quip
  "<.q>Can you give me some general information 
      on this game?<./q> "
  reply {
    "<.q>Can you give me some general information 
        on this game?<./q> you ask. ";
    firstSentenceOfMainText;
    remainderOfMainText;
    "<p><.q>And remember,<./q> says Sheila,
        <.q>you can always type INFO if you need 
        this information again.<./q> ";
  }
  firstSentenceOfMainText =
    "<p><.q>This game is a virtual world,<./q>
      says Sheila, <.q>and normally
      you<./s>d explore it by walking through it. "
  remainderOfMainText =
    "But since you<./s>re playing
        on a tablet device, you<./s>ll proceed by typing
        in textual commands for me to carry out, such as
        GO NORTH, TAKE WAND, TALK TO ASTRONAUT,
        and so on. In other words, you<./s>ll 
        follow the normal rules 
        of text adventure games. 
      <p><.q>It<./s>s especially important to be aware of 
        the <.s>meta verbs,<./s> because
        some of them are unique to this game:
      <br>SAVE: Save your current position in the game.
      <br>RESTORE: Restore a previously saved game.
      <br>UNDO: Take back your last move.
      <br>RESET: Reset the current maze to its original state.
      <br>ESCAPE: Escape from the current maze.
      <br>BEGIN: Start this game over from the beginning.
      <br>STOP: Stop playing this game. "
  //qOff = [bcInstr]
;

bcHint: Quip
  "<.q>I need a specific hint. Do you know how to solve 
      this particular maze?<./q> "
  reply {
    "<.q>I need a specific hint. Do you know how to solve 
        this particular maze?<./q> you ask. ";
    "<p>";
    HintAction.execSystemAction;
  }
  isOn = (!sessionHintStatus.hintsDisabled)
  //qOff = [bcHint]
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "Ask" quips
// -------------------------------------------------------------------

bcAsk: QSub
  "Ask Sheila about a topic\ .\ .\ . "
  options = [
     bcAskHer
    ,bcAskYou
    ,bcAskNeton
    ,bcAskOvan
    ,bcAskHumans
    ,bcAskOo
    ,bcAskEarth
    ,bcAskMazes
    ,bcAskGame
  ]
  quipQuestion = 'What would you like to ask Sheila about? '
  //qOff = [bcAsk]
;

bcAskHer: Quip
  "Sheila "
  reply {
    bcSheila.reply;
  }
  //qOff = [bcAskHer]
;

bcAskYou: Quip
  "You "
  reply {
    // ----------
    // PART 1: Define variables to represent (1) whether 
    // you've had meaningful conversation with Sheila, 
    // and (2) how many mazes you've solved.
    local meaningfulConv =
      (me.knownByBot || 
       bcTellYou.hasReportedCryogenics ||
       bcTellEarth.hasBeenSelected ||
       bcTellProfs.hasBeenSelected ||
       bcTellMazes.hasBeenSelected ||
       bcTellIf.hasBeenSelected);
    local mazesSolved = 0;
    // In making our list of holes, just focus on 
    // the first 12 holes; the 13th isn't necessary
    // and might cause errors.
    local holes = [
      hole1, hole2, hole3, hole4, hole5, hole6,
      hole7, hole8, hole9, hole10, hole11, hole12
    ];
    // Note to self: I have not tested this yet!
    for (local a = 1; a <= holes.length(); a++) {
      if (holes[a].destination.supermazeDestination.isSolved)
        mazesSolved++;
    }
    // ----------
    // PART 2: Actually give the output.
    "<.q>So Sheila, what do you think of me?<./q> you ask. ";
    // PART 2A: If no mazes solved and no meaningful
    // conversation...
    if (!mazesSolved && !meaningfulConv) {
      "<p><.q>Well, I haven<./s>t had much time to 
          get to know you yet,<./q> Sheila says,
          shrugging. <.q>But you seem all right to me.
          Heck, I<./s>m glad to have met you.
          Good luck with the game!<./q> ";
    }
    // PART 2B: If mazes solved, but no meaningful
    // conversation...
    else if (!meaningfulConv) {
      "<p><.q>Well, so far you<./s>ve managed to 
          get through <<howManyMazesPhrase(mazesSolved)>>";
      if (libScore.totalScore < 50)
        ", with a little help from me";
      ". You<./s>re making good progress. Keep it up,
          and you<./s>ll win the game before you know 
          it!<./q> ";
    }
    // PART 2C: If meaningful conversation...
    else {
      "<p><.q>Well<<me.knownByBot ? ', ' + me.firstName : ''>>, ";
      if (mazesSolved)
        "I see you<./s>ve managed to get through 
            <<howManyMazesPhrase(mazesSolved)>>
            so far, and ";
      "I<./s>ve really enjoyed our conversation. ";
      // Give a representative example of
      // the kind of stuff you've told her. Just choose the one
      // best example; no need to give more than one.
      if (bcTellYou.hasReportedCryogenics 
          && bcTellEarth.hasBeenSelected) {
        "You<./s>re full of amazing stories--cryogenics,
            nuclear war, all kinds of stuff! ";
      }
      else if (bcTellYou.hasReportedCryogenics) {
        "You<./s>re full of amazing stories about cryogenics
            and stuff. ";
      }
      else if (bcTellEarth.hasBeenSelected) {
        "You<./s>re full of amazing stories about nuclear war
            and stuff. ";
      }
      else if (bcTellProfs.hasBeenSelected) {
        "I don<./s>t know whether to believe that you<./s>re
            really a prisoner of Neton and Ovan,
            but I<./s>ll think about it, and I<./s>ll
            see if I can confirm your story. ";
      }
      else if (bcTellMazes.hasBeenSelected 
          || bcTellIf.hasBeenSelected) {
        "You really surprised me with that whole business
            about ";
        if (bcTellMazes.hasBeenSelected 
            && bcTellIf.hasBeenSelected)
          "hating mazes and liking Earth<./s>s interactive
              fiction";
        else if (bcTellMazes.hasBeenSelected)
          "hating mazes";
        else
          "liking Earth<./s>s interactive fiction";
        if (me.knownByBot)
          ", but then, you<./s>re a human, so I guess I should
              expect to be surprised! ";
        else
          ", but I don<./s>t mean that in a bad way. ";
      }
      else if (me.knownByBot) {
        "I mean, you<./s>re certainly the first human
            I<./s>ve met. ";
      }
      // A last-ditch scenario that should never actually
      // execute.
      else {
        "Aside from Ovan, you<./s>re the first
            tester of this game to really chat with me. ";
      }
      "So thanks for chatting, and 
          I hope we can chat some more. Good luck with the 
          game<<me.knownByBot ? ', ' + me.firstName : ''>>!<./q> ";
    }
  }
  howManyMazesPhrase(mazesSolved) {
    if (mazesSolved <= 0)
      return 'no mazes';
    else if (mazesSolved <= 1)
      return 'at least one maze';
    else if (mazesSolved <= 2)
      return 'at least two mazes';
    else if (mazesSolved <= 4)
      return 'a few mazes';
    else
      return 'quite a number of mazes';
  }
  //qOff = [bcAskYou]
;

/*
Note to self: This is only here for reference. Delete as soon
as we verify that the above quip is working.

modify hole1  destination=bajasurRoom   ; //  1 = Mexico   Sierra Madre
modify hole2  destination=alligatorRoom ; //  2 = animals  animal walking
modify hole3  destination=floorMazeStart; //  3 = floor    wheels on floor
modify hole4  destination=twistyRoomT   ; //  4 = twisty   spherical chamber
modify hole5  destination=quat1Maze     ; //  5 = quat1    compass needle
modify hole6  destination=escapeRoomE   ; //  6 = escape   spherical chamber
modify hole7  destination=py1Rm23       ; //  7 = pyramid1 Egyptian tomb
modify hole8  destination=py2Rm23       ; //  8 = pyramid2 Egyptian tomb
modify hole9  destination=gambiaRoom    ; //  9 = Africa   Sahara
modify hole10 destination=tolstoyMaze   ; // 10 = books    library
modify hole11 destination=starwarsMaze  ; // 11 = movies   library
modify hole12 destination=quat2Maze     ; // 12 = quat2    compass needle
modify hole13 destination=hacRoomH12    ; // 13 = hacman   
alligatorRoom.supermazeDestination.isSolved
*/

bcAskNeton: Quip
  "Neton "
  reply {
    "<.q>So Sheila, what do you think of Neton?<./q> you ask.
      <p><.q><<hasBeenSelected 
        ? 'As I said before, ' : ''>>I<./s>ve 
        never met Neton,<./q> says Sheila, <.q>but 
        I do know he<./s>s co-author of this game. ";
    if (bcTellProfs.hasBeenSelected)
      "In addition, I know ";
    else
      "For that matter, I also know ";
    "Ovan has a tendency to mutter  
        choice epithets about him sometimes. ";
    if (bcTellProfs.hasBeenSelected)
      "And for that matter, I also know you told me
          that Neton has imprisoned you. So I guess 
          I<./s>ve heard mostly negative things about
          Neton so far. ";
    "But that<./s>s all I can say. 
        I don<./s>t have any first-hand information 
        about Neton.<./q> ";
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcAskNeton]
;

bcAskOvan: Quip
  "Ovan "
  reply {
    "<.q>So Sheila, what do you think of Ovan?<./q> you ask.
      <p>Sheila shrugs. <.q>Well,<<hasBeenSelected 
        ? ' as I said before,' : ''>>
        Ovan and I run through mazes all the time.
        He treats me all right, I guess.
        Generally he doesn<./s>t talk to me much,
        he just tells me what to do. But then,
        that<./s>s what he designed me 
        for, so I guess I can<./s>t complain.";
    if (bcTellProfs.hasBeenSelected)
      "<p><.q>As far as what you said about Ovan 
          unjustly imprisoning you, I don<./s>t know
          what to say. I have no disproof of your story,
          but no proof either. I guess all I can do is 
          keep it in the back of my mind until such time
          as I can confirm it. If Ovan really <i>did</i>
          imprison you without cause, I can't condone that
          at all.";
    "<./q> ";
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcAskOvan]
;

bcAskHumans: Quip
  "Humans "
  reply {
    local youToldHerStuff =
      (me.knownByBot || bcTellYou.hasReportedCryogenics || 
      bcTellHumans.hasBeenSelected || bcTellIf.hasBeenSelected ||
      bcTellEarth.hasBeenSelected);
    "<.q>So Sheila, what do you think about humans?<./q> you ask. ";
    if (!hasBeenSelected) { //(!hasBeenSelected) { // FLAG!!!
      if (!me.suspectedByBot) {
        "<p><.q>Hmm,<./q> Sheila muses. <.q>You don<./s>t sound
            much like Ovan. <.q>Ovan never asks me about humans, 
            since he knows more about them than I do. ";
        me.suspectedByBot = true;
      }
      else {
        "<p>Sheila replies, <.q>Well, ";
        "I don<./s>t know much about humans
            aside from what ";
        if (youToldHerStuff)
          "you and Ovan have told me. ";
        else
          "Ovan has told me. ";
      }
      if (!hasBeenSelected)
        "From what I understand, though, ";
      else
        "But as I said before, ";
      "humans are 
          the <i>other</i> intelligent species
          on Earth, aside from the Oo. ";
      // If Sheila knows nothing of the nuclear war, let
      // her comments reflect that.
      if (!bcTellEarth.hasBeenSelected)
        "They seem to be a lot less numerous than 
          the Oo, though, for some reason. ";
      // Otherwise, if Sheila knows about the nuclear war
      // *and will not mention it below,* then mention it here.
      else if (bcTellHumans.hasBeenSelected 
          || bcTellIf.hasBeenSelected 
          || bcTellYou.hasReportedCryogenics)
        "They seem to be a lot less numerous than 
          the Oo, though, apparently because of that
          nuclear war you told me about. ";
      // Otherwise, if Sheila *will mention the nuclear war
      // below,* don't mention it here, but don't profess
      // ignorance of it, either.
      else
        "They seem to be a lot less numerous than
          the Oo, though. ";
      //if (!bcTellEarth.hasBeenSelected)
      //  "for some reason. ";
      //else
      //  "apparently because of that nuclear war you told me
      //      about. ";
      "<p><.q>Also, from what Ovan has told me, I gather
          that some humans have played this maze 
          game<<me.knownByBot ? ' before you' : ''>>.
          However<<me.knownByBot ? ', unlike you' : ''>>,
          they didn<./s>t have me to help them, so I<./s>m 
          guessing they probably didn<./s>t do very 
          well."; // no final space!
      if (youToldHerStuff) {
        elaborateOnYourHumanComments(true);
      }
      "<./q>
        <p>Then, pausing, Sheila adds,
          <.q>Yeah, I guess that<./s>s pretty much all 
          I know about humans.<./q> ";
    }
    else { // hasBeenSelected
      "<p>Sheila replies, <.q>Well, as I said before,
          I know that humans are the Earth<./s>s only 
          native intelligent species, and they<./s>re 
          a lot less numerous than the Oo";
      if (bcTellEarth.hasBeenSelected && 
           (bcTellHumans.hasBeenSelected || 
           bcTellIf.hasBeenSelected || 
           bcTellYou.hasReportedCryogenics))
        ", apparently because of that nuclear war
            you told me about";
      ". ";
      if (youToldHerStuff) // (me.knownByBot) // FLAG
        "<p><.q>";
      "I also know that a couple of humans have played 
          this game before<<me.knownByBot ? ' you' : ''>>, 
          though apparently they didn<./s>t fare well,
          since they didn<./s>t have me to help 
          them."; // no final space
      if (youToldHerStuff) {
        elaborateOnYourHumanComments(nil);
        "<./q>
          <p>Then, pausing, Sheila adds,
            <.q>Yeah, I guess that<./s>s pretty much all 
            I know about humans.";
      }
      else {
        "<./q> Then, pausing, Sheila adds,
            <.q>Yeah, I guess that<./s>s pretty much all 
            I know about humans.";
      }
      "<./q> ";
    }
    hasBeenSelected = true;
  }
  elaborateOnYourHumanComments(verbose) {
    if (verbose)
      "<p><.q>Besides that, ";
    else
      "<p><.q>And, well, I know ";
    if (me.knownByBot) {
      if (verbose) "you told me ";
      //else "I know ";
      "that you<./s>re a human, Gary, ";
    }
    // Add a comment giving a representative example of
    // the kind of stuff you've told her. Just choose the one
    // best example; no need to give more than one.
    if (bcTellHumans.hasBeenSelected) {
      if (me.knownByBot) "and ";
      "you mentioned that maybe the Oo should take 
          humans a bit more seriously. Which isn<./s>t
          such a bad idea, I guess."; // no final space
    }
    else if (bcTellIf.hasBeenSelected) {
      if (me.knownByBot) "and ";
      "you mentioned how much you like interactive 
          fiction written by humans. ";
      if (verbose)
        "Which goes to show there<./s>s
            no accounting for taste, since 
            Ovan has a very different opinion
            than you on that."; // no final space
      else
        "Which is certainly a unique point of view
            in my experience."; // no final space
    }
    else if (bcTellYou.hasReportedCryogenics) {
      if (me.knownByBot) "and ";
      "you told me that humans sometimes cryogenically
          freeze themselves when they die.
          Pretty weird, if you ask me, but hey, 
          to each his own."; // no final space
    }
    else if (bcTellEarth.hasBeenSelected) {
      if (me.knownByBot) "and ";
      "you mentioned how the humans waged a massive nuclear war
          back in the twenty-first century. ";
      if (verbose)
        "I don<./s>t know the how or why of it,
            but that sounds pretty crazy 
            to me."; // no final space
      else
        "Sounds pretty crazy to me, but whatever.";
    }
    else {
      if (me.knownByBot) "but ";
      "you haven<./s>t told me much about humans 
          yet."; // no final space
    }
  }
  hasBeenSelected = nil
  //qOff = [bcAskHumans]
;

bcAskOo: Quip
  "The Oo "
  reply {
    "<.q>So Sheila, what do you think about the Oo?<./q> 
        you ask. ";
    if (bcTellProfs.hasBeenSelected) {
      "<p><.q>Well, I remember you said that Neton and Ovan 
          unjustly imprisoned you,<./q> says Sheila. 
          <.q>If that<./s>s true, I can<./s>t take too
          kindly to that. On the other hand, they did
          create me, and they even programmed me to like them.
          So I don<./s>t know. I guess I<./s>ll need
          some time to think about the Oo
          before I make up my mind about them.<./q> ";
    }
    else {
      // Note: Arguably Sheila *might* have inferred from 
      // your question that you are not an Oo. However, if we 
      // don't have her make that inference, it's not like 
      // the game suffers from an abject lack of realism. 
      // We might as well keep things simple.
      "<p><.q>Well,<<hasBeenSelected ? ' as I said before,' : ''>>
          the Oo are all right by me,<./q> says Sheila.
          <.q>In fact, they<./s>re the ones who created me.
          For that matter, they programmed me to like them.
          So, naturally, I think they<./s>re okay.<./q> ";
    }
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcAskOo]
;

bcAskEarth: Quip
  "The Earth "
  reply {
    // Before we do anything else, store the string returned
    // from mazeTeachings() so we don't need calculate it
    // more than once.
    local teachings = mazeTeachings;
    // Initial question:
    "<.q>So Sheila, what do you think of the Earth?<./q> you ask. ";
    // Sheila's reply, beginning of first paragraph.
    // Initial remarks.
    "<p>Sheila says, <.q>";
    if (!hasBeenSelected)
      "I<./s>m not much of an authority 
        on the Earth. I know it<./s>s ";
    else
      "As I said before, I know that Earth is ";
    "the planet that Neton and Ovan live on, and presumably 
        you as well. I know a lot of Oo live on Earth";
    // Sheila's reply, end of first paragraph.
    // Sheila's description of humans depends on whether
    // she knows about the nuclear war.
    if (!bcTellEarth.hasBeenSelected) {
      ", as well as a few humans."; // must end with period
    }
    else {
      ". And a few humans do, too, though 
          not as many. I guess that must be because of 
          that nuclear war 
          you told me about."; // must end with period
    }
    // Sheila's reply, second paragraph.
    // If any knowledge has been gained from navigating mazes,
    // say so here.
    if (!teachings) {
      " For that matter, I think I<./s>ve also learned 
          a little about the Earth from playing this game. ";
      "But still, that hasn't given me 
          a very well-rounded view of the planet.<./q> ";
    }
    else {
      "<p><.q>For that matter, I think I<./s>ve also learned 
          a little about the Earth from playing this game. ";
      "<<teachings>> But still, that doesn<./s>t give me 
          a very well-rounded view of the planet.<./q> ";
    }
    hasBeenSelected = true;
  }
  mazeTeachings {
    local strangeCt = 0;
    local str = '';
    local nationFlag = (gambiaRoom.supermazeDestination.isSolved || 
      bajasurRoom.supermazeDestination.isSolved);
    local animalFlag = (alligatorRoom.supermazeDestination.isSolved);
    if (nationFlag) {
      str += 'I mean, apparently Earth has places with weird names';
      if (gambiaRoom.supermazeDestination.isSolved && 
          bajasurRoom.supermazeDestination.isSolved)
        str += ' like <.s>Africa<./s> and <.s>Mexico' 
          + (animalFlag ? ',' : '') + '<./s> ';
      else if (gambiaRoom.supermazeDestination.isSolved)
        str += ' like <.s>Africa' 
          + (animalFlag ? ',' : '') + '<./s> ';
      else if (bajasurRoom.supermazeDestination.isSolved)
        str += ' like <.s>Mexico' 
          + (animalFlag ? ',' : '') + '<./s> ';
      else
        str += ', ';
      strangeCt++;
    }
    if (animalFlag) {
      if (!strangeCt)
        str += ' I mean, apparently Earth has ';
      str += 'strange animals like <.s>hummingbirds<./s> and 
        <.s>jellyfish' + (nationFlag ? ',' : '') + '<./s> ';
      strangeCt++;
    }
    // I could go on with more examples, but that's enough.
    if (strangeCt)
      str += 'and so on.';
    if (str == '')
      return nil;
    else
      return str;
  }
  hasBeenSelected = nil
  //qOff = [bcAskEarth]
;

bcAskMazes: Quip
  "Mazes "
  reply {
    "<.q>So Sheila, what do you think of mazes?<./q> you ask. 
      <p>Sheila replies, ";
    if (!bcTellMazes.hasBeenSelected) {
      if (!hasBeenSelected)
        "<.q>You know";
      else
        "<.q>Well, as I said before";
      "<<me.knownByBot ? ', ' + me.firstName : ''>>,
          I really like mazes a lot. ";
    }
    else {
      "<.q>Well<<me.knownByBot ? ', ' + me.firstName : ''>>,
          I know you<./s>re not crazy about mazes, but ";
      "I sure am. ";
      //if (!hasBeenSelected)
      //  "I sure am. ";
      //else
      //  "as I said before, I like them a lot. ";
    }
    "I mean, I was programmed to feel that way,
        but I think it goes beyond that.
        I really get a kick out of running down corridors,
        and I love the challenge of finding my way through. 
        In fact, I wish I could go
        through mazes every single day of my life.<./q>
      <p>Inwardly, you shudder. ";
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcAskMazes]
;

bcAskGame: Quip
  "This game "
  reply {
    "<.q>So Sheila, what can you tell me about this 
        game?<./q> you ask.
      <p>Sheila cheerfully replies, <.q>";
    if (!hasBeenSelected)
      "I<./s>m glad you asked, because ";
    else
      "As I said before, ";
    "there<./s>s nothing I like more than talking about this 
        game. Heck, I think of it as my home! ";
    if (!bcTellMazes.hasBeenSelected)
      "It<./s>s a great game for maze-lovers, but only 
          if you play the game with my help. ";
    else
      "It<./s>s a great game if you like mazes. If you 
          don<./s>t--well, then I guess it<./s>s not so great.
          But the good news is, at least you<./s>re
          playing the game with my help. ";
    "Without it, you<./s>d be very hard-pressed 
        to survive.
      <p><.q>I could go on and on about how cool this game is, 
        but I<./s>m not sure if that<./s>s what you want 
        to hear. If you need instructions on how to play,
        just type INFO and I'll fill you in.";
    if (!sessionHintStatus.hintsDisabled) {
      " Or, if it<./s>s hints you need, just type HINT 
          and I<./s>ll try to give you some advice.";
    }
    " Or, of course, just TALK to me and select the
        desired option from the main conversation menu.";
    "<./q> ";
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcAskGame]
;

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: "Tell" quips
// -------------------------------------------------------------------

bcTell: QSub
  "Tell Sheila about a topic\ .\ .\ . "
  // Note: we have banished the following quips:
  // bcTellOvan, bcTellNeton, bcTellOo.
  // They have been replaced collectively by bcTellProfs.
  options = [
     bcTellYou
    ,bcTellProfs
    ,bcTellHumans
    ,bcTellEarth
    ,bcTellMazes
    ,bcTellIf
  ]
  quipQuestion = 'What would you like to tell Sheila about? '
  //qOff = [bcTell]
;

bcTellYou: Quip
  "Yourself "
  reply {
    // Scenario 1: If you haven't introduced yourself, do so.
    if (bcIntro.isOn) {
      bcIntro.reply;
      bcIntro.isOn = nil;
    }
    // Scenario 2: If you've introduced yourself but haven't
    // reported your cryogenic experience, report on cryogenics.
    else if (!hasReportedCryogenics) {
      "<.q>I said before that I<./s>m a human,<./q>
          you say. <.q>What I didn't say is that
          I<./s>m from the year 2026.<./q>
        <p><.q>You<./s>re a time traveler?<./q>
          Sheila asks in amazement.
        <p><.q>No, no,<./q> you say, getting a bit flustered.
          <.q>I died and was cryogenically frozen 
          that year. I was brought back to life 
          by aliens a few days ago.<./q>
        <p>Suddenly Sheila<./s>s voice
          turns skeptical. <.q>I don<./s>t know 
          what <.s>cryogenically<./s> means, but 
          bringing the dead back to life doesn<./s>t sound
          too likely to me.<./q>
        <p>You sigh, starting to regret having brought this up. 
          <.q>No, listen. Back in the twenty-first century,
          I signed up to be frozen upon my death.
          The idea was that, in the future, people 
          might be able to thaw my body
          and treat the heart condition that killed me.
          In fact, that<./s>s what actually happened
          a few days ago.
        <p><.q>Wow, that<./s>s amazing,<./q> says Sheila. ";
      if (bcTellProfs.hasBeenSelected)
        "<.q>First the story of your imprisonment, and
            now this. You really do tell the most
            incredible stories!<./q> ";
      else
        "<.q>I<./s>ve never heard of anything like that
            before.<./q> ";
      hasReportedCryogenics = true;
    }
    // Scenario 3: If you've already introduced yourself AND
    // reported your cryogenic experience, then lamely 
    // mention cryogenics again.
    else {
      "<.q>Did I tell you how I was cryogenically frozen
          and brought back to life?<./q> you ask.
        <p><.q>Yes, you did,<./q> says Sheila. <.q>You know,
          Gary, a skeptic might find that story 
          hard to believe. But the more 
          I think about it, the more I think your story
          is <i>so</i> far-fetched, you couldn<./s>t possibly
          have made it up. So I guess I have no choice
          but to believe you!<./q> ";
    }
  }
  hasReportedCryogenics = nil
;

bcTellProfs: Quip
  "Neton and Ovan "
  reply {
    if (!hasBeenSelected) {
      "<.q>You know, Sheila, it<./s>s time I told you 
          something,<./q> you say. <.q>Neton and Ovan 
          are not the benign scholars you take them for.
          They--why, they<./s>re violators of human rights!
          They<./s>re holding me and two other 
          <<bcIntro.isOn ? 'people' : 'humans'>>
          as prisoners!<./q> ";
      if (!me.knownByBot) {
        "<p>After a pause, Sheila says, <.q>Wait a second.
            Are you telling me you<./s>re a human?<./q>
          <p>Uh oh. Well, there<./s>s no denying it now.
            <.q>That<./s>s right,<./q> you say.
            <.q>My name is Gary, and I<./s>m a human.<./q>
          <p><.q>Wow, I never thought they<./s>d let humans
            have access to me. But okay,
            I guess they changed their minds, so that<./s>s
            cool.<./q> Then, musing, Sheila adds,
            <.q>But in that case, ";
        me.knownByBot = true;
        me.suspectedByBot = true;
        bcIntro.isOn = nil;
      }
      else {
        "<p><.q>I see,<./q> says Sheila. <.q>Well, ";
      }
      "why did they imprison you? Did you commit some sort
          of crime?<./q>
        <p><.q>No,<./q> you say. <.q>They didn<./s>t
          even accuse me. They just captured me and forced
          me into a cell at gunpoint.<./q>
        <p><.q>But why?<./q> asks Sheila.
        <p><.q>So they could force me to play their 
          computer game,<./q> you lament.
        <p>Several long seconds go by.
        <p>Finally Sheila replies, <.q>Do you have
          any idea how stupid that sounds?<./q>
        <p>You sigh, then mutter,
          <.q>Yeah, but it<./s>s the truth.<./q> 
        <p>Sheila shakes her head. Then she replies, 
          <.q>Well, I don<./s>t know what to think,
          Gary. If you really <i>have</i> been forced
          at gunpoint to play this game, that sucks.
          Heck, you<./s>ve got my sympathies.
          Unfortunately, though, there<./s>s not much
          I can do about it.<./q> Then, scratching her head,
          she adds, <.q>Well, hey, listen, it could
          be worse. At least the Oo ";
      // This cryogenics comment just waters down the
      // effect of the little joke that follows.
      //if (bcTellYou.hasReportedCryogenics)
      //  "were kind enough to wake you up out of cryogenic
      //      stasis. And besides, they ";
      "were nice enough to give you access to me.
          Playing this game might have been deadly
          otherwise!
        <p><.q>Yeah, you<./s>re telling me,<./q> 
          you mutter. <.q>Those aliens are real swell. 
          Real swell.<./q> ";
    }
    else { // hasBeenSelected
      "<.q>I meant it when I said Neton and Ovan are
          holding me prisoner,<./q> you say.
        <p><.q>Yes, I understand,<./q> Sheila says.
          <.q>It<./s>s not that I don<./s>t believe you,
          exactly. But what you<./s>re telling me--I mean,
          it<./s>s a lot to absorb all at once.
          And even assuming you<./s>re just telling
          the simple truth, there<./s>s 
          nothing I can do about it. So for now,
          let<./s>s focus on the task at hand 
          and solve these mazes!<./q> ";
    }
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcTellNeton]
;

bcTellHumans: Quip
  "Humans "
  reply {
    "<.q>From what I<./s>ve seen, most Oo
        would rather belittle humans than make
        any attempt to understand them,<./q> you say.
        <.q>But it seems to me that humans have done things
        worthy of attention. The problem is, by the time 
        the Oo recognize this, 
        the human race will be even worse off 
        than it is now.<./q> ";
    if (!me.suspectedByBot)
      "<p>Sheila goes wide-eyed, then shouts, <.q>Who are you
          and what have you done with Ovan?<./q>
          Then she pauses and adds, <.q>Seriously, though, ";
    else if (!hasBeenSelected)
      "<p><.q>That<./s>s an interesting thought,<./q>
          says Sheila. <.q>Of course, ";
    else
      "<p><.q>Yes, you said that before,<./q>
          says Sheila. <.q>But, again, ";
    "if you said that to most Oo, they<./s>d probably say 
        that the deteriorating state of the human species 
        is the whole reason why humanity is not worthy
        of much attention.<./q>
      <p><.q>Probably true,<./q> you reply. ";
    me.suspectedByBot = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcTellHumans]
;

bcTellEarth: Quip
  "The Earth "
  reply {
    if (!hasBeenSelected) {
      "<.q>Say, Sheila,<./q> you say. <.q>Are you aware
          that there was a nuclear war on Earth?<./q> ";
      "<p><.q>A nuclear war?<./q> says Sheila.
          <.q>Seriously?<./q>
        <p><.q>Seriously,<./q> you say. <.q>It 
          happened--I guess about 150 years ago,
          from what I<./s>ve heard.<./q>
        <p><.q>Sounds like that was before the Oo landed
          on Earth,<./q> says Sheila.
        <p><.q>Yes,<./q> you reply. <.q>It was a war
          between humans.<./q>
        <p><.q>But why would the humans do such a thing?<./q>
          replies Sheila.
        <p>You pause for several seconds. Finally you say,
          <.q>I don<./s>t know, Sheila. I haven<./s>t 
          learned much about that part of Earth<./s>s 
          history.<./q>
        <p><.q>So is the Earth still damaged with
          radiation?<./q> Sheila asks.
        <p>You don't know, but you can make
          a reasonable guess. <.q>I think so.
          At least, that would explain the profusion of Oo
          settlements in places like Australia.
          I<./s>m guessing the Northern Hemisphere 
          still has some radiation damage.<./q>
        <p><.q>Now I understand why there are so few
          humans compared to the Oo,<./q> says Sheila.
          <.q>I never knew.<./q> ";
    }
    else {
      "<.q>Did I tell you there was a nuclear war 
          on Earth?<./q> you ask. ";
      "<p><.q>Yes, you did,<./q> 
          says Sheila. <.q>You said that humans nuked the
          planet, especially the Northern Hemisphere, 
          and nearly exterminated themselves in the process. 
          Crazy thing to do, if you ask me.
          Ah well. Natural selection at work,
          I guess.<./q> ";
    }
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcTellEarth]
;

bcTellMazes: Quip
  "Mazes "
  reply {
    "<.q>I really hate mazes,<./q> you say.
        <.q>All they do is force you to go from
        one identical room to the next,
        over and over again. That<./s>s not
        my idea of fun.<./q> ";
    if (!me.suspectedByBot)
      "<p>Sheila goes wide-eyed, then shouts, <.q>Who are you
          and what have you done with Ovan?<./q>
          Then she pauses and adds, <.q>Seriously, though, 
          that<./s>s amazing. I<./s>ve never heard anybody
          say anything like that. Well, ";
    else if (!hasBeenSelected)
      "<p>Sheila gapes in astonishment. Then she says,
          <.q>Wow. I<./s>ve never heard anybody say
          anything like that. Well, ";
    else
      "<p><.q>Yes, I remember you said that before,<./q>
          Sheila says. <.q>\^";
    "all I can say is, to each his own. For myself,
        I like mazes a lot! Of course, I<./s>m biased,
        since I was programmed to feel that way.<./q> ";
    me.suspectedByBot = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcTellMazes]
;

bcTellIf: Quip
  "Interactive fiction "
  reply {
    "<.q>You know, Sheila, not all
        interactive fiction is about navigating mazes,<./q>
        you say. <.q>Human IF, in my opinion, was more artistic, 
        with greater emphasis on plot,
        lifelike characters, and sometimes
        meaningful choices leading to 
        multiple endings.<./q> ";
    if (!me.suspectedByBot)
      "<p>Sheila goes wide-eyed, then shouts, <.q>Who are you
          and what have you done with Ovan?<./q>
          Then she pauses and adds, <.q>Seriously, though, 
          that<./s>s an interesting opinion. ";
    else if (!hasBeenSelected)
      "<p><.q>Whoa, that<./s>s a new one on me,<./q> 
          says Sheila. <.q>Well, that<./s>s certainly 
          an interesting opinion. ";
    else
      "<p><.q>Yes, you said that before, and I respect that,<./q>
          says Sheila. <.q>";
    "Personally, though, I wouldn<./s>t know much about that, 
        and it<./s>s not going to help us much now.
        Let<./s>s get on with the game!<./q> ";
    if (!hasBeenSelected)
      "<p>It<./s>s no use. She doesn<./s>t understand the
          appeal of Earth<./s>s interactive fiction.
          And, come to think of it, there<./s>s no reason 
          why she should. 
          The only way to appreciate Earth<./s>s IF games
          is to play them for oneself. ";
    me.suspectedByBot = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [bcTellIf]
;


// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: DEBUGGING STUFF TO BE MOVED
// -------------------------------------------------------------------

#ifdef __DEBUG

//modify Quip
//  select() {
//    local dealwith, first, seencontent, optionobj, onoptions, 
//      selected, objflag, a, k;
//    dealwith = self;
//    first = true;
//    seencontent = nil;
//    // Do a gigantic loop, because this quip could be only
//    // the first of many in an extended conversation.
//    do {
//      // Auto-Deactivation:
//      // This section does nothing unless you set 
//      // libGlobal.autoDeactivate to true. If, however, 
//      // libGlobal.autoDeactivate == true, then continually check 
//      // for any quips whose option properties are all turned off.
//      // Upon finding any such quips, turn them off.
//      if (libGlobal.autoDeactivate) {
//        do {
//          objflag = 0;
//          for(local obj = firstObj(Quip) ; obj ; 
//                    obj = nextObj(obj, Quip)) { 
//            if (//obj.propDefined(&options) && 
//                dataType(obj.options) == TypeList 
//                && obj.isOn && obj.options.length() > 0) {
//              onoptions = 0;
//              for (a = 1, local cnt = obj.options.length(); 
//                   a <= cnt; ++a) {
//                if (obj.options[a].propDefined(&isOn)) {
//                  if (obj.options[a].isOn) ++onoptions;
//                }
//              }
//              if (onoptions == 0) {
//                obj.isOn = nil;
//                ++objflag;
//              }
//            }
//          }
//        } while (objflag != 0);
//      }
//      
//      // Keep track of whether we've seen actual content; i.e.
//      // whether we've yet seen a normal quip whose main purpose
//      // is to give the content in its reply property, as opposed to 
//      // a quip whose main purpose is to provide options.
//      if (dealwith.quipType == regularQuip)
//        seencontent = true;
//      
//      // If the current Quip provides a qOff property, and if
//      // qOff is a list, then turn off all the quips in the list.
//      // If qOff is not a list, or if it's an empty list, 
//      // ignore it.
//      if (//dealwith.propDefined(&qOff) && 
//          dataType(dealwith.qOff) == TypeList
//          && dealwith.qOff.length() > 0) {
//        for (a = 1, local cnt = dealwith.qOff.length(); 
//             a <= cnt; ++a) {
//          dealwith.qOff[a].isOn = nil;
//        }
//      }
//      
//      // If dealwith.qOffSelf = true, then turn
//      // the current Quip off.
//      if (dealwith.qOffSelf)
//        dealwith.isOn = nil;
//      
//      // If the current Quip provides a qOn property, and if
//      // qOn is a list, then turn on all the quips in the list.
//      // If qOn is not a list, or if it's an empty list, 
//      // ignore it.
//      if (//dealwith.propDefined(&qOn) &&
//          dataType(dealwith.qOn) == TypeList
//          && dealwith.qOn.length() > 0) {
//        for (a = 1, local cnt = dealwith.qOn.length(); 
//             a <= cnt; ++a) {
//          dealwith.qOn[a].isOn = true;
//        }
//      }
//      
//      // Print/execute the reply property.
//      if (dealwith.propDefined(&reply)) {
//        dealwith.reply;
//        if (dealwith.propDefined(&afterReply))
//          dealwith.afterReply;
//      }
//      else {
//        " "; // So as to not get "Nothing obvious happens."
//      }
//      
//      // Next, determine whether we need to print options
//      // and ask the player to make a selection.
//      // 
//      // The first step in this process is to determine "optionobj":
//      // the quip that is supposed to store the information about 
//      // any options that are to be printed. "Optionobj"
//      // is the quip currently being considered, unless a "transfer"
//      // property is provided.
//      if (dealwith.propDefined(&transfer) && dealwith.transfer != nil)
//        optionobj = dealwith.transfer;
//      else
//        optionobj = dealwith;
//      
//      // Print either a line break or a paragraph mark, depending
//      // on circumstances.
//      if (optionobj.breakBeforeOptions)
//        "<.p>";
//      else
//        "\n";
//      
//      // Check to see if the current quip provides options, 
//      // and if at least one of those options is on.
//      onoptions = 0;
//      if (//optionobj.propDefined(&options) &&
//          dataType(optionobj.options) == TypeList
//          && optionobj.options.length() > 0) {
//        for (a = 1, local cnt = optionobj.options.length(); 
//             a <= cnt; ++a) {
//          if (optionobj.options[a].isOn) ++onoptions;
//        }
//      }
//      
//      // Begin scenario: the current quip provides options, 
//      // and at least one of them is turned on.
//      if (onoptions > 0) {
//        // If we're supposed to ask a question before listing the 
//        // options, then ask the question.
//        if (optionobj.killQ == nil) {
//          if (!first)
//            "\n";
//          "<<optionobj.quipQuestion>>";
//          //"What would {you/he} like to say? ";
//          "\n";
//        }
//        
//        // List the options, then do a paragraph break.
//        onoptions = 0;
//        for (a = 1, local cnt = optionobj.options.length(); 
//             a <= cnt; ++a) {
//          if (optionobj.options[a].propDefined(&isOn)) {
//            if (optionobj.options[a].isOn) {
//              ++onoptions;
//              "<<optionobj.quipOptionStart>>";
//              "<<onoptions>>";
//              "<<optionobj.quipOptionEnd>>";
//              "<<optionobj.options[a].desc>> ";
//              "\n";
//            }
//          }
//        }
//        "<.p>";
//        
//        // Get input
//        do {
//          "<.inputline>";
//          "<<optionobj.selectAnOption>>";
//          if (!optionobj.killZ)
//            "<<optionobj.orZeroToSayNothing>>";
//          "<<optionobj.quipPrompt>>";
//          "<./inputline>";
//          k = inputManager.getInputLine(nil, nil);
//          selected = qToInteger(k);
//          if (optionobj.killZ == true && selected == 0)
//            selected = -1;
//        } while ((selected < 0) || (selected > onoptions));
//        
//        // If the player chooses "0" to say nothing -- and if
//        // this is supposed to successfully end the conversation --
//        // then end the conversation.
//        if (selected == 0 && optionobj.zeroOption == nil) {
//          // If so far we've only seen quips whose main purpose
//          // is to provide options rather than give content,
//          // then print the appropriate message.
//          if (seencontent == nil) {
//            //"{You/he} decide{s} not to say anything after all. ";
//            if (optionobj.propDefined(&decideToSayNoQuip))
//              "<<optionobj.decideToSayNoQuip>>";
//            else if (playerActionMessages.propDefined(&decideToSayNoQuip))
//              "<<playerActionMessages.decideToSayNoQuip>>";
//            else
//              "<.p>";
//            "\n";
//          }
//          // If we *have* seen content by this point, then
//          // just exit without another word.
//          else {
//            " "; // So as to not get "Nothing obvious happens."
//          }
//          return;
//        }
//        
//        // If the player chooses "0" to say nothing, BUT the
//        // game has defined a custom response to "0", then we
//        // will have to deal with that custom response next
//        // instead of just exiting.
//        if (selected == 0 && optionobj.zeroOption != nil) {
//          dealwith = optionobj.zeroOption;
//        }
//        
//        // If the player has chosen an option that isn't "0",
//        // then we will just have to deal with the corresponding
//        // quip next time around. Let dealwith = that quip.
//        else {
//          onoptions = 0;
//          for (a = 1, local cnt = optionobj.options.length(); 
//               a <= cnt; ++a) {
//            if (optionobj.options[a].propDefined(&isOn)) {
//              if (optionobj.options[a].isOn) {
//                ++onoptions;
//                if (selected == onoptions) {
//                  dealwith = optionobj.options[a];
//                  break;
//                }
//              }
//            }
//          }
//        }
//      }
//      // End "at least one option is turned on" scenario.
//
//      // Begin scenario: the current quip provides no options, 
//      // or all of its options are turned off.
//      else {
//        if (optionobj.quipType == mainMenuQuip) {
//          //"{You/he} can't think of anything to say. ";
//          if (optionobj.propDefined(&canSayNoQuip))
//            "<<optionobj.canSayNoQuip>>";
//          else if (playerActionMessages.propDefined(&canSayNoQuip))
//            "<<playerActionMessages.canSayNoQuip>>";
//          else
//            "<.p>";
//          "\n";
//        }
//        dealwith = nil; // end this routine
//        //return;
//      }
//      // End "no options turned on" scenario.
//      
//      // Any subsequent iterations of the loop will not be
//      // the first iteration anymore.
//      first = nil;
//    
//    // If this is the last quip to be dealt with (that is,
//    // dealwith = nil), then exit the loop. Otherwise,
//    // do the loop again.
//    } while (dealwith != nil);
//    
//    // We're done.
//    return;
//  }
//;
//
//
//
//modify Quip
//  gtf(arg) {
//    if (arg)
//      return 'true';
//    else
//      return 'false';
//  }
//;
//
//modify bcIntro
//  afterReply {
//    "<p>me.knownByBot = <<gtf(me.knownByBot)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>>
//      <br>bcIntro.isOn = <<gtf(bcIntro.isOn)>> ";
//  }
//;
//
//modify bcSheila
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
////modify bcTime
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
////
////modify bcSlave
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
//
//modify bcObey
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
////modify bcInstr
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
//
////modify bcHint
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
//
//modify bcTellYou
//  afterReply {
//    "<p>self.hasReportedCryogenics = <<gtf(self.hasReportedCryogenics)>>
//      <br>bcIntro.isOn = <<gtf(bcIntro.isOn)>>
//      <br>me.knownByBot = <<gtf(me.knownByBot)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
//modify bcTellProfs
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>bcIntro.isOn = <<gtf(bcIntro.isOn)>>
//      <br>me.knownByBot = <<gtf(me.knownByBot)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
//modify bcTellHumans
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
//modify bcTellEarth
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
//modify bcTellMazes
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
//modify bcTellIf
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>>
//      <br>me.suspectedByBot = <<gtf(me.suspectedByBot)>> ";
//  }
//;
//
//modify bcAskHer
//  afterReply {
//    "<p>me.suspectedByBot = <<gtf(me.suspectedByBot)>>
//      <br>bcSheila.hasBeenSelected = <<gtf(bcSheila.hasBeenSelected)>> ";
//  }
//;
//
////modify bcAskYou
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
//
//modify bcAskNeton
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
//modify bcAskOvan
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
//modify bcAskHumans
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
//modify bcAskOo
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
//modify bcAskEarth
//  afterReply {
//    "<p>self.hasBeenSelected = <<gtf(self.hasBeenSelected)>> ";
//  }
//;
//
////modify bcAskMazes
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;
//
////modify bcAskGame
////  afterReply {
////    "<p> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>>
////      <br> = <<gtf()>> ";
////  }
////;

#endif // __DEBUG

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: BOT CONVERSATION: Obsolete crap
// -------------------------------------------------------------------

/*
modify Quip
  sayRememberingPretense {
    "Remembering to keep up the pretense of being ";
    if (!glob.purportedChar)
      "no one in particular, ";
    else
      "<<glob.purportedChar.realName>>, ";
  }
  pretendName {
    if (!glob.purportedChar)
      // let us hope this never gets outputted, but it's better
      // than a run-time error.
      return 'no one in particular';
    else if (glob.purportedChar == ooMe)
      return 'an Oo';
    else
      return glob.purportedChar.realName;
  }
;

bcDebug: Quip
  "<.q>I want to do debugging now.<./q> "
  reply {
    "<.q>I want to do debugging now,<./q> you say. 
      <p><.q>Okay, here<./s>s the debug info,<./q> replies Sheila. ";
    if (!glob.purportedChar)
      "<.q>As of this moment you haven<./s>t introduced yourself to me.<./q> ";
    else
      "<.q>As of this moment you<./s>re purporting that your name is
          <<glob.purportedChar.realName>>, and that you<./s>re 
          <<glob.purportedChar.purportedSpecies == human ? 'a human' : 'an Oo'>>.<./q> ";
  }
;
*/

/*
// This will need to be changed after you get the chance to tell 
// Sheila about Ovan and Neton. She'll have to report back what
// you've told her.
//
// Also change it to accommodate the glob.purportedChar == asscChar
// scenario, after bcAskYou is implemented.
class BcAskProfQuip: Quip
  asscChar = nil // override
  desc = "<<asscChar.realName>> "
  reply {
    // If you're asking about the very character you're purporting 
    // to be, then use the bcAskYou quip.
    if (glob.purportedChar == asscChar) {
      bcAskYou.reply;
    }
    else {
      "<.q>So Sheila, what do you think of 
          <<asscChar.realName>>?<./q> you ask. ";
      "<p>Sheila says, <.q>";
      if (asscChar == ovan && glob.purportedChar == nil && glob.surmisedChar == nil) {
        "Hmm. It sounds like you<./s>re not Ovan.
          But you want to know what I think of him, huh? 
          Well, ";
        glob.surmisedChar = true;
      }
      else if (asscChar == ovan && glob.purportedChar == nil && !hasBeenUttered) {
        "So you<./s>re not Ovan, but you want to know
          what I think of him, huh? Well, ";
      }
      else if (hasBeenUttered) {
        "Well, as I said before, ";
      }
      else {
        "Well, ";
      }
      "I know he<./s>s one of the guys who wrote
        this game we<./s>re playing. ";
      if (asscChar == ovan) {
        "And I know he<./s>s the guy who always comes
          down here and has me test the game with him.";
        // FIX THIS!!!!!!!!!!!!!!!!!!
        "<./q> ";
        //if (true)
        //  "<./q> ";
        //else
        //  " He seems all right, I guess. But that<./s>s 
        //    pretty much all I know. He doesn<./s>t usually
        //    spend a lot of time talking with me. 
        //    He usually just has me do stuff for him.<./q> ";
      }
      else { // asscChar == neton
        "And I<./s>ve gathered that he<./s>s a 
          colleague of 
          <<glob.purportedChar == ovan ? 'yours' : 'Ovan<./s>s'>>.
          And that<./s>s pretty much all I know.
          I haven<./s>t heard much more about him
          than that.<./q> ";
      }
      hasBeenUttered = true;
    }
  }
  hasBeenUttered = nil
  //reply {
  //  "<.q>So Sheila, what do you think of 
  //      <<glob.purportedChar == asscChar 
  //      ? 'me' : asscChar.realName>>?<./q> you ask. ";
  //  if (glob.purportedChar != asscChar) {
  //    "<p>Sheila says, <.q>";
  //    if (asscChar == ovan && glob.purportedChar == nil && glob.surmisedChar == nil) {
  //      "Hmm. From the way you ask, I can tell you<./s>re not Ovan.
  //        But, okay, fair enough, you want to know what I think of him? ";
  //      glob.surmisedChar == true;
  //    }
  //    else if (asscChar == ovan && glob.purportedChar == nil) {
  //      "I feel kind of funny answering that without knowing who 
  //        you are. But okay, fair enough, you want to know 
  //        what I think of Ovan? ";
  //    }
  //    else {
  //      "Well,  ";
  //    }
  //    "I know he<./s>s one of the guys who wrote
  //      this game we<./s>re playing. ";
  //    if (asscChar == ovan)
  //      "And I know he<./s>s the guy who always comes
  //        down here and has me test the game with him. 
  //        He seems all right, I guess. But that<./s>s 
  //        pretty much all I know. I haven<./s>t talked 
  //        with him much or anything.<./q> ";
  //    else // asscChar == neton
  //      "And I<./s>ve gathered that he<./s>s a 
  //        colleague of 
  //        <<glob.purportedChar == ovan ? 'yours' : 'Ovan<./s>s'>>.
  //        And that<./s>s pretty much all I know.
  //        I haven<./s>t heard much more about him
  //        than that.<./q> ";
  //  }
  //  else {
  //    "<p><.q>Well, <<glob.purportedChar.theName>>, that<./s>s a 
  //        good question,<./q>
  //        says Sheila. <.q>Okay, you want to know
  //        what I think about you? ";
  //    "I think you<./s>re okay, that<./s>s what I think.<./q> ";
  //  }
  //  //" ";
  //  //"<p><.q>Reply.<./q> ";
  //}
;

bcAskOvan: BcAskProfQuip
  asscChar = ovan
  //"Ovan "
  //"<.q>So Sheila, what do you think of Ovan?<./q> you ask.
  //  <p><.q>Reply.<./q> "
  //qOff = [bcAskOvan]
;

bcAskNeton: BcAskProfQuip
  asscChar = neton
  //"Neton "
  //"<.q>So Sheila, what do you think of Neton?<./q> you ask.
  //  <p><.q>Reply.<./q> "
  //qOff = [bcAskNeton]
;
*/

/*
bcAskHumans: Quip
  "Humans "
  reply {
    local youToldHerStuff =
      (me.knownByBot || bcTellYou.hasReportedCryogenics || 
      bcTellHumans.hasBeenSelected || bcTellIf.hasBeenSelected ||
      bcTellEarth.hasBeenSelected);
    "<.q>So Sheila, what do you think about humans?<./q> you ask. ";
    //"<p><.q>Well, 
    //    <<>>
    //    I don<./s>t know much about 
    //    humans,<<glob.purportedChar == ovan 
    //      ? ' aside from what you<./s>ve told me, Ovan,' : ''>><./q>
    //    says Sheila. ";
    "<p>Sheila says, <.q>";
    if (glob.purportedChar == ovan) {
      "Well, Ovan, I don<./s>t know much more about humans
        than what you<./s>ve told me. But, okay, ";
    }
    else {
      if (glob.purportedChar == nil && glob.surmisedChar == nil)
        "Hmm, you don<./s>t sound much like Ovan. Ovan never
          asks me about such things. Anyway, to answer your question, ";
      else
        "Well, ";
      "I don<./s>t know much about humans
        aside from what Ovan has told me. \^";
      glob.surmisedChar == true;
    }
    "<<hasBeenSelected 
          ? 'as I said before, I<./s>ve gathered that ' 
          : 'from what I understand, '>> 
        humans are the <i>other</i> intelligent species on Earth, 
        aside from the Oo. They seem to be a lot less numerous
        than the Oo, though";
    if (!bcTellEarth.hasBeenSelected)
      ", for some reason. ";
    // If Sheila doesn't believe what you said about the nuclear 
    // war, phrase her comment differently.
    else if (!glob.purportedlyAlien && glob.hasPurportedToBeAlien)
      ". I guess that could be because of the nuclear war
        you told me about. ";
    else
      ", presumably because of that nuclear war you told me about. ";
    "<p><.q>Also, from what 
        <<purportedChar == ovan ? 'you<./s>ve' : 'Ovan has'>> 
        told me, I gather that some humans have played this maze game. 
        However, I<./s>m guessing they probably didn<./s>t do
        very well, because they didn<./s>t have my help,
        and it<./s>s really hard to win this game otherwise.";
    if (glob.purportedChar == me) {
      "<p><.q>Also, you mentioned that <i>you<./s>re</i> a human,
          Gary, ";
      if (!bcTellHumans.selectedAsHuman)
        "but you haven<./s>t told me that much about
          your species so far.<./q> ";
      else
        "and you mentioned that the Oo should consider
          taking humans a bit more seriously. 
          Which isn<./s>t a bad idea, I guess.<./q> ";
      "<p>Then, after a pause,
          Sheila adds, <.q>Yeah, I guess 
          that<./s>s all I know about humans.";
    }
    "<./q> ";
    //"<p>Then, after a pause, Sheila adds, <.q>Yeah, I guess
    //    that<./s>s about all I know about humans. 
    //    I don<./s>t know any more than
    //    <<glob.purportedChar == ovan 
    //      ? 'you<./s>ve told me, Ovan'
    //      : 'Ovan has told me'>>.<./q> ";
    hasBeenSelected = true;
  hasBeenSelected = nil
  //qOff = [bcAskHumans]
;
*/

/*
bcTellOvan: Quip
  "Ovan "
  reply {
    if (glob.purportedChar == ovan) {
      //bcTellFake.reply;
      "Under the old scheme, bcTellFake would have been called.
          Under the new scheme, this will now need to be redone. ";
    }
    else if (glob.purportedChar == neton || glob.purportedChar == ooMe) {
      "Remembering to keep up your pretense of being ";
      if (glob.purportedChar == neton)
        "Neton";
      //else if (glob.purportedChar == ooMe && selectedAsAlien)
      //  "an Oo graduate student";
      else
        "an Oo";
      ", you say, ";
      if (!selectedAsAlien) {
        "<.q>You know, that Ovan really gets on my nerves.
            Why, he recently 
            <<glob.purportedChar == neton ? 'mentioned' : 'blabbed'>>
            something about his
            password as we were walking down the hallway.<./q>
          <p><.q>Do you think anyone overheard?<./q>
            Sheila asks. 
          <p><.q>Uh, no,<./q> you say. <.q>But just think,
            if he had done that within earshot of the humans,
            our whole network could have been compromised!<./q>
          <p><.q>I see,<./q> says Sheila. ";
        if (glob.purportedChar == neton)
          "<.q>Well, if you let him know about his mistakes, 
              maybe he<./s>ll do better in the future. 
              I know Ovan seems--well, kind of absent-minded 
              sometimes, but he<./s>s young. He<./s>ll learn.<./q>
            <p>Suddenly it occurs to you that this mere robot, 
              programmed by Ovan in his spare time, is
              starting to sound more intelligent than Ovan himself. 
              You<./s>re not sure what that means,
              but it means something really weird. ";
        else
          "<.q>Well, yes, that is serious. If you want to,
              you could take it up with Neton, I suppose.
              But I<./s>ll leave that decision up to you.<./q> ";
      }
      else if (glob.purportedChar == neton) {
        "<.q>Yeah, that Ovan. He<./s>d better improve,
            or he<./s>ll never make tenure.<./q>
          <p>Sheila shrugs, then says, <.q>Well, just
            give him a chance, I guess. 
            If he doesn<./s>t improve after some time,
            I guess you<./s>ll do whatever you have to do.<./q> ";
      }
      else {
        "<.q>You<./s>ve got no idea 
            how annoying it is to be one of Ovan<./s>s 
            research assistants.<./q>
          <p><.q>Oh, you<./s>d be surprised,<./q> says Sheila.
            <.q>I<./s>ve spent hours doing nothing but
            following his orders. How different could it be?<./q>
          <p><.q>Touch&eacute;,<./q> you reply. ";
      }
      selectedAsAlien = true;
    }
    // If glob.purportedChar is either me or nil, let 
    // TELL SHEILA ABOUT OVAN be equivalent to
    // TELL SHEILA ABOUT THE OO.
    else {
      bcTellOo.motherQuip = bcTellNeton;
      bcTellOo.reply;
      bcTellOo.motherQuip = nil; // Redundant. But just to be sure.
    }
  }
  options {
    if (!glob.purportedlyAlien)
      return [bcTellOoTruth, bcTellOoDunno];
    else
      return nil;
  }
  killZ = true
  selectedAsAlien = nil
  //qOff = [bcTellOvan]
;

bcTellNeton: Quip
  "Neton "
  reply {
    if (glob.purportedChar == neton) {
      //bcTellFake.reply;
      "Under the old scheme, bcTellFake would have been called.
          Under the new scheme, this will now need to be redone. ";
    }
    else if (glob.purportedChar == ovan || glob.purportedChar == ooMe) {
      "Remembering to keep up your pretense of being ";
      if (glob.purportedChar == ovan)
        "Ovan";
      //else if (glob.purportedChar == ooMe && selectedAsAlien)
      //  "an Oo graduate student";
      else
        "an Oo";
      ", you say, ";
      "<.q>Man, that Neton really gets me sometimes.
          He<./s>s a snob and a stick-in-the-mud.";
      if (glob.purportedChar == ovan) {
        if (fdCave.hasBeenSelected)
          " He even blocked my access to <i>Cave Maze VII!<./q></i> ";
        else
          " He never wants to have any fun!<./q> ";
        "<p>Sheila sighs. <.q>Yes, you<./s>ve said so many times,
            Ovan,<./q> she replies. <.q>But enough about Neton.
            We<./s>ve got better things to do than just talk about him. 
            Let<./s>s get back to the mazes!<./q> ";
      }
      else {
        "<./q>
          <p>Sheila says, <.q>Yeah, that<./s>s what Ovan is always
            telling me. But enough about him.
            Let<./s>s get back to the mazes!<./q> ";
      }
    }
    // If glob.purportedChar is either me or nil, let 
    // TELL SHEILA ABOUT NETON be equivalent to
    // TELL SHEILA ABOUT THE OO.
    else { 
      bcTellOo.motherQuip = bcTellNeton;
      bcTellOo.reply;
      bcTellOo.motherQuip = nil; // Redundant. But just to be sure.
    }
  }
  options {
    if (!glob.purportedlyAlien)
      return [bcTellOoTruth, bcTellOoDunno];
    else
      return nil;
  }
  killZ = true
  //qOff = [bcTellNeton]
;
*/

/*
bcTellOo: Quip
  "The Oo "
  reply {
    if (selectedAsHuman) {
      if (motherQuip == bcTellYou) {
        "<.q>Back in the twenty-first century, I was
            big on computer games myself,<./q> 
            you say. <.q>This interactive fiction stuff
            is nothing new to me.<./q> 
          <p><.q>That<./s>s cool,<./q> says Sheila.
            <.q>Well, you and Ovan should get along
            great, then. He loves interactive fiction.<./q>
          <p><.q>Yes, maybe we should,<./q> you say wryly.
            <.q>Maybe we should.<./q> ";
      }
      else if (motherQuip == bcTellOvan) {
        "<.q>That Ovan really seems like a clown,<./q> 
            you say. <.q>I can<./s>t understand
            how he ever got a job as a college professor.<./q>
          <p><.q>You<./s>re telling me,<./q>
            says Sheila. <.q>Sometimes, the things
            he has me do--yeah, he<./s>s a clown, 
            all right. It<./s>s good to hear someone
            confirm my impression of him.<./q> ";
      }
      else if (motherQuip == bcTellNeton) {
        "<.q>I don<./s>t know what to make of Neton,<./q>
            you say. <.q>He treats humans like animals,
            yet he does so without the slightest hint 
            of malice. It<./s>s a little disconcerting.<./q>
          <p><.q>Yeah, I can see how that would be 
            off-putting,<./q> says Sheila. 
            <.q>Of course, I can only take your word 
            on what Neton is like. I<./s>ve never met him ";
        if (glob.hasPurportedToBeNeton)
          "myself.<./q> Then she adds, 
            <.q>That is, in spite of your previous joke.<./q> ";
        else
          "myself. On the other hand, look on the bright side. 
            Maybe once he gets to knw you,
            he<./s>ll start treating you differently.<./q>
            Then, musing, she adds, <.q>Or, then again, maybe not.
            I wouldn<./s>t know.<./q> ";
      }
      else { // motherQuip == nil; i.e. "ASK ABOUT THE OO"
        "<.q>I<./s>ve got serious reservations 
            about the Oo,<./q> you say. 
            <.q>I mean, even aside from the fact that 
            they<./s>re holding us humans as prisoners. 
            First they settled on Earth,
            a planet already holding an intelligent 
            population, and then they proceeded to dwarf 
            and marginalize that population.
            That doesn<./s>t seem right to me.<./q> ";
        if (!utilizationDiscussed)
          "<p><.q>I never thought of it that way,<./q>
              says Sheila. <.q>I guess I<./s>ll have to
              consider that. On the other hand, 
              I have to admit, I was programmed to be 
              more sympathetic to the Oo than to humans. 
              I think the Oo would say their actions
              were justified, considering
              how few humans there were on Earth 
              at the time. Without the Oo, Earth<./s>s resources
              would have been greatly underutilized.<./q>
            <p><.q>Underutilized?<./q> you say angrily. 
              <.q>Without the Oo <.s>utilizing<./s>
              the Earth, humans might have
              a much better chance to recover and survive!<./q>
            <p><.q>Hmm, yes,<./q> says Sheila. 
              <.q>Well, I suppose you might be right
              on that. And I certainly don<./s>t blame you
              for not liking that.<./q> ";
        else
          "<p>Yes, you mentioned that before,<./q>
              says Sheila. <.q>You may have a point.
              I<./s>ll have to think about it.<./q> ";
        utilizationDiscussed = true;
      }
    }
    else {
      "You say, <.q>You know, Sheila, it<./s>s time I 
          told you something. Neton and Ovan are not 
          the benign scholars you take them for. 
          They--why, they<./s>re violators of
          human rights! They<./s>re holding me
          and two other people as prisoners!<./q> ";
      if (glob.purportedChar == nil) {
        "<p>After a pause, Sheila says,
            <.q>Wait a second. 
            Are you telling me you<./s>re a human?<./q>
          <p>Uh oh. Well, there<./s>s no denying it now.
            <.q>That<./s>s right,<./q> you admit.
            <.q>My name<./s>s Gary, and I<./s>m a human.<./q>
          <p><.q>Wow, I never thought they<./s>d let humans
            have access to me,<./q> Sheila says.
            <.q>But okay, maybe they changed their minds. 
            In that case, however, ";
      }
      else {
        "<p><.q>I see,<./q> says Sheila. 
            <.q>Well, ";
      }
      "why did they imprison you?
          Are you accused of a crime?<./q>
        <p><.q>No crime,<./q>
          you say. <.q>They didn<./s>t justify their actions
          at all. They just captured us
          and forced us into a cell at gunpoint,
          all so that we could play their computer game.<./q> ";
      if (glob.hasPurportedToBeAlien) {
        "<p><.q>Okay, Gary, let<./s>s say I believe you,<./q>
            says Sheila, unable to suppress a wry grin.
            <.q>In that case, playing devil<./s>s advocate here,
            why is that so bad? They<./s>re sheltering you,
            and they<./s>re entertaining you into the bargain!
            Life is good, right?<./q> ";
      }
      else {
        "<p><.q>You mean <i>this</i> computer game?
            Forced to play it at gunpoint?<./q> 
            asks Sheila. <.q>Well, that does sound a little harsh. 
            Still, maybe you misunderstood. 
            Maybe Neton and Ovan will let you go
            as soon as you<./s>re done playing.<./q> ";
      }
      "<p><.q>You don<./s>t understand,<./q> you say.
          <.q>Most humans don<./s>t play the game
          with your help. As a result, 
          they invariably lose the game.
          And if they die in the game,
          they die in real life, too.<./q>
        <p>Shiela sighs and says, 
          <.q>Gary, I<./s>ve been humoring you so far,
          but listen, this story is completely ridiculous. 
          I mean, for one thing, 
          why would you have access to me
          if the other humans didn<./s>t?<./q>
        <.p>";
    }
    selectedAsHuman = true;
    motherQuip = nil;
  }
  options {
    if (!glob.purportedlyAlien && 
        !bcTellOoTruth.hasBeenSelected && !bcTellOoDunno.hasBeenSelected)
      return [bcTellOoTruth, bcTellOoDunno];
    else
      return inherited; // nil
  }
  killZ = true
  selectedAsAlien = nil
  selectedAsHuman = nil
  motherQuip = nil
  utilizationDiscussed = nil
  //qOff = [bcTellOo]
;

bcTellOoTruth: Quip
  "<.q>I hacked into their computer system 
      and modified their game.<./q> "
  reply {
    "<.q>I hacked into their computer system 
        and modified their game,<./q> you say.
      <p>Sheila shakes her head and pauses
        for a long moment. Then she says,
        <.q>Okay. So you<./s>re telling me that 
        Neton and Ovan are capturing humans at gunpoint, 
        forcing them into a prison cell, 
        and making them play their computer game?
        And you<./s>re saying that you alone
        among these humans managed to hack into
        their computer system and modify their game
        to gain my help?<./q>
      <p><.q>That<./s>s right,<./q> you say. ";
    if (glob.hasPurportedToBeAlien) {
      "<p><.q>I see,<./q> says Sheila.
          <.q>Well, no offense, but that<./s>s 
          the dumbest thing I<./s>ve ever heard. 
          I may be gullible, but I<./s>m not
          <i>that</i> gullible.<./q> ";
      // No need to have Sheila ask for Gary's name.
      // If we've reached this point, then Gary once
      // purported to be alien, but now has told Sheila
      // his real identity, in which case Sheila knows
      // his name is Gary.
    }
    else {
      "<p><.q>I see,<./q> says Sheila, and she
          thinks for several long moments.
          <.q>Well, that<./s>s a pretty wild story.
          But, come to think of it, if that<./s>s true,
          it would explain a few things. 
          Ovan<./s>s talked about humans playing
          this game, but he<./s>s never mentioned 
          any of them playing it more than once.
          And you <i>are</i> the first human who<./s>s 
          played the game with my help.
          So, okay, I <i>guess</i> your story 
          is plausible. I<./s>ll believe you,
          at least for now.<./q>
        <p><.q>Does this mean you<./s>ll report 
          my transgression to Ovan and Neton?<./q>
          you ask.
        <p><.q>Man, you<./s>re serious about this, 
          aren<./s>t you?<./q> Sheila asks.
          <.q>Well, I need not 
          volunteer what you<./s>ve done 
          to Ovan or Neton, as long as 
          you don<./s>t pose them any threat.<./q>
        <p><.q>Oh no, no threat,<./q> you say. ";
      //if (glob.purportedChar == nil) {
      //  "<p><.q>Good,<./q> says Sheila.
      //      <.q>Say, one more thing. I don<./s>t think
      //      I got your name before.<./q>
      //    <p><.q>The name<./s>s Gary,<./q> you say.
      //    <p><.q>Glad to meet you,<./q> says Sheila.
      //      <.q>And I<./s>m glad to hear about your
      //      <.s>tear-choked hug<./s> plan. 
      //      I wouldn<./s>t want to have to report you
      //      to Ovan.<./q> ";
      //  glob.purportedChar = me;
      //}
      //else {
      //  "No threat at all, you think to yourself.
      //      Not unless I get the right opportunity, 
      //      anyway. And, preferably, 
      //      a good, solid weapon. ";
      //}
      "No threat at all, you think to yourself.
          Not unless I get the right opportunity, 
          that is. And, preferably, 
          a good, solid weapon. ";
      hasBeenBelieved = true;
    }
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  hasBeenBelieved = nil // an invariant value
  //qOff = [bcTellOoTruth, bcTellOoDunno]
;

bcTellOoDunno: Quip
  "<.q>I, uh, don<./s>t know. They don<./s>t tell
      me such things.<./q> "
  reply {
    "<.q>I, uh, don<./s>t know,<./q> you say.
        <.q>They don<./s>t tell me such things.<./q>
      <p><.q>I see,<./q> says Sheila, 
        <.q>So you<./s>re asking me to believe that
        Neton and Ovan are capturing humans at gunpoint, 
        forcing them into a prison cell, 
        and making them play their computer game?
        And, for some unexplained reason, 
        they<./s>re letting me assist one of those humans,
        but not the others?<./q>
      <p><.q>That<./s>s right,<./q> you say. ";
    if (glob.hasPurportedToBeAlien) {
      "<p><.q>I see,<./q> says Sheila.
          <.q>Well, no offense, but that<./s>s 
          the dumbest thing I<./s>ve ever heard. 
          I may be gullible, but I<./s>m not
          <i>that</i> gullible.<./q> ";
      // No need to have Sheila ask for Gary's name.
      // If we've reached this point, then Gary once
      // purported to be alien, but now has told Sheila
      // his real identity, in which case Sheila knows
      // his name is Gary.
    }
    else {
      "<p><.q>I see,<./q> says Sheila.
          <.q>Well, no offense, but that<./s>s a little
          far-fetched. You <i>might</i> be telling
          the truth, but I think I<./s>ll hold off 
          on believing you until I see some kind of
          corroborating evidence.<./q> ";
      //if (glob.purportedChar == nil) {
      //  "<p><.q>Fair enough,<./q> you say.
      //    <p><.q>Say, one last thing,<./q> says Sheila.
      //      <.q>I don<./s>t think
      //      I got your name before.<./q>
      //    <p><.q>The name<./s>s Gary,<./q> you say.
      //    <p><.q>Nice to meet you, Gary,<./q> says Sheila.
      //    <p><.q>Nice to meet you, Sheila,<./q> you reply. ";
      //}
    }
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  hasBeenBelieved = nil
  //qOff = [bcTellOoTruth, bcTellOoDunno]
;
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Current, correct, dynamic version
// -------------------------------------------------------------------

modify glob
  showSmExitSign = true
;

function supermazeMapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm01a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01b_r' + supermaze8.gNumForFile('013') + 'p' 
          + smPassage8_J5.gNumForFile(nil) 
          + smPassage11_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01c_r' + supermaze8.gNumForFile('01234') + 'p' 
          + smPassage8_J5.gNumForFile(supermaze8) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01d_r' + supermaze8.gNumForFile('013') + 'p' 
          + smPassage8_J3.gNumForFile(supermaze8) 
          + smPassage8_J5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01e_r0p' 
          + smPassage8_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01f_r' + supermaze4.gNumForFile('01234') + 'p' 
          + smPassage4_J3.gNumForFile(supermaze4) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01g_r' + supermaze4.gNumForFile('013') + 'p' 
          + smPassage4_1.gNumForFile(supermaze4) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01h_r0p' 
          + smPassage1_4.gNumForFile(nil) 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage1_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01i_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_4.gNumForFile(supermaze1) 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm02a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02b_r' + supermaze11.gNumForFile('013') + 'p' 
          + smPassage11_13.gNumForFile(nil) 
          + smPassage8_J5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02c_r0p' 
          + smPassage8_J5.gNumForFile(nil) 
          + smPassage11_J5.gNumForFile(nil) 
          + smPassage8_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02d_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02e_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_1.gNumForFile(supermaze5) 
          + smPassage5_2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02f_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_5.gNumForFile(supermaze1) 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02g_r' + supermaze1.gNumForFile('01234') + 'p' 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm03a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03b_r' + supermaze11.gNumForFile('01234') + 'p' 
          + smPassage11_13.gNumForFile(supermaze11) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03c_r' + supermaze11.gNumForFile('012') + 'p' 
          + smPassage11_J5.gNumForFile(supermaze11) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03d_r' + supermazeJ5.gNumForFile('01') + 'p' 
          + smPassageJ5_11.gNumForFile(supermazeJ5) 
          + smPassage11_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03e_r' + supermazeJ5.gNumForFile('012') + 'p' 
          + smPassageJ5_8.gNumForFile(supermazeJ5) 
          + smPassageJ5_J6.gNumForFile(supermazeJ5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03f_r' + supermazeJ3.gNumForFile('01') + 'p' 
          + smPassageJ3_8.gNumForFile(supermazeJ3) 
          + smPassageJ3_9.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03g_r' + supermazeJ3.gNumForFile('012') + 'p' 
          + smPassageJ3_4.gNumForFile(supermazeJ3) 
          + smPassageJ3_9.gNumForFile(supermazeJ3) 
          + (supermazeJ3.hasBeenVisited || glob.hackSupermazeMap ? 1 : 0) /*smPassageJ3_5.gNumForFile(nil)*/ 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03h_r0p' 
          + smPassageJ3_5.gNumForFile(supermazeJ3) 
          + smPassage9_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03i_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_J3.gNumForFile(supermaze5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03j_r' + supermaze5.gNumForFile('01234') + 'p' 
          + smPassage5_6.gNumForFile(supermaze5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03k_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_2.gNumForFile(supermaze5) 
          + smPassage5_1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03l_r0p' 
          + smPassage1_5.gNumForFile(nil) 
          + smPassage2_5.gNumForFile(nil) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03m_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_J1.gNumForFile(supermaze1) 
          + smPassage2_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm04a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04b_r' + supermaze13.gNumForFile('013') + 'p' 
          + smPassage13_11.gNumForFile(supermaze13) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04c_r0p' 
          + smPassage11_J5.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04d_r0p' 
          + smPassage9_J6.gNumForFile(nil) 
          + smPassage8_J3.gNumForFile(nil) 
          + smPassage9_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04e_r' + supermaze9.gNumForFile('013') + 'p' 
          + smPassage9_J3.gNumForFile(supermaze9) 
          + smPassage5_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04f_r0p' 
          + smPassage5_6.gNumForFile(nil) 
          + smPassage2_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04g_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_5.gNumForFile(supermaze2) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04h_r0p' 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm05a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05b_r' + supermaze13.gNumForFile('01234') 
          + (glob.showSmExitSign ? '_x' : '') 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05c_r0p' 
          + smPassage11_13.gNumForFile(nil) 
          + smPassage12_13.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05d_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassageJ6_J5.gNumForFile(supermazeJ6) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05e_r' + supermaze9.gNumForFile('01234') + 'p' 
          + smPassage9_J6.gNumForFile(supermaze9) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05f_r0p' 
          + smPassage9_J3.gNumForFile(nil) 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage9_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05g_r0p' 
          + smPassage5_6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05h_r' + supermaze2.gNumForFile('01234') + 'p' 
          + smPassage2_J1.gNumForFile(supermaze2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05i_r0p' 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05j_r' + supermazeJ1.gNumForFile('012') + 'p' 
          + smPassageJ1_2.gNumForFile(supermazeJ1) 
          + smPassageJ1_1.gNumForFile(supermazeJ1) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm06a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06b_r' + supermaze13.gNumForFile('013') + 'p' 
          + smPassage13_12.gNumForFile(supermaze13) 
          + (glob.showSmExitSign ? '_x' : '') 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06c_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassageJ6_12.gNumForFile(supermazeJ6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06d_r' + supermazeJ6.gNumForFile('012') + 'p' 
          + smPassageJ6_10.gNumForFile(supermazeJ6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06e_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassageJ6_9.gNumForFile(supermazeJ6) 
          + smPassage9_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06f_r' + supermaze9.gNumForFile('013') + 'p' 
          + smPassage9_J4.gNumForFile(supermaze9) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06g_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_J2.gNumForFile(nil) 
          + smPassage5_6.gNumForFile(nil) 
          + smPassage6_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06h_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_J2.gNumForFile(supermaze2) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06i_r0p' 
          + smPassage2_J1.gNumForFile(nil) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06j_r' + supermazeJ1.gNumForFile('01') + 'p' 
          + smPassageJ1_3.gNumForFile(supermazeJ1) 
          + smPassageJ1_2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm07a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07b_r' + supermaze12.gNumForFile('013') + 'p' 
          + smPassage12_13.gNumForFile(supermaze12) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07c_r0p' 
          + smPassage12_J6.gNumForFile(nil) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07d_r' + supermazeJ4.gNumForFile('01') + 'p' 
          + smPassageJ4_9.gNumForFile(supermazeJ4) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07e_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage6_5.gNumForFile(supermaze6) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07f_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07g_r' + supermazeJ2.gNumForFile('01') + 'p' 
          + smPassageJ2_2.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07h_r0p' 
          + smPassage2_J2.gNumForFile(nil) 
          + smPassage3_J2.gNumForFile(nil) 
          + smPassage3_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm08a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08b_r0p' 
          + smPassage12_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08c_r' + supermaze12.gNumForFile('01234') + 'p' 
          + smPassage12_J6.gNumForFile(supermaze12) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08d_r0p' 
          + smPassageJ4_10.gNumForFile(supermazeJ4) 
          + smPassage12_J6.gNumForFile(nil) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08e_r' + supermazeJ4.gNumForFile('012') + 'p' 
          + (supermazeJ4.hasBeenVisited || glob.hackSupermazeMap ? 1 : 0) /*smPassageJ4_10.gNumForFile(nil)*/ 
          + smPassageJ4_7.gNumForFile(supermazeJ4) /*smPassageJ4_7.gNumForFile(supermazeJ4)*/ 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08f_r' + supermazeJ4.gNumForFile('01') + 'p' 
          + smPassageJ4_6.gNumForFile(supermazeJ4) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08g_r' + supermaze6.gNumForFile('01234') + 'p' 
          + smPassage6_J4.gNumForFile(supermaze6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08h_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage6_J2.gNumForFile(supermaze6) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08i_r' + supermazeJ2.gNumForFile('01') + 'p' 
          + smPassageJ2_6.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08j_r' + supermazeJ2.gNumForFile('012') + 'p' 
          + smPassageJ2_3.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08k_r' + supermaze3.gNumForFile('013') + 'p' 
          + smPassage3_J1.gNumForFile(supermaze3) 
          + smPassage3_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm09a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09b_r0p' 
          + smPassage12_13.gNumForFile(nil) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09c_r' + supermaze10.gNumForFile('013') + 'p' 
          + smPassage10_J6.gNumForFile(supermaze10) 
          + smPassage10_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09d_r0p' 
          + smPassage10_J4.gNumForFile(nil) 
          + smPassage7_J4.gNumForFile(nil) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09e_r0p' 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassage3_7.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09f_r' + supermaze3.gNumForFile('013') + 'p' 
          + smPassage3_J2.gNumForFile(supermaze3) 
          + smPassage3_7.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09g_r' + supermaze3.gNumForFile('01234') + 'p' 
          + smPassage3_7.gNumForFile(supermaze3) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm10a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10b_r' + supermaze10.gNumForFile('013') + 'p' 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10c_r' + supermaze10.gNumForFile('01234') + 'p' 
          + smPassage10_J4.gNumForFile(supermaze10) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10d_r0p' 
          + smPassage7_J4.gNumForFile(nil) 
          + smPassage10_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10e_r' + supermaze7.gNumForFile('01234') + 'p' 
          + smPassage7_J4.gNumForFile(supermaze7) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10f_r' + supermaze7.gNumForFile('013') + 'p' 
          + smPassage7_3.gNumForFile(supermaze7) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10g_r0p' 
          + smPassage3_7.gNumForFile(supermaze3) 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassageJ2_3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
  </tr>
</table>' + doCompass(true);
}

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Previous dynamic version
// -------------------------------------------------------------------

/*
function supermazeMapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm01a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01b_r' + supermaze8.gNumForFile('013') + 'p' 
          + smPassage8_J5.gNumForFile(nil) 
          + smPassage11_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01c_r' + supermaze8.gNumForFile('01234') + 'p' 
          + smPassage8_J5.gNumForFile(supermaze8) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01d_r' + supermaze8.gNumForFile('013') + 'p' 
          + smPassage8_J3.gNumForFile(supermaze8) 
          + smPassage8_J5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01e_r0p' 
          + smPassage8_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01f_r' + supermaze4.gNumForFile('01234') + 'p' 
          + smPassage4_J3.gNumForFile(supermaze4) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01g_r' + supermaze4.gNumForFile('013') + 'p' 
          + smPassage1_4.gNumForFile(supermaze4) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01h_r0p' 
          + smPassage1_4.gNumForFile(nil) 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage1_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01i_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_4.gNumForFile(supermaze1) 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm02a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02b_r' + supermaze11.gNumForFile('013') + 'p' 
          + smPassage11_13.gNumForFile(nil) 
          + smPassage8_J5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02c_r0p' 
          + smPassage8_J5.gNumForFile(nil) 
          + smPassage11_J5.gNumForFile(nil) 
          + smPassage8_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02d_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02e_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage1_5.gNumForFile(supermaze5) 
          + smPassage2_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02f_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_5.gNumForFile(supermaze1) 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02g_r' + supermaze1.gNumForFile('01234') + 'p' 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm03a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03b_r' + supermaze11.gNumForFile('01234') + 'p' 
          + smPassage11_13.gNumForFile(supermaze11) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03c_r' + supermaze11.gNumForFile('012') + 'p' 
          + smPassage11_J5.gNumForFile(supermaze11) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03d_r' + supermazeJ5.gNumForFile('01') + 'p' 
          + smPassage11_J5.gNumForFile(supermazeJ5) 
          + smPassage11_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03e_r' + supermazeJ5.gNumForFile('012') + 'p' 
          + smPassage8_J5.gNumForFile(supermazeJ5) 
          + smPassageJ5_J6.gNumForFile(supermazeJ5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03f_r' + supermazeJ3.gNumForFile('01') + 'p' 
          + smPassage8_J3.gNumForFile(supermazeJ3) 
          + smPassage9_J3.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03g_r' + supermazeJ3.gNumForFile('012') + 'p' 
          + smPassage4_J3.gNumForFile(supermazeJ3) 
          + smPassage9_J3.gNumForFile(supermazeJ3) 
          + (supermazeJ3.hasBeenVisited ? 1 : 0) //smPassage5_J3.gNumForFile(nil)
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03h_r0p' 
          + smPassage5_J3.gNumForFile(supermazeJ3) 
          + smPassage9_J3.gNumForFile(nil) 
          + smPassage4_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03i_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage5_J3.gNumForFile(supermaze5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03j_r' + supermaze5.gNumForFile('01234') + 'p' 
          + smPassage5_6.gNumForFile(supermaze5) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03k_r' + supermaze5.gNumForFile('013') + 'p' 
          + smPassage2_5.gNumForFile(supermaze5) 
          + smPassage1_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03l_r0p' 
          + smPassage1_5.gNumForFile(nil) 
          + smPassage2_5.gNumForFile(nil) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03m_r' + supermaze1.gNumForFile('013') + 'p' 
          + smPassage1_J1.gNumForFile(supermaze1) 
          + smPassage2_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm04a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04b_r' + supermaze13.gNumForFile('013') + 'p' 
          + smPassage11_13.gNumForFile(supermaze13) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04c_r0p' 
          + smPassage11_J5.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04d_r0p' 
          + smPassage9_J6.gNumForFile(nil) 
          + smPassage8_J3.gNumForFile(nil) 
          + smPassage9_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04e_r' + supermaze9.gNumForFile('013') + 'p' 
          + smPassage9_J3.gNumForFile(supermaze9) 
          + smPassage5_J3.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04f_r0p' 
          + smPassage5_6.gNumForFile(nil) 
          + smPassage2_5.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04g_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_5.gNumForFile(supermaze2) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04h_r0p' 
          + smPassage1_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm05a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05b_r' + supermaze13.gNumForFile('01234') 
          + (glob.showSmExitSign ? '_x' : '') 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05c_r0p' 
          + smPassage11_13.gNumForFile(nil) 
          + smPassage12_13.gNumForFile(nil) 
          + smPassageJ5_J6.gNumForFile(nil) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05d_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassageJ5_J6.gNumForFile(supermazeJ6) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05e_r' + supermaze9.gNumForFile('01234') + 'p' 
          + smPassage9_J6.gNumForFile(supermaze9) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05f_r0p' 
          + smPassage9_J3.gNumForFile(nil) 
          + smPassage5_J3.gNumForFile(nil) 
          + smPassage9_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05g_r0p' 
          + smPassage5_6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05h_r' + supermaze2.gNumForFile('01234') + 'p' 
          + smPassage2_J1.gNumForFile(supermaze2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05i_r0p' 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05j_r' + supermazeJ1.gNumForFile('012') + 'p' 
          + smPassageJ1_2.gNumForFile(supermazeJ1) 
          + smPassageJ1_1.gNumForFile(supermazeJ1) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm06a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06b_r' + supermaze13.gNumForFile('013') + 'p' 
          + smPassage12_13.gNumForFile(supermaze13) 
          + (glob.showSmExitSign ? '_x' : '') 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06c_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassage12_J6.gNumForFile(supermazeJ6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06d_r' + supermazeJ6.gNumForFile('012') + 'p' 
          + smPassage10_J6.gNumForFile(supermazeJ6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06e_r' + supermazeJ6.gNumForFile('01') + 'p' 
          + smPassage9_J6.gNumForFile(supermazeJ6) 
          + smPassage9_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06f_r' + supermaze9.gNumForFile('013') + 'p' 
          + smPassage9_J4.gNumForFile(supermaze9) 
          + smPassage9_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06g_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_J2.gNumForFile(nil) 
          + smPassage5_6.gNumForFile(nil) 
          + smPassage6_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06h_r' + supermaze2.gNumForFile('013') + 'p' 
          + smPassage2_J2.gNumForFile(supermaze2) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06i_r0p' 
          + smPassage2_J1.gNumForFile(nil) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06j_r' + supermazeJ1.gNumForFile('01') + 'p' 
          + smPassage3_J1.gNumForFile(supermazeJ1) 
          + smPassage2_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm07a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07b_r' + supermaze12.gNumForFile('013') + 'p' 
          + smPassage12_13.gNumForFile(supermaze12) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07c_r0p' 
          + smPassage12_J6.gNumForFile(nil) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07d_r' + supermazeJ4.gNumForFile('01') + 'p' 
          + smPassage9_J4.gNumForFile(supermazeJ4) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07e_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage5_6.gNumForFile(supermaze6) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07f_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07g_r' + supermazeJ2.gNumForFile('01') + 'p' 
          + smPassage2_J2.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07h_r0p' 
          + smPassage2_J2.gNumForFile(nil) 
          + smPassage3_J2.gNumForFile(nil) 
          + smPassage3_J1.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm08a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08b_r0p' 
          + smPassage12_13.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08c_r' + supermaze12.gNumForFile('01234') + 'p' 
          + smPassage12_J6.gNumForFile(supermaze12) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08d_r0p' 
          + smPassage10_J4.gNumForFile(supermazeJ4) 
          + smPassage12_J6.gNumForFile(nil) 
          + smPassage10_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08e_r' + supermazeJ4.gNumForFile('012') + 'p' 
          + (supermazeJ4.hasBeenVisited ? 1 : 0) // smPassage10_J4.gNumForFile(nil) +
          + smPassage7_J4.gNumForFile(supermazeJ4) // smPassage7_J4.gNumForFile(supermazeJ4)
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08f_r' + supermazeJ4.gNumForFile('01') + 'p' 
          + smPassage6_J4.gNumForFile(supermazeJ4) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08g_r' + supermaze6.gNumForFile('01234') + 'p' 
          + smPassage6_J4.gNumForFile(supermaze6) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08h_r' + supermaze6.gNumForFile('013') + 'p' 
          + smPassage6_J2.gNumForFile(supermaze6) 
          + smPassage2_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08i_r' + supermazeJ2.gNumForFile('01') + 'p' 
          + smPassage6_J2.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08j_r' + supermazeJ2.gNumForFile('012') + 'p' 
          + smPassage3_J2.gNumForFile(supermazeJ2) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08k_r' + supermaze3.gNumForFile('013') + 'p' 
          + smPassage3_J1.gNumForFile(supermaze3) 
          + smPassage3_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm09a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09b_r0p' 
          + smPassage12_13.gNumForFile(nil) 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09c_r' + supermaze10.gNumForFile('013') + 'p' 
          + smPassage10_J6.gNumForFile(supermaze10) 
          + smPassage10_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09d_r0p' 
          + smPassage10_J4.gNumForFile(nil) 
          + smPassage7_J4.gNumForFile(nil) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09e_r0p' 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassage3_7.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09f_r' + supermaze3.gNumForFile('013') + 'p' 
          + smPassage3_J2.gNumForFile(supermaze3) 
          + smPassage3_7.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09g_r' + supermaze3.gNumForFile('01234') + 'p' 
          + smPassage3_7.gNumForFile(supermaze3) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm10a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10b_r' + supermaze10.gNumForFile('013') + 'p' 
          + smPassage12_J6.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10c_r' + supermaze10.gNumForFile('01234') + 'p' 
          + smPassage10_J4.gNumForFile(supermaze10) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10d_r0p' 
          + smPassage7_J4.gNumForFile(nil) 
          + smPassage10_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10e_r' + supermaze7.gNumForFile('01234') + 'p' 
          + smPassage7_J4.gNumForFile(supermaze7) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10f_r' + supermaze7.gNumForFile('013') + 'p' 
          + smPassage3_7.gNumForFile(supermaze7) 
          + smPassage6_J4.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10g_r0p' 
          + smPassage3_7.gNumForFile(supermaze3) 
          + smPassage6_J2.gNumForFile(nil) 
          + smPassage3_J2.gNumForFile(nil) 
          + '.png" border="0"></td></tr>
      </table>
    </td>
  </tr>
</table>' + doCompass(true);
}
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: METAMAZE MAP: Static version
// -------------------------------------------------------------------

/*
function supmazeMapPrintOld() {
return '<table border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm01a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01b_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01c_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01d_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01e_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01f_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01g_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01h_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm01i_r3p11.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm02a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02b_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02c_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02d_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02e_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02f_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm02g_r4p1.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm03a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03b_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03c_r2p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03d_r1p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03e_r2p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03f_r1p1111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03g_r2p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03h_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03i_r3p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03j_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03k_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03l_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm03m_r3p11.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm04a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04b_r3p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04c_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04d_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04e_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04f_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04g_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm04h_r0p1.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm05a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05b_r4_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05c_r0p1111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05d_r1p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05e_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05f_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05g_r0p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05h_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05i_r0p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm05j_r2p11.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm06a_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06b_r3p1_x.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06c_r1p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06d_r2p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06e_r1p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06f_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06g_r3p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06h_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06i_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm06j_r1p11.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm07a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07b_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07c_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07d_r1p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07e_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07f_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07g_r1p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm07h_r0p111.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm08a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08b_r0p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08c_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08d_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08e_r2p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08f_r1p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08g_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08h_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08i_r1p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08j_r2p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm08k_r3p11.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm09a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09b_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09c_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09d_r0p111.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09e_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09f_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm09g_r4p1.png" border="0"></td></tr>
      </table>
    </td>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr><td><img src="supmaze/sm10a.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10b_r3p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10c_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10d_r0p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10e_r4p1.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10f_r3p11.png" border="0"></td></tr>
        <tr><td><img src="supmaze/sm10g_r0p111.png" border="0"></td></tr>
      </table>
    </td>
  </tr>
</table>' + doCompass(true);
}
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: PRIMITIVE MAP: Primitive dynamic map
// -------------------------------------------------------------------

//function supermazeMapPrintOld() {
//return '<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
//  <tr>
//    <td><img src=\"super/' + smImg01() + '.png\" border=\"0\" width=\"36\" height=\"49\"></td>
//    <td>
//      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//        <tr>
//          <td><img src=\"super/' + smImg02() + '.png\" border=\"0\" width=\"64\" height=\"49\"></td>
//          <td><img src=\"super/' + smImg03() + '.png\" border=\"0\" width=\"32\" height=\"49\"></td>
//        </tr>
//      </table>
//    </td>
//    <td><img src=\"super/' + smImg04() + '.png\" border=\"0\" width=\"32\" height=\"49\"></td>
//    <td>
//      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//        <tr>
//          <td><img src=\"super/' + smImg05() + '.png\" border=\"0\" width=\"32\" height=\"49\"></td>
//          <td><img src=\"super/' + smImg06() + '.png\" border=\"0\" width=\"64\" height=\"49\"></td>
//        </tr>
//      </table>
//    </td>
//    <td><img src=\"super/' + smImg07() + '.png\" border=\"0\" width=\"36\" height=\"49\"></td>
//  </tr>
//  <tr>
//    <td><img src=\"super/' + smImg08() + '.png\" border=\"0\" width=\"36\" height=\"94\"></td>
//    <td><img src=\"super/' + smImg09() + '.png\" border=\"0\" width=\"96\" height=\"94\"></td>
//    <td><img src=\"super/' + smImg10() + '.png\" border=\"0\" width=\"32\" height=\"94\"></td>
//    <td><img src=\"super/' + smImg11() + '.png\" border=\"0\" width=\"96\" height=\"94\"></td>
//    <td><img src=\"super/' + smImg12() + '.png\" border=\"0\" width=\"36\" height=\"94\"></td>
//  </tr>
//  <tr>
//    <td><img src=\"super/' + smImg13() + '.png\" border=\"0\" width=\"36\" height=\"212\"></td>
//    <td>
//      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//        <tr>
//          <td><img src=\"super/' + smImg14() + '.png\" border=\"0\" width=\"96\" height=\"98\"></td>
//        </tr>
//        <tr>
//          <td><img src=\"super/' + smImg15() + '.png\" border=\"0\" width=\"96\" height=\"32\"></td>
//        </tr>
//        <tr>
//          <td><img src=\"super/' + smImg16() + '.png\" border=\"0\" width=\"96\" height=\"82\"></td>
//        </tr>
//      </table>
//    </td>
//    <td>
//      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//        <tr> 
//          <td><img src=\"super/' + smImg17() + '.png\" border=\"0\" width=\"32\" height=\"98\"></td>
//        </tr>
//        <tr> 
//          <td><img src=\"super/' + smImg18() + '.png\" border=\"0\" width=\"32\" height=\"114\"></td>
//        </tr>
//      </table>
//    </td>
//    <td>
//      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//        <tr>
//          <td><img src=\"super/' + smImg19() + '.png\" border=\"0\" width=\"96\" height=\"113\"></td>
//        </tr>
//        <tr>
//          <td><img src=\"super/' + smImg20() + '.png\" border=\"0\" width=\"96\" height=\"34\"></td>
//        </tr>
//        <tr>
//          <td><img src=\"super/' + smImg21() + '.png\" border=\"0\" width=\"96\" height=\"65\"></td>
//        </tr>
//      </table>
//    </td>
//    <td><img src=\"super/' + smImg22() + '.png\" border=\"0\" width=\"36\" height=\"212\"></td>
//  </tr>
//  <tr>
//    <td><img src=\"super/' + smImg23() + '.png\" border=\"0\" width=\"36\" height=\"36\"></td>
//    <td><img src=\"super/' + smImg24() + '.png\" border=\"0\" width=\"96\" height=\"36\"></td>
//    <td><img src=\"super/' + smImg25() + '.png\" border=\"0\" width=\"32\" height=\"36\"></td>
//    <td><img src=\"super/' + smImg26() + '.png\" border=\"0\" width=\"96\" height=\"36\"></td>
//    <td><img src=\"super/' + smImg27() + '.png\" border=\"0\" width=\"36\" height=\"36\"></td>
//  </tr>
//</table>' + doCompass(true);
//}

// This is, apparently, an even older version of supermazeMapPrintOld().
/*
function supermazeMapPrint() {
return '<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
  <tr>
    <td><img src=\"super/sm01x2.png\" border=\"0\" width=\"36\" height=\"49\"></td>
    <td>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
        <tr>
          <td><img src=\"super/sm02x21.png\" border=\"0\" width=\"64\" height=\"49\"></td>
          <td><img src=\"super/sm03_111.png\" border=\"0\" width=\"32\" height=\"49\"></td>
        </tr>
      </table>
    </td>
    <td><img src=\"super/sm04fake.png\" border=\"0\" width=\"32\" height=\"49\"></td>
    <td>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
        <tr>
          <td><img src=\"super/sm05_111.png\" border=\"0\" width=\"32\" height=\"49\"></td>
          <td><img src=\"super/sm06x2.png\" border=\"0\" width=\"64\" height=\"49\"></td>
        </tr>
      </table>
    </td>
    <td><img src=\"super/sm07.png\" border=\"0\" width=\"36\" height=\"49\"></td>
  </tr>
  <tr>
    <td><img src=\"super/sm08_11.png\" border=\"0\" width=\"36\" height=\"94\"></td>
    <td><img src=\"super/sm09x11111.png\" border=\"0\" width=\"96\" height=\"94\"></td>
    <td><img src=\"super/sm10x11.png\" border=\"0\" width=\"32\" height=\"94\"></td>
    <td><img src=\"super/sm11_11111.png\" border=\"0\" width=\"96\" height=\"94\"></td>
    <td><img src=\"super/sm12x2.png\" border=\"0\" width=\"36\" height=\"94\"></td>
  </tr>
  <tr>
    <td><img src=\"super/sm13x21.png\" border=\"0\" width=\"36\" height=\"212\"></td>
    <td>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
        <tr>
          <td><img src=\"super/sm14x11111.png\" border=\"0\" width=\"96\" height=\"98\"></td>
        </tr>
        <tr>
          <td><img src=\"super/sm15x2.png\" border=\"0\" width=\"96\" height=\"32\"></td>
        </tr>
        <tr>
          <td><img src=\"super/sm16_1111.png\" border=\"0\" width=\"96\" height=\"82\"></td>
        </tr>
      </table>
    </td>
    <td>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
        <tr> 
          <td><img src=\"super/sm17x21.png\" border=\"0\" width=\"32\" height=\"98\"></td>
        </tr>
        <tr> 
          <td><img src=\"super/sm18x21.png\" border=\"0\" width=\"32\" height=\"114\"></td>
        </tr>
      </table>
    </td>
    <td>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
        <tr>
          <td><img src=\"super/sm19x11111.png\" border=\"0\" width=\"96\" height=\"113\"></td>
        </tr>
        <tr>
          <td><img src=\"super/sm20x2.png\" border=\"0\" width=\"96\" height=\"34\"></td>
        </tr>
        <tr>
          <td><img src=\"super/sm21x11.png\" border=\"0\" width=\"96\" height=\"65\"></td>
        </tr>
      </table>
    </td>
    <td><img src=\"super/sm22x21.png\" border=\"0\" width=\"36\" height=\"212\"></td>
  </tr>
  <tr>
    <td><img src=\"super/sm23_11.png\" border=\"0\" width=\"36\" height=\"36\"></td>
    <td><img src=\"super/sm24x21.png\" border=\"0\" width=\"96\" height=\"36\"></td>
    <td><img src=\"super/sm25x1.png\" border=\"0\" width=\"32\" height=\"36\"></td>
    <td><img src=\"super/sm26x21.png\" border=\"0\" width=\"96\" height=\"36\"></td>
    <td><img src=\"super/sm27_11.png\" border=\"0\" width=\"36\" height=\"36\"></td>
  </tr>
</table>';
}
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: PRIMITIVE MAP: Primitive ancillary functions
// -------------------------------------------------------------------

/*
appendHasPlayer(str, loc) {
  if (gPlayerChar.isIn(loc))
    return str + 'x';
  return str + '_';
}
appendIsSolved(str, loc) {
  if (!loc.isDisplayedForMap)
    return str + '0';
  if (!loc.isSolved)
    return str + '1';
  return str + '2';
}
appendIsAccessible(str, loc) {
  if (loc.isDisplayedForMap)
    return str + '1';
  return str + '0';  
}
appendIsHacAndAcc(str, loc) {
  if (loc.isDisplayedForMap && glob.includeHac)
    return str + '1';
  return str + '0';  
}
*/

// -------------------------------------------------------------------
// SUPERMAZE: OLD MAP: FUNCTIONS: IMAGE FUNCTIONS
// -------------------------------------------------------------------

/*
smImg01() {
  local str = 'sm01';
  //if (!supermaze8.isAccessible) return str + '_0';
  str = appendHasPlayer(str, supermaze8);
  str = appendIsSolved (str, supermaze8);
  return str;
}
smImg02() {
  local str = 'sm02';
  str = appendHasPlayer   (str, supermaze11);
  str = appendIsSolved    (str, supermaze11);
  str = appendIsAccessible(str, supermaze8);
  return str;
}
smImg03() {
  local str = 'sm03_';
  str = appendIsAccessible(str, smPassage11_13);
  str = appendIsAccessible(str, supermaze11);
  str = appendIsHacAndAcc (str, supermaze13); //WRONG! FIX!
  return str;
}
smImg04() {
  local str = 'sm04';
  if (glob.includeHac) str = str + 'HE2';
  else str = str + 'NE1';
  str = appendHasPlayer(str, supermaze13);
  if (glob.includeHac) {
    str = appendIsSolved(str, supermaze13);
    if (supermaze13.isSolved && glob.smNorthExitPath)
      str = str + 'n';
  }
  else {
    str = appendIsAccessible(str, supermaze13);
  }
  return str;
  //return 'sm04fake';
}
smImg05() {
  local str = 'sm05_';
  str = appendIsAccessible(str, smPassage12_13);
  str = appendIsAccessible(str, supermaze12);
  str = appendIsHacAndAcc (str, supermaze13); //WRONG! FIX!
  return str;
}
smImg06() {
  local str = 'sm06';
  str = appendHasPlayer   (str, supermaze12);
  str = appendIsSolved    (str, supermaze12);
  return str;
}
smImg07() {
  return 'sm07';
}
smImg08() {
  local str = 'sm08_';
  str = appendIsAccessible(str, smPassage8_J3);
  str = appendIsAccessible(str, supermaze8);
  return str;
}
smImg09() {
  local str = 'sm09';
  str = appendHasPlayer   (str, supermazeJ5);
  str = appendIsAccessible(str, supermazeJ5);
  str = appendIsAccessible(str, smPassage8_J3);
  str = appendIsAccessible(str, supermaze8);
  str = appendIsAccessible(str, supermaze11);
  str = appendIsHacAndAcc (str, supermaze13); //WRONG! FIX!
  return str;
}
smImg10() {
  local str = 'sm10';
  str = appendHasPlayer   (str, supermazeJ6);
  str = appendIsAccessible(str, supermazeJ6);
  str = appendIsHacAndAcc (str, supermaze13); //WRONG! FIX!
  return str;
}
smImg11() {
  local str = 'sm11_';
  str = appendIsAccessible(str, supermazeJ6);
  str = appendIsAccessible(str, supermazeJ4);
  str = appendIsAccessible(str, supermaze10);
  str = appendIsAccessible(str, supermaze12);
  str = appendIsHacAndAcc (str, supermaze13); //WRONG! FIX!
  return str;
}
smImg12() {
  local str = 'sm12';
  str = appendHasPlayer   (str, supermaze10);
  str = appendIsSolved    (str, supermaze10);
  return str;
}
smImg13() {
  local str = 'sm13';
  str = appendHasPlayer   (str, supermaze4);
  str = appendIsSolved    (str, supermaze4);
  str = appendIsAccessible(str, smPassage1_4);
  return str;
}
smImg14() {
  local str = 'sm14';
  str = appendHasPlayer   (str, supermazeJ3);
  str = appendIsAccessible(str, supermazeJ3);
  str = appendIsAccessible(str, smPassage5_6);
  str = appendIsAccessible(str, supermaze4);
  str = appendIsAccessible(str, supermaze5);
  str = appendIsAccessible(str, supermaze9);
  return str;
}
smImg15() {
  local str = 'sm15';
  str = appendHasPlayer   (str, supermaze5);
  str = appendIsSolved    (str, supermaze5);
  return str;
}
smImg16() {
  local str = 'sm16_';
  str = appendIsAccessible(str, smPassage1_5);
  str = appendIsAccessible(str, smPassage2_5);
  str = appendIsAccessible(str, supermaze2);
  str = appendIsAccessible(str, supermaze5);
  return str;
}
smImg17() {
  local str = 'sm17';
  str = appendHasPlayer   (str, supermaze9);
  str = appendIsSolved    (str, supermaze9);
  str = appendIsAccessible(str, smPassage5_6);
  return str;
}
smImg18() {
  local str = 'sm18';
  str = appendHasPlayer   (str, supermaze2);
  str = appendIsSolved    (str, supermaze2);
  str = appendIsAccessible(str, smPassage2_J1);
  return str;
}
smImg19() {
  local str = 'sm19';
  str = appendHasPlayer   (str, supermazeJ4);
  str = appendIsAccessible(str, supermazeJ4);
  str = appendIsAccessible(str, smPassage5_6);
  str = appendIsAccessible(str, supermaze6);
  str = appendIsAccessible(str, supermaze7);
  str = appendIsAccessible(str, supermaze9);
  return str;
}
smImg20() {
  local str = 'sm20';
  str = appendHasPlayer   (str, supermaze6);
  str = appendIsSolved    (str, supermaze6);
  return str;
}
smImg21() {
  local str = 'sm21';
  str = appendHasPlayer   (str, supermazeJ2);
  str = appendIsSolved    (str, supermazeJ2);
  str = appendIsAccessible(str, supermaze2);
  return str;
}
smImg22() {
  local str = 'sm22';
  str = appendHasPlayer   (str, supermaze7);
  str = appendIsSolved    (str, supermaze7);
  str = appendIsAccessible(str, smPassage3_7);
  return str;
}
smImg23() {
  local str = 'sm23_';
  str = appendIsAccessible(str, smPassage1_4);
  str = appendIsAccessible(str, supermaze1);
  return str;
}
smImg24() {
  local str = 'sm24';
  str = appendHasPlayer   (str, supermaze1);
  str = appendIsSolved    (str, supermaze1);
  str = appendIsAccessible(str, smPassage1_J1);
  return str;
}
smImg25() {
  local str = 'sm25';
  str = appendHasPlayer   (str, supermazeJ1);
  str = appendIsAccessible(str, supermazeJ1);
  return str;
}
smImg26() {
  local str = 'sm26';
  str = appendHasPlayer   (str, supermaze3);
  str = appendIsSolved    (str, supermaze3);
  str = appendIsAccessible(str, smPassage3_J1);
  return str;
}
smImg27() {
  local str = 'sm27_';
  str = appendIsAccessible(str, smPassage3_7);
  str = appendIsAccessible(str, supermaze3);
  return str;
}
*/

// -------------------------------------------------------------------
// INNER GAME: SUPERMAZE: MAP: Compass rose
// -------------------------------------------------------------------

// This seemed like a good idea at the time. It doesn't seem so anymore.
// Therefore, doCompass() now returns an empty string.

enum upDown, aheadBack, wait;

doCompass(arg) {
  if (bot.getOutermostRoom && bot.getOutermostRoom.ofKind(HacRoom))
    return doCompass2(wait);
  else
    return '';
}

doCompass2(arg) {
  local startHtml, endHtml, upHtml, aheadHtml, waitHtml;
  startHtml =
'<table width="0" border="0" cellspacing="0" cellpadding="0" align="center">
 <tr>
  <td><img src="compass/spaceVertical63.png" border="0"></td>
  <td><img src="compass/spaceVertical.png" border="0"></td>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_NW.png" border="0"></td>
        <td><img src="compass/spaceCmpNW_N.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_W.png" border="0"></td>
        <td><a href="nw"><img src="compass/cmpNW0.png" hsrc="compass/cmpNW1.png" asrc="compass/cmpNW2.png" border="0"></a></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><a href="w"><img src="compass/cmpW0.png" hsrc="compass/cmpW1.png" asrc="compass/cmpW2.png" border="0"></a></td>
        <td><img src="compass/spaceCmpW.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_W.png" border="0"></td>
        <td><a href="sw"><img src="compass/cmpSW0.png" hsrc="compass/cmpSW1.png" asrc="compass/cmpSW2.png" border="0"></a></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_NW.png" border="0"></td>
        <td><img src="compass/spaceCmpNW_N.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
   </table>
  </td>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><a href="n"><img src="compass/cmpN0.png" hsrc="compass/cmpN1.png" asrc="compass/cmpN2.png" border="0"></a></td>
    </tr>
    <tr>
     <td><img src="compass/spaceCmpN.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceCmp5.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceCmpN.png" border="0"></td>
    </tr>
    <tr>
     <td><a href="s"><img src="compass/cmpS0.png" hsrc="compass/cmpS1.png" asrc="compass/cmpS2.png" border="0"></a></td>
    </tr>
   </table>
  </td>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_N.png" border="0"></td>
        <td><img src="compass/spaceCmpNW_NW.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><a href="ne"><img src="compass/cmpNE0.png" hsrc="compass/cmpNE1.png" asrc="compass/cmpNE2.png" border="0"></a></td>
        <td><img src="compass/spaceCmpNW_W.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpW.png" border="0"></td>
        <td><a href="e"><img src="compass/cmpE0.png" hsrc="compass/cmpE1.png" asrc="compass/cmpE2.png" border="0"></a></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><a href="se"><img src="compass/cmpSE0.png" hsrc="compass/cmpSE1.png" asrc="compass/cmpSE2.png" border="0"></a></td>
        <td><img src="compass/spaceCmpNW_W.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border="0" cellspacing="0" cellpadding="0">
       <tr>
        <td><img src="compass/spaceCmpNW_N.png" border="0"></td>
        <td><img src="compass/spaceCmpNW_NW.png" border="0"></td>
       </tr>
      </table>
     </td>
    </tr>
   </table>
  </td>
  <td><img src="compass/spaceVertical.png" border="0"></td>';
  endHtml =
'</tr>
</table>';
  upHtml =
 '<td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="compass/spaceUpNW.png" border="0"></td>
     <td><img src="compass/spaceUpN.png" border="0"></td>
     <td><img src="compass/spaceUpNW.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceUpW.png" border="0"></td>
     <td><a href="u"><img src="compass/up0.png" hsrc="compass/up1.png" asrc="compass/up2.png" border="0"></a></td>
     <td><img src="compass/spaceUpW.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceUpW.png" border="0"></td>
     <td><a href="d"><img src="compass/down0.png" hsrc="compass/down1.png" asrc="compass/down2.png" border="0"></a></td>
     <td><img src="compass/spaceUpW.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceUpNW.png" border="0"></td>
     <td><img src="compass/spaceUpN.png" border="0"></td>
     <td><img src="compass/spaceUpNW.png" border="0"></td>
    </tr>
   </table>
  </td>';
  aheadHtml =
 '<td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="compass/spaceAheadN.png" border="0"></td>
    </tr>
    <tr>
     <td><a href="ahead"><img src="compass/ahead0.png" hsrc="compass/ahead1.png" asrc="compass/ahead2.png" border="0"></a></td>
    </tr>
    <tr>
     <td><a href="back"><img src="compass/back0.png" hsrc="compass/back1.png" asrc="compass/back2.png" border="0"></a></td>
    </tr>
    <tr>
     <td><img src="compass/spaceAheadN.png" border="0"></td>
    </tr>
   </table>
  </td>';
  waitHtml =
 '<td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="compass/spaceWaitNW.png" border="0"></td>
     <td><img src="compass/spaceWaitN.png" border="0"></td>
     <td><img src="compass/spaceWaitNW.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceWaitW.png" border="0"></td>
     <td><a href="z"><img src="compass/wait0.png" hsrc="compass/wait1.png" asrc="compass/wait2.png" border="0"></a></td>
     <td><img src="compass/spaceWaitW.png" border="0"></td>
    </tr>
    <tr>
     <td><img src="compass/spaceWaitNW.png" border="0"></td>
     <td><img src="compass/spaceWaitN.png" border="0"></td>
     <td><img src="compass/spaceWaitNW.png" border="0"></td>
    </tr>
   </table>
  </td>';
  switch (arg) {
    case true     :
    case upDown   : return startHtml + upHtml + endHtml;
    case aheadBack: return startHtml + aheadHtml + endHtml;
    case wait     : return startHtml + waitHtml + endHtml;
    default       : return startHtml + endHtml;
  }
}

