#charset "us-ascii"
#include <advlite.h>

steve: Actor 'bartender; friendly; steve stephen steven barkeep waiter man; him' @scootersPub
    "The bartender has sandy hair and a friendly
    expression. A white apron is wrapped around his not entirely svelte waist. "
    
    globalParamName = 'steve'
    giveName {
        replaceVocab ('Steve;; barkeep bartender waiter man stephen steven; him');
        proper = true;
    }
    attentionSpan = nil
    friendly = nil
    warnedAboutPhoto = nil
    afterAction() {
        inherited();
        if(gActionIs(Take) && (gDobj.ofKind(SignedPhoto)) && (!warnedAboutPhoto)) {
            if (gDobj.isIn(gPlayerChar) && (gDobj != goodallPhoto)) {
                "<q>Are you sure that's the one you want?</q> the bartender
                says. <q>I can't just give you the whole collection, you know.</q> ";
                warnedAboutPhoto = true;
            }
        }
            
    }
;

+ Decoration 'white apron'
    "The apron is part of the bartender's official uniform. "
;

//------------------------------------------------------------
// conversations with Steve the bartender
//------------------------------------------------------------

+steveChatting: ActorState
    stateDesc = "He's <<randomDesc.doScript>>. "
    randomDesc: ShuffledEventList {
        [
            'wiping the bar with a rag',
            'bending down to look for something behind the bar',
            'pouring fresh nuts into a nut bowl',
            'washing up some glasses and putting them back on the shelf',
            'yawning'
        ]
    }
    isInitState = true
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        '<q>Search me,</q> he replies. ',
        
        '<q>Can\'t say I know much about that,</q> he says. ',
        
        '{The steve} is polishing the bar with a rag, and seems not to have heard you. ',
        
        '<q>Me, I got nothin\' better to do than shoot the breeze,</q> he replies, <q>but
        I sort of had the impression you had something you wanted to accomplish this afternoon.</q> ',
        
        '<q>Oh, I could tell you a thing or two,</q> he replies. <q>But I\'d just be
        fakin\' it. If you look around out there, you might find somebody knows more
        than I do.</q> '
    ]
;

++ AskForTopic @tBeer
    "<q>Could I have a ... oh, never mind. I'm not thirsty.</q> "
;

++ AskTopic @tBeer
    "<q>Could I have a ... oh, never mind. I'm not thirsty.</q> "
;

++ AskTopic @paintings
    "<q>The art dealer said you were admiring the paintings,</q> you say.
    <.p><q>Oh, yeah, I guess.</q> He shrugs. <q>Mostly, art doesn\'t do much for me,
    though. Only if it\'s a picture I really like.</q> "
;

++ AskTopic, StopEventList @tScrimshaw
    [
        '<q>So you like scrimshaw,</q> you comment.
        <.p><q>You betcha,</q> he replies. <q>But it\'s gotta have a carving that
        means something to me. Like, if it had Betty Boop on it, or Wile E. Coyote,
        no thanks. See what I mean?</q> ',
        
        '<q>So there\'s some kind of scrimshaw that you especially like?</q> you
        ask.
        <.p><q>Oh, there\'s different things. I was lookin\' at some of the paintings
        over there in the gallery, and there was one or two that I did relate to.</q> ',
        
        '<q>Can you tell me which painting you liked?</q> you ask.
        <.p><q>I don\'t know if I even remember. And what does it matter? I\'d have
        to save up some cash to afford another piece, even if it had something carved on
        it that I liked.</q> ',
        
        'He has told you one of the paintings in the art gallery had an image he
        liked. Maybe the gallery owner will be able to tell you which one it was. '
    ]
;

++ AskTopic @tBilliardRoom
    "<q>I'm curious about the billiard room,</q> you say.
    <.p><q>Had to close it down,</q> he replies. <q>Somebody stole all the balls,
    if you can believe that. The cues, too. Pretty much nothin' left in there.</q> "
;

++ AskTellTopic [tFlogg, tGrabby]
    "<q>Those guys? They make a profit out of this place, I can tell you that much. It\'s 
    almost like they have a money magnet or somethin\'. Did you see that Lamborghini out
    in the parking lot? Grabby paid cash for that, or so he claims. Anything happened to
    that car, he\'d be runnin\' after it like it was his own kid,</q> "
;

++ AskTellTopic @tJoe
    "<q>I noticed a man out behind the shopping center,</q> you say. <q>I think he\'s homeless.</q>
    <.p><q>Oh, that's Joe,</q> {the steve} tells you.<<joe.giveName()>> <q>He\'s harmless. He claims
    there are pixies flying around his head all the time, that's what makes him
    crazy, but I never saw any pixies. Maybe if you blew a cloud of smoke at
    him, you could see the pixies. If there are any pixies, I mean.</q> "
;

++ TellTopic @tSamantha
    "He listens to your tale of woe, nodding and murmuring at the appropriate spots.
    <q>You say her little brother spilled ink on it?</q> he says, shaking his head.
    <q>And her date is the captain of the lacrosse team? Wow! If I had a key to the
    boutique, I\'d take you down there right now and fetch the dress for you. No can do,
    though. You\'ll have to work out for yourself how to get your hands on it.</q> "
;

++ AskTellTopic @tOctagonalRoom
    "<q>I don\'t know why they don\'t just tear that thing out and put in a stairwell,</q> he
    comments. <q>There\'s, like, nine exits from it, some upstairs, some
    downstairs. There\'s even one on the roof. But who knows how to operate it so as to
    get to any of them? I don\'t, that\'s for sure.</q> "
;

++ AskTellTopic, StopEventList @tPromDress
    [
        '<q>I came here this afternoon hoping to get a dress for my daughter for the senior prom,</q>
        you say.<.p>
        <q>The boutique is downstairs,</q> {the steve} replies. <q>But I\'m pretty sure they closed
        up early this afternoon.</q> ',
        
        '<q>You don\'t know anyone who has a master key, do you?</q> you ask. <q>I mean, I\'d pay
        for the dress. I\'m not planning to steal it or anything!</q>
        <.p><q>I know the guards have one,</q> he
        replies. <q>But they wouldn\'t want to let you into a shop.</q> ',
        
        'It doesn\'t appear the bartender is going to be much use in the prom dress department. '
    ]
;

     
++HelloTopic, StopEventList
    [
        { : "<q>Excuse me,</q> you venture. <q>Are you busy?</q><.p>
            The bartender laughs. <q>Not today. Everybody went off to watch
            the parade. Can I get you anything?</q> " },
        '<q>Hello again,</q> you say. <q>I\'m back.</q><.p>
        <q>Well, that\'s okay,</q> the bartender replies. <q>I was getting
        bored just standing here with nothing to do.</q> '
    ]
;

++ AskTopic, StopEventList @steve
    [
        { : "<q>Me? Just a regular guy. Name's Steve, don't know if I mentioned 
            <<steve.giveName()>>that. I\'m a kind of collector, I guess you could say.
            Not stamps or coins, nothing ordinary like that. These photos here, behind
            the bar, that\'s one of my collections. I\'m starting a scrimshaw collection
            too. <<tScrimshaw.makeFamiliar()>>Like that shop upstairs, with stuff carved into walrus tusks and like
            that? I love that kind of thing. But I\'m picky. It has to have exactly
            the right carving, something that speaks to me. Otherwise I won\'t touch it.</q> " },
        '<q>Me? Same as I ever was. You noticed my collection of photos? They\'re
        all autographed.</q> '
    ]
;

++ TellTopic @tSamantha
    "<q>My daughter's senior prom is tonight,</q> you tell him. <q>I'm here
    to get her a replacement prom dress.</q>
    <.p><q>Girl has to have the right dress,</q> he replies. <q>That\'s all
    I know about that.</q> "
;

++ AskTopic [photosGroup, goodallPhoto, welkPhoto, godzillaPhoto, einsteinPhoto, homerPhoto, rushmorePhoto]
    "<q>That\'s a nice collection of photos,</q> you comment.
    <.p><q>Thanks,</q> he replies. <q>I like \'em. Got quite a collection.</q> "
;

++ AskTellTopic @tArchibald
    "<q>The man in the art gallery seems awfully depressed,</q> you mention.
    <.p><q>I guess it\'s a hazard if you\'re into art,</q> {the steve} replies.
    <q>I\'m not any kind of artist, but I\'ll admit he\'s got a couple of nice
    paintings in there.</q> "
;
+++ AltTopic
    "<q>I brought a singing fish upstairs for the man in the art gallery,</q> you
    say. <q>It cheered him up quite a lot.</q>
    <.p><q>Happy to hear it,</q> {the steve} replies. <q>Ask him to tell you
    about the paintings.</q> "
    isActive = (archibald.curState == archibaldCheerful)
;

++ AskTellTopic @betsy
    "<q>Do you know the young woman at the beauty parlor?</q> you ask. <q>You know, the
    nervous one.</q><.p>
    <q>Oh, you mean Betsy,</q> he replies.<<betsy.giveName>> <q>She\'s a little strange.
    Claims she stopped smoking months ago, but I\'ve seen her dump an ashtray full of
    butts in the potted palm when she thinks nobody\'s watching.</q> "
;

++ AskTellTopic @tWizard
    "<q>Do you know anything about the wizard?</q> you ask.
    <.p><q>Not much. I\'ve seen him around. Grumpy-looking little guy, and that mustache --- I
    almost wouldn\'t serve him, if he came in here, account of that mustache. There are
    sanitary laws. Last time I
    saw him he was going on about how he mislaid his crystal ball. I\'d guess it probably fell
    off when he was flying around on that pterodactyl of his. Could have bounced, could have
    ended up anywhere.</q> "
;

++ AskTellTopic @stoneAngel
    "<q>Have you seen that stone angel in the garden?</q> you ask.
    <.p><q>Oh, yeah. It looks sad, doesn\'t it? Angels are supposed to be playing harps,
    aren\'t they? Maybe that\'s the problem.</q> "
;

++ AskTellTopic @marquee
    "<q>What can you tell me about the marquee?</q> you ask.<.p>
    <q>Oh, that thing?</q> He shakes his head sadly. <q>I'll bet it's
    on the fritz again. It's not bad enough the lines get messed up,
    some of the letters go missing too. LouAnne over at the snack bar,
    she claims the missing letters spell out some secret message about
    a book, but if she told me what it was, I clean forgot, so don't bother
    to ask.</q> "
;

++ AskTellTopic @tDiorama
    "<q>That thing?</q> The bartender shakes his head sadly. <q>Useless. It\'s
    not good for anything, it\'s just to show what Flogg and Grabby have in their
    plans. The layout is the same as that virtual capsule joyride upstairs in the
    toy shop, <<tCapsule.makeFamiliar()>>or so they tell me.</q> "
;

++ AskTellTopic @tCapsule
    "<q>What can you tell me,</q> you ask, <q>about the virtual capsule upstairs
    in the toy store?</q>
    <.p><q>Not much,</q> he replies. <q>I think it operates pretty much the way the
    diorama operates. The lever switches the track so you go either left or right at
    a fork. And the track layout is the same.</q> "
;

++ AskTellTopic @tTarzan
    "<q>There\'s a very strange-looking big blue box in the travel agency,</q> you
    comment. <q>Do you know anything about it?</q>
    <.p><q>Not much. It\'s supposed to be a magic teleportation chamber, like something
    out of Doctor Who. Madame Bloviatsky told me some famous explorer used to visit other parts
    of the world in it, but she also told me the explorer died, so maybe nobody knows how
    to use it anymore.</q> "
;

    
++ GiveShowTopic @dragonTooth
    topicResponse() {
        if (dragonTooth.imageNum == 0)
            "<q>Hey, that's quite a tooth you've got there,</q> {the steve} says.
            <q>I'll bet somebody could carve a really neat scrimshaw into it.</q> ";
        // If the tooth is carved with the wrong image, the game is unwinnable,
        // so we may as well let the player know that, and know why.
        else if (dragonTooth.imageNum != 5) {
            "{The steve} looks at the carved tooth for a moment and shakes his head
            sadly. <q>That's nice scrimshaw, sure enough, but it's not a carving that
            I care much about. You may as well keep it. Sorry.</q>
            
            <.p>Over the next couple of hours you try all sorts of ways to get
            your hands on the prom dress, but nothing works. In the end, you realize
            you've made a terrible mistake. Maybe the bartender would have liked
            the tooth better if it had some other carving. ";
            finishGameMsg ('You have failed in your quest.', [finishOptionUndo]);
        }
        else {
            dragonTooth.moveInto(nil);
            steve.friendly = true;
            "<q>Wow! Would you look at that? Ice skaters!</q> The bartender takes the scrimshaw
            tooth from you and turns it over, examining it with great care. <q>Hey,
            listen, I'll tell you what. Can I keep this? If you let me keep it,
            you can pick any one of my autographed photos as a trade, how's that?</q>
            
            <.p>You readily agree to the deal. Now which photo would be the most useful
            to you? That's the quandary. ";
        }
    }
;

// If you've taken the wrong photo, he will nudge you that you've made a mistake and
// then allow you to trade. We will assume he's in a state where he will have allowed
// you to take the photo in the first place.
++ GiveTopic [rushmorePhoto, einsteinPhoto, homerPhoto, welkPhoto, godzillaPhoto]
    topicResponse() {
        wallBehindBar.photoTaken = nil;
        steve.warnedAboutPhoto = nil;
        gDobj.moveInto(wallBehindBar);
        gDobj.isFixed = true;
        "The bartender hangs the photo back up on the wall. <q>Maybe one of the
        others?</q> he asks. ";
    }
;
++ GiveTopic @goodallPhoto
    "<q>Nah, you keep it,</q> he says. <q>Could be it'll even come in handy, if you ever
    run into a bunch of chimpanzees. They might even remember her.</q> He chuckles
    at his little joke. "
;
